---
title: The Press Release Comes First, Not After
impact: CRITICAL
tags: methodology, process, timing
---

## The Press Release Comes First, Not After

The PR/FAQ is a decision-making tool, not documentation. Writing it after you've already decided to build something defeats the entire purpose.

**Incorrect (PR as documentation):**

> **Scenario:**
>
> The team has been working on a new feature for three months. Engineering is 60% done. A new VP asks to see the PR/FAQ.
>
> PM: "Let me put one together."
>
> *Two days later, a PR/FAQ appears that describes what they're already building. The problem paragraph suspiciously matches the solution perfectly. The FAQ avoids any hard questions about technical risks that the team is already struggling with.*
>
> The VP approves it — what choice does she have? The work is already underway.

This isn't Working Backwards. It's justification theater.

**Correct (PR before building):**

> **Scenario:**
>
> A PM has an idea for a new feature. Before any engineering work begins, she writes a PR/FAQ.
>
> First draft: She realizes the problem paragraph is weak. Is this really a problem customers have?
>
> Second draft: After talking to 8 customers, she rewrites the problem paragraph. It's much sharper now.
>
> Review with team: "The solution sounds great, but the FAQ doesn't address how we'll handle the dependency on Team X. They're fully booked for 6 months."
>
> Third draft: She explores alternatives that don't require Team X. The solution changes significantly.
>
> Leadership review: The PR/FAQ is approved. Now engineering begins — with clarity on what, why, and the path forward.

**Why it matters:**

Bill Carr explains why the timing matters: "We created this process for new product innovation called the Working Backwards PR/FAQ process... the process of deciding what you should go build, and that's what the PR/FAQ is designed for. And then once you've decided that, then, yes, by all means, use all that good thinking... 'Now how can I ship it efficiently?'"

The document's power is in forcing hard thinking *before* committing resources. Afterward, it's just paperwork.
