/*
 * Hardware Configuration Pattern Example
 * 
 * Demonstrates board-agnostic hardware abstraction using compile-time
 * configuration. This pattern allows a single codebase to run on multiple
 * Arduino boards (UNO, ESP32, RP2040) with automatic pin mapping.
 * 
 * Generated by: arduino-code-generator
 * Pattern: Hardware Configuration
 * License: MIT
 */

// === Board Detection & Configuration ===
#if defined(ARDUINO_AVR_UNO)
  #define BOARD_NAME "Arduino UNO"
  #define LED_PIN 13
  #define BUTTON_PIN 2
  #define SERIAL_BAUD 9600
  #define HAS_WIFI false
#elif defined(ESP32)
  #define BOARD_NAME "ESP32"
  #define LED_PIN 2
  #define BUTTON_PIN 4
  #define SERIAL_BAUD 115200
  #define HAS_WIFI true
#elif defined(ARDUINO_ARCH_RP2040)
  #define BOARD_NAME "RP2040"
  #define LED_PIN LED_BUILTIN
  #define BUTTON_PIN 10
  #define SERIAL_BAUD 115200
  #define HAS_WIFI false
#else
  #error "Unsupported board - add configuration above"
#endif

// === Application Logic ===
void setup() {
  Serial.begin(SERIAL_BAUD);
  while (!Serial && millis() < 3000); // Wait for USB serial
  
  pinMode(LED_PIN, OUTPUT);
  pinMode(BUTTON_PIN, INPUT_PULLUP);
  
  Serial.println(F("\n=== Hardware Configuration Example ==="));
  Serial.print(F("Board: "));
  Serial.println(F(BOARD_NAME));
  Serial.print(F("LED Pin: "));
  Serial.println(LED_PIN);
  Serial.print(F("Button Pin: "));
  Serial.println(BUTTON_PIN);
  Serial.print(F("Baud Rate: "));
  Serial.println(SERIAL_BAUD);
  Serial.print(F("WiFi Available: "));
  Serial.println(HAS_WIFI ? F("Yes") : F("No"));
  Serial.println(F("\nPress button to toggle LED"));
}

void loop() {
  static bool lastButtonState = HIGH;
  static unsigned long lastDebounce = 0;
  const unsigned long DEBOUNCE_MS = 50;
  
  bool reading = digitalRead(BUTTON_PIN);
  
  // Simple debounce
  if (reading != lastButtonState) {
    lastDebounce = millis();
  }
  
  if ((millis() - lastDebounce) > DEBOUNCE_MS) {
    if (reading == LOW) {
      digitalWrite(LED_PIN, !digitalRead(LED_PIN));
      Serial.println(digitalRead(LED_PIN) ? F("LED ON") : F("LED OFF"));
      
      // Wait for release
      while (digitalRead(BUTTON_PIN) == LOW) {
        // Non-blocking wait
      }
    }
  }
  
  lastButtonState = reading;
}
