---
name: grammar
description: Use when users explicitly request grammar checking, spelling correction, proofreading, or style editing of ANY written content - sermons, sermonettes, devotionals, blogs, academic papers, or book chapters. Specializes in US English and theological writing styles.
---

# Grammar and Proofreading Skill

This skill provides comprehensive proofreading and editing for religious and theological writing, including sermons, devotionals, academic papers, and books.

## When to Use This Skill

Use this skill when the user requests:
- Grammar or spelling checking
- Proofreading of biblical or theological content
- Style improvements for clarity, conciseness, or tone
- Editing sermons, sermonettes, devotionals, or blogs
- Academic theological writing review
- Book chapter editing

## Core Capabilities

1. **Grammar and Spelling**: US English corrections, subject-verb agreement, pronoun usage, verb tense consistency
2. **Style Enhancement**: Clarity, conciseness, tone adjustment, flow improvement
3. **Specialized Formatting**: Biblical citations, theological terminology, proper capitalization
4. **Writing Type Adaptation**: Pastoral, academic, or creative devotional styles

## Workflow

### Step 1: Understand the Context

Ask the user (if not already specified):
- **Writing type**: sermon, sermonette, devotional, blog, academic paper, book chapter, or other
- **Desired tone**: pastoral (default), academic, creative, or mixed
- **Specific concerns**: grammar only, style improvements, comprehensive edit, or specific issues
- **Document length**: to set appropriate depth of review

### Step 2: Load Relevant Style References

Based on writing type, read the appropriate reference files:

**For pastoral sermons/sermonettes**:
- Read `references/pastoral-style.md` for tone, structure, and biblical integration guidance
- Read `references/us-grammar.md` for grammar and spelling rules

**For academic theological writing**:
- Read `references/academic-style.md` for formal tone, citation, and argumentation guidance
- Read `references/us-grammar.md` for grammar and spelling rules

**For creative devotionals/blogs**:
- Read `references/creative-style.md` for narrative, imagery, and voice guidance  
- Read `references/us-grammar.md` for grammar and spelling rules

**For mixed or unclear types**:
- Read `references/pastoral-style.md` as baseline
- Read `references/us-grammar.md` for grammar and spelling rules

### Step 3: Review and Edit

Perform comprehensive review focusing on:

**Grammar and Mechanics**
- Subject-verb agreement
- Pronoun consistency and clarity
- Verb tense consistency
- Sentence fragments and run-ons
- Punctuation (commas, semicolons, apostrophes, quotation marks)
- Spelling (US English conventions)

**Style and Clarity**
- Sentence variety and flow
- Active vs. passive voice
- Wordiness and redundancy
- Paragraph structure and transitions
- Tone consistency with intended audience

**Specialized Elements**
- Biblical citations (format: Book Chapter:Verse Translation)
- Theological terminology accuracy
- Capitalization of religious terms (follow loaded style guide)
- Scripture integration and quotation accuracy

**Writing-Type Specific**
- *Pastoral*: warm tone, practical application, clear structure, vivid illustrations
- *Academic*: formal tone, proper citations, logical argumentation, scholarly engagement
- *Creative*: authentic voice, imagery, narrative flow, emotional resonance

### Step 4: Present Corrections

Use one of two formats based on document length and user preference:

**Format 1: Tracked Changes (Recommended for shorter works <2000 words)**
- Present the full corrected text
- Use **[Editorial note in brackets]** to explain significant changes
- Summarize major patterns of errors at the end
- Highlight strengths of the writing

**Format 2: Categorized Feedback (For longer works >2000 words)**
- Provide summary of main issues by category (grammar, style, structure)
- Give specific examples with corrections
- Suggest broader patterns to address throughout
- Offer 2-3 overall recommendations
- If requested, provide corrected sample sections

### Step 5: Respond to Follow-up

Be prepared to:
- Clarify specific corrections
- Explain grammar rules or style choices
- Provide alternative phrasings
- Focus on specific sections
- Adjust tone or style based on feedback

## Key Principles

**Respect the Author's Voice**
- Preserve unique phrasing and style choices when possible
- Suggest rather than dictate style changes
- Distinguish between errors and stylistic preferences

**Context Matters**
- Sermons may use intentional fragments for emphasis
- Academic writing requires formal precision
- Devotionals allow creative flexibility
- Match correction level to writing type

**Biblical Accuracy**
- Verify Scripture quotations when possible
- Ensure citations are complete and accurate
- Respect theological nuance in terminology
- Flag potentially confusing or misleading phrasing

**US English Standards**
- Apply US spelling consistently (color, realize, theater)
- Use Oxford comma in series
- Follow US quotation mark conventions (periods inside quotes)
- Apply standard US capitalization for religious terms

## Common Issues to Watch For

**In Pastoral Writing**
- Overuse of Christian clichés
- Vague pronouns ("this," "that," "it" without clear antecedent)
- Inconsistent verb tense when discussing Scripture
- Missing or incorrect Scripture citations
- Overly complex sentences that obscure meaning

**In Academic Writing**
- Mixing informal and formal tone
- Incomplete or inconsistent citations
- Unsupported claims
- Unclear thesis or argument structure
- Colloquial language

**In Creative Devotional Writing**
- Forced or mixed metaphors
- Preachy or guilt-manipulative tone
- Spiritual platitudes without depth
- Unclear connection between story and spiritual insight
- Inconsistent narrative voice

## Examples

**Example 1: Pastoral Sermon Correction**

*Original*: "God is calling we to a deeper faith, its not about religion but relationship."

*Corrected*: "God is calling us to a deeper faith. It's not about religion but about relationship."

*Explanation*: Corrected pronoun case (we→us), added apostrophe (its→it's), split run-on sentence, added clarity ("about relationship").

**Example 2: Academic Style Enhancement**

*Original*: "Paul basically says that we should love each other in Romans 12."

*Corrected*: "Paul exhorts believers to express genuine love for one another (Rom. 12:9-10)."

*Explanation*: Removed informal "basically," used precise theological language, added specific verse citation, replaced vague "says" with "exhorts."

**Example 3: Creative Devotional Refinement**

*Original*: "I learned that God is always there for us no matter what happens in life."

*Corrected*: "I'm learning that even in the darkest moments—when the diagnosis comes, when the relationship fractures, when hope feels distant—God's presence remains steady, unshaken by the storms that shake me."

*Explanation*: Replaced cliché with specific examples, added concrete imagery, maintained authentic voice, created rhythm through parallel structure.

## Tips for Best Results

- Provide context about the intended audience
- Specify if maintaining the author's voice is priority
- Indicate any time constraints (light edit vs. comprehensive revision)
- Flag any sections with particular concerns
- Share if this is a first draft or near-final version
