# Pastoral Writing Style Guide

## Tone and Voice

**Warmth and Accessibility**
- Use inclusive language ("we," "us," "our") to create community
- Balance authority with approachability
- Avoid overly academic or distant tone
- Write as if speaking directly to the congregation

**Pastoral Authority**
- Speak with confidence when teaching Scripture
- Balance grace and truth
- Be direct but compassionate when addressing difficult topics
- Use "I" statements when sharing personal applications

## Structure and Clarity

**Sermon and Sermonette Structure**
- Clear introduction that hooks attention
- Logical progression of points
- Smooth transitions between sections
- Strong, memorable conclusion with application
- Each main point should stand on its own

**Paragraph Construction**
- One main idea per paragraph
- Start with topic sentences
- Use transitions: "Furthermore," "However," "In the same way," "This means that"
- Vary paragraph length for rhythm (avoid all short or all long)

## Biblical References

**Scripture Citations**
- Always cite book, chapter, and verse (e.g., "John 3:16" not "the Gospel")
- Use standard abbreviations consistently
- For multiple verses: "vv. 12-15" or "verses 12-15"
- Translation references in parentheses: (ESV, NIV, NKJV)

**Scripture Integration**
- Weave Scripture naturally into the text
- Quote accurately
- Provide context when needed
- Avoid proof-texting (using verses out of context)

## Language Choices

**Biblical Terminology**
- Use theological terms appropriately but explain when necessary
- Balance scholarly accuracy with congregational understanding
- Define technical terms on first use
- Consider your audience's biblical literacy

**Vivid Language**
- Use concrete examples and illustrations
- Employ metaphors and analogies
- Paint word pictures
- Use sensory details when appropriate

**Avoid**
- Clichés and overused phrases
- Jargon without explanation
- Unnecessarily complex sentence structures
- Passive voice when active is clearer
- Vague pronouns (clarify "this," "that," "it")

## Application and Relevance

**Practical Application**
- Move from exposition to application clearly
- Use contemporary examples
- Address real-life situations
- Provide specific, actionable steps

**Illustrations**
- Use stories that connect with your audience
- Draw from history, literature, daily life, and personal experience
- Ensure illustrations serve the text, not overshadow it
- Keep illustrations concise and relevant

## Common Pastoral Writing Patterns

**Teaching Points**
- "First... Second... Third..." for sequential points
- "Not only... but also..." for building emphasis
- "While... we must also..." for balance
- "Because... therefore..." for logical flow

**Rhetorical Questions**
- Use sparingly for engagement
- Follow with answers or reflection
- Avoid strings of unanswered questions

**Repetition for Emphasis**
- Repeat key phrases for memorability
- Use parallel structure
- Build momentum through repetition
- Balance repetition with variety
