# US English Grammar and Spelling Reference

## Common US vs. UK Spelling Differences

**-or vs. -our**
- US: color, favor, honor, labor, neighbor
- UK: colour, favour, honour, labour, neighbour

**-er vs. -re**
- US: center, fiber, meter, theater
- UK: centre, fibre, metre, theatre

**-ize vs. -ise**
- US: realize, organize, recognize, emphasize
- UK: realise, organise, recognise, emphasise

**-yze vs. -yse**
- US: analyze, paralyze
- UK: analyse, paralyse

**-og vs. -ogue**
- US: analog, catalog, dialog
- UK: analogue, catalogue, dialogue

**Double Consonants**
- US: traveling, canceled, labeled
- UK: travelling, cancelled, labelled

**Other Common Differences**
- US: gray, check, defense, license (noun), practice (noun), judgment
- UK: grey, cheque, defence, licence (noun), practise (noun), judgement

## Common Grammar Issues

**Subject-Verb Agreement**
- Singular subjects take singular verbs: "The sermon is ready"
- Plural subjects take plural verbs: "The sermons are ready"
- Collective nouns (US): typically singular ("The church believes")
- Compound subjects with "and": plural ("Faith and hope are essential")
- Compound subjects with "or/nor": verb agrees with nearest subject

**Pronoun Agreement**
- Pronouns must agree with antecedent in number
- Indefinite pronouns: singular (everyone, someone, each, either, neither)
  - "Everyone should bring his or her Bible" or "their Bible" (increasingly accepted)
- Plural indefinite pronouns: both, few, many, several

**Pronoun Case**
- Subject pronouns: I, you, he, she, it, we, they
- Object pronouns: me, you, him, her, it, us, them
- Possessive pronouns: my/mine, your/yours, his, her/hers, its, our/ours, their/theirs
- Who vs. whom: "who" for subjects, "whom" for objects

**Verb Tense Consistency**
- Maintain consistent tense within paragraphs/sections
- Use present tense for biblical narrative analysis: "Jesus teaches..."
- Use past tense for historical events: "Paul wrote to the Corinthians..."
- Shift tenses deliberately for clarity, not accidentally

**Commonly Confused Words**

*Affect vs. Effect*
- Affect (verb): to influence ("The sermon affected me deeply")
- Effect (noun): a result ("The effect was powerful")
- Effect (verb, less common): to bring about ("to effect change")

*Its vs. It's*
- Its: possessive ("The church and its mission")
- It's: contraction of "it is" or "it has"

*Your vs. You're*
- Your: possessive ("your faith")
- You're: contraction of "you are"

*Their vs. There vs. They're*
- Their: possessive ("their prayers")
- There: location or existential ("There is hope")
- They're: contraction of "they are"

*Than vs. Then*
- Than: comparison ("Greater love has no one than this")
- Then: time or consequence ("First believe, then obey")

*Who's vs. Whose*
- Who's: contraction of "who is" or "who has"
- Whose: possessive ("Whose faith inspired you?")

*Principle vs. Principal*
- Principle: fundamental truth or belief ("biblical principles")
- Principal: main/primary or school leader ("the principal theme")

*Complement vs. Compliment*
- Complement: something that completes ("Grace complements mercy")
- Compliment: praise ("He complimented the sermon")

*Further vs. Farther*
- Further: metaphorical distance ("further understanding")
- Farther: physical distance ("farther down the road")

## Punctuation

**Commas**
- Series (Oxford comma in US): "faith, hope, and love"
- After introductory elements: "In the beginning, God created"
- Around non-essential clauses: "Paul, who was a Pharisee, wrote"
- Between independent clauses with coordinating conjunction: "I prayed, and God answered"

**Semicolons**
- Between independent clauses without conjunction: "Faith believes; love acts"
- In complex series: "Speakers included Dr. Smith, theologian; Rev. Jones, pastor; and Prof. Brown, historian"

**Colons**
- Introducing lists: "Three virtues remain: faith, hope, and love"
- Introducing explanation: "The message was clear: repent and believe"
- After complete sentence before related content

**Apostrophes**
- Possessive singular: "Jesus's teaching" or "Jesus' teaching" (both acceptable)
- Possessive plural: "the disciples' faith"
- Contractions: "don't," "can't," "won't"
- NOT for plurals: "1990s" not "1990's"

**Quotation Marks**
- US style: periods and commas inside ("He said, "Believe.")
- Colons and semicolons outside ("He mentioned 'faith'; then he left")
- Question marks and exclamation points: depends on whether they're part of quote
- Scripture quotes: use quotation marks for direct speech

**Hyphens and Dashes**
- Hyphen (-): compound modifiers ("first-century church"), prefixes with proper nouns ("pre-Christian")
- En dash (–): ranges ("Matthew 5–7"), connections ("East–West dialogue")
- Em dash (—): breaks in thought—like this—or emphasis

## Capitalization

**Biblical Terms**
- Pronouns for God: varied practice (He/he, His/his)—choose consistently
- "Bible," "Scripture(s)," "Word of God" when referring to sacred text
- Lowercase: biblical, scriptural
- Books of Bible: capitalized ("Genesis," "Romans")
- Lowercase generic references: "gospel message" but "the Gospel of John"

**Religious Terms**
- Capitalize specific names: "Christianity," "Christian," "Judaism," "Muslim"
- Lowercase general concepts: "the church" (universal) but "First Baptist Church" (specific)
- "The Lord," "the Savior" (specific references to God)
- Lowercase: "kingdom of God," "the fall," "original sin"

**Titles**
- Capitalize before names: "Pastor Smith," "Dr. Jones," "Reverend Brown"
- Lowercase after names: "John Smith, pastor of..."
- Capitalize in direct address: "Yes, Pastor"

## Sentence Structure

**Fragments**
- Generally avoid in formal writing
- Acceptable in sermons for emphasis: "But here's the truth. God is faithful."
- Ensure intentional, not accidental

**Run-ons**
- Avoid comma splices: NOT "God is love, he never fails"
- Fix with: period, semicolon, or conjunction with comma

**Parallel Structure**
- Items in series should be grammatically parallel
- "to pray, to read, and to worship" NOT "praying, to read, and worship"

**Active vs. Passive Voice**
- Prefer active: "God loves us" not "We are loved by God"
- Passive acceptable when actor unknown/unimportant or for variety
- Divine passive in Bible: "It is written" (implied: by God)

## Style Consistency

**Numbers**
- Spell out one through nine; use numerals for 10+
- Spell out numbers at sentence beginning
- Bible references: always numerals (John 3:16)
- Centuries: spell out ("twenty-first century")
- Percentages: use numerals with % (15%)

**Abbreviations**
- Bible translations: (NIV), (ESV), (NKJV)
- Avoid in formal writing except established terms
- Books of Bible: spell out in text, abbreviate in citations
- Latin abbreviations: e.g., i.e., etc. (use sparingly in formal writing)

**Lists and Bullets**
- Parallel structure throughout
- Consistent punctuation (all complete sentences or all fragments)
- Capitalize first word consistently
- End punctuation consistent
