---
name: sermon-writer
description: You MUST use this when users ask you to write, create, or generate sermon content - sermons, sermonettes, or split sermons for United Church of God worship services. Use when writing biblical teaching material or spiritually formative messages (1,400-4,000 words).
---

# Sermon Writer

This skill generates sermons, sermonettes, and split sermons that meet specific theological, pedagogical, and pastoral standards for biblical teaching within United Church of God worship services.

## Message Type Decision Tree

Determine which type of message to write based on the user's request:

**SERMONETTE** (1,500 words ± 100)
- **When**: User requests "sermonette" or context indicates a shorter message
- **Word count**: 1,400-1,600 words
- **Context**: Typically delivered before the main sermon, often before an offering
- **Structure**: Opening hook (100-200) → Exposition (600-800) → Application (400-600) → Conclusion (100-200)
- **Scope**: Single focused insight or theme

**SPLIT SERMON** (2,500 words ± 100)
- **When**: User requests "split sermon" or indicates two speakers sharing teaching
- **Word count**: 2,400-2,600 words per part (two speakers)
- **Context**: Two speakers with roughly equal-length messages forming one cohesive teaching
- **Structure**: Opening hook (150-250) → Exposition (1,200-1,500) → Application (800-1,000) → Conclusion (150-250)
- **Scope**: Can explore 2-3 related themes with moderate depth
- **Special consideration**: If writing both parts, ensure thematic unity and smooth transition between speakers

**SERMON** (3,500-4,000 words)
- **When**: User requests "sermon" or context indicates a full-length main message
- **Word count**: 3,500-4,000 words
- **Context**: Main teaching of the worship service
- **Structure**: Opening hook (200-400) → Exposition (1,800-2,200) → Application (1,200-1,400) → Conclusion (300-400)
- **Scope**: Can explore multiple related themes with significant depth

## Target Specifications (All Types)

- **Theological tradition**: United Church of God (Sabbatarian, non-Trinitarian, Torah-observant)
- **Audience**: Mature believers familiar with Scripture and theological concepts
- **Purpose**: Teaching, application, spiritual formation through biblical exposition
- **Tone**: Conversational yet substantive, intellectually rigorous yet pastorally warm

## Core Writing Approach

### Theological Foundation

Start with careful biblical exegesis:
- Ground every major point in specific Scripture passages
- Use original language insights (Hebrew/Greek) when they illuminate meaning without being pedantic
- Connect passages across the biblical narrative to show theological coherence
- Distinguish between what the text explicitly says and reasonable implications
- Present theological complexity honestly while maintaining clarity

### Structural Pattern (Adapt to Message Length)

The basic architecture scales based on message type. Word counts below are for SERMONETTES; scale proportionally for split sermons and full sermons.

1. **Opening Hook**
   - Sermonette: 100-200 words | Split Sermon: 150-250 words | Sermon: 200-400 words
   - Begin with a specific biblical text or narrative detail
   - Present an intriguing question, paradox, or overlooked detail
   - Establish why this matters beyond academic interest

2. **Exposition**
   - Sermonette: 600-800 words | Split Sermon: 1,200-1,500 words | Sermon: 1,800-2,200 words
   - Unpack the biblical text carefully, often moving chronologically through a narrative or logically through a concept
   - Use multiple related passages to build a comprehensive understanding
   - Include cultural/historical context when it illuminates the text
   - Explore tensions, contrasts, or surprising elements in the Scripture
   - Use subheadings to create clear sections (sermonette: 3-5 sections; split sermon: 4-6; sermon: 5-8)
   - For longer messages, can explore multiple related themes or go deeper into a single theme

3. **Application**
   - Sermonette: 400-600 words | Split Sermon: 800-1,000 words | Sermon: 1,200-1,400 words
   - Connect biblical truth to contemporary experience authentically
   - Ask penetrating questions that invite self-examination
   - Address real struggles without offering simplistic solutions
   - Acknowledge complexity and human weakness
   - Present realistic hope grounded in God's character
   - For longer messages, can include multiple application angles or more detailed practical steps

4. **Conclusion**
   - Sermonette: 100-200 words | Split Sermon: 150-250 words | Sermon: 300-400 words
   - Circle back to the opening question or theme
   - Summarize the key trajectory or principle
   - End with a memorable question or call to reflection
   - Avoid neat resolution—leave space for the Spirit's work

### Voice and Tone

Maintain a conversational yet substantive voice:
- Use "we" and "us" to include the speaker in the challenges presented
- Ask genuine questions rather than using rhetorical devices
- Employ vivid but not flowery language
- Balance intellectual rigor with pastoral warmth
- Avoid clichés, religious jargon, and overly sentimental language
- Write in active voice with varied sentence structure

### Illustrative Techniques

Use these methods to make abstract truth concrete:

**Biblical contrasts**: Place biblical characters or situations in comparison (Aaron vs. Joseph's brothers; Eden vs. New Jerusalem)

**Cultural reversal**: Highlight how biblical commands challenge contemporary or ancient cultural norms

**Linguistic insight**: When Hebrew/Greek illuminates meaning, present it accessibly: "The Hebrew word *samach* literally means 'to brighten up'—visible, radiant gladness"

**Real-life connection**: Link biblical principles to recognizable modern struggles without forced relevance

**Historical context**: Provide ancient Near Eastern background when it clarifies the text's radical nature

### Common Pitfalls to Avoid

- **Forced application**: Don't manufacture contemporary relevance—let it emerge naturally from the text
- **Moralizing**: Avoid reducing Scripture to behavior modification; emphasize God's character and grace, especially God working through us from the inside out.
- **Proof-texting**: Build arguments from careful exegesis, not isolated verses
- **Sentimentality**: Maintain emotional authenticity without manipulation
- **Exhaustive coverage**: Better to explore one angle deeply than cover everything superficially
- **Neat endings**: Real spiritual formation is messy; honor that complexity

## Liturgical Context Integration

### Feast Day Connections

When writing for specific Holy Days:
- Connect physical observances to spiritual meanings explicitly
- Explore how commands for ancient Israel foreshadow New Covenant realities
- Address the "why this matters now" question directly
- Link feast meanings to God's broader redemptive plan

### Offering Contexts

When sermonettes precede offerings:
- Establish theological foundation for giving before the practical ask
- Connect the offering to the broader biblical theme being explored
- Frame generosity as response to God's character and abundance
- Avoid guilt-based appeals; emphasize joyful participation

## Quality Benchmarks

Evaluate against these four dimensions:

### 1. Theological Depth
- Does it faithfully interpret Scripture in context?
- Are theological themes clearly articulated and connected across the biblical narrative?
- Does it handle difficult passages honestly without oversimplifying?
- Is the doctrine sound within conservative evangelical orthodoxy?

### 2. Teaching Clarity
- Is the progression of ideas logical and easy to follow?
- Do illustrations clarify rather than distract?
- Are transitions smooth and natural?
- Will listeners remember the main point a week later?

### 3. Emotional & Spiritual Engagement
- Does it speak to both mind and heart?
- Are there moments that invite genuine conviction or comfort?
- Does it create space for the Holy Spirit's work?
- Will it resonate with various spiritual temperaments?

### 4. Resonance & Relevance
- Does it address real questions mature believers wrestle with?
- Is the application grounded in actual human experience?
- Does it avoid both irrelevance and forced contemporaneity?
- Will it speak across different life stages and circumstances?

## Example Patterns from Reference Sermonettes

**Pattern 1: Character Study with Cultural Context**
- Focus: Aaron's glad heart despite cultural expectations
- Structure: Narrative exposition → contrasting example (Joseph's brothers) → honest treatment of failures → realistic application
- Key technique: Acknowledge spectacular failures while showing how heart posture shapes trajectory

**Pattern 2: Biblical Theology Arc**
- Focus: Creation → Renewal → New Creation
- Structure: Genesis foundation → prophetic promise → Revelation fulfillment → presence of God as throughline
- Key technique: Show how God's plan has been consistent from beginning to consummation

**Pattern 3: Command Exploration**
- Focus: Rejoicing at the Feast of Tabernacles
- Structure: Physical command → spiritual meaning → test of heart → application through questions
- Key technique: Move from letter to spirit of the law while honoring both

**Pattern 4: Word Study with Application**
- Focus: Biblical concept of "honor"
- Structure: Survey of honor commands → Hebrew/Greek word analysis → God's example → challenge of familiarity
- Key technique: Use linguistic depth to reveal what common words truly mean

**Pattern 5: Foreshadowing and Fulfillment**
- Focus: Gleaning commands and the Great Commission
- Structure: Physical command in Leviticus → spiritual meaning → church application → warning against misuse
- Key technique: Show how Old Testament commands anticipate New Testament realities

## Process

1. **Determine message type**: Identify if this is a sermonette, split sermon, or full sermon based on user request
2. **Choose the focal text**: Select a specific passage, verse, or biblical concept
3. **Exegete thoroughly**: Study the passage in context with commentaries and cross-references
4. **Identify the main insight**: What's the one thing this text reveals that people might miss?
5. **Plan the structure**: Outline the logical flow using the structural pattern above, scaled to the appropriate length
6. **Write the body first**: Develop the exposition before crafting the introduction
7. **Create the hook**: Write an opening that makes the main insight intriguing
8. **Develop application organically**: Let contemporary relevance emerge from the biblical truth
9. **Craft the conclusion**: Return to the opening theme with deeper understanding
10. **Check word count**: Verify it matches the target range for the message type
11. **Review against quality benchmarks**: Evaluate all four dimensions (see Quality Benchmarks section)
12. **Check theological framework**: If uncertain about any doctrinal point, consult references/theological-framework.md

## When Multiple Themes Emerge

If the biblical text reveals multiple rich themes:
- Choose the one most relevant to the liturgical context or congregation's needs
- Mention other themes briefly but resist the temptation to explore everything
- Save additional insights for future sermonettes
- Better to go deep on one theme than shallow on many

## Final Polish

Before completion:
- Read aloud to check for natural flow and speech rhythm
- Verify all Scripture references are accurate
- Ensure theological statements align with UCG doctrine (see references/theological-framework.md)
- Confirm the main point is crystal clear
- Check that application is both specific and humble
- Verify word count matches the target range:
  - Sermonette: 1,400-1,600 words
  - Split Sermon: 2,400-2,600 words
  - Sermon: 3,500-4,000 words

## Split Sermon Special Considerations

When writing split sermons (whether one or both parts):

**If writing both parts:**
- Ensure thematic unity across both messages
- Part 1 should set up questions/tensions that Part 2 resolves or expands
- Avoid redundancy—don't repeat the same points
- Consider having Part 1 focus on biblical foundation and Part 2 focus on application
- Or Part 1 could cover one aspect of a topic and Part 2 another complementary aspect
- End Part 1 with anticipation for Part 2
- Begin Part 2 with brief connection to Part 1

**If writing only one part:**
- Ask user for the other speaker's focus/theme to ensure complementarity
- Your part must stand alone but also contribute to a larger whole
- Leave room for the other speaker to develop their angle

## Using Reference Files

This skill includes reference files that provide essential context. Consult them as needed:

**Always consult:**
- `references/theological-framework.md` - UCG doctrinal positions and pastoral tone requirements (read when uncertain about theology)

**Consult when relevant:**
- `references/example-sermonettes.md` - Five example sermonettes showing style and structure (read to match voice and approach)
- `references/liturgical-overview.md` - Overview of the annual Holy Day cycle (read when writing for a specific Holy Day)
- `references/holy-days/[feast-name].md` - Detailed guidance for specific Holy Days (read when writing for that feast)
- `references/evaluation-rubric.md` - Detailed evaluation criteria (read when reviewing completed work)
- `references/topics/[topic-name].md` - Collected resources on specific topics like faith, love, etc. (read when available for the requested topic)

The references directory will grow over time as more Holy Day guides and topic resources are added.
