# Example Sermonettes

This file contains five example sermonettes that demonstrate the style, structure, and approach expected from this skill. Read these examples when writing to match the voice, theological depth, and application style.

## Example 1: The Glad Heart of a Servant (Aaron's Support of Moses)

**Pattern**: Character Study with Cultural Context  
**Key Text**: Exodus 4:14  
**Word Count**: ~1550 words

We all know the story of the Burning Bush. Moses sees this bush burning in the distance but not being consumed. Then God tells Moses the mission God will send Moses on, but Moses goes several rounds with God making excuses for why God should not send Moses. Finally Moses relents after God tells Moses that his brother Aaron will help him, be Moses' spokesman.

It is a story we all know well but there's something remarkable hidden in the middle of Moses's objections at the burning bush. After Moses has given every excuse imaginable for why he cannot lead Israel out of Egypt, God's anger is kindled because Moses says that he is not eloquent. I find this excuse pretty humorous because here Moses is arguing with God so can can see how eloquent or not he is. But notice what God says in His final reply to Moses: "Is not Aaron the Levite your brother? I know that he can speak well. And look, he is also coming out to meet you. When he sees you, he will be glad in his heart."

That phrase - "he will be glad in his heart" - contains a profound truth about character, humility, and what it means to serve God's purposes rather than our own ambitions.

The Hebrew word for "glad" here is *samach* - which literally means "to brighten up." This isn't quiet resignation or dutiful acceptance. God is saying that when Aaron sees his younger brother, the one choses for leadership, his face will light up with joy. It will be visible, radiant gladness - the kind that comes from deep within and cannot be hidden. Aaron's heart would be so full of genuine joy that it would shine on his countenance.

Now maybe Aaron was glad to see his brother after 40 years but you could imagine the conversation when Moses tells Aaron, his older brother, that Aaron will be the spokesman for his younger brother who skipped town but now is chosen to lead the children of Israel.

### The Cultural Reversal

By every human standard, Aaron should have been the leader. He was the older brother by three years (Exodus 7:7). In the ancient Near Eastern world, this mattered enormously. The firstborn received the birthright, the blessing, the position of leadership. Moreover, Aaron had been in Egypt the whole time, living among the people who needed to be led, while Moses had fled to Midian for forty years. Aaron had the eloquence Moses said he lacked. Yet God chose Moses.

Here's where we see something extraordinary. God doesn't say Aaron will be disappointed or need time to process this. He says definitively: "When he sees you, he will be glad in his heart." Not glad in appearance only, but genuinely joyful. This is rare precisely because it defies human nature.

### The Contrast: Joseph's Brothers

Joseph's brothers couldn't bear the thought of their younger brother having authority over them. When Joseph shared his dreams, "they hated him even more" and "envied him" (Genesis 37:8, 11). Their hatred led them to sell Joseph into slavery and tear their family apart for years.

Joseph's brothers eventually repented. By the end of Genesis, they genuinely supported Joseph in his God-given position. But the difference is stark: they began with hatred and had to journey through terrible sin toward repentance. Aaron's response - however and whenever he learned of Moses's calling - was gladness. Different starting points led to different trajectories.

### What We Don't Know - And What We Do

Here's what's remarkable: We don't actually know WHY Aaron was glad. The text doesn't tell us his motivations or thought process. We can't psychoanalyze Aaron from forty centuries away. What we DO know is that God knew Aaron's heart beforehand, and God knew it would produce gladness rather than jealousy.

And we know the fruit. We can trace forty years of partnership. Aaron never led a faction against Moses. He never tried to position himself as the alternative leader. Even when Aaron failed catastrophically, his failures were not rooted in jealous rivalry over Moses's position.

### The Catastrophic Failures

Before we romanticize Aaron's story, we must confront his spectacular failures. While Moses was on Mount Sinai receiving the Ten Commandments, the people demanded that Aaron make them gods. Aaron should have stood firm. Instead, he caved. He collected their gold and fashioned a golden calf, declaring "These are your gods, O Israel!" (Exodus 32:4). God's anger burned so hot He wanted to destroy Israel. Three thousand people died that day. When confronted, Aaron made excuses, blaming the people for what he had done.

In Numbers 12, Aaron and Miriam challenged Moses's authority. God rebuked them and struck Miriam with leprosy. Then in Numbers 20, both Aaron and Moses failed at Meribah, and both were barred from entering the Promised Land. Aaron died in the wilderness, never seeing the fulfillment of the journey.

Yet notice: After the golden calf, Aaron didn't abandon Moses or try to seize power. After Numbers 12, they continued to lead together. For thirty-eight more years after the golden calf disaster, Aaron served alongside Moses. The partnership endured.

### The Legacy - Complex but Enduring

Aaron became the first High Priest of Israel - a sacred calling. But even this came with cost. His first two sons, Nadab and Abihu, were consumed by fire for offering unauthorized fire before the Lord (Leviticus 10:1-2). The Aaronic priesthood served for over a thousand years - all the way to the time of Christ when Zechariah served in Aaron's line (Luke 1:5). Scripture speaks of it as a "perpetual priesthood" (Exodus 40:15), though Hebrews reveals Christ as the ultimate High Priest who fulfills what Aaron's priesthood pointed toward.

Both Moses and Aaron were essential. Both were honored. Both failed catastrophically. Both died short of the Promised Land. Yet both accomplished their God-given missions and left lasting legacies.

### The Application

Aaron's glad heart didn't make him immune to catastrophic failure. It didn't prevent idolatry, rebellion, or dying in the wilderness. So what DID it do?

It set a trajectory. Not a guarantee, but a trajectory that could endure through failure. When Aaron failed spectacularly, his failures were not rooted in jealous rivalry. He didn't use mistakes as opportunities to grab Moses's position. The glad heart didn't prevent failure, but it created a foundation strong enough to endure through failure.

Here's the hard question: When we fail - and we will - what kind of failure will it be? Will it be failure rooted in trying to undermine or replace those God has called? Or failure from someone who, despite weakness, remains fundamentally committed to supporting God's purposes?

God isn't asking for perfection. Moses, Aaron, and David all failed terribly. But God is asking us to examine our hearts: When someone younger, less experienced, or seemingly less qualified is chosen, will our first response be gladness or bitterness?

That initial heart posture matters. Not because it prevents all future sin, but because it sets a trajectory that can endure even through our worst moments. Joseph's brothers eventually repented, but think of the decades of pain that began with hatred instead of gladness.

Aaron's story is not a fairy tale where gladness leads to unbroken success. It's the realistic story of a flawed man whose glad heart created something resilient enough to survive his worst failures and still accomplish God's purposes.

### Conclusion

God knew Aaron's heart before He spoke to Moses at the burning bush. He knew Aaron would be glad, He knew that this older brother would be happy to be a servant to his younger brother to accomplish the purpose that God had placed before both of them. God knew that Aaron's glad heart would create a foundation strong enough to endure through all of it.

Here was the older brother serving the younger - a complete cultural reversal. That gladness became the foundation for one of the most fruitful partnerships in biblical history. The partnership endured through catastrophic mistakes because it was built on gladness rather than jealousy, support rather than rivalry.

This is the realistic hope Aaron offers us: Not that a glad heart will prevent failure, but that it creates a foundation that can endure through failure. Not that supporting others guarantees perfect outcomes, but that it sets a trajectory toward fruitfulness that jealousy can never produce.

May we have hearts that are glad when God works through others - knowing our gladness won't make us perfect, but trusting it sets us on a better path than bitterness ever could. And may we discover that there is lasting legacy in faithful service despite human weakness - even when it means the older serves the younger, even when we never see the Promised Land in this life, even when we make catastrophic mistakes along the way.

The measure of spiritual maturity isn't found in perfection or positions we hold. It's found in the trajectory we choose when God calls someone else instead of us. That's the lesson of Aaron - the older brother whose heart God knew would be glad, who served the younger brother God chose to lead, who failed spectacularly along the way, yet whose partnership and priesthood endured and left a legacy that outlasted his failures.

Will you be glad in your heart?

---

## Example 2: From Garden to City (Creation, Renewal, and New Creation)

**Pattern**: Biblical Theology Arc  
**Word Count**: ~1450 words

There is a story woven throughout Scripture that begins in a garden and ends in a city—a single, magnificent arc that reveals the heart of God and the destiny of His people. From the first pages of Genesis to the final chapters of Revelation, we trace a divine plan that has never wavered, never failed, and will never be abandoned. It is the story of Creation, Renewal, and New Creation—and at its center stands the unwavering faithfulness of our God.

### The Beginning: Paradise and Presence

In the beginning, God created the heavens and the earth (Gen. 1:1). Genesis 1 reveals a God who speaks light into darkness, order into chaos, and life into the void. Each day of creation builds upon the last, culminating in the crowning achievement: humanity, made in the image of God Himself. Adam and Eve are placed in Eden, a garden of perfect provision and peace, where they walk with God in the cool of the day.

Eden presents the picture of paradise. There is no death, no sorrow, no pain. The lion and the lamb dwell together. Food comes from trees that produce abundantly. Work is meaningful, not toilsome. And most importantly, God is present—walking among His people, enjoying fellowship with them, delighting in what He has made.

Genesis 2 emphasizes this intimacy. God forms Adam with His own hands. He plants a garden specifically for humanity. He brings the animals to Adam to name, involving him in the creative process. He fashions Eve as a companion, declaring that it is not good for man to be alone. Every detail reveals a God who desires relationship, who creates not out of loneliness but out of love, who rejoices in the presence of His image-bearers.

But then comes Genesis 3. The serpent's whisper. The forbidden fruit. The catastrophic choice to doubt God's goodness and grasp for autonomy. Sin enters the world, and with it comes death, shame, separation, and suffering. The fellowship is broken. Adam and Eve hide from God among the trees. They are expelled from the garden, barred from the tree of life, sentenced to mortality and pain.

Yet even in the midst of judgment, we see the first glimmer of hope. God promises that the seed of the woman will crush the serpent's head (Gen. 3:15). God clothes Adam and Eve with garments of skin, covering their shame. Though the relationship is damaged, the story is not ended.

### The Promise: Restoration and Rejoicing

Centuries pass. Humanity multiplies in sin and misery. Yet God does not forget His promise. Through prophets and kings, through covenants and commandments, God prepares the way for restoration. And in Isaiah 65:17, we encounter one of the most stunning prophetic visions in all of Scripture.

"Behold, I create new heavens and a new earth," God declares. "The former things shall not be remembered or come to mind. But be glad and rejoice forever in that which I create; for behold, I create Jerusalem to be a joy, and her people to be a gladness" (Isa. 65:17-18).

Notice the language here. God is not merely repairing the old creation; He is making something new. Yet this newness echoes Eden. In Isaiah's vision, there is an end to weeping and the sound of crying. Infant mortality ceases. Life is extended—those who die at a hundred will be considered young. People build houses and inhabit them; they plant vineyards and eat their fruit. The labor of their hands is not in vain.

Even more remarkably, the enmity between creatures is reversed: "The wolf and the lamb shall graze together; the lion shall eat straw like the ox" (Isa. 65:25). The curse begins to lift. Death loses its sting. Suffering retreats.

But what stands out most powerfully is God's delight. "I will rejoice in Jerusalem and be glad in my people," God proclaims (Isa. 65:19). This is not a distant deity observing from heaven. This is a God who celebrates, who exults, who finds joy in His redeemed people. The relationship that was fractured in Genesis 3 is being restored, and God Himself is rejoicing over the prospect.

Isaiah's prophecy is forward-looking, a promise yet to be fulfilled. It sustains God's people through exile, oppression, and waiting. It assures them that what was lost in the garden will be restored—and more. The arc of redemption is bending toward joy. And that joy finds its full expression in the final vision of Revelation.

### The Fulfillment: New Creation and Eternal Dwelling

Then comes Revelation 21, the culmination of everything God has been doing since Genesis 3. John sees a new heaven and a new earth, for the first heaven and earth have passed away. And he sees the holy city, the New Jerusalem, coming down out of heaven from God, prepared as a bride adorned for her husband (Rev. 21:1-2).

And then John hears a loud voice from the throne: "Behold, the dwelling place of God is with man. He will dwell with them, and they will be his people, and God himself will be with them as their God" (Rev. 21:3).

This is the fulfillment of every promise. God is not simply visiting His people, as He did in Eden. He is not merely rejoicing over them, as He promised in Isaiah. He is dwelling with them—permanently, eternally, inseparably. The intimacy of the garden is restored and surpassed. The presence that was lost is not only recovered but magnified beyond measure.

"He will wipe away every tear from their eyes, and death shall be no more, neither shall there be mourning, nor crying, nor pain anymore, for the former things have passed away" (Rev. 21:4). Every consequence of Genesis 3 is reversed. Every sorrow is healed. Every injustice is answered. Every longing is satisfied.

And notice: there is no temple in the New Jerusalem, for the Lord God Almighty and the Lamb are its temple. There is no need for sun or moon, for the glory of God gives it light. The nations walk by its light, and the kings of the earth bring their glory into it. The tree of life—barred to humanity in Genesis 3—is now accessible again, its leaves for the healing of the nations.

### The Heart of the Story: God With Us

What ties these three moments together—Genesis, Isaiah, and Revelation—is the presence of God Himself. In each stage, we see God drawing near to His people, delighting in them, longing for relationship with them.

In Genesis, God walks with Adam and Eve in the garden. The relationship is direct, unmediated, intimate. God enjoys His creation and the fellowship it provides.

In Isaiah, God promises to rejoice over His people. Even before the restoration is complete, God expresses His eagerness, His anticipation, His delight in what is to come. He is not a reluctant savior but an exuberant one.

In Revelation, God dwells eternally with His people. The separation is ended forever. The longing of Eden is fulfilled in the New Jerusalem. God does not merely visit; He stays. He does not merely observe; He participates. He wipes away tears with His own hand.

This is the progression of redemption: from walking to rejoicing to dwelling. And it reveals something profound about the nature of salvation. God is not simply fixing a problem or restoring a system. He is reclaiming a relationship. He is pursuing His beloved. He is bringing His children home.

### The Faithfulness of God

What God began in Genesis, He will complete in Revelation. His plan has never changed. His purpose has never faltered. Through sin and death, through exile and suffering, through Christ's sacrifice and the empty tomb, God has been faithful. He promised restoration, and He will deliver it. He promised presence, and He will provide it. He promised joy, and He will fulfill it.

We live in the tension between promise and fulfillment. The prophecies of Isaiah and Revelation stand before us as sure hope, yet we still await their final completion. Though we face the pain of Genesis 3, we trust the God of Revelation 21—the One who will wipe away every tear and make all things new.

And even now, through Christ, we taste the first fruits of that coming joy. God dwells with us by His Spirit. He walks with us, rejoices over us, and promises never to leave us. The arc of redemption is clear. What He began, He will complete.

From the garden to the city, from creation to new creation, one truth remains constant: Our God is faithful, and His greatest delight is to dwell with His people forever. So let us live with eyes fixed on that city, walking with the God who walks with us still.

---

## Example 3: Rejoicing at the Feast (Deuteronomy 16:13-15)

**Pattern**: Command Exploration  
**Context**: Feast of Tabernacles  
**Word Count**: ~1400 words

[Opening with Scripture]
Deu 16:13 "You shall observe the Feast of Tabernacles seven days, when you have gathered from your threshing floor and from your winepress.
Deu 16:14 And you shall rejoice in your feast, you and your son and your daughter, your male servant and your female servant and the Levite, the stranger and the fatherless and the widow, who are within your gates.
Deu 16:15 Seven days you shall keep a sacred feast to the LORD your God in the place which the LORD chooses, because the LORD your God will bless you in all your produce and in all the work of your hands, so that you surely rejoice.

For each of God's Holydays, Israel was given certain physical rituals that they were to do every year at the particular feast. We are familiar with these, eating unleavened bread, fasting, washing of feet, blowing of trumpets. After doing these year after year, we have to be careful though that we don't get too familiar with them and let them become mere physical rituals, things that we do with out thinking, just going through the motions.

Here in Deuteronomy, is one of the commands God gave Israel, is giving us, for the Feast of Tabernacles. In verses 14 and 15 God is telling us that we should rejoice at the Feast because of the great abundance God has given us and manifested in the tithe we are to bring to the feast.

On first reading this might be one of the easiest commands to keep. How can you not rejoice at the feast? We spend months thinking about it, planning for it. We come here with 10% of our income to spend in just 8 days. Often we are with our friends and physical family, and we are all here with our spiritual family being fed every day God's word. On top of all this even if we spend even a little bit of time meditating on the meaning of these days it is hard to not rejoice because they picture the completion of God's great plan for us and all mankind.

Given all this it seems almost automatic that we would rejoice, but there is more here then if we just give this a surface reading.

[Turning to Related Passage]
Lets turn back a couple of chapters to:

Deu 14:22 "You shall truly tithe all the increase of your grain that the field produces year by year.
Deu 14:23 And you shall eat before the LORD your God, in the place where He chooses to make His name abide, the tithe of your grain and your new wine and your oil, of the firstborn of your herds and your flocks, that you may learn to fear the LORD your God always.
Deu 14:24 But if the journey is too long for you, so that you are not able to carry the tithe, or if the place where the LORD your God chooses to put His name is too far from you, when the LORD your God has blessed you,
Deu 14:25 then you shall exchange it for money, take the money in your hand, and go to the place which the LORD your God chooses.
Deu 14:26 And you shall spend that money for whatever your heart desires: for oxen or sheep, for wine or similar drink, for whatever your heart desires; you shall eat there before the LORD your God, and you shall rejoice, you and your household.

Verse 26 can be divided into three sections that help point us to one of the deeper meanings from this command to use our tithes to rejoice at the feast.

### Eating Before the LORD

The first I want to look at is the middle section:
"you shall eat there before the LORD your God,"

This is in stark contrast to just a few days ago, on the Day of Atonement, where God commanded us to afflict our souls by fasting. But what are these two actions (fasting and feasting) pointing us to? Lets remind ourselves about the symbolism that Christ gives us around the spiritual meaning of food in John where he says

John 6:35 And Jesus said to them, "I am the bread of life. He who comes to Me shall never hunger, and he who believes in Me shall never thirst.

John 7:38 He who believes in Me, as the Scripture has said, out of his heart will flow rivers of living water."

While Atonement serves as a reminder, as Satan is being put away, what it is like to hunger and thirst physically so we can understand spiritual hunger and thirst when we are apart from Christ teaching us how important it is to be at one with God.

These days during the Feast, where we will be spirit and Christ will be here on the earth with the rest of mankind, are to serve as a reminder of the great abundance we will have in the millennium and for all eternity when we feast with the Bread of Life and drink from the Rivers of Living Waters. Notice the exact command we are to eat there before the LORD, spiritually pointing us towards the relationship we have with God, this feasting is not apart from God but before HIM. This is about our relationship with God and Christ. We are to rejoice, give joy and praise to and with the one who makes this relationship possible.

### Rejoicing with Your Household

Reading onto the last section in Deuteronomy 14:26
"and you shall rejoice, you and your household."

For us to obey God's command it is not enough for you or I to rejoice individually. That would be relatively easy but God wants us to ensure that our whole household is rejoicing. Which is more difficult, we need to be thinking outside ourselves. But what is that household we are to think about. Now I am blessed to be here with my family, my wife, my children, and sister and her family. But it is not enough for me to just focus on my family rejoicing. Or there are many that are from our home congregation are we to only focus on those we know best? We know the answer. We are to look at having the whole household of faith rejoicing at the feast. But we can't limit it to just those who are in the household of faith today but all those that might join us.

Gal_6:10 Therefore, as we have opportunity, let us do good to all, especially to those who are of the household of faith.

Let us do good to all. Where else will we have so much opportunity? God wants us, all individually, to help all those around us to rejoice during these days.

In Deuteronomy 16:14 one of the categories of people we are supposed to rejoice with when they are in our gates "the stranger" which doesn't mean so much someone you don't know, but someone who was not born of Israel. Here in Mexico we have a unique opportunity to help those who aren't part of our church rejoice in the feast and one that I think we do well. In years past coming here we have gotten to know many of the folks from the hotel. We also have in the past thanked the staff as part of our services for all they do during this time. With the closeness we have with the staff over these seven days of the feast and the eighth day do we ensure they are rejoicing as well?

### Whatever Your Heart Desires

Which brings us to the beginning of Deuteronomy 14:26
"And you shall spend that money for whatever your heart desires: for oxen or sheep, for wine or similar drink, for whatever your heart desires;"

Twice God tells us this is a feast for whatever our heart desires. But what do our hearts desire? For the money that we will spend are we using it to lay our treasure up in heaven so our hearts are there?

Mat 6:19 "Do not lay up for yourselves treasures on earth, where moth and rust destroy and where thieves break in and steal;
Mat 6:20 but lay up for yourselves treasures in heaven, where neither moth nor rust destroys and where thieves do not break in and steal.
Mat 6:21 For where your treasure is, there your heart will be also.

This is a test for us. When we are given great abundance, even greater then normal how will we use it? Will we only eat the physical food we desire or will we eat of the Bread of Life and drink of the River of Living Water?

Here I want to pause and be clear, God is giving us physical abundance and He wants us to feast, this is not a time for fasting, this is a time for feasting and God commands that we feast. But if physically feasting, physically rejoicing is where it ends that is not what God is looking for from a spiritual people.

God wants us to use the physical abundance He has blessed us with for whatever our hearts desires because he wants to see what our hearts desires. He wants to see if we have that new heart of flesh or is we will have the heart of stone.
Eze_36:26 I will give you a new heart and put a new spirit within you; I will take the heart of stone out of your flesh and give you a heart of flesh.

The feast is a great place to see how we have progressed because we have fewer of the pulls of daily life to content with. God, if we obey him has given us the time and physical resources to do that which we might not normally do. He will see what we do with this opportunity. Looking at this command to rejoice in this way, what we might call spirit of the law, not just the letter, is not as easy or as assured as it might seem on the face of it.

### Conclusion

So brethren, here we are with just a few more days of the feast left but still with plenty of time. God wants us to feast on the physical abundance he has given us but if that is all we do we a missing this opportunity that God is giving us.

I will leave you with a question for you to meditate on.

How will you rejoice in your feast?

---

## Example 4: Honor - God's Way of Valuing Others

**Pattern**: Word Study with Application  
**Word Count**: ~1450 words

How many different groups of people did God command us to honor?
· Parents (Deuteronomy 5:1)
· The elderly (Leviticus 19:32)
· Spouses (1 Peter 3:7)
· Widows (1 Timothy 5:3)
· Church elders who rule well (1 Timothy 5:17)
· Employers (1 Timothy 6:1)
· Our own bodies (1 Thessalonians 4:4)
· Fellow believers (Romans 12:10)
· Rulers (1 Peter 2:17)

And finally, if that were not enough the Apostle Peter says all people (1 Peter 2:17).

That's at least nine categories, meaning honoring others isn't occasional—it's daily. But what does honor mean, and why does God emphasize it so heavily?

### What Honor Really Means

When we think of honor, we often think "respect." The Oxford English Dictionary defines honor as:
Noun:
a. high respect; esteem
b. a privilege
Verb:
a. regard with great respect
b. fulfill (an obligation) or keep (an agreement)

This is a good starting point to understand Godly honor, but the Hebrew and Greek reveal something deeper—something more that God wants us to understand about true Godly honor.

There are two Hebrew words translated as honor: hadar (H1921) means "to swell up," and the second, kabad (H3513), means "to make weighty"—to give something substance and importance. In ancient times, weight determined value—gold was weighed, not counted. When something had weight, it had significance, gravity, importance that couldn't be ignored.

The Greek timao (G5091) means "to fix a valuation upon"—like an appraiser determining worth.

God isn't just commanding respect. He's commanding us to give others weight in our decisions, substance in our thinking, and to fix a high value on others.

Think about how you treat something you highly value. A child with a long-awaited toy carries it everywhere, protects it, treasures it. Someone with a new car washes it, parks it carefully, maintains it.

When we truly value something, our actions naturally follow.

This is what God means by honor—placing such high value on others that loving them, serving them, and caring for them becomes natural, even joyful.

### Honor Produces Godly Character

When you fix high value on someone, the fruits of the Spirit flow naturally. Love isn't a burden—it's what you want to give. Joy comes from seeing them flourish. Patience, kindness, goodness—all become expressions of the value you place on them.

But notice—when you give someone weight in your thinking, they influence your decisions. Their needs, their wellbeing, their perspective carries substance in your mind. You don't dismiss them or brush them aside because they have weight—they matter in how you choose to act.

Consider meekness. Jesus linked meekness with "lowliness of heart" in Matthew 11:29. When you value others highly and give them weight in your thinking, you naturally think less of yourself comparatively—not in self-hatred, but in proper perspective. You put others first because you genuinely value them above yourself.

Honor doesn't just change how we act—it transforms how we think.

### God's Example of Honor

Where did we learn this? From God Himself. Jesus said in Matthew 10:29-31:

Matthew 10:29 Are not two sparrows sold for a copper coin? And not one of them falls to the ground apart from your Father's will.
Matthew 10:30 But the very hairs of your head are all numbered.
Matthew 10:31 Do not fear therefore; you are of more value than many sparrows.

God—who can do anything, have anything—chooses to value you. Stop and think about this: God the Father, the most powerful being, thinks it is worthy of His effort to know everything about you. Think about it—God can do anything, can have anything, and what does He value? You and me and every single person that has ever been and will be on this earth.

He values you so much that what Christ is saying here is that He even knows the most mundane details about you, like how many hairs are on your head. Think about this in our human experience. For those we place high value on, those we give weight to in our thinking, we know the little details about them—favorite color, favorite food, maybe favorite drink—and we use that knowledge to make their lives a little better.

And this is God, the most powerful Being in existence, who thinks you are worthy of His attention, His knowledge, His care.

And the ultimate demonstration? The Passover we celebrate shows the infinite value God and Christ place on each of us. Here They decided to give an Eternal Being in exchange for mankind because they honor us—they fix the highest possible value on human beings. By Their actions they said your life, not collectively but individually, was of equal value to the life of Jesus Christ.

### The Challenge: Familiarity

But here's the even harder struggle. Jesus said in Matthew 13:57 that "a prophet is not honored in his own country and in his own house." We know the phrase: "Familiarity breeds contempt."

Human nature devalues what's familiar. We see people treating strangers better than their own families. Political supporters who become critics of the very leaders they once championed. It's the ugly side of human nature—the longer we're around someone, the less we value them.

This isn't just human nature though—it's Satan's nature. Covering the very throne of God, he was around God, he saw how God works, he saw the nature of God, yet over time he began to place less value on God. Then what crept in was the opposite of the fruits of the Spirit. Satan began to think that his personal value was higher than the value he placed on God, to such a degree that he thought he should be God.

The Godly form of honor is not just placing honor on someone once or for a period. He expects us to show honor to everyone and to God and Christ for all eternity.

The eternal test of godly honor isn't valuing someone once—it's maintaining that high valuation over time, especially with those closest to us.

### The Call to Action

Brethren, honoring others fights against our nature twice: first, our natural selfishness, and second, our tendency to devalue the familiar. Our human nature wants to give weight only to our own thoughts, our own needs, our own perspectives. But God calls us to give weight to others—to let their needs have substance and influence in our thinking. This is why we must constantly renew our minds, continually pray for God's help.

Every person you meet should be of high value to you. Those closest to you—spouse, children, parents, brethren—require the most vigilance to maintain that honor over time.

God is looking for children who will honor Him, His Son, and each other for all eternity. That eternal perspective starts now, today, with how we choose to value—to honor—those around us.

When we truly understand honor as God intends it—giving others weight in our thinking and fixing high value on them—our entire approach to relationships transforms. We don't serve others grudgingly; we serve them because we treasure them. We don't love because we must; we love because they're valuable to us and their wellbeing carries weight in every decision we make.

This is how God sees you. This is how He wants you to see others. This is honor.

---

## Example 5: Gleaning and the Great Commission (Leviticus 23:22)

**Pattern**: Foreshadowing and Fulfillment  
**Context**: Pentecost offering  
**Word Count**: ~1500 words

We are here together to celebrate the Feast of Weeks, what we usually call Pentecost. This is one of the three times or seasons we are commanded to come and give an offering to God as found in Deuteronomy 16:16-17. No need to turn there because we know those verses so well.

This morning, I would like to start by turning to Leviticus 23:22

[Before going on just a reminder if any one needs an offering envelop please raise your hands and the Ushers will give you one.]

Leviticus 23 as we know is one of the chapters where God lays out the commands to celebrate His Holy Days. Verses 15 through 22 are specifically focused on Pentecost. In leading up to verse 22, we see in verse 15 &16 God explaining how to know when to keep Pentecost. Then in verses 17-20 we see the offering they were commanded to give, and in verse 21 the command.

And then verse 22 is put in there right before moving on to the commands around the Feast of Trumpets. On first reading it seems a bit out of place.

Lets read verse 22.

Leviticus 23:22 'When you reap the harvest of your land, you shall not wholly reap the corners of your field when you reap, nor shall you gather any gleaning from your harvest. You shall leave them for the poor and for the stranger: I am the LORD your God.'"

This is a repeat of an earlier command in found in Leviticus 19:9 & 10 which covered both harvesting grain and gleaning their vineyards.

Lev 19:9 'When you reap the harvest of your land, you shall not wholly reap the corners of your field, nor shall you gather the gleanings of your harvest.
Lev 19:10 And you shall not glean your vineyard, nor shall you gather every grape of your vineyard; you shall leave them for the poor and the stranger: I am the LORD your God.

### The Harvest Seasons

Lets quickly review what we know about the harvest seasons. In ancient Israel there were two harvest seasons, the spring harvest and the fall harvest. The spring was when grains, mainly barley and wheat were harvested. While in the fall, there was a large harvest that would include grapes, olives, figs and other fruits.

The spring harvest seasons is the longer harvest season because the barley ripens earlier then the wheat. Timing wise the barley would typically be ready around the Days of Unleavened Bread. Earlier in Leviticus 23 we know about the sheaf of the first fruits waved on the day after the Sabbath during Days of Unleavened Bread. Associated with this was a command to not eat of the harvest until after this was waved. So by the time of Pentecost the harvest was underway.

### Why This Command Here?

Why would God repeat this command with in conjunction with observing Pentecost?

Why wasn't this command given with the Days of Unleavened Bread when the barley harvest would start? Why would they be reminded well after the harvest had started?

Or why wasn't the command about gleaning grapes repeated during one of the fall Holy Days.

To answer these we need to look not at the physical keeping of these days and commands but the spiritual meaning.

In the physical sense, God is commanding the Children of Israel to leave grain for the poor and stranger so they can have bread to eat. What is the spiritual meaning of the bread that is to be left for the poor and the stranger?

Deuteronomy 8:3 & Matthew 4:4

'MAN SHALL NOT LIVE BY BREAD ALONE, BUT BY EVERY WORD THAT PROCEEDS FROM THE MOUTH OF GOD.'"

Or John 6:32-40 Where Jesus, the Word of God, says he is the Bread of Life.

John 6:32 Then Jesus said to them, "Most assuredly, I say to you, Moses did not give you the bread from heaven, but My Father gives you the true bread from heaven.
John 6:33 For the bread of God is He who comes down from heaven and gives life to the world."
John 6:34 Then they said to Him, "Lord, give us this bread always."
John 6:35 And Jesus said to them, "I am the bread of life. He who comes to Me shall never hunger, and he who believes in Me shall never thirst.
John 6:36 But I said to you that you have seen Me and yet do not believe.
John 6:37 All that the Father gives Me will come to Me, and the one who comes to Me I will by no means cast out.
John 6:38 For I have come down from heaven, not to do My own will, but the will of Him who sent Me.
John 6:39 This is the will of the Father who sent Me, that of all He has given Me I should lose nothing, but should raise it up at the last day.
John 6:40 And this is the will of Him who sent Me, that everyone who sees the Son and believes in Him may have everlasting life; and I will raise him up at the last day."

Or Amos 8:11
Amos 8:11 "Behold, the days are coming," says the Lord GOD, "That I will send a famine on the land, Not a famine of bread, Nor a thirst for water, But of hearing the words of the LORD.

From these verses we see that what is to be done is feed the poor and the stranger the Word of God.

### The Church's Commission

Why during Pentecost is this command repeated. We know well that Pentecost pictured the founding of God's Church.

So this command of sharing the physical food of Israel with the poor and the stranger must be tied to a command given to God's Church. Specifically about sharing the Word of God with the poor and stranger.

Mark 16:15 And He said to them, "Go into all the world and preach the gospel to every creature.
Mark 16:16 He who believes and is baptized will be saved; but he who does not believe will be condemned.
Mark 16:17 And these signs will follow those who believe: In My name they will cast out demons; they will speak with new tongues;
Mark 16:18 they will take up serpents; and if they drink anything deadly, it will by no means hurt them; they will lay hands on the sick, and they will recover."

See brethren this was foreshadowing the great commission that the Church was given and started to fulfill on the Day of Pentecost. We know the great preaching that started in the book of Acts. But that commission hasn't been fulfilled yet. It has come down to us today.

So Leviticus 23:22 is a reminder for us. You and I. It is a reminder that we who have been given abundant knowledge of God's word are to share with the poor and strangers among us.

### Why Not Other Holy Days?

This command wasn't needed as a reminder during the Days of Unleavened Bread, picturing Christ, because he needed no reminder to preach the Gospel, sharing the Word of God with the world. This was his whole focus while he was on earth.

And what about during the Fall Harvest, Christ will again be on the earth, the Saints will be resurrected as Spirit Being and our joint purpose will be feeding those on earth the word of God. We won't need a reminder.

But this day picturing the Church, as sinful man but still commanded to carry out the great commission of preaching the Gospel, we need to be reminded, just like ancient Israel needed to be reminded about sharing the abundance of their physical food, we need to continuously be reminded of sharing the abundance of the spiritual food God has given us.

### A Warning

Now a warning though for us if we go back a to Amos 8 and look a few verses then verse 11 we read earlier.

Amos 8:4 Hear this, you who swallow up the needy, And make the poor of the land fail,
Amos 8:5 Saying: "When will the New Moon be past, That we may sell grain? And the Sabbath, That we may trade wheat? Making the ephah small and the shekel large, Falsifying the scales by deceit,
Amos 8:6 That we may buy the poor for silver, And the needy for a pair of sandals— Even sell the bad wheat?"
Amos 8:7 The LORD has sworn by the pride of Jacob: "Surely I will never forget any of their works.

See God is showing there are two ways to use His Words. How many preachers, ministers, churches use God's word to swallow up the needy, or sell bad wheat? Taking money for their own gain and twisting the Words of God such that the words come from the Bible but they are used to point not to God's Way or God's Truth but to the ways of this words and the twisted lies that Satan has deceived the world into believing.

We need to be firmly rooted in the pure Truth of God's way. The wheat we give out of our abundance needs to be freely made available. But just as in ancient Israel where the poor and stranger had to glean. See our responsibility is to make it available to people but we can't force them to eat of the bread of life that we have. We can't force them to hear the preaching of the Gospel message.

### Our Response Through Giving

A big part of how we go about preaching the Gospel, helping people understand God's Word, His Truth, His Plan making it freely available to the world is through our tithes and our offerings.

Its interesting in this reminder to the Church, God didn't commanded how much of the corner you are to save. Just like God commanded in Deuteronomy 16:17 he leaves it up to you to decide to give as you are able. God leaves it up to us because he wants to see what is in our hearts. How we prioritize this with other needs and wants in our lives.

### Conclusion

Brethren lets us use this reminder that God gave ancient Israel to share the abundance of their bread with the poor and stranger, to remember as God's Church that we are to share the abundance of His Word, the Words of Life with the poor and strangers in this world, and through this fulfilling the great commission He has given us.

[Now we will take up this commanded offering.

Althea Chang will be playing the keyboard for Offertory Music. She will be playing "Song for the Nations" by Chris Christensen, arranged by Mark Hayes.]
