# Days of Unleavened Bread

**When**: 15th-21st of the first month (Nisan/Abib), seven days  
**Duration**: Seven days with Holy Day convocations on first and seventh days  
**Scriptural basis**: Exodus 12:15-20, Leviticus 23:6-8, 1 Corinthians 5:6-8

## Central Meaning

Coming out of sin and living righteously through Christ - the journey from Egypt (sin) toward the Promised Land (Kingdom of God).

## Key Themes

- Putting sin out of our lives (deleavening)
- Living unleavened (sinless) lives through Christ's power
- The journey from slavery to freedom
- Christ as the bread of life
- Ongoing sanctification
- The difference between being forgiven (Passover) and growing in holiness (Unleavened Bread)
- Seven days representing completeness of the sanctification process
- Leaven as a symbol of sin spreading and permeating

## Typical Sermon Focus

- **Sanctification**: The process of becoming holy
- **Overcoming sin**: Practical steps for putting sin out
- **The Christian journey**: From Egypt to the Promised Land as our spiritual walk
- **Specific sins**: Addressing particular areas believers struggle with
- **Grace and effort**: God's power enabling our obedience
- **Hidden sins**: The "leaven" we overlook (like pride, bitterness, unforgiveness)
- **The wilderness experience**: Learning dependence on God between deliverance and destination

## Key Scripture Passages

### Primary Texts
- Exodus 12:15-20 - Original command for Unleavened Bread
- Exodus 13:3-10 - Remembering deliverance and teaching children
- Leviticus 23:6-8 - Feast in the annual calendar
- Deuteronomy 16:3-4 - "Bread of affliction" and remembering
- 1 Corinthians 5:6-8 - Paul's application: "Purge out the old leaven"

### Supporting Passages
- Matthew 16:6-12 - Beware the leaven of the Pharisees
- Galatians 5:9 - "A little leaven leavens the whole lump"
- Romans 6:1-14 - Dead to sin, alive to God
- Colossians 3:1-17 - Put off the old man, put on the new
- 2 Corinthians 7:1 - Perfecting holiness in the fear of God
- Hebrews 12:1-2 - Lay aside every weight and sin

### Old Testament Journey Narrative
- Exodus 13-40 - Israel's journey from Egypt through the wilderness
- Numbers 14 - The failure at Kadesh Barnea (warning against unbelief)
- Deuteronomy 8 - God's purpose in the wilderness journey
- Joshua 1-5 - Entering the Promised Land

## Theological Considerations

### UCG-Specific Emphasis
- Two Holy Days (first and seventh days) are convocations with services
- Physical deleavening mirrors spiritual putting away of sin
- Both justification (Passover) and sanctification (Unleavened Bread) are necessary
- The seven days represent the complete Christian life
- Focus on both putting off sin and putting on righteousness

### Common Misunderstandings to Address
- Not legalism or works-righteousness - sanctification is empowered by God
- Not perfection in seven days - represents lifelong process
- Not earning salvation - responding to salvation already received
- Physical deleavening is meaningful but not magical

## Sermon Angles to Explore

### Explored Angles
[Add sermons you've already given on these topics]

### Fresh Angles to Consider
- Three types of leaven: physical, doctrinal (false teaching), moral (sin)
- Why seven days? Completeness of sanctification
- First day (Holy Day) vs. seventh day (Holy Day) - beginning and completion
- The bread of affliction - remembering where we came from
- Unleavened bread as Christ's sinless life we now partake of
- The searching and finding of leaven - self-examination
- Israel's grumbling in the wilderness - our attitudes during sanctification
- The pillar of cloud and fire - God's guidance through our journey

## Practical Application

### For New Believers
- What does putting sin out look like practically?
- How do we identify "hidden leaven" in our lives?
- The difference between striving in own strength vs. God's power
- Understanding that growth is a process

### For Mature Believers
- Deeper examination of subtle sins (pride, self-righteousness, judgmentalism)
- Helping others in their journey
- Maintaining spiritual vitality over long obedience
- The danger of spiritual complacency

### Common Questions to Address
- How do we overcome sin that keeps coming back?
- What if we fail during Unleavened Bread?
- How strict should we be about physical leaven?
- How do we teach children about this feast?

## Physical Observances

- **Deleavening homes**: Removing all leavened products before the feast
- **Eating unleavened bread**: For all seven days
- **No leaven or leavened products**: In homes or consumption
- **Teaching opportunity**: Involving family in deleavening and explaining meaning
- **Two Holy Days**: Services on first and seventh days

## Connections to Other Holy Days

- **Passover**: Immediately precedes - blood covers, then sin is put out
- **Pentecost**: Count begins during Unleavened Bread (day after Sabbath)
- **All feasts**: The only feast requiring physical change in diet for extended period

## Seasonal Context

- **Spring timing**: New growth, new beginning
- **Historical context**: Israel's hasty departure from Egypt
- **Agricultural context**: Barley harvest, firstfruits
- **Prophetic fulfillment**: Christ in the tomb during Unleavened Bread

## Sermon Resources

### Example Sermons/Sermonettes
[Add your past messages here - titles, outlines, or full texts]

### Key Illustrations That Work Well
[Add effective illustrations you've used or want to use]

### Quotes and Insights
[Add memorable quotes or insights from study]

## Things to Avoid

- Legalism about physical leaven while ignoring spiritual application
- Making it all about human effort without emphasizing God's power
- Focusing only on what to avoid, not what to pursue (righteousness)
- Overwhelming people with impossibility instead of encouraging growth
- Treating all seven days the same (miss the journey aspect)
- Making it joyless (it's about freedom from sin!)

## Notes for Future Development

[Add your observations, questions, or ideas for future Unleavened Bread messages here]
