# Liturgical Overview - United Church of God Annual Calendar

This reference provides an overview of the UCG liturgical year, Holy Day observances, and special occasions.

## The Weekly Sabbath

**When**: Every seventh day (Friday sunset to Saturday sunset)
**Scriptural basis**: Genesis 2:2-3, Exodus 20:8-11, Leviticus 23:3
**Significance**: 
- Creation ordinance established before sin
- Sign of the covenant relationship with God
- Day of rest, worship, and spiritual renewal
- Points to the millennial rest

**Sermon considerations**:
- Not every Sabbath requires a sermon specifically about the Sabbath
- Wide variety of topics are appropriate
- Emphasis on rest, relationship with God, and spiritual formation

## The Annual Holy Days

The seven annual Holy Days (eight including the Last Great Day) follow the Hebrew calendar and are calculated based on the new moon and agricultural seasons. Official dates are published annually at: https://www.ucg.org/holy-day-calendar

### Spring Holy Days (First through Fourth)

These festivals picture events largely fulfilled in Christ's first coming and the founding of the Church.

#### 1. Passover
**When**: 14th day of the first month (Nisan/Abib), observed at sunset
**Duration**: Single evening observance
**Scriptural basis**: Exodus 12, Leviticus 23:5, 1 Corinthians 11:23-26
**Central meaning**: Christ's sacrifice for our sins
**Key themes**: 
- Deliverance from sin and death
- Christ as the Passover lamb
- Examining ourselves before taking the symbols
- Covenant renewal
**Typical sermon focus**: Sacrifice, redemption, self-examination, Christ's suffering
**Related passages**: Isaiah 53, John 1:29, 1 Peter 1:18-19

For detailed guidance, see: `references/holy-days/passover.md`

#### 2. Days of Unleavened Bread
**When**: 15th-21st of first month (seven days)
**Duration**: Seven days with Holy Day convocations on first and seventh days
**Scriptural basis**: Exodus 12:15-20, Leviticus 23:6-8
**Central meaning**: Coming out of sin and living righteously
**Key themes**:
- Putting sin out of our lives
- Living unleavened (sinless) lives through Christ
- The journey from Egypt (sin) toward the Promised Land
- Christ as the bread of life
**Typical sermon focus**: Sanctification, overcoming sin, spiritual growth, the Christian journey
**Physical observance**: Eating unleavened bread, removing all leavened products from homes
**Related passages**: 1 Corinthians 5:6-8, John 6:35-58

For detailed guidance, see: `references/holy-days/unleavened-bread.md`

#### 3. Pentecost (Feast of Weeks / Feast of Firstfruits)
**When**: 50 days counted from the day after the weekly Sabbath during Unleavened Bread
**Duration**: Single Holy Day
**Scriptural basis**: Leviticus 23:15-21, Acts 2
**Central meaning**: Founding of the New Testament Church / Firstfruits harvest
**Key themes**:
- Giving of the Holy Spirit
- The Church as the firstfruits
- The spring harvest (small harvest pointing to larger fall harvest)
- Preaching the Gospel / Great Commission
- Unity in the body of Christ
**Typical sermon focus**: The Church, the Holy Spirit's work, evangelism, spiritual gifts, firstfruits
**Physical observance**: Often includes offering/tithes emphasis
**Related passages**: Acts 2, 1 Corinthians 12, James 1:18, Revelation 14:4

For detailed guidance, see: `references/holy-days/pentecost.md`

### Fall Holy Days (Fifth through Seventh/Eighth)

These festivals picture future events at Christ's return and beyond.

#### 4. Feast of Trumpets
**When**: First day of the seventh month (Tishri)
**Duration**: Single Holy Day
**Scriptural basis**: Leviticus 23:23-25, Numbers 29:1-6
**Central meaning**: Christ's return and the resurrection
**Key themes**:
- The last trumpet and Christ's second coming
- Resurrection of the saints
- Warning to the world
- Preparation for Christ's return
- The Day of the Lord
**Typical sermon focus**: Second coming, resurrection, prophecy, readiness, watching
**Related passages**: Matthew 24:30-31, 1 Corinthians 15:51-52, 1 Thessalonians 4:16-17, Revelation 11:15

For detailed guidance, see: `references/holy-days/trumpets.md`

#### 5. Day of Atonement
**When**: Tenth day of the seventh month
**Duration**: Single Holy Day with required fasting (no food or water from sunset to sunset)
**Scriptural basis**: Leviticus 16, Leviticus 23:26-32
**Central meaning**: Satan bound and removed / Being at-one with God
**Key themes**:
- Removal of Satan the deceiver
- Atonement / reconciliation with God
- Corporate and individual repentance
- Understanding our need for God
- The meaning of the two goats (Christ and Azazel)
**Typical sermon focus**: Repentance, Satan's influence, spiritual hunger/thirst, reconciliation
**Physical observance**: Complete fast from sunset to sunset
**Related passages**: Revelation 20:1-3, Isaiah 14:12-15, 2 Corinthians 5:18-21

For detailed guidance, see: `references/holy-days/atonement.md`

#### 6. Feast of Tabernacles
**When**: 15th-21st of the seventh month (seven days)
**Duration**: Seven days of rejoicing, often observed at a designated festival site
**Scriptural basis**: Leviticus 23:33-36, Deuteronomy 16:13-15
**Central meaning**: The millennial reign of Christ
**Key themes**:
- Christ ruling on earth for 1,000 years
- Peace, prosperity, and righteousness
- Learning God's way
- Dwelling with God
- The world under God's government
- Rejoicing in God's abundance
**Typical sermon focus**: The millennium, God's kingdom, prophecy, rejoicing, God's plan for humanity
**Physical observance**: 
- Travel to festival sites
- Using second tithe for celebration
- Seven days of rejoicing and fellowship
- Special emphasis on joy and abundance
**Related passages**: Zechariah 14, Revelation 20:4-6, Isaiah 11, Micah 4:1-4

For detailed guidance, see: `references/holy-days/tabernacles.md`

#### 7. Last Great Day (Eighth Day)
**When**: Immediately following Feast of Tabernacles (22nd of seventh month)
**Duration**: Single Holy Day
**Scriptural basis**: Leviticus 23:36, John 7:37-39
**Central meaning**: Final judgment / Great White Throne / Salvation for all humanity
**Key themes**:
- Resurrection of the rest of humanity
- Opportunity for salvation for all who ever lived
- Great White Throne judgment
- God's plan to save all humanity
- Jesus' words: "If anyone thirsts, let him come to Me and drink"
- The completion of God's plan
**Typical sermon focus**: God's mercy, final judgment, salvation plan, God's fairness, eternal life
**Physical observance**: Often concludes the fall festival season with final messages
**Related passages**: Revelation 20:11-15, Ezekiel 37:1-14, John 7:37-39, Romans 11:25-26

For detailed guidance, see: `references/holy-days/last-great-day.md`

## The Annual Cycle's Narrative Arc

The Holy Days tell a cohesive story of God's plan:

**Spring** (past/present):
1. Passover → Christ's sacrifice
2. Unleavened Bread → Coming out of sin
3. Pentecost → Church / firstfruits

**Fall** (future):
4. Trumpets → Christ's return
5. Atonement → Satan bound
6. Tabernacles → Millennial reign
7. Last Great Day → Final judgment / completion

This progression shows:
- God's plan has always been to save humanity
- Christ's sacrifice makes salvation possible
- The Church is the firstfruits, not the only harvest
- Christ will return to establish God's kingdom
- Satan's influence will be removed
- The world will learn God's way during the millennium
- Eventually, all who ever lived will have opportunity for salvation
- God's plan culminates in eternal life for all who choose Him

## Special Occasions (Non-Holy Days)

### Thanksgiving
**Status**: Not a biblical Holy Day, but widely observed
**Approach**: 
- Emphasis on gratitude to God
- Acknowledging God as the source of all blessings
- Fellowship and family
- Avoid mixing with origins in pagan harvest festivals
**Sermon considerations**: Thankfulness, counting blessings, stewardship

### Independence Day (USA) / National Days
**Status**: Secular observance
**Approach**:
- Can acknowledge with gratitude for freedom and national blessings
- Maintain proper perspective: God is supreme, not nation
- Remember UCG pacifist position regarding military service
- Focus on spiritual freedom in Christ
**Sermon considerations**: Freedom, citizenship in God's kingdom, Romans 13

### What UCG Does NOT Observe

These are explicitly NOT observed due to pagan origins or lack of biblical basis:

**Christmas** (December 25)
- Not Christ's actual birthday
- Pagan origins (winter solstice celebrations)
- Not commanded in Scripture
- No biblical mandate to celebrate Christ's birth

**Easter** (Spring Sunday)
- Name derives from pagan goddess Eostre
- Replaced biblical Passover
- Wrong day (Sunday vs. Passover date)
- Mixed with pagan fertility symbols

**Halloween** (October 31)
- Pagan origins in Celtic Samhain
- Associated with death, occult
- Incompatible with Christian values

**Valentine's Day, Mother's Day, Father's Day, etc.**
- Not forbidden, but not religiously observed
- Secular observances some members may participate in personally

## Sermon Planning Considerations

### Holy Day Context
When writing for a specific Holy Day:
- Always check the detailed reference file for that Holy Day
- Understand what aspect of God's plan this day pictures
- Connect to the broader narrative arc when appropriate
- Consider the physical observances and their spiritual meaning
- Address why this day matters TODAY for believers

### Festival Sites
Many sermons during Tabernacles are delivered at festival sites where:
- Congregation is often larger than home congregation
- Mix of people from different areas
- Heightened sense of celebration and community
- More time for in-depth teaching (multiple services over seven days)
- Second tithe makes fellowship and activities more abundant

### Seasonal Rhythms
- **Spring festivals** (March-May): Often focus on personal spiritual growth, Christ's sacrifice, the Church
- **Summer** (June-August): Regular Sabbaths without Holy Days
- **Fall festivals** (September-October): Focus on prophecy, God's plan, the future kingdom
- **Winter** (November-February): Regular Sabbaths, with Thanksgiving typically in November

## Helpful Resources

- **Official Holy Day dates**: https://www.ucg.org/holy-day-calendar
- **UCG Fundamental Beliefs**: https://www.ucg.org/fundamental-beliefs-of-the-united-church-of-god
- **Holiday booklets**: UCG publishes booklets explaining why certain holidays are not observed

## Quick Reference: Holy Day Summary

| Holy Day | Month | Duration | Central Theme | Fulfillment Timeline |
|----------|-------|----------|---------------|---------------------|
| Passover | 1st (Nisan) | 1 evening | Christ's sacrifice | Fulfilled (ongoing observance) |
| Unleavened Bread | 1st | 7 days | Coming out of sin | Ongoing Christian life |
| Pentecost | 3rd (Sivan) | 1 day | Church / Firstfruits | Fulfilled (Church age) |
| Trumpets | 7th (Tishri) | 1 day | Christ's return | Future |
| Atonement | 7th | 1 day (fast) | Satan bound | Future |
| Tabernacles | 7th | 7 days | Millennial reign | Future |
| Last Great Day | 7th | 1 day | Final judgment | Future |
