# Topics Directory

This directory is for building topic-specific reference files over time. Each file should contain resources, insights, and past sermons related to a specific biblical topic.

## Purpose

As you write sermons on various topics, you can create reference files here to:
- Avoid repeating the same angles on familiar topics
- Build a library of Scripture passages for each topic
- Collect your best illustrations and applications
- Maintain theological consistency across messages
- Easily reference past sermons when revisiting a topic

## When to Create a Topic File

Create a new topic file when:
- You've written 2-3 sermons on the same topic
- You find yourself returning to a topic regularly
- You want to capture insights while they're fresh
- You need to organize resources for a complex topic

Don't feel pressure to create all topic files at once. Build them organically as you write.

## Topic File Template

When creating a new topic file, use this structure:

```markdown
# [Topic Name]

## Key Scripture Passages

### Old Testament
- [List key OT passages with brief notes]

### New Testament
- [List key NT passages with brief notes]

## UCG Theological Perspective

[How does UCG understand this topic? Any distinctive emphases?]

## Common Themes and Angles

- [Theme 1]: [Brief description]
- [Theme 2]: [Brief description]
- [etc.]

## Past Sermons/Sermonettes

### [Date] - [Title]
**Main point**: [One sentence summary]
**Angle**: [What aspect did you emphasize?]
**Scripture focus**: [Primary passages used]
**Illustration**: [Key illustration if particularly effective]
[Link to full text if desired]

### [Date] - [Title]
[Same structure]

## Effective Illustrations

- [Illustration 1]: [Description and when/why it works]
- [Illustration 2]: [Description]

## Application Angles

- [Application 1]: [Specific way to apply this topic]
- [Application 2]: [Another angle]

## Things to Avoid

- [Common pitfalls when teaching this topic]
- [Angles that don't work well]
- [Theological errors to watch for]

## Related Topics

- [Topic 1]: [How it relates]
- [Topic 2]: [How it relates]

## Resources for Further Study

- [Books, articles, commentaries that have been helpful]
- [UCG resources on this topic]

## Notes and Insights

[Capture any additional thoughts, questions, or observations]
```

## Example Topic Files You Might Create

Common topics worth building reference files for:

**Theological Topics**:
- Faith
- Love
- Grace
- Obedience
- Law and Grace
- Holy Spirit
- Prayer
- Forgiveness
- Repentance
- Righteousness

**Christian Life Topics**:
- Overcoming sin
- Spiritual growth
- Fruits of the Spirit
- Christian character
- Patience
- Humility
- Service
- Unity in the body
- Dealing with trials
- Hope

**Relationship Topics**:
- Marriage
- Parenting
- Honoring parents
- Loving others
- Forgiveness in relationships
- Unity among brethren

**Prophetic/Eschatological Topics**:
- Second coming
- Resurrection
- The Kingdom of God
- Prophecy
- End times

**Church Topics**:
- The Church
- Body of Christ
- Spiritual gifts
- Church leadership
- Fellowship

## File Naming Convention

Use lowercase with hyphens:
- `faith.md`
- `love.md`
- `holy-spirit.md`
- `law-and-grace.md`
- `second-coming.md`

## How Claude Uses Topic Files

When you request a sermon on a specific topic and a file exists for it, Claude will:
1. Read the topic file to understand past angles you've covered
2. Avoid repeating the same approach
3. Use Scripture passages and illustrations you've found effective
4. Build on themes you've developed previously
5. Maintain consistency with your theological framework

This creates continuity in your teaching ministry over time.

## Getting Started

**Start small**: After writing your next sermon, create a simple topic file for it. Include:
- The main Scripture passages you used
- Your main point in one sentence
- One or two effective illustrations
- Application angles

As you write more on that topic, add to the file. Over time, you'll build a rich resource library.
