# Sermon Evaluation Rubric

This rubric expands on the four evaluation dimensions for reviewing completed sermons, sermonettes, and split sermons. Use this when the user requests a review or when self-evaluating work.

## How to Use This Rubric

When reviewing a message:
1. Read through the entire message first
2. Evaluate each dimension using the criteria below
3. Provide specific, constructive feedback with examples
4. Suggest concrete improvements where needed
5. Note what's working well (affirm strengths)

## Dimension 1: Theological Depth

**Core Question**: Does this message faithfully interpret Scripture and articulate sound theology?

### Excellent (No significant issues)
- Scripture is interpreted in context, not proof-texted
- Theological themes are clearly articulated and well-developed
- Connections across the biblical narrative are made naturally
- Difficult passages are handled honestly without oversimplifying
- Doctrine aligns with UCG positions (see theological-framework.md)
- Original language insights (when used) genuinely illuminate the text
- Types and shadows are identified appropriately with scriptural support

### Good (Minor improvements possible)
- Scripture is mostly in context with occasional loose connections
- Theological themes are present but could be more clearly stated
- Some opportunities for cross-biblical connections are missed
- Doctrine is sound but could be more precisely expressed
- Minor theological statements lack scriptural backing

### Needs Work (Significant issues to address)
- Proof-texting or taking verses out of context
- Theological themes are unclear or underdeveloped
- Misses important connections in the biblical narrative
- Oversimplifies complex passages
- Doctrine is imprecise or potentially misleading
- Contradicts UCG theological positions
- Original language work is pedantic or inaccurate

### Review Questions
- Are all Scripture references accurate and in context?
- Do theological claims have adequate scriptural support?
- Are UCG distinctive doctrines correctly represented?
- Does the message show how this passage fits into the broader biblical story?
- Are difficult texts handled with appropriate nuance?
- Is the interpretation defensible from the text itself?

### Common Issues to Flag
- **Law without grace or grace without law** - UCG emphasizes both working together
- **Trinitarian language** - Should maintain non-Trinitarian position
- **Overlooking the Father** - Keep God the Father central, not just Jesus
- **Sunday/Christmas/Easter references** - These are not observed in UCG
- **Immortal soul doctrine** - Dead are unconscious until resurrection
- **Eternal torment** - UCG teaches annihilation of the wicked

## Dimension 2: Teaching Clarity

**Core Question**: Is the message clearly communicated and easy to follow?

### Excellent (Highly clear and memorable)
- Main point is crystal clear throughout
- Logical progression that's easy to follow
- Subheadings create clear structure
- Illustrations clarify concepts without distracting
- Transitions are smooth and natural
- Listeners will remember the main point weeks later
- Language is accessible without being simplistic
- Theological terms are explained when needed

### Good (Generally clear with minor confusion)
- Main point is identifiable but could be sharper
- Logical flow is mostly sound with occasional jumps
- Structure is present but could be clearer
- Illustrations are adequate but not always illuminating
- Some transitions feel abrupt
- Main point might be remembered with prompting

### Needs Work (Difficult to follow)
- Main point is unclear or buried
- Logical progression is hard to follow
- Structure is weak or missing
- Illustrations confuse rather than clarify
- Poor transitions create disjointed feeling
- Too many ideas compete for attention
- Language is either too technical or too simplistic
- Listeners would struggle to summarize the message

### Review Questions
- Can you state the main point in one sentence?
- Does each section build logically toward that point?
- Are illustrations effective and relevant?
- Do transitions guide the listener smoothly?
- Is the vocabulary appropriate for the audience?
- Would someone remember this message a week later? A month later?
- Are theological terms explained sufficiently?

### Common Issues to Flag
- **Multiple competing main points** - Should focus on one central insight
- **Rabbit trails** - Tangents that don't serve the main point
- **Information dump** - Too much material without clear organization
- **Unclear transitions** - Jumps between ideas without connection
- **Unexplained jargon** - Terms like "justification," "sanctification" without explanation
- **Weak conclusion** - Doesn't tie back to the opening or main point

## Dimension 3: Emotional & Spiritual Engagement

**Core Question**: Does this message speak to both mind and heart?

### Excellent (Deeply engaging)
- Speaks to both intellect and emotions appropriately
- Creates moments of genuine conviction or comfort
- Asks penetrating questions that invite self-examination
- Addresses real struggles authentically
- Leaves space for the Holy Spirit's work
- Resonates with various spiritual temperaments (not just one type)
- Balances hope and challenge
- Avoids manipulation while still moving the heart

### Good (Moderately engaging)
- Mostly intellectual with some emotional connection
- Some moments of conviction or comfort
- Questions are present but not always penetrating
- Touches on real struggles but somewhat superficially
- Generally resonates but may miss some temperaments
- Could have more emotional depth or intellectual rigor

### Needs Work (Disconnected or manipulative)
- Purely intellectual with no heart connection, or
- Purely emotional with no intellectual substance
- No moments that invite personal reflection
- Addresses struggles in clichéd or superficial ways
- Too neat/packaged—no room for the Spirit
- Only resonates with one personality type
- Uses guilt, shame, or manipulation as motivators
- Either crushing (no hope) or fluffy (no challenge)

### Review Questions
- Does this message make you think AND feel?
- Are there moments that would cause listeners to examine themselves?
- Does it address real human struggles, not just abstract theology?
- Is there space for the Holy Spirit to work, or is everything tied up neatly?
- Would this resonate with both analytical and emotional personalities?
- Does it balance conviction with hope?
- Is the emotional appeal authentic or manipulative?

### Common Issues to Flag
- **All head, no heart** - Technically accurate but cold
- **All emotion, no substance** - Moving but theologically shallow
- **Guilt-based motivation** - Using shame rather than love for God
- **Overly neat endings** - Resolves everything too tidily
- **Clichéd struggles** - Addresses generic "sins" rather than real human experience
- **One-dimensional** - Only speaks to certain personality types
- **Manipulation** - "If you really loved God..." or "Other Christians are..."

## Dimension 4: Resonance & Relevance

**Core Question**: Does this message connect with today's audience and their real lives?

### Excellent (Highly relevant)
- Addresses questions mature believers actually wrestle with
- Application is grounded in authentic human experience
- Connects biblical truth to contemporary life naturally (not forced)
- Speaks across different life stages and circumstances
- Avoids both irrelevance and forced contemporaneity
- Cultural touchpoints (when used) are appropriate and illuminating
- Demonstrates why this biblical truth matters today

### Good (Generally relevant)
- Addresses real questions but not always the most pressing ones
- Application is somewhat generic but still useful
- Connection to contemporary life is present but could be stronger
- May resonate more with some life stages than others
- Mostly avoids irrelevance and forced relevance

### Needs Work (Out of touch or forced)
- Addresses questions no one is asking
- Application is abstract or disconnected from real life
- Either completely ignores contemporary context or forces it awkwardly
- Only relevant to a narrow demographic
- Cultural references feel dated or out of touch
- Fails to show why this matters beyond academic interest

### Review Questions
- Does this address questions real people in the congregation are asking?
- Is the application specific enough to be actionable?
- Does it feel relevant without pandering to cultural trends?
- Would this speak to someone in their 20s? In their 60s?
- Does it connect to actual struggles people face?
- Is the "why this matters" compelling?

### Common Issues to Flag
- **Academic without application** - Interesting but so what?
- **Generic application** - "Be more loving" without specifics
- **Forced relevance** - Awkwardly inserting current events or pop culture
- **Narrow demographic focus** - Only speaks to parents, or singles, or retirees
- **Out of touch** - Seems unaware of real struggles people face
- **Irrelevant questions** - Addresses issues no one cares about
- **Missing the real issue** - Skirts around what people actually struggle with

## Cross-Cutting Issues

These issues affect multiple dimensions:

### Length/Proportion Problems
- **Too short for depth** - Message doesn't reach the target word count and feels incomplete
- **Too long and rambling** - Exceeds word count and loses focus
- **Unbalanced sections** - Exposition dominates with weak application, or vice versa
- **Wrong length for complexity** - Trying to cover too much in a sermonette or too little in a full sermon

### Voice/Tone Problems
- **Inconsistent voice** - Shifts between formal and casual inappropriately
- **Wrong tone for context** - Too light for serious topic, too heavy for celebratory feast
- **Preachy or condescending** - Talks down to the audience
- **Overly academic** - Sounds like a journal article, not a sermon

### Structural Problems
- **Weak opening** - Doesn't hook attention or establish why this matters
- **Missing transitions** - Sections don't flow together
- **No clear conclusion** - Just stops without wrapping up
- **Doesn't circle back** - Conclusion doesn't return to opening theme

## Providing Feedback

When reviewing a message, structure feedback like this:

### Overall Assessment
Summarize the message's main strength and primary area for improvement.

### Theological Depth
- What's working well theologically
- Specific issues to address (with verse references if applicable)
- Suggestions for deepening theological engagement

### Teaching Clarity
- What's clear and effective
- Where confusion might arise
- Suggestions for improving structure, transitions, or illustrations

### Emotional & Spiritual Engagement
- Moments that truly connect
- Areas that feel flat or manipulative
- Suggestions for balancing head and heart

### Resonance & Relevance
- Where application is strong and specific
- Where it misses the mark or feels generic
- Suggestions for contemporary connection

### Suggested Edits
Provide specific, concrete suggestions:
- "Consider restructuring the middle section to..."
- "The illustration about X could be strengthened by..."
- "Add a transition between paragraphs 5 and 6 that..."
- "The application would be more concrete if..."

### Affirmation
Always end with genuine affirmation of what's working well. Building up is as important as constructive criticism.

## Self-Evaluation Checklist

Before submitting a message, ask yourself:

**Theological Depth**
- [ ] All Scripture references are accurate and in context
- [ ] Theological claims are backed by Scripture
- [ ] UCG positions are correctly represented
- [ ] Biblical connections enhance understanding

**Teaching Clarity**
- [ ] Main point is clear and memorable
- [ ] Structure is logical and easy to follow
- [ ] Illustrations clarify rather than distract
- [ ] Transitions are smooth
- [ ] Language is accessible

**Emotional & Spiritual Engagement**
- [ ] Speaks to both mind and heart
- [ ] Includes moments for reflection/conviction
- [ ] Addresses real struggles authentically
- [ ] Balances hope and challenge
- [ ] Avoids manipulation

**Resonance & Relevance**
- [ ] Addresses real questions people have
- [ ] Application is specific and actionable
- [ ] Connects naturally to contemporary life
- [ ] Speaks across demographics
- [ ] Shows why this matters today

**General**
- [ ] Word count is within target range
- [ ] Opens with a compelling hook
- [ ] Concludes by circling back to opening
- [ ] Tone is appropriate for context
- [ ] No grammar/spelling errors
