# Last Great Day (Eighth Day)

**When**: Immediately following Feast of Tabernacles (22nd of seventh month, Tishri)  
**Duration**: Single Holy Day  
**Scriptural basis**: Leviticus 23:36, John 7:37-39, Revelation 20:11-15

## Central Meaning

The final judgment / Great White Throne judgment - the resurrection of all who ever lived who didn't have their opportunity for salvation, demonstrating God's plan to save all humanity.

## Key Themes

- Resurrection of the rest of humanity (second resurrection)
- The Great White Throne judgment
- Opportunity for salvation for all who ever lived
- God's plan to save all humanity (not just the few)
- God's mercy and fairness
- Jesus' invitation: "If anyone thirsts, let him come to Me"
- The completion of God's plan
- Books opened and Book of Life
- Final judgment of those who reject God
- New heavens and new earth (eternity begins)
- God's character of love fully revealed

## Typical Sermon Focus

- **Universal opportunity**: Everyone gets their chance
- **God's fairness**: Those who never knew get their opportunity
- **The Great White Throne**: Understanding final judgment
- **God's mercy**: His desire that all be saved
- **Dealing with difficult questions**: What about babies, mentally disabled, those who never heard?
- **Second resurrection**: Different from first resurrection
- **Final disposition**: Lake of fire for those who finally reject
- **John 7:37**: The great invitation on this great day
- **Completion of the harvest**: All who ever lived accounted for

## Key Scripture Passages

### Primary Texts
- Leviticus 23:36 - The eighth day, solemn assembly
- John 7:37-39 - Jesus' cry on the Last Great Day of the feast
- Revelation 20:11-15 - Great White Throne judgment
- Revelation 21-22 - New heavens, new earth, eternity

### Supporting Passages - Second Resurrection
- Ezekiel 37:1-14 - Valley of dry bones (Israel resurrected and taught)
- Matthew 11:20-24 - More tolerable for Sodom in judgment
- Matthew 12:41-42 - Nineveh and Queen of the South rising in judgment
- Hebrews 9:27 - Appointed for men to die once, then judgment
- John 5:28-29 - Hour when all in graves will hear His voice

### Supporting Passages - Universal Salvation Opportunity
- 1 Timothy 2:3-6 - God desires all men to be saved
- 2 Peter 3:9 - Not willing that any should perish
- Romans 11:25-26 - All Israel will be saved
- 1 Corinthians 15:22 - In Adam all die, in Christ all made alive
- Philippians 2:9-11 - Every knee will bow, every tongue confess
- Acts 3:19-21 - Times of restoration of all things

### Supporting Passages - Judgment
- Matthew 25:31-46 - Sheep and goats judgment
- 2 Corinthians 5:10 - All appear before judgment seat
- Romans 2:5-16 - God's righteous judgment
- Romans 14:10-12 - Each give account of himself

### Supporting Passages - New Creation
- Isaiah 65:17 - New heavens and new earth
- 2 Peter 3:10-13 - Day of the Lord, new heavens and earth
- Revelation 21:1-5 - All things made new
- Revelation 21:6-8 - I am Alpha and Omega

### Old Testament Types
- Numbers 29:35 - Eighth day, solemn assembly
- Nehemiah 8:18 - Kept feast seven days, eighth day solemn assembly
- 2 Chronicles 7:8-10 - Solomon's dedication, eighth day assembly

## Theological Considerations

### UCG-Specific Emphasis
- This is the "great" judgment - not condemnation but evaluation
- Second resurrection gives opportunity to those who didn't have it before
- Physical resurrection to physical life (not immediately spirit)
- Time of teaching and learning (like a second lifetime)
- Some will still reject and receive second death (lake of fire)
- Second death is annihilation, not eternal torment
- God's plan ultimately succeeds for vast majority

### Common Misunderstandings to Address
- Not a "second chance" (they never had a first chance)
- Not universalism (some will still reject)
- Not condemnation but opportunity
- Lake of fire is final death (annihilation), not eternal torture
- Judgment doesn't mean punishment - means evaluation
- "Great" White Throne - great because of scope (all humanity)

## Sermon Angles to Explore

### Explored Angles
[Add sermons you've already given on these topics]

### Fresh Angles to Consider
- Why "eighth" day? (Beyond completion, new beginning)
- The contrast between first and second resurrection
- Books opened vs. Book of Life - what's the difference?
- How long will Great White Throne judgment last?
- What will teaching be like during this time?
- The "thirst" metaphor - what are people thirsting for?
- Why Jesus chose THIS day to make this declaration (John 7:37)
- The paradox: God desires all saved, yet some choose rejection
- From Great White Throne to New Earth - the transition
- Those who lived in darkness finally see the light

## Practical Application

### For New Believers
- Understanding God's fairness and mercy
- Answering questions about deceased loved ones
- Seeing the full scope of God's plan
- Relief about those who never had a chance

### For Mature Believers
- Appreciating being called now (firstfruits) vs. later
- Trusting God's justice for all humanity
- Teaching others about God's character
- Living without anxiety about unsaved loved ones
- Understanding our role in this future time (teachers?)

### Common Questions to Address
- What about babies who die?
- What about those with mental disabilities?
- What about people who never heard the Gospel?
- Will everyone be saved eventually?
- How is this fair to those called now (harder path)?
- What about really evil people (Hitler, etc.)?
- How long does this judgment period last?

## Physical Observances

- **Eighth day**: Separate from seven days of Tabernacles
- **Holy Day convocation**: Services and gathering
- **Offerings**: Often significant offering taken on this day
- **Solemn assembly**: Serious but hopeful tone
- **Often concludes festival season**: Final messages before returning home

## Connections to Other Holy Days

- **Tabernacles**: Follows immediately but distinct
- **All previous feasts**: Completes the narrative arc
- **Pentecost**: Firstfruits (few) vs. General harvest (many)
- **Passover**: Salvation initiated, now completed for all

## Seasonal Context

- **Fall timing**: End of agricultural harvest season
- **Eighth day**: New beginning after completion (seven days)
- **Historical context**: Final assembly after feast
- **Prophetic fulfillment**: Future - after millennium
- **Harvest completion**: All harvested, none lost

## Sermon Resources

### Example Sermons/Sermonettes
[Add your past messages here - titles, outlines, or full texts]

### Key Illustrations That Work Well
[Add effective illustrations you've used or want to use]

### Quotes and Insights
[Add memorable quotes or insights from study]

## Things to Avoid

- Universalism (teaching everyone is automatically saved)
- Minimizing human choice (some will still reject)
- Making God seem unjust or arbitrary
- Eternal torture doctrine (contradicts annihilation of wicked)
- Treating it as condemnation rather than opportunity
- Speculating too much about the mechanics
- Missing the hope and joy of this day
- Forgetting that this completes God's plan

## The Emotional Arc of the Holy Days

Last Great Day completes the journey:
1. **Passover** - Individual salvation through Christ
2. **Unleavened Bread** - Personal sanctification
3. **Pentecost** - Church's mission to firstfruits
4. **Trumpets** - Christ returns
5. **Atonement** - Satan removed
6. **Tabernacles** - Kingdom established, teaching nations
7. **Last Great Day** - All humanity gets opportunity, plan completed

The progression shows God's love and commitment to save all humanity.

## Key Theological Point

This day reveals God's character: He is not willing that any perish. The vast majority of humanity who ever lived will be in this resurrection, not the first. This demonstrates:
- God's fairness (all get genuine opportunity)
- God's mercy (teaches rather than condemns)
- God's patience (waits for the right time)
- God's wisdom (knows each person's situation)
- God's love (wants all to come to Him)

## Notes for Future Development

[Add your observations, questions, or ideas for future Last Great Day messages here]
