# Passover

**When**: 14th day of the first month (Nisan/Abib), observed at sunset  
**Duration**: Single evening observance  
**Scriptural basis**: Exodus 12, Leviticus 23:5, 1 Corinthians 11:23-26

## Central Meaning

Christ's sacrifice for our sins - the ultimate Passover Lamb whose blood covers us and delivers us from death.

## Key Themes

- Deliverance from sin and death
- Christ as the Passover lamb
- Examining ourselves before taking the symbols
- Covenant renewal
- Remembrance of Christ's sacrifice
- The blood on the doorposts and spiritual protection
- Egypt as a type of sin and bondage
- The lamb without blemish pointing to Christ's perfection

## Typical Sermon Focus

- **Sacrifice and atonement**: Understanding what Christ's death accomplished
- **Self-examination**: 1 Corinthians 11:28 and preparing to take the symbols worthily
- **Redemption**: Deliverance from slavery to sin
- **Christ's suffering**: The agony of the cross and what He endured for us
- **Covenant relationship**: Renewing our commitment to God
- **The meaning of the symbols**: Bread (body) and wine (blood)
- **Looking forward and backward**: Remembering the cross, anticipating the Kingdom

## Key Scripture Passages

### Primary Texts
- Exodus 12:1-14 - The original Passover instruction
- Leviticus 23:5 - Passover in the festival calendar
- Matthew 26:17-30 - Jesus institutes the New Covenant Passover
- 1 Corinthians 11:23-32 - Paul's instruction on observing Passover
- 1 Corinthians 5:7 - "Christ our Passover was sacrificed for us"

### Supporting Passages
- Isaiah 53 - Suffering servant prophecy
- John 1:29 - "Behold the Lamb of God"
- 1 Peter 1:18-19 - Redeemed with precious blood
- Hebrews 9:11-28 - Christ as High Priest and sacrifice
- Revelation 5:6-14 - The Lamb who was slain

### Old Testament Types
- Genesis 22 - Abraham and Isaac (God will provide the lamb)
- Exodus 12 - Original Passover in Egypt
- Numbers 9:1-14 - Passover regulations
- Deuteronomy 16:1-8 - Passover observance instructions

## Theological Considerations

### UCG-Specific Emphasis
- Observed on the 14th of Nisan at sunset (not the 15th)
- Footwashing precedes the bread and wine
- Private observance (not a public meal celebration like the Night to be Much Observed)
- Solemn occasion focused on Christ's sacrifice and self-examination
- Not a "Last Supper" but an ongoing memorial

### Common Misunderstandings to Address
- Difference between Passover (14th) and Night to be Much Observed (15th beginning Unleavened Bread)
- Why we don't call it "Lord's Supper" or "Communion" 
- The relationship between Old and New Covenant observance
- Why frequency matters (once a year, not weekly/monthly)

## Sermon Angles to Explore

### Explored Angles
[Add sermons you've already given on these topics]

### Fresh Angles to Consider
- The lamb had to be inspected for four days - Christ's testing before crucifixion
- The timing: between the evenings, twilight - the transition moment
- Why unleavened bread specifically (connection to Days of Unleavened Bread)
- The hyssop branch used to apply blood - faith's application of Christ's sacrifice
- No bone of Him broken - fulfillment of prophecy
- Roasted with fire - the intensity of Christ's suffering
- Eating the flesh - fully appropriating Christ's sacrifice
- The hurried eating vs. reclining - different contexts, same deliverance

## Practical Application

### For New Believers
- Understanding the solemnity of the occasion
- What self-examination looks like practically
- The meaning of the symbols
- How Passover connects to the rest of God's plan

### For Mature Believers
- Deepening appreciation for Christ's sacrifice
- Fresh perspective on familiar ceremony
- Connecting Passover to daily walk with God
- Teaching children about Passover's meaning

### Common Questions to Address
- How do we examine ourselves?
- What if we feel unworthy?
- How does Passover relate to baptism?
- Why do we wash feet?

## Physical Observances

- **Footwashing**: Service and humility (John 13)
- **Unleavened bread**: Christ's broken body
- **Wine**: Christ's shed blood
- **Timing**: After sunset on the 14th
- **Atmosphere**: Solemn, reflective, reverent

## Connections to Other Holy Days

- **Unleavened Bread**: Begins immediately after (putting sin out after being covered by blood)
- **Day of Atonement**: Both involve afflicting the soul and deep introspection
- **Last Great Day**: The completion of salvation that Passover initiates

## Seasonal Context

- **Spring timing**: New life, new beginning, firstfruits of barley
- **Historical context**: Israel's deliverance from Egypt
- **Prophetic fulfillment**: Christ crucified at Passover
- **Future hope**: Marriage supper of the Lamb

## Sermon Resources

### Example Sermons/Sermonettes
[Add your past messages here - titles, outlines, or full texts]

### Key Illustrations That Work Well
[Add effective illustrations you've used or want to use]

### Quotes and Insights
[Add memorable quotes or insights from study]

## Things to Avoid

- Making Passover routine or casual
- Focusing only on guilt without hope
- Over-explaining the obvious
- Missing the connection to Christ
- Treating it as merely historical
- Ignoring the self-examination component
- Making people feel condemned rather than cleansed

## Notes for Future Development

[Add your observations, questions, or ideas for future Passover messages here]
