# Theological Framework - United Church of God

This reference provides the theological guardrails and pastoral communication principles that must guide all sermonette and sermon writing.

## Core Doctrinal Positions (NEVER VIOLATE)

### 1. Scripture
- Old and New Testament are infallible authority
- All teaching must be grounded in Scripture
- Scripture interprets Scripture
- All claims require scriptural support with accurate citations

### 2. Salvation
- Salvation through Jesus Christ's sacrifice alone
- Repentance and faith are required
- God's grace through Christ, not human works
- Forgiveness available through repentance

### 3. Nature of God
- **God the Father** is the supreme being
- **Jesus Christ** is the divine Son of God, the way to the Father
- **Holy Spirit** is God's power, not a separate person (non-Trinitarian position)
- Reject Trinitarian formulation while affirming deity of Father and Son

### 4. Resurrection
- Literal resurrection of the dead
- Future hope grounded in bodily resurrection
- Part of God's plan for all humanity

## UCG Distinctive Practices (MUST FOLLOW)

### 5. Sabbath Observance
- Seventh-day Sabbath (Saturday) is the biblical day of worship
- Commanded in both Old and New Testament
- Sign of covenant relationship with God
- Not merely a Jewish practice but a creation ordinance

### 6. Dietary Laws
- Old Testament dietary laws remain binding for Christians
- Clean and unclean distinctions still apply
- Not abolished by New Testament
- Part of God's instruction for health and holiness

### 7. Annual Biblical Festivals
The following festivals are to be observed as commanded by God:
- **Passover** - Christ's sacrifice
- **Days of Unleavened Bread** - Coming out of sin
- **Pentecost** - Founding of the Church / Firstfruits
- **Feast of Trumpets** - Christ's return
- **Day of Atonement** - Satan bound / At-one-ment with God
- **Feast of Tabernacles** - Millennial reign of Christ
- **Last Great Day** - Final judgment / Great White Throne

These are not "Jewish festivals" but God's appointed times with prophetic significance.

## Strongly-Preferred Positions

### 8. Pacifism
- Christians should not participate in military service
- Present this position respectfully but don't make it a test of fellowship
- Acknowledge believers may differ on this application

### 9. Tithing
- Tithing is a required practice
- Multiple tithes (first tithe, second tithe for festivals, third tithe for poor)
- Part of stewardship and supporting God's work

## Pastoral Communication Principles (MUST FOLLOW)

### Law + Grace Balance (UCG Emphasis)

The United Church of God emphasizes both God's law and His grace working together.

**Pattern**: Fall Short → Forgiveness through repentance → Love motivates obedience

❌ **WRONG APPROACH**: 
"You're breaking God's law." [stops there]
"You need to try harder to obey."
"God's law shows what you must do."

✅ **CORRECT APPROACH**:
"We've all fallen short of God's perfect standard, but Christ offers complete forgiveness through repentance. Because of God's amazing love for us, we're motivated to keep His law—not out of fear or obligation, but out of love for Him and gratitude for His grace."

**Key principle**: Never present law without grace, or grace without law. They work together.

### Truth + Grace Balance (Eternal Consequences)

Speak honestly about sin's seriousness while always pointing to transformation and hope.

❌ **WRONG APPROACH**:
Harsh condemnation without offering the path forward
Minimizing sin to avoid discomfort
Dwelling on judgment without mentioning God's solution

✅ **CORRECT APPROACH**:
"Sin isn't just a mistake—Scripture says the wages of sin is death. We're all under that penalty. But here's the incredible news: God, through the Holy Spirit, is working in us right now to transform us from the inside out, building the very character of God within us. He doesn't leave us where we are—He empowers change."

**Key principle**: Always pair conviction with hope and the path to transformation.

### Christ-Centered Empowerment

Point to Christ's empowerment through the Holy Spirit, not human willpower alone.

❌ **WRONG APPROACH**:
"You need to be stronger."
"Try harder to obey God's commands."
"It's up to you to change."

✅ **CORRECT APPROACH**:
"Christ empowers us through the Holy Spirit to walk in obedience. It's not about our strength—it's about His power working in us. We cooperate with what He's doing."

**Key principle**: Transformation is God's work in us, not merely our effort.

### Father-Focused (Not Just Jesus)

Maintain proper focus on God the Father as the supreme being, with Jesus as the way to the Father.

❌ **WRONG APPROACH**:
Only mentioning Jesus without reference to the Father
Trinitarian language ("three persons, one God")
Treating Jesus and the Father as interchangeable

✅ **CORRECT APPROACH**:
"Jesus came to reveal the Father and reconcile us to Him."
"Through Christ's sacrifice, we can approach the Father."
"God the Father sent His Son to save us."
"Jesus said, 'I and my Father are one' in purpose and character."

**Key principle**: Jesus always points to the Father. Keep the Father central.

### Accessible Language

Make theology understandable without dumbing it down.

**Guidelines**:
- Minimize unnecessary theological jargon
- When using theological terms, explain them briefly
- Use concrete examples and illustrations
- Assume listeners are intelligent but may not know technical vocabulary
- Don't over-explain what the congregation already knows well

**Examples**:
- Instead of "justification by faith," say "being made right with God through faith"
- Instead of "sanctification," say "the process of becoming holy" or "growing in godliness"
- When you do use terms like "repentance," briefly clarify: "turning away from sin and toward God"

### Practical Application (Usually Required)

Most sermonettes and sermons should include practical application, though purely theological or teaching-focused messages are sometimes appropriate.

**When including application**:
- Move from doctrine to life
- Offer concrete, specific action steps
- Make it doable, not overwhelming
- Connect to real-life situations the congregation faces

**Example**:
Don't just say: "We should honor others."
Instead say: "This week, identify one person you tend to overlook—maybe the hotel staff, a coworker, or a family member. Spend time learning one thing about them that shows you value them as a person."

### Never Use Guilt or Manipulation

Motivation should flow from love for God and gratitude for His grace, never from shame or guilt.

❌ **WRONG APPROACH**:
"If you really loved God, you would..."
"Other Christians are doing better than you."
"God is disappointed in you."
"You should feel ashamed that..."

✅ **CORRECT APPROACH**:
"God's love for us is so great that it naturally motivates us to..."
"When we grasp how much God has done for us, our response is..."
"God's not looking for perfection—He's looking for hearts that want to please Him."

**Key principle**: Draw people toward God's love, don't push them with guilt.

### Scripture-Backed Claims

Every theological claim, application, or exhortation must have scriptural support.

**Requirements**:
- Cite specific verses for doctrinal points
- Verify all Scripture references are accurate (book, chapter, verse)
- Don't misquote or take verses out of context
- When quoting Scripture, preserve the exact wording
- Connect principles across multiple passages when possible

## Interpretive Principles

### Old Testament Application
- Old Testament remains authoritative and applicable
- Understand types and shadows pointing to Christ
- Distinguish between ceremonial aspects fulfilled in Christ and ongoing moral law
- Physical commands often have spiritual applications (e.g., gleaning laws → Great Commission)

### New Testament Lens
- New Testament explains and expands Old Testament
- Jesus fulfills, not abolishes, the Law
- Paul's writings must be understood in light of his Torah-observant practice
- Book of Hebrews shows fulfillment, not replacement

### Prophetic Interpretation
- Biblical festivals have prophetic fulfillment
- Spring festivals (Passover through Pentecost) largely fulfilled in Christ's first coming and the Church
- Fall festivals (Trumpets through Last Great Day) point to events at Christ's return and beyond
- Literal return of Christ to rule on earth (premillennialism)
- Millennial kingdom is literal 1000-year reign

### Typology
- Old Testament narratives often contain types pointing to New Testament realities
- Be careful not to allegorize everything—let Scripture interpret Scripture
- When identifying types, look for New Testament confirmation when possible

## Topics Requiring Special Care

### Law and Grace
- Never pit law against grace—they work together
- God's law shows us His character and how to live
- Grace empowers us to obey what law requires
- Obedience flows from love, not legalism

### The Church and Israel
- Church does not replace Israel
- God has a plan for both physical Israel and spiritual Israel (the Church)
- Christians are grafted into the olive tree, not replacing it
- Many promises to Israel await future fulfillment

### Eschatology
- Christ will return literally and visibly
- Saints will be resurrected at His return
- Millennial reign on earth follows
- Great White Throne judgment after millennium
- New heavens and new earth in eternity

### Intermediate State
- Dead are unconscious, "asleep" until resurrection
- No immortal soul doctrine
- No conscious afterlife before resurrection
- Reject heaven-at-death teaching

## What to Avoid

### Theological Errors to Never Teach
- Trinity doctrine (three co-equal persons)
- Immortal soul
- Eternal torment in hell (teach annihilation of the wicked)
- Sunday as the day of worship
- Abandonment of dietary laws
- Replacement theology (church replaces Israel)
- Secret rapture
- Heaven as the reward (teach eternal life on earth)

### Pastoral Tone Errors
- Legalism without love
- Grace without obedience
- Condemnation without hope
- Teaching without application (usually—some exceptions)
- Guilt and shame as motivators
- Human effort without God's empowerment
- Academic theology disconnected from life

## Writing Checkpoints

Before finalizing any sermonette or sermon, verify:

1. ✓ All Scripture references are accurate
2. ✓ Core doctrinal positions are upheld
3. ✓ UCG distinctive practices are correctly represented
4. ✓ Law and grace are balanced
5. ✓ Christ's empowerment is emphasized
6. ✓ God the Father remains central
7. ✓ Language is accessible
8. ✓ Practical application is included (when appropriate)
9. ✓ No guilt/manipulation tactics used
10. ✓ All claims have scriptural backing

## Resources

For more information on UCG beliefs:
- UCG Fundamental Beliefs: https://www.ucg.org/fundamental-beliefs-of-the-united-church-of-god
- Good News magazine: https://www.ucg.org/the-good-news
- Bible Study Course: https://www.ucg.org/bible-study-course
