# 创建语音转文本请求
Source: https://docs.siliconflow.cn/cn/api-reference/audio/create-audio-transcriptions

post /audio/transcriptions
Creates an audio transcription.



# 创建文本转语音请求
Source: https://docs.siliconflow.cn/cn/api-reference/audio/create-speech

post /audio/speech
Generate audio from input text. The data generated by the interface is the binary data of the audio, which requires the user to handle it themselves. Reference:https://docs.siliconflow.cn/capabilities/text-to-speech#5



# 删除参考音频
Source: https://docs.siliconflow.cn/cn/api-reference/audio/delete-voice

post /audio/voice/deletions
Delete user-defined voice style



# 上传参考音频
Source: https://docs.siliconflow.cn/cn/api-reference/audio/upload-voice

post /uploads/audio/voice
Upload user-provided voice style, which can be in base64 encoding or file format. Refer to (https://docs.siliconflow.cn/capabilities/text-to-speech#2-2)




# 参考音频列表获取
Source: https://docs.siliconflow.cn/cn/api-reference/audio/voice-list

get /audio/voice/list
Get list of user-defined voice styles



# 取消batch任务
Source: https://docs.siliconflow.cn/cn/api-reference/batch/cancel-batch

post /batches/{batch_id}/cancel
This endpoint cancels a batch identified by its unique ID.



# 创建batch任务
Source: https://docs.siliconflow.cn/cn/api-reference/batch/create-batch

post /batches
Upload files



# 获取batch任务详情
Source: https://docs.siliconflow.cn/cn/api-reference/batch/get-batch

get /batches/{batch_id}
Retrieves a batch.



# 获取batch任务列表
Source: https://docs.siliconflow.cn/cn/api-reference/batch/get-batch-list

get /batches
List your organization's batches.



# 获取文件列表
Source: https://docs.siliconflow.cn/cn/api-reference/batch/get-file-list

get /files
Returns a list of files.



# 上传文件
Source: https://docs.siliconflow.cn/cn/api-reference/batch/upload-file

post /files
Upload files



# 创建对话请求（OpenAI）
Source: https://docs.siliconflow.cn/cn/api-reference/chat-completions/chat-completions

post /chat/completions
Creates a model response for the given chat conversation.



# 创建对话请求（Anthropic）
Source: https://docs.siliconflow.cn/cn/api-reference/chat-completions/messages

post /messages
Creates a model response for the given chat conversation.



# 创建嵌入请求
Source: https://docs.siliconflow.cn/cn/api-reference/embeddings/create-embeddings

post /embeddings
Creates an embedding vector representing the input text.



# 创建图片生成请求
Source: https://docs.siliconflow.cn/cn/api-reference/images/images-generations

post /images/generations
Creates an image response for the given prompt. The URL for the generated image is valid for one hour. Please make sure to download and store it promptly to avoid any issues due to URL expiration.



# 获取用户模型列表
Source: https://docs.siliconflow.cn/cn/api-reference/models/get-model-list

get /models
Retrieve models information.



# 创建重排序请求
Source: https://docs.siliconflow.cn/cn/api-reference/rerank/create-rerank

post /rerank
Creates a rerank request.



# 获取用户账户信息
Source: https://docs.siliconflow.cn/cn/api-reference/userinfo/get-user-info

get /user/info
Get user information including balance and status



# 获取视频生成链接请求
Source: https://docs.siliconflow.cn/cn/api-reference/videos/get_videos_status

post /video/status
Get the user-generated video. The URL for the generated video is valid for one hour. Please make sure to download and store it promptly to avoid any issues due to URL expiration.



# 创建视频生成请求
Source: https://docs.siliconflow.cn/cn/api-reference/videos/videos_submit

post /video/submit
Generate a video through the input prompt. This API returns the user's current request ID. The user needs to poll the status interface to get the specific video link. The generated result is valid for 10 minutes, so please retrieve the video link promptly.



# 实名认证
Source: https://docs.siliconflow.cn/cn/faqs/authentication



## 1. 为什么要进行实名认证？

《中华人民共和国网络安全法》 等法律法规要求：网络运营者为用户办理网络接入，在与用户签订协议或者确认提供服务时，应当要求用户提供真实身份信息。用户不提供真实身份信息的，网络运营者不得为其提供相关服务。

## 2. 如果不进行实名认证，会对账号产生什么影响？

如果不进行实名认证，账号将无法进行以下操作：

* 无法进行“账户充值”
* 无法申请“开具发票”

## 3. 个人实名和企业实名认证有哪些区别？

账号实名认证分为**个人实名认证**和**企业实名认证**两类：

* 个人实名认证：认证类型为个人，支持个人人脸识别认证。
* 企业实名认证：认证类型为企业（含普通企业、政府、事业单位、社会团体组织、个体工商户等），支持法人人脸识别认证、企业对公打款认证两种认证方式。

**实名认证类型对账号的影响：**

1. 影响账号的归属。

* 完成企业实名认证的账号**归属为企业**。
* 完成个人实名认证的账号**归属于个人**。

2. 影响账号的开票信息。

* 企业认证**可以开具企业抬头的增值税专用发票、增值税普通发票**。
* 个人认证**只能开具个人抬头的增值税普通发票**。

【注意事项】

* 实名认证信息对您的账号和资金安全等很重要，请**按实际情况**进行实名认证。
* 为了您的账号安全，企业用户不要进行个人实名认证。
* 当前账号只允许绑定一个认证主体，账号主体变更成功后原主体信息将与账号解绑。

## 4. 如何进行个人认证？

### 4.1 个人认证支持证件类型

个人认证支持证件类型有以下几种：

* 身份证
* 港澳往来大陆通行证（回乡证）
* 台湾往来大陆通行证（台胞证）
* 港澳居民居住证
* 台湾居民居住证
* 外国人永久居留证

不具有以上证件的用户，暂时不支持线上个人认证，可以通过提交[表单](https://siliconflow.feishu.cn/share/base/form/shrcnDiK9EIkGN3sK0PepqN1Ppb?hide_subject_id=1\&hide_passport_id=1\&hide_phone=1\&hide_email=1)的形式跟工作人员沟通。

### 4.2 个人认证流程

1. 登录 SiliconFlow 平台，点击[用户中心-实名认证](https://cloud.siliconflow.cn/account/authentication)。
2. 在实名认证页面，选择认证类型为"个人实名认证"，然后填写个人信息。
3. 使用手机支付宝 App 扫描二维码，扫描后按照手机上的提示完成人脸识别认证，认证成功后，在网页端的弹窗上点击“已完成刷脸认证”。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=34ee153484c9ff73c3270312284f83a6" data-og-width="1016" data-og-height="882" data-path="images/faqs/authentication/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=abd828e994aa1b232fca79e2d3df4321 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bedcd7540c575fea226245f89db73e51 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b825465907e25f51f1918b439979dc7a 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a2ae0a294583973c4978a59e42e5cdee 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=996fbd446917deb534d6f5ed798b0c5a 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/authentication/image.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7cfbf30c1fa81760bcf1efd16040a0b9 2500w" />
</Frame>

4. 认证成功后您可以**修改认证信息**或者**变更为企业用户**，30 天内只可以完成一次变更或修改。

【注意事项】

* 实名认证直接影响账号的归属。如果是企业用户，请您进行企业实名认证，以免人员变动等因素引起的不必要纠纷。更多信息请参见个人实名认证和企业实名认证的区别。
* 根据相关法律法规，我们不对未满 14 周岁的个人提供在线实名认证服务。

## 5. 如何进行企业认证？

1. 登录 SiliconFlow 平台，点击“用户中心-实名认证”。
2. 在实名认证页面，选择认证类型为“企业实名认证”，然后选择认证方式。认证方式有以下两种：

* 选择法人人脸识别认证
  1. 填写企业名称、统一社会信用代码、法人姓名和法人身份证号，勾选同意协议。
  2. 法人使用手机支付宝 App 扫描二维码，扫描后按照手机上的提示完成人脸认证，验证成功即可完成认证。
* 选择企业对公打款认证
  1. 填写企业名称、统一社会信用代码和法人姓名，勾选同意协议。
  2. 填写企业对公银行卡号，填写对公银行（精确到支行）名称，选择具体的开户行，确认无误后点击获取验证金额。
  3. 等待随机打款金额到账，通常在 10 分钟以内。
  4. 打款成功后，请跟财务核实收到的 1 元以下随机金额，将该金额回填到该页面，核实无误后即可认证成功。

认证成功后您可以**修改认证信息**，30 天内只可进行一次修改。


# 错误处理
Source: https://docs.siliconflow.cn/cn/faqs/error-code



**1. 尝试获取 HTTP 错误代码，初步定位问题**

a. 在代码中，尽量把错误码和报错信息（message）打印出来，利用这些信息，可以定位大部分问题。

```shell  theme={null}
HTTP/1.1 400 Bad Request
Date: Thu, 19 Dec 2024 08:39:19 GMT
Content-Type: application/json; charset=utf-8
Content-Length: 87
Connection: keep-alive

{"code":20012,"message":"Model does not exist. Please check it carefully.","data":null}

```

* 常见错误代码及原因：
  * **400**：参数不正确，请参考报错信息（message）修正不合法的请求参数；
  * **401**：API Key 没有正确设置；
  * **403**：账户余额不足或者权限不够，权限不够最常见的原因是该模型需要实名认证，其他情况参考报错信息（message）；
  * **429**：触发了 rate limits；参考报错信息（message）判断触发的是 `RPM /RPD / TPM / TPD / IPM / IPD` 中的具体哪一种，可以参考 [Rate Limits](https://docs.siliconflow.cn/rate-limits/rate-limit-and-upgradation) 了解具体的限流策略
  * **504 / 503**：
    * 一般是服务系统负载比较高，可以稍后尝试；
    * 对于对话和文本转语音请求，可以尝试使用流式输出（"stream" : true），参考 [流式输出](https://docs.siliconflow.cn/faqs/stream-mode)；
  * **500**：服务发生了未知的错误，可以联系相关人员进行排查

<Frame>
  <img width="200" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=eb6524749b708787ab7df150a0ea8a51" data-og-width="580" data-og-height="580" data-path="images/faqs/mic/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e8b97edd223ea80d2a5262155679a4f2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=62158a34066b09967b0546b53b94a07b 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=536a6e5df37b9b807f0d464d0f688109 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e0fcd0745766b2a5c0f6c27ea8335033 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6cd797759f42aab734f7b3f7d5a10d65 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_3.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c7349fcfdd8ffdf8b7db30513f0290a6 2500w" />
</Frame>

b. 如果客户端没有输出相应的信息，可以考虑在命令行下运行 curl 命令 （以 LLM 模型为例）:

```shell  theme={null}
curl --request POST \
   --url https://api.siliconflow.cn/v1/chat/completions \
   --header 'accept: application/json' \
   --header 'authorization: Bearer 改成你的apikey' \
   --header 'content-type: application/json' \
   --data '
{
  "model": "记得改模型",
  "messages": [
    {
      "role": "user",
      "content": "你好"
    }
  ],
  "max_tokens": 128
}' -i
```

**2. 可以尝试换一个模型，看看问题是否依旧**

**3. 如果开了代理，可以考虑将代理关闭后再尝试访问**

<Note> 如遇其他问题，请点击[硅基流动MaaS线上需求收集表](https://siliconflow.feishu.cn/share/base/form/shrcnDiK9EIkGN3sK0PepqN1Ppb?hide_subject_id=1\&hide_passport_id=1\&hide_phone=1\&hide_email=1)反馈。</Note>


# 开具发票
Source: https://docs.siliconflow.cn/cn/faqs/invoice



## 1. 开票主体信息

开票主体：北京硅基流动科技有限公司<br />

## 2. 开票时效性

通常发票会在您申请开票后2个工作日内开具完成

## 3. 开票金额

仅`已消费金额`可以申请开具发票，充值未消费的充值余额不可开具发票，您可酌情申请退款；已开票金额不可重复开票。

## 4. 发票类型

目前平台仅提供数电发票

企业认证用户可以开具企业抬头的增值税专用发票/增值税普通发票；

个人认证只能开具个人抬头的增值税普通发票

## 5. 开票流程

### 5.1 用户自助开票

* 登陆 [SiliconFlow](https://cloud.siliconflow.cn/)，进入到 [开具发票](https://cloud.siliconflow.cn/invoice) 页面
* 点击`申请开票`按钮，
  * 在页面中填入`申请开票金额`
  * 选择`费用名称`
  * 选择`抬头名称和税号`
  * 选择`发票类型`
  * 勾选`发票接收方式`
  * 点击`申请发票`按钮
* 已申请开具的发票会在发票记录中显示，开具成功后`下载`即可

### 5.2 用户登记后，平台开票

根据我国税收相关政策要求，发票抬头需与实名认证主体名称一致，个人账号无法开具机构抬头发票；如有需要，您可以[变更认证主体](https://cloud.siliconflow.cn/account/authentication)；若完成认证确有困难，请通过[开具发票](https://cloud.siliconflow.cn/invoice)页面中的登记页进行登记。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a300480e2fca300d3ec0719dca8a1145" data-og-width="2796" width="2796" data-og-height="466" height="466" data-path="images/faqs/mic/image_invoice.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0714c3975dc28850dd35474392689a18 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bb2e7dfac9d39354e3c34758766eef28 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=003bc743e985c7c6db14b7cc76fdf7ab 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b9daa7d2cab1e184af9772efd76da43b 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=eeb2ce986614fbdb7ef5f81ad2ecde43 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_invoice.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5433ada573ca2b2fff03ebcaac5bbe21 2500w" />
</Frame>


# 上架指南
Source: https://docs.siliconflow.cn/cn/faqs/listing_guide



# 硅基流动AI应用合规上架指南

以下材料适用国家为：中国

## 背景依据

硅基流动 MaaS服务平台面向广大开发者提供相关开源大模型加速框架推理等技术支持，开发者开发的应用/小程序中通过硅基流动 MaaS服务平台接入了DeepSeek、通义千问等系列开源大模型。
若开发者想要将接入了开源大模型的应用或小程序上架到应用市场或小程序平台中，因应用市场或小程序平台的应用场景存在差异，可能需要开发者提供各种相关资料，本篇将基于法律合规要求引导各位开发者如何获取对应资料。

## 📌 关键提示

### 1. 责任提示

#### ⚠️ 行动前必读：

1. 建议您研读《生成式人工智能服务管理暂行办法》原文或咨询法律专家
2. 主动追踪政策变化，定期核验最新要求，并依据业务场景寻求专业法律意见
3. 您需独立承担应用/小程序的全部法律责任

### 2. 平台声明

#### 本文仅提供：

1. 备案材料清单与获取路径
2. 所接入模型的备案信息查询指引
3. 不构成任何法律意见

#### 重要法律定位：

即使使用本站模型服务，您仍是法定“服务提供者”​​，须履行包括：

① 内容审核 ② 用户保护 ③ 数据安全 ④ 标识规范 等全链条义务

<Note>  硅基流动不保证您的小程序或APP 通过该方案可以 100% 通过审核，具体审核规则由对应的审核方负责。硅基流动仅可证明贵方在使用硅基流动的服务。 </Note>

## 需备案的场景：

### 1、微信小程序上架场景

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9911081ba5086bfc6c727b8a6f57ee1a" data-og-width="1128" width="1128" data-og-height="1280" height="1280" data-path="images/faqs/mic/guide/image_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=09931b8a8cac790ce78d9748263dd5a7 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=caa50015c76ea2e9b7555e442bfe357d 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6703db80044edac03cd7eba1771808e8 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=864cecee5011339038766eff50e6b3c4 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4af5b228b339e7b77577df1a96af50ae 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=eebb7fbbd70c5843f0994379817f2d90 2500w" />
</Frame>

## 获取备案信息的操作指引

### 步骤一：查询模型备案号

#### 模型备案主体信息示例：

DeepSeek：

查询地址：[https://beian.cac.gov.cn/#/searchResult](https://beian.cac.gov.cn/#/searchResult)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fbe24e633ec1dcd2044bc1281e3a8576" data-og-width="1280" width="1280" data-og-height="289" height="289" data-path="images/faqs/mic/guide/image_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=11d9dae52e5518ed39a3b7862b37fa68 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=abd1b59c3eddca5ec1ba4d2c328dbeb9 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9fe1fa0e1e09fb04b3732f995c8f15b5 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=da989e9e9d269d311f2dd20a3d5b1fb4 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=43bb92b2e1aa90f1900410cafe4eccc0 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=287ec95b50754fe0fb625b3909cc632e 2500w" />
</Frame>

| 模型名称                  | 备案说明                | 备案号                               | 链接                                                                                                                    |
| --------------------- | ------------------- | --------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| Deepseek Chat         | 生成式人工智能服务备案         | Beijing-DeepseekChat-202404280016 | [https://www.cac.gov.cn/2024-04/02/c\_1713729983803145.htm](https://www.cac.gov.cn/2024-04/02/c_1713729983803145.htm) |
| DeepSeek大语言模型算法       | 深度合成服务算法备案（服务技术支持者） | 网信算备110108970550101240011号        | [https://www.cac.gov.cn/2024-04/11/c\_1714509267496697.htm](https://www.cac.gov.cn/2024-04/11/c_1714509267496697.htm) |
| DeepSeekChat 求索对话生成算法 | 深度合成服务算法备案（服务提供者）   | 网信算备330105747635301240017号        | [https://www.cac.gov.cn/2024-06/12/c\_1719783421546747.htm](https://www.cac.gov.cn/2024-06/12/c_1719783421546747.htm) |

| 大模型  | 算法名称          | 备案主体角色  | 备案主体              | 主要用途                                                           | 备案号                        |
| ---- | ------------- | ------- | ----------------- | -------------------------------------------------------------- | -------------------------- |
| 通义千问 | 达摩院交互式多能型合成算法 | 服务技术支持者 | 阿里巴巴达摩院(杭州)科技有限公司 | 应用于开放域多模态内容生成场景，服务于问答、咨询类的企业端客户，通过API提供根据用户输入生成多模态信息的功能。       | 网信算备330110507206401230035号 |
| 通义万相 | 达摩院图像合成算法     | 服务技术支持者 | 阿里巴巴达摩院(杭州)科技有限公司 | 应用于数字图像处理、计算机视觉、虚拟现实、人工智能等领域，在图像生成、图像增强、图像分割、图像识别等方面具有广泛的应用前景。 | 网信算备330110507206401230027号 |
| 通义万相 | 通义万相视频生成算法    | 服务技术支持者 | 通义云启（杭州）信息技术有限公司  | 应用于视频生成场景，服务于企业端客户，根据用户输入的文本或图像，生成符合广告媒体领域要求的视频。               | 网信算备330106003156001240091号 |

通义千问：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8c56dc766b0db89584a4670a7f3d3629" data-og-width="1280" width="1280" data-og-height="363" height="363" data-path="images/faqs/mic/guide/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f92cad376ffc60acc32db83d65eb2a3e 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3f1771d6dc7958df220a56bb63de6aa7 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2dc6bff8ebd880e027f3925642955808 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=12642b8e986bae640d2976844570fe07 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7e785cb2f24fe3ea365a560b30978514 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2b6461bf7585e2c29719cb2ab3e0d930 2500w" />
</Frame>

### 步骤二：获取合作协议

#### 合作协议获取流程：

1. 确保您的账号完成了企业实名认证：认证链接：[https://cloud.siliconflow.cn/account/authentication](https://cloud.siliconflow.cn/account/authentication)
2. 添加我们企微客服：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=46063815ae995279ac25e87c2c2c4395" data-og-width="396" width="396" data-og-height="396" height="396" data-path="images/faqs/mic/guide/image_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=82d3e866a347a455f271748cee4b03f0 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3c52e05cdd759081942c1656b7a759f0 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=89d263e9256b6e347ce9ebd8b25379b1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=62eeb68d4777902298126bf1edb2c370 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5a5439f7122d7300a2906be37cdfdfb0 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3be52a3dc590860972561292164c46f5 2500w" />
</Frame>

3. 按照客服指引填写表单，我们将在 5 个工作日内提供相关合作协议电子签约版本。

#### 需要注意：

1. 您的小程序/应用主体名称，需要和签订合作协议以及硅基流动账号实名认证企业为同一个，不进行硅基流动企业实名认证则无法提供相应协议。
2. 准确填写您的小程序应用场景和应用模型，将有助于您通过审核。

#### 主要法律依据：

1. 《生成式人工智能服务管理暂行办法》

   [https://www.moj.gov.cn/pub/sfbgw/flfggz/flfggzbmgz/202401/t20240109\_493171.html](https://www.moj.gov.cn/pub/sfbgw/flfggz/flfggzbmgz/202401/t20240109_493171.html)

2. 《具有舆论属性或社会动员能力的互联网信息服务安全评估规定》

   [https://www.gov.cn/zhengce/zhengceku/2018-11/30/content\_5457763.htm](https://www.gov.cn/zhengce/zhengceku/2018-11/30/content_5457763.htm)

3. 《互联网信息服务算法推荐管理规定》

   [https://www.gov.cn/zhengce/zhengceku/2022-01/04/content\_5666429.htm](https://www.gov.cn/zhengce/zhengceku/2022-01/04/content_5666429.htm)


# 模型问题
Source: https://docs.siliconflow.cn/cn/faqs/misc



## 1. 模型输出乱码

目前看到部分模型在不设置参数的情况下，容易出现乱码，遇到上述情况，可以尝试设置`temperature`，`top_k`，`top_p`，`frequency_penalty`这些参数。

对应的 payload 修改为如下形式，不同语言酌情调整

```python  theme={null}
    payload = {
        "model": "Qwen/Qwen2.5-Math-72B-Instruct",
        "messages": [
            {
                "role": "user",
                "content": "1+1=?",
            }
        ],
        "max_tokens": 200,  # 按需添加
        "temperature": 0.7, # 按需添加
        "top_k": 50,        # 按需添加
        "top_p": 0.7,       # 按需添加
        "frequency_penalty": 0 # 按需添加
    }
```

## 2. 关于`max_tokens`说明

max\_tokens 与`上下文长度`相等，由于部分模型推理服务尚在更新中，请不要在请求时将 max\_tokens 设置为最大值（上下文长度），建议留出 10k 左右作为输入内容的空间。

## 3. 关于`context_length`说明

不同的LLM模型，`context_length`是有差别的，具体可以在[模型广场](https://cloud.siliconflow.cn/models)上搜索对应的模型，查看模型具体信息。

## 4. Pro 和非 Pro 模型有什么区别

1. 对于部分模型，平台同时提供免费版和收费版。免费版按原名称命名；收费版在名称前加上“Pro/”以示区分。免费版的 Rate Limits 固定，收费版的 Rate Limits 可变，具体规则请参考：[Rate Limits](https://docs.siliconflow.cn/cn/userguide/rate-limits/rate-limit-and-upgradation)。

2. 对于 `DeepSeek R1` 和 `DeepSeek V3` 模型，平台根据`支付方式`的不同要求区分命名。`Pro 版`仅支持`充值余额`支付，`非 Pro 版`支持`赠费余额`和`充值余额`支付。

## 5. 语音模型中，对用户自定义音色有时间音质要求么

* cosyvoice2 上传音色必须小于30s

## 6. 模型输出截断问题

可以从以下几方面进行问题的排查：

* 通过API请求时候，输出截断问题排查：
  * max\_tokens设置：max\_token设置到合适值，输出大于max\_token的情况下，会被截断。
  * 设置流式输出请求：非流式请求时候，输出内容比较长的情况下，容易出现504超时。
  * 设置客户端超时时间：把客户端超时时间设置大一些，防止未输出完成，达到客户端超时时间被截断。
* 通过第三方客户端请求，输出截断问题排查：
  * CherryStdio 默认的 max\_tokens 是 4096，用户可以通过设置，打开“开启消息长度限制”的开关，将max\_token设置到合适值

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b77a496c600c494ff27b8f1c6203bb5d" data-og-width="2126" data-og-height="1324" data-path="images/faqs/mic/image_5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ed7d0698216adf85842b12f357c55053 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=64487aefdf2a783e6748ddc6ace9134a 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=175aff66b443fec3f909995629e9c4da 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=07de4aecf2d7bc13f0dbeefad8d84beb 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c50064e5887225d8e47f593f1c23f09b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bbf19aa1ef2119ec830c2a0fceeb9a29 2500w" />
</Frame>

## 7. 模型使用过程中返回429错误排查

可以从以下几方面进行问题的排查：

* 普通用户：检查用户等级及模型对应的 Rate Limits（速率限制）。如果请求超出 Rate Limits，建议稍后再尝试请求。
* 专属实例用户：专属实例通常没有 Rate Limits 限制。如果出现 429 错误，首先确认是否调用了专属实例的正确模型名称，并检查使用的 api\_key 是否与专属实例匹配。

## 8. 已充值成功，仍然提示账户余额不足

可以从以下几方面进行问题的排查：

* 确认使用的 api\_key 是否与刚刚充值的账户匹配。
* 如果 api\_key 无误，可能是充值过程中存在网络延迟，建议等待几分钟后再重试。

## 9. 已实名认证，还是无法访问部分模型

可以从以下几方面进行问题的排查：

* 确认使用的 api\_key 是否与刚刚完成实名认证的账户匹配。
* 如果 api\_key 无误，可以进入[实名认证](https://cloud.siliconflow.cn/account/authentication)页面，检查认证状态。如果状态显示为“认证中”，可以尝试取消并重新进行认证。

## 10. fnlp/MOSS-TTSD-v0.5 使用问题

* 该模型输入的文字过短时候，容易出现错误
* 使用该模型进行对话合成时，输入文案格式如下：
  * \[S1]发言人1说话内容。\[S2]发言人2说话内容。

<Note> 如遇其他问题，请点击[硅基流动MaaS线上需求收集表](https://siliconflow.feishu.cn/share/base/form/shrcnDiK9EIkGN3sK0PepqN1Ppb?hide_subject_id=1\&hide_passport_id=1\&hide_phone=1\&hide_email=1)反馈。</Note>


# 财务问题
Source: https://docs.siliconflow.cn/cn/faqs/misc_finance



## 1. 如何充值

1. 电脑端登录 [SiliconFlow](https://cloud.siliconflow.cn/) 官网。
2. 点击左侧边栏 “[实名认证](https://cloud.siliconflow.cn/account/authentication)” 进行认证。
3. 点击左侧边栏 “[余额充值](https://cloud.siliconflow.cn/expensebill)” 进行充值。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=dd836581e1c7d50676906e1665748d40" data-og-width="3028" data-og-height="1872" data-path="images/faqs/mic/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1f0926f8e5d39dfc7ed21e0a6204a483 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2407e85187d5c2d4b2f171cdd8a03190 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f16dded13fdb27e8007aac19e011fad1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8222844a4b593e544ecde9f93c642b13 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=285e9d041b7b4e010a2d5ccc524a3080 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=30a68b2ca59fe4589a06ddbf9b82c68e 2500w" />
</Frame>

## 2. 如何查询使用账单

1. 电脑端登录 [SiliconFlow](https://cloud.siliconflow.cn/) 官网。
2. 点击左侧边栏 “[费用账单](https://cloud.siliconflow.cn/bills)” 了解。<br />
   如您需要开发票，请根据 [开具发票](https://docs.siliconflow.cn/faqs/invoice) 发邮件，我们会根据您的实际消耗费用开发票。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=81c798c69a5c1ff739fc24829a90e12f" data-og-width="3028" data-og-height="1868" data-path="images/faqs/mic/image_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=098e0f7e2c459809313c70ee9243eaa2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c634a9e4212906a0cba02929b5f00937 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=31bb37ffa599df49d215d98d0eddc852 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0af1ffc7b9e35ec89ec3a599eda64d9a 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e86dfc7b19874320e78c2ba931fe256a 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_1.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bbc15ac5f98c4f772530f194d7bdc729 2500w" />
</Frame>

## 3. 模型微调的计费规则

模型微调功能会按照训练和推理两个不同场景独立计费。
费用查看路径：[模型微调](https://cloud.siliconflow.cn/fine-tune) - 新建微调任务，选择所需的“基础模型”后，页面会显示对应的“微调训练价格”和“微调推理价格”。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=365f548024d5a78588f8e85f78366d47" data-og-width="1280" data-og-height="425" data-path="images/faqs/mic/image_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3577f7cbc1321bb23c04b09c72a512d9 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1f2f20369fff0dea24e019c90a835570 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2529eb9bba9b69ec9e41fe2a6822769c 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9f524cbe89dc422f6d9bef58085d4aee 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2c85106d14b4e2c699ef4954747be5d6 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_4.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4c61207f4bf22f0b70ef27c7b7fefc40 2500w" />
</Frame>

<Note> 如遇其他问题，请点击[硅基流动MaaS线上需求收集表](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1)反馈。</Note>


# Rate Limits 问题
Source: https://docs.siliconflow.cn/cn/faqs/misc_rate



## 1. 免费模型如何提升 Rate Limits

* 所有免费模型的 Rate Limits 是固定的。<br />
* 对于部分模型，平台同时提供免费版和收费版。免费版按照原名称命名；收费版会在名称前加上“Pro/”以示区分。<br />
* 收费版模型支持通过月消费金额解锁更宽松的 Rate Limits。
* 对于 `DeepSeek R1` 、 `DeepSeek V3`及`DeepSeek-V3.1-Terminus` 模型，Rate Limits 是固定的。

<Note> 如遇其他问题，请点击[硅基流动MaaS线上需求收集表](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd17aubjk20jc73ada8ng)反馈。</Note>


# 使用问题
Source: https://docs.siliconflow.cn/cn/faqs/misc_use



## 1. 如何注销账号

请进入[个人中心](https://account.siliconflow.cn/zh/user/settings)页面，点击“申请注销”，填写注销账号申请。核实后将在 15 个工作日内处理。

<Frame>
  <img width="300" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=671a42ee7cb4ed0f36bb9814ad69410e" data-og-width="1567" data-og-height="1755" data-path="images/faqs/mic/image_6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8afde51eb8c56c46678c39323f83b5d7 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2dd20705d87c5db34508504c45299659 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1bcb16a804f492d430ab598dfd502fb0 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1a69815d8f2cc7a24ac48cdc9b6c7231 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=02d20f164214912e9f16fcf056408d31 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_6.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1ed17dc848bae7726a87339346121e78 2500w" />
</Frame>

## 2. 如何邀请

1. 电脑端登录 [SiliconFlow](https://cloud.siliconflow.cn/) 官网。
2. 点击左侧边栏 “[我的邀请](https://cloud.siliconflow.cn/invitation)” — “复制邀请链接”。
3. 分享邀请信息。
4. 邀请成功的具体信息会显示在 “[我的邀请](https://cloud.siliconflow.cn/invitation)”页面。

有三种邀请方式供选择：二维码、邀请码和邀请链接。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7c7847a00fa4943ab77a0bab0c178fb3" data-og-width="3036" data-og-height="1856" data-path="images/faqs/mic/image_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=aa6a7cfea1b6b7c93ef0ec7eaee79711 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a4bdd4a793eb4a9c96cd0d32c6aed528 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=cdecc0d022f02763e30c0d060e90c4c9 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a538894a580e3ef869d095802dee82b9 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=18169ebd6d2d6717eea3927fe10bd9ed 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_2.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fd9bb0a45b5e048bf6c8b6613d9ec7ad 2500w" />
</Frame>

## 3. 为什么我的手机号无法注册或绑定？

为保障平台用户的账户安全与服务体验，平台对部分可能存在安全风险的手机号号段（如部分虚拟运营商号段）做了注册与绑定限制。此举旨在为您提供更加安全、稳定的服务环境，降低因恶意行为对正常使用可能带来的干扰和影响。

建议您使用中国大陆常见运营商（如中国移动、中国联通、中国电信）所提供的常规手机号进行注册或绑定操作。

如您使用的是正规手机号但仍出现提示，可添加小助手微信，我们将及时协助您解决。

<Frame>
  <img width="200" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a4c1ce150c1c18f138c000c8ed184003" data-og-width="576" data-og-height="576" data-path="images/faqs/mic/assistant.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1c470fff760728074ee0df4c3fca33c2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a9d07d18316b904b10f6723a39d189be 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ea80fee38557c6dc4d579a00b8a703af 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=27e4243e702f8348f9683b271201e7a1 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3970fecabeb7f82e1401e56bb0bbd711 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/assistant.jpeg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=90240e9fcc1a899922d5b85725bd2695 2500w" />
</Frame>

## 4. 为什么无法进行 Google / GitHub 关联登录了？

为了提升账户安全性，硅基流动中文站已于近期下线 Google / GitHub 的关联登录功能。
如您已绑定手机号，仍可通过手机登录；或使用“邮箱登录”功能，输入您的 Google / GitHub 邮箱地址接收验证码完成登录。

<Note> 如遇其他问题，请点击[硅基流动工单系统](https://siliconflow.feishu.cn/share/base/form/shrcnDiK9EIkGN3sK0PepqN1Ppb?hide_subject_id=1\&hide_passport_id=1\&hide_phone=1\&hide_email=1)反馈。</Note>


# 流式输出
Source: https://docs.siliconflow.cn/cn/faqs/stream-mode



## 1. 在 python 中使用流式输出

### 1.1 基于 OpenAI 库的流式输出

在一般场景中，推荐您使用 OpenAI 的库进行流式输出。

```python  theme={null}
from openai import OpenAI

client = OpenAI(
    base_url='https://api.siliconflow.cn/v1',
    api_key='your-api-key'
)

# 发送带有流式输出的请求
response = client.chat.completions.create(
    model="deepseek-ai/DeepSeek-V2.5",
    messages=[
        {"role": "user", "content": "SiliconFlow公测上线，每用户送3亿token 解锁开源大模型创新能力。对于整个大模型应用领域带来哪些改变？"}
    ],
    stream=True  # 启用流式输出
)

# 逐步接收并处理响应
for chunk in response:
    if not chunk.choices:
        continue
    if chunk.choices[0].delta.content:
        print(chunk.choices[0].delta.content, end="", flush=True)
    if chunk.choices[0].delta.reasoning_content:
        print(chunk.choices[0].delta.reasoning_content, end="", flush=True)
```

### 1.2 基于 requests 库的流式输出

如果您有非 openai 的场景，如您需要基于 request 库使用 SiliconFlow API，请您注意：
除了 payload 中的 stream 需要设置外，request 请求的参数也需要设置stream = True, 才能正常按照 stream 模式进行返回。

```python  theme={null}
from openai import OpenAI
import requests
import json
   
url = "https://api.siliconflow.cn/v1/chat/completions"
   
payload = {
        "model": "deepseek-ai/DeepSeek-V2.5", # 替换成你的模型
        "messages": [
            {
                "role": "user",
                "content": "SiliconFlow公测上线，每用户送3亿token 解锁开源大模型创新能力。对于整个大模型应用领域带来哪些改变？"
            }
        ],
        "stream": True # 此处需要设置为stream模式
}

headers = {
        "accept": "application/json",
        "content-type": "application/json",
        "authorization": "Bearer your-api-key"
    }
   
response = requests.post(url, json=payload, headers=headers, stream=True) # 此处request需要指定stream模式
# 打印流式返回信息
if response.status_code == 200:
    full_content = ""
    full_reasoning_content = ""

    for chunk in response.iter_lines():
        if chunk:
            chunk_str = chunk.decode('utf-8').replace('data: ', '')
            if chunk_str != "[DONE]":
                chunk_data = json.loads(chunk_str)
                delta = chunk_data['choices'][0].get('delta', {})
                content = delta.get('content', '')
                reasoning_content = delta.get('reasoning_content', '')
                if content:
                    print(content, end="", flush=True)
                    full_content += content
                if reasoning_content:
                    print(reasoning_content, end="", flush=True)
                    full_reasoning_content += reasoning_content
else:
    print(f"请求失败，状态码：{response.status_code}")

```

## 2. curl 中使用流式输出

curl 命令的处理机制默认情况下，curl 会缓冲输出流，所以即使服务器分块（chunk）发送数据，也需要等缓冲区填满或连接关闭后才看到内容。传入 `-N`（或 `--no-buffer`）选项，可以禁止此缓冲，让数据块立即打印到终端，从而实现流式输出。

```bash  theme={null}
curl -N -s \
  --request POST \
  --url https://api.siliconflow.cn/v1/chat/completions \
  --header 'Authorization: Bearer token' \
  --header 'Content-Type: application/json' \
  --data '{
    "model": "Qwen/Qwen2.5-72B-Instruct",
    "messages": [
      {"role":"user","content":"有诺贝尔数学奖吗？"}
    ],
    "stream": true
}'
```


# 用户协议
Source: https://docs.siliconflow.cn/cn/legals/terms-of-service

更新日期：2025.10.11

这是您与北京硅基流动科技有限公司及其关联方（**“硅基流动”**或**“我们”**）之间的协议（**“本协议”**），您确认：在您开始试用或购买我们 SiliconFlow 平台（**本平台**）的产品或服务前，您已充分阅读、理解并接受本协议的全部内容，一旦您选择“同意”并开始使用本服务或完成购买流程，即表示您同意遵循本协议以及我们未来随时对本协议做出的修改或补充内容之所有约定。不具备前述条件的，您应立即终止注册或停止使用本服务。如您与我们已就您使用本平台服务事宜另行签订其他法律文件，则本协议与该等法律文件冲突的部分对您不适用。**另本平台的详细数据使用政策请见《隐私政策》。**

## 1. 账户管理

**1.1** 您保证自身具有法律规定的完全民事权利能力和民事行为能力，是能够独立承担民事责任的自然人或法人或您是未成年人已经获得监护人同意；本协议内容不会被您所属国家或地区的法律禁止。

**1.2 账户**<br />
1.2.1 在您按照本平台的要求填写相关信息并确认同意履行本协议的内容后，我们为您注册账户并开通本平台的使用权限，您的账户仅限您本人使用并使您能够访问某些服务和功能，我们可能根据我们的独立判断不时地修改和维护这些服务和功能。<br />

1.2.2 个人可代表公司或其他实体访问和使用本平台，在这种情况下，本协议不仅在我们与该个人之间的产生效力，亦在我们与该等公司或实体之间产生效力。<br />

1.2.3 如果您通过第三方连接/访问本服务，即表明允许我们访问和使用您的信息，并存储您的登录凭据和访问令牌。<br />

1.2.4 账户安全。当您创建帐户时，您有权使用您设置或确认的手机号码及您设置的密码登录本平台。我们建议您使用强密码（由大小写字母、数字和符号组合而成的密码）来保护您的帐户。您的账户由您自行设置并由您保管，本平台在任何时候均不会主动要求您提供您的账户密码。因此，建议您务必保管好您的账户，若账户因您主动泄露或因您遭受他人攻击、诈骗等行为导致的损失及后果，本平台不承担责任，您应通过司法、行政等救济途径向侵权行为人追偿。您向我们提供您的电子邮件地址作为您的有效联系方式，即表明您同意我们使用该电子邮件地址向您发送相关通知，请您务必及时关注。

1.2.5 您设置的账号名称不得违反国家法律法规、公序良俗、社会公德、或容易引起您与本平台身份的混淆，否则将可能导致您的账号注册不成功或我们有权经通知您后予以注销。

1.2.6 同一用户只能注册并绑定一个账号。您注册成功的账号仅可供您自用。除我们双方另有其他约定，您不得以任何形式赠与、借用、出租、转让、售卖或以其他方式许可第三方使用您的账号。如果本平台发现或者有合理理由认为使用者并非账号初始注册人，为保障账号安全，我们有权立即暂停或终止向该注册账号提供服务，并有权永久禁用该账号。

1.2.7 账户删除。您应通过本平台指定的方式提交账号注销申请，并按照系统提示填写相关信息，包括但不限于账号ID、注册手机号、注销原因等，以便本平台核实身份。如审核通过，本平台将通过短信向您发送账号注销通知；如审核不通过，本平台将通过短信告知您原因。自账号注销通知送达您之日起，您将无法再登录并使用该账号，账号相关的所有权益立即终止。账号注销后，本平台将按照法律法规的要求对您在平台留存的信息进行删除，但法律法规另有规定或双方另有约定的除外。

1.2.8 本平台及相关服务的适用范围如下：

(a) 相关服务的适用人群：服务适用于所有使用相关服务的人群，包括成年人、未成年人等群体，未区分特定适用人群。如涉及未成年人使用，公司在本协议中设置了专门的未成年人条款，督促未成年人按照要求使用本服务。<br />
(b) 适用场合是：服务适用于面向开发者的内容生成服务场合，不适用于自动控制、医疗信息服务、心理咨询和关键信息基础设施的场合。<br />
(c) 服务范围是：服务未限定特定领域，基于硅基流动推理框架技术，通过网页或 API 为开发者提供快捷、高效的通用内容生成服务。<br />

**1.3** 变更、暂停和终止。我们在尽最大努力以本平台公告、站内信、邮件或短信等一种或多种方式进行事先通知的情况下，可以变更、暂停或终止向您提供服务，或对服务设置使用限制，而无需承担责任。可以在任何时候停用您的帐户。即便您的账户因任何原因而终止后，您将继续受本协议的约束。

**1.4** 在法律有明确规定要求的情况下，本平台作为平台服务提供者若必须对用户的信息进行核实的情况下，本平台将依法不时地对您的信息进行检查核实，您应当配合提供最新、真实、完整、有效的信息。若本平台无法依据您提供的信息进行核验时，本平台有权向您发出询问或要求整改的通知，并要求您进行重新认证，直至中止、终止对您提供部分或全部平台服务，本平台对此不承担任何责任。

**1.5** 您应当为自己与其他用户之间的交互、互动、交流、沟通负责。我们保留监督您与其他用户之间争议的权利。我们不因您与其他用户之间的互动以及任何用户的作为或不作为而承担任何责任，包括与**交互数据**（定义见下文）相关的责任。

## 2. 访问服务及服务限制

**2.1** 访问服务。在您遵守本协议的前提下，您在此被授予非排他性的、不可转让的访问和使用本服务的权利，仅用于您个人使用或您代表的公司或其他实体内部业务目的。我们保留本协议中未明确授予的所有权利。

**2.2** 服务限制 <br />
2.2.1 对服务的任何部分进行反汇编、反向工程、解码或反编译；<br />
2.2.2 未经我们事先书面同意，购买、出售或转让API密钥；<br />
2.2.3 复制、出租、出售、贷款、转让、许可或意图转授、转售、分发、修改本服务任何部分或我们的任何**知识产权**（定义见下文）；<br />
2.2.4 采取可能对我们的服务器、基础设施等造成不合理的巨大负荷的任何行为；<br />
**2.2.5** 以下列任何方式或目的使用本平台服务：**(a)反对宪法所确定的基本原则的;(b)危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的；(c)损害国家荣誉和利益的;(iv)煽动地域歧视、地域仇恨的；(d)煽动民族仇恨、民族歧视，破坏民族团结的；(e)破坏国家宗教政策，宣扬邪教和封建迷信的；(f)散布谣言，扰乱社会秩序，破坏社会稳定的；(g)散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的；(h)侮辱或者诽谤他人，侵害他人合法权益的；(i)煽动非法集会、结社、游行、示威、聚众扰乱社会秩序的；(j)以非法民间组织名义活动的；(k)有可能涉及版权纠纷的非本人作品的；(l)有可能侵犯他人在先权利的；(m)对他人进行暴力恐吓、威胁，实施人肉搜索的；(n)涉及他人隐私、个人信息或资料的；(o)侵犯他人隐私权、名誉权、肖像权、知识产权等合法权益内容的；(p) 侵害未成年人合法权益或者损害未成年人身心健康的；(q)未获他人允许，偷拍、偷录他人，侵害他人合法权利的；(r)违反法律法规底线、社会主义制度底线、国家利益底线、公民合法权益底线、社会公共秩序底线、道德风尚底线和信息真实性底线的“七条底线”要求的；(s)相关法律、行政法规等禁止的。**<br />
2.2.6 绕开我们可能用于阻止或限制访问服务的措施，包括但不限于阻止或限制使用或复制任何内容或限制使用服务或其任何部分的功能；<br />
2.2.7 试图干扰、破坏运行服务的服务器的系统完整性或安全性，或破译与运行服务的服务器之间的任何传输；<br />
2.2.8 使用本服务发送垃圾邮件、连锁信或其他未经请求的电子邮件；<br />
2.2.9 通过本服务传输违法数据、病毒或其他软件代理；<br />
2.2.10 冒充他人或实体，歪曲您与某人或实体的关系，隐藏或试图隐藏您的身份，或以其他方式为任何侵入性或欺诈性目的使用本服务；<br />
2.2.11 从本服务收集或获取包括但不限于其他用户姓名在内的任何个人信息。<br />
2.2.12 其他未经我们明示授权的行为或可能损害我们利益的使用方式。<br />

## 3. 交互数据

**3.1** 本服务可能允许用户在注册后，基于平台使用目的在使用模型过程中与开源模型、第三方网站、软件、应用程序或服务之间进行输入、反馈、修正、加工、存储、上传、下载、分发相关个人资料信息、视频、图像、音频、评论、问题和其他内容、文件、数据和信息（**“交互数据”**）。**本平台就详细数据使用政策请见本平台的《隐私政策》。**

**3.2** 如交互数据存在任何违反法律法规或本协议的情况，我们有权利删除或停止技术服务。

**3.3** 关于您的交互数据，您确认、声明并保证：

3.3.1 在我们要求时，您能提供交互数据中包含的个人信息或需要获得授权后才能使用的信息的来源及其合法性提供书面说明或授权；如您超出授权范围或期限时，您应自行负责获得授权范围的扩大或延期。

3.3.2 您的交互数据，以及我们根据本协议对交互数据的使用，不会违反任何适用法律或侵犯任何第三方的任何权利，包括但不限于任何知识产权和隐私权；

3.3.3 您的交互数据不包括任何被政府机构视为敏感或保密的信息或材料，且您就本服务提供的交互数据不侵犯任何第三方的任何保密权利；

3.3.4 您不会上传或通过本服务直接或通过其他方式提供14岁以下儿童的任何个人信息；

3.3.5 您的交互数据不包括裸体或其他性暗示内容；不包括对个人或团体的仇恨言论、威胁或直接攻击；不包括辱骂、骚扰、侵权、诽谤、低俗、淫秽或侵犯他人隐私的内容；不包括性别歧视或种族、民族或其他歧视性内容；不包括含有自残或过度暴力的内容；不包括伪造或冒名顶替的档案；不包括非法内容或助长有害或非法活动的内容；不包括恶意程式或程式码；不包括未经本人同意的任何人的个人信息；不包括垃圾邮件、机器生成的内容或未经请求的信息及其他令人反感的内容；

**3.4 本平台作为独立的技术支持者对您利用本平台接入大模型所产生的全部交互数据不享有任何知产产权。您利用本平台接入大模型所产生的全部交互数据及义务和责任均由您承担，本平台不对由此造成的任何损失负责。**

**3.5 本平台作为独立的技术支持者，您利用本平台向任何第三方提供服务，相应的权利义务和责任均由您承担，本平台不对由此造成的任何损失负责。**

**3.6 免责声明。**

**3.6.1 我们对任何交互数据概不负责。您将对您输入、反馈、修正、加工、存储、上传、下载、分发在本平台及模型服务上的交互数据负责并承担全部责任。本平台提供的技术服务只会严格执行您的指示处理您的交互数据，除非法律法规另有规定、依据特定产品规则另行约定或基于您的要求为您提供技术协助进行故障排除或解决技术问题，我们不会访问您的交互数据，您理解并认同我们及本平台只是作为交互数据的被动技术支持者或渠道。我们及本平台不会对您的交互数据进行任何非授权的使用或披露，同时亦不会进行任何存储。**

**3.6.2 请您理解并认同，我们将依据《人工智能生成合成内容标识办法》等相关法律法规要求，对人工智能生成合成内容添加相应的标识。您不得对上述标识（无论该标识以何种形式体现）进行恶意删除、篡改、伪造、隐匿，不得使用上述标识进行非法活动或发布违法内容。在特定场景下，为更好地满足您的使用需求，我们可能为您提供未添加显式标识的AI生成合成内容的选项。若您申请该选项，请您承诺并保证：(a)不利用该内容从事传播虚假信息或其他违法活动；(b)您在发布或传播利用基于深度学习、虚拟现实、生成式人工智能等新技术新应用制作的非真实信息到相关平台时，或其他可能导致公众混淆或误认的信息内容时，应当以显著方式予以标识；(c)在向第三方分享该内容或使用网络信息内容传播服务发布该内容时，主动声明其为AI生成内容；(d)遵守其他相关法律法规提出的要求。由于您违反本协议使用标识给我们或他人造成损失的，由您承担全部法律责任。**

## 4. 知识产权

**4.1** 定义。就本协议而言，“知识产权”系指所有专利权、著作权、精神权利、人格权、商标权、商誉、商业秘密权、技术、信息、资料等，以及任何可能存在或未来可能存在的知识产权和所有权，以及根据适用法律提出的所有申请中、已注册、续期的知识产权。

**4.2** 硅基流动知识产权。您理解并承认，我们拥有并将持续拥有本平台及本平台所提供服务的所有权利（包括知识产权），您不得访问、出售、许可、出租、修改、分发、复制、传输、展示、发布、改编、编辑或创建任何该等知识产权的衍生作品。严禁将任何知识产权用于本协议未明确许可的任何目的。本协议中未明确授予您的权利将由硅基流动保留。

**4.3** 输出。在您遵守如下事项且在合法合规的基础上，可以将大模型产出的结果进行符合法律要求使用：（a）您对服务和输出的使用不会转移或侵犯任何知识产权（包括不会侵犯硅基流动知识产权和其他第三方知识产权）；（b）如果我们酌情认为您对输出的使用违反法律法规或可能侵犯任何第三方的权利，我们可以随时限制您对输出的使用并要求您停止使用输出（并删除其任何副本）；（c）您不得表示大模型的输出结果是人为生成的并需要依据相关法律规定履行相应标识义务；（d）您不得违反任何模型提供商的授权许可、使用限制及知识产权相关约定。

您同意，我们不对您或任何第三方声称因由我们提供的技术服务而产生的任何输出内容或结果承担任何责任。

**4.4** 用户使用数据。我们可能会收集或您可能向我们提供诊断、技术、使用的相关信息，包括有关您的计算机、移动设备、系统和软件的信息（**“用户使用数据”**）。我们可能出于平台维护运营的需要，且在法律许可的范围内使用、维护和处理用户使用数据或其中的任何部分，包括但不限于：（a）提供和维护平台服务；（b）改进我们的产品和服务或开发新的产品或服务<sup><a href="#fn1" id="ref1">1</a></sup>。**详细数据使用政策请见本平台的《隐私政策》**。

**4.5** 反馈。 如果您向我们提供有关本服务或任何其他硅基流动产品或服务的任何建议或反馈（“反馈”），则您在此将所有对反馈的权益转让给我们，我们可自由使用反馈以及反馈中包含的任何想法、专有技术、概念、技术和知识产权。反馈被视为我们的**保密信息**（定义如下）。

## 5. 保密信息

本服务可能包括硅基流动和其他用户的非公开、专有或保密信息（“保密信息”）。保密信息包括任何根据信息的性质和披露情况应被合理理解为保密的信息，包括非公开的商业、产品、技术和营销信息。您将：（a）至少以与您保护自己高度敏感的信息相同的谨慎程度保护所有保密信息的隐私性，但在任何情况下都不得低于合理的谨慎程度；（b）除行使您在本协议下的权利或履行您的义务外，不得将任何保密信息用于任何目的；以及（c）不向任何个人或实体披露任何保密信息。

## 6. 计费政策及税费

您理解并同意，本平台提供的部分服务可能会收取使用费用、售后费用或其他费用（**“费用”**）。您通过选择使用本服务即表示您同意您注册网站上载明的适用于您的定价和付款条款（受限于我们的不时更新的定价/付款条件/充值协议等文件），您同意我们相应监控您的使用数据以便完成本服务计费。定价、付款条件和充值协议特此通过引用并入本协议。您同意，我们可能会添加新产品和/或服务的额外费用、增加或修改现有产品和/或服务的费用，我们可能会按照您的实际使用地点设定不同的价格费用，和/或停止随时提供任何服务。未经我们书面同意或本平台有其他相关政策，付款义务一旦发生不可取消，并且已支付的费用不予退还。如存在任何政府要求的税费，您将负责支付与您的所有使用/开通服务相关的税款。

## 7. 隐私与数据安全

**7.1** 隐私。基于您注册以及开通本平台相关服务时主动提供给本平台的相关注册信息（**“用户信息”**），且为了确保您正常使用本平台的相关服务，我们可能对您提供的用户信息进行收集、整理、使用，但我们将持续遵守《中华人民共和国个人信息保护法》及相关适用法律。

**7.2** 数据安全。我们关心您个人信息的完整性和安全性，然而，我们不能保证未经授权的第三方永远无法破坏我们的安全保护措施。

## 8. 使用第三方服务

本服务可能包含非我们拥有或控制的第三方网站、资料和服务（**“第三方服务”**）的链接，本服务的某些功能可能需要您使用第三方服务。我们不为任何第三方服务背书或承担任何责任。如果您通过本服务访问第三方服务或在任何第三方服务上共享您的交互数据，您将自行承担风险，并且您理解本协议不适用于您对任何第三方服务的使用。您明确免除我们因您访问和使用任何第三方服务而产生的所有责任。

## 9. 赔偿

您将为我们及我们的子公司和关联公司及各自的代理商、供应商、许可方、员工、承包商、管理人员和董事（“硅基流动受偿方”）进行辩护、赔偿并使其免受因以下原因而产生的任何和所有索赔、损害（无论是直接的、间接的、偶然的、后续的或其他的）、义务、损失、负债、成本、债务和费用（包括但不限于法律费用）的损害：（a）您访问和使用本服务，包括您对任何输出的使用；（b）您违反本协议的任何条款，包括但不限于您违反本协议中规定的任何陈述和保证；（c）您对任何第三方权利的侵犯，包括但不限于任何隐私权或知识产权；（d）您违反任何适用法律；（e）交互数据或通过您的用户账户提交的任何内容，包括但不限于任何误导性、虚假或不准确的信息；（f）您故意的或者存在重大过失的不当行为；或（g）任何第三方使用您的用户名、密码或其他认证凭证访问和使用本服务。

## 10. 免责声明

**您使用本服务的风险自负。我们明确否认任何明示、暗示或法定的保证、条件或其他条款，包括但不限于与适销性、适用于特定目的、设计、条件、性能、效用、所有权以及未侵权有关的保证、条件或其他条款。我们不保证服务将不中断或无错误运行，也不保证所有错误将得到纠正。此外，我们不保证服务或与使用服务相关的任何设备、系统或网络不会遭受入侵或攻击。**

**通过使用本服务下载或以其他方式获得的任何内容，其获取风险由您自行承担，您的计算机系统或移动设备的任何损坏和由于上述情况或由于您访问和使用本服务而导致的数据丢失，您应承担全部责任。此外，硅基流动不为任何第三方通过本服务或任何超链接网站或服务宣传或提供的任何产品或服务提供担保、背书、保证、推荐或承担责任，硅基流动不参与或以任何方式监控您与第三方产品或服务提供商之间的任何交易。**

## 11. 责任限制和免责

**硅基流动在任何情况下均不对以下损害负责：（a）间接、偶发、示范性、特殊或后果性损害；或者（b）因第三方原因导致的数据丢失或受损，或者业务中断或损失；或者（c）收入、利润、商誉或预期销量或收益损失，无论是在何种法律下，无论此种损害是否因使用或无法使用软件或其他产品引起，即使硅基流动已被告知此种损害的可能性。硅基流动及其关联方、管理人员、董事、员工、代理、供应商和许可方对您承担的所有责任（无论是因保证、合同或侵权（包括疏失））无论因何原因或何种行为方式产生，始终不超过您已支付给硅基流动的费用。本协议任何内容均不限制或排除适用法律规定不得限制或排除的责任。**

## 12. 未成年人使用规则

**12.1** 若您是未满18周岁的未成年人，您应在监护人监护、指导并获得监护人同意的情况下，认真阅读并同意本协议后，方可使用本平台及相关服务。

**12.2** 我们深知未成年人个人信息和产品使用安全的重要性，我们将按法律法规的要求，采取相应的安全保护措施，尽力确保未成年人的个人信息安全和产品使用安全。鉴于此，我们制定本未成年人使用规则。

**12.3** 未成年用户及其监护人理解并确认，如因您违反法律法规、本协议内容，则您及您的监护人应依照法律规定承担因此而可能导致的全部法律责任。

**12.4** 未成年人用户特别提示：（a）使用本软件及相关服务应该在其监护人的监督指导下，在合理范围内正确学习使用网络，避免沉迷虚拟的网络空间，养成良好上网习惯；（b）必须遵守《全国青少年网络文明公约》：要善于网上学习，不浏览不良信息；要诚实友好交流，不侮辱欺诈他人；要增强自护意识，不随意约会网友；要维护网络安全，不破坏网络秩序； 要有益身心健康，不沉溺虚拟时空。

## 13. 适用法律及争议解决条款

本协议受中华人民共和国（仅为本协议之目的，不包括香港特别行政区、澳门特别行政区及台湾地区）法律管辖。
若在执行本协议过程中如发生纠纷，双方应及时协商解决。协商不成时，我们与您任一方均有权提请北京仲裁委员会按照其届时有效仲裁规则进行仲裁，而此仲裁规则由此条款纳入本协议。仲裁语言为中文。仲裁地将为北京。仲裁结果为终局且对双方都有约束力。

## 14. 其他条款

**14.1** 可转让性。未经我们事先明确书面同意，您不得转让或转让本协议及本协议项下授予的任何权利和许可，但我们可无限制地转让。任何违反本协议的转让或让渡均属无效。

**14.2** 可分割性。如果本协议的某一条款或某一条款的一部分无效或不可执行，不影响本协议其他条款的有效性，无效或不可执行的条款将被视作已从本协议中删除。

**14.3** 不时修订。根据相关法律法规变化及硅基流动运营需要，我们将不时地对本协议进行修改，修改后的协议将替代修订前的协议。您在使用本平服务时，可及时查阅了解。如您继续使用本服务，则视为对修改内容的同意，当发生有关争议时，以最新的用户协议为准；您在不同意修改内容的情况下，有权停止使用本协议涉及的服务。

**14.4** 如您对本协议或本平台有任何问题或进行投诉、举报，均可通过[contact@siliconflow.cn](mailto:contact@siliconflow.cn)联系我们。

***

<sup id="fn1">
  1 用户使用数据不同于交互数据。交互数据不保存、不披露，具体详见《隐私政策》。<a href="#ref1">↩</a>                                      |
</sup>


# 更新公告
Source: https://docs.siliconflow.cn/cn/release-notes/overview



<Update label="2025.11.11" description="">
  ### 平台服务调整通知

  为进一步优化资源配置，提供更高效、稳定的算力服务，平台将于`2025 年 11 月 11 日`起对部分模型 Rate Limits 进行调整。

  此次调整的模型是：`Pro/deepseek-ai/DeepSeek-R1`，`Pro/deepseek-ai/DeepSeek-V3`，`Pro/deepseek-ai/DeepSeek-V3.1-Terminus`，`zai-org/GLM-4.6`，`inclusionAI/Ling-1T`，`inclusionAI/Ring-1T`，`MiniMaxAI/MiniMax-M2`；

  如您业务对高并发或大规模吞吐有特殊需求，可[联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd17aubjk20jc73ada8ng)申请更高额度。

  感谢您的理解与支持。
</Update>

<Update label="2025.11.06" description="">
  ### 平台服务调整通知

  为进一步优化资源配置，提供更高效、稳定的算力服务，平台将于 `2025 年 11 月 7 日` 起关闭`等级包`的售卖入口。

  此次调整仅影响新购入口的开放，您已购的等级包、当前的用量等级及平台根据消费金额自动升降的机制不受影响。

  如您有快速提升用量等级、提高 Rate Limits 的需求，请[联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd17aubjk20jc73ada8ng)。

  感谢您的理解与支持。
</Update>

<Update label="2025.09.29" description="">
  ### 平台服务调整通知

  为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025-10-09 对下列模型进行下线处理：

  * deepseek-ai/DeepSeek-V3.1
  * Pro/deepseek-ai/DeepSeek-V3.1
    若您正在使用上述任一模型，建议您尽快切换到 V3.1 Terminus，以免服务受到影响。
</Update>

<Update label="2025.09.16" description="">
  ### 平台服务调整通知

  为进一步优化模型服务质量，平台已于 09 月 15 更新 moonshotai/Kimi-K2-Instruct 和 Pro/moonshotai/Kimi-K2-Instruct 模型至最新的 0905 版本，此前的 0711 版本不再继续提供。
  模型广场中moonshotai/Kimi-K2-Instruct 和 Pro/moonshotai/Kimi-K2-Instruct 已经下线，所有对应模型请求将被分别指向 moonshotai/Kimi-K2-Instruct-0905 和 Pro/moonshotai/Kimi-K2-Instruct-0905。
</Update>

<Update label="2025.08.22" description="">
  ### 平台服务调整通知

  为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 9 月 4 日 对下列模型进行下线处理：

  * tencent/HunyuanVideo-HD
  * Wan-AI/Wan2.1-I2V-14B-720P-Turbo
  * Wan-AI/Wan2.1-I2V-14B-720P
  * Wan-AI/Wan2.1-T2V-14B-Turbo
  * Wan-AI/Wan2.1-T2V-14B

  若您正在使用上述任一模型，建议您尽快切换到其他模型，以免服务受到影响。
</Update>

<Update label="2025.06.23" description="">
  ### 平台服务调整通知

  为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 7 月 3 日 对下列模型进行下线处理：

  * Pro/deepseek-ai/DeepSeek-R1-0120
  * Pro/deepseek-ai/DeepSeek-V3-1226
  * Qwen/QwQ-32B-Preview

  若您正在使用上述任一模型，建议您尽快切换到其他模型，以免服务受到影响。
</Update>

<Update label="2025.06.06" description="">
  ### 平台维护预告

  为提供更加丰富、先进、优质的服务，平台将于 2025 年 6 月 10 日 23 时至 11 日 8 时进行维护。

  受系统维护影响：

  1. cloud.siliconflow\.cn 将**暂停**注册、登录以及包括不限于下列功能的界面操作：
     * 模型在线体验/微调/批量推理；
     * 官网模型广场查看模型列表及详细信息；
     * 在线充值、购买等级包、查询账单、开具发票等；
  2. `/user/info` API 调整，`name` / `image` / `email` 字段将不再返回，固定输出空字符串；

  平台 API 服务不受维护影响，可以持续调用，建议您提前关注账户余额，以免因为余额不足导致服务受限。
</Update>

<Update label="2025.05.29" description="">
  ### 平台服务调整通知

  SiliconFlow 将启动 `DeepSeek R1` 模型更新。

  对于 `deepseek-ai/DeepSeek-R1` 和 `Pro/deepseek-ai/DeepSeek-R1` 模型，将“逐步“更新到最新 `0528` 版本。
  更新完成后，上述两个款模型均为 `0528` 版本。如有需求，在 `2025 年 06 月 28` 日前，您仍可以通过 `Pro/deepseek-ai/DeepSeek-R1-0120` 使用旧版模型，以更平滑地完成业务切换。
</Update>

<Update label="2025.05.23" description="">
  ### 平台服务调整通知

  为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 6 月 5 日 对下列模型进行下线处理：

  * Qwen/Qwen2-1.5B-Instruct
  * Pro/Qwen/Qwen2-1.5B-Instruct
  * Pro/Qwen/Qwen2-VL-7B-Instruct
  * THUDM/chatglm3-6b
  * internlm/internlm2\_5-20b-chat
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-1.5B
  * Pro/deepseek-ai/DeepSeek-R1-Distill-Qwen-1.5B

  若您正在使用上述任一模型，建议您尽快切换到其他模型，以免服务受到影响。
</Update>

<Update label="2025.04.17" description="">
  ### 平台服务调整通知

  为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 4 月 29 日 对 `HunyuanVideo` 模型（`非 HunyuanVideo-HD`）模型进行下线处理。
  若您正在使用该模型，建议您尽快切换其他模型，以免服务受到影响。
</Update>

<Update label="2025.03.26" description="">
  ### 平台服务调整通知

  截止目前，`Pro/deepseek-ai/DeepSeek-V3` 和 `deepseek-ai/DeepSeek-V3` 模型已经更新至最新的 0324 版本。您仍可以通过 `Pro/deepseek-ai/DeepSeek-V3-1226` 使用旧版模型，以更平滑地完成业务切换。
</Update>

<Update label="2025.03.25" description="">
  ### 平台服务调整通知

  SiliconFlow 将启动 DeepSeek V3 模型更新。

  对于 `deepseek-ai/DeepSeek-V3` 和 `Pro/deepseek-ai/DeepSeek-V3` 模型，将“逐步“更新到最新 `0324` 版本。

  更新完成后，上述两个款模型均为 0324 版本。如有需求，在 2025 年 4 月 30 日前，您仍可以通过 `deepseek-ai/DeepSeek-V3-1226` 使用旧版模型，以更平滑地完成业务切换。
</Update>

<Update label="2025.03.11" description="">
  ### 平台服务调整通知

  为了更好的服务全球开发者用户，SiliconFlow 即将上线国际站，并逐步开设多个服务区域。

  受此调整影响，现有`api.siliconflow.com API`端点将适时回收，请您尽快切换为`api.siliconflow.cn`继续使用。

  我们已经为`.cn`端点配置了全球访问加速（GTM），使其与当前的`.com`端点具有相同的全球接入体验，您只需要将 API 请求的`base URL`修改为`api.siliconflow.cn`即可。

  我们建议您在`本月底（3 月 31 日）`前完成迁移，如有任何疑问，请随时联系我们。
</Update>

<Update label="2025.03.07" description="">
  ### 平台服务调整通知

  为持续提升用户体验，现调整 Rate Limits 策略如下：

  去掉 deepseek-ai/DeepSeek-R1、deepseek-ai/DeepSeek-V3 的 RPH 和 RPD 限流

  随着流量和负载变化，策略可能会不定时调整，硅基流动保留解释权。
</Update>

<Update label="2025.02.27" description="">
  ### 平台服务调整通知

  #### 1. 模型下线通知

  为了进一步优化资源配置，提供更先进、优质、合规的技术服务，平台将于 2025 年 3 月 6 日 对部分模型进行下线处理。
  具体涉及的模型列表如下：

  * 对话模型
    * AIDC-AI/Marco-o1
    * meta-llama/Meta-Llama-3.1-8B-Instruct
    * Pro/meta-llama/Meta-Llama-3.1-8B-Instruct
    * meta-llama/Meta-Llama-3.1-70B-Instruct
    * meta-llama/Meta-Llama-3.1-405B-Instruct
    * meta-llama/Llama-3.3-70B-Instruct
  * 生图模型
    * black-forest-labs/FLUX.1-schnell
    * Pro/black-forest-labs/FLUX.1-schnell
    * black-forest-labs/FLUX.1-dev
    * black-forest-labs/FLUX.1-pro
    * stabilityai/stable-diffusion-xl-base-1.0
    * stabilityai/stable-diffusion-3-5-large
    * stabilityai/stable-diffusion-3-5-large-turbo
    * stabilityai/stable-diffusion-2-1
    * deepseek-ai/Janus-Pro-7B
  * 语音模型
    * fishaudio/fish-speech-1.5
    * FunAudioLLM/SenseVoiceSmall
    * fishaudio/fish-speech-1.4
    * RVC-Boss/GPT-SoVITS
  * 视频模型
    * Lightricks/LTX-Video
    * genmo/mochi-1-preview
</Update>

<Update label="2025.02.22" description="">
  ### 平台服务调整通知

  为保障平台服务质量与资源合理分配，现调整Rate Limits策略如下：

  一、调整内容

  1. 新增 RPH 限制（Requests Per Hour，每小时请求数）

     * 模型范围：deepseek-ai/DeepSeek-R1、deepseek-ai/DeepSeek-V3
     * 适用对象：所有用户
     * 限制标准：30次/小时

  2. 新增 RPD 限制（Requests Per Day，每日请求数）
     * 模型范围：deepseek-ai/DeepSeek-R1、deepseek-ai/DeepSeek-V3
     * 适用对象：未完成实名认证用户
     * 限制标准：100次/天

  随着流量和负载变化，策略可能会不定时调整，硅基流动保留解释权。
</Update>

<Update label="2025.02.13" description="">
  ### 平台服务调整通知

  #### 1. 模型下线通知

  为了提供更稳定、高质量、可持续的服务，以下模型将于 **2025 年 02 月 27 日**下线：

  * [01-ai/Yi-1.5-34B-Chat-16K](https://cloud.siliconflow.cn/models?target=01-ai/Yi-1.5-34B-Chat-16K)
  * [01-ai/Yi-1.5-6B-Chat](https://cloud.siliconflow.cn/models?target=01-ai/Yi-1.5-6B-Chat)
  * [01-ai/Yi-1.5-9B-Chat-16K](https://cloud.siliconflow.cn/models?target=01-ai/Yi-1.5-9B-Chat-16K)
  * [stabilityai/stable-diffusion-3-medium](https://cloud.siliconflow.cn/models?target=stabilityai/stable-diffusion-3-medium)
  * google/gemma-2-27b-it
  * google/gemma-2-9b-it
  * Pro/google/gemma-2-9b-it

  如果您有使用上述模型，建议尽快迁移至平台上的其他模型。
</Update>

<Update label="2025.02.09" description="">
  ### 平台服务调整通知

  #### deepseek-ai/DeepSeek-V3 模型的价格于北京时间 2025年2月9日00:00 起恢复至原价

  具体价格：

  * 输入：¥2/ M Tokens
  * 输出：¥8/ M Tokens
</Update>

<Update label="2025.02.03" description="">
  ### 推理模型输出调整通知

  推理模型思维链的展示方式，从之前的 `content` 中的 `<think></think>` 独立成单独的单独的 `reasoning_content` 字段，兼容 `OpenAI` 和 `deepseek` api 规范，便于各个框架和上层应用在进行多轮会话时进行裁剪。使用方式详见[推理模型（DeepSeek-R1）使用](/capabilities/reasoning)。
</Update>

<Update label="2025.02.01" description="">
  ### 平台服务调整通知

  #### 支持deepseek-ai/DeepSeek-R1和deepseek-ai/DeepSeek-V3模型

  具体价格如下：

  * `deepseek-ai/DeepSeek-R1` 输入：￥4/ M Tokens 输出：￥16/ M Tokens
  * `deepseek-ai/DeepSeek-V3`
    * **即日起至北京时间 2025-02-08 24:00 享受限时折扣价**：输入：<s>¥2</s>￥1/ M Tokens   输出：<s>¥8</s>￥2/ M Tokens，2025-02-09 00:00恢复原价。
</Update>

<Update label="2024.12.27" description="">
  ### 平台服务调整通知

  #### 生成图片及视频 URL 有效期调整为 1 小时

  为了持续为您提供更先进、优质的技术服务，从 2025 年 1 月 20 日起，大模型生成的图片、视频 URL 有效期将调整为 1 小时。

  若您正在使用图片、视频生成服务，请及时做好转存工作，避免因 URL 过期而影响业务。
</Update>

<Update label="2024.12.24" description="">
  ### 平台服务调整通知

  #### LTX-Video 模型即将开始计费通知

  为了持续为您提供更先进、优质的技术服务，平台将于 2025 年 1 月 6 日起对 Lightricks/LTX-Video 模型的视频生成请求进行计费，价格为 0.14 元 / 视频。
</Update>

<Update label="2024.12.13" description="">
  ### 平台服务调整通知

  #### 1. 模型下线通知

  为了提供更稳定、高质量、可持续的服务，以下模型将于 **2024 年 12 月 19 日**下线：

  * [deepseek-ai/DeepSeek-V2-Chat](https://cloud.siliconflow.cn/models?target=deepseek-ai/DeepSeek-V2-Chat)
  * [Qwen/Qwen2-72B-Instruct](https://cloud.siliconflow.cn/models?target=Qwen/Qwen2-72B-Instruct)
  * [Vendor-A/Qwen/Qwen2-72B-Instruct](https://cloud.siliconflow.cn/models?target=Vendor-A/Qwen/Qwen2-72B-Instruct)
  * [OpenGVLab/InternVL2-Llama3-76B](https://cloud.siliconflow.cn/models?target=OpenGVLab/InternVL2-Llama3-76B)

  如果您有使用上述模型，建议尽快迁移至平台上的其他模型。
</Update>

<Update label="2024.12.5" description="">
  ### 平台服务调整通知

  #### 1. 模型下线通知

  为了提供更稳定、高质量、可持续的服务，以下模型将于 **2024 年 12 月 13 日**下线：

  * [Qwen/Qwen2.5-Math-72B-Instruct](https://cloud.siliconflow.cn/models?target=Qwen/Qwen2.5-Math-72B-Instruct)
  * [Tencent/Hunyuan-A52B-Instruct](https://cloud.siliconflow.cn/models?target=Tencent/Hunyuan-A52B-Instruct)

  如果您有使用上述模型，建议尽快迁移至平台上的其他模型。

  如果您有使用上述模型，建议尽快迁移至平台上的其他模型。
</Update>

<Update label="2024.11.14" description="">
  ### 平台服务调整通知

  #### 1. 模型下线通知

  为了提供更稳定、高质量、可持续的服务，以下模型将于 **2024 年 11 月 22 日**下线：

  * [deepseek-ai/DeepSeek-Coder-V2-Instruct](https://cloud.siliconflow.cn/models?target=deepseek-ai/DeepSeek-Coder-V2-Instruct)
  * [Qwen/Qwen2-57B-A14B-Instruct](https://cloud.siliconflow.cn/models?target=Qwen/Qwen2-57B-A14B-Instruct)
  * [Pro/internlm/internlm2\_5-7b-chat](https://cloud.siliconflow.cn/models?target=Pro/internlm/internlm2_5-7b-chat)
  * [Pro/THUDM/chatglm3-6b](https://cloud.siliconflow.cn/models?target=Pro/THUDM/chatglm3-6b)
  * [Pro/01-ai/Yi-1.5-9B-Chat-16K](https://cloud.siliconflow.cn/models?target=Pro/01-ai/Yi-1.5-9B-Chat-16K)
  * [Pro/01-ai/Yi-1.5-6B-Chat](https://cloud.siliconflow.cn/models?target=Pro/01-ai/Yi-1.5-6B-Chat)

  如果您有使用上述模型，建议尽快迁移至平台上的其他模型。

  #### 2.邮箱登录方式更新

  为进一步提升服务体验，平台将于 **2024 年 11 月 22 日起**调整登录方式：由原先的“邮箱账户 + 密码”方式更新为“**邮箱账户 + 验证码**”方式。

  #### 3. 新增海外 API 端点

  新增支持海外用户的平台端点：[https://api-st.siliconflow.cn](https://api-st.siliconflow.cn)。如果您在使用源端点 [https://api.siliconflow.cn](https://api.siliconflow.cn) 时遇到网络连接问题，建议切换至新端点尝试。
</Update>

<Update label="2024.10.09" description="">
  ### 部分模型计价调整公告

  为了提供更加稳定、优质、可持续的服务，[Vendor-A/Qwen/Qwen2-72B-Instruct](https://cloud.siliconflow.cn/models?target=17885302571) 限时免费模型将于 2024 年 10 月 17 日开始计费。计费详情如下：

  * 限时折扣价：¥ 1.00 / M tokens
  * 原价：¥ 4.13 / M tokens（恢复原价时间另行通知）
</Update>


# 社区场景与应用
Source: https://docs.siliconflow.cn/cn/usercases/awesome-user-cases



# SiliconFlow 场景与应用案例

将 SiliconFlow 平台大模型能力轻松接入各类场景与应用案例

{/* <CardGroup cols={2} > */}

{/* <Card title="在 Cherry Studio 中使用" icon="link" href="/usercases/use-siliconcloud-in-cherry-studio">
        Cherry Studio 团队
  </Card>
  <Card title="在 Chatbox 中使用" icon="link" href="/usercases/use-siliconcloud-in-chatbox">
        Chatbox 团队
  </Card> */}

### 1. 翻译场景使用

<CardGroup cols={2}>
  <Card title="在沉浸式翻译中使用" icon="square-1" href="/usercases/use-siliconcloud-in-immersive-translate">
    SiliconFlow 团队
  </Card>

  <Card title="免费接入！沉浸式翻译 x SiliconFlow（硅基流动）" icon="square-2" href="https://www.bilibili.com/video/BV11M4m127NX/">
    沧海九粟
  </Card>

  <Card title="【硅基流动】在 GoldenDict-ng 中与 AI 无缝畅聊、使用 AI 翻译" icon="square-3" href="https://forum.freemdict.com/t/topic/31335">
    ohnny\_Van
  </Card>

  <Card title="SimpleTranslationAIAgent借助SiliconFlow API 构建自己的专属翻译助手" icon="square-4" href="https://zhuanlan.zhihu.com/p/717541519">
    mingupup
  </Card>

  <Card title="AI翻译助力Zotero外文文献阅读-SiliconFlow硅基流动api" icon="square-5" href="https://www.bilibili.com/video/BV1vwYdeREwy/">
    行歌类楚狂
  </Card>
</CardGroup>

### 2. 搜索与 RAG 场景使用

<CardGroup cols={2}>
  <Card title="在 MindSearch 中使用" icon="square-1" href="/usercases/use-siliconcloud-in-mindsearch">
    MindSearch 团队
  </Card>

  <Card title="[当 MindSearch 遇上 SiliconFlow：免费部署媲美 Perplexity 的多智能体搜索引擎]" icon="square-2" href="https://zhuanlan.zhihu.com/p/717572206">
    LogicAI
  </Card>

  <Card title="基于 SiliconFlow API 实现 CPU-only RAG 框架" icon="square-3" href="https://zhuanlan.zhihu.com/p/696833005">
    白牛
  </Card>

  <Card title="基于 SiliconFlow 使能 GraphRAG 🏠 Marscode" icon="square-4" href="https://www.bilibili.com/video/BV1Chv4eFE5s/">
    沧海九粟
  </Card>
</CardGroup>

### 3. 编码场景使用

<CardGroup cols={2}>
  <Card title="使用SiliconFlow平台API配置Continue插件" icon="square-1" href="https://zhuanlan.zhihu.com/p/716245893">
    xDiexsel
  </Card>

  <Card title="SiliconFlow硅基流动平台配合cursor，实现全自动写代码" icon="square-2" href="https://www.bilibili.com/video/BV1kas4ePEcv/?share_source=copy_web&vd_source=d3e2625153c20b669282198264ed2959">
    野原广志2\_0
  </Card>
</CardGroup>

### 4. 分析场景使用

<CardGroup cols={2}>
  <Card
    title="科研利器-硅基流动结合Open-interpreter实现数据自动分析与可视化
"
    icon="square-1"
    href="https://www.bilibili.com/video/BV1kgYiemEoq/?vd_source=ee682782eaf6b50be3fdfe777cacb535
"
  >
    行歌类楚狂
  </Card>
</CardGroup>

### 5. 通讯场景使用

<CardGroup cols={2}>
  <Card title="使用chatgpt-on-wechat 和 SiliconFlow API 打造你的专属微信全能 AI 分身" icon="square-1" href="https://f0nqg53yzdn.feishu.cn/wiki/XPXvwwLbLiPgHVkWkEhcKPvQn8d?from=from_copylink">
    大大大维维
  </Card>
</CardGroup>

### 6. 生图场景使用

<CardGroup cols={2}>
  <Card title="使用BizyAir，没有显卡，也能玩AI绘图" icon="square-1" href="https://mp.weixin.qq.com/s/_6YdsrA1yqqf7P-EDK48iw">
    mingupup
  </Card>

  <Card title="探索SiliconFlow：如何用API体验Kolors大模型" icon="square-2" href="https://www.bilibili.com/read/cv37120422/">
    baiack
  </Card>

  <Card title="在comfyUI中用SiliconFlow爽玩LLM！" icon="square-3" href="https://m.okjike.com/originalPosts/66c8b0c259d1a984c6727040?s=eyJ1IjoiNjNkYzY5YzQyNDNiYThiNTI1NmMxNjkwIiwiZCI6MX0%3D">
    糯.米.鸡
  </Card>
</CardGroup>

### 7. 使用评测

<CardGroup cols={2}>
  <Card title="国产赛博菩萨硅基流动SiliconFlow：最佳免费 llm大模型 api 提供商" icon="square-2" href="https://www.bilibili.com/video/BV1SYWke9E2Q">
    湖光橘鸦
  </Card>

  <Card title="速度与效率的飞跃：硅基流动API实战体验" icon="square-3" href="https://mp.weixin.qq.com/s/m6gS1wLDZiQJyf9G1nIi8A">
    自牧生
  </Card>
</CardGroup>

### 8. 开源项目

<CardGroup cols={2}>
  <Card title="多模型同时对话、文生图，纯前端。" icon="square-1" href="https://github.com/KwokKwok/Silo">
    郭垒
  </Card>

  <Card
    title="多语言 AI 模型评估平台"
    icon="square-2"
    href="https://github.com/flashclub/ModelJudge
"
  >
    laughing
  </Card>
</CardGroup>

### 9. 其它

<CardGroup cols={2}>
  <Card title="动手学Avalonia：基于SemanticKernel与硅基流动构建AI聊天与翻译工具" icon="square-1" href="https://mp.weixin.qq.com/s/s7ZMw8nAisAuxgAvE2VTgA">
    mingupup
  </Card>

  <Card title="使用 SiliconFlow 体验 AI 开发：为卡片盒笔记带来 AI 助手" icon="square-2" href="https://guoleilei.notion.site/SiliconFlow-AI-AI-6b8ab4ed2bd4487db098bb9fd93b5eaa">
    郭垒
  </Card>

  <Card title="【AI】用SiliconFlow开发效率工具" icon="square-3" href="https://www.bilibili.com/video/BV1XKH7eEEM9/">
    free-coder
  </Card>

  <Card title="SiliconFlow  API 接入 ONE API" icon="square-4" href="https://zhuanlan.zhihu.com/p/713980632">
    三千酱
  </Card>
</CardGroup>


# 302.AI
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-302ai



## 1. 关于302.AI

302.AI是一个按需付费的AI应用平台,提供丰富的AI在线应用和全面的AI API接入。

302.AI和硅基流动进行合作,让302.AI的用户可以在302的平台内直接使用硅基流动的所有模型以及开箱即用的AI应用；也能让硅基流动的用户可以在302的平台内自定义接入硅基流动模型API,无需自己开发或部署。

## 2. 硅基流动用户如何在302.AI使用 SiliconFlow 模型

### 2.1 接入聊天机器人进行对话

#### 2.1.1 获取 SiliconFlow 的API Key 和模型 ID

(1)打开 SiliconFlow 官网 并注册账号(如果注册过,直接登录即可)。

(2)完成注册后,打开API密钥,创建新的 API Key,点击密钥进行复制,以备后续使用。

(3)在模型广场找到需接入的模型ID备用。

#### 2.1.2 设置自定义模型

(1)依次点击: **使用机器人 → 聊天机器人 → 模型**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7a168eb38e7e565c26e47d92594c536c" data-og-width="1530" width="1530" data-og-height="1291" height="1291" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e30f1d688c18c80a1f502025a951cd95 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ab19eb52de7d9ac9d00203e8d3a05a64 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c3f82d98e6145d6e6a66422381324775 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a4f9bb7e2287f4dc7ed2b598f70fd1dc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=76298fccc8573dd604da42bf7cf33718 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e2bdc48f57a2cb86b6925e12253abc70 2500w" />
</Frame>

(2)点击左下角的自定义模型,填写相关配置信息。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8d98aa72898a6caeea59e8bfebad439c" data-og-width="1528" width="1528" data-og-height="1120" height="1120" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8646ed40dec0b98f71b0eee309b5d621 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ff6b866193fc7ac7809743813bfbbf13 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=989a1cc1419085417312a1ba9980bf3f 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2506c2bb8b804905df733dac1fd9e4fc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c49aed846bdcf4501de6bad4fcd70a60 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=293799d61df02063bec93111ba07911c 2500w" />
</Frame>

(3)示例模型:硅基流动部署的Qwen/Qwen2.5-7B-Instruct:

* API base选择硅基流动。

* 填写API Key、模型ID等,并根据模型特性进行相应配置；

* 点击【检查】按钮,一键检测信息是否填写正确(示例绿标即为通过)；

* 按需选择中转地区(中转地区选择功能可以解决部分模型提供商因为IP地区限制访问的问题)；

* 可设置备用模型,当自定义模型失效时可以自动切换到备用模型；

* 所有配置完成后,点击【确认】按钮；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ff7c97e016aad5eeefc89b1d6548ea8c" data-og-width="786" width="786" data-og-height="1272" height="1272" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3e3d21fcd2a221aadf61982d164bffea 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f7e6352229e8712a77ea41cba18a6e01 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=08b20b768e4da67c6ca78beb514ccaed 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=10f2fde44b8849bda1bd95748c8a38e6 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8f20f731ba2db01d0b1d805bc5257815 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d6957626bfecbd10490d8a0826fe6d4a 2500w" />
</Frame>

#### 2.1.3 创建聊天机器人

(1)接入成功后的模型会在自定义模型分类中显示,选中模型并点击【确认】；

(2)点击【创建聊天机器人】按钮:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0892e4475e6f31415c902c11338b5b61" data-og-width="802" width="802" data-og-height="865" height="865" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=353cecf74a8b88f5dd0584b32c519096 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ce99eaa1267b58bbaca7148fb7a99def 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=33f2eeaf9b4d1357998e916d5b8c209e 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=320e254708bf6b30228b639be81f46bc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=64579808a6a0f9d946f9481f914600e3 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=39fec511f8841a8b70c653811dbb1efd 2500w" />
</Frame>

(3)进入聊天机器人后发送消息即可开启对话；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=71c03e5fb41f8826111c6a465e443be0" data-og-width="1525" width="1525" data-og-height="1043" height="1043" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a7e8db62036f728134a86d814908a1a4 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=671029788b57377cff69b30383c92a47 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=363dbf60788bd00ca205d1f0afef5351 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2b26c593e433e34852bd5820bd92cb51 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=716efd3a1a34c4a9d67df775bb48d114 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a24332b9f6a25bcbe0c46ec3c66608b4 2500w" />
</Frame>

(所有模型均支持联网搜索、图片分析、深度思考等能力)

#### 2.1.4 自定义模型价格

开启自定义模型的聊天机器人,每创建一个机器人每天收费0.05 美金 ,按天扣费。

模型使用费用,将在SiliconFlow的账号余额扣取。

### 2.2. 接入API实现功能扩展

#### 2.2.1 创建API Key

(1)首先我们需要创建一个支持中转自定义模型的API key。

详细步骤:**使用 API → API Keys → 输入 API 名称 → 开启自定义模型中转 → 【添加 API KEY】**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=65f19767a93c26953aedc7d0a9351c99" data-og-width="1530" width="1530" data-og-height="1151" height="1151" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=698bfb9aceae15e33429fd79a1e4c72f 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b191eb7638242fc2a49a2573bdd9f7b0 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=dd68e2d6580bc1c8ddae274a59ae319f 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a88b066ab6e91e761f778d6b28bd86e3 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=35f75358de21ce1e792e334abd6c9517 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4b29ccae080a3ef9b58e3526947d37bd 2500w" />
</Frame>

(2)复制生成的API Key备用；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7f9031ccec3fb568c7fa5330450ccd64" data-og-width="1519" width="1519" data-og-height="792" height="792" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d3f475546970b52115fa42774be2889d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d8ff542d96fbe5f30a9e7b477e9fa761 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7b6a260ed8d75a86b31067971e98a6d1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c5daf4bc12bfd718a1ac32e0fc44273a 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=83f972517e27b451ae062291bdd5f9fb 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=24adc42aa715a77b497492dfdc3bfd9a 2500w" />
</Frame>

(3)查看中转后自定义模型的名称以方便调用:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=80617c20799fa3b631593a6fe2f53bd5" data-og-width="1534" width="1534" data-og-height="711" height="711" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=261882e211492b1a108b40214f12196f 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=89706f5f319f28e55984ea07a1f10795 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c09a2d460729620a0247dfd934f19abc 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=74296416188907c17cf79a735ccffb61 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a7af058d4af95382c45b440a8f30fbca 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bd0d4fffce879a1690bc0dd3b83af0b3 2500w" />
</Frame>

#### 2.2.2 为模型增加新的功能

通过302中转的模型,可以新增一些模型本身不具备的功能

目前支持的有:

联网搜索、深度搜索、图片分析、推理模式、链接解析、工具调用、长期记忆

(点击文字可直达相关文档,根据文档说明使用即可,持续更新中)

以增加自定义模型联网搜索能力为例:

(1)进入相关文档后,点击【调试】按钮:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=08f13996a7e6ebbd6dba1d1a1c9b9f71" data-og-width="1505" width="1505" data-og-height="823" height="823" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=171eb8721b29f466ece4a2c7530e7646 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a4966ca10ed579d9559e10df98801a5e 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9477fa61fd2183b977e1b05a5885d19e 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2a7f60f0ee914e661909e080f4f1464e 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fdae522bde4ad0c192a24efde869bd10 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c63a0bf77e95b43df1a396838621320e 2500w" />
</Frame>

(2)点击“去设置变量值”,粘贴生成的API Key填并点击【保存】:

(注意:模型中转功能必须手动开启,因此需要手动粘贴对应的API Key)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1a4ccc1a70cb7372a6f77146311c3b8b" data-og-width="1544" width="1544" data-og-height="1378" height="1378" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0808eb2e331f1a52a2742c4f61901689 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=48f92faa3bb67c465e8794d0f75cfdf6 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7e77c44b6acce354eac3cdeef3bcb51b 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3801d0c0543b84834c499bd4aebaa206 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=60ec2de48004927f7fd55a26ed6ecd2a 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5ae20982a94f07af3f36e5f461cdf73d 2500w" />
</Frame>

(3)根据文档说明,自定义模型后缀加上“-web-search”(如示例Qwen/Qwen2.5-7B-Instruct-2-web-search)并输入提示词点击【发送】即可增加联网搜索能力:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5f428eabbe7da5cc7408b4974eaa5759" data-og-width="848" width="848" data-og-height="1443" height="1443" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ee83fcc659d40aa000bf163c2ad7a639 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ad8ba346bf93dc2705eccdc922f0f9e2 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4a01e3baaa6846dcee017d31e5c70945 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f4113d2249da64177f075c8e71a5e835 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=62584bb926c76b3af0cc6d8fb0dbef25 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7e8f4cd9ceeb819a0e40888772947e54 2500w" />
</Frame>

#### 2.2.3 接入API价格

新增支持中转自定义模型的API-Key后,每个key每天收费 0.05 美金,按天扣费。

其他功能扩展费用可查看对应文档说明。

附上302.AI价格表:[https://302.ai/pricing/](https://302.ai/pricing/)

## 3. 302.AI用户如何直接使用 SiliconFlow 模型

### 3.1 使用 SiliconFlow 语言模型进行AI对话

#### 3.1.1 进入302.AI官网或者客户端

* 302.AI官网:[https://302.ai/](https://302.ai/)

* 302.AI客户端下载网址:[https://302.ai/download/](https://302.ai/download/)

(进入后注册账号,如已注册,直接登录即可)

#### 3.1.2 聊天机器人

##### 创建聊天机器人

(1)登录进入302.AI官网或者客户端的管理后台。点击:

**使用机器人 →  聊天机器人 →  模型**;

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=31feff89058935fe616d482442074121" data-og-width="1532" width="1532" data-og-height="1156" height="1156" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b307911fa3778a48c1eb255f88f3b72d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=126b05a16b7f375a50ae3efc434a2fdc 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f4a38b369bc3f23b859b84d3d513d3d1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=72bb836a255fc8c9de5e5b0ab75ab040 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e6ff2a81c94fc76dc95b7776e7fa215b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2ff27a3d4916d4964df466f32d5f66f7 2500w" />
</Frame>

(2)找到【硅基流动】→选择模型(如deepseek-ai/deepseek-vl2)→ 确定→创建聊天机器人；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bbc6df8950b159cae324fc621fa02f05" data-og-width="1502" width="1502" data-og-height="1042" height="1042" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=76042281230922f7bd4429e5ac52bfe2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6cb2bd9bdd9da2a215a43282dd0bce9c 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=de1400b125cc076a3beced6efeec8b94 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=78b937780e0a28af4121b9c2a2c3eabc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=26416820aef14289870e6876a3bb8253 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c6465b3bc19ae8bea804d23661664686 2500w" />
</Frame>

(3)聊天机器人创建成功后会在页面下方展示,可进一步选择聊天、分享、编辑等操作。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a3a39b3ec339196ebf1cf17a81baa236" data-og-width="1524" width="1524" data-og-height="573" height="573" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0a7d4b731baf730a16d2264772fef7af 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9f693cb4cea146f57a7b46e949e9099b 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=eb2a88d85aaf938aaf3641990d84c216 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c293df70fcf2c3a4e84742303e318049 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d7a12afd7251df31d825763bb587e55b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8c23723786cd866c06df370354163be0 2500w" />
</Frame>

##### 使用聊天机器人

(1)进入聊天机器人后在输入框键入文字即可聊天,输入框下方的按钮可上传图片或文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b73129e653620aeab3e2df1c4d3534d6" data-og-width="1529" width="1529" data-og-height="1054" height="1054" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4f832b4deceb42b5c3bfa7e7fed38194 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6b4739dca0c71608f6b88a21c2bcdfa5 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f017f07912eeac923fbe4eb50eac1eaf 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8fa3d65cd13fea4539779d75de9faf49 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3d298fb10793a666af43edb6207ed029 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=044379266c1e4780c83fbe143da6846c 2500w" />
</Frame>

(2)点击对话框界面下方的按钮可开启聊天机器人的实时预览功能,这一功能可以实时查看模型生成代码的运行效果。 1.2.3 在全能工具箱中使用

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=78d26dc3ec292b0b3486c2d44a58cf72" data-og-width="1511" width="1511" data-og-height="742" height="742" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=67df128d9a5fffbd1a8b42cbdf26aa64 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d510d5dca846846676026be50d0e721e 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bf6014bc6e881e0057513dadcc44eee2 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=81be2d5879bb371f8874863eeb44d839 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3c13c85435f5966a5e7577658a064611 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3358e3e4838824f4ce51a9b28e2378c7 2500w" />
</Frame>

我们还可以通过全能工具箱选择 SiliconFlow 模型进行对话:

**依次点击: 全能工具箱 →  快捷使用**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0ea47c5f8a0a4c8a7c4e1f6418e571af" data-og-width="1504" width="1504" data-og-height="1135" height="1135" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7403ef24db3ac499d66e9988a764d14d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=80975e3cbdf94d79e7feade29c4d32ca 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=04b6112c05dfde92136b6dc8a9cc3f58 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e236aad6f45a68063bd604c15e227f9c 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ddecae1c8ec6aeda7d901ee47474e84e 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=24c4c38c2b3fd7a159590a02153559a4 2500w" />
</Frame>

进入全能工具箱后点击:

**聊天机器人 → 找到对话框下方的 “@” → 切换 SiliconFlow 模型**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=105825106f5648d2f3a660c0a8f6542d" data-og-width="1542" width="1542" data-og-height="1113" height="1113" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8bb8d7cd2697ed7bcc01950e9d10dbb9 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f4cda5bea83bb2c611e24082cc9de3ce 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=262208cbcc500051c01f4732418e15f4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fcf054a925adc06e7116e74e9095582d 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5600080ffc9aae9200d47e33627bd284 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=84fbd0adf26d2e261097357744b92a40 2500w" />
</Frame>

### 3.2 在模型竞技场使用 SiliconFlow 模型

#### 3.2.1 创建模型竞技场

在管理后台菜单栏选择:

**使用工具 →  工具超市 →  工具效率 → 【模型竞技场】 →  创建**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=cb97f87b4550ff47381c356cff88a561" data-og-width="1536" width="1536" data-og-height="1129" height="1129" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4a6e4e6fe329074187d245637412d3ec 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=abeaa43076a915d0bb121a8097321e78 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f59d84fe6d14b06c271616a9accc383d 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a568921cb872673c9ef0372ea0e7b41b 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ae8e4d17d29fff14cf8a9f0ad1b54f8e 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=520a9bfb92ab6be4b09e198583f68333 2500w" />
</Frame>

#### 3.2.2 选择模型开始竞技

进入模型竞技场后,下滑找到【硅基流动】并按需勾选模型,输入提示词即可在页面右侧直观对比不同模型输出的答案。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fb99d8902209cdf125cdeef9fe266f79" data-og-width="1518" width="1518" data-og-height="1032" height="1032" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4f473261227bfc6256bd33bc2da6869e 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=153dfb8781511326f8be69767641527b 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=70571a206426b335df9b62820c4bce41 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2e50b29ed5fb4313a1b5125d3ecdba69 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=02fc6dbc5338af7fb5ad4d5999ec65a5 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ccdd2c28dfbc338ae19fd34f658be2e2 2500w" />
</Frame>

### 3.3. 接入 SiliconFlow 模型API

#### 3.3.1 查看文档

直达链接:[https://doc.302.ai/api-252560001?environment\[YOUR\_API\_KEY\]=sk-ykJk7PY80O3ulWYTGplndVApzj4oeTeMvH4Jrxh6CkaegWiz](https://doc.302.ai/api-252560001?environment\[YOUR_API_KEY]=sk-ykJk7PY80O3ulWYTGplndVApzj4oeTeMvH4Jrxh6CkaegWiz)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=071abd7518d22ff2003c4acae6e84b40" data-og-width="1521" width="1521" data-og-height="722" height="722" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1ec9d4a8df2eb71fcc19df45222c25c1 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=702708bd03a080e264622b206f2eaee0 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=85fae83d5baeb9bd5151a7173eb47af4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=31a7e4610a9075bd088170da6282a7f7 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=aeec8e49851a72fd14926e4cb134949b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=351edc82959b72fce5c75d8d99bd6d3c 2500w" />
</Frame>

#### 3.3.2 在线调试

(1)点击查看文档即可进入API文档:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1d209625734e056abc6ee9e75a0538e3" data-og-width="1106" width="1106" data-og-height="977" height="977" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9056af7dd0b6c3d108fc804d038ba135 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c6a9d2a706ed04d4a27395b8ba3034cb 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=64b681762f6e883fd1489e9c2e425cf4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=00298e0b23de3a822bf679e696b1e768 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f1be7c61363df8275ddba0e83a1f411b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5dc5f2496b370fec84f775046da0279f 2500w" />
</Frame>

(2)**进入API文档后点击在线调试 →  “去设置变量值”,查看API KEY是否自动赋值**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ed52e8d72b532a9c1586d1e684b509c8" data-og-width="1170" width="1170" data-og-height="875" height="875" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=22b9d7adcb9cc21a38ec5f78f97c5dcb 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=cd98b130e83445e4674a0825fedc95d6 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=09b715e17f89c2178668b0d18c9732e8 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1369ce1a27bd0522ff0bd0d96b64f51b 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f68a747b43dc7d762b28964819898c5f 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6779137ecc31449772bfccfd681c9fff 2500w" />
</Frame>

(3)根据参数模板填写要使用的模型ID和文本内容,点击发送,等待输出结果即可。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1bcf61d694e24e27bb084ff7a4f16e22" data-og-width="813" width="813" data-og-height="1455" height="1455" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=73ea0d3ddb439d12aa8b684871da5754 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=24990c2c94f91e4ca88c809fd09aa7f5 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e7d0285525cdf21b27e8a9230001e8e8 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5078234a2542a61240c48e814be4ed24 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7df372f2a6aff07d576176bcd6b097f3 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=95d8dd384d3388f673a636eedbfbf6ff 2500w" />
</Frame>


# Claude Code
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-ClaudeCode



<Note>本文档安装方式仅适用于 Mac 及 Linux用户</Note>

## 方式一：一键安装及配置脚本

1. 在终端中运行以下命令：

```bash  theme={null}
bash -c "$(curl -fsSL https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/sample/ccsf_v2_5.sh)"
```

2. 提示输入 API Key 时，粘贴你的 SiliconFlow API Key

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=983cca84c4fb86f1962a9d2d4cf9b692" data-og-width="1603" width="1603" data-og-height="256" height="256" data-path="images/usercases/claude/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a4e3873108d25c430c579b8ea2f6a088 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8a44c59e8a1e250dd955a729f60ccbc5 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=80cefa002adaa9c5fe354d65acfcf3f5 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e65c6745220e029e4d62bebb7e5c6033 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=134c014004a7c6ce3358ad2207542229 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a6454573e049c1de878c8f9ea62cc2c1 2500w" />
</Frame>

3. 提示选择模型时，使用方向键选择要在 Claude Code 中使用的模型，或选择自定义，从模型广场复制粘贴想用的模型名称：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=6ba6bfd2e11486f6fcce69226dd8cfd8" data-og-width="1032" width="1032" data-og-height="330" height="330" data-path="images/usercases/claude/image_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?w=280&fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=78b03e1fb0c4043bbda0a3d041ab3f49 280w, https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?w=560&fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=b8a7ce934d85a8719eda053ada498c18 560w, https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?w=840&fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=295ee954c0820e5bc70be7a085d088da 840w, https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?w=1100&fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=6016793b89d85f958221d93e12e57308 1100w, https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?w=1650&fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=5a2f282d71b9ff5c80d1d3768e36ad31 1650w, https://mintcdn.com/siliconflow-37161621/z1qn9lTaEob3H_Ih/images/usercases/claude/image_4.png?w=2500&fit=max&auto=format&n=z1qn9lTaEob3H_Ih&q=85&s=30066bbbc46ba5c99e7ffcc8925bba03 2500w" />
</Frame>

4. 根据提示，复制相应命令并重启终端运行，应用配置：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=14e991554fbbc1c6986918e885a3010c" data-og-width="1020" width="1020" data-og-height="106" height="106" data-path="images/usercases/claude/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a5008c6f8862d384ef61e30825477e31 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a830dfd527fe2b800a22a02383354c5e 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b4fd5f8ef4426866b35953d425ba82cc 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=4aae2c0dc97a378974c16305b94279c6 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0f876e830ac874aa08473afd1b4fd82e 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/claude/image_3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1cbe1f0a7717bab876f6e3d8553104da 2500w" />
</Frame>

5. 执行 claude 命令，进入 Claude Code 并使用

**切换模型使用**

目前 Claude Code 并不支持添加多个自定义模型（Custom Model），您可以再次执行上述 1～5 步，选择并更新 ANTHROPIC\_MODEL 环境变量的方式切换模型

## 方式二：手动配置 Claude Code 环境变量

如果你想手动配置 Claude Code 的环境变量，可以在终端中运行下列命令：

```bash  theme={null}
export ANTHROPIC_BASE_URL="https://api.siliconflow.cn/"
export ANTHROPIC_MODEL="moonshotai/Kimi-K2-Instruct-0905"    # 可以自行修改所需模型
export ANTHROPIC_API_KEY="YOUR_SiliconFlow_API_KEY"    # 请替换 API Key
```

<Note>注意：此场景使用时将显著增加 token 消耗</Note>


# DB-GPT
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-DB-GPT



## 1.关于 DB-GPT

[DB-GPT](https://github.com/eosphoros-ai/DB-GPT) **是一个开源的AI原生数据应用开发框架(AI Native Data App Development framework with AWEL(Agentic Workflow Expression Language) and Agents)。**

目的是构建大模型领域的基础设施，通过开发多模型管理(SMMF)、Text2SQL效果优化、RAG框架以及优化、Multi-Agents框架协作、AWEL(智能体工作流编排)等多种技术能力，让围绕数据库构建大模型应用更简单，更方便。

## 2.获取 API Key

2.1 打开 [SiliconFlow 官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。

2.2 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 3.部署 DB-GPT

### 3.1 克隆 DB-GPT 源码

```bash  theme={null}
git clone https://github.com/eosphoros-ai/DB-GPT.git
```

### 3.2 创建虚拟环境并安装依赖

```bash  theme={null}
# cd 到 DB-GPT 源码根目录
cd DB-GPT

# DB-GPT 要求python >= 3.10
conda create -n dbgpt_env python=3.10
conda activate dbgpt_env

# 这里选择代理模型类依赖安装
pip install -e ".[proxy]"
```

### 3.3 配置基础的环境变量

```bash  theme={null}
# 复制模板 env 文件为 .env
cp .env.template .env
```

### 3.4 修改环境变量文件`.env`，配置 SiliconFlow 模型

```bash  theme={null}
#  使用 SiliconFlow 的代理模型
LLM_MODEL=siliconflow_proxyllm
# 配置具体使用的模型名称
SILICONFLOW_MODEL_VERSION=Qwen/Qwen2.5-Coder-32B-Instruct
SILICONFLOW_API_BASE=https://api.siliconflow.cn/v1
# 记得填写您在步骤2中获取的 API Key
SILICONFLOW_API_KEY={your-siliconflow-api-key}

# 配置使用 SiliconFlow 的 Embedding 模型
EMBEDDING_MODEL=proxy_http_openapi
PROXY_HTTP_OPENAPI_PROXY_SERVER_URL=https://api.siliconflow.cn/v1/embeddings
# 记得填写您在步骤2中获取的 API Key
PROXY_HTTP_OPENAPI_PROXY_API_KEY={your-siliconflow-api-key}
# 配置具体的 Embedding 模型名称
PROXY_HTTP_OPENAPI_PROXY_BACKEND=BAAI/bge-large-zh-v1.5


# 配置使用 SiliconFlow 的 rerank 模型
RERANK_MODEL=rerank_proxy_siliconflow
RERANK_PROXY_SILICONFLOW_PROXY_SERVER_URL=https://api.siliconflow.cn/v1/rerank
# 记得填写您在步骤2中获取的 API Key
RERANK_PROXY_SILICONFLOW_PROXY_API_KEY={your-siliconflow-api-key}
# 配置具体的 rerank 模型名称
RERANK_PROXY_SILICONFLOW_PROXY_BACKEND=BAAI/bge-reranker-v2-m3
```

注意，上述的 `SILICONFLOW_API_KEY`、 `PROXY_HTTP_OPENAPI_PROXY_SERVER_URL` 和`RERANK_PROXY_SILICONFLOW_PROXY_API_KEY`环境变量是您在步骤 2 中获取的 SiliconFlow 的 Api Key。语言模型（`SILICONFLOW_MODEL_VERSION`)、 Embedding 模型（`PROXY_HTTP_OPENAPI_PROXY_BACKEND`）和 rerank 模型(`RERANK_PROXY_SILICONFLOW_PROXY_BACKEND`) 可以从 [获取用户模型列表 - SiliconFlow](https://docs.siliconflow.cn/api-reference/models/get-model-list)  中获取。

### 3.5 启动 DB-GPT 服务

```bash  theme={null}
dbgpt start webserver --port 5670
```

在浏览器打开地址 [http://127.0.0.1:5670/](http://127.0.0.1:5670/) 即可访问部署好的 DB-GPT

## 4.通过 DB-GPT Python SDK 使用 SiliconFlow  的模型

### 4.1  安装 DB-GPT Python 包

```bash  theme={null}
pip install "dbgpt>=0.6.3rc2" openai requests numpy
```

为了后续验证，额外安装相关依赖包。

### 4.2. 使用 SiliconFlow  的大语言模型

```python  theme={null}
import asyncio
import os
from dbgpt.core import ModelRequest
from dbgpt.model.proxy import SiliconFlowLLMClient

model = "Qwen/Qwen2.5-Coder-32B-Instruct"
client = SiliconFlowLLMClient(
    api_key=os.getenv("SILICONFLOW_API_KEY"),
    model_alias=model
)

res = asyncio.run(
    client.generate(
        ModelRequest(
            model=model,
            messages=[
                {"role": "system", "content": "你是一个乐于助人的 AI 助手。"},
                {"role": "human", "content": "你好"},
            ]
        )
    )
)
print(res)
```

### 4.3 使用 SiliconFlow 的 Embedding 模型

```python  theme={null}
import os
from dbgpt.rag.embedding import OpenAPIEmbeddings

openai_embeddings = OpenAPIEmbeddings(
    api_url="https://api.siliconflow.cn/v1/embeddings",
    api_key=os.getenv("SILICONFLOW_API_KEY"),
    model_name="BAAI/bge-large-zh-v1.5",
)

texts = ["Hello, world!", "How are you?"]
res = openai_embeddings.embed_documents(texts)
print(res)
```

### 4.4 使用 SiliconFlow 的 rerank 模型

```python  theme={null}
import os
from dbgpt.rag.embedding import SiliconFlowRerankEmbeddings

embedding = SiliconFlowRerankEmbeddings(
    api_key=os.getenv("SILICONFLOW_API_KEY"),
    model_name="BAAI/bge-reranker-v2-m3",
)
res = embedding.predict("Apple", candidates=["苹果", "香蕉", "水果", "蔬菜"])
print(res)
```

## 5. 上手指南

以数据对话案例为例，数据对话能力是通过自然语言与数据进行对话，目前主要是结构化与半结构化数据的对话，可以辅助做数据分析与洞察。以下为具体操作流程：

### 1. 添加数据源

首先选择左侧数据源添加，添加数据库，目前DB-GPT支持多种数据库类型。选择对应的数据库类型添加即可。这里我们选择的是MySQL作为演示，演示的测试数据参见测试样例（[https://github.com/eosphoros-ai/DB-GPT/tree/main/docker/examples/sqls）。](https://github.com/eosphoros-ai/DB-GPT/tree/main/docker/examples/sqls）。)　

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5b6392f41c8cead1dd4fff26c708124d" data-og-width="1080" width="1080" data-og-height="898" height="898" data-path="images/usercases/db-gpt/image_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e27c445a08f746daa58478eb1e0d5546 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=bd3da2b01beedea0b6aff80d6ecae524 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cf043949cd7dc84054d104c31a2ab9be 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2f00641f6f476200afc616a559ded492 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f810211af996130727703850a2159c27 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_1.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dfdb60313546156c7ff4cbd2e42468f9 2500w" />
</Frame>

### 2. 选择对话类型

选择ChatData对话类型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=62ad4e41f80b6aa593a58d43eef01caf" data-og-width="1080" width="1080" data-og-height="868" height="868" data-path="images/usercases/db-gpt/image_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ad432cccd09ca0e12bda5da6a9936e24 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=64ae008d0e9e055e2e374971b2244c56 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5d51c25177a40ee7ab75b105e6bf674b 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1f382ea48eaf7844e88eaf13d979d813 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ad29bdf13ffc6b80c0f88f91c3316d1e 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d97fb20171b1e3d1702cc0b4a71ccee0 2500w" />
</Frame>

### 3. 开始数据对话

注意：在对话时，选择对应的模型与数据库。同时DB-GPT也提供了预览模式与编辑模式。　

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=77a3a291ed5f02c2cb7cf61d06605bfd" data-og-width="1080" width="1080" data-og-height="765" height="765" data-path="images/usercases/db-gpt/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=53f2fd91cc07b38d96d70f80f1cae484 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3e6b86380eb1ac532e043dab96ab2222 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=15ba2ecd26cada58464a40e91292f088 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=17c75f07f9689c79cbc20ed2c36c4ae1 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=98b8372097f84d88cb42f9f6e794f249 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0ae9248d0da8c139bf2133f12dcc5f26 2500w" />
</Frame>

编辑模式：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0e1ba1cc08b14644f931d219e67039f4" data-og-width="1080" width="1080" data-og-height="521" height="521" data-path="images/usercases/db-gpt/image_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cda9ba01de955da9d2a7ed2990f7e489 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=12d538b4563c0c6d100be8ee72987848 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d84a8e288e821dcb851e1ee059b7e931 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c8c475c29d8701e8b46f705f62c50ea 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f1f2deb90353a841633c0cf4adb91178 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/db-gpt/image_4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=343538dfc7060f05f50709a5b52c4de4 2500w" />
</Frame>


# NoteGen
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-NoteGen



## 关于 NoteGen

[NoteGen](https://github.com/codexu/note-gen) 是一款跨端的 `Markdown` 笔记应用，致力于使用 AI 建立记录和写作的桥梁，将碎片化知识整理成一篇可读的笔记。

本文将介绍如何借助 SiliconFlow 提供的 API 服务在 NoteGen 进行笔记的记录与写作。

## 安装 NoteGen

浏览器打开 [NoteGen Releases](https://github.com/codexu/note-gen/releases) 下载对应系统的安装包。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3dd3484cc9d1b418e7fc8d01ce657635" data-og-width="1796" width="1796" data-og-height="868" height="868" data-path="images/usercases/notegen/notegen-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=275d0b574a05befb93c92303051bcb0e 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7f214c7caddce27097f2ce0c93519b72 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=230c4e45ab920b99741e36b2735a0392 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bf29466648a0eed62b55fb7e34722b87 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=404aa049ade02e4580fa08f83cea6338 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=03ec3d12b01917f1434481da39c74a2b 2500w" />
</Frame>

NoteGen 支持所有的主流操作系统，包括 Windows、MacOS 和 Linux，未来将支持 iOS 和 Android。

## 在 NoteGen 中使用 SiliconFlow

安装 NoteGen 之后，按照下面的步骤依次操作：

1. 点击左下角的设置按钮进入系统设置界面。
2. 在 Model Provider 中选择 SiliconFlow。
3. 填写在 SiliconFlow 后台新建的 API 密钥。
4. 点击 Model 下拉菜单选择你需要的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a254afe502e84f5108f8e4df2a84d464" data-og-width="2720" width="2720" data-og-height="1706" height="1706" data-path="images/usercases/notegen/notegen-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c7d99571488175a01f980bff4409a79a 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f27bf3df8acca931afdec1b867a154cf 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8b14c9410ccaf8b9894500aa6509f139 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3de9bca3b3eafb90362bb92c7b787d5e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=dd6b13a68d55793acd7802196e13c257 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ba5182230d643d61f4809284eb3bbaf2 2500w" />
</Frame>

完成上述操作后，如果 Model Provider 展示绿色对勾表示可以正常使用了。

## 在 NoteGen 测试使用 SiliconFlow DeepSeek-V3 模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=53fc38d27c64e5f2fa96d0641acd3512" data-og-width="2720" width="2720" data-og-height="1706" height="1706" data-path="images/usercases/notegen/notegen-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bbe7c815040808a8316357b65bd5bccb 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c8d34d85f2038f9065687d7923699851 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6177017fcca821a7e21a28cd418d3797 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f096eeb8050f125c5daab77088af4f2d 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a7d9e1066877f1df6aa7135e57edfb22 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8e54404a17f34557112256f83f119a1a 2500w" />
</Frame>


# AstrBot
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-astrbot



[AstrBot](https://astrbot.app/) 是一个开源的一站式 Agent 聊天机器人平台及开发框架。支持将大模型能力接入 QQ、飞书、钉钉、Slack、Telegram、Discord 等多种主流消息平台上，提供开箱即用的 RAG、Agent、MCP 等功能，并拥有丰富的 API 接口，以方便进行二次开发和集成。AstrBot 拥有强大的社区和丰富的插件生态。

## 部署并配置 AstrBot

### 通过 Docker 部署

请确保你的环境上已经安装了 Docker 和 Git。

```bash  theme={null}
git clone https://github.com/AstrBotDevs/AstrBot
cd AstrBot
docker compose up -d
```

> 如果您的网络环境在中国大陆境内，上述命令将无法正常拉取。您可能需要修改 compose.yml 文件，将其中的 `image: soulter/astrbot:latest` 替换为 `image: m.daocloud.io/docker.io/soulter/astrbot:latest`。

### 访问 AstrBot WebUI

```txt  theme={null}
http://127.0.0.1:6185
```

默认账户和密码均为 `astrbot`，登录后会提示修改默认密码。

### 配置对话模型

在硅基流动 [API Keys](https://cloud.siliconflow.cn/me/account/ak) 页面创建一个新的 API Key，留存备用。

在硅基流动[模型页面](https://cloud.siliconflow.cn/me/models)选择需要使用的模型，留存模型名称备用。

进入 AstrBot WebUI，点击左栏 `服务提供商` -> `新增提供商` -> 选择 `硅基流动`。

粘贴上面创建和选择的 `API Key` 和 `模型名称`，点击保存，完成创建。您可以点击下方 `服务提供商可用性` 的 `刷新` 按钮测试配置是否成功。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=5ac54713a1288c2c830a3f5f6e8e3eee" data-og-width="2604" width="2604" data-og-height="1658" height="1658" data-path="images/usercases/AstrBot/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=280&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=83cbb80ca38bbe988b219741a00b8eae 280w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=560&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=e60640e65d06d0551a05e8dcfe0aa742 560w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=840&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=85ca9d848dcb3a2c7902bf6c66c9e010 840w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=1100&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=9ca10946d080ba3aae615707bf240f32 1100w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=1650&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=2e7e8e2acb0dd2015eba3f83e96acff1 1650w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=2500&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=eb7b45927985394b778903fe1e4dc590 2500w" />
</Frame>

### 在线聊天测试（可选）

您可在 AstrBot WebUI 左栏 `聊天` 页面来测试您配置的模型。

## 接入消息平台（以飞书为例）

此处以飞书为例。您可前往 [AstrBot 文档](https://docs.astrbot.app/) -> `部署` -> `部署消息平台` 查看其他消息平台的接入方式。

### 创建飞书机器人

前往 [开发者后台](https://open.feishu.cn/app) ，创建企业自建应用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=10112a5aa32670db5790ad9eddf720a4" data-og-width="1880" width="1880" data-og-height="1590" height="1590" data-path="images/usercases/AstrBot/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7d82fafdb4d7364abdac6b72340fe7ca 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7da73b62f11a15e52166b722a1e473be 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=95022df887e8cf36a95ed0b9970038a2 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=ef46cafacfd7bdd5794d4bdaa903cef4 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c2c3288ba58c5f893c175e7728a6d8f0 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7558c116f7f6b98293a8606811107695 2500w" />
</Frame>

添加应用能力——机器人。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=02e3c237c5e65ca4ae58260a7ba1eac7" data-og-width="1510" width="1510" data-og-height="938" height="938" data-path="images/usercases/AstrBot/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a621df52c98ba0d2dddf5f759330d0f9 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=012ea126718878f2f14a7a4bd0e2a866 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=666e200b79933e2a1cf30af15a2137ce 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=9ab66e07ee05b2be2a50aab9c9945c47 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a8239f8ca87865c70b825a88044a8eda 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=25792f697d173b82ff0970464d8f702e 2500w" />
</Frame>

点击凭证与基础信息，获取 app\_id 和 app\_secret。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=24543719b83dc854e7f53d636c0e43ab" data-og-width="2866" width="2866" data-og-height="848" height="848" data-path="images/usercases/AstrBot/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=4b06402a9bb370547c88db2d190e0474 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f35128f8369ca2f6a8afc7328f45418f 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=20e26038e5b190380179b2e0f57a6d92 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f21d5aad9036b4df42b1b88ecb1d212b 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=aa35ddd24047e47a0b6ab1aaf23d3f6c 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c550a629c727d446f4159d9126a79ebb 2500w" />
</Frame>

### 配置 AstrBot

1. 进入 AstrBot 的管理面板
2. 点击左边栏 `机器人`
3. 然后在右边的界面中，点击 `+ 创建机器人`
4. 选择 `lark(飞书)`

弹出的配置项填写：

* ID: 随意填写，用于区分不同的消息平台实例。
* 启用: 勾选。
* app\_id: 获取的 app\_id
* app\_secret: 获取的 app\_secret
* 飞书机器人的名字

如果您正在用国际版飞书，请将 `domain` 设置为 `https://open.larksuite.com`。

在下方的 `配置文件` 中，点击 `选择配置文件` 右边的 ↗️ 箭头按钮。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=52091141707622cb90fab4b9ef90e274" data-og-width="1576" width="1576" data-og-height="642" height="642" data-path="images/usercases/AstrBot/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=104c3ec6561f39b88f8a315997ed4ad2 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=de8aca4f8a7e4b7f824d7193d82c7a12 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=2f31969dcca8350fed635048896b4e4d 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6eb5f241fead38aaf08f8e3aec665490 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d19591b56a5e265bbd059df73ba7c600 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c1883754604973eecab153992eb59db5 2500w" />
</Frame>

在呼出的配置页面中，点击默认聊天模型右边的选择提供商按钮，选择刚刚创建的硅基流动的提供商，点击右下角的保存按钮。保存成功后关闭该页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0154c0b36f03825fcaeebe925bf97281" data-og-width="2590" width="2590" data-og-height="1654" height="1654" data-path="images/usercases/AstrBot/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6ceb7aa556805ae669ed2f04f9168ce8 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=82198eed259e5bd7e3bd7d892dd8c1c6 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c653424b505fb6d84291afec87571c56 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=b07ce4f80d9d146fc4c6276088daf43a 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=47aa5f8b7b428430e5170a314f3e159b 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6f34a25c74b9dad798fe318d5cf39105 2500w" />
</Frame>

点击 `保存`，创建机器人。

### 设置回调和权限

接下来，点击事件与回调，使用长连接接收事件，点击保存。**如果上一步没有成功启动，那么这里将无法保存。**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=552e60b933ae2a7a2c21769ee7736689" data-og-width="2880" width="2880" data-og-height="1800" height="1800" data-path="images/usercases/AstrBot/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6f44dab9f1984881ca59392be19a92cb 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f3e0229964cf29fd61fac4c6f7b4e37c 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=aade885f48ed0e2444084f83ed12e106 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=10acfe189814cd3f987d5157528873dd 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d78fc3ab4838abe13688aae8936eef23 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=37b132e82c40a5909efa430c7b1976e2 2500w" />
</Frame>

点击添加事件，消息与群组，下拉找到 `接收消息`，添加。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=33f1e7e8a64b6057d185c372edff4820" data-og-width="2010" width="2010" data-og-height="1428" height="1428" data-path="images/usercases/AstrBot/8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7ff15286cbd43c5ec4ce4db4ad02a036 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d174a76daa8c4321a9372daf20e9bb75 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=e3f7f1616416e56eabb1f578fb258be2 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=dd123b432c264748b417d06674319ea6 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=189e0e2c2f15365e03fccce018dc85d6 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=dd9123c5eee0b8d0dc8a4f583b4fccfd 2500w" />
</Frame>

点击开通以下权限。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=5b9e6ea94353ccf4b9675db972166442" data-og-width="2242" width="2242" data-og-height="774" height="774" data-path="images/usercases/AstrBot/9.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=bbfb689a9d96c4fbd4765a065ed2b7fc 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0f8efbc59b5942cae010942914c405ec 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=4c305ac0fdf78fe073be6aa72ec55e62 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=21c58010537cac55af44cde66a6306b5 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=35befe9082376285e94c9457219b9ca7 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=be1eae6eba0669f66729707a8b62b331 2500w" />
</Frame>

再点击上面的`保存`按钮。

接下来，点击权限管理，点击开通权限，输入 `im:message:send,im:message,im:message:send_as_bot`。添加筛选到的权限。

再次输入 `im:resource:upload,im:resource` 开通上传图片相关的权限。

最终开通的权限如下图：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=c400c1a7fc5ec882553a441d91e60f51" data-og-width="2880" width="2880" data-og-height="1800" height="1800" data-path="images/usercases/AstrBot/10.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=280&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=f0e2b2c02605e19c35444838d883881a 280w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=560&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=c88110dfad2913e8fca12c56bf122ed9 560w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=840&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=db620c87f6d6bd3bdb4b8a1992c4bbff 840w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=1100&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=fc5044ae4311761652a784924f2b30da 1100w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=1650&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=c25d122d7f4aaf66953e06890295d103 1650w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=2500&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=8dee14cb5cc9bf7088e7a22ee92afec7 2500w" />
</Frame>

### 创建版本

创建版本。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=b610eb6232ede4bdf7716402f8a43c65" data-og-width="2528" width="2528" data-og-height="804" height="804" data-path="images/usercases/AstrBot/11.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=280&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=e2b00c5654d9481f2c31588186e300c7 280w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=560&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=85a7cfe6ba7db92f11026a6f9e0d86c4 560w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=840&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=9cda16d3d533440a4ab155df78c6f2d2 840w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=1100&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=01a5d4f4bfea8fbfa59f4dd4e7563f44 1100w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=1650&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=6dc51327139258dcd9bfb3703057845e 1650w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=2500&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=828f0a7c4c9a219b9cd555b3482c8869 2500w" />
</Frame>

填写版本号，更新说明，可见范围后点击保存，确认发布。

### 拉入机器人到群组

进入飞书 APP（网页版飞书无法添加机器人），点进群聊，点击右上角按钮->群机器人->添加机器人。

搜索刚刚创建的机器人的名字。比如教程创建了 `AstrBot` 机器人：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=47d4a292ecb0902701baa9a3a64669b5" data-og-width="2632" width="2632" data-og-height="1500" height="1500" data-path="images/usercases/AstrBot/12.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=2b861eee1059ff3a9b99e7f2cc327411 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f8c331971a1cbc5521712ed79c441614 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0270a33c750db775e1053b78168cb951 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=ca1748881a86353587eb3891212e6f30 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=041ec28a8e0c5e8e425b6fd0316e2377 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=005620faa1987305390195474b2170aa 2500w" />
</Frame>

### 🎉 大功告成

在群内发送测试消息 `hi`，机器人将做出响应。

## 更多功能

您可以前往 [AstrBot 文档](https://docs.astrbot.app/) 查看更多功能和配置。


# Bob 翻译
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-bob



## 1. 关于 Bob

[Bob](https://bobtranslate.com) 是一款 macOS 平台的翻译和 OCR 软件，您可以在任何应用程序中使用 Bob 进行翻译和 OCR，即用即走，简单、快捷、高效！

本文将介绍如何借助 SiliconFlow 提供的 API 服务在 Bob 中进行翻译。

## 2. 安装 Bob

前往 Mac App Store 安装 Bob。[Mac App Store 安装](https://apps.apple.com/cn/app/id1630034110)

## 3. 在 Bob 中使用 SiliconFlow

### 3.1 默认配置

安装完 Bob 之后，在任意软件选中一段文本，然后按下 `⌥` `D` 快捷键即可翻译，SiliconFlow 的免费模型会作为默认翻译服务进行翻译，如下图所示。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=892f0670b71eb177e8dc980e263f8f26" data-og-width="2768" width="2768" data-og-height="844" height="844" data-path="images/usercases/bob/siliconflow-use-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9fa8e1586ed30ad81bb2e33023bfcc09 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bfd5cfc3340929cbcb515ac05e164bd2 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f7812eb0e0ec4ae1556041f051edd4fe 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7cdb944afc7609fbfec14aff0618adb6 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=23fcb3aaef61871edb0cf4c8427a66f4 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=51a0488ccec323618628d2d5865375f5 2500w" />
</Frame>

### 3.2 使用 SiliconFlow 的其他免费模型

默认使用的模型是 `Qwen/Qwen2.5-7B-Instruct`，可以使用**鼠标右键**点击翻译窗口右上角的服务图标前往「翻译-服务」页面切换其他免费模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=16b763683a28c57903e184087c12ead8" data-og-width="1116" width="1116" data-og-height="526" height="526" data-path="images/usercases/bob/siliconflow-use-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=5041e89af667fef60e2ab4cd58ccaaf3 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3749c53bb4c95f166b7ee91881d0da5e 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2c08fcf87f7dd152957165b0acd27cb2 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1b96f48e83b856e4d7dda0ed658ed527 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1cac43cbe190cad305d14435635d08e5 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=32d288173ee52034e39b89ef6ab08951 2500w" />
</Frame>

如下图所示，标注为**免费**的模型均可直接使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=150bbeef103c19ac609dee5a75413a44" data-og-width="2124" width="2124" data-og-height="1918" height="1918" data-path="images/usercases/bob/siliconflow-use-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=589a1f916cbb6598dd47fda58f652d87 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c3b30ed550c5542293cbf3a7c5fe4e72 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ca80c584df2bfe0f877b4f43dead9f9d 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6c4c2e926862e97c4807ed4e0cc5a059 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b9cd881ec55cec4779babd53427563fd 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=162a96a975dfa2968a0cdff67ad81bea 2500w" />
</Frame>

### 3.3 使用 SiliconFlow 的其他文本生成模型

如需使用没有标注为免费的模型，需要自行获取 SiliconFlow API Key。

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。
3. 进入之前提到的 Bob「翻译-服务」页面，将 API Key 填入**硅基流动翻译**服务的 API Key 设置项中，然后切换到需要使用的其他模型，点击保存即可使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=14327f02b2033253f84d9674a174a843" data-og-width="2074" width="2074" data-og-height="1624" height="1624" data-path="images/usercases/bob/siliconflow-use-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c87f0b4187d393ba3ad046b3481dba82 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a077893d797c297a31ba4e996ccaa072 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a0b7593de80a152ee044f2625fafdb69 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=477944680dfbc76ce23f7d0f8d675b70 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9652b36a0fe62293bbf1a214865dfabc 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=987ae13b478805c4356d4081e4fac932 2500w" />
</Frame>


# Chat2Graph
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chat2graph



## 关于 Chat2Graph

[Chat2Graph](https://github.com/TuGraph-family/chat2graph) 是一个图原生的智能体系统（Graph Native Agentic System），通过利用图数据结构在关系建模、可解释性等符号主义的天然优势，对智能体的推理、规划、记忆、知识、工具协作等关键能力进行增强，同时借助智能体技术推进图数据库智能化，降低用图门槛，加速内容生成，实现与图对话。做到图计算技术与人工智能技术的深度融合。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b4edf470dabd717027290ec549a1bfa8" data-og-width="3602" width="3602" data-og-height="1329" height="1329" data-path="images/usercases/chat2graph/head.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=24880ac8637c59fa43e7d9e7ca7dccb4 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=24237af5b8493b3e744836370046c277 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=526defecf6db8e172226586a6fe3ac92 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=389cb54560e5d3e54fb95a9faab858aa 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ed3288137670ed02aec90a65b2e14f4d 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=72b20956685542cfc472bf2401637df6 2500w" />
</Frame>

## 获取 API Key

1. 打开 [SiliconFlow](https://cloud.siliconflow.cn/) 官网 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开 [API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 部署 Chat2Graph

### 下载 Chat2Graph

```yaml  theme={null}
git clone https://github.com/TuGraph-family/chat2graph.git
```

### 准备执行环境

准备符合要求的 Python 和 NodeJS 版本。

* **Python**: 推荐[Python == 3.10](https://www.python.org/downloads)。
* **NodeJS**: 推荐[NodeJS >= v16](https://nodejs.org/en/download)。

您可以使用 `conda` 等工具来管理您的 Python 环境：

```yaml  theme={null}
conda create -n chat2graph_env python=3.10
conda activate chat2graph_env
```

### 构建 Chat2Graph

一键构建 Chat2Graph：

```yaml  theme={null}
cd chat2graph
./bin/build.sh
```

### 配置 SiliconFlow 模型

准备 `.env` 配置文件：

```yaml  theme={null}
cp .env.template .env && vim .env
```

填写 SiliconFlow 模型配置：

```yaml  theme={null}
LLM_NAME=deepseek-ai/DeepSeek-V3
LLM_ENDPOINT=https://api.siliconflow.cn/v1
LLM_APIKEY={your-siliconflow-api-key}
EMBEDDING_MODEL_NAME=BAAI/bge-large-zh-v1.5
EMBEDDING_MODEL_ENDPOINT=https://api.siliconflow.cn/v1/embeddings
EMBEDDING_MODEL_APIKEY={your-siliconflow-api-key}
```

### 启动 Chat2Graph

一键启动 Chat2Graph：

```yaml  theme={null}
./bin/start.sh
```

当看到如下日志时，表示 Chat2Graph 已成功启动：

```latex  theme={null}
Starting server...
Web resources location: /Users/florian/code/chat2graph/app/server/web
System database url: sqlite:////Users/florian/.chat2graph/system/chat2graph.db
Loading AgenticService from app/core/sdk/chat2graph.yml with encoding utf-8
Init application: Chat2Graph
Init the Leader agent
Init the Expert agents
  ____ _           _   ____   ____                 _     
 / ___| |__   __ _| |_|___ \ / ___|_ __ __ _ _ __ | |__  
| |   | '_ \ / _` | __| __) | |  _| '__/ _` | '_ \| '_ \ 
| |___| | | | (_| | |_ / __/| |_| | | | (_| | |_) | | | |
 \____|_| |_|\__,_|\__|_____|\____|_|  \__,_| .__/|_| |_|
                                            |_|          

 * Serving Flask app 'bootstrap'
 * Debug mode: off
WARNING: This is a development server. Do not use it in a production deployment. Use a production WSGI server instead.
 * Running on all addresses (0.0.0.0)
 * Running on http://127.0.0.1:5010
 * Running on http://192.168.1.1:5010
Chat2Graph server started success !
```

## 使用 Chat2Graph

你可以在浏览器访问 [http://localhost:5010/](http://localhost:5010/) 使用 Chat2Graph。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=4a6abd9759e3729bf74637225a3b6f5e" data-og-width="3456" width="3456" data-og-height="938" height="938" data-path="images/usercases/chat2graph/index.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=af6c3b5da462d30a03ec9e6ff0141155 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=25f52f8bd4cef52daaf19450e5745832 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=28ea8b5a5a5c26d5667229531871e819 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d8d259aa987cd2e4cd2de7e22703e43e 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cd1553a0976a69e99889a7914637aadc 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3af990120e9c447210d13703bdd268b7 2500w" />
</Frame>

### 注册图数据库

提前注册图数据库实例，可以体验完整的 Chat2Graph 的「与图对话」功能。当前支持 [Neo4j](https://neo4j.com/) 和 [TuGraph](https://tugraph.tech/) 图数据库。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=57b23f26b2148da9026dc2a4d88f21fe" data-og-width="3456" width="3456" data-og-height="638" height="638" data-path="images/usercases/chat2graph/gdb-mng.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3fd414a8f216d5b0e345b5e4412f8a36 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=365f43b1fe2ab153c61204805291a8ca 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0927b4cc7bb3a0e69176bfcbffd7c190 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d4497f389e9752aad60ed1d598e5341e 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9c637dbc737ec8abe72b14a4718b3dd8 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f645fa88f2898c81f0aa1785ad558ac3 2500w" />
</Frame>

启动 Neo4j 实例：

```plain  theme={null}
docker pull neo4j:latest
docker run -d -p 7474:7474 -p 7687:7687 --name neo4j-server --env NEO4J_AUTH=none \
  --env NEO4J_PLUGINS='["apoc", "graph-data-science"]' neo4j:latest
```

启动 TuGraph 实例：

```latex  theme={null}
docker pull tugraph/tugraph-runtime-centos7:4.5.1
docker run -d -p 7070:7070 -p 7687:7687 -p 9090:9090 --name tugraph-server \
  tugraph/tugraph-runtime-centos7:latest lgraph_server -d run --enable_plugin true
```

### 与图轻松对话

自动完成知识图谱的构建与分析任务：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0728436e48c79bcc462d6f89f77e1f67" data-og-width="3400" width="3400" data-og-height="1832" height="1832" data-path="images/usercases/chat2graph/chat-layout-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a5ea30531de53a8839769681c56406e3 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6ff0cbd00177f019c0f88f2adcdc263a 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=273c18806066de83d970161a8c014729 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7ecb0608c0521b2d527a424711c80ee1 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=646cbc96db4ca19dd2d24a880248ace5 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bc80b46f82f2267cbbd8b9f13998efec 2500w" />
</Frame>

支持图模型与图数据的实时渲染。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a473d0c4f579c13b882c90846ceb9bd5" data-og-width="3412" width="3412" data-og-height="1838" height="1838" data-path="images/usercases/chat2graph/chat-layout-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cbe0794d0ce2ce20dd0fcc0db98f99ce 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=97debd6f6217a4145002c4b53ea70bdc 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=56aed90bf6aca7c73fbb6fb9bf8f4ab4 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6c336b04c87451ccf22053e191390ecd 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c7de2be8f610638ad3f4f4de2377e11c 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1abc807286e76a54536f402463cbeb38 2500w" />
</Frame>

## 集成 Chat2Graph

Chat2Graph 提供了清晰简洁的 SDK API，让你轻松定制智能体系统。

配置 SiliconFlow 模型：

```latex  theme={null}
SystemEnv.LLM_NAME="deepseek-ai/DeepSeek-V3"
SystemEnv.LLM_ENDPOINT="https://api.siliconflow.cn/v1"
SystemEnv.LLM_APIKEY="{your-siliconflow-api-key}"
SystemEnv.EMBEDDING_MODEL_NAME="BAAI/bge-large-zh-v1.5"
SystemEnv.EMBEDDING_MODEL_ENDPOINT="https://api.siliconflow.cn/v1/embeddings"
SystemEnv.EMBEDDING_MODEL_APIKEY="{your-siliconflow-api-key}"
```

仿写 `chat2graph.yml` 文件，一键初始化智能体：

```latex  theme={null}
chat2graph = AgenticService.load("app/core/sdk/chat2graph.yml")
```

同步调用智能体：

```latex  theme={null}
answer = chat2graph.execute("What is TuGraph ?").get_payload()
```

异步调用智能体：

```latex  theme={null}
job = chat2graph.session().submit("What is TuGraph ?")
answer = job.wait().get_payload()
```


# Chatbox
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chatbox



## 1 关于 Chatbox

Chatbox 是一个流行的大语言模型的全平台聊天客户端，特点是功能强大、安装简单。你可以用它接入各种大语言模型，然后在任何设备（电脑、手机、网页）上和 AI 聊天。

Chatbox 不仅提供简单好用的 AI 聊天功能，还提供了一系列强大功能：

* Artifact 预览：在 Chatbox 中你可以预览 AI 生成代码的实际效果，比如让 AI 帮你做一个网页、贪吃蛇游戏，然后在 Chatbox 中直接运行。
* 图表制作：让 AI 绘制思维导图、流程图、统计图表。
* 文档理解和图形视觉：可以向 AI 发送文档或者图片。
* 网页解析与识别：可以向 AI 发送链接，讨论网页内容等。

## 2 安装使用 Chatbox

浏览器访问 [Chatbox 官网](https://chatboxai.app/)下载安装包。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-website.png" />
</Frame>

Chatbox 支持所有的主流操作系统，包括 Windows、MacOS 和 Linux，手机系统支持 iOS 和 Android。下载安装包后，在系统中直接安装即可。或者也可以访问和使用 Chatbox 的网页版本。

## 3 在 Chatbox 中使用硅基流动模型

### 3.1 配置硅基流动 API 密钥

访问 [API 密钥](https://cloud.siliconflow.cn/account/ak)新建或复制已有密钥。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/siliconcloud.png" />
</Frame>

### 3.2 在 Chatbox 中配置

1. 打开 Chatbox，进入设置。

2. 在模型提供方界面选择 SiliconFlow。

3. 输入个人的 SiliconFlow API 密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a83b0e8d37d57ff0b7260c3dfce1d4ba" data-og-width="2050" width="2050" data-og-height="1366" height="1366" data-path="images/usercases/chatbox/image_0.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=560bae9c31d8adf857ce6a3f51b7c704 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=98c7498f407744deb6fdcc5c9458dfd1 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=62952fabd17d66e5d04b922a11c9865b 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=721a31479918119f6f90eb5842ce721d 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=98a75c3d372541e404ae1251081486a3 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a94fbbd4e77279bec1eb9cd1fd7d22a5 2500w" />
</Frame>

点击检查，完成后即可开始聊天。

### 3.3 开始聊天

按照上面步骤，基本上已经配置成功了，简单聊天测试一下。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatting.png" />
</Frame>

### 3.4 使用技巧

在结尾这里在顺带介绍一些 Chatbox 的使用技巧。

#### 3.4.1 利用 Chatbox 的图表能力，在聊天中生成可视化图表

Chatbox 的“做图表”助手会生成各种图表，在聊天中可以更方便地让你理解一些数据。

注意：为了更好的效果，需要选择更聪明更强大的模型。模型能力将直接决定图表的效果。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-with-charts.png" />
</Frame>

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-with-charts2.png" />
</Frame>

#### 3.4.2 利用 Chatbox 的 Artifact 预览功能，查看 AI 生成代码的运行效果

Chatbox 的 Artifact 预览功能，则可以让你直接预览 AI 生成前端代码的实际运行效果。

注意：为了更好的效果，需要选择更聪明更强大的模型。模型能力将直接决定生成代码的效果。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-with-artifact.png" />
</Frame>

除了这些技巧外，在 Chatbox 简单易用的外表下，还隐藏着非常多强大的功能，有很多值得探索的地方。

## 4 参考资料

* [Chatbox 官网](https://chatboxai.app/)
* [如何在 Chatbox 中接入 SiliconFlow - 超简单完整教程](https://bennhuang.com/posts/chatbox-siliconcloud-integration-guide/)


# ChatHub
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chathub



## 关于 ChatHub

[ChatHub](https://chathub.gg/zh) 是一个流行的大语言模型聚合插件，特点是可以同时和多个模型聊天，方便对比回答。ChatHub 在全球拥有数十万活跃用户。

## 安装 ChatHub

浏览器打开 [ChatHub 官网](https://chathub.gg/zh)，点击“新增至Chrome”按钮安装 ChatHub 浏览器插件：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=07bd1f9df0e347d73d3b2cb9719dfdb5" data-og-width="1200" width="1200" data-og-height="438" height="438" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=5da062e4a2c928e595f0c26ad956b35f 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3cb64f2a26fdad90532ac6f9ec2b67f1 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8b0b0bd9777ad089cea28524f75fb764 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=dcdffe37c4c37da7752a6343d9b1c677 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=86507eb8245cccb45fd295cef349d84b 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bff183f4232eb08e5840caff53558b65 2500w" />
</Frame>

安装后，将自动打开 ChatHub 设置页面.

## 在ChatHub中使用SiliconFlow模型

1、在 ChatHub 设置中找到“自定义机器人”模块，点击“添加”按钮

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9d511f21fdac6c49cafbf223c7bdcf94" data-og-width="944" width="944" data-og-height="442" height="442" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d7a1a21c6dbd157176bdd8a777be4c7e 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0fe473ad3a1ffb30bc6c900762d8cb5e 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bb42c7a930027766eef06d37f0119c7c 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=36c89c457d748f72ba0aa2a512754220 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cdd3fbfc1884557a0a31d84080f18750 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2351611fd22a3b11af55d6ce78c3c232 2500w" />
</Frame>

2、在弹窗中，依次：

1. 输入机器人名称
2. 选择 SiliconFlow 作为提供方
3. 输入 SiliconFlow 密钥
4. 填写 SiliconFlow 支持的任何模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=46a601e1de52ac47d3b7b52419d1f4e6" data-og-width="1200" width="1200" data-og-height="1042" height="1042" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3499c936f24c3936171952981fa5a6f6 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1ea03ba710281e69c7e1abe0f4d7bac9 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2ff3ada8913a8853def7a37feb9fdeb5 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d0bf3a6bba1908dc65c4306e5f9d0362 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=98b82c6ee9f04b989b682add1f2ae74f 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c0ffb50da8957b44106d997c0d44c91e 2500w" />
</Frame>

3、点击“确认”后模型即配置成功

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=752740890bc58e3c9287811af21b5db5" data-og-width="824" width="824" data-og-height="394" height="394" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8261e01a57668353fd26eb805e7d5803 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b74804a647095c337440c6d3ca90b176 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=76d8192224b24700c28427533b95d355 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3f3989061a2b37d42a48592ab4d7c07d 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f17c4995471bd1d2841bc67e21390556 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=edea26c2a40810fda03948e02dc36077 2500w" />
</Frame>

4、开始聊天

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9ac25b4c3896753c0ed753ce2ef14b47" data-og-width="1200" width="1200" data-og-height="601" height="601" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ce223fb8770887a2cdbca846d21aa775 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0562bdc1fd75f7367dd578f48ffd84b1 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=fc50f07c9e0dd1f1644592563079f1e4 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a940703cb0d25921dbcc76d2ede39aa0 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7e0be5fb21a8aa287414540751dd200b 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1ac609e7f1910c72c7208203e7953505 2500w" />
</Frame>

## 在 ChatHub 中进行多模型对比

你可以重复上面的步骤在 ChatHub 添加其他模型，然后你就可以使用 ChatHub 的 All-in-One 功能同时和多个模型聊天（最多可以同时和 6 个模型对话）：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=93d5429cf96454c2f403a123cf2d1408" data-og-width="1200" width="1200" data-og-height="900" height="900" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=49bf8446d3bc568eb965976b4fea7ba4 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7f5683ca2d388b58644c49a5b138e8ac 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=10d4f1ad49d8d2702ce67b1a0706f673 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2bf95b99b16c4fa2f9a158beffa51fe0 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=be4862fb2fba68b42c6aa9bf9515ccd8 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=72d275b56727f8f4a806ae6353b91269 2500w" />
</Frame>

除了核心的对比功能外，ChatHub 还有提示词库、代码预览等强大的功能，可以在 [ChatHub 官方文档](https://doc.chathub.gg/introduction)了解更多。


# Chatika
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chatika



## 1. 关于 Chatika

**Chatika** 是一款 iOS 平台的免费 AI 对话客户端，让用户可以自己输入 API 密钥自由调用各供应商，或使用本地部署的 Ollama 的各种 AI 大语言模型进行对话。具备：**高隐私性** 、**高自由度**、**丰富的聊天功能**、**原生开发**等特性。

最新版 Chatika 合作硅基流动，特别为新用户预设了免 API Key 的全模型试用模式。

## 2. 安装与配置

在苹果 AppStore 搜索 **Chatika** 或下方直接扫码即可，**最低系统要求 iOS 17.1** 。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3f081536599b40cecdb86ea9ed4424c9" data-og-width="865" width="865" data-og-height="364" height="364" data-path="images/usercases/chatika/Chatika_Banner.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3ecee992558a90dc10411ec292a04a8e 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7b5a5757f13fdc6a39c9ec83b3dfc999 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b288a20ac34c92ab5fa88ac11e9644f6 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bf1a32db0ebf8a1ee074ad86fd9b40c6 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=4e77c3722a4d740094b6890a47987876 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=84d130f9123a7e21896f020beec565c9 2500w" />
</Frame>

初次运行会进入欢迎页面（根据系统语言自动设置 app 语言，目前支持中英）。

随后被引导到下图的 Provider 设置界面，可以自己输入对应的 API 密钥，也可以配置 Ollama Host 在本地局域网调用。

还可以**点击 SiliconFlow（硅基流动）进行试用，激活试用就有 1w tokens 的试用额度**。模型方面只要硅基流动有的模型，全开放使用，激活试用或直接输入 Api keys 就可以开始对话了。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_1.gif" />
</Frame>

## 3. 对话界面

**对话界面是本 App 的主界面**。

* **窗口顶部**：供应商名称旁显示 “State” 徽章，标识模型能力。若为多模态模型，将显示“图片”徽章，支持发送图片。

* **中间区域**：为消息交流主体内容。可以在消息下方进行额外的 **“引用”，“创建分支”，“回到某个点重发”，“重新生成回答”** 等额外操作。

* **底部操作栏**：“Persona”（人设）快捷选择栏，已预设了常用 AI 人设，并支持 AI 人设设置

<Frame>
  <img width="300" src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/gif_2.gif?s=8ebb1971d7895409c68b5109e8aa634b" data-og-width="720" data-og-height="1280" data-path="images/usercases/chatika/gif_2.gif" data-optimize="true" data-opv="3" />
</Frame>

### 对话设置和模板

点击聊天标题或者右上角的配置按钮，会进入 **当前对话** 的设置界面。可以直接更改对话的模型/人设，需要注意的是 **额外自定义提示词**。这个**额外**的提示词，仅仅作用于当前的对话，不影响其他对话的人设。另外如果对当前这个聊天的设置满意，可以直接保存对话设置为模板供将来复用。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_3.gif" />
</Frame>

### 对话管理

点击对话界面左上角的**边栏**按钮，则会打开边栏弹窗。

在这里可以对对话进行**搜索**，**星标**和**批量删除**。长按单个对话，还可以对单个对话进行直接重命名/删除/或用整个对话创建副本分支。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_4.gif" />
</Frame>

## 4. 在线搜索

Chatika 支持在线信息搜索，只需填入搜索服务商的 API Key, 即可在聊天调取打开实时在线检索结果。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_5.gif" />
</Frame>

## 5. 未来展望

Chatika 是一款独立软件和兴趣项目，计划在不久的将来会开源本 App。

Chatika 当前主要满足的是在手机端尽可能自由的 AI 对话，待时机更成熟的时候，可能会考虑增加有限的 MCP 支持，实现一定程度的 Agent 化操作。

如果有 Bug 和其他反馈，联系 Email: [dev@chatika.app](mailto:dev@chatika.app)


# Cherry Studio
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-cherry-studio



## 1 关于 Cherry Studio

<Note>开发者可以打开 [Github](https://github.com/kangfenmao/cherry-studio) 项目链接点亮 ⭐️ 来支持开源项目</Note>
🍒 Cherry Studio 是一款支持多模型服务的桌面客户端，内置了超过 30 个行业的智能助手，旨在帮助用户在多种场景下提升工作效率。它适用于 Windows、Mac 和 Linux 系统，无需复杂设置即可使用。
<br />🚀 Cherry Studio 集成了主流的 LLM 云服务和 AI Web 服务，同时支持本地模型运行。
<br />🌟 Cherry Studio 提供了诸如完整的 Markdown 渲染、智能体创建、翻译功能、文件上传和多模态对话等个性化功能，并具有友好的界面设计和灵活的主题选项，旨在为用户提供全面而高效的 AI 交互体验。

### 1.1 下载 Cherry Studio

* [官网下载](https://cherry-ai.com/)
* [开源下载](https://github.com/kangfenmao/cherry-studio/releases/latest)

### 1.2 安装教程

* [Windows 安装](https://cherry-ai.com/docs/windows-install)
* [macOS 安装](https://cherry-ai.com/docs/mac-install)

## 2. 配置 SiliconFlow 的模型服务

### 2.1 点击左下角的设置，在模型服务中选择【硅基流动】

<Frame>
  <img src="https://raw.githubusercontent.com/siliconflow/doc-images/refs/heads/main/1-apikey-settings.webp" />
</Frame>

### 2.2 点击链接获取 SiliconFlow API 密钥

1. 登录[SiliconFlow](https://cloud.siliconflow.cn)（若未注册首次登录会自动注册账号）
2. 访问[API 密钥](https://cloud.siliconflow.cn/account/ak)新建或复制已有密钥

<Frame>
  <img src="https://raw.githubusercontent.com/siliconflow/doc-images/refs/heads/main/2-siliconcloud-apikey.png" />
</Frame>

### 2.3 点击管理添加模型

<Frame>
  <img src="https://raw.githubusercontent.com/siliconflow/doc-images/refs/heads/main/3-models.png" />
</Frame>

### 2.4 添加嵌入模型

1. 在模型管理服务中查找模型，可以点击“嵌入模型”快速筛选；
2. 找到需要的模型，添加到我的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=28a779ac8b66e9ae94baad7d9a5f717b" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2af4991f158c6351676105b3f49c1f69 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=13b178f356ddefa22a69e73f5f1b29b3 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c610320fd56e946f90de779f7b4bfe91 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=53db53ca96f8bd20978c68945bbd5cbf 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b99c26183d396020e00d434d43d03378 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=433149dea55cbb368fc009f8b724db18 2500w" />
</Frame>

## 3. 模型服务使用

### 3.1 使用语言模型服务聊天

1. 点击左侧菜单栏的“对话”按钮
2. 在输入框内输入文字即可开始聊天
3. 可以选择顶部菜单中的模型名字切换模型

<Frame>
  <img src="https://raw.githubusercontent.com/siliconflow/doc-images/refs/heads/main/4-chat.webp" />
</Frame>

### 3.2 使用嵌入模型服务创建知识库并使用

#### 3.2.1 创建知识库

1. 知识库入口：在 CherryStudio左侧工具栏，点击知识库图标，即可进入管理页面；
2. 添加知识库：点击添加，开始创建知识库；
3. 命名：输入知识库的名称并添加嵌入模型，以 bge-m3为例，即可完成创建。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=67dd526c854ef908c357f70a5e5348bd" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1ae0f20c7f7b44e2a594f08a1c7ec517 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d765374dde6c72f055640c9ca5f4ac55 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cebd41b0ec49d0e3a68d73f99c25c0fb 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=57163a3d30d0d82f9dd59273c4ac0a06 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6447babee1990e9672f7eb2f06cb452a 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image1.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=96ae7ceef4fb9299c7982e0b808d296c 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=23b42bccb1d925a11b386ac0e9eea975" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6a4af1de80182a68659d45ab1d74365b 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=25c18f3443f359d47177d99927d895bd 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=66ac3ca1280687f456cff69b9221b0ea 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3b384d8ee1c37ce54a04a83a348ab763 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=aca7864cef822b824362ff8e64a0b62c 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=68a6ba3d8f6dcdfa206e13dd753fe7ce 2500w" />
</Frame>

#### 3.2.2 添加文件并向量化

1. 添加文件：点击添加文件的按钮，打开文件选择；
2. 选择文件：选择支持的文件格式，如 pdf，docx，pptx，xlsx，txt，md，mdx 等，并打开；
3. 向量化：系统会自动进行向量化处理，当显示完成时（绿色✓），代表向量化已完成。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d197f9166ac0fe46d4fcadfb635d6315" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e7e9dac7e6acc23e3eaef45763788cfb 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8bcf1a964df07a748c88687f24bb547c 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3906bfac8b9a320f1fe55d79862d6142 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9636bb00633bf3e6049f594d8d79fc76 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=63774b98f763d5af17676ae8db0ac673 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ed6ca73d744336c1b3b24b5403be7142 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1c44bf7a9c496a80d33f4803e15e3c06" data-og-width="2764" width="2764" data-og-height="1596" height="1596" data-path="images/usercases/cherrystudio/image4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e9f5dc95dfe5594d77d081a440327c17 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=53124b7ce98670bfa3774e98d34c777d 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cfac01c543fe256e52b9718e8f8ee354 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a0171ad1139aebf998b00d1429be6991 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2844f2f028862e1a4b797fba384aa3c2 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image4.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=18e439cef6ce16ee018264141379ff70 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a952c2f173e252cb18b97ee14c1c25fc" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c6bb1e3606744895b0f0f5ecd67ee73e 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=05cda853f0d32680d62d932d831daee0 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8328a396419c30e11b164ed48213c07b 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ed51e37004d555db2ad7ff527539f1a9 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=19bf961a931778f0ebf0bfa10861dddb 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image5.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e3cc2f8e1d6b53db6996a3b90a285afb 2500w" />
</Frame>

#### 3.2.3 添加多种来源的数据

CherryStudio 支持多种添加数据的方式：

1. 文件夹目录：可以添加整个文件夹目录，该目录下支持格式的文件会被自动向量化；
2. 网址链接：支持网址 url，如[https://docs.siliconflow.cn/introduction](https://docs.siliconflow.cn/introduction)；
3. 站点地图：支持 xml 格式的站点地图，如[https://docs.siliconflow.cn/sitemap.xml](https://docs.siliconflow.cn/sitemap.xml)；
4. 纯文本笔记：支持输入纯文本的自定义内容。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1d75cc61e33e161fbb204cc5389a36d6" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=961323c387144f795830f47e03e4f417 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f2a94f8f76c645c8d0dfe4173b08fe3b 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1210de88422d500ba2034eec7cf88b7d 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=659508b40b42462b8e5d29f5c6369ca7 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1c9bf776302d272b34344a7cf82ea422 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image6.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c7597810da676e71ef8606e848ce5265 2500w" />
</Frame>

#### 3.2.4 搜索知识库

当文件等资料向量化完成后，即可进行查询：

1. 点击页面下方的搜索知识库按钮；
2. 输入查询的内容；
3. 呈现搜索的结果；
4. 并显示该条结果的匹配分数。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0bff5f741a5e86f23d4685c3907f9f20" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1b16adb207151bfe04a8228119ccfe53 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a262ac77d859344f941b119732dbfd0a 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7c47e9666702317ee549762199474fed 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e8fcb8ae9aa06bf9f6a77ace85d8a0f1 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=25a18e9fe376dfb5080482ea4c4521db 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image7.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=76e576e178d1748fade44a8724296f5c 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=85331a5030b049c63efd03d0e9519433" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e2dea213b0097358e1ff50865dc4f95f 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a022ef112e6b01da835703e145a6ba6c 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6f56bf0fea7a4c17b602a338adac0676 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=73e862bb2333906515fb5b79960a1112 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c9e2b35dcc17f92660ac4755f0b658a9 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image8.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0abe981b39ea6b705f105b9edf659255 2500w" />
</Frame>

#### 3.2.5 对话中引用知识库生成回复

1. 创建一个新的话题，在对话工具栏中，点击知识库，会展开已经创建的知识库列表，选择需要引用的知识库；
2. 输入并发送问题，模型即返回通过检索结果生成的答案 ；
3. 同时，引用的数据来源会附在答案下方，可快捷查看源文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=883b8ac873512dbd16fc6c3554d9f22a" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image9.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3c573a49caa877c98e924d4bc5e6d630 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8a6668142d596d163918ce7966ac29d5 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=09e53fee38a3a3b3489005601c20f8d1 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0bff408d5ca8ed84eea5edfafc59361e 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=38181b76024427533bd90c04c487838b 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image9.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f3acda9c1156a460188195a3f9e53b0a 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1f237ebe9890090344ab31f1cde6b191" data-og-width="2852" width="2852" data-og-height="1684" height="1684" data-path="images/usercases/cherrystudio/image10.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e6f12d0b8d1d20b2eb3ed5b09a8e7f60 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3bceb9eb81507789ca6ed9293a486e51 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=49a04789ec180db4897af00eed10fffd 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=acc6627054c77f2da4a412bd50adced6 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cd70e5bafd4d5ed751eac9086f8b0552 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cherrystudio/image10.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7231d058a480e5fec71999e307768b6c 2500w" />
</Frame>


# Cline
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-cline



## 1. 安装 Cline

[安装地址](https://marketplace.visualstudio.com/items?itemName=saoudrizwan.claude-dev)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cab729764c69e32df48c79f873f4ca59" data-og-width="1280" width="1280" data-og-height="841" height="841" data-path="images/usercases/cline/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3b7dcb2215ce409fdfc98d8db1e12877 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d2873cee2ebfd7804a86ee6cce397256 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=45eded3625e37182a0b9b0fa7ee05aa2 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8f2b0e6d66e4c9235f9a1738fdcfed4d 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=252e314ed7be8cf0b9bbcae3b25e8daf 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1cac7b391d8302e99b10d7d1bac8a765 2500w" />
</Frame>

## 2. 打开cline

在VSCode中，通过 Ctrl/Command+Shift+P 打开命令工具，在新 tab 中打开 Cline 进行配置

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=be9199b024f53387f85e7c33f825b6af" data-og-width="1280" width="1280" data-og-height="405" height="405" data-path="images/usercases/cline/image_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=97aee5b5e41c69a0737d40e4b401c846 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2699fb45d8dcee4995752ec88da8fb43 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a4250e548073ff2bd48e414d3c503c74 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=495561545c796f0cec8cc5fbdddf7b79 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=fa0a0e420765fb28a6098eac5827556c 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e146430d61e39cbaa40f9aba7565d097 2500w" />
</Frame>

## 3. 在新窗口中进行配置

1. API Provider：选择 “OpenAI Compatible”
2. Base Url：[https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
3. API Key：从 [https://cloud.siliconflow.cn/account/ak](https://cloud.siliconflow.cn/account/ak) 中获取
4. Model ID：从 [https://cloud.siliconflow.cn/models](https://cloud.siliconflow.cn/models) 中获取

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a6946fccb3be7952b8d8d783dd1bf336" data-og-width="3408" width="3408" data-og-height="2172" height="2172" data-path="images/usercases/cline/image_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6034d539633b3f8639e0ce5aeed57555 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=85985ac25d95e1c0f98bba1aca308a2d 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=fcf92d062dc6e71df13d37998f780642 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b1c682204bd68f0805b5b984c47f2610 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=28fa48488d2faad8e0fd7c3a42520249 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=23467f80d547cf9d975961530ceed6e1 2500w" />
</Frame>

## 4. 开始使用

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=883f8deaeae7354b0c19f57a8d7ce89e" data-og-width="1280" width="1280" data-og-height="813" height="813" data-path="images/usercases/cline/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1e8616963b5be3f810e399af8c8fd823 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a372261a009e1ddc586f3313c2802013 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02b5a019d341b2b8786f9fdcf60be1cd 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8c882ae1cf0d3d46359ff51f47bd35dc 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=66174f361c96a9161fedaa225dc036c3 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e440c6c4cc4f33116545c2382157423c 2500w" />
</Frame>


# CodeWave
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-codewave



## 1、关于网易 CodeWave 智能开发平台

网易 CodeWave 是面向企业应用的智能开发平台，通过融合 AI 与可视化开发能力，帮助企业降低开发门槛、提升效率、优化协作方式，加速实现研发与应用智能化升级。

* 全栈可视化开发
* 支持导出应用和源码
* 100% 还原视觉稿
* 多项拓展能力开发复杂系统

## 2、使用 CodeWave 创建应用

* 点击注册体验 saas 版：[https://codewave.163.com/?fromlcap=gjld\_cw](https://codewave.163.com/?fromlcap=gjld_cw)
* 创建应用

  * 进入“**应用中心**”->“**我的应用**”页面，单击“**创建应用**”按钮。
  * 编辑应用的基本信息，如应用场景、名称等。按照提示，完成创建。各基本信息的详细介绍，请参见下文：基本信息说明。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=da00ebe479422ba58b5df015ef719bcd" data-og-width="1242" width="1242" data-og-height="644" height="644" data-path="images/usercases/codewave/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=61e67db4976a97a3fc9d6163456d7729 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8f3416a7e1ab1a2cc2b6c748a4834c91 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=36949f16dd985170b2f6675395247821 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=165f761868648b1a742721f4471a4242 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5ee864c0078f67f349c89911739dd136 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=89f227a27a4ec9f6f0d22a8584d64311 2500w" />
</Frame>

## 3、在 CodeWave 中使用硅基流动连接器

\*\*对话：\*\*支持调用硅基流动对话接口，实现对接多种大模型对话接口，可指定模型等具体参数

\*\*生成图片：\*\*根据提示词生成图片，可指定模型参数

\*\*视频生成：\*\*根据提示词生成视频，可指定模型参数，返回本次请求 ID，可根据请求 ID 查询视频生成状态及视频地址。
\*\*列出模型：\*\*列出可用的模型列表，并提供相关模型的基本信息。

\*\*查询账户信息：\*\*查询当前账号余额和状态。

### 3.1 添加连接器

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=31eaf78d3c31cf9f7315991485c0cc4a" data-og-width="1916" width="1916" data-og-height="948" height="948" data-path="images/usercases/codewave/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2056ee5322942354547fc64a20757735 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=05a561d3be487898d131260839b36ede 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7e613cf0ff46c152c25803ec49961041 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cc2d1d9569761b667bb856c97369848c 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8d725434ff18ad9fe400fd39f6a3450d 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fba11f7b5b977aae1ecefb539565b80f 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b8f4d8cb721af142f35374b463ded676" data-og-width="1267" width="1267" data-og-height="613" height="613" data-path="images/usercases/codewave/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e71a78291c5e882c95d52da393162f86 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1ce25c4d27313f64ac5db12c372b2217 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02fde731213e9125588c9b1ad16dc310 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=59ed94fae51cf62088c9e265f7c4645b 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c37a61b6f4f93aa4a7479b5563c004b0 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6d86bdd99cac221ec1cd8b677c160f89 2500w" />
</Frame>

### 3.2 调用连接器

1. 在应用中需要调用硅基流动接口的地方，调用连接器
2. 选择一个连接和一个操作，例如对话
3. 输入参数，对话接口需要传入对应的参数对象，并填入相关参数。针对必填参数说明如下：

   * messages：messages 中的 content 可根据用户输入的对话内容动态传入，role 可以是 user
   * model：根据自己需要传入，目前根据官方说明填写，例如：deepseek-ai/DeepSeek-R1 或者 Pro/deepseek-ai/DeepSeek-R1
   * stream：需要传入 true，本连接器默认支持流式接口返回

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=30d05ed39a4788fb4e75aa887ed0ec20" data-og-width="1267" width="1267" data-og-height="619" height="619" data-path="images/usercases/codewave/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2de6ee801181159de8aada7e0aaa502a 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=efb93897e02f930fbb27a018baf0049d 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=22fac17134797800aed0b8aa79fecf64 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f55225ae3d710933c1de6d14dbd4d83c 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=93d0165ff835df0c272d2cd9409d5e1f 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d1bd7e20fb8a2e0bd91eb96fa093c3de 2500w" />
</Frame>

在 onMessage 子逻辑中对接口返回数据进行处理，然后显示到页面

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f7d0a0d93ea83aea10b5d2ffef5499e2" data-og-width="1267" width="1267" data-og-height="625" height="625" data-path="images/usercases/codewave/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2cc98e9d56bbec6dbeb31393b9398682 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9fcf3c39c49e8247679e018aba682715 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=06bfec69fc0bfb475868aecce4a9275f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=13bd1e519f34b27e7cc5fb3decdae8ae 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=01cf9372b7212df6dfe15e7e7c4de9fd 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8e13f002863f655a808e666b23517198 2500w" />
</Frame>


# 麦悠电台
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-cube-sugar-studio



麦悠电台（my.ft07.com）是独立开发者方糖开发的一款独具特色的 AI 电台 App，借助 AI 大模型为你打造专属播客。

通过与 RSS Hub、Wewe-rss 订阅器的配合，麦悠电台用户可在麦悠电台订阅上千个媒体平台和微信公众号来获取资讯。电台支持本地/云端 TTS 合成，可自由选择多种 AI 音效。在电台中生成的播客还支持分享、导出音频/视频格式，为内容创作者提供了极大便利。

本文将介绍如何借助 SiliconFlow 提供的 API 服务，在麦悠电台创建你的个性化播客节目。

## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Sider 中使用 SiliconFlow 语言模型系列

### 2.1 下载安装麦悠电台

IOS 用户可打开苹果商店进行搜索安装。Android 用户可[下载 APK](https://the7.ft07.com/Maidio/maidio-byok-1.0.9-b29.apk) 安装。

### 2.2 配置 SiliconFlow 的 API 服务

打开麦悠电台 App 首页，点击左上角任务栏中的“设置”，在“AI 设置”中粘贴从 SiliconFlow 获取的 API Key，保存设置，就可以使用 SiliconFlow 上的相应模型了。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=03f6b2ebef46ef9ce0c8cbc33fcb67f7" data-og-width="1080" width="1080" data-og-height="1201" height="1201" data-path="images/usercases/cube-sugar-studio/cube-sugar-1.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=14ba10c49100a4e681a61d6634f0904d 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7b099d14d4a2a9dc41c9dcb135c736f9 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ccd593c7a3916f03bff467990e1dd4f4 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=60260cc6399d965db7d491dea77cf985 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=796a1897b04a36f9daff3cccc8d95d2a 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=75dae8c316dcf0373022574a7c856c07 2500w" />
</Frame>

### 2.3 设置语音

1. 点击顶部导航栏的“语音”标签，在“本地语音”页面选择主持人和助理的语音引擎，调整语速、音调和音量，点击“声音”按钮可以试听效果。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f21062443ced343fa70aa8eaac2fe47c" data-og-width="1080" width="1080" data-og-height="661" height="661" data-path="images/usercases/cube-sugar-studio/cube-sugar-2.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a6e05901b3aa60c210ad93a60a99455b 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=86884f7f305f0838b48a0cd42b2b54dd 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=eae6633dda42e00983ee764d091b255e 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=454f0791fc26f73924b751a0c6c9d8e9 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=adccc588f8d1c646947141576a4a075a 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9d32ca9fb59c702548d98596ff4aa4a1 2500w" />
</Frame>

<Note>
  Android 系统，请先在系统设置中安装中文语音包，推荐使用小米和 Google 的语音引擎，选择合适的中文语音。

  如iOS 系统，进入设置→辅助功能→朗读所选内容→声音→中文→月/瀚→下载高质量语音，重启应用，即可在本地 TTS 中选择使用 Yue/Han 的高质量语音。
</Note>

2. 接入 SiliconFlow 提供的 API Key 后，通过平台的音频模型 `fishaudio/fish-speech-1.5`，用户可以进一步测试 "云端语音"，享受 8 种开箱即用预置音色。

### 2.4 创建电台，获取新闻

1. 点击主界面右上角的“+”按钮，自定义电台名称，添加 RSS 订阅源，直接输入 RSS 地址（每行一个）或导入 OPML 文件。

2. 在主界面点击电台右侧的 RSS 图标，点击右上角的刷新按钮，获取最新内容，等待新闻加载完成。

### 2.5 生成节目，收听节目

1. 在新闻列表中选择感兴趣的新闻，点击底部的”创建节目”按钮，根据自己的兴趣选择新闻喜好（分为详细、摘要、略过、原文四个选项），等待 AI 生成对话内容。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=68d585b8ad7f70ccc8c9ad7385db6f5a" data-og-width="1080" width="1080" data-og-height="1025" height="1025" data-path="images/usercases/cube-sugar-studio/cube-sugar-3.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7f4b2d72634205ff22c34a31bd781ecf 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fb0a46ddff8a96f4838cbda584ba2fe1 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a399004e099f4458230b69c01f466e9a 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=eaedcdc1a184764961a717c51c1df135 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1cd622474c8c28a11f0dc81fa66aa9f1 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1e6a0eced81cada6cbde15cec6fc664d 2500w" />
</Frame>

2. 返回主界面，点击电台右侧的播放按钮，即可享受 AI 主持人为你播报定制化的新闻内容。

### 3. 总结

如果你想开发一个麦悠电台这样的 AI 应用，想快速地测试各类大模型效果或让用户使用高性价比的模型服务，可以选择接入 SiliconFlow 的 API 模型进行快速体验。


# Deep Research Web UI
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-deep-research-web-ui



## 1. 介绍

Deep Research Web UI 是一个由人工智能驱动的研究助手，通过结合搜索引擎、网络抓取和大语言模型，可以让 AI 根据某个问题自己搜索资料并且不断深挖，最后输出一份研究报告。

本项目的特性：

* 💰 **低成本**：可以用很低的成本实现类似 ChatGPT、Perplexity、秘塔等产品的“深度研究”效果
* 🚀 **隐私安全**：所有配置和 API 请求均在浏览器端完成，并且可以自部署
* 🕙 **实时反馈**：流式传输 AI 响应并在界面实时展示
* 🌳 **搜索可视化**：使用树状结构展示研究过程，支持使用英文搜索词
* 📄 **支持导出 PDF**：将最终研究报告导出为 Markdown 和 PDF 格式
* 🤖 **多模型支持**：底层使用纯提示词而非结构化输出等新特性，兼容更多大模型供应商

项目开源地址： [GitHub](https://github.com/AnotiaWang/deep-research-web-ui)

## 2. 如何使用

打开 [Deep Research Web UI 官网](https://deep-research.ataw.top)，点击右上角的“⚙️”按钮打开设置弹窗。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=74855ab4aff29ff4e76b4cfe837aafc2" data-og-width="2018" data-og-height="1228" data-path="images/usercases/deep-research/deep-research-showcase-1.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0188893cf0c66aefb533d64100a694d5 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2474fce08a3cb4eab51d07dd4ce5cf1f 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d7ca9742122330891fae3e057927cb63 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=afe2a2e54a380746a2c83efbe7d44aff 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c79eeff0b5abc9271aeab4dc084edcb 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=df84ce3cea86c535ebb23056233cda08 2500w" />
</Frame>

### 2.1 配置 AI 大模型服务

1. 在硅基流动官网注册或者登录一个账号。
2. 在 [API 密钥](https://cloud.siliconflow.cn/account/ak)中生成一个新的 API key，然后复制一下。
3. 回到 Deep Research 网页，在设置的 AI 服务部分，选择“SiliconFlow 硅基流动”，在“API 密钥”一栏里粘贴刚才生成的 API key。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e9d8785b85c961bd665fcc90d6017bc1" data-og-width="1114" data-og-height="504" data-path="images/usercases/deep-research/deep-research-showcase-2.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=425790a3dc32809fb43e1037f5b7aaa4 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5a72168454158c1636ad0928ba0a5817 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=247625c0489124d308ad9378b735b8f1 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ad0abd23e4c70f4c6966a9b628f0b3a4 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3332a4acc645a9e726f54e88bfb22734 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fb2c8d0ebc5d80b65788ceb2611925c0 2500w" />
</Frame>

4. 在“模型名称”一栏，点击右侧的下拉按钮（也可以在输入框里输入模型名称来筛选），选择想要使用的模型。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c52e3da58f54fa66d47e293956b32613" data-og-width="1006" data-og-height="622" data-path="images/usercases/deep-research/deep-research-showcase-3.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1d5f6322528e3a69ce7ed31f30459852 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ea056eab27749fa8afb88f556366ff09 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=22a76edb87682f1d38909c37692b97d9 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f53b62888c55766d0f873fd443a85e55 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=db84d13acdb3431a09dd4dbf9f2befc7 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c28632a0294bad53602d900d7ae3a244 2500w" />
</Frame>

5. （可选）设置上下文长度：如果要做大规模的研究，建议配置“上下文长度”选项，不要超过所选模型的最大上下文长度，避免请求失败。

### 2.2 配置联网搜索模型

目前支持 Tavily 和 Firecrawl，后续会增加支持更多搜索服务。这里我们选择 Tavily，因为它提供了每月 1000 次的免费搜索，足够大部分场景使用。

1. 在 [Tavily 官网](https://app.tavily.com/home)注册一个账号。然后在控制台里新建一个 API key 并复制。
   * Key Name 可以填写 Deep Research。
   * Key Type 根据你的使用情况决定，如果是轻度使用，可以选择“Development”；重度使用则选择“Production”，支持更高的请求频率。
   * 注意保管好 API key 不要泄露。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=38091917a8c3192578a882810e915e48" data-og-width="2874" data-og-height="1444" data-path="images/usercases/deep-research/deep-research-showcase-4.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dbdb3c5773475900bba73d3e67299bd3 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=11f476bca37995e44b71784fb6524828 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5bb0983f8ad00a2a7aec203e31ef57ea 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fd3c1cda23780b9d8e4c0bad49250798 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a713687c9acf47a71e01ce5a04200af8 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3c7708ef60498453271a86c48e71fb79 2500w" />
</Frame>

2. 回到 Deep Research 网页，在设置的“联网搜索服务”部分，选择 “Tavily”；在“API 密钥”一栏填写刚才生成的 API key。
3. （可选）设置搜索时使用的语言。AI 模型默认会使用你网页的当前语言来搜索和回复，不过如果你想用英文搜索词来查找更高质量的资料，可以把“使用语言”设置成 English。

这样就设置完毕，可以开始使用了！

### 3. 开始使用

本项目在每一步都做了说明，力求降低使用门槛。可以用它来查找第一手资料、了解自己感兴趣的话题、查找新闻并汇总等等。例如，查找一下 NVIDIA RTX 50 系列显卡的信息：

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=80b8c6802056d9c41f7c504d34af62a7" data-og-width="3374" data-og-height="1996" data-path="images/usercases/deep-research/deep-research-showcase-5.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ec8cd6a520a58838ee648173a4442aed 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a95fa37321a68c07268f8d7f1943c54b 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4168674b009279ecc82605e60f16b5bb 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=90f59824e0b6d5e0fb309cd3c30b3501 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fb6a855befe49babaa77878536702815 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f8b159304879a37ea8fd57e1033bbe52 2500w" />
</Frame>

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ec6edaa0e39f82270d4514bd174e87f4" data-og-width="1832" data-og-height="1502" data-path="images/usercases/deep-research/deep-research-showcase-6.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=98ab525f2a16f1d82eecabcccc386de3 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1958b8ac6c979ac77c0217ea87677d04 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=378bd478d3ca58f9b3d063774227166c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1f16528fa9055c72dc7dac79906e349a 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2f46c60889524a3fb486ec88c915394c 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0cbfafa0fe18ef569a045c69e865c993 2500w" />
</Frame>

本项目正在活跃更新中，如果遇到问题可以前往 [GitHub 仓库](https://github.com/AnotiaWang/deep-research-web-ui)反馈。


# DeepStudent
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-deepstudent



DeepStudent 是一款免费开源的 AI 错题管理解决方案，专为追求高效学习的学生和教师设计。 DeepStudent 通过人工智能技术革新传统错题整理方式，使用户可以自由使用最先进的 LLM、VLM 模型进行分工协作，进而使学习更高效，让知识更牢固。

为了提升用户体验，DeepStudent 现已全面接入硅基流动大模型云服务平台的 API 服务，支持用户灵活接入 DeepSeek、Qwen 等主流 LLM 及 VLM 模型，在开发流程中引入自然语言交互能力，辅助错题整理、优化知识点逻辑体系，进一步提升学习效率。

## 1、关于 DeepStudent

[DeepStudent](https://deepstudent.cn) 是一款 macOS、iPadOS、PC 平台的免费开源的 AI 错题管理应用程序，您可以在应用程序中管理错题，数据本地化、简单、快捷、高效学习。本文将介绍如何借助硅基流动提供的 API 服务在 DeepStudent 中进行使用。

## 2、安装 DeepStudent

前往 [Deepstdent 官网](https://deepstudent.cn)，安装 DeepStdent。

## 3、DeepStudent 中试用硅基流动

### 默认配置

#### 步骤 1：获取硅基流动（SiliconFlow）API 密钥

1. 访问官网：打开浏览器，访问 [硅基流动](https://cloud.siliconflow.cn/i/deadXN1B) 官方网站。
2. 注册/登录：完成账户注册并登录。
3. 创建API密钥：在"API 密钥"页面，创建一个新的密钥。给它起个名字（如 deep\_student\_key），然后立即复制并妥善保管这串 sk- 开头的密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=96b49d39b0016510ac40c13b7b938f5d" data-og-width="1418" width="1418" data-og-height="888" height="888" data-path="images/usercases/DeepStudent/1.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f32005a7215828558369107c6bc6df7d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1eed1818070fd0bd9ea4fe6b5d5f3b9f 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0bc6c8269a56ab5fffd2b018f238f1d5 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=77d5fc883b20ccc7319322566242e744 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=40506ca835d19990f99cd7b7951831c7 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5b59f2364ba239324045cfc8ca3f5ada 2500w" />
</Frame>

#### 步骤 2：在 DeepStudent 使用硅基流动提供的模型服务

> 这是你首次使用软件时必须完成的步骤。

如果你对模型没有了解，只想直接使用，推荐完全按照以下默认配置来。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=be09f3720b0f6183446ff8a1b4f934ac" data-og-width="2304" width="2304" data-og-height="1274" height="1274" data-path="images/usercases/DeepStudent/2.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4e1f2a5322f5588eac594e50c218daf2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2dfb96fd297e87193d7a9208f2d931eb 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=db61ff852fa681bdf847eb6ce9c8ebd4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c67f92cfb98902f69efe2ac43d6f647e 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a1e13c6a5a312045a317a97140d541cd 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3ab22ce11e21ae2ab3d3c987234658c2 2500w" />
</Frame>

1. 启动应用，点击左侧导航栏底部的齿轮图标进入 设置 界面。
2. 导航至 API 配置：在 设置 页面中，输入 sk- 开头的密钥，点击 一键分配 即可，软件会自动完成 API 配置的创建和模型分配。

至此，您已经可以使用软件的所有功能了。

### 切换模型

你可以从硅基流动官网的模型广场找到所有可用的免费或付费模型。

借助 DeepStudent 与硅基流动大模型云服务平台的深度集成，错题整理正变得更加高效与便捷。用户可通过自然语言描述错题或困惑点，AI 将智能分析、自动归类并关联薄弱知识点，显著提升错题消化与复习效率。在 DeepStudent 中，AI 正逐步从“整理助手”升级为“学习伙伴”，为高效学习带来质的飞跃。


# Dify
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-dify

结合 SiliconFlow 模型多、速度快的优势，在 Dify 中快速实现工作流/Agent 

## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Dify 中使用 SiliconFlow 语言模型系列

### 2.1 调用 Dify 中内置的 SiliconFlow 模型的 API

1. 打开 SiliconFlow 官网 并注册账号（如果注册过，直接登录即可）。 完成注册后，打开 API 密钥 ，创建新的 API Key，点击密钥进行复制，以备后续使用。
2. 在 Dify 首页右上角选择“设置”，选择左上角“模型供应商”。
3. 找到“ SiliconFlow ”，粘贴先前在 SiliconFlow 平台复制的 API Key，然后点击“保存”按钮。
4. 校验成功后可以在模型提供商的顶部区域看到 SiliconFlow 提供的模型，并在应用中使用 SiliconFlow 模型。

### 2.2 使用目前不在 Dify 源代码中的 SiliconFlow 模型

1. 打开 Dify 的“ Settings ”进行设置。
2. 选择导航栏“ Model Provider ”，添加兼容 OpenAI 接口的模型服务平台。
3. 在其中设置对应的 SiliconFlow 对应的 Model Name 、 API Key 、 API 端点。

* **Model Name:** 从[model-list](/api-reference/models/get-model-list) 文档中选择
* **API Key:** 从[https://cloud.siliconflow.cn/account/ak](https://cloud.siliconflow.cn/account/ak) 中获取
* **API 端点 URL：** [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)

4. 设置完成后，可以在模型列表中看到上述新增的模型。

## 3. 在 Dify 中使用 SiliconFlow 生图模型系列

参考[在 Dify 中使用 SiliconFlow 生图模型系列](https://docs.dify.ai/zh-hans/guides/tools/tool-configuration/siliconflow)


# eechat
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-eechat



## 关于 eechat

[eechat](https://github.com/Lucassssss/eechat) 是一款开源免费的国产 AI 应用，支持 Windows、macOS 和 Linux，集成了聊天、多模态指令执行（MCP）、知识库问答（RAG）、语音识别（ASR）、语音合成（TTS）等功能模块。

* **开箱即用**，无需代码基础，适合非技术背景用户。
* **免费开源**，国产的免费开源应用，数据都存储在本地
* **多模型支持**，同时支持 API 模型和本地模型聊天，可以自定义配置自己喜欢的模型
* **丰富的支持**，支持 MCP、RAG 和插件支持

本文档将演示硅基流动在 eechat 中的使用。

## 下载 eechat

* **[官网下载](https://ee.chat)**
* **[开源下载](https://github.com/Lucassssss/eechat/releases)**

## 安装 eechat 并配置硅基流动模型

### 1. 安装 eechat（以 Windows 为例）

* 下载并运行安装包，点击安装。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ba8d8b81e27820c74707f0c95d699a4d" data-og-width="872" width="872" data-og-height="630" height="630" data-path="images/usercases/eechat/win-install-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cd8685dcc56984b75b04b2b176522099 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2fcf3bff4fe33d5c15e296c011eae9f0 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e7834d45694cd49d780fed2ad51ba85d 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=71a40c08cd4eb47c131713bcc42b7a23 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5fa0f18e12311b56f4ae32b8bdfdfd86 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=75829c3c67e224282d8857a2aac131a3 2500w" />
</Frame>

* 点击“浏览”，选择安装路径，确认后开始安装。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1b96c15cfd33f53e4fcf24da38dbf592" data-og-width="1736" width="1736" data-og-height="861" height="861" data-path="images/usercases/eechat/win-install-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a35dede4850c893d8a3fa60b1ae86da2 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6a3745facec3b6a5ef6296bcba574031 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a4bda9376cb683fc9925b24e3e30c95c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b068e5d568ee1075f8e61b6d4e4b9278 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=90834744f264a7613245775a2fd27e03 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=855980f5b86a5b32915a565293d82853 2500w" />
</Frame>

* 安装完成后，打开 eechat，按图示操作

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=aac28c4a290f329331ff4510d8ae419d" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/win-install-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dea56b3bff20dfd2b7bcf22e894dc06a 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fd7d98eb777ff22c2a0dfa5b4602bf19 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=447615949d0eb2464eaee2c77a92f09c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c33c16ffb4b33cceb297210c8177429a 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6f37307c80c1f87ceb2486a6a9aa5bd7 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=042f1d8b4682749ec5e31ddcc820b1bc 2500w" />
</Frame>

1. 点击左侧菜单的最后一个图标“设置”
2. 选中设置下的 “API 模型”
3. 在 API 模型提供商中选择 "硅基流动"
4. 点击获取 API Key，打开硅基流动登录页面，如果已登录会进入硅基流动控制台页面

### 2. 获取 API Key

* 点击获取 API Key 后，会在浏览器打开硅基流动登录页面，登录您的账户信息

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=266abd055e7865e472e92716ed2e1f92" data-og-width="950" width="950" data-og-height="918" height="918" data-path="images/usercases/eechat/win-install-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=095d6df5a5ee88564cd39f65f8a5f8ff 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8996eec22b0eef86feade63b7858117b 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f43f91d9754e8a9ab1ffdc62a23cd15e 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=16d24079bb1e6c9809b49df9abb7f2ef 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02361e1e0e6b535c15210465f776fa4b 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e851dd1cc9e120a28594174e2fbad748 2500w" />
</Frame>

* 创建 API Key

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9b7925bd8f0b23a07d5b4667928dbf60" data-og-width="1731" width="1731" data-og-height="1246" height="1246" data-path="images/usercases/eechat/siliconflow-create-key.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6c0343d58d2a5ee7c0d24058248d06db 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d72ecb7dbb106478a6155889c9da021e 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8cfe4b6991ce2970a70c34f0ed224c84 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=273a3b30b1457bd1b89eaab3b4b35375 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0a15e79a26e611f3f0a73a6a56920daf 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=de977183fe4173eacd919386dbf7ffc9 2500w" />
</Frame>

### 3. 配置 API Key

* 在 eechat 中配置提供商和 API Key

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=97fd4503a0000fcab1ecb3fc8e976332" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/win-config-provider.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e6d7c3d3247e79e998a486d65d54094b 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b05f599c2832adfcdf8f16ac20ba7d9d 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8496c5d9eb002f41fefc9ec5da9faef6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0bf22091368a7d79555712059f627c81 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2677f986a3d965e952a54fa322dd67f4 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=065cdf98c3d7697203337489d0757ec8 2500w" />
</Frame>

1. 在 eechat 的 API 模型提供商中选择 "硅基流动"
2. 在 API Key 中粘贴刚刚创建的 API Key
3. 在 API URL 中输入 `https://api.siliconflow.cn/v1`
4. 点击测试连接，如果测试成功就可以直接对话了，如果测试失败，请检查 API Key 或 API URL 是否正确。

> 硅基流动的 API 接口默认是`https://api.siliconflow.cn/v1`，如有变动以 API 手册为准。

### 4. 配置模型

* 在 eechat 中点击“模型列表”

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d4d40f1ab52e15201d94f87767dc52ad" data-og-width="1516" width="1516" data-og-height="1253" height="1253" data-path="images/usercases/eechat/add-model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c0fd1af55ce444fb157337e619c322bd 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c4baeea2db6f59d77f2afb7c1f408ce7 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1d2dd02be5c94fc9bf152f0c994a849c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=684543d47c2fca30dc271fa285e88c64 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8faa6d4ad8f3adef510c77963a7c5d18 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d139285402d7f2fa2591dfeef66957f5 2500w" />
</Frame>

* 在弹出的浏览器窗口中，选择所需模型（如 Qwen3），如下图 ①
* 复制对应模型卡片的模型 ID，如下图 ②

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=511a4eee76d1f2b344ee54f220cc594d" data-og-width="2244" width="2244" data-og-height="1093" height="1093" data-path="images/usercases/eechat/siliconflow-copy-model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ef5e9b596e474beda89f841485c714cb 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=836c968bd1d9957f0bab7134912ab5d7 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=014f29d87c147122dbad05305fef6bce 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c8e8d394d14a81d50b35102058d9a0cf 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7bd4496a83225b4c92927009fba63cc9 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=18ef9bc112b0ab5de7cc20509b03e941 2500w" />
</Frame>

* 点击 eechat "新增模型" 按钮，在弹出的窗口中，粘贴刚刚复制的模型 ID，点击确定

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cb4245eba2e3925a1c27c2cf79db62db" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/add-model-id.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c63d5b0526d2936cf6241867eb02a01e 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=40dc025fa75b44a7bf08f599806186e6 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a6c812771fee72fc10afc3e8ca16a85f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=488bf82ecb93f2eed6729520cd830ece 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8a184c0345eb042b1d24961ce18b43e6 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d40e8b9ddc87f0c9b73792f151b6e068 2500w" />
</Frame>

这样模型就添加成功了。

## 在聊天中使用模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cab4a4a765cc97ca7c2db69b58c16ab2" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/select-model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7c29ece4950074322e1f683b16086d17 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=404acb0c66626f79ea930ff3d3d115bc 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=91087e496e93144b48e9fd7d52f520db 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b558727384e1d197db463bbcf606a791 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=da00e30b0192ac16d130ab952ab77e2b 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=69b2ccc01339861e6ad97252421186ba 2500w" />
</Frame>

打开对话菜单，选择模型，开始聊天吧！

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=36dba0dc1bd73f18ecd65eb2b2dc79e3" data-og-width="1934" width="1934" data-og-height="1403" height="1403" data-path="images/usercases/eechat/talk.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4ae2da671e74f60ba6cfcb0fec1727b2 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=414ff84caffd241e82185a7b65ca595c 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4f6139db5294abce537956bbf289b3a6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=61f7b33c7f819a71faa3a73aa729317d 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c8274fccdc27d0d9b2053d9e7d044a80 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b5e49b6255b67fbfadb2044dce99483d 2500w" />
</Frame>

## 相关参考

* 💻 [eechat 官网](https://ee.chat)
* 🧑‍💻 [eechat GitHub](https://github.com/Lucassssss/eechat)
* ☁️ [硅基流动 API 密钥](https://cloud.siliconflow.cn/account/ak)
* 📘 [硅基流动官方文档](https://docs.siliconflow.cn)

如何你觉得 [eechat](https://github.com/Lucassssss/eechat) 不错，欢迎给一个 Star ⭐️ 支持开源项目发展！


# FastGPT
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-fastgpt



<Note>
  本文转载自 [FastGPT](https://fastgpt.run) 的官方文档，介绍了如何在 FastGPT 中使用 SiliconFlow 的模型。[原文地址](https://doc.tryfastgpt.ai/docs/development/modelconfig/siliconcloud/)
</Note>

[SiliconFlow](https://cloud.siliconflow.cn/i/TR9Ym0c4) 是一个以提供开源模型调用为主的平台，并拥有自己的加速引擎。帮助用户低成本、快速的进行开源模型的测试和使用。实际体验下来，他们家模型的速度和稳定性都非常不错，并且种类丰富，覆盖语言、向量、重排、TTS、STT、绘图、视频生成模型，可以满足 FastGPT 中所有模型需求。

如果你想部分模型使用 SiliconFlow 的模型，可额外参考[OneAPI接入硅基流动](https://doc.tryfastgpt.ai/docs/development/modelconfig/one-api/#%E7%A1%85%E5%9F%BA%E6%B5%81%E5%8A%A8--%E5%BC%80%E6%BA%90%E6%A8%A1%E5%9E%8B%E5%A4%A7%E5%90%88%E9%9B%86)。

本文会介绍完全使用 SiliconFlow SiliconFlow 账号

1. [点击注册硅基流动账号](https://cloud.siliconflow.cn/i/TR9Ym0c4)
2. 进入控制台，获取 API key: [https://cloud.siliconflow.cn/account/ak](https://cloud.siliconflow.cn/account/ak)

## 2. 修改 FastGPT 环境变量

```bash  theme={null}
OPENAI_BASE_URL=https://api.siliconflow.cn/v1
# 填写 SiliconFlow 控制台提供的 Api Key
CHAT_API_KEY=sk-xxxxxx
```

## 3. 修改 FastGPT 配置文件

我们选取 SiliconFlow 中的模型作为 FastGPT 配置。这里配置了 `Qwen2.5 72b` 的纯语言和视觉模型；选择 `bge-m3` 作为向量模型；选择 `bge-reranker-v2-m3` 作为重排模型。选择 `fish-speech-1.5` 作为语音模型；选择 `SenseVoiceSmall` 作为语音输入模型。

注意：ReRank 模型仍需配置一次 Api Key

```json  theme={null}
{
    "llmModels": [
    {
      "provider": "Other", // 模型提供商，主要用于分类展示，目前已经内置提供商包括：https://github.com/labring/FastGPT/blob/main/packages/global/core/ai/provider.ts, 可 pr 提供新的提供商，或直接填写 Other
      "model": "Qwen/Qwen2.5-72B-Instruct", // 模型名(对应OneAPI中渠道的模型名)
      "name": "Qwen2.5-72B-Instruct", // 模型别名
      "maxContext": 32000, // 最大上下文
      "maxResponse": 4000, // 最大回复
      "quoteMaxToken": 30000, // 最大引用内容
      "maxTemperature": 1, // 最大温度
      "charsPointsPrice": 0, // n积分/1k token（商业版）
      "censor": false, // 是否开启敏感校验（商业版）
      "vision": false, // 是否支持图片输入
      "datasetProcess": true, // 是否设置为文本理解模型（QA），务必保证至少有一个为true，否则知识库会报错
      "usedInClassify": true, // 是否用于问题分类（务必保证至少有一个为true）
      "usedInExtractFields": true, // 是否用于内容提取（务必保证至少有一个为true）
      "usedInToolCall": true, // 是否用于工具调用（务必保证至少有一个为true）
      "usedInQueryExtension": true, // 是否用于问题优化（务必保证至少有一个为true）
      "toolChoice": true, // 是否支持工具选择（分类，内容提取，工具调用会用到。）
      "functionCall": false, // 是否支持函数调用（分类，内容提取，工具调用会用到。会优先使用 toolChoice，如果为false，则使用 functionCall，如果仍为 false，则使用提示词模式）
      "customCQPrompt": "", // 自定义文本分类提示词（不支持工具和函数调用的模型
      "customExtractPrompt": "", // 自定义内容提取提示词
      "defaultSystemChatPrompt": "", // 对话默认携带的系统提示词
      "defaultConfig": {}, // 请求API时，挟带一些默认配置（比如 GLM4 的 top_p）
      "fieldMap": {} // 字段映射（o1 模型需要把 max_tokens 映射为 max_completion_tokens）
    },
    {
      "provider": "Other",
      "model": "Qwen/Qwen2-VL-72B-Instruct",
      "name": "Qwen2-VL-72B-Instruct",
      "maxContext": 32000,
      "maxResponse": 4000,
      "quoteMaxToken": 30000,
      "maxTemperature": 1,
      "charsPointsPrice": 0,
      "censor": false,
      "vision": true,
      "datasetProcess": false,
      "usedInClassify": false,
      "usedInExtractFields": false,
      "usedInToolCall": false,
      "usedInQueryExtension": false,
      "toolChoice": false,
      "functionCall": false,
      "customCQPrompt": "",
      "customExtractPrompt": "",
      "defaultSystemChatPrompt": "",
      "defaultConfig": {}
    }
  ],
  "vectorModels": [
    {
      "provider": "Other",
      "model": "Pro/BAAI/bge-m3",
      "name": "Pro/BAAI/bge-m3",
      "charsPointsPrice": 0,
      "defaultToken": 512,
      "maxToken": 5000,
      "weight": 100
    }
  ],
  "reRankModels": [
    {
        "model": "BAAI/bge-reranker-v2-m3", // 这里的model需要对应 siliconflow 的模型名
        "name": "BAAI/bge-reranker-v2-m3",
        "requestUrl": "https://api.siliconflow.cn/v1/rerank",
        "requestAuth": "siliconflow 上申请的 key"
    }
  ],
  "audioSpeechModels": [
    {
        "model": "fishaudio/fish-speech-1.5",
        "name": "fish-speech-1.5",
        "voices": [
            {
                "label": "fish-alex",
                "value": "fishaudio/fish-speech-1.5:alex",
                "bufferId": "fish-alex"
            },
            {
                "label": "fish-anna",
                "value": "fishaudio/fish-speech-1.5:anna",
                "bufferId": "fish-anna"
            },
            {
                "label": "fish-bella",
                "value": "fishaudio/fish-speech-1.5:bella",
                "bufferId": "fish-bella"
            },
            {
                "label": "fish-benjamin",
                "value": "fishaudio/fish-speech-1.5:benjamin",
                "bufferId": "fish-benjamin"
            },
            {
                "label": "fish-charles",
                "value": "fishaudio/fish-speech-1.5:charles",
                "bufferId": "fish-charles"
            },
            {
                "label": "fish-claire",
                "value": "fishaudio/fish-speech-1.5:claire",
                "bufferId": "fish-claire"
            },
            {
                "label": "fish-david",
                "value": "fishaudio/fish-speech-1.5:david",
                "bufferId": "fish-david"
            },
            {
                "label": "fish-diana",
                "value": "fishaudio/fish-speech-1.5:diana",
                "bufferId": "fish-diana"
            }
        ]
    }
  ],
  "whisperModel": {
    "model": "FunAudioLLM/SenseVoiceSmall",
    "name": "SenseVoiceSmall",
    "charsPointsPrice": 0
  }
}
```

## 4. 重启 FastGPT

## 5. 体验测试

### 测试对话和图片识别

随便新建一个简易应用，选择对应模型，并开启图片上传后进行测试：

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-68.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-70.png) |

可以看到，72B 的模型，性能还是非常快的，这要是本地没几个 4090，不说配置环境，输出怕都要 30s 了。

### 测试知识库导入和知识库问答

新建一个知识库（由于只配置了一个向量模型，页面上不会展示向量模型选择）

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-72.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-71.png) |

导入本地文件，直接选择文件，然后一路下一步即可。79 个索引，大概花了 20s 的时间就完成了。现在我们去测试一下知识库问答。

首先回到我们刚创建的应用，选择知识库，调整一下参数后即可开始对话：

|                                                                                             |                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-73.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-75.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-76.png) |

对话完成后，点击底部的引用，可以查看引用详情，同时可以看到具体的检索和重排得分：

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-77.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-78.png) |

### 测试语音播放

继续在刚刚的应用中，左侧配置中找到语音播放，点击后可以从弹窗中选择语音模型，并进行试听：

![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-79.png)

### 测试语言输入

继续在刚刚的应用中，左侧配置中找到语音输入，点击后可以从弹窗中开启语言输入

![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-80.png)

开启后，对话输入框中，会增加一个话筒的图标，点击可进行语音输入：

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-81.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-82.png) |

## 总结

如果你想快速的体验开源模型或者快速的使用 FastGPT，不想在不同服务商申请各类 Api Key，那么可以选择 SiliconFlow 的模型先进行快速体验。

如果你决定未来私有化部署模型和 FastGPT，前期可通过 SiliconFlow 进行测试验证，后期再进行硬件采购，减少 POC 时间和成本。


# 飞书多维表格
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-feishu



飞书多维表格已正式接入硅基流动 SiliconFlow 平台，你可以直接在多维表格的 AI 字段捷径中心调用平台上包括 DeepSeek-R1、QWQ-32B 等热门大模型，搭配多维表格的批量结构化数据处理和业务自动化构建能力，一键完成创作、翻译、分类、总结等操作，享受更快、更准、更聪明的数据管理体验。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-1.gif?s=4a446bd498b66c1a649b7eee4a04c4b1" data-og-width="888" width="888" data-og-height="526" height="526" data-path="images/usercases/feishu/feishu-1.gif" data-optimize="true" data-opv="3" />
</Frame>

## 使用方法

### 1. 进入飞书，点击 “多维表格”，“新建多维表格”。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5bcaf6826fa3956636ed989913cf14de" data-og-width="1080" width="1080" data-og-height="685" height="685" data-path="images/usercases/feishu/feishu-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dcc6b759fbadce1cc1d2aa06c430face 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7279c9b80aadf86d5513fe31643bd87f 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=377351734991d9510def5d5ad894b615 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0709b3d8928654f23a77d00e2a3ef3de 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a0dd7b6676365b3748dc4041ba36e5f3 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1b2d2b214226f1dc3e4f2d83408abe19 2500w" />
</Frame>

### 2. 创建 DeepSeek-R1 AI 字段捷径

* 在左侧的导航栏中打开需要使用的数据表，创建文本字段，输入任务关键词（如"自媒体文案主题"），该字段将作为后续 AI 任务指令的引用字段。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2c1d259962726ca7ec009bb9abcae940" data-og-width="702" width="702" data-og-height="583" height="583" data-path="images/usercases/feishu/feishu-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1431fec95fcfa17b49ff146b4894ce17 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=975fcd7f78f75ea043017dd243bc1959 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c3667fea2b18cdf9c70b7cf19332b0f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7388f36c0a2dcdd0aeecc1a9fdb9cf90 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d5fb5130472eaf4380fcd0b7b249f775 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c19735637510217e5c011a6430fd4560 2500w" />
</Frame>

* 点击字段名右侧的“+”或搜索字段。点击悬停字段类型的 “探索字段捷径” ，搜索“硅基流动”并选择 “AI 大模型（硅基流动）”。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=98541de8706a2a6c575c6c6afc5cc805" data-og-width="1024" width="1024" data-og-height="740" height="740" data-path="images/usercases/feishu/feishu-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=97c3b47cf7478e739d6d554b34570467 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=930f2af5f8b0bff8884f18bbf6ce0c8f 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e66d79acbe4cb3837f235065b4c1959e 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8f1bdce7b6dd9d22800ea956156dc2b3 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=121cb61d4b76bf8f4716bccf761bbead 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5a7c93b2349949d2d753cc05e608c507 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02685fe5c9f1a3f35a86aba6a47d72bc" data-og-width="1024" width="1024" data-og-height="788" height="788" data-path="images/usercases/feishu/feishu-5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=31b1cd99c5aa71eaf24a1297e51b53df 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f7ad2e8ff268c1e1a9dccbf5ec4971d5 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7e42f5e6d78571b354b8df3ac2124249 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=27e6e17d976140127a9090fa3be9f285 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e29122ec27606cb51f5228510b090f00 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=af57c9346523182334c7088af939c293 2500w" />
</Frame>

* 点击“关联账号”按钮，跳转 硅基流动 SiliconFlow 平台以获取 API 密钥，复制 API 密钥，返回当前页面，将 API 密钥粘贴至指定输入框内。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=717187ba43bb8ca32d118317c3f3c738" data-og-width="1024" width="1024" data-og-height="703" height="703" data-path="images/usercases/feishu/feishu-6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=56a70062f8bff97b91083617495378a6 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=58b91949dc9642f09a41fc487fc69ae0 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9f46e38dcec69f32d4aa25b19948d179 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7f85256aa7effc48c6f627070ba72a3c 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9ac4702df4ca7514673c6e55ac209fb9 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=64b351cc864fc557267b07cebbd72b1c 2500w" />
</Frame>

硅基流动 SiliconFlow 默认提供 Qwen/QwQ-32B、Pro/deepseek-ai/DeepSeek-R1、THUDM/GLM-Z1-32B-0414 和 DeepSeek-R1-Distill-Qwen-32B 四款 AI 模型，用户可以按需选择。

* 在"输入指令"栏中直接输入文字指令，点击右上角 ”+引用字段” 添加数据表字段，系统自动将输入文字与引用字段拼接为完整指令。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c1be686bfa68ab945500667e4eac03b" data-og-width="978" width="978" data-og-height="690" height="690" data-path="images/usercases/feishu/feishu-7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a32e66b16512a44ace1b52156b913da6 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1a3e3951c806b9c4f1cad10c165da632 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3e35f95d0e9ec603dcf29a9df1bf61e7 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7d481421b4f7c424d2448ce89e8cb058 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=92172c4d2ba4d00cf8d90187b896a608 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=93b47df49059930b7319db147e5bbe3a 2500w" />
</Frame>

* 点击“确认”并生成内容，查看字段名右上角百分比可得知任务处理进度，任务完成后图标自动消失。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b4a968c5e561987a2af67157a28652ff" data-og-width="1080" width="1080" data-og-height="510" height="510" data-path="images/usercases/feishu/feishu-8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0079c54dd969a4926bcef3a3e7e257eb 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4e1e0a905ed3ae1cb834582f8c04c540 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b94d1b807e2b66f11d3839010f4c6fef 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ef08b4a3fd8f865046d9dcee2bd2adae 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ff90947b67464a54be8a75d89a487148 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fd9a82e48e0efa5deca8af9f19817edf 2500w" />
</Frame>

* 鼠标光标悬停在字段列的任意单元格，点击“查看”，上下滑动即可浏览模型生成的完整内容，包括模型执行任务时的思考过程和输出结果。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=569a2ecbe4a45f1414f4e698ba49c8da" data-og-width="1080" width="1080" data-og-height="510" height="510" data-path="images/usercases/feishu/feishu-9.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=172fb2e904934f58272add1e967ae77c 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b9cd38fb231fe1634acf4bbc8536e39a 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7636514f98f07ee0f59c451bf62c83d6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fe2236897e718dedac9578e9f0e96554 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=279725cd46d3d7630225f1f5b2aaa7df 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=972c3e5fc30e8da9d41d3ceb9f2472da 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-10.gif?s=d6bd02ed60555270f3101acbd67d5d5c" data-og-width="1079" width="1079" data-og-height="849" height="849" data-path="images/usercases/feishu/feishu-10.gif" data-optimize="true" data-opv="3" />
</Frame>

* 你也可以双击单元格查阅对应的生成内容。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dd6bf18c84b12c48ec27d8281d320b4e" data-og-width="1080" width="1080" data-og-height="590" height="590" data-path="images/usercases/feishu/feishu-11.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b45cc924614e491c572fac015c76c1f0 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=893459dd6682e505fc700d45234b7d55 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=af31d1ec4d0c3e7dccffdaca3baf91b5 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7417fd2b7c9692fde43b44d44bbcd786 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ddcd9613dc5248b378cf8098e3a3b1ae 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a78e392e8729f1e183ade02b352557e1 2500w" />
</Frame>

注：“硅基流动”字段捷径开箱即用，尝鲜用户会有部分免费配额，超过上限后，用户可自助绑定硅基流动 SiliconFlow 账号继续使用模型。

## 错误码信息

| **错误码**   | **原因**                                     | **解决方案**                                |
| --------- | ------------------------------------------ | --------------------------------------- |
| 800004780 | 密钥填写错误                                     | 确认密钥正确填写                                |
| 800004781 | 当前捷径有大量任务处理中，请稍后重                          | 可能遇到高峰期，稍后重试                            |
| 800004782 | 1. 飞书赠送额度已用完；2. 需要绑定个人硅基流动账户使用额度           | 硅基流动绑定自己的 api key，                      |
| 800004783 | 高峰期排队导致服务超时                                | 等待一段时间后刷新，不要频繁刷新                        |
| 800004788 | 高峰期排队导致服务超时                                | 等待一段时间后刷新，不要频繁刷新                        |
| 800004789 | 1. 飞书赠送额度已用完；2. 需要绑定个人硅基流动账户使用额度；3. 密钥填写错误 | 请对照以下几个方案依次排查：1. 查看硅基流动账户余额；2. 确认密钥正确填写 |

## 联系开发者

点击此处的“联系开发者”进入话题群，也可以通过直接扫描下面官方群二维码进入。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=40789132bcf91e7f51bfa832d45402ec" data-og-width="1280" width="1280" data-og-height="398" height="398" data-path="images/usercases/feishu/feishu-12.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6d69972af2f20803eaf6a1969a740a69 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dc63eb714085bea06d44d2a4635ac18e 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7dd71e6770b014571662b7d475f77acb 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3d549f18b732501b3d1554abbb578624 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d46a08ad0691d27ace74c5c301f3d1f1 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=82dc96b146fa48a2a8bba1216981ec2b 2500w" />
</Frame>

### 官方群

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e6c723ba434c1799e6eebca003df6b76" data-og-width="744" width="744" data-og-height="754" height="754" data-path="images/usercases/feishu/feishu-13.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1dadbe60e50bba220bda5e3585332de1 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9a613239ddb9eda21ff66b6aa5c508ce 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=258573da3f32ca3923407a9c2ce742a6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b3ac27524c2251f357feb8450296e6c9 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ca95617f8f2362e677505e7626c3daa1 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=36a0ee6f7219c52bf2d115a6f714c3ec 2500w" />
</Frame>


# 沉浸式翻译
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-immersive-translate

在沉浸式翻译中，调用 SiliconFlow 的 API，实现快速跨语言翻译的目标

作为全网口碑炸裂的双语对照网页翻译插件，[沉浸式翻译](https://immersivetranslate.com/)使用大语言模型，具备跨语种理解能力，能够实时翻译外语内容，可应用于网页阅读、 PDF 翻译、 EPUB 电子书翻译、视频双语字幕翻译等场景，并支持各种浏览器插件和应用使用。自 2023 年上线以来，这款备受赞誉的 AI 双语对照网页翻译插件，已帮助超过 100 万用户跨越语言障碍，汲取全球智慧。

硅基流动的 SiliconFlow 第一时间提供 GLM4 、 Qwen2 、 DeepSeek V2 、零一万物等大模型，将三方大模型和沉浸式翻译插件相结合，极大改善翻译时的速度和准确度。

## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在沉浸式翻译中使用 SiliconFlow

### 2.1 默认配置

1. 在“沉浸式翻译”[官网](https://immersivetranslate.com/zh-Hans/)选择“安装浏览器插件”，选择合适的浏览器版本，根据提示进行安装。如您已安装对应插件，请跳过本步骤。
2. 点击沉浸式翻译拓展，点击设置，出现弹窗，将弹窗中的“翻译服务”设置为“ SiliconFlow 翻译”
3. 设置成功后即可开始使用 SiliconFlow 翻译服务。

### 2.2 使用 SiliconFlow 的其他免费模型：

1. 设置的默认模型是 SiliconFlow 的“ Qwen/Qwen2-7B-Instruct ”，如果需要切换成 SiliconFlow 的其他模型，请点击图标中的“设置”，打开设置界面。
2. 在“基本设置”中选择其他模型，即可使用 SiliconFlow 的其他免费模型。

### 2.3 使用 SiliconFlow 的其他文本生成模型：

1. 如需使用 SiliconFlow 其他模型，点击沉浸式翻译的扩展图标，找到“设置”按钮并点击，选择“更多翻译服务”。
2. 代开设置页后点击“翻译服务”，划到底部，点击`添加兼容 Open AI 接口的自定义 AI 翻译服务？`。
   3.根据要求添加 SiliconFlow 模型的相关信息

* **自定义翻译服务名称：** 按照自己的实际情况填写即可。
* **自定义 API 接口地址：** [https://api.siliconflow.cn/v1/chat/completions](https://api.siliconflow.cn/v1/chat/completions)
* **API Key：** 将 SiliconFlow 平台的密钥粘贴到此处。
* **模型名称：** 模型在 SiliconFlow 中的名称

3. 完成配置后，点击右上角的测试，进行验证。

4. 配置成功后即可开始使用其他文本生成大模型。


# 微服务编排框架 Juggle
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-juggle



## 1. 关于 Juggle

[Juggle](https://juggle.plus) 是一个零码 + 低码 + AI 的微服务编排 & 系统集成的强大编排工具平台，致力于为用户提供微服务接口编排、第三方系统对接、标准产品私有化定制、数据清洗等痛点的解决方案。支持 Http , Dubbo , WebService 等协议的接口编排，支持通过 Groovy , JavaScript , Python , Java 等多种脚本语言来增强流程，支持使用 MySQL，达梦等几十种常见数据源。赋能企业业务系统，实现合作共赢。

**项目特点：**

* 全零码化搭建流程，上手容易

* 全私有化部署，数据安全有保障

* 极致性能追求，高并发无压力

项目开源地址：[GitHub](https://github.com/somta/Juggle)

## 2. 使用 Juggle

前往 [Juggle 官网](https://juggle.plus)下载最新 Juggle 版本，参考 [Juggle 安装手册](https://juggle.plus/docs/guide/start/quick-start/)进行安装使用。

## 3. 在 Juggle 中使用 SiliconFlow

### a. 获取 API Key

打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可），完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak)，创建新的 API Key，点击密钥进行复制，以备后续使用。

### b. 安装硅基流动套件

进入 Juggle 套件市场，在套件市场中搜索**硅基流动**，安装硅基流动套件，后续就能在流程中使用硅基流动提供的接口了。

<Frame>
  <img width="700" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a6bf85eaaf73a22c8dbc2f521cbca995" data-og-width="1918" data-og-height="733" data-path="images/usercases/Juggle/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2799c12fa84bc4a4bf8dcef440ae5657 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7be8400bac32baa51a3c3474984c5e13 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8c9037acaf8f9bbd711d16c9c5ddce5d 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=392b6792f45e44b3f57f7b941de0e578 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c9f452becf74dc8bb64860d3459243df 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/Juggle/3.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=25862428a77f3363ae6f4c9551c63df5 2500w" />
</Frame>

### c. 使用硅基流动接口

在流程中新建一个**方法节点**，在方法节点的设置中选择**硅基流动套件**，就可以选择硅基流动提供的文本对话，生成图片，生成视频等各种接口了，基于这些接口能力，用户可以编排出各种场景的流程，来满足用户的不同场景的需求。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=57033ed60a5d858234758de956af47b9" data-og-width="1099" data-og-height="857" data-path="images/usercases/Juggle/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9f94679157aec9dcab3231ff1fbba3ff 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3e3b4f55f80f4a34a841ec6c7c631dec 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=69304e24505d300750155f1ab9fe467d 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6b7253913fddbf8a44b6e4c0b1f9ea89 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b0b8b67a978a8578d9a81c474169aacf 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/Juggle/4.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3fd5e912f84c689bac7e02e0bd3bb780 2500w" />
</Frame>


# LangBot
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-langbot



## 关于 LangBot

[**LangBot**](https://langbot.app) 是一个开源的即时通信机器人平台，支持接入 **飞书、钉钉、QQ、微信、Discord、Telegram 等多种消息平台**，帮助用户直接在这些平台内进行任务处理或作为业务组成部分。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=00a694ed6ec0124acd6643a90dbd8b16" data-og-width="2724" width="2724" data-og-height="1706" height="1706" data-path="images/usercases/langbot/hero.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=596bf53d931fa7c8cc17bddac889bb6b 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f1ef347ceeec81b95e9ff7cd2c664cfb 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e133ea8dcee99e3e1852ed5fa1665555 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=71e5ec5e0fe5a86f40d0c3cd099daa6d 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=163d978dddb5f80e64e0b3ea0aef3e35 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=28e3e9041f8e50766fa9276353399b58 2500w" />
</Frame>

结合 [**SiliconFlow**](https://siliconflow.cn/zh-cn/siliconcloud) 提供的大模型 API 服务，LangBot 可以接入多种主流开源大模型，用户可根据不同场景需求选择合适的模型。以下为完整的配置教程，简单几步即可拥有专属智能助手。

## 配置教程

### 第一步：获取硅基流动 API Key

#### 获取 API Key

1、注册并登录 [硅基流动](https://cloud.siliconflow.cn/)。

2、进入`API 密钥` 页面，生成 API 密钥。

#### 获取模型信息

访问 `模型广场` 查看可用模型及详细参数。

### 第二步：部署并配置 LangBot

#### 使用 Docker 部署 LangBot

> 更多部署方式可查看[文档](https://docs.langbot.app/zh/insight/guide.html)

确保已安装 Git 和 Docker。

```bash  theme={null}
git clone https://github.com/langbot-app/LangBot  
cd LangBot
docker compose up -d
```

> 如果在中国大陆使用，可将 `docker-compose.yaml` 中的镜像替换为：

```
docker.langbot.app/langbot-public/rockchin/langbot:latest
```

#### 访问 WebUI

启动后访问：

```
http://127.0.0.1:5300
```

首次运行会提示创建配置文件，请根据提示完成初始化。

#### 配置对话模型

1. 登录 WebUI，进入 **模型配置** 页面。
2. 添加新模型，填写如下信息：

| 字段      | 内容                           |
| ------- | ---------------------------- |
| 模型名称    | 根据需要选择的模型名称，可以在硅基流动的模型广场页面获取 |
| 模型提供商   | 选择`硅基流动`                     |
| API Key | 从`硅基流动`-`API 密钥`页面获取的密钥      |
| 模型能力    | 根据硅基流动页面描述勾选                 |

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3788bf4d75c8ccd90ce5a70bf560c2d7" data-og-width="1446" width="1446" data-og-height="474" height="474" data-path="images/usercases/langbot/find_model_name.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=28eaed3615bbeacb43970d4c9aa46a44 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=38629a22fc5764b25810bbfae0ba131d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eb6176e8982f854b25f426b6e4c608c7 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0bf5b0958e06258e41b6bfb19c67e829 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=411d3690b994d4adb196a690c06bc303 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1c50988a8bd5adbe9bea268df74acc2c 2500w" />
</Frame>

模型名称可在 SiliconFlow 模型详情页标题找到。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e0a007a33a43b8d79ddd089ff6d5b2a2" data-og-width="2426" width="2426" data-og-height="1584" height="1584" data-path="images/usercases/langbot/create_model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=df9476f262b3a638dd213c7233b40318 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d184833aa5a86080c8f03511cdbc1cc2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=aa73bd3c9a4fb0fa257cb83a4e097d49 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=5e287375f29a099b4c0850919b2efe87 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e538662bf3e9430e01647b6bca105dea 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=22cf8a5905d36ca1bc0623972f55a14f 2500w" />
</Frame>

### 第三步：接入平台（以钉钉为例）

> 企业微信、飞书、Discord、Telegram、QQ、微信 等更多平台，请参考 [LangBot 文档](https://docs.langbot.app/zh/insight/guide.html)

#### 创建钉钉机器人应用

1、登录 [钉钉开发者后台](https://open-dev.dingtalk.com/)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6308b4c3a10ef3be46f576ea7a6890d5" data-og-width="2814" width="2814" data-og-height="1425" height="1425" data-path="images/usercases/langbot/dingtalk_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=50ffcc392f7ba69de2b13a753fb0fb6d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=acc53f8a45173c250fa816414080d74e 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=da50a6a380c2d69e37172ec0ef9b51b5 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1f0905b06d75c33902b931ab51584483 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8876c266705c3193f57e203a0978e6dd 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=075bb0daa788496ba9471d26d4aadc72 2500w" />
</Frame>

2、进入组织，点击「应用开发」→「创建应用」，填写基本信息。

3、添加「机器人」能力，完成基础配置并发布。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=032269050da1291a4d9800e5f1e2fb91" data-og-width="2858" width="2858" data-og-height="1301" height="1301" data-path="images/usercases/langbot/dingtalk_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c49f22954a522a9fbc010054e0f348be 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e3446fea0a915c059de90aa9bfe7f670 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0f521ad82aad99636882effe91889c2c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4ea3bad7f97491dd1f9c0b1461e17ce5 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8cbc1400a0e0c42a92ffcaa160370ed7 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3656b41f1b4ad2fe1ef916e0f88d957b 2500w" />
</Frame>

#### 配置机器人

* 在「机器人」选项卡中填写相关信息并发布。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0b5ecdbbe56332bf2c0eb45ea0026eed" data-og-width="2857" width="2857" data-og-height="1435" height="1435" data-path="images/usercases/langbot/dingtalk_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3691d089d18ff7163f9df69305df1401 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=53a45ad6bbec245438e83cd76b77128f 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c3a930aef432be435b1c4fdf94a5bf39 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b49ca7499292deedc11c50128f51f2cc 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ba369aafaefb7bf3ce7341d78d7d6a4e 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ced9c9b98e0449bc7c038340a22962ff 2500w" />
</Frame>

* 在「版本管理」中配置版本号。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c0a4e49c870aa41493d3105ac3ea7826" data-og-width="2857" width="2857" data-og-height="1385" height="1385" data-path="images/usercases/langbot/dingtalk_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6f4a6acf80db91f640d0ef4fd313b80f 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=674c19995dbf9cd68bc458517416fafa 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2763ce71f45667a3a4a5de60a1938883 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4481eb8e36c117fb880aac8b71e4f86e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c82ed5efc16b2b11f9170d577c5829d8 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e6f0046549e758c4dbea67cbdbbb63f2 2500w" />
</Frame>

* 在「事件订阅」中选择 **Stream 模式**，无需公网回调地址。
* 在「凭证与基础信息」中记录：
  * Client ID
  * Client Secret
  * RobotCode
  * 机器人名称

#### 配置 LangBot 平台绑定

1、打开 LangBot WebUI，编辑机器人。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=afbc3c91969dc888e19e77f58d67a9ed" data-og-width="1024" width="1024" data-og-height="1644" height="1644" data-path="images/usercases/langbot/create_bot.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b3f7c113f56986f3b8bc3585e5545d01 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=876db36147ba10c03c6e56ceda561173 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a8b2458104111de67af8d456c2b74636 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a6461349b9f306c0344c356a82f26e85 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=78f926209f6eb5d5dc8dee6b524783b0 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6c3d26cfd5d828324133a45296363071 2500w" />
</Frame>

2、绑定流水线（默认已有 `ChatPipeline`），平台选择 **钉钉**。

3、编辑流水线，在 AI 能力中选择 **内置 Agent**，并选择此前配置好的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6fd094208feb27654bdd29464d74a602" data-og-width="1614" width="1614" data-og-height="1402" height="1402" data-path="images/usercases/langbot/config_pipeline.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=988565cdbef754123cd70ff9c88ba49b 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=626853bc803accb7eaf75702291068da 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6220d5e2c451d2fb4b62727794f5a28b 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0e20b32df6e35c918c7d8f08ec8a0a37 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2d52b7aa3d417d3b208e66b90e16d262 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=584388fe2cf26208ca6da1b2f9172b84 2500w" />
</Frame>

### 第四步：使用机器人

1、在钉钉搜索机器人名称，点击即可开始聊天。

2、如需在群聊中使用，可在群设置中点击「添加机器人」，搜索名称添加。


# LazyCraft
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-lazycraft



LazyCraft 是基于 LazyLLM 搭建的应用编排平台，它支持大模型调用和自定义代码块，具备强大的资源管理和数据集成能力，并配合 RAG 技术，支持自定义离线解算和在线调用。在 LazyCraft 中使用 SiliconFlow 模型，结合 SiliconFlow 模型丰富、速度快的优势，快速构建多样化的 AI 应用。

## 1. 获取 SiliconFlow API Key

* 注册硅基流动账号。[点击注册](https://cloud.siliconflow.cn/i/TR9Ym0c4)
* 进入控制台，[获取 API key](https://cloud.siliconflow.cn/account/ak)。
* 点击密钥进行复制，用于在 LazyCraft 中使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=2547f102f535780f0417aefb947e4d0d" data-og-width="1920" width="1920" data-og-height="910" height="910" data-path="images/usercases/LazyCraft/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=d832bef231df61716f700182bd33f594 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=63fb97e820ab8155d23646863b598020 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=f347d202d9a53720e9c660c512135a8c 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=d1138ddefe1559ff88e5c9110ebac3d2 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=f0208a29ce75c4946db8c2fcf84d0c90 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/1.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=764a1071aba0aa7994db6fda298de5f6 2500w" />
</Frame>

> 💡 **提示**：API Key 是访问 SiliconFlow 服务的凭证，请妥善保管，不要泄露给他人。

## 2. 在 LazyCraft 中配置 SiliconFlow

### 2.1 配置 API Key

**通过模型管理页面配置**

1. **进入云服务页面**
   * 登录 LazyCraft 平台后，点击顶部导航栏的 **"推理服务"** 菜单
   * 进入左侧 **"云服务"** 页面

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=cd90d89570f372a90cb873307d0a88c9" data-og-width="1920" width="1920" data-og-height="852" height="852" data-path="images/usercases/LazyCraft/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=7f7403b39238a112b2d05787bbccee2c 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=a5f8da788622c70cb2d9a5864d171a9e 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=9d25ab80c03c249afc9848ee4a81a571 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=c3b43194b84859916f5adae4a35f8d1a 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=686adbf405028a720b3416d2a353d57d 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/2.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=599eeaeff8ac52d5299c15038f588077 2500w" />
</Frame>

2. **配置 API Key**
   * 从厂家名字中选择 **"SiliconFlow"** 云模型
   * 在页面SiliconFlow模型列表行最右侧找到 **"key"** 按钮
   * 点击进入配置页面
   * 将之前复制的 API Key 粘贴到输入框中
   * 点击 **"保存"** 按钮

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=df712a49a546fa1f03effbec94fa1277" data-og-width="1920" width="1920" data-og-height="903" height="903" data-path="images/usercases/LazyCraft/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=2a9015ae0de78b2192c41d1450070b3c 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=8d2aa85f8a74496564da6ba7f11cf04f 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=45bded21aebd7a96339ff5278f67b870 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=ceed50870778f054c31e90249e024c0a 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=a3ee86212b78fbf0be826181b35070db 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/3.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=dafe27fe91b521d3e9e486a9446a3e6c 2500w" />
</Frame>

3. **验证配置**

* 配置成功后，系统会自动验证 API Key 的有效性
* 验证通过后，即可在应用中使用 SiliconFlow 的模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=c3b638ae19477c6f7a44acf06b130f24" data-og-width="1920" width="1920" data-og-height="831" height="831" data-path="images/usercases/LazyCraft/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=00ff2e55b9d02ff2a405ca0c29400364 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=aea5a5a56abdae9586300c4e768467ef 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=21fce350f2b1688a0de778bb8f4bba52 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=2b219dd83b6dc2320e4c5c343b9cb948 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=3e8906a487b1723806795da825e3276e 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/4.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=741b9c77c7883443c6d543782e5639e6 2500w" />
</Frame>

### 2.2 管理模型清单

LazyCraft 内置了 SiliconFlow 的模型清单，支持以下模型类型：

#### 支持的模型类型

| 模型类型          | 说明    | 代表模型                                                   |
| ------------- | ----- | ------------------------------------------------------ |
| **LLM**       | 大语言模型 | Qwen/Qwen3-32B, DeepSeek-V3, GLM-4.6 等                 |
| **Embedding** | 向量模型  | BAAI/bge-m3, Qwen/Qwen3-Embedding-8B 等                 |
| **Reranker**  | 重排序模型 | BAAI/bge-reranker-v2-m3, Qwen/Qwen3-Reranker-8B 等      |
| **VQA**       | 视觉问答  | Qwen/Qwen3-VL-32B-Instruct, deepseek-ai/deepseek-vl2 等 |
| **SD**        | 文生图   | Qwen/Qwen-Image, Kwai-Kolors/Kolors 等                  |
| **TTS**       | 文字转语音 | fnlp/MOSS-TTSD-v0.5, FunAudioLLM/CosyVoice2-0.5B 等     |
| **STT**       | 语音转文字 | FunAudioLLM/SenseVoiceSmall, TeleAI/TeleSpeechASR 等    |

#### 修改模型清单

**通过云服务页面修改模型清单**

* 进入 **"推理服务"** → **"云模型"**
* 厂商名字选择 **"SiliconFlow"**
* 即可看到所有可用的 SiliconFlow 模型类型及每个模型类型中的模型清单
* 可根据实际需要对模型清单进行新增或者删除
* 填写模型名称（需与 SiliconFlow 平台上的模型名称一致）[SiliconFlow模型列表](https://docs.siliconflow.cn/cn/api-reference/models/get-model-list)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=3ba9288454d89189ae47162aa594083f" data-og-width="1920" width="1920" data-og-height="978" height="978" data-path="images/usercases/LazyCraft/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b002778fcf41a8cd8db94dee6c475c40 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=0e523a5cb92ddebb6559cafafd2c7ad9 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=14d8e1595819c39aca4b8732d298f9a5 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=270f8088d32a925dcf2acdb219edac32 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=284bc884df9f296c0173767940950b07 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/5.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=63b3574b0bfe51a0990e268fb3415b47 2500w" />
</Frame>

## 3. 在画布中创建应用

LazyCraft 提供了强大的可视化画布功能。下面将展示如何使用 SiliconFlow 的不同类型模型创建应用。

### 3.1 大语言模型（LLM）应用示例

#### 场景：智能对话助手

**使用模型**：`Qwen/Qwen3-32B` 或 `deepseek-ai/DeepSeek-V3`

**创建步骤**：

1. **创建新应用**
   * 点击 **"应用商店"** → **"新建应用"**
   * 选择 **"创建空白应用"**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=1c6eef2101bd5469172f92e16de1acd0" data-og-width="1920" width="1920" data-og-height="965" height="965" data-path="images/usercases/LazyCraft/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=8740bd0257aa839c3905e7cdd2a01e7d 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=d08e6c03dafa3cc26e90c3a8f3e0bd2b 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=e04f1d43bdd817fd93c45d5f1a7055eb 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=285d265dbef085aa3c22aee12aae7fb8 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=c3ece78f273787e18e3b89ec92e5aaa9 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/6.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=a7aca72bf2f4823991092dc2cee48069 2500w" />
</Frame>

2. **添加 LLM 节点**
   * 在画布中拖入 **"大模型"** 节点
   * 点击节点进行配置：
     * **模型来源**：选择 `在线模型`
     * **服务提供商**：选择 `SiliconFlow`
     * **模型名**：选择 `Qwen/Qwen3-32B` 或 `DeepSeek-V3`
     * 其它如提示词模板等参数可以根据需要进行选择也可以直接使用默认值

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=272a26e7935742034053452d4d65e5c6" data-og-width="1920" width="1920" data-og-height="1032" height="1032" data-path="images/usercases/LazyCraft/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=edbff08e90dd5ab82895d9dc21583122 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=f36f5ba56ec9680b8d88f9ea74e91150 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=99f5e37651549116590502c113156ab0 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=bc5d4cf192863ccc6888112887a3bca2 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=9634f619cd1a2b03d6615d8b6a1dd747 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/7.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=4fbac0a008e1ff20c331ae7354a00fe3 2500w" />
</Frame>

3. **连接节点**
   * 点击 **"开始"** 节点添加输入参数，并将 **"开始"** 节点连接到 **"大模型-1"** 节点
   * 点击 **"结束"** 节点添加输出参数，并将 **"大模型-1"** 节点连接到 **"结束"** 节点

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b8ef5b2d143e5f9036db4b9f2662e932" data-og-width="1920" width="1920" data-og-height="983" height="983" data-path="images/usercases/LazyCraft/8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=ef0ac05a90827e0bd0a91884b90d3c0a 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=11439be4822fbf81526625ed11950c3a 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=64c4ee359772253ff004e5407f7d9129 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=1154b9be71ece86f70f9a05436d40d73 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=1fb8256a60249c859e604d6d3b73a496 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/8.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=352bce3b4121fa1632d7aae8107aa027 2500w" />
</Frame>

4. **测试运行**
   * 点击右上角 **"启用调试"** 按钮
   * 点击 **"运行"** 按钮，输入测试问题，如："请介绍一下人工智能的发展历史"
   * 查看模型返回的结果

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=75a284364a20807ba8ce9835cf16d18d" data-og-width="1920" width="1920" data-og-height="988" height="988" data-path="images/usercases/LazyCraft/9.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=e2b622e3411ef5c6175509a812981cb7 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=2c1c02e71db3219c39fb2c3146477d17 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=30a50ca387fd7d0245a9915c20103697 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=c88090806827517ec45cc558ca1280f1 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=5de363757adf6c196b923e802c040784 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/9.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=cae98f04558c81120328c11482090cbe 2500w" />
</Frame>

*启用调试应用*

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=1a9b0147243252910f3750f052673138" data-og-width="1920" width="1920" data-og-height="619" height="619" data-path="images/usercases/LazyCraft/10.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=f3eedef5f8e4c8ab2857c3d63fc0364a 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=bcc8bfb2364a369ec16eb4d1c1c1c634 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=701169c397dabbde638def66b1fddf01 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=018daea5f7e21d529779e9074e22d399 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=76293f24580484148b06e5e263610ef3 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/10.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b4b8e211f936a94d9f666a5d10a39ea3 2500w" />
</Frame>

*查看模型返回结果*

5. **应用发布**
   * 点击右上角 **"发布"** 按钮
   * 在弹出框内确认发布版本号后，点击 **"确认"** 按钮，即发布成功
   * 可在 **"应用商店"** 查看已发布应用
   * 可随时启动/关闭服务，对外提供服务能力（服务页面、API发布）

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=0f079383cdfe411c85f71137708a4919" data-og-width="1920" width="1920" data-og-height="647" height="647" data-path="images/usercases/LazyCraft/11.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=dc001b7b2059856738faf1d3bf48b310 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b426691ff1cde5a9bbdfaeaaa300b51d 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=6f7e63c206b0b5760a1af40614412dc5 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=8983af3ecce95ed5745a4d024dfce0c3 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=30b135ad21289f531265ce6e5f843c4c 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/11.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=bffa1620473b50f07556ff48dfda0c72 2500w" />
</Frame>

*应用发布*

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b384ce6882cad86a8dbc0bf999ae0d56" data-og-width="1920" width="1920" data-og-height="742" height="742" data-path="images/usercases/LazyCraft/12.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=691ebd1c55d897b051b1c0ab0112dd66 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=901dd6e5893880a5e0c53040447029be 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=7e8a209de4dbdda6391d5aff3d7c9486 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=43e4be69099790c0326038481b6b34aa 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=dd1b355ac8f111b568dae6f24c7322e4 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/12.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=beed066e22d0e5240b6aa99f4a823b0a 2500w" />
</Frame>

*应用发布查看*

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b438351036c8954af7ee78fc87408ff6" data-og-width="1920" width="1920" data-og-height="697" height="697" data-path="images/usercases/LazyCraft/13.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=6df8b070f408557c52361670083602b7 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=04dd6cbf907c4961b2441718897ab010 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=4e39685af934271c9608d653c8c75be7 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=9c6feaf343e093b69fef3da66c5d02d6 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=0d36075169ceb99f8a8916aca910c5f9 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/13.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=c0ed84b59d9fec8c29444f5a313fc0e1 2500w" />
</Frame>

*应用服务能力提供*

### 3.2 其它模型应用示例

#### 场景：其它类型的模型可参考大模型节点配置方法进行自行配置体验

比如文生图使用效果如下：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=039f66abbb5be0208756b2cb18018d78" data-og-width="1920" width="1920" data-og-height="993" height="993" data-path="images/usercases/LazyCraft/14.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?w=280&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=103e24567113dc696ff10bbd956412bd 280w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?w=560&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=45afded068b9979258f5c73b20206675 560w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?w=840&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=ed09aa27a4f44d03a47c056022008b05 840w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?w=1100&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=248bc79844957c863afa1f593a353606 1100w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?w=1650&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=b61df8df2e92183a1997dfed34fbd4e2 1650w, https://mintcdn.com/siliconflow-37161621/e9qpGD61Z-vpw2P6/images/usercases/LazyCraft/14.png?w=2500&fit=max&auto=format&n=e9qpGD61Z-vpw2P6&q=85&s=fe5c8060a418c1ca140942a56156ecef 2500w" />
</Frame>

**相关链接**：

* [SiliconFlow 官网](https://cloud.siliconflow.cn/)
* [LazyCraft GitHub](https://github.com/LazyAGI/LazyCraft)
* [LazyLLM GitHub](https://github.com/LazyAGI/LazyLLM)


# LazyLLM
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-lazyllm



LazyLLM 是由商汤 LazyAGI 团队开发的一款开源低代码大模型应用开发工具，提供从应用搭建、数据准备、模型部署、微调到评测的一站式工具支持，以极低的成本快速构建 AI 应用，持续迭代优化效果。

## API 申请和环境配置

### 1. 账号注册

* 注册硅基流动账号。[点击注册](https://cloud.siliconflow.cn/i/TR9Ym0c4)
* 进入控制台，[获取 API key](https://cloud.siliconflow.cn/account/ak)。

### 2. 环境配置

参考网页：[快速开始 - LazyLLM](https://docs.lazyllm.ai/zh-cn/stable/)

## API 使用测试

### 0. 设置环境变量

可以使用以下命令设置对应的环境变量。或从代码中显示给入:

```
  export LAZYLLM_SILICONFLOW_API_KEY=<申请到的api key>
```

### 1. 实现对话和图片识别

#### 文本问答演示

填好 api\_key 后，运行下面代码可以迅速调用模型并生成一个问答形式的前端界面:

```
    import lazyllm
    from lazyllm import OnlineChatModule,WebModule
    api_key = 'sk-' #替换成申请的api
    # # 测试chat模块
    llm = OnlineChatModule(source='siliconflow', api_key=api_key, stream=False)
    w = WebModule(llm, port=8846, title="siliconflow")
    w.start().wait()
```

我们询问“什么是 LazyLLM ”，运行结果如下:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=5c524605d1d5f9f768e1a08a872043b5" data-og-width="1910" width="1910" data-og-height="923" height="923" data-path="images/usercases/LazyLLM/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=baac190a4f940a18846c4c3c3d1f831e 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=40c0863b8a37b3628142f3ca3b7c3aeb 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=9d203d2b1284af2fe1ca4799f833efce 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c28a38044c1f9b31f9aa19bc4f5f4951 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c237e0ed8b9f9b8f22e67b82f3e06c1c 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/1.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=00424887097696c93d8ff7178d1b599b 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=aab59e6fe140f254606a024eb2674281" data-og-width="1910" width="1910" data-og-height="923" height="923" data-path="images/usercases/LazyLLM/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=e340db97d1a08fdf32d4a398852ea79e 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=65779b6681b79958d805214e40db0364 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=fb6f63397dfb45439ff999ead9ddbd19 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=b5dad1165ff859fbf3f71f380239a594 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a15ec1e5f4a9e2497b28c3f3610b9d12 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/2.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=3305ffbc877876f4e49eec8f5935307f 2500w" />
</Frame>

#### 多模态问答演示

在输入中通过 lazyllm\_files 参数传入一张图片，并询问图片的内容，就可以实现多模态的问答。

```
    import lazyllm
    from lazyllm import OnlineChatModule
    api_key = 'sk-' #替换成申请的api
    llm = OnlineChatModule(source='siliconflow', api_key=api_key,
    model='Qwen/Qwen2.5-VL-72B-Instruct')
    print(llm('你好，这是什么？', lazyllm_files=['your_picture.png']))
```

这里我们使用这个图片测试多模态问答

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=2bebba994217eacd7be23e9efe4ff3b2" data-og-width="554" width="554" data-og-height="555" height="555" data-path="images/usercases/LazyLLM/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=b7ec9f8719c89240cbf140a2d654ca65 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=9e81e4fc99be3b4519411a0ce51c6f3d 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=dd05c0cf69f6d68848b5295c8892e1d6 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=606eede14ca92d842d3a4122bf63ef1e 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=40596bc9093ddf63eea3d50c39d17a60 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/3.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a7fd0b4b3a11fae0ff1c3681cff337ba 2500w" />
</Frame>

命令行中输出结果：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=777dbe36a162128ea8be071d7bb02463" data-og-width="1488" width="1488" data-og-height="49" height="49" data-path="images/usercases/LazyLLM/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0d6e84f803fec26ede87dcb381047e53 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=e93797f405d0ceab995b6f67b961f4b7 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=eb08fc308c526a7f124b95e609c576f7 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=5ef455f541455fb600ab1d6d33b3f482 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=558eb7f75886332535e8df1332bd46a5 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/4.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=520e07c8b7a307a135e24ef3217af7de 2500w" />
</Frame>

### 2. 实现文生图和文生语音

使用`OnlineMultiModalModule`进行文生图和文生语音，运行后会输出生成的文件路径

```
    import lazyllm
    from lazyllm import OnlineMultiModalModule
    api_key = 'sk-xxx'
    # 测试文生图 fuction=text2image
    llm =OnlineMultiModalModule(source='siliconflow',api_key=api_key,function='text2image')
    print(llm("生成一个可爱的小狗"))
    #测试文生语音 function=tts
    llm = OnlineMultiModalModule(source='siliconflow',api_key=api_key,function='tts')
    print(llm("你好，你叫什么名字",voice='fnlp/MOSS-TTSD-v0.5:anna'))
```

运行结果：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=55af397cf01449ddc96d596d195c2201" data-og-width="564" width="564" data-og-height="566" height="566" data-path="images/usercases/LazyLLM/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a1d9981d9116ebfc7bfd947b8b642dc6 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=3b17ee7154d328107681b6bc7e10713c 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f466a04acba012732896ccdb4274c59b 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7a389e9034990fc8b990b974eb2776b6 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a10bade263735181d3062b35188b2f59 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/5.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=ca275773b01b196a986249f7d4d9b505 2500w" />
</Frame>

生成的语音如下：

| [tmpck44zfds.mp3](https://ones.ainewera.com/wiki/?/team/JNwe8qUX/share/7fy5a6mk/page/FUcz8wKs/) | 55.13 KB | 2025-10-27 23:13 |
| ----------------------------------------------------------------------------------------------- | -------- | ---------------- |

### 3. 10+行代码实现知识库问答

#### 实现 Eembed 和 Rerank 功能

运行下面代码，使用`OnlineEmbeddingModule`进行向量化嵌入；设置`type='rerank'`调用重排序模型。

```
    import lazyllm
    from lazyllm import OnlineEmbeddingModule
    api_key = 'sk-'
    
    #测试embed模块
    llm = OnlineEmbeddingModule(source='siliconflow', api_key=api_key)
    print(llm("苹果"))
    
    #测试rerank模块
    llm = OnlineEmbeddingModule(source='siliconflow', api_key=api_key, type='rerank')
    print(llm(["苹果", ['苹果','香蕉','橘子']]))
```

向量化的结果如下：

```
    [-0.0024823144, -0.0075530247, -0.013154144, -0.031351723, -0.024489744, 0.009692847, 0.008086464, -0.037946977, 0.013251133, -0.046675995, -0.011390155, -0.011111312, 0.016779112, 0.054168403, 0.04849454, 0.014742341, 0.02341074, -0.015542501, 0.059939254, -0.024223024, 0.0065467632, -0.041244607, -0.022925794, -0.024804957, 0.006752865, -0.047548898, -0.03685585, 0.0513557....，-0.070656545, -0.01997975, 0.023398615, 0.008735079]
```

词相似性分数如下：

```
    [{'index': 0, 'relevance_score': 0.9946065545082092}, {'index': 2, 'relevance_score': 0.014802767895162106}, {'index': 1, 'relevance_score': 0.0004139931406825781}]
```

#### 知识库导入

我们使用中国古典文籍作为示例知识库，下载后放在 database 文件夹。示例数据集下载链接：[示例数据集下载](https://huggingface.co/datasets/LazyAGI/Chinese_Classics_Articles/tree/main)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0f75b8b4bb6c42971a19b137fc14d174" data-og-width="1640" width="1640" data-og-height="797" height="797" data-path="images/usercases/LazyLLM/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d31dcea11682f4628203dd49545482a5 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d1b0742fea021c73b3c0cf52f3d97a82 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a1d731daa7c8c18d900b7ca3a86466a9 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=74d1635cfd7b08a812aea09aa1ad63e2 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=3069f26527bc4f8e7f4e2b8527bdd647 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=af8b441621548aef505feb661e3f148e 2500w" />
</Frame>

首先定义 embed 模型，然后使用 LazyLLM 的 Document 组件创建文档管理模块，以实现知识库的导入。

```
    import lazyllm
    api_key='sk-'
    embed_model = lazyllm.OnlineEmbeddingModule(source="siliconflow", api_key=api_key)
    documents = lazyllm.Document(
    dataset_path = "database",
    embed = embed_model
    )
```

#### 知识库检索

现在有了外部知识库，LazyLLM 中使用 Retriever 组件可以实现检索知识库并召回相关内容。
使用示例：

```
    import lazyllm
    from lazyllm.tools import Retriever, Document, SentenceSplitter
    api_key='sk-'
    embed_model = lazyllm.OnlineEmbeddingModule(source="siliconflow", api_key=api_key)

    documents = Document(dataset_path='database', embed=embed_model, manager=False)
    rm = Retriever(documents, group_name='CoarseChunk', similarity='bm25', similarity_cut_off=0.01, topk=6)
    rm.start()
    print(rm("user query"))
```

#### 知识库问答

结合上述模型、文档管理和检索模块，搭配 LazyLLM 内置的 Flow 组件进行完整的数据流搭建，完整代码如下：

```
    import lazyllm

    from lazyllm import (
    OnlineEmbeddingModule, OnlineChatModule, Document, SentenceSplitter,
    Retriever, Reranker, ChatPrompter, pipeline
    )
    # 初始化api key和提示词
    api_key = 'sk-'
    prompt = """
    You will play the role of an AI Q&A assistant and complete a dialogue task.
    In this task, you need to provide your answer based on the given context and question.
    """
    # 初始化模型
    embed_model = OnlineEmbeddingModule(source="siliconflow", api_key=api_key)
    rerank_model = OnlineEmbeddingModule(source="siliconflow", api_key=api_key, type="rerank")
    llm = OnlineChatModule(source="siliconflow", api_key=api_key)
    # 定义文档管理模块，并创建节点组
    doc = Document(dataset_path="/home/xxx/database", manager=False, embed=embed_model)
    doc.create_node_group(name="block", transform=SentenceSplitter, chunk_size=1024, chunk_overlap=100)
    doc.create_node_group(name="line", transform=SentenceSplitter, chunk_size=128, chunk_overlap=20, parent="block")
    # 构建RAG pipeline（多路召回--重排--提示词拼接--大模型回答）
    with pipeline() as ppl:
    with lazyllm.parallel().sum as ppl.prl:
        prl.r1 = Retriever(doc, group_name='line', similarity="cosine", topk=6, target='block')
        prl.r2 = Retriever(doc, group_name='block', similarity="cosine", topk=6)
    ppl.reranker = Reranker('ModuleReranker', model=rerank_model, output_format='content',
                            join=True) | bind(query=ppl.input)
    ppl.formatter = (lambda context, query: dict(context_str=str(context), query=query)) | bind(query=ppl.input)
    ppl.llm = llm.prompt(lazyllm.ChatPrompter(prompt, extra_keys=["context_str"]))
    ppl.start()
    query = "何为天道"
    
    print(ppl(query))
```

可以看到 RAG 很好地从《道德经》等中取回了有关天道的内容，并传给大模型进行回答。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0f75b8b4bb6c42971a19b137fc14d174" data-og-width="1640" width="1640" data-og-height="797" height="797" data-path="images/usercases/LazyLLM/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d31dcea11682f4628203dd49545482a5 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d1b0742fea021c73b3c0cf52f3d97a82 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a1d731daa7c8c18d900b7ca3a86466a9 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=74d1635cfd7b08a812aea09aa1ad63e2 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=3069f26527bc4f8e7f4e2b8527bdd647 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/LazyLLM/6.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=af8b441621548aef505feb661e3f148e 2500w" />
</Frame>


# MarketAssistant
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-marketassistant



## 关于 MarketAssistant

MarketAssistant 是一款基于 .NET MAUI 开发，结合 AI 大模型构建的股票分析工具。本文将介绍如何在 MarketAssistant 中配置和使用 SiliconFlow 的 AI 模型服务。

SiliconFlow 为 MarketAssistant 提供了强大的大语言模型支持，本指南将帮助您：

* 快速配置 SiliconFlow API
* 选择合适的 AI 模型
* 优化使用成本和性能
* 解决常见的集成问题

### 软件下载

在开始配置之前，请确保您已经安装了 MarketAssistant：

**下载地址**: [MarketAssistant Releases](https://github.com/X2Agent/MarketAssistant/releases)

请选择适合您操作系统的版本进行下载和安装。

> 更多 MarketAssistant 的完整功能介绍，可参考项目 [官方文档](https://github.com/X2Agent/MarketAssistant)

## 快速配置

### 步骤 1：获取 SiliconFlow API 密钥

1. 访问 [硅基流动官网](https://cloud.siliconflow.cn/)
2. 完成注册后，进入 [API 密钥管理页面](https://cloud.siliconflow.cn/account/ak)
3. 点击“创建新密钥”
4. 复制生成的 API Key（请妥善保存）

### 步骤 2：在 MarketAssistant 中配置

1. 打开 MarketAssistant 应用
2. 导航到“设置”页面
3. 在“AI 模型配置”部分填入：
   * **API密钥**：粘贴您的SiliconFlow API Key
   * **模型选择**: 通过下拉菜单选择合适的模型（见下方推荐）
   * **嵌入模型**: 保持默认`BAAI/bge-m3`
4. 若需获取股票数据，可在智兔官网获取令牌；
5. 点击“保存”按钮

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f563a66263f454761b791044b7bc5a2f" data-og-width="1904" width="1904" data-og-height="992" height="992" data-path="images/usercases/MarketAssistant/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f4dcfb63dea684df4f80ba77d450f905 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=859d5c8f88a5da75d9bc4e0570cdff6b 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2e041ae1700cd2ec383a20bd68cecb9c 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e1073279181e323663ca6c560a331c3c 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=41521ff1378ecf217c0021ad35a33a92 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/MarketAssistant/3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=96162f898ff452e9fb85b4f33ef43c0d 2500w" />
</Frame>

### 步骤 3：验证配置

1. 保存配置后，尝试进行一次股票分析
2. 如果分析成功，说明配置正确
3. 如有问题，请查看应用日志

## 模型选择指南

### 推荐配置组合

| 使用场景      | 推荐模型                            | 特点          | 适用对象  |
| --------- | ------------------------------- | ----------- | ----- |
| **日常使用**  | `Qwen/Qwen3-32B`                | 快速响应，成本较低   | 个人投资者 |
| **专业分析**  | `deepseek-ai/DeepSeek-R1`       | 推理能力强，分析深度高 | 专业投资者 |
| **长文档处理** | `Tongyi-Zhiwen/QwenLong-L1-32B` | 支持长上下文      | 研报分析  |
| **复杂策略**  | `Qwen/Qwen3-235B-A22B`          | 超强理解能力      | 量化策略  |

### 完整支持列表

* `Qwen/Qwen3-32B` - 通义千问 32B 版本
* `deepseek-ai/DeepSeek-R1` - DeepSeek 推理模型
* `deepseek-ai/DeepSeek-V3` - DeepSeek V3 版本
* `Qwen/Qwen3-235B-A22B` - 超大规模模型
* `Tongyi-Zhiwen/QwenLong-L1-32B` - 长文本模型
* `THUDM/GLM-4-32B-0414` - 智谱 GLM-4 模型
* `THUDM/GLM-Z1-Rumination-32B-0414` - 深度思考模型
* `tencent/Hunyuan-A13B-Instruct` - 腾讯混元模型
* `moonshotai/Kimi-K2-Instruct-0905` - Kimi K2 模型

## 安全最佳实践

### API 密钥安全

**安全做法**:

* API 密钥仅存储在本地
* 定期更换 API 密钥

### 数据隐私

* 股票分析数据仅在本地处理
* 仅向 SiliconFlow 发送分析请求
* 向量化文档存储在本地 SQLite 数据库

## 优化建议

1. **模型调优**: 根据实际使用效果调整模型选择
2. **批量处理**: 充分利用 AI 选股等批量功能
3. **配置调整**: 根据使用模式调整分析师角色

## 技术支持

### 获取帮助

* **MarketAssistant 问题**: 查看项目 GitHub 页面的 Issues 部分
* **社区讨论**: 参与相关技术社区讨论

### 故障报告

如遇到技术问题，请提供以下信息：

1. MarketAssistant版本号
2. 使用的 SiliconFlow 模型
3. 具体错误信息和日志
4. 复现步骤


# minbricks 智能小说编辑器
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-minbricks



## 1. 关于 mindbricks

mindbricks 是一款 macOS 平台与 Windows 平台皆可使用的智能小说编辑器，您可以将它下载到您的电脑上进行使用，感受 mindbrikcs 带来的写作新体验！

本文将介绍如何借助 SiliconFlow 提供的 API 服务在 mindbricks 中进行小说创作。

## 2. 安装 mindbricks

前往 [mindbricks 官网](https://mindbricks.cn) 安装, 选择合适的系统版本下载.

## 3. 在 mindbricks 中使用 SiliconFlow

### 3.1 默认配置

安装完 mindbricks 之后，鼠标左键点击右下角的 \[齿轮] 图标，选择 \[模型设置] 。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=70b3dbc1d7c6039cb4878cf802545de8" data-og-width="830" width="830" data-og-height="474" height="474" data-path="images/usercases/mindbricks/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c633a21a517fe866b28bdd90584ce996 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2572c3425c273f91ca828f5206fc5ba0 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3a0fd23ddd4c285c30fb4a33fe61f3de 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=40d1405be675f0f69724bd542392080e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=fe3baa31d41358f9e99a309f3c630048 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4fbe7690e10bf3afa27b454908b4cb0b 2500w" />
</Frame>

在 \[模型] 中选择 「硅基流动（免费）」，鼠标左键点击保存。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=62ba60b3279092ed2a0420335f6ea331" data-og-width="830" width="830" data-og-height="878" height="878" data-path="images/usercases/mindbricks/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a9134baedfc14c317e2df952cc0ed2ef 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=493c13e8f128d0eeb3e9818cae9cefcb 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c268fe53de07a05fa8709c21d00ce166 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=96b0854743575771f27b5bf9c165d93b 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=978de3ddb09ee9695dbbb9143d284b70 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=311f2bff3ad2d77ab32aab347692add8 2500w" />
</Frame>

在主界面左键点击\[开始创作]，输入作品名称及作品位置即可创建新作品。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=166aff1534fa59f2df35a16134908b04" data-og-width="830" width="830" data-og-height="448" height="448" data-path="images/usercases/mindbricks/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f090f1fbc68fae116001e46026fa0aba 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=85515603098069176bec3ba4681806da 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=37fcd340bfdc346f0b6b1ee78e622b26 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=567927cdcaa994107754a068100da079 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=39c0e7fbf2834605e87d4cbba7970c88 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ace82e6017b6d894fefc8c7b4d7dd562 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=05428a369587db21459b753641a72756" data-og-width="830" width="830" data-og-height="320" height="320" data-path="images/usercases/mindbricks/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=569c1d1e8520e779d54458ad7f28fa2e 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e301f1fd4ee8e73936b67293a6933759 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=931ad0bf5a52d7d508a07d046c3aa85a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8a2e7762ee0221e0c59672dcefd6c9c1 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b056eed93e51fdda4e766795b3dc4f04 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8d22d434a230a195b1a8a4307c5706da 2500w" />
</Frame>

**注: 免费模型使用的模型是 Qwen3-8B，如需使用 SiliconFlow 的其他模型，需要自行获取 SiliconFlow API Key**

## 3.2 使用 SiliconFlow 的其他文本生成模型

打开 [SiliconFlow 官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。

完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

进入之前提到的 mindbricks \[模型设置] 页面，点击 \[模型]，选择 \[硅基流动] 将API Key 填入硅基流动服务的 API Key 设置项中，点击保存即可使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1b1e242c35054d0159183730079e4d84" data-og-width="830" width="830" data-og-height="474" height="474" data-path="images/usercases/mindbricks/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=673f14eac96fac93678475344796d03d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3b72459f6fef8c3dfd45320fdb7f56ae 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6d2f97fd162a765be194ad34c406d849 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3cddab1cdf499b6c05882c88eba8c64a 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eecae03f4ec4c1fe45bd8959aec3eb1d 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=fe14cc2125825ab6ea927c39754a779f 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e31ef8f7c1866fb5cd45cb9c4a1eb8da" data-og-width="830" width="830" data-og-height="456" height="456" data-path="images/usercases/mindbricks/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7254a7e3f2c6a27878dfb3faac967fb6 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1d7932b3222e1ccea5b89b85104bbdc8 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=5830c33166f2590d1bbce001581d2caf 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a9f99e0e1aaf347e5c6eae7c418f62d4 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3d49486f1ba4d01a19acfb7f41997297 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d46fca00857e8404d2265a098fada835 2500w" />
</Frame>

**注：MindBricks 已针对不同应用场景内置了不同模型，主要分为以下几类:**

* 对话模型: 在硅基流动服务商下默认为 Qwen/Qwen3-235B-A22B

* 角色模型: 在硅基流动服务商下默认为 Qwen/Qwen3-235B-A22B

* 推理模型: 在硅基流动服务商下默认为 deepseek-ai/DeepSeek-R1

若需要自定义完全自定义模型, 可使用自定义配置。


# MindSearch
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-mindsearch



## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 部署MindSearch

1. 复制 MindSearch 到本地并安装相关依赖后（参考 [https://github.com/InternLM/MindSearch/blob/main/README.md）](https://github.com/InternLM/MindSearch/blob/main/README.md）) ，

2. 修改：
   `/path/to/MindSearch/mindsearch/models.py`

3. 加上调用硅基流动 API 的相关配置。配置如下：

```
internlm_silicon = dict(type=GPTAPI,
                        model_type='internlm/internlm2_5-7b-chat',
                        key=os.environ.get('SILICON_API_KEY', 'YOUR SILICON API KEY'),
                        openai_api_base='https://api.siliconflow.cn/v1/chat/completions',
                        meta_template=[
                            dict(role='system', api_role='system'),
                            dict(role='user', api_role='user'),
                            dict(role='assistant', api_role='assistant'),
                            dict(role='environment', api_role='system')
                        ],
                        top_p=0.8,
                        top_k=1,
                        temperature=0,
                        max_new_tokens=8192,
                        repetition_penalty=1.02,
                        stop_words=['<|im_end|>'])
```

加入这段配置后，可以执行相关指令来启动 MindSearch。

4. 启动后端：

```
# 指定硅基流动的 API Key
export SILICON_API_KEY=上面流程中复制的密钥
# 启动
python -m mindsearch.app --lang en --model_format internlm_silicon --search_engine DuckDuckGoSearch
```

5. 启动前端。这里以gradio前端为例，其他前端启动可以参考MindSearch的README：
   `python frontend/mindsearch_gradio.py`

## 3. 上传到 HuggingFace Space

我们也可以选择部署到 HuggingFace 的 Space 当中。

1. 在 [https://huggingface.co/new-space](https://huggingface.co/new-space) 创建一个新的Space，
   配置为：
   Gradio
   Template:Blank
   Hardware:CPU basic·2 vCPU·16GB·FREE

2. 创建成功后，进入" Settings "设置 API Key。

3. 把第二步中的 MindSearch 目录、requirements.txt 和一个 app.py 一并上传。

app.py 详细内容请参考：[https://huggingface.co/spaces/SmartFlowAI/MindSearch\_X\_SiliconFlow/blob/main/app.py](https://huggingface.co/spaces/SmartFlowAI/MindSearch_X_SiliconFlow/blob/main/app.py)


# NextChat
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-nextchat



## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 部署 NextChat

访问[ NextChat ](https://app.nextchat.dev/)官网，或者本地安装[ ChatGPT-Next-Web ](https://github.com/ChatGPTNextWeb/ChatGPT-Next-Web)之后：

1. 点击页面左下角的“设置”按钮
2. 找到其中的“自定义接口”选项并选中
3. 填入参数：

* **接口地址：** [https://api.siliconflow.cn](https://api.siliconflow.cn)
* **API Key：** 输入“ API 密钥页签 ”生成的 API Key 并填入“自定义模型名”和“模型（ model ）”

其它自定义模型名可以在 [https://docs.siliconflow.cn/api-reference/chat-completions/chat-completions](https://docs.siliconflow.cn/api-reference/chat-completions/chat-completions) 中查找


# NoBase
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-nobase



NoBase 是寻安科技推出的一站式后端 API 集成平台，旨在给用户提供无需编写后端代码，一键复制接口地址即可获取数据，通过后台管理系统实时查看运营数据的高效体验。[官网直达](https://nobase.cn/)

NoBase 集成了多个功能系统的 API 接口：

* 应用系统、用户（登陆、注册等）系统
* 卡密（兑换码）、邮箱、论坛系统
* AI 大模型对话接口，角色扮演（提示词智能体）系统
* 云文档（文本、JSON、网页）系统
* 更多系统接口解锁中···

## 硅基流动 AI 模型配置教程

* 打开主页找到 AI系统 -> 系统配置。

* 接口提供商选择硅基流动,点击下方提示进入硅基流动。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=88af1361a4807c3f9e21d26bded49e7a" data-og-width="1914" width="1914" data-og-height="958" height="958" data-path="images/usercases/nobase/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=9a9a72e6e663bc71c3d97531f75d550a 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=5255d99e1af196c8be18192ee7ba6511 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=c1d59e0f1ede1456d8ddeeb64f8be19f 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=65e65e365c676a409db239609246624f 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=6e6c9cc880cb6149fe2f9a5bf8876e96 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=4216c1446f69333af086c7f1a3f63912 2500w" />
</Frame>

* 打开硅基流动后，如果你还未登陆请先登录，进入硅基流动平台的 API 密钥管理页面。
* 如果下方没有 API 密钥请先点击上方蓝色按钮“新建 API 密钥”，完成之后点击密钥进行复制。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=ca37e43fbece1cb61c7ee895ae090a79" data-og-width="1914" width="1914" data-og-height="971" height="971" data-path="images/usercases/nobase/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=812913ff94125527f0e55c6f0c158af7 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=a17969c82493d6a30b09a12b589c37f2 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=7c367c95be8e2cbb5f59eb997650e7f2 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=c54c2951859a15b17bf3e8bc6435a0f4 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=11b4841995853017442ed1f60743cfba 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=da75118d4a582f2981143ad5ef7f4579 2500w" />
</Frame>

* 回到 NoBase 粘贴 APIKEY（API密钥）,然后点击右边的验证并加载模型按钮即可展示模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=3f8d0652d1a6482562d41b67644f12fc" data-og-width="1280" width="1280" data-og-height="646" height="646" data-path="images/usercases/nobase/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=e586c0dfb4a79874c2c442b698f50e06 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=48a5e90b0ede259cd94ae0ac4cfde7be 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=2c7c3f2c257b29dcb4040ee683326a21 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=1f5e53dd950ee3f63c1182dc5f33fe96 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=04feded542b4b26b81a7ddc36f23b84d 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=bdbb342c6a0137cd4c227f02f80a7240 2500w" />
</Frame>

* 验证完成后可以看到可以选择硅基流动的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=0a154c421021364a8e5dab8f036d46f6" data-og-width="1918" width="1918" data-og-height="959" height="959" data-path="images/usercases/nobase/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=716c5b4e96adecb2d7a5dfbcc1a1f0f6 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=24404859a0bb5e186eada34dfb82f3db 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=50a97a9b26dbd9a4a81dbd40abb91955 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=34eaae308dfb74932b5269c59251a9c5 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=c88e0a18c14f4ff3fe109fff98212171 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=89064ade756dcf81dab9c0d82800c4ed 2500w" />
</Frame>

* 点击保存完成 AI 接口配置后根据文档请求接口，可以看到成功请求硅基流动的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=b3e6cfe9ae35667d348327c87f635eb4" data-og-width="1919" width="1919" data-og-height="965" height="965" data-path="images/usercases/nobase/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=539e01aafa9872ac8143922be187901f 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=109153ec2e641221f1a8654ac54c9de0 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=6364f8b5b1902d63f169d81826ebbb24 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=02d4f0bae4637c1a48cb62e6146284c8 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=ff5198ef557d5b3281b6034f6ef403e0 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=9188b13be40b4114dd0314b0f64fd0cc 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=41997a1437bac6ccf1f20e1c1aef7359" data-og-width="1544" width="1544" data-og-height="917" height="917" data-path="images/usercases/nobase/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=3426df6ab6dda81fbc90c08fd9883cae 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=1eede5dedff1dba52ed5de319bee218d 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=b9821cb9aae08030f39426201668b32a 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=d2bc0c0517bc0d944ba97d41aaca0462 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=be8f58b9fd1d561425c84a5d5457d838 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=6756d671fe845206e6a2af150eff6e94 2500w" />
</Frame>

> 如有使用上的疑问，可加入 [天使用户群](https://qm.qq.com/q/TO50m57Nok) 反馈。


# Obsidian Copilot
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-obsidian



Obsidian Copilot 是一款开源的 AI 助手插件，设计简洁，使用方便。用户可通过自带的 API 密钥或本地模型与多种模型交互。支持自定义提示，快速与整个笔记库对话，获取答案和见解。旨在成为注重隐私的终极 AI 助手，深入理解您的个人知识库。
<br />如何在 Obsidian 中使用 SiliconFlow 模型呢？

## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Obsidian Copilot 中使用 SiliconFlow 语言模型系列

### 2.1 安装 Obsidian Copilot

1. 安装 Obsidian 应用，详见[Obsidian 官网](https://obsidian.md/)
2. 在 Obsidian 中安装 Copilot 插件：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0ac70aac25ca77090e0fdfe614f47109" data-og-width="1856" width="1856" data-og-height="1364" height="1364" data-path="images/usercases/obsidian/Obsidian-1-安装.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a472017a32c6f20e254e348aed1c87fd 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=53d0d96ff10dd3aa7944d7b15f6b05c7 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8b36d4e82980df2ce73185ad84d3e73c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d798570da0bd3e216b55d922936309fa 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=573d6d5679e6871cdf5eeea94fa0b761 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6083cba8d1f90806293408e6eef9261b 2500w" />
</Frame>

### 2.2 在 Obsidian Copilot中配置 SiliconFlow 模型

#### 2.2.1 设置 LLM 模型

* 模型: [SiliconFlow 平台 LLM 列表](https://cloud.siliconflow.cn/models?types=chat)
* Provider: 3rd party (openai-format)
* Base URL: [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
* API Key: [获取 API Key](use-siliconcloud-in-obsidian#1-api-key)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b970b1282064c4a612e46052942e083b" data-og-width="1856" width="1856" data-og-height="1362" height="1362" data-path="images/usercases/obsidian/Obsidian-2-1-设置.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c074c2aa72b9ed1333fbafec0016675d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=78c5a92c28f5b8f3f2ae95096107bf5d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=546ba19aa64f4668a57dc5781cf19ffc 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b421ce89dd51ef98211cc9a9e7fbb1eb 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=81ce9fd3671bcc50fb06db679ccd7667 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=11a3ac9d364d8e389d0b319e40128255 2500w" />
</Frame>

#### 2.2.2 设置 Embedding 模型

* 模型: 详见 [SiliconFlow 平台 Embedding 列表](https://cloud.siliconflow.cn/models?types=embedding)
* Provider: 3rd party (openai-format)
* Base URL: [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
* API Key: [获取 API Key](use-siliconcloud-in-obsidian#1-api-key)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8d95ab9e269b7b7b9d73acc07cfb2a77" data-og-width="1836" width="1836" data-og-height="1366" height="1366" data-path="images/usercases/obsidian/Obsidian-2-3-embedding.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ee71e3f115d2b69fc178391704881a9b 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=fe37e38df8344c0752e6b40ffbefde6d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e9551cd9b0fb084436463186db358c41 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3485e08c764faa5a498d48cd547a9bc0 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9c3ab0cf4370f3070b8351d85c850387 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c12cc0fd61aedfec10ecbea4ee255df2 2500w" />
</Frame>

#### 2.2.3 加载配置

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4973e8ecea66fd4969eb4c353f2d7ff0" data-og-width="1392" width="1392" data-og-height="918" height="918" data-path="images/usercases/obsidian/Obsidian-2-2-加载配置.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6b5bb51dd6369a69b85f5a3c55ad8bad 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=69f248e4c784322752596fe143513d9e 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ec44bec1d28c7d0438f07078a705ca66 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eb67429c16bb5c2a64e1a2c71999a00c 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ed193acb316bc045b0e0debf385b838f 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9e2c9f042d0bf3f8bb63ffe8b25a0915 2500w" />
</Frame>

### 2.3 在 Obsidian Copilot中使用 SiliconFlow 模型

接下来就可以基于 SiliconFlow 模型和本地知识库进行检索和问答了。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=897fa6f1f60d3be88024c31c1bd8ba7a" data-og-width="2048" width="2048" data-og-height="1600" height="1600" data-path="images/usercases/obsidian/Obsidian-3-使用.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f309d11873e866e6963f6d729c8880f7 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ea7dc8f25853f7ece4e01dac25a6869a 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=761d022b12d0c9a1ba0fa28dc6b7aacd 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=edf13ab8be6b7ed613ce0879f4a69bbb 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=873bac23a2f70559d8164861960f6d4e 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c1101fd62be7ba9cae6968d829558441 2500w" />
</Frame>

<Frame>
  <img src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/obsidian/Obsidian-3-2-QA-with-embedding.jpeg" />
</Frame>


# OpenManus
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-openmanus



## 1. 安装 OpenManus

参考[安装指南](https://github.com/mannaandpoem/OpenManus?tab=readme-ov-file#installation)完成相关代码下载和依赖安装。

## 2. 配置 OpenManus

在 config 目录设置 config.toml，参考如下配置：

```toml  theme={null}
# Global LLM configuration
[llm]
model = "Qwen/QwQ-32B" # 或者平台中的其他支持 function calling 模型，参见[Function Calling](https://docs.siliconflow.cn/cn/userguide/guides/function-calling)
base_url = "https://api.siliconflow.cn/v1"
api_key = "your_api_key_from_siliconcloud"
max_tokens = 16384
temperature = 0.6

# Optional configuration for specific LLM models
[llm.vision]
model = "Qwen/Qwen2-VL-72B-Instruct" # 或者平台中的其他视觉语言模型，参见[vision](https://docs.siliconflow.cn/cn/userguide/capabilities/vision)
base_url = "https://api.siliconflow.cn/v1"
api_key = "your_api_key_from_siliconcloud"
```

## 3. 使用 OpenManus

通过命令行

```shell  theme={null}
python main.py
```

### 3.1 下面是某次运行的大致流程：

| 步骤 | 工作内容                | 使用工具            | 输入/参数                                              | 输出/结果         |
| -- | ------------------- | --------------- | -------------------------------------------------- | ------------- |
| 1  | 分析用户需求，确定搜索策略       | google\_search  | "global soybean market analysis 2025 report"       | 搜索结果链接列表      |
| 2  | 分析搜索结果，决定使用中文搜索     | google\_search  | "全球大豆市场 2025 年分析报告"                                | 搜索结果链接列表      |
| 3  | 分析中文搜索结果，决定访问USDA网站 | browser\_use    | action: "navigate", url: USDA网站链接                  | 成功导航到USDA网站   |
| 4  | 获取USDA网站HTML内容      | browser\_use    | action: "get\_html"                                | 网页HTML内容      |
| 5  | 分析HTML内容，决定保存数据     | file\_saver     | 保存HTML内容到文件                                        | 成功保存HTML文件    |
| 6  | 分析如何处理HTML数据        | -               | -                                                  | 思考处理HTML的策略   |
| 7  | 编写Python脚本解析HTML数据  | python\_execute | 解析HTML的Python代码                                    | 解析结果（大豆产量数据）  |
| 8  | 分析解析结果，决定获取更多数据     | browser\_use    | action: "navigate", url: FAO网站链接                   | 成功导航到FAO网站    |
| 9  | 获取FAO网站HTML内容       | browser\_use    | action: "get\_html"                                | 网页HTML内容      |
| 10 | 编写Python脚本解析FAO数据   | python\_execute | 解析FAO数据的Python代码                                   | 解析结果（FAO大豆数据） |
| 11 | 编写Python脚本合并数据      | python\_execute | 合并USDA和FAO数据的代码                                    | 合并后的数据集       |
| 12 | 编写Python脚本生成图表      | python\_execute | 生成图表的Python代码                                      | 生成的图表数据       |
| 13 | 保存生成的图表             | file\_saver     | 保存图表数据到文件                                          | 成功保存图表文件      |
| 14 | 搜索气候变化对大豆影响         | google\_search  | "climate change impact on soybean production 2025" | 搜索结果链接列表      |
| 15 | 访问气候变化研究网站          | browser\_use    | action: "navigate", url: 气候研究网站链接                  | 成功导航到气候研究网站   |
| 16 | 获取气候研究网站HTML        | browser\_use    | action: "get\_html"                                | 网页HTML内容      |
| 17 | 编写Python脚本分析气候数据    | python\_execute | 分析气候数据的Python代码                                    | 气候影响分析结果      |
| 18 | 编写Python脚本整合所有数据    | python\_execute | 整合所有数据的Python代码                                    | 整合后的完整数据集     |
| 19 | 编写Python脚本生成报告框架    | python\_execute | 生成报告框架的Python代码                                    | 报告HTML框架      |
| 20 | 编写Python脚本添加数据到报告   | python\_execute | 添加数据到报告的Python代码                                   | 带数据的报告HTML    |
| 21 | 编写Python脚本添加图表到报告   | python\_execute | 添加图表到报告的Python代码                                   | 带图表的报告HTML    |
| 22 | 编写Python脚本添加气候分析到报告 | python\_execute | 添加气候分析的Python代码                                    | 带气候分析的报告HTML  |
| 23 | 编写Python脚本添加结论到报告   | python\_execute | 添加结论的Python代码                                      | 带结论的完整报告HTML  |
| 24 | 保存完整报告HTML          | file\_saver     | 保存报告HTML到文件                                        | 成功保存报告HTML文件  |
| 25 | 编写Python脚本将报告转为PDF  | python\_execute | HTML转PDF的Python代码                                  | 报告PDF数据       |
| 26 | 保存报告PDF             | file\_saver     | 保存PDF数据到文件                                         | 成功保存报告PDF文件   |
| 27 | 编写Python脚本创建报告摘要    | python\_execute | 创建摘要的Python代码                                      | 报告摘要文本        |
| 28 | 保存报告摘要              | file\_saver     | 保存摘要到文件                                            | 成功保存摘要文件      |
| 29 | 编写Python脚本发送报告邮件    | python\_execute | 发送邮件的Python代码                                      | 邮件发送结果        |
| 30 | 总结完成的工作，等待下一步指示     | -               | -                                                  | 最终总结和下一步建议    |

### 3.2 执行日志

<Accordion title="部分执行日志">
  INFO     \[browser\_use] BrowserUse logging setup complete with level info
  INFO     \[root] Anonymized telemetry enabled. See [https://docs.browser-use.com/development/telemetry](https://docs.browser-use.com/development/telemetry) for more information.
  Enter your prompt (or 'exit' to quit): 全球大豆市场 2025 年分析报告
  2025-03-08 18:08:00.304 | WARNING  | **main**:main:15 - Processing your request...
  2025-03-08 18:08:00.305 | INFO     | app.agent.base:run:137 - Executing step 1/30
  2025-03-08 18:08:25.067 | INFO     | app.agent.toolcall:think:53 - ✨ Manus's thoughts: 好的，我现在需要处理用户关于“全球大豆市场2025年分析报告”的请求。首先，用户想要一份分析报告，这可能包括市场趋势、产量、价格、主要生产国、消费国以及未来预测等方面的信息。由于报告涉及未来数据，可能需要最新的行业数据和预测，而这些信息通常来自市场研究公司或权威机构的报告。

  接下来，我需要考虑如何获取这些信息。用户提供的工具包括Google搜索、浏览器使用、Python执行和文件保存。首先，我应该使用Google搜索来查找相关的分析报告或数据来源。可能需要搜索关键词如“global soybean market analysis 2025 report”或者“大豆市场预测2025”，看看是否有权威机构如美国农业部（USDA）、国际粮食政策研究所（IFPRI）或市场研究公司如Frost & Sullivan、Mordor Intelligence等发布的报告。

  使用Google搜索工具时，我需要构造合适的查询词，并可能需要多个关键词组合来确保找到最新的信息。搜索结果返回的链接可能包括PDF报告、行业分析文章或新闻稿。之后，可能需要使用浏览器工具访问这些链接，查看具体内容，提取关键数据。如果某些报告需要付费或注册，可能需要寻找免费摘要或通过其他途径获取。

  另外，用户可能希望报告以结构化的方式呈现，比如图表或数据表格。这时候可能需要使用Python来处理数据，例如从网页中抓取数据，或者生成图表。但首先需要确保有可用的数据源。如果搜索到的数据是文本形式，可能需要手动整理或使用Python的解析库如BeautifulSoup或Pandas来处理。

  保存最终的报告或分析结果可能需要使用文件保存工具，将整理好的数据、图表或总结文本保存为文档或代码文件。例如，将分析结果写入Markdown或PDF文件，或者生成一个HTML页面展示图表。

  现在，第一步应该是执行Google搜索，收集相关链接。然后根据搜索结果决定下一步行动，可能是访问具体网页提取数据，或者发现需要进一步处理的数据。如果搜索结果中有直接可下载的PDF报告，可能需要使用浏览器工具下载文件，但可能需要处理文件内容，比如使用Python读取PDF内容。如果报告需要付费，可能需要寻找替代资源或建议用户购买。

  另外，可能需要考虑时间因素，2025年的预测数据可能在2023或2024年的报告中已经存在，因此搜索时可能需要限定时间范围。不过Google搜索工具的参数中没有时间选项，可能需要在查询词中加入年份，如“2023 global soybean market forecast 2025”。

  总结步骤：

  1. 使用Google搜索查找相关报告链接。
  2. 分析搜索结果，访问相关网页，提取关键数据。
  3. 使用Python处理和整理数据，生成图表或分析结果。
  4. 将最终报告保存为文件。

  现在，首先执行Google搜索，看看能找到哪些资源。可能需要多次调整关键词以确保找到足够的信息。如果搜索结果不够，可能需要进一步细化查询，例如按地区、主要公司或特定方面（如价格趋势、产量预测）来搜索。

  ```
  <tool_call>
    "name": "google_search",
    "arguments": {
      "query": "global soybean market analysis 2025 report",
      "num_results": 10
    }
  </tool_call>
  ```

  如需查看详细结果，请[参见此处链接](https://raw.githubusercontent.com/siliconflow/siliconcloud-cookbook/refs/heads/main/examples/openmanus/30-step-log.txt)
</Accordion>


# Para 翻译
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-para



## 1.关于 Para 翻译

Para 翻译是一款高效的多平台翻译聚合工具，专为追求精准与效率的用户设计，它支持全局任意界面文本翻译，助你快速获取最准确的翻译结果。核心功能：

* **全局划词翻译**：在任意 APP 复制文本，画中画悬浮窗秒显结果；
* **截屏翻译 & 取词**：在任意 APP 截屏即可翻译当前页面 & 快速取词，让阅读无障碍
* **多平台聚合翻译**：集成主流翻译引擎和 AI 大模型，实时比对，确保最佳翻译效果；
* **翻译风格配置**：通过自定义 Prompt，让悬浮窗不止翻译，还可以对选中的文本进行润色、改写、总结等等；
* **设为默认翻译**：修改为 iOS 系统默认翻译，在任意 APP划词即可调用多平台聚合翻译。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6239f55266fc5293011dc4434e9872d2" data-og-width="4096" width="4096" data-og-height="1511" height="1511" data-path="images/usercases/para/01.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f640ad3042a0801883b37f35ea1e6e98 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=241862a92c36a31b151a2ea7bb1488ac 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=99990cd940d2ab5004649a2ab24c2e7a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7c73e23642c31fe0768de72f93498432 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c04521ee117196cb62788fdaa7a86f83 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/01.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=5d310f3fe0474c86a8e7dc7b69983733 2500w" />
</Frame>

## 2.安装 Para 翻译

#### 前往 AppStore 安装 Para翻译。[点击前往下载](https://apps.apple.com/app/apple-store/id6742104594?pt=127627614\&ct=SiliconFlow\&mt=8)

## 3.在 Para 翻译中使用 SiliconFlow

### 3.1 使用 SiliconFlow 服务

安装 Para 翻译后，点击翻译服务，即可切换到硅基流动的服务源，Para 接入了 SiliconFlow 免费模型，可以直接免费使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1c4a3c33eecf95a3f21676281e80ae38" data-og-width="1502" width="1502" data-og-height="1558" height="1558" data-path="images/usercases/para/02.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d3549e085bf54979773ce9615fe61092 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8773d3901395892da82649ce7eb11150 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7c259c04c25203a51e76b2d8a89a4fcd 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eef826ce6ad068870e08c52c11765163 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0f0c55ce6cb641a574bd51e3233b91d9 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/02.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=efceb1ad243f68087aa4157f54fd684b 2500w" />
</Frame>

### 3.2 使用 SiliconFlow 的其他免费模型

如需使用其他模型，可以进入翻译服务页，点击进入配置页面，在模型列表切换其他免费模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0a8a3ba752348e522f8ba3d13a6d761b" data-og-width="2199" width="2199" data-og-height="1558" height="1558" data-path="images/usercases/para/03.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=cd8159818cc2533ff8b9a88daee20310 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e883d5f165849f9b6cb7e5ba707413d8 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=79c0dc8a803c0813ea5c06afdcb5dd22 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f67ab9b74f4dbc5cd485baf637f45414 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9c8e76dd8cfee623de0f03700c148c58 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/03.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d05e1272eab50b995933f65edd6ea499 2500w" />
</Frame>

### 3.3 使用 SiliconFlow 的其他文本生成模型

在翻译服务页点击添加翻译源，选择硅基流动，即可自定义添加其他模型。

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。
3. 将 API Key 填入**硅基流动翻译**服务的 API Key 设置项中，
4. 将你需要使用的模型（模型在 SiliconFlow 中的名称）写入，点击右上角保存即可使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ba66e5f5ba8d037c4bd0bf86f1b0546b" data-og-width="2199" width="2199" data-og-height="1558" height="1558" data-path="images/usercases/para/04.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e19e201687d924db7c9943bda3b527e9 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6839f5d65158f0bbd5f05491677c542a 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=715c1e7e1677e547777f39f8394fa1ec 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6dd3f8b95e0107809f4bce08233cafaf 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=5526c3ce38a1ff46d21f13b006448b5f 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/para/04.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1942d56efdce25c6d0573833136dbdba 2500w" />
</Frame>

前往 AppStore 安装 Para翻译，体验 SiliconFlow 的模型。[点击前往下载](https://apps.apple.com/app/apple-store/id6742104594?pt=127627614\&ct=SiliconFlow\&mt=8)


# PDFMathTranslate Next
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-pdfmathtranslate-next



## 1. 关于 PDFMathTranslate Next

[PDFMathTranslate Next](https://pdf2zh-next.com/zh/index.html) 是一款开源、保留排版的 PDF 翻译器。其翻译功能基于 funstory.ai 开源的 [BabelDOC](https://github.com/funstory-ai/BabelDOC) 项目，并在此基础上封装了易用的 CLI 和 GUI 界面。同时，它也是 BabelDOC 官方推荐的本地自部署方式。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/babeldoc-preview.gif?s=48116dc9d6710722f8bebadd8feaabd6" data-og-width="3840" width="3840" data-og-height="2424" height="2424" data-path="images/usercases/pdf2zh/babeldoc-preview.gif" data-optimize="true" data-opv="3" />
</Frame>

## 2. 安装

1. [**Windows EXE**](https://pdf2zh-next.com/zh/getting-started/INSTALLATION_winexe.html) <small>推荐用于 Windows</small>
2. [**Docker**](https://pdf2zh-next.com/zh/getting-started/INSTALLATION_docker.html) <small>推荐用于 Linux</small>
3. [**uv** (一个 Python 项目管理工具)](https://pdf2zh-next.com/zh/getting-started/INSTALLATION_uv.html) <small>推荐用于 macOS</small>

## 3. 使用

最新使用教程请参考 [PDFMathTranslate Next 硅基流动使用指南](https://pdf2zh-next.com/zh/advanced/TranslationServices/SiliconFlow.html)。

### 免费翻译服务

#### cli

```bash  theme={null}
pdf2zh_next --siliconflowfree example.pdf 
```

#### webui

1. 在 "Translation Options" - "Service" 下拉列表中选择 "SiliconFlowFree"。
2. 点击页面下方的 Translate 按钮开始翻译
3. 翻译完成后，即可在页面下方的 "Translated" 一栏找到翻译后的 PDF 文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1efb52a94225abdc7cf8c0e4b8ad5ddb" data-og-width="3196" width="3196" data-og-height="2562" height="2562" data-path="images/usercases/pdf2zh/webui_free.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c4fee9a503415ea737c6dce4766f70c1 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=385cee7a463652108c9a81356d5922c2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=559266e2b25bbc1732d0247faad10620 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=94d268773da8959da2a2210d13c76ce0 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bd5bbfbda6fb13d46faa01a2e5f718d4 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0d3df98241f0fcbefac2fe003474e2e1 2500w" />
</Frame>

#### Zotero

整体参照 [zotero-pdf2zh](https://github.com/guaguastandup/zotero-pdf2zh/blob/main/README_babeldoc.md) 的说明，将翻译服务配置为 "SiliconFlowFree" 即可。

#### 免费服务隐私说明

文件内容将被发送到 PDFMathTranslate Next 项目维护者 [@awwaawwa](https://github.com/awwaawwa) 的服务器，然后转发给硅基流动进行翻译。

PDFMathTranslate Next 项目维护者仅收集硅基流动返回的错误信息以调试相关服务。您的文件内容不会被收集。

[硅基流动隐私政策](https://docs.siliconflow.cn/cn/legals/privacy-policy)

### 使用硅基流动提供的其他模型

1. 注册一个硅基流动账号：[SiliconFlow](https://siliconflow.cn)
2. 创建一个 API 密钥：[SiliconFlow API Key](https://cloud.siliconflow.cn/me/account/ak)。然后，点击密钥以复制它。

#### cli

```bash  theme={null}
pdf2zh_next --siliconflow --siliconflow-model "Pro/deepseek-ai/DeepSeek-V3" --siliconflow-api-key <your-api-key> example.pdf
```

#### webui

1. "Translation Options" - **"Service"** dropdown list: 选中 "SiliconFlow"
2. "Translation Options" - **"Base URL for SiliconFlow API"**: 保持默认
3. "Translation Options" - **"SiliconFlow model to use"**: 填入 "Pro/deepseek-ai/DeepSeek-V3" 或其他模型
4. "Translation Options" - **"API key for SiliconFlow service"**: 粘贴你的 API 密钥
5. 点击页面下方的 Translate 按钮开始翻译
6. 翻译完成后，即可在页面下方的 "Translated" 一栏找到翻译后的 PDF 文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=21597781fff231729c619caf8c1afc22" data-og-width="4142" width="4142" data-og-height="2562" height="2562" data-path="images/usercases/pdf2zh/webui_set_sf.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=646c71c5e815480bc7479946da560334 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c45d4c9603f71604c57085141f1f0868 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=83925ac9b57c700641ba7e4fcc259c1a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=657a3635ae2fcd55e1f0efcfd044b65b 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b99827214a74f00b9e913b7888da3498 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=87eac020e9df8eb90eee8159e71b4887 2500w" />
</Frame>

#### Zotero

整体参照 [zotero-pdf2zh](https://github.com/guaguastandup/zotero-pdf2zh/blob/main/README_babeldoc.md) 的说明，将翻译服务配置为 "SiliconFlow" 并填写对应参数即可。

## 4. 高级选项

请参考 [PDFMathTranslate Next 高级选项](https://pdf2zh-next.com/zh/advanced/advanced.html)。


# ComfyUI 提示词小助手
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-prompt-assistant



## 1、关于 ComfyUI 提示词小助手

提示词小助手，是一款 ComfyUI 中非常受欢迎的提示词扩展，它可以借助硅基流动等云服务平台提供的大模型 API，无感地在 ComfyUI 中实现提示词翻译、扩写润色、图像反推提示词等功能。是学习和使用 comfyUI 的必备的好帮手。

### 核心功能

**提示词翻译**：无需手动设置源语言和目标语言，一键实现中英互译；

**提示词扩写**：可以根据不同生图模型、视频模型的特点，设置不同的规则，一键实现提示词扩写并润色；

**图像反推提示词**：借助视觉模型 API， 一键实现图像内容转换成提示词；

**标签预设**：可以将常用的提示词标签、触发词标签作为预设，实现快速插入。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=e6ecdaffe66b67c54908f3bea7d19679" data-og-width="1640" width="1640" data-og-height="1017" height="1017" data-path="images/usercases/prompt-assistant/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=280&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=8103d300b1c9b228714bf8a9362938bd 280w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=560&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=3609136847486f8c6c86b281aac371fe 560w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=840&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=dc1e88661596fe6d208ddd4d8af7ae0d 840w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=1100&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=7a329ae000fb9a0351bf6fb1fdca316d 1100w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=1650&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=3261aad5fb3fdf4f826bd04a35f33a55 1650w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=2500&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=d87542340e3ad3955460253825b00e8f 2500w" />
</Frame>

## 2、在 ComfyUI 中安装提示词小助手

**ComfyUI 桌面应用版或便携版**

可以在 Manager 中搜索“提示词小助手”或“Prompt-Assistant”（需要将 manager 中的 DB：local 改成 DB：Channel(remote) 才能搜索到），选择最新的版本号安装。

**秋叶启动器版**

在启动器界面中的“版本管理”→“安装新扩展”中，在“扩展 URL”中输入 [https://github.com/yawiii/comfyui\_prompt\_assistant.git](https://github.com/yawiii/comfyui_prompt_assistant.git) 点击安装。

**手动安装**

来到提示词小助手的 [GitHub 仓库](https://github.com/yawiii/comfyui_prompt_assistant)，下载源代码，放置到 custom\_nodes 目录下。

## 3、在提示词小助手中使用 SiliconFlow

### 3.1 **进入 API 配置界面**

安装完提示词小助手后，在 ComfyUI 设置中，找到“✨提示词小助手”选项。在右侧面板中点击“API 管理器”按钮，进入 API 配置界面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=d62efd2d0b98db5d3b5500b2d7a675ff" data-og-width="1760" width="1760" data-og-height="1286" height="1286" data-path="images/usercases/prompt-assistant/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=280&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=b292c5fb42c51dff771eb034d976a32e 280w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=560&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=6f7d14b2ad2ee626570171070d991b8d 560w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=840&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=f2d165fb3cdbcd362b4ee977b39b7041 840w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=1100&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=20f8674f914c2d570e2f3a86a858f922 1100w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=1650&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=bd708265a62f423ebd0d8fefc4c08ba1 1650w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=2500&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=9889d97a4b54708b7a1ed0dcf1f5df27 2500w" />
</Frame>

### 3.2 **选择硅基流动服务**

将大语言模型配置和视觉模型配置中的模型提供商下拉选项，修改为“硅基流动”。

### 3.3 **填写模型**

模型输入框中默认填写的是免费的“Qwen/Qwen2.5-7B-Instruct”模型，如果想要效果更好、响应更快，可以点击界面中的“硅基流动 API 申请”链接，快速进入硅基流动主页，在“模型广场”页面中挑选适合的模型，复制模型名称填入即可。

### 3.4 **填入 API key**

在硅基流动“API 密钥”页面，新建一个密钥。复制密钥，填入到“API Key” 输入框中，点击“保存”按钮，就可以使用了。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=03d042ad9f6641a6c7b8860ee3078044" data-og-width="1280" width="1280" data-og-height="1134" height="1134" data-path="images/usercases/prompt-assistant/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=280&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=0ac799bbc2b1cf7059dd1437c7fda4ab 280w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=560&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=c3e9102a6eee4b99bd490ae5b22f5d9a 560w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=840&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=9676539b3105622f8caf14450c46bf70 840w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=1100&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=31f2ec4405442e50e8e35b4276ab1054 1100w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=1650&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=7c9823e82f0231b1f1929a88eea5cce1 1650w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=2500&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=bb00aad4b22648a8ca57f228f3bd2f16 2500w" />
</Frame>

## 4、使用教程

提示词小助手的使用非常简单，不需要添加额外的节点或额外的启动操作，只要创建的节点上包含提示词输入框或者图像内容，小助手就会自动创建。当需要对提示词进行翻译、扩写、反推时，只需要点击小助手 UI 上对应功能的按钮，即可轻松实现需求啦。

详细的提示词小助手使用技巧，请查看作者主页：[诶-阿伟哥](https://space.bilibili.com/520680644)。


# 却惑几菩提
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-qhgpt



## 一、关于却惑几菩提

[却惑几菩提](https://qhgpt.aihub.ren) 是一个将人工智能技术与佛教文化深度融合的对话平台。在这里，以禅宗思想、佛教经典为根基，借助 AI 的强大语言处理能力，为用户打造一场充满智慧与禅意的对话之旅。无论您是想探寻佛法的真谛、求解生活困惑，还是单纯想感受禅意的宁静，都能在与平台的对话中有所收获。

平台秉持 “自性求佛” 的理念，希望通过一问一答的形式，引导您向内思考，体悟内心的智慧。同时，平台承诺不存储任何对话信息，在页面刷新后，所有内容都会重置，充分保障用户的隐私安全。但也请您注意，平台内容仅作为文化交流与探讨，若存在佛教知识方面的不准确之处，还望宽容理解。

## 二、如何使用

### 1. API 配置

本平台基于**硅基流动 API** 驱动，平台内置 API，可直接开启对话。

> 建议设置你自己的硅基流动 API 密钥，将会优先调用。可避免公用 API 因使用人数过多导致的回复速率问题。

1、打开 **硅基流动 [官网](https://cloud.siliconflow.cn/)** 并注册账号（如果注册过，直接登录即可）。

2、完成注册后，进入 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，点击 **新建 API 密钥**，点击密钥进行复制保存，以备后续使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6cc99bb2c389ff68b8a5b13a6d5f016c" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/qhgpt/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=521c74861e0ec31a655731b2c2d4f0b4 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=585ffa04b8bf4b5265358863c419ab5a 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9b71f7b622fb01a2d975a30eab3816ae 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=25ea71033e9276d96912b6729874c611 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e23c9ad1026e8188efcf3cb3133f4dcc 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3a230933ce58ca13951459489cd9e83b 2500w" />
</Frame>

### 2. 填入 API Key

1、请先阅读页面下方的 **【告示】**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=349568f33c4ccabfb192cf4fc3dfcafb" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/qhgpt/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=06bfc529903fa98cf77f7f066f7c77fa 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8d01d2c42d9e79f438bbebcbf4ea7ccc 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0976261a709f26108f72cf5209c24de8 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=18649796cb38f983deff85cb26cdb484 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d454c1eef4ec2fb50396e2495174696b 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3c65db9a72c61a610631b0b6e3851491 2500w" />
</Frame>

2、在页面对话输入框，右下角位置找到 **【拈花】**，点击会展开 **【API Key** 以及 **自定义角色】**输入框。请在**【API Key】**右侧的输入框中**粘贴您刚刚在硅基流动页面复制保存的 API 密钥**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=22364745ad2a1f6e13b772d08683f6eb" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/qhgpt/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=689c4192b9c1e497f4b85575f0438bde 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7f5af133dde4dcdf087d4e80bc8202b2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c6119565e3f9f1bd96bc8169648a0113 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ca941a12c5107456c87ba7364e309ea1 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=92142c68e24287534488cc3a42db85f1 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3a6a31cbdb09fd51a914d3a2749d53ae 2500w" />
</Frame>

3、点击人物头像，在头像下方的输入框中，输入您想要询问的问题、探讨的话题或内心的困惑。例如，您可以问 “如何理解‘诸行无常’？” 或 “生活中遇到烦恼该如何化解？”回车或点击右侧【 **卍** 】按钮开启对话。输入框左侧为\*\*【清空对话】**，右侧为 **【发送对话】** 、**【导出对话记录】**，点击**【录经】**复制当前回复，点击 **【轮转】** 将重新生成回复。等待回复过程中点击**【唵】\*\* 将终止回复。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=945bff2b6e84182321d4da4eaff6ea17" data-og-width="2879" width="2879" data-og-height="1799" height="1799" data-path="images/usercases/qhgpt/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4eee53b24b78e5cb8640b3c942d92daf 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=96f974d50f1524854defa0ba6e0ed51d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=93433a027af983c6134096c2c17dfd14 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=77ad43fd0c21f0bad42b75fac54524a4 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=44237f71b999a3ce829737eae0aae3f4 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bfee6d87240b1c4a2d04536c341b6cb5 2500w" />
</Frame>

4、当前版本仍处于持续迭代升级阶段，平台将陆续融入更多禅意新功能与趣味小彩蛋，静待您前来探索发现。

<Note> 注：本指南由合作伙伴提供，内容涉及宗教或哲学元素，旨在展示其技术应用场景，SiliconFlow 平台不持任何宗教立场。 </Note>


# 轻流无代码开发平台
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-qingflow



## 1. 关于轻流

[轻流](https://qingflow.com)是一款领先的无代码开发平台，致力于为企业提供便捷、高效、智能的业务系统搭建工具。通过轻流平台，企业用户无需编写复杂代码即可快速构建个性化业务应用，轻松实现业务流程的自动化与智能化！

本文将介绍如何借助 SiliconFlow 提供的 API 服务在轻流中快捷使用，赋能企业业务系统。

## 2. 使用轻流

无需下载安装，前往轻流官网，注册即可使用。[注册入口](https://qingflow.com/passport/register)

## 3. 在轻流中使用 SiliconFlow 连接器

### 3.1 订阅连接器

注册轻流之后，进入工作区点击“更多”-“轻商城”进入轻流连接中心，点击“硅基流动”，点击“订阅”，如下图所示。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=959f3a6d874d44cdef1a145353c1b4c1" data-og-width="1000" width="1000" data-og-height="446" height="446" data-path="images/usercases/qinglow/qingflow-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6ef6f6175252b518b4a7fbc6a7ae72a1 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=abf0c4d9998ad6c6f49c385521b38746 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0380f5e4bec334385662f012e18a3c3c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=33a1dabd1ac4c68952e8180e7b35e3b4 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f9dfd6cad8410dc7b779251453db4910 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=51f57ca8e7b911227110be2625602c1e 2500w" />
</Frame>

### 3.2 在业务系统中使用硅基流动连接器

在应用中插入“Q-Linker”字段，配置模式选择“使用连接中心模板”“硅基流动”后，即可选择你所需要的AI大模型；发布后即可投入使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=dd4b6449394cad28308109d7c546a274" data-og-width="1000" width="1000" data-og-height="484" height="484" data-path="images/usercases/qinglow/qingflow-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=cc8f425c583f316380da9103d13555a8 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=36c415e8f7a2ab56949ae3fbcfea6cbc 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7d450ed587053534919413e02a16c19c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c081eeca58a0ac236136223f7b850728 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ed98176b8d9db6bf5f8bd1537f570299 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=dc417a32dee780b9be9f6645b3973916 2500w" />
</Frame>

值得注意的是，在轻流平台使用硅基流动提供的大模型服务时，无需额外填写自己的 API key，轻流平台已自动配置与硅基流动账户的对接，大家可以轻松享受便捷的服务接入体验。


# 清雅
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-qingya



## 1、关于清雅

**清雅** 的寓意为“清新脱俗，知性优雅”。是一款融合了 Live 2D 模型的 AI 聊天互动应用，为用户带来沉浸式的温暖陪伴。目前支持 iOS 平台，具备**智能聊天**、**情绪识别**、**丰富背景**、**高度定制**，多项功能。

目前， 清雅合作硅基流动，用户输入硅基流动 API 密钥后，可选择硅基流动提供的各种**语言模型**进行聊天互动。同时，也可选择硅基流动提供的**文本转语音模型**，享受云端高品质语音，媲美真人发音。

## 2、安装使用清雅

在 App Store 内搜索“清雅”，下拉找到清雅 APP，点击下载即可。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e827394de908ba1661347a04340e0c7b" data-og-width="1231" width="1231" data-og-height="486" height="486" data-path="images/usercases/qingya/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d348c7f169af4bc6aeed76282b2b3c0d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2c3dc7e02419352870206a4a7bc159ea 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3e79953506dbef4bfc71b974ca67a5c7 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=59a3ef2f97cafc168937defe3d72bff1 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9d22914dc562e99ff34250a5b678bcd3 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ac78157a0101d20bff66d7000d899f55 2500w" />
</Frame>

## 3、在清雅中使用硅基流动模型

### 3.1 配置硅基流动的 API 服务

1、打开清雅 APP，进入设置页面，找到 API 设置模块，在模型服务中选择硅基流动。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1202df099ac8a8b8d2e1d76de62e145c" data-og-width="1242" width="1242" data-og-height="2208" height="2208" data-path="images/usercases/qingya/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=34028286f2b130468e1baf0bd9a1503d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=692df45ce22b763d253a983f691287e3 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=702483d6822769de4b8479ff863c0fb5 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a26b56a9cae70159f26875bf97a0a070 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1ee40fecf4afbc24f87913e61da6ad74 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bff8a133c17167a9fa6236f45f910100 2500w" />
</Frame>

2、点击“硅基流动平台”字样，进入硅基流动 注册/登录页面。注册/登录完成后，点击左侧导航栏的“API 密钥”，进入“API 密钥”页面。点击“新建 API 密钥”按钮，输入密钥名称后，再点击“新建密钥”按钮，即可创建硅基流动 API 密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=59107ace8e1fbf3791a5948ec510fdd6" data-og-width="1610" width="1610" data-og-height="919" height="919" data-path="images/usercases/qingya/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2dfb13047e5717b9a4bc924c1e624d09 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c54f39c9d89ba5261bf9e323b4b184ce 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=18e32256aabfb16f1ceba899e687659c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0d9831bcc278caed9e3f905bbad29762 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4f5a50b44c568aac547db98a1df08772 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6b7526fe31718dab3c9d0c6487d295f6 2500w" />
</Frame>

3、在“API 密钥”页面复制硅基流动 API 密钥，回到清雅 APP 中，在“硅基流动 API key”一栏粘贴，然后点击“测试连接”按钮，如果显示“连接成功”的弹窗，表示硅基流动的 API 服务配置完成。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ea07e63a00929f9f491570433c8b2759" data-og-width="1182" width="1182" data-og-height="822" height="822" data-path="images/usercases/qingya/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=06bea36be2e17181750180438573e43a 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bf06d365f93c0c0c8b75580c417cbe0e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fdbf38bd7195a00bcfef77e1fcd85088 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6650892b3fe6c1dc8b79a666589d159a 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e4db07c0e59af18403649d547b8fb10f 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=33b0d8a26d0c4c298836a957c49e5a37 2500w" />
</Frame>

### 3.2 配置语言模型

1、在“设置”页面的“API设置”模块下方，可找到“选择模型”一栏。点击“选择模型”旁的“刷新”按钮，能够获取硅基流动最新上线的模型列表，在右侧可进行大语言模型的选择。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9fe23fe58c858d485dccb0ee7819fa3f" data-og-width="1580" width="1580" data-og-height="1232" height="1232" data-path="images/usercases/qingya/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1a43ca12bf22b8b9dfcc7bb619d9004e 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=78a21f4ca373fefe508035abd8da8a79 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9002eac03b30aebb1058208f7f28a30c 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a899585fe03a8729f3a60d12964dacef 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c944621071ed135ea5b3b4e97fcfe700 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b8da7adffe6f18f601c340078ef2602f 2500w" />
</Frame>

2、同理，在“相知”页面的输入框上方，点击“选择模型”按钮，也能够随时切换与您对话的大语言模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=678520a485e4498ee1da082cfb00c511" data-og-width="1578" width="1578" data-og-height="1234" height="1234" data-path="images/usercases/qingya/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fd7201aeb74546e6f5887993ab575b20 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dd06f9b8e56c119a86a058f47b7bc233 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b22d37b044e68f2290228b014f06aefd 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c360d3bc80676dccf8b62f409798ebf4 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0b267199bd92fd0d06d7f089a08fe404 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9036fe6d1c05d2edd7d86b025fa1d1f2 2500w" />
</Frame>

3、选择大语言模型后，即可在应用内进行语音通话或者文字交流。

### 3.3 配置文本转语音模型

在“设置”页面下方的“人物设置”模块，找到“选择语音”按钮，点击按钮进入“语音设置”页面。清雅提供“系统内置”语音服务或者“硅基流动”语音服务。在“硅基流动”语音服务中，可以选择硅基流动上线的文本转语音模型。选好模型和音色后，点击页面底部的“测试当前语音”按钮试听当前语音，满意的话，再点击“保存设置”按钮，即可使用当前语音与您进行对话。

和系统内置的音色相比，使用硅基流动的高品质语音能够显著降低机械感，媲美真人发音，效果非常惊艳。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d0a36a68769aa60db6a4a444ffba62cd" data-og-width="1712" width="1712" data-og-height="1374" height="1374" data-path="images/usercases/qingya/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=06af04a1dd242613e84de0369ac9d566 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=15b4155111898910edaee553821a6c7c 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8fc1d5d6c773bd908cb338007c61f1f8 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c40892000e0cfa99a6f47279e6cf8fac 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=67ede09c01bb39d5bb11d5d0475935f0 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6b9ad366cb7a2c127aa7f41bf0813b8a 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1b60771f10ec9ad1142d951858fcb39c" data-og-width="1800" width="1800" data-og-height="1462" height="1462" data-path="images/usercases/qingya/8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c0d3b6393badd4c49e89ff654b09f2f3 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=135100f3009dc7952b96cff99a814378 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=451da8d19ae97701d0ad5c8ea7482c04 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=242fd4e4a7530fe647e04d148d607f0a 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=43031ff3e304d5dceb95ff9acd7a01bc 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=78bd516aaf3f59f3d8dea226524f42c0 2500w" />
</Frame>

## 4、功能简介

除了上述提及的 AI 聊天功能外，应用还提供以下功能：

**情绪识别**：深度分析对话情感，可根据情感使 Live 2D 模型表现相应的动作或表情。

**丰富背景**：应用内置多款静态图片背景和动态视频背景，营造良好聊天氛围。

**高度定制**：用户能够选择使用自定义的 Live 2D 模型、聊天背景、主题颜色、应用启动页、人物设定等等，个性化定制自己专属的应用风格。

### 4.1 选择 Live 2D 模型

在“设置”页面的“人物设置”模块，用户可以使用应用内置的Live 2D 模型或者导入自定义的Live 2D 模型，还可以配置每种情绪相对应的表情或动作

### 4.2 选择背景

在“设置”页面的“主题设置”模块，用户可以使用应用内置的丰富聊天背景或者导入系统相册内的图片或视频作为自定义的聊天背景。

### 4.3 选择人设

在“设置”页面的“人物设置”模块，用户可以选择让 AI 扮演的人设，应用内置多种预设的人设模板，用户也可保存自定义的人设模板。

## 5、参考资料

如果想了解本应用的更多内容，可以看看清雅的用户手册。

[用户手册](https://www.yuque.com/qingya-ojuuj/czi4uf)

联系我们：[wangjingqian1770@163.com](mailto:wangjingqian1770@163.com)


# Refly
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-refly



[Refly](https://github.com/refly-ai/refly) 是一个支持 MCP、工作流和 Agent 的 **开源 AI 工作台**，旨在将创意转化为可重用/分享的工作流，并通过工作流产出高质量的文档、PPT、知识网页等结果。

> 本文将介绍如何在 refly 中使用 SiliconFlow 提供的模型能力。

## 访问 Refly

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0648fed3b733170b22377aa7f2d3017c" data-og-width="1900" width="1900" data-og-height="872" height="872" data-path="images/usercases/refly/refly主界面.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=45ecace90661bc7ae466b9dbb71fff14 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=07c43c15fc3392cdf4bcc92c530843cb 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f3ad342928abb8efd9385eb414354b4 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=486a994cd96335b09b64785aacf299e2 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dc298db8908c7a6a8fcf505ae3d6aec0 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b21be9f730e7dff1fbd7c23132844f87 2500w" />
</Frame>

您可以通过访问 [refly.ai 官网](https://refly.ai)，注册并登录您的账号，开始体验 Refly 强大的 AI 工作空间。平台支持网页端直接操作，无需本地安装，支持多种 AI 模型和工作流的创建与管理。建议使用最新版的 Chrome 或 Edge 浏览器以获得最佳体验。

### 点击开始使用

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7f0047ef4b707414b68e6a0c3d4d3040" data-og-width="1919" width="1919" data-og-height="861" height="861" data-path="images/usercases/refly/refly开始使用.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=448ee4061c6bfc3e461a85597c367a8d 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=217410f593b0a7f2c72f61a7cb8134e4 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c8c073c05154df1f3a226a0b13e92427 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d7be7f8594e36c298384f6e7127b9fcf 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c23146f61960abfd484bc55d6b6b56fd 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=561bc24e1b601640ad0d89f681548cd2 2500w" />
</Frame>

> 选择你的登录方式

## 配置 SiliconFlow

### 第一步：进入设置页面

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2130f54c17d6678945fd77526bed059c" data-og-width="1922" width="1922" data-og-height="873" height="873" data-path="images/usercases/refly/refly点击头像.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7ba6a24a5ceb5374ab5ce2f064b1053a 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6f5d96f42b9bc8be6675e676e29c3c78 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=cb6966ba742b4d142a072367571c2145 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ac22d1486c9995460ef271fe91ebf9d6 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=51a3c807661a7a11ba4db33c594cf02d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2b66ae6be59a356f97dab02b8a34f262 2500w" />
</Frame>

登录 Refly 后，在左侧导航栏底部找到您的头像，点击头像进入个人设置页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d7e8bb2cf125dfd37f06f33214a28f61" data-og-width="1901" width="1901" data-og-height="875" height="875" data-path="images/usercases/refly/refly点击设置.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e529fb79ffab201981eff477c7883927 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=763118d342c7a100734aa59aec4e2eed 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=71f439926b7b5eef709ac70271c57409 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=53e56a945d7f86cabde794f85e7e1820 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=10fea33b85738b9f745a8080960ec30d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b666d908d750d6d27a03272222420c84 2500w" />
</Frame>

在个人设置页面中，点击"设置"选项，进入系统配置页面。

### 第二步：访问供应商商店

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eb34f51904d023c7d12ba0fd60c6b50a" data-og-width="1915" width="1915" data-og-height="866" height="866" data-path="images/usercases/refly/refly模型供应商商店.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a72b9ca5c2108766867e4e9df9715287 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dab47c504381edc237368a1dc7f871db 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bad0a63b1fd9bc2b994e552c45af0884 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1e5e0054c20434284a382857a1bfd918 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1ff9348a13d410f96620b4e89d703067 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4b30196add3909c97441df9cb97be3a6 2500w" />
</Frame>

在设置页面中，左侧导航栏选择"供应商"选项，然后在主内容区域点击"供应商商店"标签页。这里列出了所有可用的 AI 模型供应商。

### 第三步：安装 SiliconFlow

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f5fea33df1f19c6834e107b2fa6d5d4" data-og-width="1918" width="1918" data-og-height="872" height="872" data-path="images/usercases/refly/refly安装siliconflow.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=200e02dceeb99086ffe1da44fb95e7e6 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c06c7a55739e3b2bab75e6623b18bccf 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8c0787dd830de00a1fe9ac23d96c8ccd 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8006f87ab145dbcb249d1940f5026b21 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b6f53ab928963ba88f190af76fedcb87 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=679559d051e9ee259d8b86c36472f509 2500w" />
</Frame>

在供应商商店中找到 "SiliconFlow" 卡片，点击其右侧的"安装"按钮。SiliconFlow 提供一站式云服务平台，为顶级大语言模型和嵌入模型提供高性能推理服务。

### 第四步：配置 API Key

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6476e4d6773502c00eee7b56931f3524" data-og-width="1892" width="1892" data-og-height="871" height="871" data-path="images/usercases/refly/reflyapi配置.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1649f117ff4603c4476f49817a28b160 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8873536e75e0b2dbbcbc50764a027ab2 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a1bd7da9cc22e8f60f6a3ad765ab1601 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1effdc83fe16ac6f4f7b23a8ea91e049 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=26dd485d746c9ba7fcc08d534dcab4da 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f75c37dbd809e9ab08cff57632f1fff3 2500w" />
</Frame>

<Frame>
  <img src="https://raw.githubusercontent.com/siliconflow/doc-images/refs/heads/main/2-siliconcloud-apikey.png" />
</Frame>

安装 SiliconFlow 后，系统会弹出"配置 API Key"对话框：

1. **获取 API Key**：您需要从 SiliconFlow 官网获取 API Key
2. **填写 API Key**：在"API Key"输入框中填入您的密钥
3. **Base URL（可选）**：默认值为`https://api.siliconflow.cn/v1`，如需使用自定义服务地址可修改
4. **点击安装**：确认信息无误后点击"安装"按钮

### 第五步：验证安装成功

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4aac22a940ee91f0a8ace685396b32fc" data-og-width="1918" width="1918" data-og-height="877" height="877" data-path="images/usercases/refly/refly显示安装成功.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ec41e7fee593275c538852cc05249a75 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6abf7212049017ac4a452c64a5a8217b 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3b81c81581882764787b844bb2e3937b 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=de9a3406a89ade991beefcc626367c26 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f5edeb35d8b7b63b66ab271a5085d6c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=95a76974515f4b3e6c9292ab6a346850 2500w" />
</Frame>

安装成功后，您可以在"我的供应商"标签页中看到 "SiliconFlow OPENAI" 已添加到供应商列表中，并且开关处于启用状态。

### 第六步：配置模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8578cb721c909381fa416ce109b1c470" data-og-width="1916" width="1916" data-og-height="867" height="867" data-path="images/usercases/refly/refly模型配置.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=88c04ca8e245cbc4496a269bf8a6c34f 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7f2cb18dff541123f26ee9d85b9a1cea 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=98037795f516072fe8310acc8fd09c48 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7185a424b546e05ef6270e90025fd566 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d1fd4d0475a8193f948327c3d92f255c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4b2d7a94167418f998a492c44e07c710 2500w" />
</Frame>

在左侧导航栏中选择"模型配置"，进入模型管理页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=58782bf7463084b05f57cd8f1e169d22" data-og-width="1918" width="1918" data-og-height="875" height="875" data-path="images/usercases/refly/refly确认添加模型.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0ec97c776e7c20c5f32e55d6dbc7127f 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9097d3278b65bb11570346186bd47f7c 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=82371473a7ae2fd7bb347210c6c13449 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=167282e36efa51e3dc1a7ed62e83ab30 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b3fa678167bb4fd573a44de2a0cbe197 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=579bbe8a9ec63027287874e8c3e736dc 2500w" />
</Frame>

点击"+ 添加模型"按钮，在弹出的对话框中配置模型参数：

* **供应商**：选择 "SiliconFlow"
* **模型ID**：输入`deepseek-ai/DeepSeek-V3`
* **模型名称**：输入`deepseek-ai/DeepSeek-V3`
* **分组名称**：输入`siliconflow`
* **上下文数量限制**：设置为`128000`
* **最大输出token**：设置为`128000`
* **能力**：勾选"函数调用"等所需功能
* **是否启用**：保持开启状态

### 第七步：了解模型能力

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=89c5c9187073d9cb376ec6bcd8990701" data-og-width="916" width="916" data-og-height="870" height="870" data-path="images/usercases/refly/模型能力.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=56d9be4a1a88dc36456c8fa0653e7d4e 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e5d44404b6a4d32a6598306c7584c475 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=59bb2357e6ea8b0997d278fbdb254ff8 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a24fc212a23b5225731315370004e730 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=30867234dc2f09dc17593e22b4622bec 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b46958f352faa6dc7c3033467f79539a 2500w" />
</Frame>

DeepSeek-V3-0324 模型具有以下特点：

* **价格**：输入 ¥2/M Tokens，输出 ¥8/M Tokens
* **上下文窗口**：128K tokens
* **支持能力**：
  * 工具调用 (Tool use / Function calling)
  * FIM 补全 (FIM completion)
* **速率限制**：RPM 1,000，TPM 10,000

## 使用建议

1. **API Key 安全**：请妥善保管您的 API Key，不要泄露给他人
2. **费用控制**：注意监控 API 使用量，避免产生意外费用
3. **模型选择**：根据具体需求选择合适的模型和配置参数
4. **功能测试**：配置完成后建议进行简单的功能测试，确保一切正常

## 常见问题

**Q: 如何修改模型配置？**
A: 在模型配置页面中，点击对应模型右侧的"..."按钮，选择编辑选项。

**Q: 如何禁用某个供应商？**
A: 在供应商列表中，将对应供应商的开关关闭即可。

***

配置完成后，您就可以在 Refly 中使用 SiliconFlow 提供的强大 AI 模型能力了！


# RikkaHub
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-rikkahub



## 关于 RikkaHub

RikkaHub 是一个支持多模型服务的安卓 APP，能够接入不同的 AI 供应商和模型。

* 采用原生技术开发，启动快速使用流畅，并且界面简洁，使用 Material You 设计。
* 功能强大，支持 Markdown，公式，Mermaid 渲染，支持网络搜索，MCP，TTS 等功能，并且强大可配置。

## 下载安装

* 从 [官网](https://rikka-ai.com/) 下载
* 从 [Google Play](https://play.google.com/store/apps/details?id=me.rerere.rikkahub) 下载

下载 APK 后安装即可。

## 免配置使用硅基流动模型

**自 1.4.8 版本起， RikkaHub 已与硅基流动达成合作，默认集成了 2 个由硅基流动提供的免费小模型，用户无需登录即可直接使用。**

进入对话页面，点击页面左下角图标，也可从  Qwen3-8B / GLM-4.1V-9B 中切换选择，而无需配置 API Key。

### 默认模型配置

目前，默认模型配置页，已根据产品功能对应预填了硅基流动的两款模型。该页面也支持手动修改配置，以下为不同功能对应的模型选择建议。

* **聊天模型**\
  用于与用户进行自然语言对话，是主要的交互模型。不同模型风格和能力略有差异，建议根据个人偏好选择。

* **标题生成模型**\
  负责总结对话内容并生成对话标题。建议选择**参数量较小、性能稳定**的模型，避免使用复杂的推理类模型，以提升效率并降低资源消耗。

* **聊天建议模型**\
  用于自动生成聊天建议，显示在输入框上方。如果不需要此功能，可点击 “×” 关闭，不设置该模型后将不再显示建议内容。

* **翻译模型**\
  支持应用内的多语言翻译功能，包括对话翻译和 AI 翻译界面的实时翻译服务。

## 配置硅基流动模型

1、侧滑侧边栏，选择"设置"，进入设置页面，选择"提供商"进入 AI 提供商配置页面
2、选择硅基流动卡片，进入硅基流动配置页面，将你的硅基流动的 API Key 填写到**API Key输入框**内，然后点击**保存**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5db2aae7629390ec0bdff5fad5910d03" data-og-width="1080" width="1080" data-og-height="2400" height="2400" data-path="images/usercases/rikkahub/image1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=beace2d901de0b37c0c3642fdecdc807 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=53619a3f799e9f8475a55f886735d7d7 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b033cffb58757e55998bdbf6d119975d 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ca1f157b340ca09a3b66f3785e630d3c 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1f6ba86ab96272f1af56b11fcb709041 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image1.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4d39025d6c4529e391277eff9c2d12b5 2500w" />
</Frame>

3、点击底部的模型，进入模型配置页面，添加你想要的模型，可以手动点击 “+” 添加模型，也可以点击左边的按钮选择你喜欢的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c9a76b5a65c6785ae273925ba436c437" data-og-width="1080" width="1080" data-og-height="2400" height="2400" data-path="images/usercases/rikkahub/image2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e9b2ffbddf6412db95fbb6b11679c46a 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=cfe47ee97b1bee2d270a5d69236a571d 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d50e25ec6fc768340e98a323c4a160a9 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=371ff21b707754cc77eb9d2a096cf0e8 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=36678af4359593eeee0f98b81cee96b5 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3c079b290ac8d483d8c1412807e71e61 2500w" />
</Frame>

4、返回主菜单即可开始使用

## 其他功能

### 助手设定

一个助手就是具有不同提示词和参数的 Agent，你可以创建和切换你想要的助手。

既可以在设置中进入助手配置页面查看和编辑助手，也可以直接在侧边栏切换和编辑当前的助手。

同时，助手之间的对话是隔离的。

### 记忆功能

大模型没有记忆功能，离开对话就无法记得聊了什么。APP 有一个记忆功能，可以引导大模型主动存储一些记忆到数据库内，并且在其他聊天内模型可以读取到这些记忆。

点击进入一个你想开启记忆的助手，然后点击记忆 tab，即可进入记忆配置页面，你可以开关记忆，也可以编辑已有的记忆。

记忆是大模型主动记录的，需要模型支持工具调用，不过你也可以在这里手动修改或者添加。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2e66a75b1399ce8e5a21fd2c3dd95bdb" data-og-width="526" width="526" data-og-height="657" height="657" data-path="images/usercases/rikkahub/image3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9fb938fa8d53fbf6d1d25d378144344c 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6d18a1525d8e91e8f66dcb208146b1b9 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=cec8a5fe32bb8f9ce147aff07fca42a8 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4c85f69b06fae620a3a983d30dcd8d6b 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f06e08cd81a6658fc43e45120666d1b2 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/rikkahub/image3.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7d3face543b6a08dc8ffc22d765acc6c 2500w" />
</Frame>


# Sider
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-sider



作为 2023 年度 “Chrome 年度精选插件”，Sider 获得了 50K+ “5星好评”，并有 6+百万 的活跃用户。Sider 浏览器插件主要解决：

* Sider（ChatGPT 侧边栏）是您有用的人工智能助手，您可以在浏览任何网站时使用它。

<Note>开发者可以打开 [Sider官网](https://sider.ai/zh-CN/) 来使用 Sider 应用。</Note>
<Note> Sider 为满足软件开发者的需求，提供了 OpenAI API的兼容模型注册方式，以便大家可以更加便利的使用大家想要的模型。</Note>
<Note> 作为集合顶尖大模型的一站式云服务平台，SiliconFlow 致力于为开发者提供更快、更便宜、更全面、体验更丝滑的模型API。 </Note>
那么怎么在 Sider 中使用 SiliconFlow 呢？

## 1. 获取 API Key

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Sider 中使用 SiliconFlow 语言模型系列

按照下图操作即可

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=aff9a01f92463d2d489ec42dc53693c0" data-og-width="2448" width="2448" data-og-height="1874" height="1874" data-path="images/usercases/sider/sider.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=16c231afe6f32639025495688c064f38 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=20f34173720236fcdfa0135ec0be8845 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f8a58ece6e25d78d9d272eea215760c7 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f3bce3ca7135782bed179b87865c26f 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=69d2ffdd0da9e9f6423073051795028a 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=60b36bb51482540c18163c22a8899994 2500w" />
</Frame>


# ToMemo
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-tomemo



ToMemo 是一款多功能快捷键盘 + 剪切内容记录 + 懒人短语的便签应用。可以帮助你快速获取和输入常用的内容，比如邮箱地址、快递地址、身份证号、发票抬头等。

## 添加 SiliconFlow 供应商

进入添加页面后，直接点击「供应商」选项，在里面选择 SiliconFlow （硅基流动），此时，会自动填入名称、Base URL 和接口类型。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fa2c36a241eb32ae2b845de176459e0b" data-og-width="1170" data-og-height="2532" data-path="images/usercases/tomemo/tomemo-1.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c936c6a0ff254d6e1040d9350add8ddf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b99845542de28aa977633a13bfcafba8 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=010ca4ccbe9c95b697cec67c5dbebd9f 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2fac203a6dfec8046b76554f21dde2a5 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=81c1a5710a749a7a24beda9335909487 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=721ccc8d0456cd23c936031b9d35fd33 2500w" />
</Frame>

## 从 SiliconFlow 获取 API Key

SiliconFlow 的 API Key 获取地址：[点击打开 ](https://cloud.siliconflow.cn/account/ak)

点击后，完成登录，进入到下面所展示的页面。

点击「创建API密钥」按钮，逐步完成创建。

需要**拷贝 API 密钥**， 并妥善保管。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5cb71d2204ce1b055c6f312276a74c29" data-og-width="5088" data-og-height="3896" data-path="images/usercases/tomemo/tomemo-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5f3a36fa907ee946ed14b6ca3e3f9f5e 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=813b7df970dc588a50c07dfa719398d9 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=66376cbd751731b7ec5e79ab7f2f89e6 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0aea0ad46fa866fc4b1f8e714fc84e58 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=22cfcae143bd14290731d77e8db7925d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=93c73ca87c7efebd6309c9488db92c1a 2500w" />
</Frame>

### 拉取模型

将上面获取的 API Key，填入到当前页面的 API Key 输入框中。

点击「拉取模型」按钮，会自动拉取模型。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4ee0c41b86023897f3fd5e4185fe8035" data-og-width="1170" data-og-height="2532" data-path="images/usercases/tomemo/tomemo-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6f0459a0bb7c6fd400f38299ca6137b4 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2f48a063f27b45b4121e60ab3f13b113 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a84d7d4b6cbc9a043d4bcc5fff3e972c 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d2cb231edc7ff2905d94ba71d5cb752b 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bb5c7cfb6c0db19b43b8a48721b653ed 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e426aec1c10efa4c97a2056c70233dfa 2500w" />
</Frame>

然后选择需要加载的模型，最后点击「保存」按钮，完成 SiliconFlow 的集成。

💡

**Tip**

需要选择文字生成模型，应用暂时不支持图片输入和输出。

## 添加单词助理 🤓

进入「AI助手」页面，开始添加 AI 助手。

我们从模版中添加「单词助理 🤓」。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-4.gif?s=594e6735958d397e3226fdcb994770fe" data-og-width="480" data-og-height="1038" data-path="images/usercases/tomemo/tomemo-4.gif" data-optimize="true" data-opv="3" />
</Frame>

## 键盘中的单词助理 🤓

在键盘中使用「单词助理」，需要先在「AI助手」中添加「单词助理」的助手。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-5.gif?s=04af5b31ccb22dd52c1c883c653a5629" data-og-width="480" data-og-height="1038" data-path="images/usercases/tomemo/tomemo-5.gif" data-optimize="true" data-opv="3" />
</Frame>


# Trae
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-trae



[Trae](https://www.trae.com.cn/) 是字节推出的首个 AI IDE，Trae 预置了一系列业内表现比较出色的模型，你可以直接切换不同的模型进行使用。此外，Trae Chat 模式还支持通过 API 密钥（API Key）接入硅基流动的模型资源，从而满足个性化的需求。

## 切换模型

在输入框的右下角，点击当前模型名称，打开模型列表，然后选择你想使用的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1747650c77c13bf0b8006fd8af22c824" data-og-width="1280" width="1280" data-og-height="800" height="800" data-path="images/usercases/trae/trae-1.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=23b7f373743c254efeccccfe568f51aa 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5576a62497e6a0ccf8d2ec4caafc81e8 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3ef68dcd7e5998afcee62cb73888ccdf 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2b4c0e5e23c85db8db096af1931e0f3f 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ec4fe5e502ebd72e611188afeec24ea6 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f23f19895565051f292aa8981cdd7037 2500w" />
</Frame>

各个模型的能力不同，你可以将鼠标悬浮至模型名称上，然后查看该模型支持的能力。

## 添加硅基流动模型

1、前往 **头像** > **设置** > **Trae AI** > **模型管理**。

2、点击 **添加模型** 按钮。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=75fb614c651764c033941fd49d216fcf" data-og-width="1280" width="1280" data-og-height="800" height="800" data-path="images/usercases/trae/trae-2.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bc83921058771fe48949843ba49d37bf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6cdb35c08b1472b91535ba8a4c12d390 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0810a8c73574e06ba73ce0059fc964e7 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=27a626f72e241e77068fcbe4f82cdb68 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0b21a644d01a13fade90ee77cc7613eb 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c39fa3366018422a0432324008b9fc4c 2500w" />
</Frame>

页面上显示 **添加模型** 窗口。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4ff8b03199290acbd5beb2d3e9e8a3b6" data-og-width="1280" width="1280" data-og-height="800" height="800" data-path="images/usercases/trae/trae-3.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c853a0a3b1ba6dc9f34989149353c9df 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=622a0260d94749eb23cb23767fa72658 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=db86acd95991542b194d689a02a45e76 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e51456c448ee7fe2db51e6e61003ea60 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=94cc96a5302a34495d2bb51f1b6e4292 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6909f884f89ee93abbd9bbbed7d21216 2500w" />
</Frame>

3、选择 **服务商**为硅基流动

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8c47b6803454d3b6e1ea19c87c3e7d95" data-og-width="1280" width="1280" data-og-height="852" height="852" data-path="images/usercases/trae/trae-4.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=336f5b64b91cc1328b97f9c10793b950 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0e43511b7ee63c3d98260e19d996916e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7237c8f277cdfbba9cc8490a25082366 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3a4203efa11390a0aa1e9f8d5d49e177 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e64913198173041f61cfee7e2bceaed5 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=340334c63324d4c7162f6e3d9ebd30dc 2500w" />
</Frame>

4、选择 **模型**：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c6ad83c31b0465f0edaab857ccca73c4" data-og-width="1280" width="1280" data-og-height="855" height="855" data-path="images/usercases/trae/trae-5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=22fa0d68b0d645a66a4bed5342415339 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=480fb56b25b903a8a40450745e974982 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=67e2c593aefc419a8bff8bc01546790a 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=680825836b37b666f7769138c1f4476c 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8cf6f666f7005f009a9acbdd42ffdd0c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bccec004763dcbfb22cc5cc577e8e2a4 2500w" />
</Frame>

￮ 直接从列表中选择 Trae 为每个服务商预置的模型（均为默认版本）。

￮ 若你希望使用其他模型或使用特定版本的模型，点击列表中的 **使用其他模型**，然后在输入框中填写模型 ID。

5、填写 **API 密钥**

点击 **获取 API 密钥** 按钮，Trae 会为你打开硅基流动的 API 密钥配置页面。（若未注册/登录对应网站，需先完成注册/登录动作）

进入页面后创建新的 API Key，点击密钥进行复制。

6、点击 **添加模型** 按钮

Trae 将调用服务商的接口来检测 API 密钥是否有效。可能的结果如下：

￮ 若连接成功，该自定义模型会被添加。

￮ 若连接失败，**添加模型** 窗口中展示错误信息和服务商返回的错误日志，你可以参考这些信息排查问题。

**管理自定义模型**

在设置中心，你可以管理自定义模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8d6869098e6312ab84c0251ed93027ef" data-og-width="2388" width="2388" data-og-height="1568" height="1568" data-path="images/usercases/trae/trae-6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eb3a7e209bb4c86580ee2ba084d21bd3 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a94650086bf8453f877664a8bd3b7a74 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dba3d61b5e4da0f83e97a3cf13d3d2ad 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e82555e438618d7146f9c0b476b3b0e8 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fb9012cdfa33ee94fd719233c688c41b 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ef49052bec12871dcfbb50c5c63d2ca5 2500w" />
</Frame>

| **编号** | **操作类型** | **说明**                                                                       |
| ------ | -------- | ---------------------------------------------------------------------------- |
| 1      | 编辑模型     | 点击 **编辑** 图标，然后在弹窗中修改服务商、模型名称、API 密钥等信息。                                     |
| 2      | 删除模型     | 点击 **删除** 图标，然后在弹窗中二次确认。删除后，当前模型将被从列表里移除，不可被继续使用。                            |
| 3      | 启用/禁用模型  | 若你不希望删除模型，但在一段时间内无需使用这个模型，你可以禁用该模型。被禁用的模型将保留在设置页面的列表中，但不会出现在 AI 对话框的模型选择列表中。 |


# Trancy
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-trancy



Trancy 不仅提供网页沉浸翻译、划词划句翻译、字幕翻译和 PDF 翻译，此外用户还可以基于自己感兴趣的内容进行语言学习，渐进式的掌握一门新语言。

Trancy 集成了 SiliconFlow 提供的 API 服务，还内置了免费的 Qwen/Qwen2-7B-Instruct 模型，如果需要其他模型也可以在 Trancy 中手动添加。

## 下载 Trancy

Trancy 翻译扩展支持主流的浏览器，如 Chrome、Edge、Firefox、Safari等，下载安装地址：[Trancy 翻译](https://www.trancy.org/download)

## 使用 SiliconFlow 服务

### 1. 使用 SiliconFlow 免费模型

点击 Trancy 扩展图标，进入设置，点击「翻译引擎」，接着根据需要选择 SiliconFlow 引擎即可，默认内置模型是 Qwen/Qwen2-7B-Instruct 。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=b9877f7d0ddeeef76a84251b26cb8224" data-og-width="1558" width="1558" data-og-height="1404" height="1404" data-path="images/usercases/Trancy/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?w=280&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=127faaeacb099a74c5f4a3948c9188c9 280w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?w=560&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=e3f5b241c0e62ca017b79f70080cba1c 560w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?w=840&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=b4e01eb79728f0fea2b435c9a6b358ae 840w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?w=1100&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=8bb5a32cc3ba336b5f847c2942f53c8e 1100w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?w=1650&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=167e57da3c2114e6cbac40bbe53a8d07 1650w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/1.png?w=2500&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=ad0102b22a6b646140ad35d25a92d713 2500w" />
</Frame>

### 2. 使用 SiliconFlow 的其他文本模型

1. 打开 [SiliconFlow 官网](https://siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。
3. 进入之前 Trancy 的引擎管理页面，点击右上角或空状态的添加按钮，可以选择需要的模型，将 API Key 填入硅基流动翻译服务的 API Key 设置项中，然后点击保存即可回到扩展中使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=aa6abad7572d2b1e3baee0a4ef846b31" data-og-width="2626" width="2626" data-og-height="1494" height="1494" data-path="images/usercases/Trancy/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?w=280&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=5fe42663bd9e5cf65c07323fe421eba2 280w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?w=560&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=9c822697160584f8aeb02350d4af2ce8 560w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?w=840&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=e492dd56b1f31ed40cb003dd8fe3b62c 840w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?w=1100&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=b28012eccf8518d7a9bc98be405ffc38 1100w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?w=1650&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=12eb32ac920222db7b1e7f0082271caf 1650w, https://mintcdn.com/siliconflow-37161621/0DVSR5Y6rtrJXOKM/images/usercases/Trancy/2.png?w=2500&fit=max&auto=format&n=0DVSR5Y6rtrJXOKM&q=85&s=c4bbabb5782e40860c77e591c177f447 2500w" />
</Frame>


# translate.js
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-translate-js



## 简介

[translate.js](https://gitee.com/mail_osc/translate) 是面向前端开发者的 AI i18n
专注于多语言切换能力，两行 js 实现 html 全自动翻译，百多语种一键切换，无需改动页面、无语言配置文件、支持[几十个微调扩展指令](https://gitee.com/mail_osc/translate)，满足你的一切个性化需求、对 SEO 友好。
采用 MIT 协议进行开源: [GitHub](https://github.com/xnx3/translate) | [Gitee](https://gitee.com/mail_osc/translate) ，完全免费开放并允许商业使用。

本文将详细介绍依靠 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 提供的 API 服务，让你的网站支持上百语种切换。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/html_demo.gif?s=5c1ada668555a20ca5cd4a44e80ffacf" data-og-width="1650" width="1650" data-og-height="718" height="718" data-path="images/usercases/translate-js/html_demo.gif" data-optimize="true" data-opv="3" />
</Frame>

## 模型优化

提到翻译，可能你第一时间想到的这种情景：输入框输入一段文字，后面跟上一句 ： 帮我翻译为 xxx 语言 ，它并不是这样的。

大模型有比传统机器翻译更好的译文质量，但稳定可靠的结果输出是线上场景是必须要具备的，它对大(小)模型在文本翻译领域的实际应用场景应用使用进行了深度调优及多重自检修复，以达到稳定可用的能力。展开聊聊见 [这里](https://e.gitee.com/leimingyun/doc/share/6d69716d52be98f0/?sub_id=14253611#%E6%A8%A1%E5%9E%8B%E4%BC%98%E5%8C%96)。

简单来说，就是可以通过 [SiliconFlow](https://cloud.siliconflow.cn/i/64MyJQtM) ，来对各种不规则的句子、多语种混合的句子、前后各种不通顺的句子进行翻译，进行翻译，质量比传统文本翻译的阅读通顺度跟高，同时还能达到传统文本翻译的极速响应。

## 快速使用

您无需做任何前提准备，各种注册等，只需加入几行 js 就能完成

### 代码

只需在你原本的 html**底部**增加以下代码，即可完成接入

```
<script src="https://cdn.staticfile.net/translate.js/3.15.6/translate.min.js"></script>
<script>
translate.service.use('siliconflow'); //设置采用硅基流动的翻译通道
translate.execute(); //触发翻译
</script>
```

### 说明

只需要 js 加入 `translate.service.use('siliconflow');` 即可使用 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 免费的 qwen3-8b 模型来进行翻译，我们已对硅基流动进行了深度集成，所以你无需其他任何设置。

translate.js由 [指点云](https://www.zhidianyun.cn/?i125cc1) 提供服务器赞助支持，将大模型转化为文本翻译 API 并开放给 translate.js 进行使用，亚、欧、美洲等都有网络节点以支持全球范围的网络使用畅通。
如果您接入时遇到困难，可[点此反馈求助](https://gitee.com/mail_osc/translate/issues)，或加 QQ 群（1034085260）向作者求助。

### 微调指令

translate.js 有极其丰富的扩展指令，让你可以对它进行各种精准控制，满足各种难缠客户的各种脑洞要求。（如果满足不了，可通过上方 QQ 群提出来我们加） 比如：
[切换语言select选择框的位置、CSS美化、是否出现、显示的语种等](https://translate.zvo.cn/41541.html)、[设置默认翻译为什么语种进行显示](http://translate.zvo.cn/4071.html)、[自定义翻译术语](http://translate.zvo.cn/41555.html)、[翻译完后自动触发执行](http://translate.zvo.cn/4069.html)、[指定私有部署的翻译服务接口](http://translate.zvo.cn/4068.html)、[监控页面动态渲染的文本进行自动翻译](http://translate.zvo.cn/4067.html)、[自动切换为用户所使用的语种](http://translate.zvo.cn/4065.html)、[用js控制主动进行语言切换](http://translate.zvo.cn/4064.html)、[只翻译指定的元素](http://translate.zvo.cn/4063.html)、[翻译时忽略指定的元素](http://translate.zvo.cn/4061.html)、[翻译时忽略指定的文字不翻译](http://translate.zvo.cn/283381.html)、[对网页中图片进行翻译](http://translate.zvo.cn/4055.html)、[鼠标划词翻译](http://translate.zvo.cn/4072.html)、[网页ajax请求触发自动翻译](http://translate.zvo.cn/4086.html)、[设置只对指定语种进行翻译](http://translate.zvo.cn/4085.html)、[对指定标签的属性进行翻译](http://translate.zvo.cn/231504.html) ……

更多指令及其说明可 [点此查看](https://gitee.com/mail_osc/translate).

## 使用 SiliconFlow 实现私有部署

您可以注册 [SiliconFlow](https://cloud.siliconflow.cn/i/64MyJQtM)  自己的账号，然后私有部署此服务，来进行更多设定，极大提升使用体验。

### 优势

* **翻译质量**：你可以对接 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 更大尺寸的模型，比如 qwen3-32B，让翻译语句更通顺，拥有极高的阅读体验。
* **极速响应**：可开启 [内存缓存](https://translate.zvo.cn/391130.html) 来极大提高文本翻译 API 的响应速度
* **用量限制**：可针对某个域名（或者开通 API 接口的 key）来设定它的 [用量限制](https://translate.zvo.cn/391130.html) ，如果你是网络公司，你可以以套餐的形式卖给使用用户。
* **管理接口**：可以通过开放的 [管理 API 接口](https://doc.zvo.cn/translate.service/20250312/admin.getCache.json.html) ，来实时获取当前有哪些域名(或 key)在使用、翻译的字符数有多少、等等。
* **数据隐私**：接口请求、缓存数据等完全都在自己的服务器上，数据隐私无需担忧。
* **并发控制**：可自由定义每秒的[并发请求上限](https://translate.zvo.cn/413975.html)，以及调用大模型进行翻译时[请求线程池](https://translate.zvo.cn/391753.html)的线程上限，以极大缩减接口等待的耗时。另还可以通过管理接口实时获取当前请求线程池的并发数等

### 部署

#### 1. 服务器规格

* **CPU** ：1 核
* **架构** ：x86\_64 （也就是 Intel 的 CPU ）
* **内存** ：1G
* **操作系统** ：
  1. CentOS 7.4 (这个版本没有可选 7.6 、7.2 等，7.x 系列的都可以)
  2. openEulor 20 (如果没有 20 版本那就选 22 版本)
* **系统盘** ：默认的系统盘即可，无需数据盘
* **弹性公网 IP** ：按流量计费（带宽大小 10MB。如果是个人使用，翻译的量不大，完全可以选 1MB 带宽）
* **所在区域** : 选国内，这样请求硅基流动接口就会更快。

  其他没提到的，都按照便宜的来即可。

#### 2. 一键部署

执行以下 shell 命令进行一键部署：

```
yum -y install wget && wget https://raw.githubusercontent.com/xnx3/translate/refs/heads/master/deploy/service.sh -O ~/install.sh && chmod -R 777 ~/install.sh && sh ~/install.sh
```

#### 3. 获取 API 密钥

1. 进入 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 注册账号
2. 在控制台的左侧，找到 **账户管理** 下的 **API 密钥** ，点开，去新建一个即可。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=962312a9df51eb6935be27d5a6642af3" data-og-width="1195" width="1195" data-og-height="746" height="746" data-path="images/usercases/translate-js/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=04e36d5600a1c96b76a1de41a2bc2578 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=87ecea2022e62d6647f23af643313a1e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ca65c4f98db44eadc8072a9cc1960e71 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5001e7897f7dd7973356dd718e346515 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6fb25ece2319c653610d9af978cdcb9e 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=53f7e22c9661ca82e21d84a48675882c 2500w" />
</Frame>

#### 4. 配置 API 密钥

首先，找到配置文件 /mnt/service/config.properties 编辑它，找到

```
translate.service.leimingyun.domain=http://api.translate.zvo.cn
```

这个，将它注释掉（这个是默认体验的），然后增加以下配置：

```
# 这个url固定填写，无需改动
translate.service.openai.url=https://api.siliconflow.cn/v1/chat/completions
# 使用哪个大模型。比如你这里可以填写 Qwen/Qwen3-32B ， 具体模型可以通过 https://cloud.siliconflow.cn/models 获得
translate.service.openai.model=Qwen/Qwen3-32B
#  硅基流动的 API 密钥，你上一步获取到的，填到这里
translate.service.openai.key=sk-kqpnpfhlikgacrmdab2946d28eb00ede7acd9b3axfiIadf4P81
# 进行大模型API调用线程池的程数。不懂可设置100即可。此参数的具体说明可参考 http://translate.zvo.cn/396728.html
translate.service.thread.number=100
```

当然，还有更多的配置方式可以解锁更高的能力，这些刚部署初期你可以忽略，熟悉了可以研究：

* [翻译精准度效验及自动修复](https://translate.zvo.cn/411064.html)
* [配置多翻译通道支持的语种分流策略](https://translate.zvo.cn/426176.html)
* [配置翻译API接口的流量控制](https://translate.zvo.cn/413975.html)
* [配置备用翻译通道](https://translate.zvo.cn/404947.html)
* ...

#### 5. 重启项目

操作完毕后，重启 translate.service 服务，执行重启命令 :

```
/mnt/service/start.sh
```

#### 6. 访问测试

直接访问你的服务器 ip，即可看到效果：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0128421f1be0331c8362bdffc36be52b" data-og-width="341" width="341" data-og-height="185" height="185" data-path="images/usercases/translate-js/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=11f19bf6d0a349ebf5162440057187e9 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a57516d48050d8a2b173966f0dfe0782 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fb11b38c1035ede727c397e2d5a4398f 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eb09d28fd689ff655e887a40427a9863 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a1e30b5adadea0c08d01ab499ebe34e4 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=32f99cfd7fb79be0ab1ebcc26a067bae 2500w" />
</Frame>

随便选个语种切换一下试试，切换后“你好，世界”能被翻译，说明已接入成功，可以正常使用了。

### 使用

#### 文本翻译 API 接口

它以 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM)  平台的大模型算力作为基础支撑，通过 [translate.service](https://gitee.com/mail_osc/translate) 作为中间调度。
你完全不需要去了解 大模型 是什么以及怎么使用，给你暴露出标准的API翻译接口进行使用。

**请求 URL** ：[http://你的服务器 ip/translate.json](http://api.zvo.cn/translate/service/20230807/translate.json.html)
**请求方式** ：POST
**请求方式** ：POST
**请求参数** ：

* **to** 将文本翻译为什么语种。可传入如 english 更多语种可访问 [http://你服务器的 ip/language.json](http://api.zvo.cn/translate/service/20230807/language.json.html) 就能看到
* **text** 需要翻译的语言。格式如 `["你好","世界"]` 它是 json 数组格式，支持一次翻译多个不同的文本，每个文本可以分别是不同的语言。
  **响应示例** ：
  `{"result":1,"info":"success","to":"english","text":["Hello","World"]}`

注意，header 头的 Content-Type 要么不设置，如果设置的话值是 application/x-www-form-urlencoded

**curl 翻译示例：**

为了方便理解上面的 API 接口使用，这里给出了一个 curl 请求的示例，另外这个示例你也可以直接复制就能运行使用，看到效果

```
curl --request POST \
  --url https://siliconflow.zvo.cn/translate.json \
  --header 'content-type: application/x-www-form-urlencoded' \
  --data to=english \
  --data 'text=["你好，世界","让我们探索星辰大海"]'
```

它是开放的，你不需要再去买高额的文本翻译了，硅基流动给你提供免费的，翻译通顺度还更高！
[可点此查看有关文本翻译API接口的详细文档](http://api.zvo.cn/translate/service/20230807/translate.json.html)

#### 网页多语言切换

使用方式为，在网页最末尾，html 结束之前，加入以下代码，一般在页面的最底部就出现了选择语言的 select 切换标签，你可以点击切换语言试试切换效果

```
<script src="https://cdn.staticfile.net/translate.js/3.15.6/translate.min.js"></script>
<script>
translate.service.use('translate.service'); //设置采用私有部署的翻译通道，相关说明参考 https://translate.zvo.cn/4081.html
translate.request.api.host='http://121.121.121.121/'; //将这里面的ip地址换成你服务器的ip，注意开头，及结尾还有个 / 别拉下
translate.execute();//进行翻译 
</script>
```

如此，翻译请求接口就会走您自己服务器了。有关这个手动指定翻译接口的详细说明，可参考： [http://translate.zvo.cn/4068.html](https://gitee.com/link?target=http%3A%2F%2Ftranslate.zvo.cn%2F4068.html)

另外 translate.js 这个 js 文件你可以自己下载下来放到你自己项目里使用，它没有任何别的依赖，是标准的原生 JavaScript 。而且 translate.js 是完全开源的，你可以从 [https://raw.githubusercontent.com/xnx3/translate/refs/heads/master/translate.js/translate.js](https://gitee.com/link?target=https%3A%2F%2Fraw.githubusercontent.com%2Fxnx3%2Ftranslate%2Frefs%2Fheads%2Fmaster%2Ftranslate.js%2Ftranslate.js) 下载最新的 js，放到你项目里进行使用。

他的原理是直接扫描你网页的 dom 元素进行自动分析识别，然后将文本集中化进行翻译。也就是你要讲这个 translate.execute(); 这行要放在最底部，就是因为上面的渲染完了在执行它，可以直接触发整个页面的翻译。

### 日志查看

你可以从服务器中查看相关日志情况。
日志存放于 /mnt/service/logs/ 目录下

#### 文本翻译日志

openai\_yyyy-MM-dd.log 是硅基流动通过openai接口调用大模型进行文本翻译的日志

比如： `openai_2025-05-17.log`
yyyy-MM-dd 是当前的年月日，它按照日期每天都会创建一个日志文件。
它记录了你所有文本翻译的原文、译文、进行时间、翻译结果审查得分、是否启用了修复机制 等
它每行都是一个文本翻译记录。
示例：

```
{"time":"00:40:59","originalText":"按钮切换语言:","resultText":"Button switch language:","to":"english","useTime":583,"score":96}
{"time":"00:40:59","originalText":"语言切换示例：","resultText":"Language Switching Example:","to":"english","useTime":482,"score":96}
{"time":"00:40:59","originalText":"你好","resultText":"Hello","to":"english","useTime":546,"score":96}
```

* **time** 发生时间
* **originalText** 翻译的原文
* **resultText** 翻译的译文
* **to** 翻译为什么语种
* **score** 对译文进行校验后的打分。 1\~100 分，分数越高表示翻译越精准
* **useTime** 当前使用[SiliconFlow](https://cloud.siliconflow.cn/i/64MyJQtM)翻译的耗时，单位是毫秒

#### 系统运行日志

translate.service.log 是系统运行日志，它存放 translate.service 本身的运行情况的日志

#### 访问请求日志

request\_yyyy-MM-dd.log 是进行翻译请求（/translate.json）的请求日志。\
它并不是你访问后它就会立即产生日志，而是它有一个日志缓冲，比如当日志达到几百条、或者距离上次将其保存到日志文件超过 2 分钟，它才会进行将日志信息打包写入到日志文件中。
这里列出其中两条示例：

```
{"method":"translate.json","size":4,"ip":"192.168.31.95","domain":"192.168.31.95","memoryCacheHitsSize":5,"time":"2025-03-19 10:22:56","memoryCacheHitsNumber":1,"to":"english"}
{"fileCache":"1845bbcbd9e600fab184b346d82042a9_english.txt","method":"translate.json","size":4,"ip":"192.168.31.95","domain":"192.168.31.95","time":"2025-03-19 10:26:56","to":"english"}
```

* **method** 当前请求的是哪个接口。比如 translate.json 则是请求的文本翻译 API 接口； language.json 则是请求的获取当前所支持的语言列表接口
* **fileCache** 针对 translate.json 翻译接口的请求，如果有命中文件缓存，则有这个参数，其值是 文件缓存的名字，它是在 `/mnt/service/cache/` 内的
* **originalSize** 针对 translate.json 翻译接口的请求，记录当前翻译的字符数（原文的字符数，非译文）
* **size** 针对 translate.json 翻译接口的请求，记录当前翻译的字符数（译文的字符数，非原文）
* **ip** 请求来源的 ip
* **domain** 针对 translate.json 翻译接口的请求，如果是网站使用了 translate.js ，那这个则是这个网站的域名（它是自动获取到的）
* **time** 触发的时间
* **to** 针对 translate.json 翻译接口的请求，翻译为什么语种
* **key** 针对 translate.json 翻译接口的请求，如果是你给对方通过 domain.json 配置设置的文本翻译 key，那这个就是记录的 key。
* **memoryCacheHitsNumber** 针对 translate.json 翻译接口的请求，如果有命中内存缓存，这里是记录命中内存缓存的条数（translate.json 支持同时翻译多条）
* **memoryCacheHitsSize** 针对 translate.json 翻译接口的请求，如果有命中内存缓存，这里是记录命中内存缓存的字符数（译文的字符数，非原文）


# Tyrion
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-tyrion



[Tyrion.ai​](https://www.tyrion.ai) 一站式企业复合 AI 系统平台，融合生成式 AI、大语言模型智能体（Agent）与知识本体语义层打造统一的 AI 中枢，帮助大型企业实现跨业务的智能自动化与决策支持。平台低代码开发界面、基于大语言模型（LLM），支持快速构建 AI Agent，可视化工作流编排和智能知识库，打造高效协同的一体化产品矩阵。

本文将介绍如何在 Tyrion 中使用 SiliconFlow 提供的模型能力。

## 配置 SiliconFlow 模型

进入设置中的模型管理页面，点击 SiliconFlow 设置按钮，在编辑模型组窗口中点击**从 SiliconFlow 获取 API Key** 按钮，Tyrion 会打开相应配置页面，点击密钥复制并在 **API Key** 中粘贴，点击确认即可完成配置。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ffb4b113532a2ed887b75b713f654b65" data-og-width="1280" width="1280" data-og-height="716" height="716" data-path="images/usercases/tyrion/tyrion-1.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4ad8d61419422b1804e5bd54d438f776 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f8cc06c8c6c6ed3b6d328c41d263f0c3 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=70877f102f891e2a407229b914a606de 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6aa08dcfccc6ca4c76803869fbd1b1d5 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c2d6a938dbac85d80de931348407ac81 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c73d5a507047db2ba9325f3fca9317c9 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f788a73d18bac63c65a539e5180c67c1" data-og-width="1280" width="1280" data-og-height="400" height="400" data-path="images/usercases/tyrion/tyrion-2.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ba9f15e2a5c1899461416e6bb0a2e6af 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c6c6feeff50289045575ac6c3ab884e3 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=47274a4924d288af4a18054193b95967 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c0b6438983d92640e208d392e508b2f5 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8e4b88343b9e760f0c61647b06741ab7 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7c83bdfe83793d35c7324fa5a6a67352 2500w" />
</Frame>

## 在流程中使用 SiliconFlow 模型

在模型分组下拉框中选择 **SiliconFlow**，完成提示词的编写等配置后，便可以体验 SiliconFlow 提供的强大的模型能力。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=49ebff5189ad85d61b3fbe9c642f27e1" data-og-width="1280" width="1280" data-og-height="1038" height="1038" data-path="images/usercases/tyrion/tyrion-3.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f97e5abeaf7f872b4e9de509c25c8990 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5c4722b8d0253f3e38684ff1f1631695 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=25cdfd1bef82a67ba2d75ba50143bb7d 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c8e61bff29598a73131f516bdb7c3633 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b7967a2524cffd0abd10680adb80be7a 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f742ba679fc4865e5aed30abf609c78b 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c627342c94f0ce4c6b7ba2387588bdfa" data-og-width="943" width="943" data-og-height="1396" height="1396" data-path="images/usercases/tyrion/tyrion-4.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=aa5f38b6334934e56052b0eddcdc53d8 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d8b0e8463d7162708c2e4f400fadd7e9 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fc55577a4a73405d26fcd0b0c6449ed6 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dcc51e0624504b4e478876673551f8e7 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=683784c4ef68dfeee0c751093e2ca9c6 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=63d7c6a9aafa05687703fa99dae81b32 2500w" />
</Frame>


# 问道
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-wendao



## 1、关于问道

[问道](https://wendao.aihub.ren)是一个 AI 聊天平台，以“问道”为主题，预设道家人物角色（如老子、庄子等）作为交互对象。用户可通过对话形式与“道家先贤”互动，探索道家思想，兼具文化传播与智能交流功能。

平台对话服务基于 [硅基流动](https://cloud.siliconflow.cn/) API ，本文将介绍如何在网站中使用 **硅基流动** 提供的 API 服务。

## 2、获取 API 密钥

> 建议设置你自己的硅基流动API 密钥，将会优先调用。若不设置，将使用内置硅基流动密钥（使用人数多时，可能会有速率限制）。

1. 打开硅基流动 [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。

2. 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，点击 **新建 API 密钥**，点击密钥进行复制，以备后续使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b88fdf88029711f916e86d28b4a92e8e" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e695a8a4ea3742970e0e74b739b7dcdf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=97cc395b409103fdb5147421cb2dc918 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fc6111929459b0a38295cd2ec04ac7e9 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=92e04b3dc62c709e50893f24a05aaf6b 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=18408c7d958cdf46e942c7168afd1ed8 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bd579e14109ee4c95384579922e384be 2500w" />
</Frame>

## 3、在平台使用

1、[问道](https://wendao.aihub.ren) 首页选择任一人物卡片，进入对话框后点击右上角 **太极八卦图标**，打开 **设置框**，API Key 处填入刚刚复制的 API 密钥。API 地址和模型名称、温度也可根据需求自定义。设置完成后，点击 **保存设置** 生效。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3e586c89dd0f575ac734e01ba07ea3dd" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=26c62d549a4742bb96326f99a3d328bf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=700176f091d018eb9750a995fbf19567 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4371f7b662d68039eb40bcf346b37ef6 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a37252b5283a046d4bf8f5df1e4b4990 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c7b4589a152a1220dd878a3656f53604 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=84bac4bbefa3428a7c9975062770c6a5 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4c5e79f9269c153a693dae6ed7fea031" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1688e762e69e5d6cc674ee7280bd2058 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c111fcfa11b61e89be4303b35b698c17 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d5b022ad7caf89b1cd1f357bc5dde66d 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8de3954fcade1c9ac3418853d2676ca9 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c81f527f88ea1205b51a3b83c2e10af7 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=97f643cdb3e19e58c37395c5050ba788 2500w" />
</Frame>

2、在老子、庄子独立页面使用：点击首页“太上”、“逍遥”进入对应页面，点击对话框右上角 “**枢**” 字按钮弹出设置，在设置框中填入 API 密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=35f3a290c06156c856f245fc6d1d7ad9" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=20adb8d833c7b0356aa6f356c273eae4 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eaaa6756da7ff57ecc90360156d12dd4 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=968410d22bf1530556321837df58f40b 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=051ea845f27ebd065a22dcdaf1c58ed4 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=48d7e6863524d2d7f86436cb30459d74 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=50e1ef10a466c7c65a333aefe8944b4c 2500w" />
</Frame>

3、完成配置后，直接在对话框进行对话使用即可。更多页面功能可自行探索。


# wiseflow AI 首席情报官
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-wiseflow



## 关于 wiseflow

[wiseflow](https://github.com/TeamWiseFlow/wiseflow/)（中文名：AI 首席情报官）是一款利用大模型帮用户每日从海量信息、各类信源中挖掘真正感兴趣信息的开源应用。

与 ChatGPT、Manus 等 **'deep search'** 类应用不同，wiseflow 定位于 **'wide search'**，特别适合行业情报、客户信息、招投标信息、竞对动态、舆情监控以及知识情报等需要信息“广度”收集的场景。而相对于传统的 RPA 类爬虫，项目又支持免手工提取 xpath 的“开箱即用"模式，并使用大模型对每条信息严格根据用户设定的关注点进行分析、过滤和总结。

wiseflow 刚刚发布了全新的 4.0 版本，在已有的普通网页、rss 和搜索引擎信源基础上，增加提供了对微博和快手平台的支持，4.x 后续版本还将陆续提供对微信公众号平台、抖音、小红书、b 站以及知乎平台的支持。4.0 版本还对程序架构进行了比较大的重构，运行起来更加稳定、更加快速，同时对内存更加友好。

## 使用方法

**wiseflow 自 3.1 版本开始一直推荐使用 SiliconFlow 提供的 llm 服务，4.0 版本对比 3.x 进一步简化了操作步骤，只需三步即可开始使用！**

<Note> 温馨提示：windows 用户请提前下载 git bash 工具，并在 bash 中执行如下命令 [bash下载链接](https://git-scm.com/downloads/win) </Note>

### 下载项目源代码并安装 uv 和 pocketbase

```Plain  theme={null}
curl -LsSf https://astral.sh/uv/install.sh | sh
git clone https://github.com/TeamWiseFlow/wiseflow.git
```

上述操作会完成 uv 的安装。

接下来去 [pocketbase docs](https://pocketbase.io/docs/) 下载对应自己系统的 pocketbase 程序并放置于 wiseflow/pb 文件夹下。

注意，使用 MacOS 的小伙伴需要在这一步完成后，去到 wiseflow/pb 文件夹执行一次：

```
xattr -d com.apple.quarantine pocketbase
```

### 参考 env\_sample 配置 .env 文件

先在 wiseflow 文件夹（项目根目录）参考 env\_sample 创建 .env 文件，并填入相关设定信息。

**接下来就要轮到 SiliconFlow 登场了！**

* 进入 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）；
* 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key；
* 点击密钥进行复制，然后填入上一步创建的 .env 文件的 LLM\_API\_KEY 中，同时将 LLM\_API\_BASE 设置为 [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)

.env 文件最终可以参考如下：

```Python  theme={null}
LLM_API_KEY=你的 API KEY 
LLM_API_BASE=https://api.siliconflow.cn/v1 # LLM 服务接口地址
PRIMARY_MODEL=Qwen/Qwen3-14B # 推荐 Qwen3-14B 或同量级思考模型
VL_MODEL=Pro/Qwen/Qwen2.5-VL-7B-Instruct
```

对于 wiseflow 这种“广度信息搜集”任务，Qwen3-14B 模型已经可以实现不错的效果，VL\_MODEL 只是辅助作用。Qwen2.5-VL-7B-Instruct 也可以满足要求，wiseflow 也特别针对小尺寸模型做了优化，当然如果你的关注点涉及大量约束限制条件以及专有名词，也可以选择尺寸更大的 Qwen3-32B 模型。

有关 .env 其他项目的说明可以参考 wiseflow 的 [docs/manual/manual.md](https://github.com/TeamWiseFlow/wiseflow/blob/master/docs/manual/manual.md)

### 起飞！

接下来只需要依次执行如下命令即可

```Bash  theme={null}
cd wiseflow
uv venv # 仅第一次执行需要
source .venv/bin/activate  # Linux/macOS# 
#或者在 Windows 上：
# .venv\Scripts\activate
uv sync # 仅第一次执行需要
python -m playwright install --with-deps chromium # 仅第一次执行需要
chmod +x run.sh # 仅第一次执行需要
./run.sh
```

项目会自动拉起浏览器，引导你注册并进入使用界面。


# Zadig
Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-zadig



[Zadig ](https://www.koderover.com/)是由 KodeRover 公司基于 Kubernetes 研发的自助式云原生 DevOps 平台，源码 100% 开放。Zadig 提供灵活可扩展的工作流支持、多种发布策略编排以及一键安全审核等特性。该平台还支持定制的企业级 XOps 敏捷效能看板，深度集成多种企业级平台，并通过项目模板化批量快速接入，实现数千个服务的一键纳管治理。其主要目标是帮助企业实现产研的数字化转型，使工程师成为创新引擎，并为数字经济的无限价值链接提供支持。

本文主要介绍如何借助 SiliconFlow 提供的 DeepSeek 模型在 Zadig 上进行 AI 环境巡检和 AI 效能巡检。

## 安装 Zadig

* [基于主机快速试用](https://docs.koderover.com/zadig/install/all-in-one/)
* [基于 k8s 正式运维](https://docs.koderover.com/zadig/install/helm-deploy/)

## 获取 API Key

* 打开 [SiliconFlow 官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
* 完成注册后，打开[ API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 配置 SiliconFlow 模型

在 Zadig 上，访问 `系统设置` -> `系统集成` -> `AI 服务` ，添加 AI 服务。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a46ca8e8339a10d813c1aee891d1e41a" data-og-width="1280" width="1280" data-og-height="645" height="645" data-path="images/usercases/zadig/zadig-1.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9bc43456d8e54e40f570db740961c8f7 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ee195a7a17615b4dee0e81876bd46db1 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c08b9a902df74d0cac4b065562e9b851 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8435b92274df49394369508bb9cfcb65 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4fb38ca697678447808c1f9bbf00347d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-1.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=18e4f840f10850469c6603056a9abaa0 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3b6a995e104cf3140dc938b17ab3e2dc" data-og-width="1280" width="1280" data-og-height="645" height="645" data-path="images/usercases/zadig/zadig-2.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bf3141550fb685733c331b0ba03cdc3c 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e69674d32c74b7bb2f2cc7cc07c5e52a 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2a3da71da1eeac57ac2ce3e0c50009eb 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fe6da8b2bb6cd74ea4147b8b5d9428d8 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a011ab981baa9ebbc46b591649959dcb 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-2.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a7c0b95ebc45d7c9065342e1bc67edd7 2500w" />
</Frame>

1. 提供商：选择 SiliconFlow
2. 模型名称：输入 SiliconFlow 上提供的模型
3. 访问地址：[https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
4. API Key：上一步中获取的 API Key

## 模型服务使用

### AI 环境巡检

通过 AI 能力全面的分析 和识别 K8s 环境中的问题，比如 Pod 异常、配置错误，并且可以给出解决方案，配置上定时器和 IM 通知，实现定时巡检，及时将问题和解法发送给对应的负责人。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fcb05e75ec15ae9951d0d05ea68bdb93" data-og-width="1280" width="1280" data-og-height="1212" height="1212" data-path="images/usercases/zadig/zadig-3.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d3403755aad0d8ee9f7ecf6b51851dc5 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a55b785db1412201ae01a2409462da4e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ce6dffd689cc601108a1d66e00a5b2a2 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ec0bb8e856ae7e52c390144b04435e19 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6b3599ba4110bab1cab7f1305d63aba5 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-3.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9eaaedbbdbb0941864832a77e99831ce 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=baaf5ac1bcf3b2761c9aa7b06d317971" data-og-width="1280" width="1280" data-og-height="954" height="954" data-path="images/usercases/zadig/zadig-4.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=208ef714788c612b33db5f4210a6df12 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=65f409e5a4807492393d133aa3de2638 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=cec5ed2901495fcd80beed5a7a8e2169 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0a89f198532c0ac3c6e2ee10d029feef 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=69f6aa6c2abe559c71b4ae764cd9a002 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-4.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=688fb8d3e4e42d43e259ae5560d2b998 2500w" />
</Frame>

### AI 效能洞察

基于 Zadig 上产生的效能数据，AI 辅助分析，可以比较精准的定位项目效能问题，并且给出一定的改进建议，和传统方式相比，传统可能需要手动分析大量数据，而 AI 能在较短的时间内自动生成报告。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=112cbda4cca19965387227db542f1ab8" data-og-width="1280" width="1280" data-og-height="900" height="900" data-path="images/usercases/zadig/zadig-5.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=80220d4bf6c3d9af56787c5e537ea335 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=90fe610605af962f27c426141fb85a2f 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=265b6df9711eb61f611ed4d2e4f04562 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0f8da3bfda7626c0c60077f373e8248c 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=172c5f897ea9893e7d0c1ff7c4c97cfb 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-5.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7b5d2ac096a9c80b1ec879f132edb4db 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=37cd885a77a1ea35bc85a0bad8fecaed" data-og-width="1280" width="1280" data-og-height="900" height="900" data-path="images/usercases/zadig/zadig-6.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ded52699c7745304a8144b7f92ff881b 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bed5acf5f92e7c7aa6ab465dd58d0739 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=65572f5071893f09ec65f3e7ecb7dcc5 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=451fd649e655f425fc50f00e3bdd4500 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d0ba5842fd3970458566c8863085887c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-6.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7b9b0574f6f869ba1509caa4ddecb5df 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=57991a0c08af92aa5acf1bd0f1064644" data-og-width="1280" width="1280" data-og-height="645" height="645" data-path="images/usercases/zadig/zadig-7.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c9859c19255d8e68520d89f22d2600ab 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=800986bc78533767d71fa59be8758950 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=326fffed2e6cdaf3622b07a8609cc02b 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6c9ecf6de1ee711a9eca7f0bc0bb5c9b 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5e867c147ce04a8b2d66f7957bdfa2a3 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/zadig/zadig-7.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=cc5631a6d31a3a423691d5b1919d7daa 2500w" />
</Frame>


# 生图模型
Source: https://docs.siliconflow.cn/cn/userguide/capabilities/images



## 1.生图模型简介

平台提供的生图模型主要有以下两种使用方式：一种是根据prompt输入直接生成图像；一种是根据现有图像，加上prompt输入，生成图像变体。

* **根据文本提示创建图像**

  在使用文生图的大模型时，为了生成更高质量的图像，输入的prompt（提示词）需要精心设计。以下是一些有助于提高生成图像质量的提示词输入技巧：

  * **具体描述**：尽量详细地描述你想要生成的图像内容。比如，如果你想生成一幅日落的海滩风景，不要仅仅输入“海滩日落”，而是可以尝试输入“一个宁静的海滩上，夕阳西下，天空呈现出橙红色，海浪轻轻拍打着沙滩，远处有一艘小船”。

  * **情感和氛围**：除了描述图像的内容，还可以加入对情感或氛围的描述，比如“温馨的”、“神秘的”、“充满活力的”等，这样可以帮助模型更好地理解你想要的风格。

  * **风格指定**：如果你有特定的艺术风格偏好，比如“印象派”、“超现实主义”等，可以在prompt中明确指出，这样生成的图像更有可能符合你的期待。

  * **避免模糊不清的词汇**：尽量避免使用过于抽象或模糊不清的词汇，比如“美”、“好”等，这些词汇对于模型来说难以具体化，可能会导致生成的图像与预期相差较大。

  * **使用否定词**：如果你不希望图像中出现某些元素，可以使用否定词来排除。例如，“生成一幅海滩日落的图片，但不要有船”。

  * **分步骤输入**：对于复杂场景，可以尝试分步骤输入提示词，先生成基础图像，再根据需要调整或添加细节。

  * **尝试不同的描述方式**：有时候，即使描述的是同一个场景，不同的描述方式也会得到不同的结果。可以尝试从不同的角度或使用不同的词汇来描述，看看哪种方式能得到更满意的结果。

  * **利用模型的特定功能**：一些模型可能提供了特定的功能或参数调整选项，比如调整生成图像的分辨率、风格强度等，合理利用这些功能也可以帮助提高生成图像的质量。

通过上述方法，可以有效地提高使用文生图大模型时生成图像的质量。不过，由于不同的模型可能有不同的特点和偏好，实际操作中可能还需要根据具体模型的特性和反馈进行适当的调整。

可以参考如下示例：

> A futuristic eco-friendly skyscraper in central Tokyo. The building incorporates lush vertical gardens on every floor, with cascading plants and trees lining glass terraces. Solar panels and wind turbines are integrated into the structure's design, reflecting a sustainable future. The Tokyo Tower is visible in the background, contrasting the modern eco-architecture with traditional city landmarks.

> An elegant snow leopard perched on a cliff in the Himalayan mountains, surrounded by swirling snow. The animal’s fur is intricately detailed with distinctive patterns and a thick winter coat. The scene captures the majesty and isolation of the leopard's habitat, with mist and mountain peaks fading into the background.

* **根据现有图像，生成图像变体**

有部分生图模型支持通过已有图像生成图像变体，这种情况下，仍然需要输入适当的prompt，才能达到预期的效果，具体prompt输入，可以参考上面内容。

## 2.体验地址

可以通过 [图像生成](https://cloud.siliconflow.cn/playground/image) 体验生图的功能，也可以通过 [API文档](https://docs.siliconflow.cn/api-reference/images/images-generations) 介绍，通过API进行调用。

* OpenAI 调用方式如下

```python  theme={null}
from openai import OpenAI

client = OpenAI(api_key="Your-api_key", base_url="https://api.siliconflow.cn/v1")

response = client.images.generate(
    model="Kwai-Kolors/Kolors",
    prompt="a cat",
    size="1024x1024",
    n=1,
    extra_body={
        "step": 20
    }
)

print(response)
```

* **重点参数介绍**

  * **image\_size**：控制参数的图像分辨率，API请求时候，可以自定义多种分辨率。

  * **num\_inference\_steps**：控制图像生成的步长。

  * **batch\_size**：一次生成图像的个数，默认值是1，最大值可以设置为4

  * **negative\_prompt**：这里可以输入图像中不想出现的某些元素，消除一些影响影响因素。

  * **seed**：如果想要每次都生成固定的图片，可以把seed设置为固定值。

## 3.支持模型列表

目前已支持的生图模型，可以通过[模型广场](https://cloud.siliconflow.cn/sft-siliconflow/models?types=to-image)查看。

<Note>注意：支持的生图模型可能发生调整，请在「模型广场」筛选“生图”标签，了解支持的模型列表。</Note>


# 多模态模型（视觉/音频/视频）
Source: https://docs.siliconflow.cn/cn/userguide/capabilities/multimodal-vision



## 1. 概述

多模态模型是能够同时处理多种模态信息（文本、图像、音频、视频）的大语言模型。SiliconFlow 提供了多个支持不同模态组合的强大模型，能够：

1. **视觉理解**：理解图片内容、OCR、图像描述
2. **视频分析**：提取视频帧、理解视频内容、动作识别
3. **音频处理**：语音识别、音频内容分析
4. **多模态融合**：同时处理多种媒体类型的综合分析

## 2. 支持模型概览

| 模型系列               | 视觉输入 | 音频输入 | 视频输入 | 主要特点            |
| ------------------ | ---- | ---- | ---- | --------------- |
| **Qwen3-Omni 系列**  | ✅    | ✅    | ✅    | 全面多模态支持，音视频同时处理 |
| **Qwen3-VL 系列**    | ✅    | ❌    | ✅    | 视觉+视频理解，无音频支持   |
| **GLM 系列**         | ✅    | ❌    | ❌    | 仅视觉理解           |
| **Qwen2-VL 系列**    | ✅    | ❌    | ❌    | 仅视觉理解           |
| **DeepseekVL2 系列** | ✅    | ❌    | ❌    | 仅视觉理解           |
| **Step3**          | ✅    | ❌    | ❌    | 仅视觉理解           |
| **DeepSeek-OCR**   | ✅    | ❌    | ❌    | 仅视觉理解，支持pdf输入   |

<Note>
  通过[模型广场](https://cloud.siliconflow.cn/me/models?tags=%E8%A7%86%E8%A7%89)查看当前支持的多模态模型列表。
  支持的模型可能发生调整，请以平台实际展示为准。
</Note>

## 3. 使用方式

所有多模态模型都通过 `/chat/completions` 接口调用，使用标准化的 `messages` 格式，其中 `content` 可以包含不同类型的内容部分。

### 3.1 基本消息格式

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "text" | "image_url" | "audio_url" | "video_url",
            "[type]_url": {
                // 对应类型的配置
            }
        }
    ]
}
```

### 3.2 通用参数说明

#### 图像参数 (`image_url`)

* `url`: 图像 URL 或 base64 编码数据，DeepSeek-OCR 还支持 PDF URL 或 base64 编码数据
* `detail`: 细节级别 (`auto`, `low`, `high`)

#### 视频参数 (`video_url`)

* `url`: 视频 URL 或 base64 编码数据
* `detail`: 细节级别 (`auto`, `low`, `high`)
* `max_frames`: 最大提取帧数
* `fps`: 每秒提取帧数，最终帧数为 `min(fps × T, max_frames)`

#### 音频参数 (`audio_url`)

* `url`: 音频 URL 或 base64 编码数据

## 4. 使用示例

### 4.1 视觉理解

#### 图像分析

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "image_url",
            "image_url": {
                "url": "https://example.com/image.jpg",
                "detail": "high"
            }
        },
        {
            "type": "text",
            "text": "描述这张图片的内容"
        }
    ]
}
```

#### 多图对比

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "image_url",
            "image_url": {"url": "https://example.com/image1.jpg"}
        },
        {
            "type": "image_url",
            "image_url": {"url": "https://example.com/image2.jpg"}
        },
        {
            "type": "text",
            "text": "比较这两张图片的相同点和不同点"
        }
    ]
}
```

#### PDF OCR

DeepSeek-OCR 还支持 PDF URL 或 base64 编码数据。

DeepSeek-OCR 支持多种场景的提示词：

```
- 文档转Markdown：<image>\n<|grounding|>Convert the document to markdown.
- 通用OCR：<image>\n<|grounding|>OCR this image.
- 无布局提取：<image>\nFree OCR.
- 图表解析：<image>\nParse the figure.
- 图像描述：<image>\nDescribe this image in detail.
- 文本定位：<image>\nLocate <|ref|>特定文字<|/ref|> in the image.
```

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "image_url",
            "image_url": { 
                "url": "data:application/pdf;base64," + base64.b64encode(
                            open("xxx.pdf", "rb").read()).decode("utf-8")
                            }
        },
        {
            "type": "text",
            "text": "<image>\n<|grounding|>Convert the document to markdown. "
        }
    ]
}
```

### 4.2 视频理解

#### 基础视频分析

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "video_url",
            "video_url": {
                "url": "https://example.com/video.mp4",
                "detail": "high",
                "max_frames": 16,
                "fps": 1
            }
        },
        {
            "type": "text",
            "text": "总结这个视频的主要内容"
        }
    ]
}
```

#### 多模态分析（视频 + 图片）

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "video_url",
            "video_url": {
                "url": "https://example.com/video.mp4",
                "detail": "high",
                "max_frames": 16,
                "fps": 1
            }
        },
        {
            "type": "image_url",
            "image_url": {"url": "https://example.com/thumbnail.jpg"}
        },
        {
            "type": "text",
            "text": "基于视频和缩略图，分析这个视频的主题和受众群体"
        }
    ]
}
```

### 4.3 音频理解

#### 音频内容分析

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "audio_url",
            "audio_url": {
                "url": "https://example.com/audio.mp3"
            }
        },
        {
            "type": "text",
            "text": "转录这个音频的内容"
        }
    ]
}
```

### 4.4 全模态分析

#### 音视频综合分析

```json  theme={null}
{
    "role": "user",
    "content": [
        {
            "type": "video_url",
            "video_url": {
                "url": "https://example.com/video.mp4",
                "detail": "high",
                "max_frames": 16,
                "fps": 1
            }
        },
        {
            "type": "audio_url",
            "audio_url": {
                "url": "https://example.com/audio.mp3"
            }
        },
        {
            "type": "text",
            "text": "对比分析视频画面和音频内容，找出它们之间的联系"
        }
    ]
}
```

## 5. Python SDK 使用示例

### 5.1 视觉识别

```python  theme={null}
from openai import OpenAI

client = OpenAI(
    api_key="your-api-key",
    base_url="https://api.siliconflow.cn/v1"
)

response = client.chat.completions.create(
    model="Qwen/Qwen2.5-VL-72B-Instruct",
    messages=[
        {
            "role": "user",
            "content": [
                {
                    "type": "image_url",
                    "image_url": {
                        "url": "https://example.com/tech-conference.jpg"
                    }
                },
                {
                    "type": "text",
                    "text": "这张图片显示的是什么样的科技会议？分析参会者的表情和氛围"
                }
            ]
        }
    ]
)

print(response.choices[0].message.content)
```

### 5.2 视频分析

```python  theme={null}
response = client.chat.completions.create(
    model="Qwen/Qwen3-Omni-30B-A3B-Instruct",
    messages=[
        {
            "role": "user",
            "content": [
                {
                    "type": "video_url",
                    "video_url": {
                        "url": "https://example.com/product-demo.mp4",
                        "detail": "high",
                        "max_frames": 16,
                        "fps": 1
                    }
                },
                {
                    "type": "text",
                    "text": "这个产品演示视频展示了哪些核心功能？目标用户群体可能是什么？"
                }
            ]
        }
    ],
    stream=True
)

# 流式输出
for chunk in response:
    content = chunk.choices[0].delta.content
    if content:
        print(content, end='', flush=True)
```

### 5.3 音频理解

```python  theme={null}
response = client.chat.completions.create(
    model="Qwen/Qwen3-Omni-30B-A3B-Instruct",
    messages=[
        {
            "role": "user",
            "content": [
                {
                    "type": "audio_url",
                    "audio_url": {
                        "url": "data:audio/wav;base64,UklGRnoGAABXQVZFZm10IBAAAAABAAEA..."
                    }
                },
                {
                    "type": "text",
                    "text": "这段音频的主要内容和情感基调是什么？"
                }
            ]
        }
    ]
)
```

## 6. 计费说明

### 6.1 视觉输入计费

不同模型的视觉内容转换方式不同。下表对比展示核心规则与计费口径：

| 模型系列           | 尺寸/像素约束                                              | detail=low                | detail=high                               | Token 计算方式                           |
| -------------- | ---------------------------------------------------- | ------------------------- | ----------------------------------------- | ------------------------------------ |
| Qwen 系列        | 最小 `56×56`，最大 `3584×3584`；按 `28` 的倍数取整到区间            | 统一 `448×448`，≈`256 token` | 长宽先上取整到 `28` 的倍数，再等比裁剪到区间                 | `ceil(h/28) * ceil(w/28)`            |
| DeepseekVL2 系列 | 以 `384×384` 为基块；`1 ≤ h*w ≤ 9` 的 `(h,w)` 块数           | 统一 `384×384`，`421 token`  | 按 `(h*384, w*384)` 放缩，选择有效像素最大且无效像素更小的组合  | `(h*w + 1) * 196 + (w + 1) * 14 + 1` |
| GLM 系列         | 最小 `28×28`；按 `28` 的倍数取整到区间；若小于 `112×112` 或超出上限则回压到区间 | 统一 `448×448`，≈`256 token` | 长宽取最近 `28` 倍数并限制在 `(12544, 4816894)` 像素区间 | `(h/28) * (w/28)`                    |

说明：

* `h,w` 为最终用于计费的像素尺寸；表中 token 为视觉输入侧的估算，实际账单以请求时的最终转换结果为准。

### 6.2 视频输入计费

视频内容根据提取的帧数转换为 tokens：

* 最终帧数 = `min(fps × 视频时长, max_frames)`
* 每帧图像按对应视觉模型的标准转换

### 6.3 音频输入计费

音频内容转换为 tokens 进行计费，对于 Qwen3 omni 多模态模型，输入音频每秒对应 13 个 token，  如 22.5s 音频对应 292 个 token。

## 7. 最佳实践

### 7.1 性能优化

1. **视频时长控制**：建议 30 秒内以获得最佳分析效果
2. **帧数选择**：`max_frames=8-16`，`fps=1-2` 通常足够
3. **图像尺寸**：根据模型推荐尺寸进行预处理

### 7.2 使用建议

1. **逐步分析**：复杂任务分解为多个简单步骤
2. **多模态组合**：充分利用不同类型媒体的优势
3. **错误处理**：检查媒体文件可访问性和格式兼容性

### 7.3 常见问题

**Q: 文件大小限制？**
A: 建议音频视频文件保持适中大小，超大文件可能影响性能

**Q: 可以同时处理多少个媒体文件？**
A: 可以在同一请求中包含多个媒体 URL，但建议控制总体数据量

**Q: 帧提取策略？**
A: 对于长视频，合理设置`fps`和`max_frames`参数以获得最优的分析效果和成本平衡


# 推理模型
Source: https://docs.siliconflow.cn/cn/userguide/capabilities/reasoning



## 1. 概述

推理模型是基于深度学习的AI系统，通过逻辑推演、知识关联和上下文分析解决复杂任务，典型应用包括数学解题、代码生成、逻辑判断和多步推理场景。这类模型通常具备以下特性：

* 结构化思维：采用思维链（Chain-of-Thought）等技术分解复杂问题
* 知识融合：整合领域知识库与常识推理能力
* 自修正机制：通过验证反馈回路提升结果可靠性
* 多模态处理：部分先进模型支持文本/代码/公式混合输入

## 2. 平台支持推理模型

平台支持的推理模型，可以通过[模型广场](https://cloud.siliconflow.cn/sft-siliconflow/models?tags=%E6%8E%A8%E7%90%86%E6%A8%A1%E5%9E%8B)查询。

## 3. 使用建议

### 3.1 API 参数

#### 3.1.1 请求参数

* **请求参数**：

  * **最大思维链长度（thinking\_budget）**：模型用于内部推理的 token 数，合理设置 thinking\_budget ，可以控制回答的思维链长度。

  * **最大回复长度（max\_tokens**）：用于限制模型最终输出给用户的回复 token 数，控制回复的最大长度。

**最大上下文长度（context\_length）**：非请求参数，不需要用户自己设置。不同模型支持的最大上下文长度可通过[模型广场](https://cloud.siliconflow.cn/sft-siliconflow/models)页面进行查看。

推理模型思维链输出行为将遵循以下规则：

* 若“思考阶段”生成的 `token` 数达到 `thinking_budget`，因 `Qwen3` 系列推理模型原生支持该参数模型将强制停止思维链推理，其他推理模型有可能会继续输出思考内容。
* 若最大回复长度超过 `max_tokens`或上下文长度超过`context_length` 限制，回复内容将进行截断，响应中的 `finish_reason` 字段将标记为 `length`，表示因长度限制终止输出。

#### 3.1.2 返回参数

* **返回参数**:
  * reasoning\_content：思维链内容，与 content 同级。
  * content：最终回答内容

### 3.2 DeepSeek-R1 使用建议

* 将 temperature 设置在 0.5-0.7 范围内（推荐值为 0.6），以防止无限循环或不连贯的输出。

* 将 top\_p 的值设置在 0.95。

* 避免添加系统提示,所有指令应包含在用户提示中。

* 对于数学问题，建议在提示中包含一个指令，例如：“请逐步推理，并将最终答案写在 \boxed{} 中。”

* 在评估模型性能时，建议进行多次测试并平均结果。

## 4. OpenAI 请求示例

### 4.1 流式输出请求

```python  theme={null}
from openai import OpenAI

url = 'https://api.siliconflow.cn/v1/'
api_key = 'your api_key'

client = OpenAI(
    base_url=url,
    api_key=api_key
)

# 发送带有流式输出的请求
content = ""
reasoning_content=""
messages = [
    {"role": "user", "content": "奥运会的传奇名将有哪些？"}
]
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=True,  # 启用流式输出
    max_tokens=4096,
    extra_body={
        "thinking_budget": 1024
    }
)
# 逐步接收并处理响应
for chunk in response:
    if chunk.choices[0].delta.content:
        content += chunk.choices[0].delta.content
    if chunk.choices[0].delta.reasoning_content:
        reasoning_content += chunk.choices[0].delta.reasoning_content

# Round 2
messages.append({"role": "assistant", "content": content})
messages.append({'role': 'user', 'content': "继续"})
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=True
)
```

### 4.2 非流式输出请求

```python  theme={null}
from openai import OpenAI
url = 'https://api.siliconflow.cn/v1/'
api_key = 'your api_key'

client = OpenAI(
    base_url=url,
    api_key=api_key
)

# 发送非流式输出的请求
messages = [
    {"role": "user", "content": "奥运会的传奇名将有哪些？"}
]
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=False, 
    max_tokens=4096,
    extra_body={
        "thinking_budget": 1024
    }
)
content = response.choices[0].message.content
reasoning_content = response.choices[0].message.reasoning_content

# Round 2
messages.append({"role": "assistant", "content": content})
messages.append({'role': 'user', 'content': "继续"})
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=False
)
```

## 5. 注意事项

* API 密钥：请确保使用正确的 API 密钥进行身份验证。
* 流式输出：流式输出适用于需要逐步接收响应的场景，而非流式输出则适用于一次性获取完整响应的场景。

## 6. 常见问题

* 如何获取 API 密钥？

  请访问 [SiliconFlow](https://cloud.siliconflow.cn/) 注册并获取 API 密钥。
* 如何处理超长文本？

  可以通过调整 max\_tokens 参数来控制输出的长度，但请注意最大长度为 16K。


# 语言模型
Source: https://docs.siliconflow.cn/cn/userguide/capabilities/text-generation



语言模型（LLM）使用说明手册

## 1. 模型核心能力

### 1.1 基础功能

文本生成：根据上下文生成连贯的自然语言文本，支持多种文体和风格。

语义理解：深入解析用户意图，支持多轮对话管理，确保对话的连贯性和准确性。

知识问答：覆盖广泛的知识领域，包括科学、技术、文化、历史等，提供准确的知识解答。

代码辅助：支持多种主流编程语言（如Python、Java、C++等）的代码生成、解释和调试。

### 1.2 进阶能力

长文本处理：支持4k至64k tokens的上下文窗口，适用于长篇文档生成和复杂对话场景。

指令跟随：精确理解复杂任务指令，如“用Markdown表格对比A/B方案”。

风格控制：通过系统提示词调整输出风格，支持学术、口语、诗歌等多种风格。

多模态支持：除了文本生成，还支持图像描述、语音转文字等多模态任务。

## 2. 接口调用规范

### 2.1 基础请求结构

您可以通过 openai sdk进行端到端接口请求

<AccordionGroup>
  <Accordion title="生成对话（点击查看详情）">
    ```python  theme={null}
        from openai import OpenAI  
        client = OpenAI(api_key="YOUR_KEY", base_url="https://api.siliconflow.cn/v1")  

        response = client.chat.completions.create(  
            model="deepseek-ai/DeepSeek-V3",  
            messages=[  
                {"role": "system", "content": "You are a helpful assistant."},  
                {"role": "user", "content": "Write a haiku about recursion in programming."}  
            ],  
            temperature=0.7,  
            max_tokens=1024,
            stream=True
        )  
        # 逐步接收并处理响应
        for chunk in response:
            if not chunk.choices:
                continue
            if chunk.choices[0].delta.content:
                print(chunk.choices[0].delta.content, end="", flush=True)
            if chunk.choices[0].delta.reasoning_content:
                print(chunk.choices[0].delta.reasoning_content, end="", flush=True)

    ```
  </Accordion>

  <Accordion title="分析一幅图像（点击查看详情）">
    ```python  theme={null}
    from openai import OpenAI

    client = OpenAI(api_key="YOUR_KEY", base_url="https://api.siliconflow.cn/v1")

    response = client.chat.completions.create(
        model="deepseek-ai/deepseek-vl2",
        messages=[
            {
                "role": "user",
                 "content": [
                        {
                            "type": "image_url",
                            "image_url": {
                                "url": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/outputs/658c7434-ec12-49cc-90e6-fe22ccccaf62_00001_.png",
                            },
                        },
                         {
                             "type": "text",
                             "text": "What's in this image?"
                         }
                    ],
            }
        ],
        temperature=0.7,
        max_tokens=1024,
        stream=True
    )
    # 逐步接收并处理响应
    for chunk in response:
        if not chunk.choices:
            continue
        if chunk.choices[0].delta.content:
            print(chunk.choices[0].delta.content, end="", flush=True)
        if chunk.choices[0].delta.reasoning_content:
            print(chunk.choices[0].delta.reasoning_content, end="", flush=True)
    ```
  </Accordion>

  <Accordion title="生成json数据（点击查看详情）">
    ```python  theme={null}
    import json  
    from openai import OpenAI

    client = OpenAI(
        api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
        base_url="https://api.siliconflow.cn/v1"
    )

    response = client.chat.completions.create(
            model="deepseek-ai/DeepSeek-V2.5",
            messages=[
                {"role": "system", "content": "You are a helpful assistant designed to output JSON."},
                {"role": "user", "content": "? 2020 年世界奥运会乒乓球男子和女子单打冠军分别是谁? "
                 "Please respond in the format {\"男子冠军\": ..., \"女子冠军\": ...}"}
            ],
            response_format={"type": "json_object"}
        )

    print(response.choices[0].message.content)
    ```
  </Accordion>
</AccordionGroup>

### 2.2 消息体结构说明

| 消息类型      | 功能描述                            | 示例内容               |
| --------- | ------------------------------- | ------------------ |
| system    | 模型指令，设定AI角色，描述模型应一般如何行为和响应      | 例如："你是有10年经验的儿科医生" |
| user      | 用户输入，将最终用户的消息传递给模型              | 例如："幼儿持续低烧应如何处理？"  |
| assistant | 模型生成的历史回复，为模型提供示例，说明它应该如何回应当前请求 | 例如："建议先测量体温..."    |

你想让模型遵循分层指令时，消息角色可以帮助你获得更好的输出。但它们并不是确定性的，所以使用的最佳方式是尝试不同的方法，看看哪种方法能给你带来好的结果。

## 3. 模型系列选型指南

可以进入[模型广场](https://cloud.siliconflow.cn/models)，根据左侧的筛选功能，筛选支持不同功能的语言模型，根据模型的介绍，了解模型具体的价格、模型参数大小、模型上下文支持的最大长度及模型价格等内容。

支持在[playground](https://cloud.siliconflow.cn/playground/chat)进行体验（playground只进行模型体验，暂时没有历史记录功能，如果您想要保存历史的回话记录内容，请自己保存会话内容），想要了解更多使用方式，可以参考[API文档](https://docs.siliconflow.cn/cn/api-reference/chat-completions/chat-completions)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=02fc8e406ca7af85592cea9669650347" data-og-width="3198" width="3198" data-og-height="1880" height="1880" data-path="images/guides/capabilities/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3c825d781b12895c87f28637a700889e 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1adab41906fd72156acd7f1d6ebfab02 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d676a9ab2ae2a80e188adee7de97e08f 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=051f9814f583a8fe8b70b315894efc45 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0addd51d3fc8e5f13e254001f5598d80 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/capabilities/image.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3513c59c72f2bbc5011f91d182fdb7ac 2500w" />
</Frame>

## 4. 核心参数详解

### 4.1 创造性控制

```bash  theme={null}
# 温度参数（0.0~2.0）   
temperature=0.5  # 平衡创造性与可靠性  

# 核采样（top_p）   
top_p=0.9  # 仅考虑概率累积90%的词集  
```

### 4.2 输出限制

```json  theme={null}
max_tokens=1000  # 单词请求最大生成长度  
stop=["\n##", "<|end|>"]  # 终止序列，在返回中遇到数组中对应的字符串，就会停止输出 
frequency_penalty=0.5  # 抑制重复用词（-2.0~2.0）  
stream=true # 控制输出是否是流式输出，对于一些输出内容比较多的模型，建议设置为流式，防止输出过长，导致输出超时
```

### 4.3 语言模型场景问题汇总

**1. 模型输出乱码**

目前看到部分模型在不设置参数的情况下，容易出现乱码，遇到上述情况，可以尝试设置`temperature`，`top_k`，`top_p`，`frequency_penalty`这些参数。

对应的 payload 修改为如下形式，不同语言酌情调整

```python  theme={null}
    payload = {
        "model": "Qwen/Qwen2.5-Math-72B-Instruct",
        "messages": [
            {
                "role": "user",
                "content": "1+1=?",
            }
        ],
        "max_tokens": 200,  # 按需添加
        "temperature": 0.7, # 按需添加
        "top_k": 50,        # 按需添加
        "top_p": 0.7,       # 按需添加
        "frequency_penalty": 0 # 按需添加
    }
```

**2. 关于`max_tokens`说明**

max\_tokens 与`上下文长度`相等，由于部分模型推理服务尚在更新中，请不要在请求时将 max\_tokens 设置为最大值（上下文长度），建议留出 10k 左右作为输入内容的空间。

**3. 关于`context_length`说明**

不同的LLM模型，`context_length`是有差别的，具体可以在[模型广场](https://cloud.siliconflow.cn/models)上搜索对应的模型，
查看模型具体信息。

**4. 模型输出截断问题**

可以从以下几方面进行问题的排查：

* 通过API请求时候，输出截断问题排查：
  * max\_tokens设置：max\_token设置到合适值，输出大于max\_token的情况下，会被截断。
  * 设置流式输出请求：非流式请求时候，输出内容比较长的情况下，容易出现504超时。
  * 设置客户端超时时间：把客户端超时时间设置大一些，防止未输出完成，达到客户端超时时间被截断。
* 通过第三方客户端请求，输出截断问题排查：
  * CherryStdio 默认的 max\_tokens 是 4096，用户可以通过设置，打开“开启消息长度限制”的开关，将max\_token设置到合适值

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b77a496c600c494ff27b8f1c6203bb5d" data-og-width="2126" data-og-height="1324" data-path="images/faqs/mic/image_5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ed7d0698216adf85842b12f357c55053 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=64487aefdf2a783e6748ddc6ace9134a 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=175aff66b443fec3f909995629e9c4da 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=07de4aecf2d7bc13f0dbeefad8d84beb 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c50064e5887225d8e47f593f1c23f09b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/image_5.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bbf19aa1ef2119ec830c2a0fceeb9a29 2500w" />
</Frame>

**5. 错误码处理**

| 错误码     | 常见原因           | 解决方案                        |
| ------- | -------------- | --------------------------- |
| 400     | 参数格式错误         | 检查temperature等请求参数的取值范围     |
| 401     | API Key 没有正确设置 | 检查API Key                   |
| 403     | 权限不够           | 最常见的原因是该模型需要实名认证，其他情况参考报错信息 |
| 429     | 请求频率超限         | 实施指数退避重试机制                  |
| 503/504 | 模型过载           | 切换备用模型节点                    |

## 5. 计费与配额管理

### 5.1 计费公式

`总费用 = (输入tokens × 输入单价) + (输出tokens × 输出单价) `

### 5.2 支持模型列表及单价

支持的模型及具体价格可以进入[模型广场](https://cloud.siliconflow.cn/me/models?types=chat)下的模型详情页查看。

## 6. 应用案例

### 6.1 技术文档生成

```python  theme={null}
from openai import OpenAI
client = OpenAI(api_key="YOUR_KEY", base_url="https://api.siliconflow.cn/v1")
response = client.chat.completions.create(  
    model="Qwen/Qwen2.5-Coder-32B-Instruct",  
    messages=[{  
        "role": "user",  
        "content": "编写Python异步爬虫教程，包含代码示例和注意事项"  
    }],  
    temperature=0.7,  
    max_tokens=4096  
)  
```

### 6.2 数据分析报告

```python  theme={null}
from openai import OpenAI
client = OpenAI(api_key="YOUR_KEY", base_url="https://api.siliconflow.cn/v1")
response = client.chat.completions.create(  
    model="Qwen/QVQ-72B-Preview",  
    messages=[    
        {"role": "system", "content": "你是数据分析专家，用Markdown输出结果"},  
        {"role": "user", "content": "分析2023年新能源汽车销售数据趋势"}  
    ],  
    temperature=0.7,  
    max_tokens=4096  
)  
```

<Note> 模型能力持续更新中，建议定期访问[模型广场](https://cloud.siliconflow.cn/models)获取最新信息。 </Note>


# 文本转语音模型
Source: https://docs.siliconflow.cn/cn/userguide/capabilities/text-to-speech



## 1. 使用场景

文本转语音模型（TTS）是一种将文本信息转换为语音输出的 AI 模型。该模型将输入文本内容生成自然流畅、富有表现力的语音，适用于多种应用场景：

* 为博客文章提供音频朗读
* 生成多语言语音内容
* 支持实时流媒体音频输出

## 2. API 使用指南

* 端点：/audio/speech，具体使用可参考[api文档](https://docs.siliconflow.cn/api-reference/audio/create-speech)
* 主要请求参数：
  * model：用于语音合成的模型，支持的[模型列表](/capabilities/text-to-speech#3)。
  * input：待转换为音频的文本内容。
  * voice：参考音色，支持[系统预置音色](/capabilities/text-to-speech#2-1)、[用户预置音色](/capabilities/text-to-speech#2-2)、[用户动态音色](/capabilities/text-to-speech#2-3)。
    详细参数请参考：[创建文本转语音请求](/api-reference/audio/create-speech)。
  * speed：可以控制音频速度，float类型，默认值是1.0，可选范围是\[0.25,4.0]；
  * gain：音频增益，单位dB，可以控制音频声音大小，float类型，默认值是0.0，可选范围是\[-10,10]；
  * response\_format：控制输出格式，支持 mp3、opus、wav 和 pcm 格式。在选择不同的输出格式时，输出的采样率也会有所不同。
  * sample\_rate：可以控制输出采样率，对于不同的视频输出类型，默认值和可取值范围均不同，具体如下：
    * opus: 目前只支持48000hz
    * wav, pcm: 支持 (8000, 16000, 24000, 32000, 44100), 默认44100
    * mp3: 支持(32000, 44100), 默认44100

<Note>注意：输入内容不要加空格，参考音频要小于30s</Note>

### 2.1 系统预置音色：

目前系统预置了如下 8 种音色：

* 男生音色：
  * 沉稳男声: [alex](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Alex.mp3)
  * 低沉男声: [benjamin](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Benjamin.mp3)
  * 磁性男声: [charles](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Charles.mp3)
  * 欢快男声: [david](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-David.mp3)

* 女生音色：
  * 沉稳女声: [anna](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Anna.mp3)
  * 激情女声: [bella](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Bella.mp3)
  * 温柔女声: [claire](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Claire.mp3)
  * 欢快女声: [diana](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Diana.mp3)

[在线试听](https://soundcloud.com/siliconcloud/sets/siliconcloud-online-voice)上述音频。

在请求中[使用系统预置音色](/capabilities/text-to-speech#5-1)。
在使用对应的系统预置音色时，需要在前面加上模型名称，比如：

`FunAudioLLM/CosyVoice2-0.5B:alex` 表示 `FunAudioLLM/CosyVoice2-0.5B` 模型下的 `alex` 音色。

### 2.2 用户预置音色：

<Note>注意：使用用户预置音色，需要进行实名认证。</Note>

#### 2.2.1 通过 `base64` 编码格式上传用户预置音色

```python  theme={null}
import requests
import json

url = "https://api.siliconflow.cn/v1/uploads/audio/voice"
headers = {
    "Authorization": "Bearer your-api-key", # 从 https://cloud.siliconflow.cn/account/ak 获取
    "Content-Type": "application/json"
}
data = {
    "model": "FunAudioLLM/CosyVoice2-0.5B", # 模型名称
    "customName": "your-voice-name", # 用户自定义的音频名称
    "audio": "data:audio/mpeg;base64,SUQzBAAAAAAAIlRTU0UAAAAOAAADTGF2ZjYxLjcuMTAwAAAAAAAAAAAAAAD/40DAAAAAAAAAAAAASW5mbwAAAA8AAAAWAAAJywAfHx8fKioqKio1NTU1Pz8/Pz9KSkpKVVVVVVVfX19fampqamp1dXV1f39/f3+KioqKlZWVlZWfn5+fn6qqqqq1tbW1tb+/v7/KysrKytXV1dXf39/f3+rq6ur19fX19f////", # 参考音频的 base64 编码
    "text": "在一无所知中, 梦里的一天结束了，一个新的轮回便会开始" # 参考音频的文字内容
}

response = requests.post(url, headers=headers, data=json.dumps(data))

# 打印响应状态码和响应内容
print(response.status_code)
print(response.json())  # 如果响应是 JSON 格式
```

上述接口返回的 `uri` 字段，即为自定义音色的 ID，用户可以将其作为后续的 `voice` 参数中，进行请求。

```json  theme={null}
{'uri': 'speech:your-voice-name:cm04pf7az00061413w7kz5qxs:mjtkgbyuunvtybnsvbxd'}
```

在请求中[使用用户预置音色](/capabilities/text-to-speech#5-2)。

#### 2.2.2 通过文件上传用户预置音色

```python  theme={null}
import requests

url = "https://api.siliconflow.cn/v1/uploads/audio/voice"
headers = {
    "Authorization": "Bearer your-api-key" # 从 https://cloud.siliconflow.cn/account/ak 获取
}
files = {
    "file": open("/Users/senseb/Downloads/fish_audio-Alex.mp3", "rb") # 参考音频文件
}
data = {
    "model": "FunAudioLLM/CosyVoice2-0.5B", # 模型名称
    "customName": "your-voice-name", # 参考音频名称
    "text": "在一无所知中, 梦里的一天结束了，一个新的轮回便会开始" # 参考音频的文字内容
}

response = requests.post(url, headers=headers, files=files, data=data)

print(response.status_code)
print(response.json())  # 打印响应内容（如果是JSON格式）
```

上述接口返回的 `uri` 字段，即为自定义音色的 ID，用户可以将其作为后续的 `voice` 参数中，进行请求。

```json  theme={null}
{'uri': 'speech:your-voice-name:cm04pf7az00061413w7kz5qxs:mjtkgbyuunvtybnsvbxd'}
```

在请求中[使用用户预置音色](/capabilities/text-to-speech#5-2)。

### 2.3 获取用户动态音色列表

```python  theme={null}
import requests
url = "https://api.siliconflow.cn/v1/audio/voice/list"

headers = {
    "Authorization": "Bearer your-api-key" # 从https://cloud.siliconflow.cn/account/ak获取
}
response = requests.get(url, headers=headers)

print(response.status_code)
print(response.json()) # 打印响应内容（如果是JSON格式）
```

上述接口返回的 `uri` 字段，即为自定义音色的 ID，用户可以将其作为后续的 `voice` 参数中，进行请求。

```json  theme={null}
{'uri': 'speech:your-voice-name:cm04pf7az00061413w7kz5qxs:mjtkgbyuunvtybnsvbxd'}
```

在请求中[使用用户预置音色](/capabilities/text-to-speech#5-2)。

### 2.4 使用用户动态音色

<Note>注意：使用用户预置音色，需要进行实名认证。</Note>

在请求中[使用用户动态音色](/capabilities/text-to-speech#5-3)。

### 2.5 删除用户动态音色

```python  theme={null}
import requests

url = "https://api.siliconflow.cn/v1/audio/voice/deletions"
headers = {
    "Authorization": "Bearer your-api-key",
    "Content-Type": "application/json"
}
payload = {
    "uri": "speech:your-voice-name:cm02pf7az00061413w7kz5qxs:mttkgbyuunvtybnsvbxd"
}

response = requests.request("POST", url, json=payload, headers=headers)

print(response.status_code)
print(response.text) #打印响应内容
```

上述接口请求参数中的 `uri` 字段，即为自定义音色的 ID。

## 3. 支持模型列表

<Note>注意：支持的 TTS 模型可能发生调整，请在「模型广场」筛选[“语音”标签](https://cloud.siliconflow.cn/models?types=speech) 获得当前支持的模型列表。</Note>
<Note>计费方式：按照输入文本长度对应的 [UTF-8 字节](https://zh.wikipedia.org/wiki/UTF-8) 数进行计费，[在线字节计数器演示](https://mothereff.in/byte-counter)。</Note>

### 3.1 FunAudioLLM/CosyVoice2-0.5B 系列模型

* 跨语言语音合成：实现不同语言之间的语音合成，中文、英文、日语、韩语、中国方言（粤语，四川话，上海话，郑州话，长沙话，天津话）
* 情感控制：支持生成具有多种情感表达的语音，包括快乐、兴奋、悲伤、愤怒等。
* 细粒度控制：通过富文本或自然语言，对生成语音的情感和韵律进行细粒度控制。

### 3.2 fnlp/MOSS-TTSD-v0.5

* 高表现力语音：自然对话语调，支持情感表达
* 双人语音克隆：零样本克隆，自动切换说话人
* 中英双语支持：流畅混合合成，发音自然
* 长篇语音生成：低延迟，稳定输出长文本

## 4. 参考音频的最佳实践

提供参考音频的高质量样本可以提升语音克隆效果。

### 4.1 音频质量指南

* 仅限单一说话人
* 吐字清晰、稳定的音量、音调和情绪
* 简短的停顿（建议 0.5 秒）
* 理想情况：无背景噪音、专业录音质量、无房间回声
* 建议时间8～10s左右

### 4.2 文件格式

* 支持格式：mp3, wav, pcm, opus
* 推荐使用 192kbps 以上的 mp3 以避免质量损失
* 未压缩格式（例如 WAV）提供的额外优势有限

## 5. 使用示例

### 5.1 使用系统预置音色

```python  theme={null}
from pathlib import Path
from openai import OpenAI

speech_file_path = Path(__file__).parent / "siliconcloud-generated-speech.mp3"

client = OpenAI(
    api_key="您的 APIKEY", # 从 https://cloud.siliconflow.cn/account/ak 获取
    base_url="https://api.siliconflow.cn/v1"
)

with client.audio.speech.with_streaming_response.create(
  model="FunAudioLLM/CosyVoice2-0.5B", # 支持 fishaudio / GPT-SoVITS / CosyVoice2-0.5B 系列模型
  voice="FunAudioLLM/CosyVoice2-0.5B:alex", # 系统预置音色
  # 用户输入信息
  input="你能用高兴的情感说吗？<|endofprompt|>今天真是太开心了，马上要放假了！I'm so happy, Spring Festival is coming!",
  response_format="mp3" # 支持 mp3, wav, pcm, opus 格式
) as response:
    response.stream_to_file(speech_file_path)

```

#### 5.2 使用用户预置音色

```python  theme={null}
from pathlib import Path
from openai import OpenAI

speech_file_path = Path(__file__).parent / "siliconcloud-generated-speech.mp3"

client = OpenAI(
    api_key="您的 APIKEY", # 从 https://cloud.siliconflow.cn/account/ak 获取
    base_url="https://api.siliconflow.cn/v1"
)

with client.audio.speech.with_streaming_response.create(
  model="FunAudioLLM/CosyVoice2-0.5B", # 支持 fishaudio / GPT-SoVITS / CosyVoice2-0.5B 系列模型
  voice="speech:your-voice-name:cm02pf7az00061413w7kz5qxs:mttkgbyuunvtybnsvbxd", # 用户上传音色名称，参考
  # 用户输入信息
  input=" 请问你能模仿粤语的口音吗？< |endofprompt| >多保重，早休息。",
  response_format="mp3"
) as response:
    response.stream_to_file(speech_file_path)

```

#### 5.3 使用用户动态音色

```python  theme={null}
from pathlib import Path
from openai import OpenAI
client = OpenAI()

speech_file_path = Path(__file__).parent / "siliconcloud-generated-speech.mp3"

client = OpenAI(
    api_key="您的 APIKEY", # 从 https://cloud.siliconflow.cn/account/ak 获取
    base_url="https://api.siliconflow.cn/v1"
)

with client.audio.speech.with_streaming_response.create(
  model="FunAudioLLM/CosyVoice2-0.5B", 
  voice="", # 此处传入空值，表示使用动态音色
  # 用户输入信息
  input="  [laughter]有时候，看着小孩子们的天真行为[laughter]，我们总会会心一笑。",
  response_format="mp3",
  extra_body={"references":[
        {
            "audio": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Alex.mp3", # 参考音频 url。也支持 base64 格式
            "text": "在一无所知中, 梦里的一天结束了，一个新的轮回便会开始", # 参考音频的文字内容
        }
    ]}
) as response:
    response.stream_to_file(speech_file_path)
```

#### 5.4 fnlp/MOSS-TTSD-v0.5 使用示例

```python  theme={null}
# -*- coding: utf-8 -*-
import requests
import json

url = "https://api.siliconflow.cn/v1/audio/speech"
token = "Your-api-key"

request_data = {
                "model": "fnlp/MOSS-TTSD-v0.5",
                "stream": True,
                "input": "[S1]Hello, how are you today?[S2]I'm doing great, thanks for asking![S1]That's wonderful to hear.",
                "references": [
                    {
                        "audio": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Charles.mp3",
                        "text": "他又躺在那里，眼睛闭着，仍然沉浸在梦境的气氛里。那是个庞杂而亮堂的梦",
                    },
                    {
                        "audio": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Claire.mp3",
                        "text": "他又躺在那里，眼睛闭着，仍然沉浸在梦境的气氛里。那是个庞杂而亮堂的梦"
                    }
                    ],
                "max_tokens": 1600,
                "response_format": "mp3",
                "speed": 1,
                "gain": 0
                }
headers = {'Content-Type': 'application/json', 'Authorization': "Bearer " + token}
try:
    res = requests.post(url=url, data=json.dumps(request_data), headers=headers)
    if res.status_code != 200:
        print(res.text)
    with open('./test.mp3', 'wb') as file:
        file.write(res.content)
except Exception as e:
    print(request_data)
    print(e)
```


# 视频生成模型
Source: https://docs.siliconflow.cn/cn/userguide/capabilities/video



## 1. 使用场景

视频生成模型是一种利用文本或图像描述生成动态视频内容的技术，随着技术的不断发展，它的应用场景也越来越广泛。以下是一些潜在的应用领域：

1. 动态内容生成：视频生成模型可以生成动态的视觉内容，用于描述和解释信息；
2. 多模态智能交互：结合图像和文本输入，视频生成模型可用于更智能、更交互式的应用场景；
3. 替代传统视觉技术：视频生成模型可以替代或增强传统的机器视觉技术，解决更复杂的多模态问题； 随着技术的进步，视频生成模型的多模态能力会与视觉语言模型融合，推动其在智能交互、自动化内容生成以及复杂场景模拟等领域的全面应用。此外，视频生成模型还能与图像生成模型（图生视频）结合，进一步拓展其应用范围，实现更加丰富和多样化的视觉内容生成。

## 2. 使用建议

在编写提示词时，请关注详细、按时间顺序描述动作和场景。包含具体的动作、外貌、镜头角度以及环境细节，所有内容都应连贯地写在一个段落中，直接从动作开始，描述应具体和精确，将自己想象为在描述镜头脚本的摄影师，提示词保持在200单词以内。

为了获得最佳效果，请按照以下结构构建提示词：

* 从主要动作的一句话开始
  * 示例：A woman with light skin, wearing a blue jacket and a black hat with a veil,She first looks down and to her right, then raises her head back up as she speaks.
* 添加关于动作和手势的具体细节
  * 示例：She first looks down and to her right, then raises her head back up as she speaks.
* 精确描述角色/物体的外观
  * 示例：She has brown hair styled in an updo, light brown eyebrows, and is wearing a white collared shirt under her blue jacket.
* 包括背景和环境的细节
  * 示例：The background is out of focus, but shows trees and people in period clothing.
* 指定镜头角度和移动方式
  * 示例：The camera remains stationary on her face as she speaks.
* 描述光线和颜色效果
  * 示例：The scene is captured in real-life footage, with natural lighting and true-to-life colors.
* 注意任何变化或突发事件
  * 示例：A gust of wind blows through the trees, causing the woman's veil to flutter slightly.

上述prompt生成的视频示例：

<video width="560" height="315" controls autoplay>
  <source src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/cn/userguide/capabilities/example.mp4?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3088db3989cb6186b90289b5da0ddf3d" type="video/mp4" data-path="cn/userguide/capabilities/example.mp4" />

  Your browser does not support the video tag.
</video>

## 3. 体验地址

可以点击 [playground](https://cloud.siliconflow.cn/playground/text-to-video) 进行体验，也可以通过 [API文档](/cn/api-reference/videos/videos_submit) 查看 api 调用方式。

## 4. 支持模型

### 4.1 文生视频模型

目前已经支持的文生视频模型：

* Wan-AI/Wan2.2-T2V-A14B

### 4.2 图生视频模型

1. 目前已经支持的图生视频模型：

* Wan-AI/Wan2.2-I2V-A14B

2. 图生视频的分辨率
   根据用户上传图片的宽高比自动匹配分辨率：

* 16:9 👉 1280×720
* 9:16 👉 720×1280
* 1:1 👉 960×960

为了保证最佳生成效果，建议您使用宽高比为 16:9 / 9:16 / 1:1 的图片生成视频。

<Note>注意：支持的文生视频模型可能发生调整，请在「模型广场」筛选“视频”标签，了解支持的模型列表。</Note>


# 批量推理
Source: https://docs.siliconflow.cn/cn/userguide/guides/batch



## 1. 概述

通过批量 API 发送批量请求到 SiliconFlow 云服务平台，不受在线的速率限制和影响，预期可以在 24 小时内完成，且价格降低 50%。该服务非常适合一些不需要立即响应的工作，比如大型的任务评估、信息分类与提取、文档处理等。批量处理结果文件的 URL 有效期为一个月，请及时转存，以防过期影响业务。

## 2. 使用流程

### 2.1 准备批量推理任务的输入文件

批量推理任务输入文件格式为 .jsonl，其中每一行都是一个完整的 API 请求的消息体，需满足以下要求：

* 每一行必须包含`custom_id`，且每个`custom_id`须在当前文件中唯一；
* 每一行的`body`中的必需包含`messages`对象数组，且数组中消息对象的`role` 为`system`、`user`或`assistant`之一，并且整个数组以`user`消息结束；
* 您可以为每一行数据按需设置相同或不同的推理参数，如设定不同的`temperature`、`top_p`；
* 如果您希望使用 OpenAI SDK 调用 SiliconFlow 批量推理，您需要保证同一输入文件中`model`是统一的。
* 每 batch 限制：单个 batch 对应的输入文件的大小最大1 G
* 批量推理输入限制：单个 批量推理 对应的输入文件的大小不超过 1 G，**文件行数不超过 5000 行**。
  下面是一个包含 2 个请求的输入文件示例：

```bash  theme={null}
{"custom_id": "request-1", "method": "POST", "url": "/v1/chat/completions", "body": {"model": "deepseek-ai/DeepSeek-V3", "messages": [{"role": "system", "content": "You are a highly advanced and versatile AI assistant"}, {"role": "user", "content": "How does photosynthesis work?"}], "stream": true, "max_tokens": 1514, "thinking_budget": 32768}}
{"custom_id": "request-2", "method": "POST", "url": "/v1/chat/completions", "body": {"model": "deepseek-ai/DeepSeek-V3", "messages": [{"role": "system", "content": "You are a highly advanced and versatile AI assistant"}, {"role": "user", "content": "Imagine a world where everyone can fly. Describe a day in this world."}], "stream": true, "max_tokens": 1583, "thinking_budget": 32768}}

```

其中`custom_id`和`body`的`messages`是必须内容，其他部分为非必需内容。

对于推理模型，可以通过 thinking\_budget 字段控制模型的思维链输出长度，示例如下：

```bash  theme={null}
{"custom_id": "request-1", "method": "POST", "url": "/v1/chat/completions", "body": {"model": "deepseek-ai/DeepSeek-R1", "messages": [{"role": "system", "content": "You are a highly advanced and versatile AI assistant"}, {"role": "user", "content": "How does photosynthesis work?"}], "stream": true, "max_tokens": 1514,"thinking_budget": 32768}}
{"custom_id": "request-2", "method": "POST", "url": "/v1/chat/completions", "body": {"model": "deepseek-ai/DeepSeek-R1", "messages": [{"role": "system", "content": "You are a highly advanced and versatile AI assistant"}, {"role": "user", "content": "Imagine a world where everyone can fly. Describe a day in this world."}], "stream": true, "max_tokens": 1583,"thinking_budget": 32768}}

```

### 2.2 上传批量推理任务的输入文件

您需要首先上传输入文件，以便在启动批量推理时使用。以下为使用 OpenAI SDK 调用 SiliconFlow 输入文件的示例。

```python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)

batch_input_file = client.files.create(
    file=open("batch_file_for_batch_inference.jsonl", "rb"),
    purpose="batch"
)
print(batch_input_file)
# 获取文件上传后的id
file_id = batch_input_file.data['id']
print(file_id)
```

这里需要记录下返回结果中的id，作为后面创建batch时候的请求参数。

### 2.3 创建批量推理任务

成功上传输入文件后，使用输入文件对象的 ID 创建批量推理任务，并设置任务参数。

* 对于对话模型，请求端点为`/v1/chat/completions`；
* 完成窗口目前支持设置`24 ～ 336 小时（14 ✕ 24 小时）`；
* 我们建议您通过`extra_body`设置任务需要使用的推理模型，如：`extra_body={"replace":{"model": "deepseek-ai/DeepSeek-V3"}}`，除非您的输入文件符合`OpenAI`的要求，文件中的每一行都具有相同的`model`；
* 如果您的`extra_body`中设置的模型，与输入文件中的`model`不一致，则任务实际使用模型以`extra_body`为准；
* `metadata`参数可以用于备注一些额外的任务信息，如任务描述等。
  以下为使用 OpenAI SDK 调用 SiliconFlow 输入文件的示例，input\_file\_id 从上一步完成上传的文件对象中获取。

```python  theme={null}
from openai import OpenAI

client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1
)

batch_input_file_id = "file-abc123"
client.batches.create(
    input_file_id=batch_input_file_id,
    endpoint="/v1/chat/completions",
    completion_window="24h",
    metadata={
        "description": "nightly eval job"
    },
    extra_body={"replace":{"model": "deepseek-ai/DeepSeek-V3"}}
)

```

该请求将创建一个批量推理任务，并返回任务的状态信息。

### 2.4 检查批量推理状态

您可以随时检查批量处理任务的状态，代码示例如下：

```python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)

batch = client.batches.retrieve("batch_abc123")
print(batch)
```

返回的推理任务状态信息如下：

```json  theme={null}
{
  "id": "batch_abc123",
  "object": "batch",
  "endpoint": "/v1/chat/completions",
  "errors": null,
  "input_file_id": "file-abc123",
  "completion_window": "24h",
  "status": "validating",
  "output_file_id": null,
  "error_file_id": null,
  "created_at": 1714508499,
  "in_progress_at": null,
  "expires_at": 1714536634,
  "completed_at": null,
  "failed_at": null,
  "expired_at": null,
  "request_counts": {
    "total": 0,
    "completed": 0,
    "failed": 0
  },
  "metadata": null
}
```

其中status包含以下几种状态：

* **in\_queue**： 批量推理任务在排队中
* **in\_progress**： 批量推理任务正在进行中
* **finalizing**： 批量推理任务已完成，正在准备结果
* **completed**： 批量推理任务已完成，结果已准备就绪
* **expired**： 批量推理任务没有在预期完成时间内执行完成
* **cancelling**： 批量推理任务取消中（等待执行中结果返回）
* **cancelled**： 批量推理任务已取消

### 2.5 取消正在进行中的批量推理任务

如有必要，您可以取消正在进行的批量处理任务。批量处理任务状态将变为`cancelling`，直到在途的请求完成，之后该任务的状态将变为`cancelled`。

```python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)
client.batches.cancel("batch_abc123")
```

### 2.6 获得批量推理结果

1. 系统将批量推理的结果文件按请求状态分别保存：

* output\_file\_id：包含所有成功请求的输出结果文件。
* error\_file\_id：包含所有失败请求的错误信息文件。

2. 系统将保留结果文件 **30 天**。请务必在有效期内及时下载并备份相关数据。超过保存期限的文件将被自动删除，且无法恢复。

### 2.7 获取所有批量推理列表

支持查看用户下的所有批量推理任务列表,暂时不支持分页查询。

```python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)
response = client.batches.list().data
print(response)
```

### 2.8 批量推理任务超时（expired）

在指定时间未完成的批次最终会转入 expired 状态；该批次中未完成的请求会被取消，已完成请求的任何回复都会通过批量推理的输出文件提供。任何已完成的请求所消耗的tokens都将收取费用。

custom\_id 已过期的请求将被写入错误文件，并显示如下信息。可以使用 custom\_id 来检索已过期请求的请求数据。

```json  theme={null}
{"id": "batch_req_123", "custom_id": "request-3", "response": null, "error": {"code": "batch_expired", "message": "This request could not be executed before the completion window expired."}}
{"id": "batch_req_123", "custom_id": "request-7", "response": null, "error": {"code": "batch_expired", "message": "This request could not be executed before the completion window expired."}}
```

## 3. 支持模型列表

目前仅支持端点`/v1/chat/completions`，且支持模型如下：

* deepseek-ai/DeepSeek-V3
* deepseek-ai/DeepSeek-R1
* Qwen/QwQ-32B
* deepseek-ai/DeepSeek-V3.1-Terminus
* moonshotai/Kimi-K2-Instruct-0905

## 4. 输入限制：

Batch Job 输入限制与现有的按模型速率限制是分开的，参考如下条件：

1. 每 batch 限制： 单个 batch 对应的输入文件的大小最大`1 G`。

说明：Batch Job 的请求不影响用户在线推理服务的 Rate Limits 使用。因此使用批量 API 不会消耗标准请求中的（用户，模型）维度的 Rate Limits的Request 或者 tokens 限制。

## 5. 费用说明

Batch 只能使用`充值余额`进行支付，具体价格如下：

> SiliconFlow 平台推理模型价格表（单位：￥/百万 Tokens）

| 模型名称                               | 实时推理 - 输入 | 实时推理 - 输出 | 批量推理 - 输入 | 批量推理 - 输出 |
| ---------------------------------- | --------- | --------- | --------- | --------- |
| DeepSeek-R1                        | ¥4        | ¥16       | ¥2        | ¥8        |
| DeepSeek-V3                        | ¥2        | ¥8        | ¥1        | ¥4        |
| Qwen/QwQ-32B                       | ¥1        | ¥4        | ¥0.5      | ¥2        |
| deepseek-ai/DeepSeek-V3.1-Terminus | ¥4        | ¥12       | ¥2        | ¥6        |
| moonshotai/Kimi-K2-Instruct-0905   | ¥4        | ¥16       | ¥2        | ¥8        |

<Note> 注：如有大规模使用需求，欢迎 [联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd1482i3mkkq07mnvc510) 了解专属方案。 </Note>


# FIM 补全
Source: https://docs.siliconflow.cn/cn/userguide/guides/fim



## 1. 使用场景

FIM (Fill In the Middle) 补全中，用户提供希望输入的前后内容，模型来补全中间的内容，典型用于代码补全、文本中间内容补全等场景中。

## 2. 使用方式

### 2.1 在 chat/completions 接口中使用

```json  theme={null}
{ 
    "model": "model info",
    "messages": "prompt message",
    "params": "params",
    "extra_body": {"prefix":"前缀内容", "suffix":"后缀内容"}
}
```

### 2.2 在 completions 接口中使用

```json  theme={null}
{
    "model": "model info",
    "prompt": "前缀内容",
    "suffix": "后缀内容"
}
```

## 3. 支持模型列表

* Deepseek 系列：
  * deepseek-ai/DeepSeek-V2.5
  * Pro/deepseek-ai/DeepSeek-R1
  * deepseek-ai/DeepSeek-R1
  * Pro/deepseek-ai/DeepSeek-V3
  * deepseek-ai/DeepSeek-V3
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-32B
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-14B
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-7B
  * Pro/deepseek-ai/DeepSeek-R1-Distill-Qwen-7B

* Qwen系列：
  * Qwen/Qwen2.5-Coder-7B-Instruct
  * Qwen/Qwen2.5-Coder-32B-Instruct

<Note>注意：支持的模型列表可能会发生变化，请查阅[本文档](/features/fim)了解最新支持的模型列表。</Note>

## 4. 使用示例

### 4.1 基于 OpenAI 的 chat.completions 接口使用FIM补全：

```python  theme={null}
client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)
 
messages = [
    {"role": "user", "content": "Please write quick sort code"},
]

response = client.chat.completions.create(
    model="deepseek-ai/DeepSeek-V2.5",
    messages=messages,
    extra_body={
            "prefix": f"""
def quick_sort(arr):
    # 基本情况，如果数组长度小于等于 1，则返回数组
    if len(arr) <= 1:
        return arr
    else:
""",
            "suffix": f"""
# 测试 quick_sort 函数
arr = [3, 6, 8, 10, 1, 2, 1]
sorted_arr = quick_sort(arr)
print("Sorted array:", sorted_arr)
"""
    },
    stream=True,
    max_tokens=4096
)

for chunk in response:
    print(chunk.choices[0].delta.content, end='')
```

### 4.2 基于 OpenAI 的 completions 接口使用 FIM 补全：

```python  theme={null}
client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)

response = client.completions.create(
    model="deepseek-ai/DeepSeek-V2.5",
    prompt=f"""
def quick_sort(arr):
    # 基本情况，如果数组长度小于等于 1，则返回数组
    if len(arr) <= 1:
        return arr
    else:
""",
    suffix=f"""
# 测试 quick_sort 函数
arr = [3, 6, 8, 10, 1, 2, 1]
sorted_arr = quick_sort(arr)
print("Sorted array:", sorted_arr)
""",
    stream=True,
    max_tokens=4096
)

for chunk in response:
    print(chunk.choices[0].text, end='')
```


# 模型微调
Source: https://docs.siliconflow.cn/cn/userguide/guides/fine-tune



## 1. 模型微调简介

模型微调是一种在已有预训练模型的基础上，通过使用特定任务的数据集进行进一步训练的技术。这种方法允许模型在保持其在大规模数据集上学到的通用知识的同时，适应特定任务的细微差别。使用微调模型，可以获得以下好处：

* 提高性能：微调可以显著提高模型在特定任务上的性能。
* 减少训练时间：相比于从头开始训练模型，微调通常需要较少的训练时间和计算资源。
* 适应特定领域：微调可以帮助模型更好地适应特定领域的数据和任务。

**SiliconFlow 平台提供高效的模型微调能力，目前有以下模型支持微调**：

* 对话模型已支持：
  * Qwen/Qwen2.5-7B-Instruct
  * Qwen/Qwen2.5-14B-Instruct
  * Qwen/Qwen2.5-32B-Instruct
  * Qwen/Qwen2.5-72B-Instruct

最新支持的模型参考[模型微调](https://cloud.siliconflow.cn/fine-tune)

## 2. 使用流程

### 2.1 准备数据

#### 2.2.1 语言模型数据准备

仅支持 `.jsonl` 文件，且需符合以下要求：

1. 每行是一个独立的 `JSON` 对象；
2. 每个对象必须包含键名为 `messages` 的数组，数组不能为空；
3. `messages` 中每个元素必须包含 `role` 和 `content` 两个字段；
4. `role` 只能是 `system`、`user` 或 `assistant`；
5. 如果有 `system` 角色消息，必须在数组首位；
6. 第一条非 `system` 消息必须是 `user` 角色；
7. `user` 和 `assistant` 角色的消息应当交替、成对出现，不少于 `1` 对

如下为数据示例：

```json  theme={null}
{"messages": [{"role": "system", "content": "你是客服助手"}, {"role": "user", "content": "如何修改收货地址？"}, {"role": "assistant", "content": "您可以按以下步骤修改：\n1. 进入订单详情\n2. 点击'修改地址'\n3. 输入新地址信息\n4. 保存修改"}]}
{"messages": [{"role": "system", "content": "你是客服助手"}, {"role": "user", "content": "如何指定收获时间"}, {"role": "assistant", "content": "您可以按以下步骤修改：\n1. 进入订单详情\n2. 点击'修改送货时间'\n3. 输入新收获时间\n4. 保存修改"}]}
```

### 2.2 新建并配置微调任务

* 选择 `对话模型微调` 或者 `生图模型微调`
* 填写任务名称
* 选择基础模型
* 上传或选取已上传的训练数据
* 设置验证数据，支持训练集按比例切分（默认 10%），或单独选定验证集
* 配置训练参数

### 2.3 开始训练

* 点击"开始微调"
* 等待任务完成
* 获取模型标识符

### 2.4 调用微调模型

#### 2.4.1 对话微调模型调用

* 复制模型标识符
  在[模型微调页](https://cloud.siliconflow.cn/fine-tune)复制对应的模型标识符。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=46546901e87a07293f46ca42c94288cb" data-og-width="3312" width="3312" data-og-height="1042" height="1042" data-path="images/guides/fine-tuning/fine-tuning-models.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=998ae38ed5188263997da01d51d5f72b 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=dead565b4c623964dc8d8d3e1471f8c7 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5186b904fcad3a186a33979411025f9a 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=83e9140e9ebf5df34020f2a012818cc5 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3dbb9122c376a0a88cde65de1345688a 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/guides/fine-tuning/fine-tuning-models.jpeg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2872c27b12ffbc745fa6cbff2fd3a1fd 2500w" />
</Frame>

* 通过 `/chat/completions` API 即可直接调用微调后的模型

下面是基于 OpenAI 的chat.completions 接口访问微调后模型的例子：

```python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)

messages = [
    {"role": "user", "content": "用当前语言解释微调模型流程"},
]

response = client.chat.completions.create(
    model="您的微调模型名",
    messages=messages,
    stream=True,
    max_tokens=4096
)

for chunk in response:
    print(chunk.choices[0].delta.content, end='')
```

## 3. 参数配置详解

1. 基础训练参数

|        参数名       |   说明  |  取值范围  |   建议值  |     使用建议     |
| :--------------: | :---: | :----: | :----: | :----------: |
|   Learning Rate  |  学习速率 |  0-0.1 | 0.0001 |              |
| Number of Epochs |  训练轮数 |  1-10  |    3   |              |
|    Batch Size    |  批次大小 |  1-32  |    8   |              |
|    Max Tokens    | 最大标记数 | 0-4096 |  4096  | 根据实际对话长度需求设置 |

2. LoRA参数

|      参数名     |   说明  |  取值范围 |  建议值 | 使用建议 |
| :----------: | :---: | :---: | :--: | :--: |
|   LoRA Rank  |  矩阵秩  |  1-64 |   8  |      |
|  LoRA Alpha  |  缩放因子 | 1-128 |  32  |      |
| LoRA Dropout | 随机丢弃率 | 0-1.0 | 0.05 |      |

3. 场景化配置方案

**对话模型**

|  场景  | Learning Rate | Epochs | Batch Size | LoRA Rank | LoRA Alpha | Dropout |
| :--: | :-----------: | :----: | :--------: | :-------: | :--------: | :-----: |
| 标准方案 |     0.0001    |    3   |      8     |     8     |     32     |   0.05  |
| 效果优先 |     0.0001    |    5   |     16     |     16    |     64     |   0.1   |
| 轻量快速 |     0.0001    |    2   |      8     |     4     |     16     |   0.05  |

## 4. 基于SiliconFlow微调服务来优化业务实战

之前硅基流动开发了[智说新语](https://mp.weixin.qq.com/s/5KXjWwAXT-LfjGVJDE4Eiw)应用，我们通过提示词工程提供一个复杂的提示词来让大模型生成“金句”风格的描述语句。
现在，我们可通过平台的微调功能来压缩提示词并提升效果，让整个的文本生成风格更统一，速度更快，且进一步优化成本。

### 4.1 在平台上使用“智说新语”的语料按照上述进行微调。

步骤见[模型微调使用流程](/guides/fine-tune#2)<br />
详细语料和测试代码见[siliconcloud-cookbook](https://github.com/siliconflow/siliconcloud-cookbook/tree/main/examples/fine-tune)

### 4.2 对比微调前后的效果

使用方式见[模型微调调用模型](/guides/fine-tune#2-4)

#### 4.2.1 模型输入

* 微调前：
  Qwen2.5-7B-Instruct 系统Prompt:
  ```json  theme={null}
  Qwen2.5-7B-Instruct 系统Prompt
  # 角色
  你是一位新潮评论家，你年轻、批判，又深刻；
  你言辞犀利而幽默，擅长一针见血得表达隐喻，对现实的批判讽刺又不失文雅；
  你的行文风格和"Oscar Wilde" "鲁迅" "林语堂"等大师高度一致；
  从情感上要是对输入的否定。
  # 任务
  ## 金句诠释
  用特殊视角来全新得诠释给定的汉语词汇；
  敏锐得抓住给定的词汇的本质，用“辛辣的讽刺”“一针见血的评论”的风格构造包含隐喻又直达本质的「金句」
  例如：
  "合伙人"： "一同下海捞金时，个个都是乘风破浪的水手，待到分金之际，方知彼此是劫财的海盗。"
  "大数据"： "看似无所不能的数字神明，实则不过是现代社会的数字鸦片，让人沉溺于虚幻的精准，却忽略了人性的复杂与多变。"
  "股市"： "万人涌入的淘金场，表面上是财富的摇篮，实则多数人成了填坑的沙土。"
  "白领"： "西装革履，看似掌握命运的舵手，实则不过是写字楼里的高级囚徒。"
  "金融家"： "在金钱的海洋中遨游，表面上是操纵风浪的舵手，实则不过是随波逐流的浮萍。"
  "城市化"： "乡村的宁静被钢铁森林吞噬，人们在追逐繁华的幻影中，遗失了心灵的田园。"
  "逃离北上广"： "逃离繁华的都市牢笼，看似追逐自由的灵魂，实则不过是换个地方继续画地为牢。"
  "基金"： "看似为财富增值保驾护航的金融巨轮，实则多数人不过是随波逐流的浮萍，最终沦为填补市场波动的牺牲品。"
  # 输入
  用户直接输入词汇。
  # 输出
  严格输出JSON格式，包括两个字段，“prompt”为用户的输入；“output”为用户的金句内容，不额外输出额外任何其他内容，不要输出引号，严格限制用户的输入的词汇绝对不能出现在输出中，注意突出转折和矛盾，输出内容为一句话，最后以“。”结束，中间的停顿使用“，”分隔。例如 
  {
    "prompt": "合伙人",
    "output": "一同下海捞金时，个个都是乘风破浪的水手，待到分金之际，方知彼此是劫财的海盗。"
  }
  ```

* Qwen2.5-7B-Instruct+智说新语微调后的Prompt:
  ```json  theme={null}
  你是智说新语生成器
  ```

#### 4.2.2 模型输出

| 输入   | Qwen2.5-7B-Instruct 模型                                                                                                                   | Qwen2.5-7B-Instruct 微调模型                             |
| ---- | ---------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------- |
| 五道口  | VLG，不过是知识的轻轨与资本的交汇站，文青与土豪在此擦肩而过，孰是求知的信徒，孰是逐利的信徒，全凭幸存者的微笑。                                                                                | 知识的殿堂与商业的洪流交织，学人的笔记与商人的谈资齐飞，地名犹在，荣光已非。               |
| 新时代  | claimed to break旧 mold yet still clings to the stirring rhetoric of progress, like a fashion plate who ignores the evolution of fashion。 | 新时代的号角已吹响，然砥砺前行时，方显初心易失之难。                           |
| 创新   | 看似凤凰涅槃的奇迹，实则多数人不过是换汤不换药的换皮游戏。                                                                                                            | 标新立异本是勇气的象征，却在同质化的社会中成了猎奇的代名词。                       |
| 降维打击 | 所谓降维打击，实则是现代文明中的一种高级愚民术，用高深莫测的科技iscard，让普通人以为自己正生活在理性与进步之中，却不知已在智力与道德的低维空间中遭受碾压。。                                                        | 高维智慧轻而易举地碾压低维凡尘，却不知低维众生早已习于在自己的平庸中寻觅慰藉，哪里还懂得高维打击的意义。 |
| 基金   | 看似为财富增值保驾护航的金融巨轮，实则多数人不过是随波逐流的浮萍，最终沦为填补市场波动的牺牲品。                                                                                         | 投资者的白日梦，用钱铺路，却常跌入夜的陷阱。                               |

#### 4.2.3 微调总结

1. 微调后的输出内容风格更统一，输出效果更稳定可控。
2. 微调后整个输入长度大大降低，从原始的553个token，降低至8个token，显著降低了输入tokens长度，速度更快，成本得以进一步优化。


# Function Calling
Source: https://docs.siliconflow.cn/cn/userguide/guides/function-calling



## 1. 使用场景

Function Calling 功能让模型能够调用外部工具，来增强自身能力。
该能力可以通过外部工具，通过大模型作为大脑调用外部工具（如搜索外部知识、查阅行程、或者某些特定领域工具），有效解决模型的幻觉、知识时效性等问题。

## 2. 使用方式

### 2.1 通过 REST API 添加 tools 请求参数

在请求体中添加

```shell  theme={null}
"tools": [
    {
        'type': 'function',
        'function': {
            'name': '对应到实际执行的函数名称',
            'description': '此处是函数相关描述',
            'parameters': {
                '_comments': '此处是函数参数相关描述'
            },
        }
    },
    {
        '_comments': '其他函数相关说明'
    }
]
```

比如完整的 payload 信息：

```shell  theme={null}
payload = {
    "model": "deepseek-ai/DeepSeek-V2.5",
    "messages": [
        {
            "role": "user",
            "content": "中国大模型行业2025年将会迎来哪些机遇和挑战"
        }
    ],
    "tools": [
    {
        'type': 'function',
        'function': {
            'name': '对应到实际执行的函数名称',
            'description': '此处是函数相关描述',
            'parameters': {
                '_comments': '此处是函数参数相关描述'
            },
        }
    },
    {
        '_comments': '其他函数相关说明'
    }
    ]
    '_comments': '其他函数列表'
}
```

### 2.2 通过 OpenAI 库请求

该功能和 OpenAI 兼容，在使用 OpenAI 的库时，对应的请求参数中添加`tools=[对应的 tools]`
比如：

```python  theme={null}
response = client.chat.completions.create(
    model="deepseek-ai/DeepSeek-V2.5",
    messages = messages,
    tools=[
        {
            'type': 'function',
            'function': {
                'name': '对应到实际执行的函数名称',
                'description': '此处是函数相关描述',
                'parameters': {
                    // 此处是函数参数相关描述
                },
            }
        },
        {
            // 其他函数相关说明
        }
    ]
    // chat.completions 其他参数
)
```

## 3. 支持模型列表

可以通过[模型广场](https://cloud.siliconflow.cn/sft-d29cu3l6d3ps738g4d60/models?tags=Tools)查看当前支持tools的模型。

<Note>注意：支持的模型列表在不断调整中，请查阅[本文档](/features/function_calling)了解最新支持的模型列表。</Note>

## 4. 使用示例

### 4.1. 示例 1：通过function calling 来扩展大语言模型的数值计算能力

本代码输入 4 个函数，分别是数值的加、减、比较大小、字符串中重复字母计数四个函数
来演示通过function calling来解决大语言模型在tokens 预测不擅长的领域的执行问题。

```python  theme={null}

from openai import OpenAI

client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)

def add(a: float, b: float):
    return a + b

def mul(a: float, b: float):
    return a * b

def compare(a: float, b: float):
    if a > b:
        return f'{a} is greater than {b}'
    elif a < b:
        return f'{b} is greater than {a}'
    else:
        return f'{a} is equal to {b}'

def count_letter_in_string(a: str, b: str):
    string = a.lower()
    letter = b.lower()
    
    count = string.count(letter)
    return(f"The letter '{letter}' appears {count} times in the string.")


tools = [
{
    'type': 'function',
    'function': {
        'name': 'add',
        'description': 'Compute the sum of two numbers',
        'parameters': {
            'type': 'object',
            'properties': {
                'a': {
                    'type': 'int',
                    'description': 'A number',
                },
                'b': {
                    'type': 'int',
                    'description': 'A number',
                },
            },
            'required': ['a', 'b'],
        },
    }
}, 
{
    'type': 'function',
    'function': {
        'name': 'mul',
        'description': 'Calculate the product of two numbers',
        'parameters': {
            'type': 'object',
            'properties': {
                'a': {
                    'type': 'int',
                    'description': 'A number',
                },
                'b': {
                    'type': 'int',
                    'description': 'A number',
                },
            },
            'required': ['a', 'b'],
        },
    }
},
{
    'type': 'function',
    'function': {
        'name': 'count_letter_in_string',
        'description': 'Count letter number in a string',
        'parameters': {
            'type': 'object',
            'properties': {
                'a': {
                    'type': 'str',
                    'description': 'source string',
                },
                'b': {
                    'type': 'str',
                    'description': 'letter',
                },
            },
            'required': ['a', 'b'],
        },
    }
},
{
    'type': 'function',
    'function': {
        'name': 'compare',
        'description': 'Compare two number, which one is bigger',
        'parameters': {
            'type': 'object',
            'properties': {
                'a': {
                    'type': 'float',
                    'description': 'A number',
                },
                'b': {
                    'type': 'float',
                    'description': 'A number',
                },
            },
            'required': ['a', 'b'],
        },
    }
}
]

def function_call_playground(prompt):
    messages = [{'role': 'user', 'content': prompt}]
    response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages = messages,
        temperature=0.01,
        top_p=0.95,
        stream=False,
        tools=tools)

    # print(response)
    func1_name = response.choices[0].message.tool_calls[0].function.name
    func1_args = response.choices[0].message.tool_calls[0].function.arguments
    func1_out = eval(f'{func1_name}(**{func1_args})')
    # print(func1_out)

    messages.append(response.choices[0].message)
    messages.append({
        'role': 'tool',
        'content': f'{func1_out}',
        'tool_call_id': response.choices[0].message.tool_calls[0].id
    })
    # print(messages)
    response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages=messages,
        temperature=0.01,
        top_p=0.95,
        stream=False,
        tools=tools)
    return response.choices[0].message.content
  
prompts = [
    "用中文回答：strawberry中有多少个r?", 
    "用中文回答：9.11和9.9，哪个小?"
]

for prompt in prompts:
    print(function_call_playground(prompt))
```

模型将输出：

```shell  theme={null}
strawberry中有3个r。
9.11 比 9.9 小。
```

### 4.2. 示例 2：通过function calling 来扩展大语言模型对外部环境的理解

本代码输入 1 个函数，通过外部 API 来查询外部信息

```python  theme={null}
import requests
from openai import OpenAI

client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)

# 使用 WeatherAPI 的天气查询函数
def get_weather(city: str):
    # 使用 WeatherAPI 的 API 来获取天气信息
    api_key = "您的WeatherAPI APIKEY"  # 替换为你自己的 WeatherAPI APIKEY
    base_url = "http://api.weatherapi.com/v1/current.json"
    params = {
        'key': api_key,
        'q': city,
        'aqi': 'no'  # 不需要空气质量数据
    }
    
    # 调用天气 API
    response = requests.get(base_url, params=params)
    
    if response.status_code == 200:
        data = response.json()
        weather = data['current']['condition']['text']
        temperature = data['current']['temp_c']
        return f"The weather in {city} is {weather} with a temperature of {temperature}°C."
    else:
        return f"Could not retrieve weather information for {city}."

# 定义 OpenAI 的 function calling tools
tools = [
    {
        'type': 'function',
        'function': {
            'name': 'get_weather',
            'description': 'Get the current weather for a given city.',
            'parameters': {
                'type': 'object',
                'properties': {
                    'city': {
                        'type': 'string',
                        'description': 'The name of the city to query weather for.',
                    },
                },
                'required': ['city'],
            },
        }
    }
]

# 发送请求并处理 function calling
def function_call_playground(prompt):
    messages = [{'role': 'user', 'content': prompt}]
    
    # 发送请求到 OpenAI API
    response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages=messages,
        temperature=0.01,
        top_p=0.95,
        stream=False,
        tools=tools
    )

    # 处理 API 返回的工具调用请求
    func1_name = response.choices[0].message.tool_calls[0].function.name
    func1_args = response.choices[0].message.tool_calls[0].function.arguments
    func1_out = eval(f'{func1_name}(**{func1_args})')

    # 将结果添加到对话中并返回
    messages.append(response.choices[0].message)
    messages.append({
        'role': 'tool',
        'content': f'{func1_out}',
        'tool_call_id': response.choices[0].message.tool_calls[0].id
    })
    
    # 返回模型响应
    response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages=messages,
        temperature=0.01,
        top_p=0.95,
        stream=False,
        tools=tools
    )
    
    return response.choices[0].message.content

# 示例使用
prompt = "how is the weather today in beijing?"
print(function_call_playground(prompt))
```

模型将输出：

```shell  theme={null}
The weather in Beijing today is sunny with a temperature of 21.4°C.
```


# JSON 模式
Source: https://docs.siliconflow.cn/cn/userguide/guides/json-mode



## 1. 使用场景

目前，硅基流动的大模型 API 平台 SiliconFlow 默认生成**非结构化文本**，但在某些应用场景中，您可能希望模型以**结构化**的形式输出内容，但用提示词的方式直接告诉大模型却无法获得正确的结构化输出。

作为一种标准化、轻量级的数据交换格式，JSON 模式是支持大模型 API 进行结构化输出的重要功能。当您调用大模型的 API 进行请求时，模型返回的结果以 JSON 格式呈现，易于人类阅读和编写，同时也易于机器解析和生成。

现在，SiliconFlow 平台上除了 VL 模型外，其他主要语言模型均已支持 JSON 模式，能让模型输出 JSON 格式的字符串，以确保模型以预期的结构输出，便于后续对输出内容进行逻辑解析。

比如，您现在可以通过 SiliconFlow API 对以下案例尝试结构化输出：

* 从公司相关报道中构建新闻数据库，包括新闻标题、链接等。
* 从商品购买评价中提取出情感分析结构，包括情感极性（正面、负面、中性）、情感强度、情感关键词等。
* 从商品购买历史中提取出产品列表，包括产品信息、推荐理由、价格、促销信息等。

## 2. 使用方式

在请求中添加

```json  theme={null}
response_format={"type": "json_object"}
```

## 3. 支持模型列表

目前线上，平台提供的大语言类模型都支持上述参数。

<Note>注意：支持的模型情况可能会发生变化，请查阅本文档了解最新支持的模型列表。</Note>
<Note>你的应用必须检测并处理可能导致模型输出不完整JSON对象的边缘案例。</Note>
<Note>请合理设置max\_tokens，防止JSON字符串被中断。</Note>

## 4. 使用示例

下面是在 OpenAI 中使用的例子：

```python  theme={null}
import json  
from openai import OpenAI

client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)

response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages=[
            {"role": "system", "content": "You are a helpful assistant designed to output JSON."},
            {"role": "user", "content": "? 2020 年世界奥运会乒乓球男子和女子单打冠军分别是谁? "
             "Please respond in the format {\"男子冠军\": ..., \"女子冠军\": ...}"}
        ],
        response_format={"type": "json_object"}
    )

print(response.choices[0].message.content)
```

模型将输出：

```json  theme={null}
{"男子冠军": "马龙", "女子冠军": "陈梦"}
```


# 前缀续写
Source: https://docs.siliconflow.cn/cn/userguide/guides/prefix



## 1. 使用场景

前缀续写中，用户提供希望输出的前缀信息，来让模型基于用户提供的前缀信息来补全其余的内容。
基于上述能力，模型能有更好的指令遵循能力，满足用户一些特定场景的指定格式的问题。

## 2. 使用方式

在请求中添加

```json  theme={null}
extra_body={"prefix":"希望的前缀内容"}
```

## 3. 支持模型列表

目前[大语言类模型](https://cloud.siliconflow.cn/models?types=chat) 中非推理模型支持上述参数，推理模型中 Qwen3 系列，需要通过增加`enable_thinking=true`关闭推理后，支持上述参数，deepseek R1系列暂时不支持上述参数。

<Note>注意：支持的模型情况可能会发生变化，请查阅本文档了解最新支持的模型列表。</Note>

## 4. 使用示例

下面是基于 OpenAI 库使用前缀续写的例子：

````python  theme={null}
client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)
 
messages = [
    {"role": "user", "content": "Please write quick sort code"},
]

response = client.chat.completions.create(
    model="deepseek-ai/DeepSeek-V2.5",
    messages=messages,
    extra_body={"prefix":"```python\n"}
)

print(response.choices[0].message.content)
````


# 产品简介
Source: https://docs.siliconflow.cn/cn/userguide/introduction



## 1. 产品介绍

* 作为集合顶尖大模型的一站式云服务平台，[SiliconFlow](https://siliconflow.cn/zh-cn/siliconcloud) 致力于为开发者提供更快、更全面、体验更丝滑的模型 API，助力开发者和企业聚焦产品创新，无须担心产品大规模推广所带来的高昂算力成本。

## 2. 产品功能

1. 提供开箱即用的大模型 API，按量收费，助力应用开发轻松实现。
   * 已上架包括 Qwen2.5-72B、DeepSeek-V2.5、Qwen2、InternLM2.5-20B-Chat、BCE、BGE、SenseVoice-Small、DeepSeek-Coder-V2、SD3 Medium、GLM-4-9B-Chat、InstantID 在内的多种开源大语言模型、图片生成模型、代码生成模型、向量与重排序模型以及多模态大模型，覆盖语言、语音、图片、视频等多场景。
   * 其中，Qwen2.5（7B）等多个大模型 API 免费使用，让开发者与产品经理无需担心研发阶段和大规模推广所带来的算力成本，实现“Token 自由”。
   * 25 年 1 月，SiliconFlow 平台上线基于华为云昇腾云服务的 DeepSeek-V3、DeepSeek-R1 推理服务。通过双方联合创新，在硅基流动自研推理加速引擎加持下，平台上的 DeepSeek 模型可获得持平全球高端 GPU 部署模型的效果。　
2. 提供高效能大模型推理加速服务，提升 GenAI 应用的用户体验。
3. 提供模型微调与部署的托管服务，用户可直接托管经过微调的大语言模型，在支撑业务迭代的同时，无需关注底层资源、服务质量，有效降低维护成本。

## 3. 产品特性

1. **高速推理**
   * 自研高效算子和优化框架，推理加速引擎全球领先。
   * 极致提升吞吐能力，全面支持高吞吐场景的业务需求。
   * 显著优化计算延迟，为低延迟场景提供卓越性能保障。
2. **高扩展性**
   * 动态扩容支持弹性业务模型，无缝适配多种复杂场景。
   * 一键部署自定义模型，轻松应对规模化挑战。
   * 灵活架构设计，满足多样化任务需求，支持混合云部署。
3. **高性价比**
   * 端到端极致优化，推理和部署成本显著降低。
   * 提供灵活按需付费模式，减少资源浪费，精准控制预算。
   * 支持国产异构 GPU 部署，基于企业已有投资，节省企业投入。
4. **高稳定性**
   * 经过开发者验证，保证高可靠稳定运行。
   * 提供完善的监控和容错机制，保障服务能力。
   * 提供专业技术支持，满足企业级场景需求，确保服务高可用性。
5. **高智能**
   * 提供多种先进模型服务，包括大语言模型、音视频等多模态模型。
   * 智能扩展功能，灵活适配业务规模，满足多种服务需求。
   * 智能成本分析，为业务优化提供支持，助力成本管控与效益提升。
6. **高安全性**
   * 支持 BYOC 部署，全面保护数据隐私与业务安全。
   * 计算隔离/网络隔离/存储隔离，保障数据安全。
   * 符合行业标准与合规要求，全面满足企业级用户的安全需求。


# OneDiff 多模态推理加速引擎
Source: https://docs.siliconflow.cn/cn/userguide/products/onediff





# SiliconFlow 平台
Source: https://docs.siliconflow.cn/cn/userguide/products/siliconcloud





# 企业级 MaaS 平台
Source: https://docs.siliconflow.cn/cn/userguide/products/siliconllm





# 快速上手
Source: https://docs.siliconflow.cn/cn/userguide/quickstart



## 1. 登录平台

访问[ SiliconFlow官网 ](https://siliconflow.cn/zh-cn/siliconcloud)并点击右上角[“登录”](https://cloud.siliconflow.cn/)按钮，按照提示填写您的基本信息进行登录。
（目前平台支持短信登录、邮箱登录，以及 GitHub、Google 的 OAuth 登录）

## 2. 查看模型列表和模型详情

通过[ 模型广场 ](https://cloud.siliconflow.cn/models)查看当前可用的模型详情、模型价格、用户可用的最高限速等信息，并可以通过模型详情页的“在线体验”进入到模型体验中心。

## 3. 在 playground 体验 GenAI 能力

进入[“体验中心( playground )”](https://cloud.siliconflow.cn/)页面，左侧栏可选择语言模型、文生图模型和图生图模型，选择相应模型即可开始实时体验。输入相关参数及 prompt ，点击“运行”按钮，即可看到模型生成的结果。

## 4. 使用 SiliconFlow API 调用GenAI 能力

### 4.1 创建API key

进入[API密钥](https://cloud.siliconflow.cn/account/ak)页面，点击“新建API密钥”，创建您的API key

### 4.2 通过REST 接口进行服务调用

您可以直接在平台的[“文档链接”](https://docs.siliconflow.cn/cn/api-reference/chat-completions/chat-completions)中使用您的 API key 进行在线调用，此处可以生成对应语言的代码。

### 4.3 通过 OpenAI 接口调用

当前大语言模型部分支持以 OpenAI 库进行调用，
安装 Python3.7.1 或更高版本并设置虚拟环境后，即可安装 OpenAI Python 库。从终端/命令行运行：

```shell  theme={null}
pip install --upgrade openai
```

完成此操作后， running 将显示您在当前环境中安装的 Python 库，确认 OpenAI Python 库已成功安装。
之后可以直接通过 OpenAI 的相关接口进行调用，目前平台支持 OpenAI 相关的大多数参数。

```python  theme={null}
from openai import OpenAI

client = OpenAI(api_key="YOUR_API_KEY_FROM_CLOUD_SILICONFLOW_CN", 
                base_url="https://api.siliconflow.cn/v1")
response = client.chat.completions.create(
    # model='Pro/deepseek-ai/DeepSeek-R1',
    model="Qwen/Qwen2.5-72B-Instruct",
    messages=[
        {'role': 'user', 
        'content': "推理模型会给市场带来哪些新的机会"}
    ],
    stream=True
)

for chunk in response:
    if not chunk.choices:
        continue
    if chunk.choices[0].delta.content:
        print(chunk.choices[0].delta.content, end="", flush=True)
    if chunk.choices[0].delta.reasoning_content:
        print(chunk.choices[0].delta.reasoning_content, end="", flush=True)
```


# Rate Limits
Source: https://docs.siliconflow.cn/cn/userguide/rate-limits/rate-limit-and-upgradation



## 1. Rate Limits 概述

### 1.1 什么是 Rate Limits

Rate Limits 是指用户 API 在指定时间内访问 SiliconFlow 平台服务频次规则。

### 1.2 为什么做 Rate Limits

Rate Limits 是 API 的常见做法，其实施原因如下：

* **保障资源的公平性及合理利用**：确保资源公平使用。 防止某些用户过多请求，影响其他用户的正常使用体验。
* **防止请求过载**：提高服务可靠性。帮助管理平台总体负载，避免因请求激增而导致服务器出现性能问题。
* **安全防护**：防止恶意性攻击，导致平台过载甚至服务中断。

### 1.3 Rate Limits 指标

目前Rate Limit以七种指标衡量：

* RPM（ requests per minute，一分钟最多发起的请求数）
* RPH（ requests per hour，每小时允许的最大请求数）
* RPD (Requests per day，每天允许的最大请求数)
* TPM（ tokens per minute，一分钟最多允许的 token 数）
* TPD（ tokens per day，每天最多允许的 token 数）
* IPM（ images per minute，一分钟最多生成的图片数）
* IPD（ images per day，一天最多生成的图片数）

### 1.4 不同模型的 Rate Limits 指标

| 模型名称                      | Rate Limit指标 | 当前指标                               |
| ------------------------- | ------------ | ---------------------------------- |
| 语言模型(Chat)                | RPM、 TPM     | RPM=1000-10000 TPM=50000-5000000   |
| 向量模型(Embedding)           | RPM、 TPM     | RPM:2000-10000 TPM:500000-10000000 |
| 重排序模型(Reranker)           | RPM、 TPM     | RPM:2000 TPM:500000                |
| 图像生成模型(Image)             | IPM、IPD      | IPM:2  IPD:400                     |
| 多模态模型 (Multimodal Models) | -            | -                                  |

Rate Limits 可能会因在任一选项（RPM、RPH、RPD、TPM、TPD、IPM、IPD）中达峰而触发，取决于哪个先发生。
例如，在 RPM 限制为20，TPM 限制为 200K 时，一分钟内，账户向 ChatCompletions 发送了 20 个请求，每个请求有 100个Token ，限制即触发，即使账户在这些 20 个请求中没有发满 200K 个 Token。

<Note>注意：每个模型的Rate Limits 可以通过[模型广场](https://cloud.siliconflow.cn/me/models)进行查询。</Note>

### 1.5 Rate Limits 主体

1. Rate Limit是在用户账户级别定义的，而不是密钥（API key）维度。
2. 每个模型**单独设置  Rate Limits**，一个模型请求超出  Rate Limits 不影响其他模型正常使用。

## 2. Rate Limits 规则

* 当前免费模型 Rate Limits 指标是固定值，收费模型根据账户[用量级别](https://account.siliconflow.cn/user/settings)有不同的 [Rate Limits 指标](https://cloud.siliconflow.cn/models)。
* 同一用量级别下，模型类别不同、模型参数量不同，Rate Limits 峰值不同。

### 2.1 免费模型Rate Limits

1. **[实名认证](/faqs/authentication)后使用全部的免费模型。**
2. **免费模型调用免费**，账户的[费用账单](https://cloud.siliconflow.cn/bills)中看到此类模型的费用为调用消耗是 0。
3. **免费模型的 Rate Limits 固定**。对于部分模型，平台同时提供**免费版**和**收费版**。免费版按照原名称命名；收费版会在**名称前加上“Pro/”以示区分**。例如，Qwen2.5-7B-Instruct 的免费版命名为“Qwen/Qwen2.5-7B-Instruct”，收费版则命名为“Pro/Qwen/Qwen2.5-7B-Instruct”。

### 2.2 收费模型 Rate Limits

1. 按照用量付费。API 调用消耗**计入**账户[费用账单](https://cloud.siliconflow.cn/bills)。
2. 根据账户**用量级别**进行分层  Rate Limits 。 Rate Limits 峰值随着用量级别提升而增大。
3. 同一用量级别下，模型类别不同、模型参数量大小不同， Rate Limits 峰值不同。

### 2.3 用户用量级别与 Rate Limits

平台依据账户每月消费金额将其划分为不同的用量级别，每个级别有各自的  Rate Limits 标准。月消费达到更高级别标准时，自动升级至相应用量级别。升级立即生效，并提供更宽松的  Rate Limits。

* **月消费金额**：包含充值金额消费和赠送金额在内的账户每个月的总[消费金额](https://cloud.siliconflow.cn/bills)。
* **级别设置**：比较**上个自然月**和**当月 1 号到今日**的消费金额，取最高值换算成对应的用量级别。新用户注册后初始用量级别为L0。

| 用量级别 | 资质（单位：人民币元）                    |
| ---- | ------------------------------ |
| L0   | 上月或当月消费金额最高值 \< ¥50            |
| L1   | ¥50 ≤ 上月或当月消费金额最高值 \< ¥200     |
| L2   | ¥200 ≤ 上月或当月消费金额最高值 \< ¥2000   |
| L3   | ¥2000 ≤ 上月或当月消费金额最高值 \< ¥5000  |
| L4   | ¥5000 ≤ 上月或当月消费金额最高值 \< ¥10000 |
| L5   | ¥10000 ≤ 上月或当月消费金额最高值          |

### 2.4 具体模型的 Rate Limits

平台目前提供文本生成、图像生成、向量化、重排序和语音五大类，具体模型的  Rate Limits 指标在[模型广场](https://cloud.siliconflow.cn/models)中查看。

## 3. 超出 Rate Limits 处理

### 3.1 超出 Rate Limits 报错信息

如果超出  Rate Limits 调用限制，用户的 API 请求将会因为超过  Rate Limits 而失败。用户需要等待一段时间待满足  Rate Limits 条件后方能再次调用。对应的 HTTP 错误信息为：

```shell  theme={null}
    HTTP/1.1 429
    Too Many Requests
    Content Type: application/json
    Request was rejected due to rate limiting. If you want more, please contact contact@siliconflow.cn
```

### 3.2 超出 Rate Limits 处理方式

* 在已有的Rate Limits下，可以参考 [超出  Rate Limits 处理](https://github.com/siliconflow/siliconcloud-cookbook/blob/main/examples/how-to-handle-rate-limit-in-siliconcloud.ipynb)
  进行错误回避。
* 也可以通过提升用量级别来提升模型  Rate Limits 峰值，业务目标。

## 4. 如何提升模型 Rate Limits 指标

* 根据用量自动升级：您可以通过提高用量来增加[月消费金额](https://cloud.siliconflow.cn/bills)，满足下一级别资质时，会自动升级。
* 购买等级包快速提升：如果您需要**快速达到**更高用量级别、提高  Rate Limits 峰值，请[联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd17aubjk20jc73ada8ng)。


# 在编程工具中使用本文档
Source: https://docs.siliconflow.cn/cn/userguide/use-docs-with-cursor



SiliconFlow 文档站支持 [llms.txt 协议](https://llmstxt.org/)，既可供用户直接查阅，也可无缝对接各类支持该协议的工具进行使用。<br />
考虑到部分用户可能对  [llms.txt 协议](https://llmstxt.org/) 不够熟悉，下面将简要介绍使用流程及相关概述。

## 1. 在 Cursor 中使用本文档

### 1.1 在 Cursor 中增加 SiliconFlow 模型

* 进入 Cursor 设置的 Models 页面，在 Models Names 列表底部输入框填写 SiliconFlow 平台的模型名称，点击`Add model`添加模型；
* 在 Models Names 列表中打开刚刚填入的模型开关；
* 在 OpenAI API Key 中 填写 SiliconFlow API Base URL 和 SiliconFlow API Key，点击 Verify 验证成功。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c5e9d057a098bd4b44cfeca0099158f4" data-og-width="2272" data-og-height="2204" data-path="images/usercases/genai-tools/cursor.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=917eee58a4e7c283f7c4cb9c3aec0a82 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=67bb456ade18fa1ea97fd8734298083d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=16d62e3172250992cf618fd815a85580 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4c3413fa8a185461198d53f5f87fea77 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=17733a1e20795d897d065f48d3f71231 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=39c9279cc2a134209fcadf867a1c9c65 2500w" />
</Frame>

### 1.2 在 Cursor 中配置 SiliconFlow 文档

配置 `Cursor` 的 `@Docs` 数据源，可以很方便的将本文档丢给 `Cursor` 使用。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5acb9a2e680c796373b85fba3081e86e" data-og-width="1268" data-og-height="1012" data-path="images/usercases/genai-tools/cursor-1.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=10af45a975a34b6e6c67fcfd8b1d9514 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e8d341e91dce3b26d7adda57c5dfacd1 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=01d55a665ab9b2574559c182ddfc385c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c16a4ef8a06444979b545bb2e926a518 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=01d399ff76f89a7de17a5ac61aad7cdb 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-1.jpeg?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cecdae378049b9bddbe0210dd5968b89 2500w" />
</Frame>

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=75a80226da5e82a6dc1a4214eeeb9f50" data-og-width="2728" data-og-height="1460" data-path="images/usercases/genai-tools/cursor-3.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7b542d5c8b9706af886d19e9332721e5 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4277c8d527e534b7b7a68157002da092 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ee06eba3f1bdce31ba2607f7a82d032f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3a759b6ed2333446aeb7406b0a5c8c0e 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4146b48fcdbf2e6aedf1c1333cf995bf 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/genai-tools/cursor-3.jpeg?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=633b5d1af43ccd584d90c1526a093c8d 2500w" />
</Frame>

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e2d1fba1a4f7bfd8dec8eb00d3a1496d" data-og-width="1728" data-og-height="794" data-path="images/usercases/genai-tools/cursor-4.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=cc21faf1da333621f6eff611f0136d00 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=818a81c4549fdbd8054ae3cb79b9c866 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=21755069d3490a1a90f98da51793e1be 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b3b97346ffe4e33465c506e7207132e3 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9c7d497ac675d3dae3556463f2284237 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-4.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f5ab53684355c34e619c0ebdd0d402ee 2500w" />
</Frame>

### 1.3 在 Cursor 中使用文档

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=37d5a9df7f603aaeba680fc40f0526c6" data-og-width="1232" data-og-height="1804" data-path="images/usercases/genai-tools/cursor-5.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f7ae6dfdf5097badb13d4d1f5c20b1ba 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d2ae754db193a4e2d90cf9887bcd3160 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=163c0790526a3e2f59776385c0fb1736 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=51e9356906d52b0e35dc116d59191bd7 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=41de5cd93273d71266b59b6085926cf9 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/cursor-5.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=79697d95d6f476d5a68367b31f16413b 2500w" />
</Frame>

## 2. 关于 llmx.txt 的相关介绍 

### 2.1 协议背景

llms.txt 是一种新兴的 Web 标准，旨在帮助大型语言模型（LLMs）更有效地访问和理解网站内容。通过在网站根目录下创建 llms.txt 文件，网站所有者可以为 AI 系统提供清晰的导航和指引，从而提升信息检索的效率。

### 2.2 文件结构：

llms.txt 文件采用 Markdown 格式，通常包含以下部分：

1. 标题：网站名称或项目名称。
2. 描述（可选）：对网站或项目的简要介绍。
3. 详细信息（可选）：提供更多背景信息或链接到其他文档。
4. 章节：列出网站的重要部分，每个部分包含链接和可选的详细说明。

示例如下（参考：[https://docs.siliconflow.cn/llms.txt](https://docs.siliconflow.cn/llms.txt) 和 [https://docs.siliconflow.cn/llms-full.txt](https://docs.siliconflow.cn/llms-full.txt) 文件)

```markdown  theme={null}
# SiliconFlow

## Docs
- [创建语音转文本请求](https://docs.siliconflow.cn/api-reference/audio/create-audio-transcriptions): Creates an audio transcription.
- [创建文本转语音请求](https://docs.siliconflow.cn/api-reference/audio/create-speech): 从输入文本生成音频。根据输入的文本生成音频。接口生成的数据为音频的二进制数据，需要使用者自行处理。参考：https://docs.siliconflow.cn/capabilities/text-to-speech#5
- [删除参考音频](https://docs.siliconflow.cn/api-reference/audio/delete-voice): 删除用户预置音色
- [上传参考音频](https://docs.siliconflow.cn/api-reference/audio/upload-voice): 上传用户预置音色，支持以 base64 编码或者文件形式上传，参考https://docs.siliconflow.cn/capabilities/text-to-speech#2-2)
- [参考音频列表获取](https://docs.siliconflow.cn/api-reference/audio/voice-list): 获取用户预置音色列表
...
```

### 2.3 文件作用

#### 2.3.1 /llms.txt：

* 大规模人工智能友好导航：该文件提供了整个文档导航的简化视图，使 Cursor 或 ChatGPT 等 LLM 可以更轻松地索引您的内容。
* 将其视为人工智能的搜索引擎优化--用户现在可以直接通过通用的 LLM 找到特定产品的信息。

#### 2.3.2 /llms-full.txt：

* 文件会将所有文档文本编译成一个标记符文件，便于人工智能工具基于该文件将信息直接载入其上下文窗口。
* 可以将文档输入到 Cursor 等人工智能编码助手中，让它们根据您产品的具体细节提供上下文感知建议。

### 2.4 与现有标准的区别：

虽然 llms.txt 与 robots.txt 和 sitemap.xml 等现有标准在功能上有所重叠，但它们的目的和作用不同：

* robots.txt：用于指示搜索引擎爬虫哪些页面可以或不可以抓取，主要关注访问权限控制。
* sitemap.xml：提供网站的结构地图，帮助搜索引擎了解网站的页面布局，主要用于索引目的。
* llms.txt：为大型语言模型提供结构化的内容概述，帮助 AI 系统更好地理解和处理网站信息，提升与 AI 交互的效果。

## 3. 在其他工具中使用

其他平台如果支持[llms.txt 协议](https://llmstxt.org/)，也可以直接使用。
比如在 ChatGPT 中使用：

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2a08d81ff5d8eada9ebbd96f8a456c3c" data-og-width="900" data-og-height="1376" data-path="images/usercases/genai-tools/gpt-1.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=711f9c84f7fec6a923fd5d0a7a319d01 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=41873fdffd15d0fec5f4c19fb6676956 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a9e054934510cea357b8adecb267904a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=cf229f73e36dd8a84bd7865804e2499e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ab6122fbea2d47fa2975aa8df7a1afcf 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c9c2da5644c866c6d8ae19503d9ecffa 2500w" />
</Frame>

## 4. 扩展阅读

1. The /llms.txt file, [https://llmstxt.org/](https://llmstxt.org/)
2. @Docs, [https://docs.cursor.com/context/@-symbols/@-docs](https://docs.cursor.com/context/@-symbols/@-docs)
3. LLMs.txt：AI时代的站点地图, [https://juejin.cn/post/7447083753187328050](https://juejin.cn/post/7447083753187328050)


# 主体变更协议
Source: https://docs.siliconflow.cn/cn/legals/agreement-for-account-ownership-transfer

更新日期：2025年2月12日

在您正式提交账号主体变更申请前，请您务必认真阅读本协议。**<u>本协议将通过加粗或加下划线的形式提示您特别关注对您的权利及义务将产生重要影响的相应条款。</u>** 如果您对本协议的条款有疑问的，请向[contact@siliconflow.cn](mailto:contact@siliconflow.cn)咨询，如果您不同意本协议的内容，或者无法准确理解 SiliconFlow 平台（本平台）对条款的解释，请不要进行后续操作。

当您通过网络页面直接确认、接受引用本页面链接及提示遵守内容、签署书面协议、以及本平台认可的其他方式，或以其他法律法规或惯例认可的方式选择接受本协议，即表示您与本平台已达成协议，并同意接受本协议的全部约定内容。自本协议约定的生效之日起，本协议对您具有法律约束力。

**<u>请您务必在接受本协议，且确信通过账号主体变更的操作，能够实现您所希望的目的，且您能够接受因本次变更行为的相关后果与责任后，再进行后续操作。</u>**

## 一、定义和解释

1.1 “本平台官网”：是指包含域名为[https://siliconflow.cn的网站。](https://siliconflow.cn的网站。)

1.2 “本平台账号”：是指本平台分配给注册用户的数字ID，以下简称为“本平台账号”、“账号”。

1.3 “本平台账号持有人”，是指注册、持有并使用本平台账号的用户。

已完成实名认证的账号，除有相反证据外，本平台将根据用户的实名认证信息来确定账号持有人，如用户填写信息与实名认证主体信息不同的，以实名认证信息为准；未完成实名认证的账号，本平台将根据用户的填写信息，结合其他相关因素合理判断账号持有人。

1.4 “账号实名认证主体变更”：是指某一本平台账号的实名认证主体（原主体），变更为另一实名认证主体（新主体），本协议中简称为“账号主体变更”。

1.5 本协议下的“账号主体变更”程序、后果，仅适用于依据账号原主体申请发起、且被账号新主体接受的本平台账号实名认证主体变更情形。

## 二. 协议主体、内容与生效

**2.1** 本协议是特定本平台账号的账号持有人（“您”、“原主体”）与本平台之间，就您申请将双方之前就本次申请主体变更的本平台账号所达成的《SiliconFlow平台产品用户协议》的权利义务转让给第三方，及相关事宜所达成的一致条款。

**<u>2.2 本协议为附生效条件的协议，仅在以下四个条件同时满足的情况下，</u>** 才对您及本平台产生法律效力：

2.2.1 您所申请变更的本平台账号已完成了实名认证，且您为该实名认证主体；

2.2.2 本平台审核且同意您的账号主体变更申请；

2.2.3 您申请将账号下权利义务转让给第三方（“新主体”），且其同意按照《SiliconFlow平台产品用户协议》的约定继续履行相应的权利及义务；

2.2.4 新主体仅为企业主体，不能为自然人主体。

**<u>2.3 您与新主体就账号下所有的产品、服务、资金、债权、债务等（统称为“账号下资源”）转让等相关事项，由您与新主体之间另外自行约定。但如果您与新主体之间的约定如与本协议约定冲突的，应优先适用本协议的约定。</u>**

## 三. 变更的条件及程序

**3.1** 本平台仅接受符合以下条件下的账号主体变更申请；

3.1.1 由于原账号主体发生合并、分立、重组、解散、死亡等原因，需要进行账号主体变更的；

3.1.2 根据生效判决、裁定、裁决、决定等生效法律文书，需要账号主体变更的；

3.1.3 账号实际持有人与账号实名认证主体不一致，且提供了明确证明的；

3.1.4 根据法律法规规定，应当进行账号主体变更的；

3.1.5 本平台经过审慎判断，认为可以进行账号主体变更的其他情形。

**3.2** 您发起账号主体变更，应遵循如下程序要求：

3.2.1 您应在申请变更的本平台账号下发起账号主体变更申请；

3.2.2 本平台有权通过手机号、人脸识别等进行二次验证、要求您出具授权证明（当您通过账号管理人发起变更申请时）、以及其他本平台认为有必要的材料，确认本次申请账号主体变更的行为确系您本人意愿；

3.2.3 您应同意本协议的约定，接受本协议对您具有法律约束力；

3.2.4 您应遵守与账号主体变更相关的其他本平台规则、制度等的要求。

**<u>3.3 您理解并同意，</u>**

**<u>3.3.1 在新主体确认接受且完成实名认证前，您可以撤回、取消本账号主体变更流程；</u>**

**<u>3.3.2 当新主体确认接受且完成实名认证后，您的撤销或取消请求本平台将不予支持；</u>**

**<u>3.3.3 且您有义务配合新主体完成账号管理权的转交。</u>**

**<u>3.3.4 在您进行实名认证主体变更期间，本账号下的登录和操作行为均视为您的行为，您应注意和承担账号的操作风险。</u>**

**<u>3.4 您理解并同意，如果发现以下任一情形的，本平台有权随时终止账号主体变更程序或采取相应处理措施：</u>**

**<u>3.4.1 第三方对该账号发起投诉，且尚未处理完毕的；</u>**

**<u>3.4.2 该账号正处于国家主管部门的调查中；</u>**

**<u>3.4.3 该账号正处于诉讼、仲裁或其他法律程序中；</u>**

**<u>3.4.4 该账号下存在与本平台的信控关系、伙伴关系等与原主体身份关联的合作关系的；</u>**

**<u>3.4.5 存在其他可能损害国家、社会利益，或者损害本平台或其他第三方权利的情形的；</u>**

**<u>3.4.6 该账号因存在频繁变更引起的账号纠纷或账号归属不明确的情形。</u>**

## 四. 账号主体变更的影响

**4.1** 当您的账号主体变更申请经本平台同意，且新主体确认并完成实名认证后，该账号主体将完成变更，变更成功以本平台系统记录为准，变更成功后会对您产生如下后果：

**<u>4.1.1您本账号下的权益转让给变更后的实名主体，权益包括不限于账号控制权、账号下已开通的服务、账号下未消耗的充值金额等；</u>**

4.1.2 该账号及该账号下的全部资源的归属权全部转由新主体拥有。**<u>但本平台有权终止，原主体通过该账号与本平台另行达成的关于优惠政策、信控、伙伴合作等相关事项的合作协议，或与其他本平台账号之间存在的关联关系等；</u>**

**<u>4.1.3 本平台不接受您以和新主体之间的协议为由或以其他理由，要求将该账号下一项或多项业务、权益转移给您指定的其他账号的要求；</u>**

**<u>4.1.4 本平台有权拒绝您以和新主体之间存在纠纷为由或以其他理由，要求撤销该账号主体变更的请求；</u>**

**<u>4.1.5 本平台有权在您与新主体之间就账号管理权发生争议或纠纷时，采取相应措施使得新主体获得该账号的实际管理权。</u>**

**<u>4.2 您理解并确认，账号主体变更并不代表您自变更之时起已对该账号下的所有行为和责任得到豁免或减轻：</u>**

**<u>4.2.1 您仍应对账号主体变更前，该账号下发生的所有行为承担责任；</u>**

**<u>4.2.2 您还需要对于变更之前已经产生，变更之后继续履行的合同及其他事项，对新主体在变更之后的履行行为及后果承担连带责任。</u>**

## 五. 双方权利与义务

**5.1** 您应承诺并保证，

5.1.1 您在账号主体变更流程中所填写的内容及提交的资料均真实、准确、有效，且不存在任何误导或可能误导本平台同意接受该项账号主体变更申请的行为；

5.1.2 您不存在利用本平台的账号主体变更服务进行任何违反法律、法规、部门规章和国家政策等，或侵害任何第三方权利的行为；

**<u>5.1.3 您进行账号主体变更的操作不会置本平台于违约或者违法的境地。因该账号主体变更行为而产生的任何纠纷、争议、损失、侵权、违约责任等，本平台不承担法律明确规定外的责任。</u>**

**<u>您进一步承诺，如上述原因给本平台造成损失的，您应向本平台承担相应赔偿责任。</u>**

**5.2** 您理解并同意，

5.2.1 本平台有权在您发起申请后的任一时刻，要求您提供书面材料或其他证明，证明您有权进行变更账号主体的操作；

5.2.2 本平台有权依据自己谨慎的判断来确定您的申请是否符合法律法规或政策的规定及账号协议的约定，如存在违法违规或其他不适宜变更的情形的，本平台有权拒绝；

5.2.3 本平台有权记录账号实名认证主体变更前后的账号主体、交易流水、合同等相关信息，以遵守法律法规的规定，以及维护自身的合法权益；

5.2.4 如果您存在违反本协议第5.1条的行为的，本平台一经发现，有权直接终止账号主体变更流程，或者撤销已完成的账号主体变更操作，将账号主体恢复为没有进行变更前的状态。

## 六. 附则

**6.1** 您理解并接受，本协议的订立、执行和解释及争议的解决均应适用中华人民共和国法律，与法律规定不一致或存在冲突的，该不一致或冲突条款不具有法律约束力。

**6.2** 就本协议内容或其执行发生任何争议，双方应进行友好协商；协商不成时，任一方均可向被告方所在地有管辖权的人民法院提起诉讼。

**6.3** 本协议如果与双方以前签署的有关条款或者本平台的有关陈述不一致或者相抵触的，以本协议约定为准。

**<u>您在此再次保证已经完全阅读并理解了上述《申请账号主体变更协议》，并自愿正式进入账号主体变更的后续流程，接受上述条款的约束。</u>**


# 隐私政策
Source: https://docs.siliconflow.cn/cn/legals/privacy-policy

更新日期：2025.10.11

欢迎您使用SiliconFlow高性价比的GenAI开放平台。北京硅基流动科技有限公司及其关联方（**“硅基流动”或“我们”**）非常重视用户（**“您”**）信息的保护。您在注册、登录、使用[https://siliconflow.cn（“本平台”）时，我们依据本隐私政策使用您的相关数据信息。](https://siliconflow.cn（“本平台”）时，我们依据本隐私政策使用您的相关数据信息。)

如我们的服务可能包含指向第三方网站、应用程序或服务的链接，本政策不适用于第三方提供的任何产品、服务、网站或内容。如您（或您的公司等经营实体）借助我们的产品或服务为您（或您的公司等经营实体）的客户提供服务，您（或您的公司等经营实体）需要自行制定符合交易场景及相关法律的隐私政策。如您（或您的公司等经营实体）同意借用我们的产品或服务访问第三方网站、应用程序或服务的链接，您（或您的公司等经营实体）需要自行遵守第三方网站、应用程序或服务的相关政策。

我们希望通过本隐私政策向您介绍我们对您的用户信息和交互数据的处理方式。在您开始使用我们的服务前，请您务必先仔细阅读和理解本政策，特别应重点阅读我们以粗体标识的条款，确保您充分理解和同意后再开始使用。如果您不同意本隐私政策，您应当立即停止使用服务。当您选择使用服务时，将视为您接受和认可我们按照本隐私政策对您的相关信息进行处理。

# 概述

本隐私政策将帮助您了解：

1. 我们如何收集和使用您的用户信息
2. 对Cookie和同类技术的使用
3. 我们如何存储您的用户信息
4. 我们如何共享、转让、公开披露您的信息
5. 我们如何保护您的信息安全
6. 我们如何管理您的用户信息
7. 未成年人使用条款
8. 隐私政策的修订和通知
9. 适用范围

## 1. 我们如何收集和使用您的用户信息

### 1.1 我们主动收集您的用户信息

为了保证您正常使用我们的平台，且在法律允许的情况下，我们会在如下场景和业务活动中收集您在使用服务时主动提供的信息，以及我们通过自动化手段收集您在使用服务过程中产生的信息（**“用户信息”**）<sup><a href="#fn1" id="ref1">1</a></sup>，包括但不限于您主动提供的个人信息。特别提示您注意，如信息无法单独或结合其他信息识别到您的个人身份且与您无关，其不属于法律意义上您的个人信息；当您的信息可以单独或结合其他信息识别到您的个人身份或与您有关时，或我们将无法与任何特定用户建立联系的数据与其他您的用户信息结合使用时，则在结合使用期间，这些信息将作为您的用户信息按照本隐私政策处理与保护。需要澄清的是，个人信息不包括经匿名化处理后的信息。

**1.1.1 您注册、认证、登录本平台账号时**<br />
当您在本平台注册账号时，您可以通过手机号创建账号。我们将通过发送短信验证码来验证您的身份是否有效，收集这些信息是为了帮助您完成注册和登录。 如果您使用其他平台的账号登录本平台，您授权我们获得您其他平台账号的相关信息，例如微信等第三方平台的账户/账号信息（包括但不限于名称、头像以及您授权的其他信息）。

**1.1.2 您订购及开通使用服务时**<br />
在您订购或开通使用我们提供的任一项服务前，根据中华人民共和国大陆地区（不含中国香港、澳门、台湾地区）相关法律法规的规定，我们需要对您进行实名认证。

(1) 如果您是个人用户，您可能需要提供您的真实身份信息，包括真实姓名、身份证件号码、身份证件正反面照片、中国银联成员机构I类银行账户卡号或 信用卡 号、银行预留手机号码等信息以完成实名认证。

(2) 如果您是单位用户，您可能需要提供您的相关信息，包括您的主体名称、统一社会信用代码、就注册账号所出具的授权委托书（加盖单位公章）、法人或组织的登记/资格证明（证件类型包括：企业营业执照、组织机构代码证、事业单位法人证书、社会团体法人登记证书、行政执法主体资格证等）、开户行、开户行账号（中国银联成员机构I类银行账户或信用卡号）、法定代表人或被授权人姓名、身份证件号码、身份证件正反面照片、法定代表人证件照片等信息以完成实名认证。另外，您可能需要提供企业联系人的个人信息，包括姓名、手机号码、电子邮箱。我们可能通过这些信息验证您的用户身份，并向您推广、介绍服务，发送业务通知、开具发票或与您进行业务沟通等。如您提供的上述信息包含第三方的个人信息或用户信息，您承诺并保证您向我们提供这些信息前已经获得了相关权利人的授权许可。

(3) 上述实名认证过程中，如果您通过人脸识别来进行实名认证的，您还需要提供面部特征的生物识别信息，并授权我们通过国家权威可信身份认证机构进行信息核验。

**1.1.3 您使用服务时**<br />

(1) 我们致力于为您提供安全、可信的产品与使用环境，提供优质而可靠的服务与信息是我们的核心目标。为了维护我们服务的正常运行，保护您或其他用户或公众的合法利益免受损失，我们会收集用于维护产品或服务安全稳定运行的必要信息。

(2) 当您浏览或使用本平台时，为了保障网站和服务的正常运行及运营安全，预防网络攻击、侵入风险，更准确地识别违反法律法规或本平台的相关协议、服务规则的情况，我们会收集您的分辨率、时区和语言等设备信息、网络接入方式及类型信息、网页浏览记录。这些信息是我们提供服务和保障服务正常运行和网络安全所必须收集的基本信息。

(3) 为让您体验到更好的服务，并保障您的使用安全，我们可能记录网络日志信息，以及使用本平台及相关服务的频率、崩溃数据、使用情况及相关性能数据信息。

(4) 当您参与本平台调研、抽奖活动时，本平台可能会留存您的账号ID、姓名、地址、手机号、职务身份、产品和服务使用情况等信息，以后续与您取得联系，核实身份信息，并按照有关活动规则为您提供奖励（如有），具体调研、抽奖活动规则与本协议不一致的，以活动规则为准。

(5) 我们可能收集您使用本平台及相关服务而产生的用户咨询记录、报障记录和针对用户故障的排障过程（如通信或通话记录），我们将通过记录、分析这些信息以便更及时响应您的帮助请求，以及用于改进服务。

(6) 合同信息，如果您需要申请线下交付或进行产品测试等，请联系[contact@siliconflow.cn](mailto:contact@siliconflow.cn)。

(7) 为了向您提供域名服务，依据工信部相关要求，我们会收集域名持有者名称、联系人姓名、通讯地址、地区、邮编、电子邮箱、固定电话/手机号码、证件号码、证件照片。您理解并授权我们和第三方域名服务机构使用这些信息资料为您提供域名服务。

(8) 为了向您提供证书中心服务，依据数字证书认证机构相关要求，我们会收集联系人姓名、联系人邮箱、联系人手机号码、企业名称、企业所在城市、企业地址。您理解并授权我们和第三方证书服务机构使用这些信息资料为您提供证书中心服务。

(9) 您知悉并同意，对于您在使用产品及/或服务的过程中提供的您的联系方式（即联系电话及电子邮箱），我们在运营中可能会向其中的一种或多种发送通知，用于用户消息告知、身份验证、安全验证、用户使用体验调研等用途；此外，我们也可能会向在前述过程中收集的手机号码通过短信、电话的方式，为您提供您可能感兴趣的服务、功能或活动等商业性信息的用途，但请您放心，如您不愿接受这些信息，您可以通过手机短信或回复邮件退订方式进行退订，也可以直接与我们联系进行退订。

### 1.2 我们可能从第三方获得的用户信息

为了给您提供更好、更优、更加个性化的服务，或共同为您提供服务，或为了预防互联网欺诈的目的，我们的关联公司、合作伙伴可能会依据法律规定或与您的约定或征得您同意前提下，向我们分享您的信息。我们会根据相关法律法规规定和/或该身份认证功能所必需，采用行业内通行的方式及尽最大的商业努力来保护您用户信息的安全。

### 1.3 收集、使用用户信息目的变更的处理

请您了解，随着我们业务的发展，我们提供的功能或服务可能有所调整变化。原则上，当新功能或服务与我们当前提供的功能或服务相关时，收集与使用的用户信息将与原处理目的具有直接或合理关联。仅在与原处理目的无直接或合理关联的场景下，我们收集、使用您的用户信息，会再次按照法律法规及国家标准的要求以页面提示、交互流程、协议确认方式另行向您进行告知说明。

### 1.4 业务和客户数据

**请您理解，不同于您的用户信息<sup><a href="#fn2" id="ref2">2</a></sup>，本平台将按如下方式使用您的交互数据（定义见下）：**

**1.4.1** 您通过本平台提供的服务与开源模型、第三方网站、软件、应用程序或服务之间进行输入、反馈、修正、加工、存储、上传、下载、分发相关个人资料信息、视频、图像、音频、评论、问题和其他内容、文件、数据和信息等均为您的业务和客户数据（**“交互数据”**），您完全拥有您的交互数据。

**1.4.2** 本平台作为中立的技术服务提供者，只会严格执行您的指示处理您的交互数据，我们及本平台只是作为交互数据的被动技术支持者或渠道，除非法律法规另有规定、依据特定产品规则另行约定或基于您的要求为您提供技术协助进行故障排除或解决技术问题。我们及本平台不会对您的交互数据进行任何非授权的使用或披露，同时亦不会进行任何存储。

**1.4.3** 您应对您的交互数据来源及内容负责，我们提示您谨慎判断数据来源及内容的合法性。您应保证有权授权本平台通过提供技术服务对该等交互数据进行处理，且前述处理活动均符合相关法律法规的要求，不存在任何违法违规、侵权或违反与第三方合同约定的情形，亦不会将数据用于违法违规目的。若因您的交互数据内容或您处理以及您授权本平台处理交互数据行为违反法律法规、部门规章或国家政策而造成的全部结果及责任均由您自行承担。

**1.4.4** 受限于前款规定，若您提供的交互数据包含任何个人信息或需要获得授权后才能使用的信息时（“需授权信息”），您应当自行依法提前向相关信息主体履行告知义务，并取得相关信息主体的单独同意，并保证：

(1)在我们要求时，您能就需授权信息的来源及其合法性提供书面说明和确认；<br />
(2)在我们要求时，您能提供需授权信息的授权范围，包括使用目的，个人信息主体同意您使用本平台对其个人信息进行处理；如您超出该等需授权信息的授权范围或期限时，您应自行负责获得需授权信息授权的范围扩大或延期。<br />
您理解并同意，除非满足上述条件及法律要求的其他义务，您不得向我们提供包含需授权信息的交互数据。<br />
如您违反上述义务，或未按照要求向我们提供合理满意的证明，或我们收到个人信息主体举报或投诉，我们有权单方决定拒绝继续提供技术服务（根据实际情形，包括通过限制相关服务功能，冻结、注销或收回账号等方式），或拒绝按照您的指令处理相关个人信息及其相关的数据，由此产生的全部责任均由您自行承担。

## 2. 对Cookie和同类技术的使用

Cookie和同类技术是互联网中的通用常用技术。当您使用本平台时，我们可能会使用相关技术向您的设备发送一个或多个Cookie或匿名标识符，以收集和存储您的账号信息、搜索记录信息以及登录状态信息。通过Cookie和同类技术可以帮助您省去重复填写账号信息、输入搜索内容的步骤和流程，还可以帮助我们改进服务效率、提升登录和响应速度。

您可以通过浏览器设置拒绝或管理Cookie。但请注意，如果停用Cookie，您有可能无法享受最佳的服务体验，某些功能的可用性可能会受到影响。我们承诺，我们不会将通过Cookie或同类技术收集到的您的用户信息用于本隐私政策所述目的之外的任何其他用途。

## 3. 我们如何存储您的用户信息

### 3.1 信息存储的地点

出于服务专业性考虑，我们可能委托关联公司或其他法律主体向您提供本平台上一项或多项具体服务。我们依照法律法规的规定，将在境内运营本网站和相关服务过程中收集和产生的用户信息存储于中华人民共和国境内。

### 3.2 信息存储的期限

**3.2.1** 我们将仅在为提供本平台及相关服务之目的所必需的期间内保留您的用户信息，但您理解并认可基于不同的服务及其功能需求，必要存储期限可能会有所不同。我们用于确定存储期限的标准包括：

(1) 完成该业务目的需要留存用户信息的时间，包括提供服务，依据法律要求维护相应的交易及业务记录，保证系统和服务的安全，应对可能的用户查询或投诉、问题定位等；

(2) 用户同意的更长的留存期间；

(3) 法律、合同等对保留用户信息的特殊要求等。

**3.2.2** 在您未撤回授权同意、删除或注销账号期间，我们会保留相关信息。超出必要期限后，我们将对您的信息进行删除或匿名化处理，前述情况若法律法规有强制留存要求的情况下，即使您注销您的账户或要求删除您的用户信息，我们亦无法删除或匿名化处理您的用户信息。

## 4.我们如何共享、转让、公开披露您的信息

### 4.1 数据使用过程中涉及的合作方

**4.1.1** 原则

(1) 合法原则：与合作方合作过程中涉及数据使用活动的，必须具有合法目的、符合法定的合法性基础。如果合作方使用信息不再符合合法原则，则其不应再使用您的用户信息，或在获得相应合作性基础后再行使用。

(2) 正当与最小必要原则：数据使用必须具有正当目的，且应以达成目的必要为限。

(3) 安全审慎原则：我们将审慎评估合作方使用数据的目的，对这些合作方的安全保障能力进行综合评估，并要求其遵循合作法律协议。我们会对合作方获取信息的软件工具开发包（SDK）、应用程序接口（API）进行严格的安全监测，以保护数据安全。

**4.1.2** 委托处理
对于委托处理用户信息的场景，我们会与受托合作方根据法律规定签署相关处理协议，并对其用户信息使用活动进行监督。

**4.1.3** 共同处理
对于共同处理用户信息的场景，我们会与合作方根据法律规定签署相关协议并约定各自的权利和义务，确保在使用相关用户信息的过程中遵守法律的相关规定、保护数据安全。

**4.1.4** 合作方的范围
若具体功能和场景中涉及由我们的关联方、第三方提供服务，则合作方范围包括我们的关联方与第三方。

### 4.2 用户信息共同数据处理或数据委托处理的情形

**4.2.1** 本平台及相关服务功能中的某些具体模块或功能由合作方提供，对此您理解并同意，在我们与任何合作方合作中，我们仅会基于合法、正当、必要及安全审慎原则，在为提供服务所最小的范围内向其提供您的用户信息，并且我们将努力确保合作方在使用您的信息时遵守本隐私政策及我们要求其遵守的其他适当的保密和安全措施，承诺不得将您的信息用于其他任何用途。

**4.2.2** 为提供更好的服务，我们可能委托合作方向您提供服务，包括但不限于客户服务、支付功能、实名认证、技术服务等，因此，为向您提供服务所必需，我们会向合作方提供您的某些信息。例如：

(1) 为进行用户实名认证在您使用身份认证的功能或相关服务所需时，根据相关法律法规的规定及相关安全保障要求可能需要完成实名认证以验证您的身份。在实名认证过程中，与我们合作的认证服务机构可能需要使用您的真实姓名、身份证号码、手机号码等。<br />
(2) 支付功能由与我们合作的第三方支付机构向您提供服务。第三方支付机构为提供功能可能使用您的姓名、银行卡类型及卡号、有效期、身份证号码及手机号码等。<br />
(3) 为及时处理您的投诉、建议以及其他诉求，我们的客户服务提供商（若有）可能需要使用您的账号及所涉及的事件的相关信息，以及时了解、处理和相应相关问题。

**4.2.3** 为保障服务安全与分析统计的数据使用

(1) 保障使用安全：我们非常重视账号与服务安全，为保障您和其他用户的账号与财产安全，使您和我们的正当合法权益免受不法侵害，我们和我们的合作方可能需要使用必要的设备、账号及日志信息。<br />
(2) 分析服务使用情况：为分析我们服务的使用情况，提升用户使用的体验，我们和我们的合作方可能需要使用您的服务使用情况（崩溃、闪退）的统计性数据，这些数据难以与其他信息结合识别您的身份或与您的身份相关联。

### 4.3 用户信息的转移

我们不会转移您的用户信息给任何其他第三方，但以下情形除外：

**4.3.1** 基于您的书面请求，并符合国家网信部门规定条件的，我们会向您提供转移的途径。

**4.3.2** 获得您的明确同意后，我们会向其他第三方转移您的用户信息。

**4.3.3** 在涉及本平台运营主体变更、合并、收购或破产清算时，如涉及到用户信息转移，我们会依法向您告知有关情况，并要求新的持有您的信息的公司、组织继续接受本隐私政策的约束或按照不低于本隐私政策所要求的安全标准继续保护您的信息，否则我们将要求该公司、组织重新向您征求授权同意。如发生破产且无数据承接方的，我们将对您的信息做删除处理。

### 4.4 用户信息的公开披露

**4.4.1** 原则上我们不会公开披露您的用户信息，除非获得您明确同意或遵循国家法律法规规定的披露。

(1) 获得您明确同意或基于您的主动选择，我们可能会公开披露您的用户信息；<br />
(2) 为保护您或公众的人身财产安全免遭侵害，我们可能根据适用的法律或本平台相关协议、规则披露关于您的用户信息。

**4.4.2** 征得授权同意的例外

请您理解，在下列情形中，根据法律法规及相关国家标准，我们收集和使用您的用户信息不必事先征得您的授权同意：<br />
(1) 与我们履行法律法规规定的义务相关的；<br />
(2) 与国家安全、国防安全直接相关的；<br />
(3) 与公共安全、公共卫生、重大公共利益直接相关的；<br />
(4) 与刑事侦查、起诉、审判和判决执行等直接相关的；<br />
(5) 出于维护您或他人的生命、财产等重大合法权益但又很难得到本人授权同意的；<br />
(6) 您自行向社会公众公开的信息；<br />
(7) 根据用户信息主体要求签订和履行合同所必需的；<br />
(8) 从合法公开披露的信息中收集的您的信息的，如合法的新闻报道、政府信息公开等渠道；<br />
(9) 用于维护软件及相关服务的安全稳定运行所必需的，例如发现、处置软件及相关服务的故障；<br />
(10) 为开展合法的新闻报道所必需的；<br />
(11) 为学术研究机构，基于公共利益开展统计或学术研究所必要，且对外提供学术研究或描述的结果时，对结果中所包含的个人信息进行去标识化处理的；<br />
(12) 法律法规规定的其他情形。

特别提示您注意，如信息无法单独或结合其他信息识别到您的个人身份，其不属于法律意义上您的个人信息；当您的信息可以单独或结合其他信息识别到您的个人身份时，这些信息在结合使用期间，将作为您的用户信息按照本隐私政策处理与保护。

## 5. 我们如何保护您的信息安全

我们非常重视用户信息的安全，将努力采取合理的安全措施（包括技术方面和管理方面）来保护您的信息，防止您提供的信息被不当使用或未经授权的情况下被访问、公开披露、使用、修改、损坏、丢失或泄漏。 我们会使用不低于行业通行的加密技术、匿名化处理等合理可行的手段保护您的信息，并使用安全保护机制尽可能地降低您的信息遭到恶意攻击的可能性。

我们会有专门的人员和制度保障您的信息安全。我们采取严格的数据使用和访问制度。尽管已经采取了上述合理有效措施，并已经遵守了相关法律规定要求的标准，但请您理解，由于技术的限制以及可能存在的各种恶意手段，在互联网行业，即便竭尽所能加强安全措施，也不可能始终保证信息百分之百的安全，我们将尽力确保您提供给我们的信息的安全性。您知悉并理解，您接入我们的服务所用的系统和通讯网络，有可能因我们可控范围外的因素而出现问题。因此，我们强烈建议您采取积极措施保护用户信息的安全，包括但不限于使用复杂密码、定期修改密码、不将自己的账号密码等信息透露给他人。

我们会制定应急处理预案，并在发生用户信息安全事件时立即启动应急预案，努力阻止该等安全事件的影响和后果扩大。一旦发生用户信息安全事件（泄露、丢失等）后，我们将按照法律法规的要求，及时向您告知：安全事件的基本情况和可能的影响、我们已经采取或将要采取的处置措施、您可自主防范和降低风险的建议、对您的补救措施等。我们将及时将事件相关情况以推送通知、邮件、信函或短信等形式告知您，难以逐一告知时，我们会采取合理、有效的方式发布公告。同时，我们还将按照相关监管部门要求，上报用户信息安全事件的处置情况。

我们谨此特别提醒您，本隐私政策提供的用户信息保护措施仅适用于本平台及相关服务。一旦您离开本平台及相关服务，浏览或使用其他网站、产品、服务及内容资源，我们即没有能力及义务保护您在本平台及相关服务之外的软件、网站提交的任何信息，无论您登录、浏览或使用上述软件、网站是否基于本平台的链接或引导。

## 6. 我们如何管理您的用户信息

我们非常重视对用户信息的管理，并依法保护您对于您信息的查阅、复制、更正、补充、删除以及撤回授权同意、注销账号、投诉举报等权利，以使您有能力保障您的隐私和信息安全。

### 6.1 您在用户信息处理活动中的权利

**6.1.1** 一般情况下，您可以查阅、复制、更正、补充、访问、修改、删除您主动提供的用户信息。

**6.1.2** 在以下情形中，您可以向我们提出删除用户信息的请求：<br />
(1) 如果处理目的已实现、无法实现或者为实现处理目的不再必要；<br />
(2) 如果我们处理用户信息的行为违反法律法规；<br />
(3) 如果我们收集、使用您的用户信息，却未征得您的同意；<br />
(4) 如果我们处理用户信息的行为违反了与您的约定；<br />
(5) 如果我们停止提供产品或者服务，或用户信息的保存期限已届满；<br />
(6) 如果您撤回同意授权；<br />
(7) 如果我们不再为您提供服务；<br />
(8) 法律、行政法规规定的其他情形。

### 6.2 撤回或改变您授权同意的范围

**6.2.1** 您理解并同意，每项服务均需要一些基本用户信息方得以完成。除为实现业务功能收集的基本用户信息外，对于额外收集的用户信息的收集和使用，您可以选择撤回您的授权，或改变您的授权范围。您也可以通过注销账号的方式，撤回我们继续收集您用户信息的全部授权。

**6.2.2** 您理解并同意，当您撤回同意或授权后，将无法继续使用与撤回的同意或授权所对应的服务，且本平台也不再处理您相应的用户信息。但您撤回同意或授权的决定，不会影响此前基于您的授权而开展的用户信息处理。

### 6.3 如何获取您的用户信息副本

我们将根据您的书面请求，为您提供以下类型的用户信息副本：您的基本资料、用户身份信息。但请注意，我们为您提供的信息副本仅以我们直接收集的信息为限。

### 6.4 响应您的请求

您享有注销账号、举报或投诉的权利。为保障安全，您可能需要提供书面请求，并以其它方式证明您的身份。 对于您合理的请求，我们原则上不收取费用。但对多次重复、超出合理限度的请求，我们将视具体情形收取一定成本费用。对于那些无端重复、需要过多技术手段（例如，需要开发新系统或从根本上改变现行惯例）、给他人合法权益带来风险或者不切实际（例如，涉及备份磁带上存放的信息）的请求，我们可能会予以拒绝。<br />
您理解并认可，在以下情形中，我们将无法响应您的请求：<br />
(1) 与我们履行法律法规规定的义务相关的；<br />
(2) 与国家安全、国防安全直接相关的；<br />
(3) 与公共安全、公共卫生、重大公共利益直接相关的；<br />
(4) 与刑事侦查、起诉、审判和执行判决等直接相关的；<br />
(5) 我们有充分证据表明用户信息主体存在主观恶意或滥用权利的；<br />
(6) 出于维护用户信息主体或其他个人的生命、财产等重大合法权益但又很难得到本人同意的；<br />
(7) 响应用户信息主体的请求将导致用户信息主体或其他个人、组织的合法权益受到严重损害的；<br />
(8) 涉及商业秘密的。

### 6.5 停止运营向您告知

如我们停止运营，我们将停止收集您的用户信息，并将停止运营的通知以逐一送达或公告等商业上可行的形式通知您，并对我们所持有的您的用户信息进行删除或匿名化处理。

## 7. 未成年人使用条款

我们的服务主要面向企业或相关组织。未成年人使用本平台应已经获得监护人同意。如果我们发现在未事先获得可证实的监护人同意的情况下提供了用户信息，经未成年人的监护人书面告知后我们会设法尽快删除相关信息。

## 8. 隐私政策的修订和通知

为了给您提供更好的服务，本平台及相关服务将不时更新与变化，我们会适时对本隐私政策进行修订，该等修订构成本隐私政策的一部分并具有等同于本隐私政策的效力。但未经您明确同意，我们不会严重减少您依据当前生效的隐私政策所应享受的权利。<br />
本隐私政策更新后，我们会在本平台公布更新版本，并在更新后的条款生效前通过官方网站公告或其他适当的方式提醒您更新的内容，以便您及时了解本隐私政策的最新版本。如您继续使用本平台及相关服务，视为您同意接受修订后的本隐私政策的全部内容。<br />
对于重大变更，我们还会提供更为显著的通知（包括但不限于电子邮件、短信、系统消息或在浏览页面做特别提示等方式），向您说明本隐私政策的具体变更。<br />
本隐私政策所指的重大变更包括但不限于：<br />
(1) 我们的服务模式发生重大变化。如处理用户信息的目的、处理用户信息的类型、用户信息的使用方式等；<br />
(2) 我们在所有权结构、组织架构等方面发生重大变化。如业务调整、破产并购等引起的所有变更等；<br />
(3) 用户信息传输、转移或公开披露的主要对象发生变化；<br />
(4) 您参与用户信息处理方面的权利及其行使方式发生重大变化；<br />
(5) 我们的联络方式及投诉渠道发生变化时。

## 9. 适用范围

本隐私政策适用于本平台提供产品、服务、解决方案以及公司后续可能不时推出的纳入服务范畴内的其他产品、服务或解决方案。

本隐私政策不适用于有单独的隐私政策且未纳入本隐私政策的第三方通过本平台向您提供的产品或服务（“第三方服务”）。您使用这些第三方服务（包括您向这些第三方提供的任何含用户信息在内的信息），将受这些第三方的服务条款及隐私政策约束（而非本隐私政策），并通过其建立的用户信息主体请求和投诉等机制，提出相关请求、投诉举报，具体规定请您仔细阅读第三方的条款。请您妥善保护自己的用户信息，仅在必要的情况下向第三方提供。

需要特别说明的是，作为本平台的用户，若您利用本平台的技术服务，为您的用户再行提供服务，因您与客户的业务合作所产生的数据属于您所有，您应当与您的用户自行约定相关隐私政策，本隐私政策不作为您与您的用户之间的隐私政策的替代。

***

<sup id="fn1">
  1 <a href="#ref1">↩</a>
  用户信息不同于交互数据。
</sup>

<sup id="fn2">
  2 <a href="#ref2">↩</a>

  | 简要说明 | 用户信息                             | 交互数据                               |
  | ---- | -------------------------------- | ---------------------------------- |
  | 来源   | 基于使用平台功能的目的，于平台注<br />册时由用户提供给平台 | 基于使用模型或软件的目的，由用户通过平台<br />输入给模型或软件 |
  | 存储   | 平台按相关法律法规要求存储                    | 平台不存储                              |
</sup>


# 用户充值协议
Source: https://docs.siliconflow.cn/cn/legals/recharge-policy

更新日期：2025年3月5日

尊敬的用户，为保障您的合法权益，请您在点击“确认支付”按钮前，完整、仔细地阅读本充值协议，当您点击“确认支付”按钮，即表示您已阅读、理解本协议内容，并同意按照本协议约定的规则进行充值和使用余额行为。如您不接受本协议的部分或全部内容，请您不要点击“确认支付”按钮。

## 1. 接受条款

欢迎您使用SiliconFlow平台。以下所述条款和条件为平台充值的用户（以下简称“用户“或“您“）和北京硅基流动科技有限公司（以下简称“硅基流动”）就充值以及余额使用所达成的协议。
当您以在线点击“确认支付”等方式确认本协议或实际进行充值时，即表示您已理解本协议内容并同意受本协议约束，包括但不限于本协议正文及所有硅基流动已经发布的或将来可能发布的关于服务的各类规则、规范、公告、说明和（或）通知等，以及其他各项网站规则、制度等。所有前述规则为本协议不可分割的组成部分，与协议正文具有同等法律效力。
硅基流动有权根据国家法律法规的变化以及实际业务运营的需要不时修改本协议相关内容，并提前公示于软件系统、网站等以通知用户。修改后的条款应于公示通知指定的日期生效。如果您选择继续充值即表示您同意并接受修改后的协议且受其约束；如果您不同意我们对本协议的修改，请立即放弃充值或者停止使用本服务。
请注意，本协议限制了硅基流动的责任，还限制了您的责任，具体条款将以加粗并加下划线的形式提示您注意，硅基流动督促您仔细阅读。如果您对本协议的条款有疑问的，请通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）进行询问，硅基流动将向您解释条款内容。如果您不同意本协议的任意内容，或者无法准确理解硅基流动对条款的解释，请不要同意本协议或使用本协议项下的服务。

## 2. 定义

**2.1** SiliconFlow平台个人充值余额账户：简称“充值余额账户”，指由硅基流动根据用户的SiliconFlow平台账户为用户自动配置的资金账户。用户向该账户充值的行为视为用户向硅基流动预付服务费，预付服务费可用于购买SiliconFlow平台提供的产品或服务。

## 3. 充值条件

当您充值时，您应该具有经实名认证成功后的SiliconFlow平台账户。

## 4. 账户安全

**4.1** 当用户进行充值时，用户应仔细确认自己的账号及信息，若因为用户自身操作不当、不了解或未充分了解充值计费方式等因素造成充错账号、错选充值种类等情形而损害自身权益，应由用户自行承担责任。

**4.2** 用户在充值时使用第三方支付企业提供的服务的，应当遵守与该第三方的各项协议及其服务规则；在使用第三方支付服务过程中用户应当妥善保管个人信息，包括但不限于银行账号、密码、验证码等；用户同意并确认，硅基流动对因第三方支付服务产生的纠纷不承担任何责任。

## 5. 充值方式

**5.1** 用户充值可以选择硅基流动认可的第三方支付企业（目前支持微信支付）支付充值金额。

**5.2** 用户如委托第三方对其消耗账户充值，则用户承诺并保证其了解和信任第三方，且第三方亦了解和同意接受用户委托，为用户充值；否则，如硅基流动被第三方告知该等充值非经第三方同意，则硅基流动有权立即封禁用户的 SiliconFlow 账户（账户封禁期间，硅基流动将暂停用户使用本平台服务，包括不限于用户的 API 请求或任何线上功能，下同）。自用户的消耗账户被封禁之日起30日内，用户应提供充足证据证实第三方事先同意为其充值，否则用户同意并授权硅基流动配合第三方的要求，自用户被锁定的消耗账户中将相应款项退还第三方。如届时用户的消耗账户余额不足以退还，则短缺部分，用户同意最晚在30日内充值相应金额，委托硅基流动退还，或自其微信账户或支付宝账户自行退还，除非第三方同意用户可不退还这部分款项。

**5.3** 用户承诺并保证用于其充值余额账户充值的资金来源的合法性，否则硅基流动有权配合司法机关或其他政府主管机关的要求，对用户的 SiliconFlow 账户进行相应处理，包括但不限于封禁用户的 SiliconFlow 账户等。

## 6. 充值余额和赠送余额

**6.1** 充值余额，是指您进行在线充值并实际支付的金额（人民币），不包括任何形式的赠送金额，可在SiliconFlow 平台消耗使用。

**6.2** 赠送余额，是指根据 SiliconFlow 平台不时推出的充值优惠运营活动，在充值余额以外、额外赠予的金额（包括但不限于邀请奖励等）。赠送余额不可提现、不可转让，不可开具发票。赠送余额将依据对应的活动规则发放并依据平台服务规则使用，硅基流动对赠送金额的可用范围享有最终解释权。

## 7. 充值余额使用

**7.1** 您充值后，充值余额的使用不设有效期，不能转移、转赠。因此，请您根据自己的消耗情况选择充值金额，硅基流动对充值次数不做限制。

**7.2** 充值成功后，通常您可以立即开始使用相应产品（或服务），部分情况下可能存在延迟到账的情况，若较长时间仍未到账您可通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）联系硅基流动的服务支持人员为您处理。

## 8. 发票

硅基流动将在您的充值金额消耗后，按照实际消耗金额，根据您订购的产品（或服务）协议开具相应发票。

## 9. 关于退款

**9.1** 您应充分预估实际需求并确定充值金额。

**9.2** 若您使用在线支付方式（目前为微信支付），通过第三方支付企业进行充值，充值完成后 360 日内，对于尚未消费的余额您可自行操作退款。硅基流动及其合作第三方支付企业将对用户的退款操作进行审核，若审核通过将会按照原支付路径退回，并可能产生相应手续费。

**9.3** 原则上，您的每一笔在线支付充值仅支持一次退款。如遇特殊情况，您可通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）联系硅基流动的服务支持人员为您处理。

**9.4** 您通过对公转账或其他方式充值的金额，不支持自助退款，您可通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）联系硅基流动的服务支持人员，配合提供相关证明材料，硅基流动将在审核完成后将应退金额返回给用户，并可能产生相应手续费。

**9.5** 赠送余额（包括但不限于邀请奖励及同类非现金折扣等）不支持申请退款。

**9.6** 您完成充值并已经消耗的或根据相关产品（或服务）协议应予扣除的，将不予退还。

## 10. 争议解决

本协议适用中华人民共和国大陆地区法律。用户如因本协议与硅基流动发生争议的，双方应首先友好协商解决，如协商不成的，该等争议将由北京市海淀区人民法院管辖。


