# Siliconflow - Other

**Pages:** 49

---

## 硅基流动AI应用合规上架指南

**URL:** llms-txt#硅基流动ai应用合规上架指南

**Contents:**
- 背景依据
- 📌 关键提示
  - 1. 责任提示
  - 2. 平台声明
- 需备案的场景：
  - 1、微信小程序上架场景
- 获取备案信息的操作指引
  - 步骤一：查询模型备案号
  - 步骤二：获取合作协议

硅基流动 MaaS服务平台面向广大开发者提供相关开源大模型加速框架推理等技术支持，开发者开发的应用/小程序中通过硅基流动 MaaS服务平台接入了DeepSeek、通义千问等系列开源大模型。
若开发者想要将接入了开源大模型的应用或小程序上架到应用市场或小程序平台中，因应用市场或小程序平台的应用场景存在差异，可能需要开发者提供各种相关资料，本篇将基于法律合规要求引导各位开发者如何获取对应资料。

1. 建议您研读《生成式人工智能服务管理暂行办法》原文或咨询法律专家
2. 主动追踪政策变化，定期核验最新要求，并依据业务场景寻求专业法律意见
3. 您需独立承担应用/小程序的全部法律责任

1. 备案材料清单与获取路径
2. 所接入模型的备案信息查询指引
3. 不构成任何法律意见

即使使用本站模型服务，您仍是法定“服务提供者”​​，须履行包括：

① 内容审核 ② 用户保护 ③ 数据安全 ④ 标识规范 等全链条义务

<Note>  硅基流动不保证您的小程序或APP 通过该方案可以 100% 通过审核，具体审核规则由对应的审核方负责。硅基流动仅可证明贵方在使用硅基流动的服务。 </Note>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9911081ba5086bfc6c727b8a6f57ee1a" data-og-width="1128" width="1128" data-og-height="1280" height="1280" data-path="images/faqs/mic/guide/image_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=09931b8a8cac790ce78d9748263dd5a7 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=caa50015c76ea2e9b7555e442bfe357d 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6703db80044edac03cd7eba1771808e8 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=864cecee5011339038766eff50e6b3c4 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4af5b228b339e7b77577df1a96af50ae 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_1.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=eebb7fbbd70c5843f0994379817f2d90 2500w" />
</Frame>

查询地址：[https://beian.cac.gov.cn/#/searchResult](https://beian.cac.gov.cn/#/searchResult)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fbe24e633ec1dcd2044bc1281e3a8576" data-og-width="1280" width="1280" data-og-height="289" height="289" data-path="images/faqs/mic/guide/image_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=11d9dae52e5518ed39a3b7862b37fa68 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=abd1b59c3eddca5ec1ba4d2c328dbeb9 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9fe1fa0e1e09fb04b3732f995c8f15b5 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=da989e9e9d269d311f2dd20a3d5b1fb4 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=43bb92b2e1aa90f1900410cafe4eccc0 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_2.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=287ec95b50754fe0fb625b3909cc632e 2500w" />
</Frame>

| 模型名称                  | 备案说明                | 备案号                               | 链接                                                                                                                    |
| --------------------- | ------------------- | --------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| Deepseek Chat         | 生成式人工智能服务备案         | Beijing-DeepseekChat-202404280016 | [https://www.cac.gov.cn/2024-04/02/c\_1713729983803145.htm](https://www.cac.gov.cn/2024-04/02/c_1713729983803145.htm) |
| DeepSeek大语言模型算法       | 深度合成服务算法备案（服务技术支持者） | 网信算备110108970550101240011号        | [https://www.cac.gov.cn/2024-04/11/c\_1714509267496697.htm](https://www.cac.gov.cn/2024-04/11/c_1714509267496697.htm) |
| DeepSeekChat 求索对话生成算法 | 深度合成服务算法备案（服务提供者）   | 网信算备330105747635301240017号        | [https://www.cac.gov.cn/2024-06/12/c\_1719783421546747.htm](https://www.cac.gov.cn/2024-06/12/c_1719783421546747.htm) |

| 大模型  | 算法名称          | 备案主体角色  | 备案主体              | 主要用途                                                           | 备案号                        |
| ---- | ------------- | ------- | ----------------- | -------------------------------------------------------------- | -------------------------- |
| 通义千问 | 达摩院交互式多能型合成算法 | 服务技术支持者 | 阿里巴巴达摩院(杭州)科技有限公司 | 应用于开放域多模态内容生成场景，服务于问答、咨询类的企业端客户，通过API提供根据用户输入生成多模态信息的功能。       | 网信算备330110507206401230035号 |
| 通义万相 | 达摩院图像合成算法     | 服务技术支持者 | 阿里巴巴达摩院(杭州)科技有限公司 | 应用于数字图像处理、计算机视觉、虚拟现实、人工智能等领域，在图像生成、图像增强、图像分割、图像识别等方面具有广泛的应用前景。 | 网信算备330110507206401230027号 |
| 通义万相 | 通义万相视频生成算法    | 服务技术支持者 | 通义云启（杭州）信息技术有限公司  | 应用于视频生成场景，服务于企业端客户，根据用户输入的文本或图像，生成符合广告媒体领域要求的视频。               | 网信算备330106003156001240091号 |

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8c56dc766b0db89584a4670a7f3d3629" data-og-width="1280" width="1280" data-og-height="363" height="363" data-path="images/faqs/mic/guide/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f92cad376ffc60acc32db83d65eb2a3e 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3f1771d6dc7958df220a56bb63de6aa7 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2dc6bff8ebd880e027f3925642955808 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=12642b8e986bae640d2976844570fe07 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7e785cb2f24fe3ea365a560b30978514 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_3.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2b6461bf7585e2c29719cb2ab3e0d930 2500w" />
</Frame>

1. 确保您的账号完成了企业实名认证：认证链接：[https://cloud.siliconflow.cn/account/authentication](https://cloud.siliconflow.cn/account/authentication)
2. 添加我们企微客服：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=46063815ae995279ac25e87c2c2c4395" data-og-width="396" width="396" data-og-height="396" height="396" data-path="images/faqs/mic/guide/image_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=82d3e866a347a455f271748cee4b03f0 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3c52e05cdd759081942c1656b7a759f0 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=89d263e9256b6e347ce9ebd8b25379b1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=62eeb68d4777902298126bf1edb2c370 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5a5439f7122d7300a2906be37cdfdfb0 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/faqs/mic/guide/image_4.png?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3be52a3dc590860972561292164c46f5 2500w" />
</Frame>

3. 按照客服指引填写表单，我们将在 5 个工作日内提供相关合作协议电子签约版本。

1. 您的小程序/应用主体名称，需要和签订合作协议以及硅基流动账号实名认证企业为同一个，不进行硅基流动企业实名认证则无法提供相应协议。
2. 准确填写您的小程序应用场景和应用模型，将有助于您通过审核。

[https://www.moj.gov.cn/pub/sfbgw/flfggz/flfggzbmgz/202401/t20240109\_493171.html](https://www.moj.gov.cn/pub/sfbgw/flfggz/flfggzbmgz/202401/t20240109_493171.html)

2. 《具有舆论属性或社会动员能力的互联网信息服务安全评估规定》

[https://www.gov.cn/zhengce/zhengceku/2018-11/30/content\_5457763.htm](https://www.gov.cn/zhengce/zhengceku/2018-11/30/content_5457763.htm)

[https://www.gov.cn/zhengce/zhengceku/2022-01/04/content\_5666429.htm](https://www.gov.cn/zhengce/zhengceku/2022-01/04/content_5666429.htm)

---

## 流式输出

**URL:** llms-txt#流式输出

**Contents:**
  - 5.3 音频理解
- 6. 计费说明
  - 6.1 视觉输入计费
  - 6.2 视频输入计费
  - 6.3 音频输入计费
- 7. 最佳实践
  - 7.1 性能优化
  - 7.2 使用建议
  - 7.3 常见问题

for chunk in response:
    content = chunk.choices[0].delta.content
    if content:
        print(content, end='', flush=True)
python  theme={null}
response = client.chat.completions.create(
    model="Qwen/Qwen3-Omni-30B-A3B-Instruct",
    messages=[
        {
            "role": "user",
            "content": [
                {
                    "type": "audio_url",
                    "audio_url": {
                        "url": "data:audio/wav;base64,UklGRnoGAABXQVZFZm10IBAAAAABAAEA..."
                    }
                },
                {
                    "type": "text",
                    "text": "这段音频的主要内容和情感基调是什么？"
                }
            ]
        }
    ]
)
```

不同模型的视觉内容转换方式不同。下表对比展示核心规则与计费口径：

| 模型系列           | 尺寸/像素约束                                              | detail=low                | detail=high                               | Token 计算方式                           |
| -------------- | ---------------------------------------------------- | ------------------------- | ----------------------------------------- | ------------------------------------ |
| Qwen 系列        | 最小 `56×56`，最大 `3584×3584`；按 `28` 的倍数取整到区间            | 统一 `448×448`，≈`256 token` | 长宽先上取整到 `28` 的倍数，再等比裁剪到区间                 | `ceil(h/28) * ceil(w/28)`            |
| DeepseekVL2 系列 | 以 `384×384` 为基块；`1 ≤ h*w ≤ 9` 的 `(h,w)` 块数           | 统一 `384×384`，`421 token`  | 按 `(h*384, w*384)` 放缩，选择有效像素最大且无效像素更小的组合  | `(h*w + 1) * 196 + (w + 1) * 14 + 1` |
| GLM 系列         | 最小 `28×28`；按 `28` 的倍数取整到区间；若小于 `112×112` 或超出上限则回压到区间 | 统一 `448×448`，≈`256 token` | 长宽取最近 `28` 倍数并限制在 `(12544, 4816894)` 像素区间 | `(h/28) * (w/28)`                    |

* `h,w` 为最终用于计费的像素尺寸；表中 token 为视觉输入侧的估算，实际账单以请求时的最终转换结果为准。

视频内容根据提取的帧数转换为 tokens：

* 最终帧数 = `min(fps × 视频时长, max_frames)`
* 每帧图像按对应视觉模型的标准转换

音频内容转换为 tokens 进行计费，对于 Qwen3 omni 多模态模型，输入音频每秒对应 13 个 token，  如 22.5s 音频对应 292 个 token。

1. **视频时长控制**：建议 30 秒内以获得最佳分析效果
2. **帧数选择**：`max_frames=8-16`，`fps=1-2` 通常足够
3. **图像尺寸**：根据模型推荐尺寸进行预处理

1. **逐步分析**：复杂任务分解为多个简单步骤
2. **多模态组合**：充分利用不同类型媒体的优势
3. **错误处理**：检查媒体文件可访问性和格式兼容性

**Q: 文件大小限制？**
A: 建议音频视频文件保持适中大小，超大文件可能影响性能

**Q: 可以同时处理多少个媒体文件？**
A: 可以在同一请求中包含多个媒体 URL，但建议控制总体数据量

**Q: 帧提取策略？**
A: 对于长视频，合理设置`fps`和`max_frames`参数以获得最优的分析效果和成本平衡

**Examples:**

Example 1 (unknown):
```unknown
### 5.3 音频理解
```

---

## 发送带有流式输出的请求

**URL:** llms-txt#发送带有流式输出的请求

content = ""
reasoning_content=""
messages = [
    {"role": "user", "content": "奥运会的传奇名将有哪些？"}
]
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=True,  # 启用流式输出
    max_tokens=4096,
    extra_body={
        "thinking_budget": 1024
    }
)

---

## 逐步接收并处理响应

**URL:** llms-txt#逐步接收并处理响应

for chunk in response:
    if chunk.choices[0].delta.content:
        content += chunk.choices[0].delta.content
    if chunk.choices[0].delta.reasoning_content:
        reasoning_content += chunk.choices[0].delta.reasoning_content

---

## 打印流式返回信息

**URL:** llms-txt#打印流式返回信息

**Contents:**
- 2. curl 中使用流式输出

if response.status_code == 200:
    full_content = ""
    full_reasoning_content = ""

for chunk in response.iter_lines():
        if chunk:
            chunk_str = chunk.decode('utf-8').replace('data: ', '')
            if chunk_str != "[DONE]":
                chunk_data = json.loads(chunk_str)
                delta = chunk_data['choices'][0].get('delta', {})
                content = delta.get('content', '')
                reasoning_content = delta.get('reasoning_content', '')
                if content:
                    print(content, end="", flush=True)
                    full_content += content
                if reasoning_content:
                    print(reasoning_content, end="", flush=True)
                    full_reasoning_content += reasoning_content
else:
    print(f"请求失败，状态码：{response.status_code}")

bash  theme={null}
curl -N -s \
  --request POST \
  --url https://api.siliconflow.cn/v1/chat/completions \
  --header 'Authorization: Bearer token' \
  --header 'Content-Type: application/json' \
  --data '{
    "model": "Qwen/Qwen2.5-72B-Instruct",
    "messages": [
      {"role":"user","content":"有诺贝尔数学奖吗？"}
    ],
    "stream": true
}'
```

**Examples:**

Example 1 (unknown):
```unknown
## 2. curl 中使用流式输出

curl 命令的处理机制默认情况下，curl 会缓冲输出流，所以即使服务器分块（chunk）发送数据，也需要等缓冲区填满或连接关闭后才看到内容。传入 `-N`（或 `--no-buffer`）选项，可以禁止此缓冲，让数据块立即打印到终端，从而实现流式输出。
```

---

## 用户协议

**URL:** llms-txt#用户协议

**Contents:**
- 1. 账户管理
- 2. 访问服务及服务限制
- 3. 交互数据
- 4. 知识产权
- 5. 保密信息
- 6. 计费政策及税费
- 7. 隐私与数据安全
- 8. 使用第三方服务
- 9. 赔偿
- 10. 免责声明

Source: https://docs.siliconflow.cn/cn/legals/terms-of-service

这是您与北京硅基流动科技有限公司及其关联方（**“硅基流动”**或**“我们”**）之间的协议（**“本协议”**），您确认：在您开始试用或购买我们 SiliconFlow 平台（**本平台**）的产品或服务前，您已充分阅读、理解并接受本协议的全部内容，一旦您选择“同意”并开始使用本服务或完成购买流程，即表示您同意遵循本协议以及我们未来随时对本协议做出的修改或补充内容之所有约定。不具备前述条件的，您应立即终止注册或停止使用本服务。如您与我们已就您使用本平台服务事宜另行签订其他法律文件，则本协议与该等法律文件冲突的部分对您不适用。**另本平台的详细数据使用政策请见《隐私政策》。**

**1.1** 您保证自身具有法律规定的完全民事权利能力和民事行为能力，是能够独立承担民事责任的自然人或法人或您是未成年人已经获得监护人同意；本协议内容不会被您所属国家或地区的法律禁止。

**1.2 账户**<br />
1.2.1 在您按照本平台的要求填写相关信息并确认同意履行本协议的内容后，我们为您注册账户并开通本平台的使用权限，您的账户仅限您本人使用并使您能够访问某些服务和功能，我们可能根据我们的独立判断不时地修改和维护这些服务和功能。<br />

1.2.2 个人可代表公司或其他实体访问和使用本平台，在这种情况下，本协议不仅在我们与该个人之间的产生效力，亦在我们与该等公司或实体之间产生效力。<br />

1.2.3 如果您通过第三方连接/访问本服务，即表明允许我们访问和使用您的信息，并存储您的登录凭据和访问令牌。<br />

1.2.4 账户安全。当您创建帐户时，您有权使用您设置或确认的手机号码及您设置的密码登录本平台。我们建议您使用强密码（由大小写字母、数字和符号组合而成的密码）来保护您的帐户。您的账户由您自行设置并由您保管，本平台在任何时候均不会主动要求您提供您的账户密码。因此，建议您务必保管好您的账户，若账户因您主动泄露或因您遭受他人攻击、诈骗等行为导致的损失及后果，本平台不承担责任，您应通过司法、行政等救济途径向侵权行为人追偿。您向我们提供您的电子邮件地址作为您的有效联系方式，即表明您同意我们使用该电子邮件地址向您发送相关通知，请您务必及时关注。

1.2.5 您设置的账号名称不得违反国家法律法规、公序良俗、社会公德、或容易引起您与本平台身份的混淆，否则将可能导致您的账号注册不成功或我们有权经通知您后予以注销。

1.2.6 同一用户只能注册并绑定一个账号。您注册成功的账号仅可供您自用。除我们双方另有其他约定，您不得以任何形式赠与、借用、出租、转让、售卖或以其他方式许可第三方使用您的账号。如果本平台发现或者有合理理由认为使用者并非账号初始注册人，为保障账号安全，我们有权立即暂停或终止向该注册账号提供服务，并有权永久禁用该账号。

1.2.7 账户删除。您应通过本平台指定的方式提交账号注销申请，并按照系统提示填写相关信息，包括但不限于账号ID、注册手机号、注销原因等，以便本平台核实身份。如审核通过，本平台将通过短信向您发送账号注销通知；如审核不通过，本平台将通过短信告知您原因。自账号注销通知送达您之日起，您将无法再登录并使用该账号，账号相关的所有权益立即终止。账号注销后，本平台将按照法律法规的要求对您在平台留存的信息进行删除，但法律法规另有规定或双方另有约定的除外。

1.2.8 本平台及相关服务的适用范围如下：

(a) 相关服务的适用人群：服务适用于所有使用相关服务的人群，包括成年人、未成年人等群体，未区分特定适用人群。如涉及未成年人使用，公司在本协议中设置了专门的未成年人条款，督促未成年人按照要求使用本服务。<br />
(b) 适用场合是：服务适用于面向开发者的内容生成服务场合，不适用于自动控制、医疗信息服务、心理咨询和关键信息基础设施的场合。<br />
(c) 服务范围是：服务未限定特定领域，基于硅基流动推理框架技术，通过网页或 API 为开发者提供快捷、高效的通用内容生成服务。<br />

**1.3** 变更、暂停和终止。我们在尽最大努力以本平台公告、站内信、邮件或短信等一种或多种方式进行事先通知的情况下，可以变更、暂停或终止向您提供服务，或对服务设置使用限制，而无需承担责任。可以在任何时候停用您的帐户。即便您的账户因任何原因而终止后，您将继续受本协议的约束。

**1.4** 在法律有明确规定要求的情况下，本平台作为平台服务提供者若必须对用户的信息进行核实的情况下，本平台将依法不时地对您的信息进行检查核实，您应当配合提供最新、真实、完整、有效的信息。若本平台无法依据您提供的信息进行核验时，本平台有权向您发出询问或要求整改的通知，并要求您进行重新认证，直至中止、终止对您提供部分或全部平台服务，本平台对此不承担任何责任。

**1.5** 您应当为自己与其他用户之间的交互、互动、交流、沟通负责。我们保留监督您与其他用户之间争议的权利。我们不因您与其他用户之间的互动以及任何用户的作为或不作为而承担任何责任，包括与**交互数据**（定义见下文）相关的责任。

**2.1** 访问服务。在您遵守本协议的前提下，您在此被授予非排他性的、不可转让的访问和使用本服务的权利，仅用于您个人使用或您代表的公司或其他实体内部业务目的。我们保留本协议中未明确授予的所有权利。

**2.2** 服务限制 <br />
2.2.1 对服务的任何部分进行反汇编、反向工程、解码或反编译；<br />
2.2.2 未经我们事先书面同意，购买、出售或转让API密钥；<br />
2.2.3 复制、出租、出售、贷款、转让、许可或意图转授、转售、分发、修改本服务任何部分或我们的任何**知识产权**（定义见下文）；<br />
2.2.4 采取可能对我们的服务器、基础设施等造成不合理的巨大负荷的任何行为；<br />
**2.2.5** 以下列任何方式或目的使用本平台服务：**(a)反对宪法所确定的基本原则的;(b)危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的；(c)损害国家荣誉和利益的;(iv)煽动地域歧视、地域仇恨的；(d)煽动民族仇恨、民族歧视，破坏民族团结的；(e)破坏国家宗教政策，宣扬邪教和封建迷信的；(f)散布谣言，扰乱社会秩序，破坏社会稳定的；(g)散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的；(h)侮辱或者诽谤他人，侵害他人合法权益的；(i)煽动非法集会、结社、游行、示威、聚众扰乱社会秩序的；(j)以非法民间组织名义活动的；(k)有可能涉及版权纠纷的非本人作品的；(l)有可能侵犯他人在先权利的；(m)对他人进行暴力恐吓、威胁，实施人肉搜索的；(n)涉及他人隐私、个人信息或资料的；(o)侵犯他人隐私权、名誉权、肖像权、知识产权等合法权益内容的；(p) 侵害未成年人合法权益或者损害未成年人身心健康的；(q)未获他人允许，偷拍、偷录他人，侵害他人合法权利的；(r)违反法律法规底线、社会主义制度底线、国家利益底线、公民合法权益底线、社会公共秩序底线、道德风尚底线和信息真实性底线的“七条底线”要求的；(s)相关法律、行政法规等禁止的。**<br />
2.2.6 绕开我们可能用于阻止或限制访问服务的措施，包括但不限于阻止或限制使用或复制任何内容或限制使用服务或其任何部分的功能；<br />
2.2.7 试图干扰、破坏运行服务的服务器的系统完整性或安全性，或破译与运行服务的服务器之间的任何传输；<br />
2.2.8 使用本服务发送垃圾邮件、连锁信或其他未经请求的电子邮件；<br />
2.2.9 通过本服务传输违法数据、病毒或其他软件代理；<br />
2.2.10 冒充他人或实体，歪曲您与某人或实体的关系，隐藏或试图隐藏您的身份，或以其他方式为任何侵入性或欺诈性目的使用本服务；<br />
2.2.11 从本服务收集或获取包括但不限于其他用户姓名在内的任何个人信息。<br />
2.2.12 其他未经我们明示授权的行为或可能损害我们利益的使用方式。<br />

**3.1** 本服务可能允许用户在注册后，基于平台使用目的在使用模型过程中与开源模型、第三方网站、软件、应用程序或服务之间进行输入、反馈、修正、加工、存储、上传、下载、分发相关个人资料信息、视频、图像、音频、评论、问题和其他内容、文件、数据和信息（**“交互数据”**）。**本平台就详细数据使用政策请见本平台的《隐私政策》。**

**3.2** 如交互数据存在任何违反法律法规或本协议的情况，我们有权利删除或停止技术服务。

**3.3** 关于您的交互数据，您确认、声明并保证：

3.3.1 在我们要求时，您能提供交互数据中包含的个人信息或需要获得授权后才能使用的信息的来源及其合法性提供书面说明或授权；如您超出授权范围或期限时，您应自行负责获得授权范围的扩大或延期。

3.3.2 您的交互数据，以及我们根据本协议对交互数据的使用，不会违反任何适用法律或侵犯任何第三方的任何权利，包括但不限于任何知识产权和隐私权；

3.3.3 您的交互数据不包括任何被政府机构视为敏感或保密的信息或材料，且您就本服务提供的交互数据不侵犯任何第三方的任何保密权利；

3.3.4 您不会上传或通过本服务直接或通过其他方式提供14岁以下儿童的任何个人信息；

3.3.5 您的交互数据不包括裸体或其他性暗示内容；不包括对个人或团体的仇恨言论、威胁或直接攻击；不包括辱骂、骚扰、侵权、诽谤、低俗、淫秽或侵犯他人隐私的内容；不包括性别歧视或种族、民族或其他歧视性内容；不包括含有自残或过度暴力的内容；不包括伪造或冒名顶替的档案；不包括非法内容或助长有害或非法活动的内容；不包括恶意程式或程式码；不包括未经本人同意的任何人的个人信息；不包括垃圾邮件、机器生成的内容或未经请求的信息及其他令人反感的内容；

**3.4 本平台作为独立的技术支持者对您利用本平台接入大模型所产生的全部交互数据不享有任何知产产权。您利用本平台接入大模型所产生的全部交互数据及义务和责任均由您承担，本平台不对由此造成的任何损失负责。**

**3.5 本平台作为独立的技术支持者，您利用本平台向任何第三方提供服务，相应的权利义务和责任均由您承担，本平台不对由此造成的任何损失负责。**

**3.6.1 我们对任何交互数据概不负责。您将对您输入、反馈、修正、加工、存储、上传、下载、分发在本平台及模型服务上的交互数据负责并承担全部责任。本平台提供的技术服务只会严格执行您的指示处理您的交互数据，除非法律法规另有规定、依据特定产品规则另行约定或基于您的要求为您提供技术协助进行故障排除或解决技术问题，我们不会访问您的交互数据，您理解并认同我们及本平台只是作为交互数据的被动技术支持者或渠道。我们及本平台不会对您的交互数据进行任何非授权的使用或披露，同时亦不会进行任何存储。**

**3.6.2 请您理解并认同，我们将依据《人工智能生成合成内容标识办法》等相关法律法规要求，对人工智能生成合成内容添加相应的标识。您不得对上述标识（无论该标识以何种形式体现）进行恶意删除、篡改、伪造、隐匿，不得使用上述标识进行非法活动或发布违法内容。在特定场景下，为更好地满足您的使用需求，我们可能为您提供未添加显式标识的AI生成合成内容的选项。若您申请该选项，请您承诺并保证：(a)不利用该内容从事传播虚假信息或其他违法活动；(b)您在发布或传播利用基于深度学习、虚拟现实、生成式人工智能等新技术新应用制作的非真实信息到相关平台时，或其他可能导致公众混淆或误认的信息内容时，应当以显著方式予以标识；(c)在向第三方分享该内容或使用网络信息内容传播服务发布该内容时，主动声明其为AI生成内容；(d)遵守其他相关法律法规提出的要求。由于您违反本协议使用标识给我们或他人造成损失的，由您承担全部法律责任。**

**4.1** 定义。就本协议而言，“知识产权”系指所有专利权、著作权、精神权利、人格权、商标权、商誉、商业秘密权、技术、信息、资料等，以及任何可能存在或未来可能存在的知识产权和所有权，以及根据适用法律提出的所有申请中、已注册、续期的知识产权。

**4.2** 硅基流动知识产权。您理解并承认，我们拥有并将持续拥有本平台及本平台所提供服务的所有权利（包括知识产权），您不得访问、出售、许可、出租、修改、分发、复制、传输、展示、发布、改编、编辑或创建任何该等知识产权的衍生作品。严禁将任何知识产权用于本协议未明确许可的任何目的。本协议中未明确授予您的权利将由硅基流动保留。

**4.3** 输出。在您遵守如下事项且在合法合规的基础上，可以将大模型产出的结果进行符合法律要求使用：（a）您对服务和输出的使用不会转移或侵犯任何知识产权（包括不会侵犯硅基流动知识产权和其他第三方知识产权）；（b）如果我们酌情认为您对输出的使用违反法律法规或可能侵犯任何第三方的权利，我们可以随时限制您对输出的使用并要求您停止使用输出（并删除其任何副本）；（c）您不得表示大模型的输出结果是人为生成的并需要依据相关法律规定履行相应标识义务；（d）您不得违反任何模型提供商的授权许可、使用限制及知识产权相关约定。

您同意，我们不对您或任何第三方声称因由我们提供的技术服务而产生的任何输出内容或结果承担任何责任。

**4.4** 用户使用数据。我们可能会收集或您可能向我们提供诊断、技术、使用的相关信息，包括有关您的计算机、移动设备、系统和软件的信息（**“用户使用数据”**）。我们可能出于平台维护运营的需要，且在法律许可的范围内使用、维护和处理用户使用数据或其中的任何部分，包括但不限于：（a）提供和维护平台服务；（b）改进我们的产品和服务或开发新的产品或服务<sup><a href="#fn1" id="ref1">1</a></sup>。**详细数据使用政策请见本平台的《隐私政策》**。

**4.5** 反馈。 如果您向我们提供有关本服务或任何其他硅基流动产品或服务的任何建议或反馈（“反馈”），则您在此将所有对反馈的权益转让给我们，我们可自由使用反馈以及反馈中包含的任何想法、专有技术、概念、技术和知识产权。反馈被视为我们的**保密信息**（定义如下）。

本服务可能包括硅基流动和其他用户的非公开、专有或保密信息（“保密信息”）。保密信息包括任何根据信息的性质和披露情况应被合理理解为保密的信息，包括非公开的商业、产品、技术和营销信息。您将：（a）至少以与您保护自己高度敏感的信息相同的谨慎程度保护所有保密信息的隐私性，但在任何情况下都不得低于合理的谨慎程度；（b）除行使您在本协议下的权利或履行您的义务外，不得将任何保密信息用于任何目的；以及（c）不向任何个人或实体披露任何保密信息。

您理解并同意，本平台提供的部分服务可能会收取使用费用、售后费用或其他费用（**“费用”**）。您通过选择使用本服务即表示您同意您注册网站上载明的适用于您的定价和付款条款（受限于我们的不时更新的定价/付款条件/充值协议等文件），您同意我们相应监控您的使用数据以便完成本服务计费。定价、付款条件和充值协议特此通过引用并入本协议。您同意，我们可能会添加新产品和/或服务的额外费用、增加或修改现有产品和/或服务的费用，我们可能会按照您的实际使用地点设定不同的价格费用，和/或停止随时提供任何服务。未经我们书面同意或本平台有其他相关政策，付款义务一旦发生不可取消，并且已支付的费用不予退还。如存在任何政府要求的税费，您将负责支付与您的所有使用/开通服务相关的税款。

**7.1** 隐私。基于您注册以及开通本平台相关服务时主动提供给本平台的相关注册信息（**“用户信息”**），且为了确保您正常使用本平台的相关服务，我们可能对您提供的用户信息进行收集、整理、使用，但我们将持续遵守《中华人民共和国个人信息保护法》及相关适用法律。

**7.2** 数据安全。我们关心您个人信息的完整性和安全性，然而，我们不能保证未经授权的第三方永远无法破坏我们的安全保护措施。

本服务可能包含非我们拥有或控制的第三方网站、资料和服务（**“第三方服务”**）的链接，本服务的某些功能可能需要您使用第三方服务。我们不为任何第三方服务背书或承担任何责任。如果您通过本服务访问第三方服务或在任何第三方服务上共享您的交互数据，您将自行承担风险，并且您理解本协议不适用于您对任何第三方服务的使用。您明确免除我们因您访问和使用任何第三方服务而产生的所有责任。

您将为我们及我们的子公司和关联公司及各自的代理商、供应商、许可方、员工、承包商、管理人员和董事（“硅基流动受偿方”）进行辩护、赔偿并使其免受因以下原因而产生的任何和所有索赔、损害（无论是直接的、间接的、偶然的、后续的或其他的）、义务、损失、负债、成本、债务和费用（包括但不限于法律费用）的损害：（a）您访问和使用本服务，包括您对任何输出的使用；（b）您违反本协议的任何条款，包括但不限于您违反本协议中规定的任何陈述和保证；（c）您对任何第三方权利的侵犯，包括但不限于任何隐私权或知识产权；（d）您违反任何适用法律；（e）交互数据或通过您的用户账户提交的任何内容，包括但不限于任何误导性、虚假或不准确的信息；（f）您故意的或者存在重大过失的不当行为；或（g）任何第三方使用您的用户名、密码或其他认证凭证访问和使用本服务。

**您使用本服务的风险自负。我们明确否认任何明示、暗示或法定的保证、条件或其他条款，包括但不限于与适销性、适用于特定目的、设计、条件、性能、效用、所有权以及未侵权有关的保证、条件或其他条款。我们不保证服务将不中断或无错误运行，也不保证所有错误将得到纠正。此外，我们不保证服务或与使用服务相关的任何设备、系统或网络不会遭受入侵或攻击。**

**通过使用本服务下载或以其他方式获得的任何内容，其获取风险由您自行承担，您的计算机系统或移动设备的任何损坏和由于上述情况或由于您访问和使用本服务而导致的数据丢失，您应承担全部责任。此外，硅基流动不为任何第三方通过本服务或任何超链接网站或服务宣传或提供的任何产品或服务提供担保、背书、保证、推荐或承担责任，硅基流动不参与或以任何方式监控您与第三方产品或服务提供商之间的任何交易。**

**硅基流动在任何情况下均不对以下损害负责：（a）间接、偶发、示范性、特殊或后果性损害；或者（b）因第三方原因导致的数据丢失或受损，或者业务中断或损失；或者（c）收入、利润、商誉或预期销量或收益损失，无论是在何种法律下，无论此种损害是否因使用或无法使用软件或其他产品引起，即使硅基流动已被告知此种损害的可能性。硅基流动及其关联方、管理人员、董事、员工、代理、供应商和许可方对您承担的所有责任（无论是因保证、合同或侵权（包括疏失））无论因何原因或何种行为方式产生，始终不超过您已支付给硅基流动的费用。本协议任何内容均不限制或排除适用法律规定不得限制或排除的责任。**

**12.1** 若您是未满18周岁的未成年人，您应在监护人监护、指导并获得监护人同意的情况下，认真阅读并同意本协议后，方可使用本平台及相关服务。

**12.2** 我们深知未成年人个人信息和产品使用安全的重要性，我们将按法律法规的要求，采取相应的安全保护措施，尽力确保未成年人的个人信息安全和产品使用安全。鉴于此，我们制定本未成年人使用规则。

**12.3** 未成年用户及其监护人理解并确认，如因您违反法律法规、本协议内容，则您及您的监护人应依照法律规定承担因此而可能导致的全部法律责任。

**12.4** 未成年人用户特别提示：（a）使用本软件及相关服务应该在其监护人的监督指导下，在合理范围内正确学习使用网络，避免沉迷虚拟的网络空间，养成良好上网习惯；（b）必须遵守《全国青少年网络文明公约》：要善于网上学习，不浏览不良信息；要诚实友好交流，不侮辱欺诈他人；要增强自护意识，不随意约会网友；要维护网络安全，不破坏网络秩序； 要有益身心健康，不沉溺虚拟时空。

本协议受中华人民共和国（仅为本协议之目的，不包括香港特别行政区、澳门特别行政区及台湾地区）法律管辖。
若在执行本协议过程中如发生纠纷，双方应及时协商解决。协商不成时，我们与您任一方均有权提请北京仲裁委员会按照其届时有效仲裁规则进行仲裁，而此仲裁规则由此条款纳入本协议。仲裁语言为中文。仲裁地将为北京。仲裁结果为终局且对双方都有约束力。

**14.1** 可转让性。未经我们事先明确书面同意，您不得转让或转让本协议及本协议项下授予的任何权利和许可，但我们可无限制地转让。任何违反本协议的转让或让渡均属无效。

**14.2** 可分割性。如果本协议的某一条款或某一条款的一部分无效或不可执行，不影响本协议其他条款的有效性，无效或不可执行的条款将被视作已从本协议中删除。

**14.3** 不时修订。根据相关法律法规变化及硅基流动运营需要，我们将不时地对本协议进行修改，修改后的协议将替代修订前的协议。您在使用本平服务时，可及时查阅了解。如您继续使用本服务，则视为对修改内容的同意，当发生有关争议时，以最新的用户协议为准；您在不同意修改内容的情况下，有权停止使用本协议涉及的服务。

**14.4** 如您对本协议或本平台有任何问题或进行投诉、举报，均可通过[contact@siliconflow.cn](mailto:contact@siliconflow.cn)联系我们。

<sup id="fn1">
  1 用户使用数据不同于交互数据。交互数据不保存、不披露，具体详见《隐私政策》。<a href="#ref1">↩</a>                                      |
</sup>

---

## 更新公告

**URL:** llms-txt#更新公告

Source: https://docs.siliconflow.cn/cn/release-notes/overview

<Update label="2025.11.11" description="">
  ### 平台服务调整通知

为进一步优化资源配置，提供更高效、稳定的算力服务，平台将于`2025 年 11 月 11 日`起对部分模型 Rate Limits 进行调整。

此次调整的模型是：`Pro/deepseek-ai/DeepSeek-R1`，`Pro/deepseek-ai/DeepSeek-V3`，`Pro/deepseek-ai/DeepSeek-V3.1-Terminus`，`zai-org/GLM-4.6`，`inclusionAI/Ling-1T`，`inclusionAI/Ring-1T`，`MiniMaxAI/MiniMax-M2`；

如您业务对高并发或大规模吞吐有特殊需求，可[联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd17aubjk20jc73ada8ng)申请更高额度。

<Update label="2025.11.06" description="">
  ### 平台服务调整通知

为进一步优化资源配置，提供更高效、稳定的算力服务，平台将于 `2025 年 11 月 7 日` 起关闭`等级包`的售卖入口。

此次调整仅影响新购入口的开放，您已购的等级包、当前的用量等级及平台根据消费金额自动升降的机制不受影响。

如您有快速提升用量等级、提高 Rate Limits 的需求，请[联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd17aubjk20jc73ada8ng)。

<Update label="2025.09.29" description="">
  ### 平台服务调整通知

为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025-10-09 对下列模型进行下线处理：

* deepseek-ai/DeepSeek-V3.1
  * Pro/deepseek-ai/DeepSeek-V3.1
    若您正在使用上述任一模型，建议您尽快切换到 V3.1 Terminus，以免服务受到影响。
</Update>

<Update label="2025.09.16" description="">
  ### 平台服务调整通知

为进一步优化模型服务质量，平台已于 09 月 15 更新 moonshotai/Kimi-K2-Instruct 和 Pro/moonshotai/Kimi-K2-Instruct 模型至最新的 0905 版本，此前的 0711 版本不再继续提供。
  模型广场中moonshotai/Kimi-K2-Instruct 和 Pro/moonshotai/Kimi-K2-Instruct 已经下线，所有对应模型请求将被分别指向 moonshotai/Kimi-K2-Instruct-0905 和 Pro/moonshotai/Kimi-K2-Instruct-0905。
</Update>

<Update label="2025.08.22" description="">
  ### 平台服务调整通知

为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 9 月 4 日 对下列模型进行下线处理：

* tencent/HunyuanVideo-HD
  * Wan-AI/Wan2.1-I2V-14B-720P-Turbo
  * Wan-AI/Wan2.1-I2V-14B-720P
  * Wan-AI/Wan2.1-T2V-14B-Turbo
  * Wan-AI/Wan2.1-T2V-14B

若您正在使用上述任一模型，建议您尽快切换到其他模型，以免服务受到影响。
</Update>

<Update label="2025.06.23" description="">
  ### 平台服务调整通知

为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 7 月 3 日 对下列模型进行下线处理：

* Pro/deepseek-ai/DeepSeek-R1-0120
  * Pro/deepseek-ai/DeepSeek-V3-1226
  * Qwen/QwQ-32B-Preview

若您正在使用上述任一模型，建议您尽快切换到其他模型，以免服务受到影响。
</Update>

<Update label="2025.06.06" description="">
  ### 平台维护预告

为提供更加丰富、先进、优质的服务，平台将于 2025 年 6 月 10 日 23 时至 11 日 8 时进行维护。

1. cloud.siliconflow\.cn 将**暂停**注册、登录以及包括不限于下列功能的界面操作：
     * 模型在线体验/微调/批量推理；
     * 官网模型广场查看模型列表及详细信息；
     * 在线充值、购买等级包、查询账单、开具发票等；
  2. `/user/info` API 调整，`name` / `image` / `email` 字段将不再返回，固定输出空字符串；

平台 API 服务不受维护影响，可以持续调用，建议您提前关注账户余额，以免因为余额不足导致服务受限。
</Update>

<Update label="2025.05.29" description="">
  ### 平台服务调整通知

SiliconFlow 将启动 `DeepSeek R1` 模型更新。

对于 `deepseek-ai/DeepSeek-R1` 和 `Pro/deepseek-ai/DeepSeek-R1` 模型，将“逐步“更新到最新 `0528` 版本。
  更新完成后，上述两个款模型均为 `0528` 版本。如有需求，在 `2025 年 06 月 28` 日前，您仍可以通过 `Pro/deepseek-ai/DeepSeek-R1-0120` 使用旧版模型，以更平滑地完成业务切换。
</Update>

<Update label="2025.05.23" description="">
  ### 平台服务调整通知

为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 6 月 5 日 对下列模型进行下线处理：

* Qwen/Qwen2-1.5B-Instruct
  * Pro/Qwen/Qwen2-1.5B-Instruct
  * Pro/Qwen/Qwen2-VL-7B-Instruct
  * THUDM/chatglm3-6b
  * internlm/internlm2\_5-20b-chat
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-1.5B
  * Pro/deepseek-ai/DeepSeek-R1-Distill-Qwen-1.5B

若您正在使用上述任一模型，建议您尽快切换到其他模型，以免服务受到影响。
</Update>

<Update label="2025.04.17" description="">
  ### 平台服务调整通知

为了进一步优化资源配置，提供更先进和优质的技术服务，平台将于 2025 年 4 月 29 日 对 `HunyuanVideo` 模型（`非 HunyuanVideo-HD`）模型进行下线处理。
  若您正在使用该模型，建议您尽快切换其他模型，以免服务受到影响。
</Update>

<Update label="2025.03.26" description="">
  ### 平台服务调整通知

截止目前，`Pro/deepseek-ai/DeepSeek-V3` 和 `deepseek-ai/DeepSeek-V3` 模型已经更新至最新的 0324 版本。您仍可以通过 `Pro/deepseek-ai/DeepSeek-V3-1226` 使用旧版模型，以更平滑地完成业务切换。
</Update>

<Update label="2025.03.25" description="">
  ### 平台服务调整通知

SiliconFlow 将启动 DeepSeek V3 模型更新。

对于 `deepseek-ai/DeepSeek-V3` 和 `Pro/deepseek-ai/DeepSeek-V3` 模型，将“逐步“更新到最新 `0324` 版本。

更新完成后，上述两个款模型均为 0324 版本。如有需求，在 2025 年 4 月 30 日前，您仍可以通过 `deepseek-ai/DeepSeek-V3-1226` 使用旧版模型，以更平滑地完成业务切换。
</Update>

<Update label="2025.03.11" description="">
  ### 平台服务调整通知

为了更好的服务全球开发者用户，SiliconFlow 即将上线国际站，并逐步开设多个服务区域。

受此调整影响，现有`api.siliconflow.com API`端点将适时回收，请您尽快切换为`api.siliconflow.cn`继续使用。

我们已经为`.cn`端点配置了全球访问加速（GTM），使其与当前的`.com`端点具有相同的全球接入体验，您只需要将 API 请求的`base URL`修改为`api.siliconflow.cn`即可。

我们建议您在`本月底（3 月 31 日）`前完成迁移，如有任何疑问，请随时联系我们。
</Update>

<Update label="2025.03.07" description="">
  ### 平台服务调整通知

为持续提升用户体验，现调整 Rate Limits 策略如下：

去掉 deepseek-ai/DeepSeek-R1、deepseek-ai/DeepSeek-V3 的 RPH 和 RPD 限流

随着流量和负载变化，策略可能会不定时调整，硅基流动保留解释权。
</Update>

<Update label="2025.02.27" description="">
  ### 平台服务调整通知

为了进一步优化资源配置，提供更先进、优质、合规的技术服务，平台将于 2025 年 3 月 6 日 对部分模型进行下线处理。
  具体涉及的模型列表如下：

* 对话模型
    * AIDC-AI/Marco-o1
    * meta-llama/Meta-Llama-3.1-8B-Instruct
    * Pro/meta-llama/Meta-Llama-3.1-8B-Instruct
    * meta-llama/Meta-Llama-3.1-70B-Instruct
    * meta-llama/Meta-Llama-3.1-405B-Instruct
    * meta-llama/Llama-3.3-70B-Instruct
  * 生图模型
    * black-forest-labs/FLUX.1-schnell
    * Pro/black-forest-labs/FLUX.1-schnell
    * black-forest-labs/FLUX.1-dev
    * black-forest-labs/FLUX.1-pro
    * stabilityai/stable-diffusion-xl-base-1.0
    * stabilityai/stable-diffusion-3-5-large
    * stabilityai/stable-diffusion-3-5-large-turbo
    * stabilityai/stable-diffusion-2-1
    * deepseek-ai/Janus-Pro-7B
  * 语音模型
    * fishaudio/fish-speech-1.5
    * FunAudioLLM/SenseVoiceSmall
    * fishaudio/fish-speech-1.4
    * RVC-Boss/GPT-SoVITS
  * 视频模型
    * Lightricks/LTX-Video
    * genmo/mochi-1-preview
</Update>

<Update label="2025.02.22" description="">
  ### 平台服务调整通知

为保障平台服务质量与资源合理分配，现调整Rate Limits策略如下：

1. 新增 RPH 限制（Requests Per Hour，每小时请求数）

* 模型范围：deepseek-ai/DeepSeek-R1、deepseek-ai/DeepSeek-V3
     * 适用对象：所有用户
     * 限制标准：30次/小时

2. 新增 RPD 限制（Requests Per Day，每日请求数）
     * 模型范围：deepseek-ai/DeepSeek-R1、deepseek-ai/DeepSeek-V3
     * 适用对象：未完成实名认证用户
     * 限制标准：100次/天

随着流量和负载变化，策略可能会不定时调整，硅基流动保留解释权。
</Update>

<Update label="2025.02.13" description="">
  ### 平台服务调整通知

为了提供更稳定、高质量、可持续的服务，以下模型将于 **2025 年 02 月 27 日**下线：

* [01-ai/Yi-1.5-34B-Chat-16K](https://cloud.siliconflow.cn/models?target=01-ai/Yi-1.5-34B-Chat-16K)
  * [01-ai/Yi-1.5-6B-Chat](https://cloud.siliconflow.cn/models?target=01-ai/Yi-1.5-6B-Chat)
  * [01-ai/Yi-1.5-9B-Chat-16K](https://cloud.siliconflow.cn/models?target=01-ai/Yi-1.5-9B-Chat-16K)
  * [stabilityai/stable-diffusion-3-medium](https://cloud.siliconflow.cn/models?target=stabilityai/stable-diffusion-3-medium)
  * google/gemma-2-27b-it
  * google/gemma-2-9b-it
  * Pro/google/gemma-2-9b-it

如果您有使用上述模型，建议尽快迁移至平台上的其他模型。
</Update>

<Update label="2025.02.09" description="">
  ### 平台服务调整通知

#### deepseek-ai/DeepSeek-V3 模型的价格于北京时间 2025年2月9日00:00 起恢复至原价

* 输入：¥2/ M Tokens
  * 输出：¥8/ M Tokens
</Update>

<Update label="2025.02.03" description="">
  ### 推理模型输出调整通知

推理模型思维链的展示方式，从之前的 `content` 中的 `<think></think>` 独立成单独的单独的 `reasoning_content` 字段，兼容 `OpenAI` 和 `deepseek` api 规范，便于各个框架和上层应用在进行多轮会话时进行裁剪。使用方式详见[推理模型（DeepSeek-R1）使用](/capabilities/reasoning)。
</Update>

<Update label="2025.02.01" description="">
  ### 平台服务调整通知

#### 支持deepseek-ai/DeepSeek-R1和deepseek-ai/DeepSeek-V3模型

* `deepseek-ai/DeepSeek-R1` 输入：￥4/ M Tokens 输出：￥16/ M Tokens
  * `deepseek-ai/DeepSeek-V3`
    * **即日起至北京时间 2025-02-08 24:00 享受限时折扣价**：输入：<s>¥2</s>￥1/ M Tokens   输出：<s>¥8</s>￥2/ M Tokens，2025-02-09 00:00恢复原价。
</Update>

<Update label="2024.12.27" description="">
  ### 平台服务调整通知

#### 生成图片及视频 URL 有效期调整为 1 小时

为了持续为您提供更先进、优质的技术服务，从 2025 年 1 月 20 日起，大模型生成的图片、视频 URL 有效期将调整为 1 小时。

若您正在使用图片、视频生成服务，请及时做好转存工作，避免因 URL 过期而影响业务。
</Update>

<Update label="2024.12.24" description="">
  ### 平台服务调整通知

#### LTX-Video 模型即将开始计费通知

为了持续为您提供更先进、优质的技术服务，平台将于 2025 年 1 月 6 日起对 Lightricks/LTX-Video 模型的视频生成请求进行计费，价格为 0.14 元 / 视频。
</Update>

<Update label="2024.12.13" description="">
  ### 平台服务调整通知

为了提供更稳定、高质量、可持续的服务，以下模型将于 **2024 年 12 月 19 日**下线：

* [deepseek-ai/DeepSeek-V2-Chat](https://cloud.siliconflow.cn/models?target=deepseek-ai/DeepSeek-V2-Chat)
  * [Qwen/Qwen2-72B-Instruct](https://cloud.siliconflow.cn/models?target=Qwen/Qwen2-72B-Instruct)
  * [Vendor-A/Qwen/Qwen2-72B-Instruct](https://cloud.siliconflow.cn/models?target=Vendor-A/Qwen/Qwen2-72B-Instruct)
  * [OpenGVLab/InternVL2-Llama3-76B](https://cloud.siliconflow.cn/models?target=OpenGVLab/InternVL2-Llama3-76B)

如果您有使用上述模型，建议尽快迁移至平台上的其他模型。
</Update>

<Update label="2024.12.5" description="">
  ### 平台服务调整通知

为了提供更稳定、高质量、可持续的服务，以下模型将于 **2024 年 12 月 13 日**下线：

* [Qwen/Qwen2.5-Math-72B-Instruct](https://cloud.siliconflow.cn/models?target=Qwen/Qwen2.5-Math-72B-Instruct)
  * [Tencent/Hunyuan-A52B-Instruct](https://cloud.siliconflow.cn/models?target=Tencent/Hunyuan-A52B-Instruct)

如果您有使用上述模型，建议尽快迁移至平台上的其他模型。

如果您有使用上述模型，建议尽快迁移至平台上的其他模型。
</Update>

<Update label="2024.11.14" description="">
  ### 平台服务调整通知

为了提供更稳定、高质量、可持续的服务，以下模型将于 **2024 年 11 月 22 日**下线：

* [deepseek-ai/DeepSeek-Coder-V2-Instruct](https://cloud.siliconflow.cn/models?target=deepseek-ai/DeepSeek-Coder-V2-Instruct)
  * [Qwen/Qwen2-57B-A14B-Instruct](https://cloud.siliconflow.cn/models?target=Qwen/Qwen2-57B-A14B-Instruct)
  * [Pro/internlm/internlm2\_5-7b-chat](https://cloud.siliconflow.cn/models?target=Pro/internlm/internlm2_5-7b-chat)
  * [Pro/THUDM/chatglm3-6b](https://cloud.siliconflow.cn/models?target=Pro/THUDM/chatglm3-6b)
  * [Pro/01-ai/Yi-1.5-9B-Chat-16K](https://cloud.siliconflow.cn/models?target=Pro/01-ai/Yi-1.5-9B-Chat-16K)
  * [Pro/01-ai/Yi-1.5-6B-Chat](https://cloud.siliconflow.cn/models?target=Pro/01-ai/Yi-1.5-6B-Chat)

如果您有使用上述模型，建议尽快迁移至平台上的其他模型。

为进一步提升服务体验，平台将于 **2024 年 11 月 22 日起**调整登录方式：由原先的“邮箱账户 + 密码”方式更新为“**邮箱账户 + 验证码**”方式。

新增支持海外用户的平台端点：[https://api-st.siliconflow.cn](https://api-st.siliconflow.cn)。如果您在使用源端点 [https://api.siliconflow.cn](https://api.siliconflow.cn) 时遇到网络连接问题，建议切换至新端点尝试。
</Update>

<Update label="2024.10.09" description="">
  ### 部分模型计价调整公告

为了提供更加稳定、优质、可持续的服务，[Vendor-A/Qwen/Qwen2-72B-Instruct](https://cloud.siliconflow.cn/models?target=17885302571) 限时免费模型将于 2024 年 10 月 17 日开始计费。计费详情如下：

* 限时折扣价：¥ 1.00 / M tokens
  * 原价：¥ 4.13 / M tokens（恢复原价时间另行通知）
</Update>

---

## 社区场景与应用

**URL:** llms-txt#社区场景与应用

Source: https://docs.siliconflow.cn/cn/usercases/awesome-user-cases

---

## SiliconFlow 场景与应用案例

**URL:** llms-txt#siliconflow-场景与应用案例

**Contents:**
  - 1. 翻译场景使用
  - 2. 搜索与 RAG 场景使用
  - 3. 编码场景使用
  - 4. 分析场景使用
  - 5. 通讯场景使用
  - 6. 生图场景使用
  - 7. 使用评测
  - 8. 开源项目
  - 9. 其它

将 SiliconFlow 平台大模型能力轻松接入各类场景与应用案例

{/* <CardGroup cols={2} > */}

{/* <Card title="在 Cherry Studio 中使用" icon="link" href="/usercases/use-siliconcloud-in-cherry-studio">
        Cherry Studio 团队
  </Card>
  <Card title="在 Chatbox 中使用" icon="link" href="/usercases/use-siliconcloud-in-chatbox">
        Chatbox 团队
  </Card> */}

<CardGroup cols={2}>
  <Card title="在沉浸式翻译中使用" icon="square-1" href="/usercases/use-siliconcloud-in-immersive-translate">
    SiliconFlow 团队
  </Card>

<Card title="免费接入！沉浸式翻译 x SiliconFlow（硅基流动）" icon="square-2" href="https://www.bilibili.com/video/BV11M4m127NX/">
    沧海九粟
  </Card>

<Card title="【硅基流动】在 GoldenDict-ng 中与 AI 无缝畅聊、使用 AI 翻译" icon="square-3" href="https://forum.freemdict.com/t/topic/31335">
    ohnny\_Van
  </Card>

<Card title="SimpleTranslationAIAgent借助SiliconFlow API 构建自己的专属翻译助手" icon="square-4" href="https://zhuanlan.zhihu.com/p/717541519">
    mingupup
  </Card>

<Card title="AI翻译助力Zotero外文文献阅读-SiliconFlow硅基流动api" icon="square-5" href="https://www.bilibili.com/video/BV1vwYdeREwy/">
    行歌类楚狂
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="在 MindSearch 中使用" icon="square-1" href="/usercases/use-siliconcloud-in-mindsearch">
    MindSearch 团队
  </Card>

<Card title="[当 MindSearch 遇上 SiliconFlow：免费部署媲美 Perplexity 的多智能体搜索引擎]" icon="square-2" href="https://zhuanlan.zhihu.com/p/717572206">
    LogicAI
  </Card>

<Card title="基于 SiliconFlow API 实现 CPU-only RAG 框架" icon="square-3" href="https://zhuanlan.zhihu.com/p/696833005">
    白牛
  </Card>

<Card title="基于 SiliconFlow 使能 GraphRAG 🏠 Marscode" icon="square-4" href="https://www.bilibili.com/video/BV1Chv4eFE5s/">
    沧海九粟
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="使用SiliconFlow平台API配置Continue插件" icon="square-1" href="https://zhuanlan.zhihu.com/p/716245893">
    xDiexsel
  </Card>

<Card title="SiliconFlow硅基流动平台配合cursor，实现全自动写代码" icon="square-2" href="https://www.bilibili.com/video/BV1kas4ePEcv/?share_source=copy_web&vd_source=d3e2625153c20b669282198264ed2959">
    野原广志2\_0
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card
    title="科研利器-硅基流动结合Open-interpreter实现数据自动分析与可视化
"
    icon="square-1"
    href="https://www.bilibili.com/video/BV1kgYiemEoq/?vd_source=ee682782eaf6b50be3fdfe777cacb535
"
  >
    行歌类楚狂
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="使用chatgpt-on-wechat 和 SiliconFlow API 打造你的专属微信全能 AI 分身" icon="square-1" href="https://f0nqg53yzdn.feishu.cn/wiki/XPXvwwLbLiPgHVkWkEhcKPvQn8d?from=from_copylink">
    大大大维维
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="使用BizyAir，没有显卡，也能玩AI绘图" icon="square-1" href="https://mp.weixin.qq.com/s/_6YdsrA1yqqf7P-EDK48iw">
    mingupup
  </Card>

<Card title="探索SiliconFlow：如何用API体验Kolors大模型" icon="square-2" href="https://www.bilibili.com/read/cv37120422/">
    baiack
  </Card>

<Card title="在comfyUI中用SiliconFlow爽玩LLM！" icon="square-3" href="https://m.okjike.com/originalPosts/66c8b0c259d1a984c6727040?s=eyJ1IjoiNjNkYzY5YzQyNDNiYThiNTI1NmMxNjkwIiwiZCI6MX0%3D">
    糯.米.鸡
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="国产赛博菩萨硅基流动SiliconFlow：最佳免费 llm大模型 api 提供商" icon="square-2" href="https://www.bilibili.com/video/BV1SYWke9E2Q">
    湖光橘鸦
  </Card>

<Card title="速度与效率的飞跃：硅基流动API实战体验" icon="square-3" href="https://mp.weixin.qq.com/s/m6gS1wLDZiQJyf9G1nIi8A">
    自牧生
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="多模型同时对话、文生图，纯前端。" icon="square-1" href="https://github.com/KwokKwok/Silo">
    郭垒
  </Card>

<Card
    title="多语言 AI 模型评估平台"
    icon="square-2"
    href="https://github.com/flashclub/ModelJudge
"
  >
    laughing
  </Card>
</CardGroup>

<CardGroup cols={2}>
  <Card title="动手学Avalonia：基于SemanticKernel与硅基流动构建AI聊天与翻译工具" icon="square-1" href="https://mp.weixin.qq.com/s/s7ZMw8nAisAuxgAvE2VTgA">
    mingupup
  </Card>

<Card title="使用 SiliconFlow 体验 AI 开发：为卡片盒笔记带来 AI 助手" icon="square-2" href="https://guoleilei.notion.site/SiliconFlow-AI-AI-6b8ab4ed2bd4487db098bb9fd93b5eaa">
    郭垒
  </Card>

<Card title="【AI】用SiliconFlow开发效率工具" icon="square-3" href="https://www.bilibili.com/video/BV1XKH7eEEM9/">
    free-coder
  </Card>

<Card title="SiliconFlow  API 接入 ONE API" icon="square-4" href="https://zhuanlan.zhihu.com/p/713980632">
    三千酱
  </Card>
</CardGroup>

---

## 302.AI

**URL:** llms-txt#302.ai

**Contents:**
- 1. 关于302.AI
- 2. 硅基流动用户如何在302.AI使用 SiliconFlow 模型
  - 2.1 接入聊天机器人进行对话
  - 2.2. 接入API实现功能扩展
- 3. 302.AI用户如何直接使用 SiliconFlow 模型
  - 3.1 使用 SiliconFlow 语言模型进行AI对话
  - 3.2 在模型竞技场使用 SiliconFlow 模型
  - 3.3. 接入 SiliconFlow 模型API

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-302ai

302.AI是一个按需付费的AI应用平台,提供丰富的AI在线应用和全面的AI API接入。

302.AI和硅基流动进行合作,让302.AI的用户可以在302的平台内直接使用硅基流动的所有模型以及开箱即用的AI应用；也能让硅基流动的用户可以在302的平台内自定义接入硅基流动模型API,无需自己开发或部署。

## 2. 硅基流动用户如何在302.AI使用 SiliconFlow 模型

#### 2.1.1 获取 SiliconFlow 的API Key 和模型 ID

(1)打开 SiliconFlow 官网 并注册账号(如果注册过,直接登录即可)。

(2)完成注册后,打开API密钥,创建新的 API Key,点击密钥进行复制,以备后续使用。

(3)在模型广场找到需接入的模型ID备用。

(1)依次点击: **使用机器人 → 聊天机器人 → 模型**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7a168eb38e7e565c26e47d92594c536c" data-og-width="1530" width="1530" data-og-height="1291" height="1291" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e30f1d688c18c80a1f502025a951cd95 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ab19eb52de7d9ac9d00203e8d3a05a64 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c3f82d98e6145d6e6a66422381324775 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a4f9bb7e2287f4dc7ed2b598f70fd1dc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=76298fccc8573dd604da42bf7cf33718 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_1_64_51_1530_1291_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e2bdc48f57a2cb86b6925e12253abc70 2500w" />
</Frame>

(2)点击左下角的自定义模型,填写相关配置信息。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8d98aa72898a6caeea59e8bfebad439c" data-og-width="1528" width="1528" data-og-height="1120" height="1120" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8646ed40dec0b98f71b0eee309b5d621 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ff6b866193fc7ac7809743813bfbbf13 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=989a1cc1419085417312a1ba9980bf3f 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2506c2bb8b804905df733dac1fd9e4fc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c49aed846bdcf4501de6bad4fcd70a60 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_2_68_48_1528_1120_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=293799d61df02063bec93111ba07911c 2500w" />
</Frame>

(3)示例模型:硅基流动部署的Qwen/Qwen2.5-7B-Instruct:

* 填写API Key、模型ID等,并根据模型特性进行相应配置；

* 点击【检查】按钮,一键检测信息是否填写正确(示例绿标即为通过)；

* 按需选择中转地区(中转地区选择功能可以解决部分模型提供商因为IP地区限制访问的问题)；

* 可设置备用模型,当自定义模型失效时可以自动切换到备用模型；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ff7c97e016aad5eeefc89b1d6548ea8c" data-og-width="786" width="786" data-og-height="1272" height="1272" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3e3d21fcd2a221aadf61982d164bffea 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f7e6352229e8712a77ea41cba18a6e01 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=08b20b768e4da67c6ca78beb514ccaed 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=10f2fde44b8849bda1bd95748c8a38e6 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8f20f731ba2db01d0b1d805bc5257815 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_3_438_49_786_1272_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d6957626bfecbd10490d8a0826fe6d4a 2500w" />
</Frame>

(1)接入成功后的模型会在自定义模型分类中显示,选中模型并点击【确认】；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0892e4475e6f31415c902c11338b5b61" data-og-width="802" width="802" data-og-height="865" height="865" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=353cecf74a8b88f5dd0584b32c519096 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ce99eaa1267b58bbaca7148fb7a99def 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=33f2eeaf9b4d1357998e916d5b8c209e 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=320e254708bf6b30228b639be81f46bc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=64579808a6a0f9d946f9481f914600e3 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_4_356_1232_802_865_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=39fec511f8841a8b70c653811dbb1efd 2500w" />
</Frame>

(3)进入聊天机器人后发送消息即可开启对话；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=71c03e5fb41f8826111c6a465e443be0" data-og-width="1525" width="1525" data-og-height="1043" height="1043" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a7e8db62036f728134a86d814908a1a4 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=671029788b57377cff69b30383c92a47 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=363dbf60788bd00ca205d1f0afef5351 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2b26c593e433e34852bd5820bd92cb51 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=716efd3a1a34c4a9d67df775bb48d114 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_5_64_40_1525_1043_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a24332b9f6a25bcbe0c46ec3c66608b4 2500w" />
</Frame>

(所有模型均支持联网搜索、图片分析、深度思考等能力)

开启自定义模型的聊天机器人,每创建一个机器人每天收费0.05 美金 ,按天扣费。

模型使用费用,将在SiliconFlow的账号余额扣取。

(1)首先我们需要创建一个支持中转自定义模型的API key。

详细步骤:**使用 API → API Keys → 输入 API 名称 → 开启自定义模型中转 → 【添加 API KEY】**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=65f19767a93c26953aedc7d0a9351c99" data-og-width="1530" width="1530" data-og-height="1151" height="1151" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=698bfb9aceae15e33429fd79a1e4c72f 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b191eb7638242fc2a49a2573bdd9f7b0 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=dd68e2d6580bc1c8ddae274a59ae319f 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a88b066ab6e91e761f778d6b28bd86e3 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=35f75358de21ce1e792e334abd6c9517 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_64_38_1530_1151_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4b29ccae080a3ef9b58e3526947d37bd 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7f9031ccec3fb568c7fa5330450ccd64" data-og-width="1519" width="1519" data-og-height="792" height="792" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d3f475546970b52115fa42774be2889d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d8ff542d96fbe5f30a9e7b477e9fa761 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7b6a260ed8d75a86b31067971e98a6d1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c5daf4bc12bfd718a1ac32e0fc44273a 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=83f972517e27b451ae062291bdd5f9fb 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_6_77_1254_1519_792_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=24adc42aa715a77b497492dfdc3bfd9a 2500w" />
</Frame>

(3)查看中转后自定义模型的名称以方便调用:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=80617c20799fa3b631593a6fe2f53bd5" data-og-width="1534" width="1534" data-og-height="711" height="711" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=261882e211492b1a108b40214f12196f 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=89706f5f319f28e55984ea07a1f10795 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c09a2d460729620a0247dfd934f19abc 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=74296416188907c17cf79a735ccffb61 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a7af058d4af95382c45b440a8f30fbca 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_57_30_1534_711_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bd0d4fffce879a1690bc0dd3b83af0b3 2500w" />
</Frame>

通过302中转的模型,可以新增一些模型本身不具备的功能

联网搜索、深度搜索、图片分析、推理模式、链接解析、工具调用、长期记忆

(点击文字可直达相关文档,根据文档说明使用即可,持续更新中)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=08f13996a7e6ebbd6dba1d1a1c9b9f71" data-og-width="1505" width="1505" data-og-height="823" height="823" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=171eb8721b29f466ece4a2c7530e7646 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a4966ca10ed579d9559e10df98801a5e 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9477fa61fd2183b977e1b05a5885d19e 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2a7f60f0ee914e661909e080f4f1464e 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fdae522bde4ad0c192a24efde869bd10 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_7_81_1208_1505_823_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c63a0bf77e95b43df1a396838621320e 2500w" />
</Frame>

(2)点击“去设置变量值”,粘贴生成的API Key填并点击【保存】:

(注意:模型中转功能必须手动开启,因此需要手动粘贴对应的API Key)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1a4ccc1a70cb7372a6f77146311c3b8b" data-og-width="1544" width="1544" data-og-height="1378" height="1378" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0808eb2e331f1a52a2742c4f61901689 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=48f92faa3bb67c465e8794d0f75cfdf6 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7e77c44b6acce354eac3cdeef3bcb51b 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3801d0c0543b84834c499bd4aebaa206 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=60ec2de48004927f7fd55a26ed6ecd2a 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_8_53_35_1544_1378_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5ae20982a94f07af3f36e5f461cdf73d 2500w" />
</Frame>

(3)根据文档说明,自定义模型后缀加上“-web-search”(如示例Qwen/Qwen2.5-7B-Instruct-2-web-search)并输入提示词点击【发送】即可增加联网搜索能力:

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5f428eabbe7da5cc7408b4974eaa5759" data-og-width="848" width="848" data-og-height="1443" height="1443" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ee83fcc659d40aa000bf163c2ad7a639 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ad8ba346bf93dc2705eccdc922f0f9e2 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4a01e3baaa6846dcee017d31e5c70945 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f4113d2249da64177f075c8e71a5e835 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=62584bb926c76b3af0cc6d8fb0dbef25 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_9_394_46_848_1443_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7e8f4cd9ceeb819a0e40888772947e54 2500w" />
</Frame>

新增支持中转自定义模型的API-Key后,每个key每天收费 0.05 美金,按天扣费。

附上302.AI价格表:[https://302.ai/pricing/](https://302.ai/pricing/)

## 3. 302.AI用户如何直接使用 SiliconFlow 模型

### 3.1 使用 SiliconFlow 语言模型进行AI对话

#### 3.1.1 进入302.AI官网或者客户端

* 302.AI官网:[https://302.ai/](https://302.ai/)

* 302.AI客户端下载网址:[https://302.ai/download/](https://302.ai/download/)

(进入后注册账号,如已注册,直接登录即可)

(1)登录进入302.AI官网或者客户端的管理后台。点击:

**使用机器人 →  聊天机器人 →  模型**;

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=31feff89058935fe616d482442074121" data-og-width="1532" width="1532" data-og-height="1156" height="1156" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b307911fa3778a48c1eb255f88f3b72d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=126b05a16b7f375a50ae3efc434a2fdc 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f4a38b369bc3f23b859b84d3d513d3d1 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=72bb836a255fc8c9de5e5b0ab75ab040 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e6ff2a81c94fc76dc95b7776e7fa215b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_10_65_348_1532_1156_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2ff27a3d4916d4964df466f32d5f66f7 2500w" />
</Frame>

(2)找到【硅基流动】→选择模型(如deepseek-ai/deepseek-vl2)→ 确定→创建聊天机器人；

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bbc6df8950b159cae324fc621fa02f05" data-og-width="1502" width="1502" data-og-height="1042" height="1042" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=76042281230922f7bd4429e5ac52bfe2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6cb2bd9bdd9da2a215a43282dd0bce9c 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=de1400b125cc076a3beced6efeec8b94 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=78b937780e0a28af4121b9c2a2c3eabc 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=26416820aef14289870e6876a3bb8253 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_75_118_1502_1042_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c6465b3bc19ae8bea804d23661664686 2500w" />
</Frame>

(3)聊天机器人创建成功后会在页面下方展示,可进一步选择聊天、分享、编辑等操作。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a3a39b3ec339196ebf1cf17a81baa236" data-og-width="1524" width="1524" data-og-height="573" height="573" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0a7d4b731baf730a16d2264772fef7af 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9f693cb4cea146f57a7b46e949e9099b 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=eb2a88d85aaf938aaf3641990d84c216 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c293df70fcf2c3a4e84742303e318049 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d7a12afd7251df31d825763bb587e55b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_11_65_1226_1524_573_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8c23723786cd866c06df370354163be0 2500w" />
</Frame>

(1)进入聊天机器人后在输入框键入文字即可聊天,输入框下方的按钮可上传图片或文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=b73129e653620aeab3e2df1c4d3534d6" data-og-width="1529" width="1529" data-og-height="1054" height="1054" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4f832b4deceb42b5c3bfa7e7fed38194 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6b4739dca0c71608f6b88a21c2bcdfa5 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f017f07912eeac923fbe4eb50eac1eaf 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8fa3d65cd13fea4539779d75de9faf49 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3d298fb10793a666af43edb6207ed029 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_64_33_1529_1054_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=044379266c1e4780c83fbe143da6846c 2500w" />
</Frame>

(2)点击对话框界面下方的按钮可开启聊天机器人的实时预览功能,这一功能可以实时查看模型生成代码的运行效果。 1.2.3 在全能工具箱中使用

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=78d26dc3ec292b0b3486c2d44a58cf72" data-og-width="1511" width="1511" data-og-height="742" height="742" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=67df128d9a5fffbd1a8b42cbdf26aa64 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=d510d5dca846846676026be50d0e721e 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=bf6014bc6e881e0057513dadcc44eee2 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=81be2d5879bb371f8874863eeb44d839 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3c13c85435f5966a5e7577658a064611 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_12_75_1220_1511_742_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3358e3e4838824f4ce51a9b28e2378c7 2500w" />
</Frame>

我们还可以通过全能工具箱选择 SiliconFlow 模型进行对话:

**依次点击: 全能工具箱 →  快捷使用**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0ea47c5f8a0a4c8a7c4e1f6418e571af" data-og-width="1504" width="1504" data-og-height="1135" height="1135" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7403ef24db3ac499d66e9988a764d14d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=80975e3cbdf94d79e7feade29c4d32ca 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=04b6112c05dfde92136b6dc8a9cc3f58 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e236aad6f45a68063bd604c15e227f9c 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ddecae1c8ec6aeda7d901ee47474e84e 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_13_82_44_1504_1135_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=24c4c38c2b3fd7a159590a02153559a4 2500w" />
</Frame>

**聊天机器人 → 找到对话框下方的 “@” → 切换 SiliconFlow 模型**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=105825106f5648d2f3a660c0a8f6542d" data-og-width="1542" width="1542" data-og-height="1113" height="1113" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=8bb8d7cd2697ed7bcc01950e9d10dbb9 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f4cda5bea83bb2c611e24082cc9de3ce 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=262208cbcc500051c01f4732418e15f4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fcf054a925adc06e7116e74e9095582d 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5600080ffc9aae9200d47e33627bd284 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_14_54_30_1542_1113_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=84fbd0adf26d2e261097357744b92a40 2500w" />
</Frame>

### 3.2 在模型竞技场使用 SiliconFlow 模型

**使用工具 →  工具超市 →  工具效率 → 【模型竞技场】 →  创建**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=cb97f87b4550ff47381c356cff88a561" data-og-width="1536" width="1536" data-og-height="1129" height="1129" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4a6e4e6fe329074187d245637412d3ec 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=abeaa43076a915d0bb121a8097321e78 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f59d84fe6d14b06c271616a9accc383d 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a568921cb872673c9ef0372ea0e7b41b 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ae8e4d17d29fff14cf8a9f0ad1b54f8e 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_15_61_41_1536_1129_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=520a9bfb92ab6be4b09e198583f68333 2500w" />
</Frame>

进入模型竞技场后,下滑找到【硅基流动】并按需勾选模型,输入提示词即可在页面右侧直观对比不同模型输出的答案。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=fb99d8902209cdf125cdeef9fe266f79" data-og-width="1518" width="1518" data-og-height="1032" height="1032" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4f473261227bfc6256bd33bc2da6869e 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=153dfb8781511326f8be69767641527b 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=70571a206426b335df9b62820c4bce41 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2e50b29ed5fb4313a1b5125d3ecdba69 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=02fc6dbc5338af7fb5ad4d5999ec65a5 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_68_44_1518_1032_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ccdd2c28dfbc338ae19fd34f658be2e2 2500w" />
</Frame>

### 3.3. 接入 SiliconFlow 模型API

直达链接:[https://doc.302.ai/api-252560001?environment\[YOUR\_API\_KEY\]=sk-ykJk7PY80O3ulWYTGplndVApzj4oeTeMvH4Jrxh6CkaegWiz](https://doc.302.ai/api-252560001?environment\[YOUR_API_KEY]=sk-ykJk7PY80O3ulWYTGplndVApzj4oeTeMvH4Jrxh6CkaegWiz)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=071abd7518d22ff2003c4acae6e84b40" data-og-width="1521" width="1521" data-og-height="722" height="722" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1ec9d4a8df2eb71fcc19df45222c25c1 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=702708bd03a080e264622b206f2eaee0 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=85fae83d5baeb9bd5151a7173eb47af4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=31a7e4610a9075bd088170da6282a7f7 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=aeec8e49851a72fd14926e4cb134949b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_16_65_1406_1521_722_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=351edc82959b72fce5c75d8d99bd6d3c 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1d209625734e056abc6ee9e75a0538e3" data-og-width="1106" width="1106" data-og-height="977" height="977" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=9056af7dd0b6c3d108fc804d038ba135 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c6a9d2a706ed04d4a27395b8ba3034cb 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=64b681762f6e883fd1489e9c2e425cf4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=00298e0b23de3a822bf679e696b1e768 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f1be7c61363df8275ddba0e83a1f411b 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_276_82_1106_977_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5dc5f2496b370fec84f775046da0279f 2500w" />
</Frame>

(2)**进入API文档后点击在线调试 →  “去设置变量值”,查看API KEY是否自动赋值**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=ed52e8d72b532a9c1586d1e684b509c8" data-og-width="1170" width="1170" data-og-height="875" height="875" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=22b9d7adcb9cc21a38ec5f78f97c5dcb 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=cd98b130e83445e4674a0825fedc95d6 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=09b715e17f89c2178668b0d18c9732e8 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1369ce1a27bd0522ff0bd0d96b64f51b 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f68a747b43dc7d762b28964819898c5f 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_17_247_1157_1170_875_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=6779137ecc31449772bfccfd681c9fff 2500w" />
</Frame>

(3)根据参数模板填写要使用的模型ID和文本内容,点击发送,等待输出结果即可。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1bcf61d694e24e27bb084ff7a4f16e22" data-og-width="813" width="813" data-og-height="1455" height="1455" data-path="images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=73ea0d3ddb439d12aa8b684871da5754 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=24990c2c94f91e4ca88c809fd09aa7f5 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=e7d0285525cdf21b27e8a9230001e8e8 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5078234a2542a61240c48e814be4ed24 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=7df372f2a6aff07d576176bcd6b097f3 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/302ai/images/0195face-f195-7148-84b7-acbdf70a7669_18_411_47_813_1455_0.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=95d8dd384d3388f673a636eedbfbf6ff 2500w" />
</Frame>

---

## DB-GPT

**URL:** llms-txt#db-gpt

**Contents:**
- 1.关于 DB-GPT
- 2.获取 API Key
- 3.部署 DB-GPT
  - 3.1 克隆 DB-GPT 源码
  - 3.2 创建虚拟环境并安装依赖

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-DB-GPT

[DB-GPT](https://github.com/eosphoros-ai/DB-GPT) **是一个开源的AI原生数据应用开发框架(AI Native Data App Development framework with AWEL(Agentic Workflow Expression Language) and Agents)。**

目的是构建大模型领域的基础设施，通过开发多模型管理(SMMF)、Text2SQL效果优化、RAG框架以及优化、Multi-Agents框架协作、AWEL(智能体工作流编排)等多种技术能力，让围绕数据库构建大模型应用更简单，更方便。

2.1 打开 [SiliconFlow 官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。

2.2 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

```bash  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
### 3.2 创建虚拟环境并安装依赖
```

---

## cd 到 DB-GPT 源码根目录

**URL:** llms-txt#cd-到-db-gpt-源码根目录

---

## DB-GPT 要求python >= 3.10

**URL:** llms-txt#db-gpt-要求python->=-3.10

conda create -n dbgpt_env python=3.10
conda activate dbgpt_env

---

## 复制模板 env 文件为 .env

**URL:** llms-txt#复制模板-env-文件为-.env

**Contents:**
  - 3.4 修改环境变量文件`.env`，配置 SiliconFlow 模型

cp .env.template .env
bash  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
### 3.4 修改环境变量文件`.env`，配置 SiliconFlow 模型
```

---

## NoteGen

**URL:** llms-txt#notegen

**Contents:**
- 关于 NoteGen
- 安装 NoteGen
- 在 NoteGen 中使用 SiliconFlow
- 在 NoteGen 测试使用 SiliconFlow DeepSeek-V3 模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-NoteGen

[NoteGen](https://github.com/codexu/note-gen) 是一款跨端的 `Markdown` 笔记应用，致力于使用 AI 建立记录和写作的桥梁，将碎片化知识整理成一篇可读的笔记。

本文将介绍如何借助 SiliconFlow 提供的 API 服务在 NoteGen 进行笔记的记录与写作。

浏览器打开 [NoteGen Releases](https://github.com/codexu/note-gen/releases) 下载对应系统的安装包。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3dd3484cc9d1b418e7fc8d01ce657635" data-og-width="1796" width="1796" data-og-height="868" height="868" data-path="images/usercases/notegen/notegen-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=275d0b574a05befb93c92303051bcb0e 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7f214c7caddce27097f2ce0c93519b72 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=230c4e45ab920b99741e36b2735a0392 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bf29466648a0eed62b55fb7e34722b87 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=404aa049ade02e4580fa08f83cea6338 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=03ec3d12b01917f1434481da39c74a2b 2500w" />
</Frame>

NoteGen 支持所有的主流操作系统，包括 Windows、MacOS 和 Linux，未来将支持 iOS 和 Android。

## 在 NoteGen 中使用 SiliconFlow

安装 NoteGen 之后，按照下面的步骤依次操作：

1. 点击左下角的设置按钮进入系统设置界面。
2. 在 Model Provider 中选择 SiliconFlow。
3. 填写在 SiliconFlow 后台新建的 API 密钥。
4. 点击 Model 下拉菜单选择你需要的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a254afe502e84f5108f8e4df2a84d464" data-og-width="2720" width="2720" data-og-height="1706" height="1706" data-path="images/usercases/notegen/notegen-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c7d99571488175a01f980bff4409a79a 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f27bf3df8acca931afdec1b867a154cf 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8b14c9410ccaf8b9894500aa6509f139 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3de9bca3b3eafb90362bb92c7b787d5e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=dd6b13a68d55793acd7802196e13c257 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ba5182230d643d61f4809284eb3bbaf2 2500w" />
</Frame>

完成上述操作后，如果 Model Provider 展示绿色对勾表示可以正常使用了。

## 在 NoteGen 测试使用 SiliconFlow DeepSeek-V3 模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=53fc38d27c64e5f2fa96d0641acd3512" data-og-width="2720" width="2720" data-og-height="1706" height="1706" data-path="images/usercases/notegen/notegen-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bbe7c815040808a8316357b65bd5bccb 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c8d34d85f2038f9065687d7923699851 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6177017fcca821a7e21a28cd418d3797 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f096eeb8050f125c5daab77088af4f2d 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a7d9e1066877f1df6aa7135e57edfb22 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/notegen/notegen-3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8e54404a17f34557112256f83f119a1a 2500w" />
</Frame>

---

## Bob 翻译

**URL:** llms-txt#bob-翻译

**Contents:**
- 1. 关于 Bob
- 2. 安装 Bob
- 3. 在 Bob 中使用 SiliconFlow
  - 3.1 默认配置
  - 3.2 使用 SiliconFlow 的其他免费模型
  - 3.3 使用 SiliconFlow 的其他文本生成模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-bob

[Bob](https://bobtranslate.com) 是一款 macOS 平台的翻译和 OCR 软件，您可以在任何应用程序中使用 Bob 进行翻译和 OCR，即用即走，简单、快捷、高效！

本文将介绍如何借助 SiliconFlow 提供的 API 服务在 Bob 中进行翻译。

前往 Mac App Store 安装 Bob。[Mac App Store 安装](https://apps.apple.com/cn/app/id1630034110)

## 3. 在 Bob 中使用 SiliconFlow

安装完 Bob 之后，在任意软件选中一段文本，然后按下 `⌥` `D` 快捷键即可翻译，SiliconFlow 的免费模型会作为默认翻译服务进行翻译，如下图所示。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=892f0670b71eb177e8dc980e263f8f26" data-og-width="2768" width="2768" data-og-height="844" height="844" data-path="images/usercases/bob/siliconflow-use-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9fa8e1586ed30ad81bb2e33023bfcc09 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bfd5cfc3340929cbcb515ac05e164bd2 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f7812eb0e0ec4ae1556041f051edd4fe 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7cdb944afc7609fbfec14aff0618adb6 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=23fcb3aaef61871edb0cf4c8427a66f4 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-1.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=51a0488ccec323618628d2d5865375f5 2500w" />
</Frame>

### 3.2 使用 SiliconFlow 的其他免费模型

默认使用的模型是 `Qwen/Qwen2.5-7B-Instruct`，可以使用**鼠标右键**点击翻译窗口右上角的服务图标前往「翻译-服务」页面切换其他免费模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=16b763683a28c57903e184087c12ead8" data-og-width="1116" width="1116" data-og-height="526" height="526" data-path="images/usercases/bob/siliconflow-use-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=5041e89af667fef60e2ab4cd58ccaaf3 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3749c53bb4c95f166b7ee91881d0da5e 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2c08fcf87f7dd152957165b0acd27cb2 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1b96f48e83b856e4d7dda0ed658ed527 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1cac43cbe190cad305d14435635d08e5 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=32d288173ee52034e39b89ef6ab08951 2500w" />
</Frame>

如下图所示，标注为**免费**的模型均可直接使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=150bbeef103c19ac609dee5a75413a44" data-og-width="2124" width="2124" data-og-height="1918" height="1918" data-path="images/usercases/bob/siliconflow-use-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=589a1f916cbb6598dd47fda58f652d87 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c3b30ed550c5542293cbf3a7c5fe4e72 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ca80c584df2bfe0f877b4f43dead9f9d 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6c4c2e926862e97c4807ed4e0cc5a059 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b9cd881ec55cec4779babd53427563fd 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=162a96a975dfa2968a0cdff67ad81bea 2500w" />
</Frame>

### 3.3 使用 SiliconFlow 的其他文本生成模型

如需使用没有标注为免费的模型，需要自行获取 SiliconFlow API Key。

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。
3. 进入之前提到的 Bob「翻译-服务」页面，将 API Key 填入**硅基流动翻译**服务的 API Key 设置项中，然后切换到需要使用的其他模型，点击保存即可使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=14327f02b2033253f84d9674a174a843" data-og-width="2074" width="2074" data-og-height="1624" height="1624" data-path="images/usercases/bob/siliconflow-use-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c87f0b4187d393ba3ad046b3481dba82 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a077893d797c297a31ba4e996ccaa072 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a0b7593de80a152ee044f2625fafdb69 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=477944680dfbc76ce23f7d0f8d675b70 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9652b36a0fe62293bbf1a214865dfabc 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/bob/siliconflow-use-4.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=987ae13b478805c4356d4081e4fac932 2500w" />
</Frame>

---

## Cline

**URL:** llms-txt#cline

**Contents:**
- 1. 安装 Cline
- 2. 打开cline
- 3. 在新窗口中进行配置
- 4. 开始使用

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-cline

[安装地址](https://marketplace.visualstudio.com/items?itemName=saoudrizwan.claude-dev)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cab729764c69e32df48c79f873f4ca59" data-og-width="1280" width="1280" data-og-height="841" height="841" data-path="images/usercases/cline/image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3b7dcb2215ce409fdfc98d8db1e12877 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d2873cee2ebfd7804a86ee6cce397256 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=45eded3625e37182a0b9b0fa7ee05aa2 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8f2b0e6d66e4c9235f9a1738fdcfed4d 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=252e314ed7be8cf0b9bbcae3b25e8daf 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1cac7b391d8302e99b10d7d1bac8a765 2500w" />
</Frame>

在VSCode中，通过 Ctrl/Command+Shift+P 打开命令工具，在新 tab 中打开 Cline 进行配置

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=be9199b024f53387f85e7c33f825b6af" data-og-width="1280" width="1280" data-og-height="405" height="405" data-path="images/usercases/cline/image_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=97aee5b5e41c69a0737d40e4b401c846 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2699fb45d8dcee4995752ec88da8fb43 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a4250e548073ff2bd48e414d3c503c74 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=495561545c796f0cec8cc5fbdddf7b79 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=fa0a0e420765fb28a6098eac5827556c 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_1.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=e146430d61e39cbaa40f9aba7565d097 2500w" />
</Frame>

1. API Provider：选择 “OpenAI Compatible”
2. Base Url：[https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
3. API Key：从 [https://cloud.siliconflow.cn/account/ak](https://cloud.siliconflow.cn/account/ak) 中获取
4. Model ID：从 [https://cloud.siliconflow.cn/models](https://cloud.siliconflow.cn/models) 中获取

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a6946fccb3be7952b8d8d783dd1bf336" data-og-width="3408" width="3408" data-og-height="2172" height="2172" data-path="images/usercases/cline/image_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6034d539633b3f8639e0ce5aeed57555 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=85985ac25d95e1c0f98bba1aca308a2d 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=fcf92d062dc6e71df13d37998f780642 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b1c682204bd68f0805b5b984c47f2610 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=28fa48488d2faad8e0fd7c3a42520249 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/cline/image_2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=23467f80d547cf9d975961530ceed6e1 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=883f8deaeae7354b0c19f57a8d7ce89e" data-og-width="1280" width="1280" data-og-height="813" height="813" data-path="images/usercases/cline/image_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1e8616963b5be3f810e399af8c8fd823 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a372261a009e1ddc586f3313c2802013 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02b5a019d341b2b8786f9fdcf60be1cd 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8c882ae1cf0d3d46359ff51f47bd35dc 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=66174f361c96a9161fedaa225dc036c3 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cline/image_3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e440c6c4cc4f33116545c2382157423c 2500w" />
</Frame>

---

## CodeWave

**URL:** llms-txt#codewave

**Contents:**
- 1、关于网易 CodeWave 智能开发平台
- 2、使用 CodeWave 创建应用
- 3、在 CodeWave 中使用硅基流动连接器
  - 3.1 添加连接器
  - 3.2 调用连接器

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-codewave

## 1、关于网易 CodeWave 智能开发平台

网易 CodeWave 是面向企业应用的智能开发平台，通过融合 AI 与可视化开发能力，帮助企业降低开发门槛、提升效率、优化协作方式，加速实现研发与应用智能化升级。

* 全栈可视化开发
* 支持导出应用和源码
* 100% 还原视觉稿
* 多项拓展能力开发复杂系统

## 2、使用 CodeWave 创建应用

* 点击注册体验 saas 版：[https://codewave.163.com/?fromlcap=gjld\_cw](https://codewave.163.com/?fromlcap=gjld_cw)
* 创建应用

* 进入“**应用中心**”->“**我的应用**”页面，单击“**创建应用**”按钮。
  * 编辑应用的基本信息，如应用场景、名称等。按照提示，完成创建。各基本信息的详细介绍，请参见下文：基本信息说明。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=da00ebe479422ba58b5df015ef719bcd" data-og-width="1242" width="1242" data-og-height="644" height="644" data-path="images/usercases/codewave/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=61e67db4976a97a3fc9d6163456d7729 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8f3416a7e1ab1a2cc2b6c748a4834c91 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=36949f16dd985170b2f6675395247821 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=165f761868648b1a742721f4471a4242 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5ee864c0078f67f349c89911739dd136 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/1.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=89f227a27a4ec9f6f0d22a8584d64311 2500w" />
</Frame>

## 3、在 CodeWave 中使用硅基流动连接器

\*\*对话：\*\*支持调用硅基流动对话接口，实现对接多种大模型对话接口，可指定模型等具体参数

\*\*生成图片：\*\*根据提示词生成图片，可指定模型参数

\*\*视频生成：\*\*根据提示词生成视频，可指定模型参数，返回本次请求 ID，可根据请求 ID 查询视频生成状态及视频地址。
\*\*列出模型：\*\*列出可用的模型列表，并提供相关模型的基本信息。

\*\*查询账户信息：\*\*查询当前账号余额和状态。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=31eaf78d3c31cf9f7315991485c0cc4a" data-og-width="1916" width="1916" data-og-height="948" height="948" data-path="images/usercases/codewave/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2056ee5322942354547fc64a20757735 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=05a561d3be487898d131260839b36ede 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7e613cf0ff46c152c25803ec49961041 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cc2d1d9569761b667bb856c97369848c 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8d725434ff18ad9fe400fd39f6a3450d 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fba11f7b5b977aae1ecefb539565b80f 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b8f4d8cb721af142f35374b463ded676" data-og-width="1267" width="1267" data-og-height="613" height="613" data-path="images/usercases/codewave/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e71a78291c5e882c95d52da393162f86 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1ce25c4d27313f64ac5db12c372b2217 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02fde731213e9125588c9b1ad16dc310 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=59ed94fae51cf62088c9e265f7c4645b 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c37a61b6f4f93aa4a7479b5563c004b0 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6d86bdd99cac221ec1cd8b677c160f89 2500w" />
</Frame>

1. 在应用中需要调用硅基流动接口的地方，调用连接器
2. 选择一个连接和一个操作，例如对话
3. 输入参数，对话接口需要传入对应的参数对象，并填入相关参数。针对必填参数说明如下：

* messages：messages 中的 content 可根据用户输入的对话内容动态传入，role 可以是 user
   * model：根据自己需要传入，目前根据官方说明填写，例如：deepseek-ai/DeepSeek-R1 或者 Pro/deepseek-ai/DeepSeek-R1
   * stream：需要传入 true，本连接器默认支持流式接口返回

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=30d05ed39a4788fb4e75aa887ed0ec20" data-og-width="1267" width="1267" data-og-height="619" height="619" data-path="images/usercases/codewave/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2de6ee801181159de8aada7e0aaa502a 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=efb93897e02f930fbb27a018baf0049d 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=22fac17134797800aed0b8aa79fecf64 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f55225ae3d710933c1de6d14dbd4d83c 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=93d0165ff835df0c272d2cd9409d5e1f 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d1bd7e20fb8a2e0bd91eb96fa093c3de 2500w" />
</Frame>

在 onMessage 子逻辑中对接口返回数据进行处理，然后显示到页面

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f7d0a0d93ea83aea10b5d2ffef5499e2" data-og-width="1267" width="1267" data-og-height="625" height="625" data-path="images/usercases/codewave/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2cc98e9d56bbec6dbeb31393b9398682 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9fcf3c39c49e8247679e018aba682715 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=06bfec69fc0bfb475868aecce4a9275f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=13bd1e519f34b27e7cc5fb3decdae8ae 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=01cf9372b7212df6dfe15e7e7c4de9fd 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/codewave/5.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8e13f002863f655a808e666b23517198 2500w" />
</Frame>

---

## 麦悠电台

**URL:** llms-txt#麦悠电台

**Contents:**
- 1. 获取 API Key
- 2. 在 Sider 中使用 SiliconFlow 语言模型系列
  - 2.1 下载安装麦悠电台
  - 2.2 配置 SiliconFlow 的 API 服务
  - 2.3 设置语音
  - 2.4 创建电台，获取新闻
  - 2.5 生成节目，收听节目
  - 3. 总结

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-cube-sugar-studio

麦悠电台（my.ft07.com）是独立开发者方糖开发的一款独具特色的 AI 电台 App，借助 AI 大模型为你打造专属播客。

通过与 RSS Hub、Wewe-rss 订阅器的配合，麦悠电台用户可在麦悠电台订阅上千个媒体平台和微信公众号来获取资讯。电台支持本地/云端 TTS 合成，可自由选择多种 AI 音效。在电台中生成的播客还支持分享、导出音频/视频格式，为内容创作者提供了极大便利。

本文将介绍如何借助 SiliconFlow 提供的 API 服务，在麦悠电台创建你的个性化播客节目。

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Sider 中使用 SiliconFlow 语言模型系列

IOS 用户可打开苹果商店进行搜索安装。Android 用户可[下载 APK](https://the7.ft07.com/Maidio/maidio-byok-1.0.9-b29.apk) 安装。

### 2.2 配置 SiliconFlow 的 API 服务

打开麦悠电台 App 首页，点击左上角任务栏中的“设置”，在“AI 设置”中粘贴从 SiliconFlow 获取的 API Key，保存设置，就可以使用 SiliconFlow 上的相应模型了。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=03f6b2ebef46ef9ce0c8cbc33fcb67f7" data-og-width="1080" width="1080" data-og-height="1201" height="1201" data-path="images/usercases/cube-sugar-studio/cube-sugar-1.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=14ba10c49100a4e681a61d6634f0904d 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7b099d14d4a2a9dc41c9dcb135c736f9 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ccd593c7a3916f03bff467990e1dd4f4 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=60260cc6399d965db7d491dea77cf985 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=796a1897b04a36f9daff3cccc8d95d2a 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-1.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=75dae8c316dcf0373022574a7c856c07 2500w" />
</Frame>

1. 点击顶部导航栏的“语音”标签，在“本地语音”页面选择主持人和助理的语音引擎，调整语速、音调和音量，点击“声音”按钮可以试听效果。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f21062443ced343fa70aa8eaac2fe47c" data-og-width="1080" width="1080" data-og-height="661" height="661" data-path="images/usercases/cube-sugar-studio/cube-sugar-2.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a6e05901b3aa60c210ad93a60a99455b 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=86884f7f305f0838b48a0cd42b2b54dd 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=eae6633dda42e00983ee764d091b255e 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=454f0791fc26f73924b751a0c6c9d8e9 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=adccc588f8d1c646947141576a4a075a 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-2.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9d32ca9fb59c702548d98596ff4aa4a1 2500w" />
</Frame>

<Note>
  Android 系统，请先在系统设置中安装中文语音包，推荐使用小米和 Google 的语音引擎，选择合适的中文语音。

如iOS 系统，进入设置→辅助功能→朗读所选内容→声音→中文→月/瀚→下载高质量语音，重启应用，即可在本地 TTS 中选择使用 Yue/Han 的高质量语音。
</Note>

2. 接入 SiliconFlow 提供的 API Key 后，通过平台的音频模型 `fishaudio/fish-speech-1.5`，用户可以进一步测试 "云端语音"，享受 8 种开箱即用预置音色。

1. 点击主界面右上角的“+”按钮，自定义电台名称，添加 RSS 订阅源，直接输入 RSS 地址（每行一个）或导入 OPML 文件。

2. 在主界面点击电台右侧的 RSS 图标，点击右上角的刷新按钮，获取最新内容，等待新闻加载完成。

1. 在新闻列表中选择感兴趣的新闻，点击底部的”创建节目”按钮，根据自己的兴趣选择新闻喜好（分为详细、摘要、略过、原文四个选项），等待 AI 生成对话内容。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=68d585b8ad7f70ccc8c9ad7385db6f5a" data-og-width="1080" width="1080" data-og-height="1025" height="1025" data-path="images/usercases/cube-sugar-studio/cube-sugar-3.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7f4b2d72634205ff22c34a31bd781ecf 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fb0a46ddff8a96f4838cbda584ba2fe1 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a399004e099f4458230b69c01f466e9a 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=eaedcdc1a184764961a717c51c1df135 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1cd622474c8c28a11f0dc81fa66aa9f1 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/cube-sugar-studio/cube-sugar-3.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1e6a0eced81cada6cbde15cec6fc664d 2500w" />
</Frame>

2. 返回主界面，点击电台右侧的播放按钮，即可享受 AI 主持人为你播报定制化的新闻内容。

如果你想开发一个麦悠电台这样的 AI 应用，想快速地测试各类大模型效果或让用户使用高性价比的模型服务，可以选择接入 SiliconFlow 的 API 模型进行快速体验。

---

## DeepStudent

**URL:** llms-txt#deepstudent

**Contents:**
- 1、关于 DeepStudent
- 2、安装 DeepStudent
- 3、DeepStudent 中试用硅基流动
  - 默认配置
  - 切换模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-deepstudent

DeepStudent 是一款免费开源的 AI 错题管理解决方案，专为追求高效学习的学生和教师设计。 DeepStudent 通过人工智能技术革新传统错题整理方式，使用户可以自由使用最先进的 LLM、VLM 模型进行分工协作，进而使学习更高效，让知识更牢固。

为了提升用户体验，DeepStudent 现已全面接入硅基流动大模型云服务平台的 API 服务，支持用户灵活接入 DeepSeek、Qwen 等主流 LLM 及 VLM 模型，在开发流程中引入自然语言交互能力，辅助错题整理、优化知识点逻辑体系，进一步提升学习效率。

[DeepStudent](https://deepstudent.cn) 是一款 macOS、iPadOS、PC 平台的免费开源的 AI 错题管理应用程序，您可以在应用程序中管理错题，数据本地化、简单、快捷、高效学习。本文将介绍如何借助硅基流动提供的 API 服务在 DeepStudent 中进行使用。

前往 [Deepstdent 官网](https://deepstudent.cn)，安装 DeepStdent。

## 3、DeepStudent 中试用硅基流动

#### 步骤 1：获取硅基流动（SiliconFlow）API 密钥

1. 访问官网：打开浏览器，访问 [硅基流动](https://cloud.siliconflow.cn/i/deadXN1B) 官方网站。
2. 注册/登录：完成账户注册并登录。
3. 创建API密钥：在"API 密钥"页面，创建一个新的密钥。给它起个名字（如 deep\_student\_key），然后立即复制并妥善保管这串 sk- 开头的密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=96b49d39b0016510ac40c13b7b938f5d" data-og-width="1418" width="1418" data-og-height="888" height="888" data-path="images/usercases/DeepStudent/1.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=f32005a7215828558369107c6bc6df7d 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=1eed1818070fd0bd9ea4fe6b5d5f3b9f 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=0bc6c8269a56ab5fffd2b018f238f1d5 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=77d5fc883b20ccc7319322566242e744 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=40506ca835d19990f99cd7b7951831c7 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/1.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=5b59f2364ba239324045cfc8ca3f5ada 2500w" />
</Frame>

#### 步骤 2：在 DeepStudent 使用硅基流动提供的模型服务

如果你对模型没有了解，只想直接使用，推荐完全按照以下默认配置来。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=be09f3720b0f6183446ff8a1b4f934ac" data-og-width="2304" width="2304" data-og-height="1274" height="1274" data-path="images/usercases/DeepStudent/2.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=280&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=4e1f2a5322f5588eac594e50c218daf2 280w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=560&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=2dfb96fd297e87193d7a9208f2d931eb 560w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=840&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=db61ff852fa681bdf847eb6ce9c8ebd4 840w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=1100&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=c67f92cfb98902f69efe2ac43d6f647e 1100w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=1650&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=a1e13c6a5a312045a317a97140d541cd 1650w, https://mintcdn.com/siliconflow-37161621/lraNstG3w6Lot0Ag/images/usercases/DeepStudent/2.jpg?w=2500&fit=max&auto=format&n=lraNstG3w6Lot0Ag&q=85&s=3ab22ce11e21ae2ab3d3c987234658c2 2500w" />
</Frame>

1. 启动应用，点击左侧导航栏底部的齿轮图标进入 设置 界面。
2. 导航至 API 配置：在 设置 页面中，输入 sk- 开头的密钥，点击 一键分配 即可，软件会自动完成 API 配置的创建和模型分配。

你可以从硅基流动官网的模型广场找到所有可用的免费或付费模型。

借助 DeepStudent 与硅基流动大模型云服务平台的深度集成，错题整理正变得更加高效与便捷。用户可通过自然语言描述错题或困惑点，AI 将智能分析、自动归类并关联薄弱知识点，显著提升错题消化与复习效率。在 DeepStudent 中，AI 正逐步从“整理助手”升级为“学习伙伴”，为高效学习带来质的飞跃。

---

## Dify

**URL:** llms-txt#dify

**Contents:**
- 1. 获取 API Key
- 2. 在 Dify 中使用 SiliconFlow 语言模型系列
  - 2.1 调用 Dify 中内置的 SiliconFlow 模型的 API
  - 2.2 使用目前不在 Dify 源代码中的 SiliconFlow 模型
- 3. 在 Dify 中使用 SiliconFlow 生图模型系列

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-dify

结合 SiliconFlow 模型多、速度快的优势，在 Dify 中快速实现工作流/Agent

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Dify 中使用 SiliconFlow 语言模型系列

### 2.1 调用 Dify 中内置的 SiliconFlow 模型的 API

1. 打开 SiliconFlow 官网 并注册账号（如果注册过，直接登录即可）。 完成注册后，打开 API 密钥 ，创建新的 API Key，点击密钥进行复制，以备后续使用。
2. 在 Dify 首页右上角选择“设置”，选择左上角“模型供应商”。
3. 找到“ SiliconFlow ”，粘贴先前在 SiliconFlow 平台复制的 API Key，然后点击“保存”按钮。
4. 校验成功后可以在模型提供商的顶部区域看到 SiliconFlow 提供的模型，并在应用中使用 SiliconFlow 模型。

### 2.2 使用目前不在 Dify 源代码中的 SiliconFlow 模型

1. 打开 Dify 的“ Settings ”进行设置。
2. 选择导航栏“ Model Provider ”，添加兼容 OpenAI 接口的模型服务平台。
3. 在其中设置对应的 SiliconFlow 对应的 Model Name 、 API Key 、 API 端点。

* **Model Name:** 从[model-list](/api-reference/models/get-model-list) 文档中选择
* **API Key:** 从[https://cloud.siliconflow.cn/account/ak](https://cloud.siliconflow.cn/account/ak) 中获取
* **API 端点 URL：** [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)

4. 设置完成后，可以在模型列表中看到上述新增的模型。

## 3. 在 Dify 中使用 SiliconFlow 生图模型系列

参考[在 Dify 中使用 SiliconFlow 生图模型系列](https://docs.dify.ai/zh-hans/guides/tools/tool-configuration/siliconflow)

---

## 飞书多维表格

**URL:** llms-txt#飞书多维表格

**Contents:**
- 使用方法
  - 1. 进入飞书，点击 “多维表格”，“新建多维表格”。
  - 2. 创建 DeepSeek-R1 AI 字段捷径
- 错误码信息
- 联系开发者
  - 官方群

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-feishu

飞书多维表格已正式接入硅基流动 SiliconFlow 平台，你可以直接在多维表格的 AI 字段捷径中心调用平台上包括 DeepSeek-R1、QWQ-32B 等热门大模型，搭配多维表格的批量结构化数据处理和业务自动化构建能力，一键完成创作、翻译、分类、总结等操作，享受更快、更准、更聪明的数据管理体验。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-1.gif?s=4a446bd498b66c1a649b7eee4a04c4b1" data-og-width="888" width="888" data-og-height="526" height="526" data-path="images/usercases/feishu/feishu-1.gif" data-optimize="true" data-opv="3" />
</Frame>

### 1. 进入飞书，点击 “多维表格”，“新建多维表格”。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5bcaf6826fa3956636ed989913cf14de" data-og-width="1080" width="1080" data-og-height="685" height="685" data-path="images/usercases/feishu/feishu-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dcc6b759fbadce1cc1d2aa06c430face 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7279c9b80aadf86d5513fe31643bd87f 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=377351734991d9510def5d5ad894b615 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0709b3d8928654f23a77d00e2a3ef3de 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a0dd7b6676365b3748dc4041ba36e5f3 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1b2d2b214226f1dc3e4f2d83408abe19 2500w" />
</Frame>

### 2. 创建 DeepSeek-R1 AI 字段捷径

* 在左侧的导航栏中打开需要使用的数据表，创建文本字段，输入任务关键词（如"自媒体文案主题"），该字段将作为后续 AI 任务指令的引用字段。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2c1d259962726ca7ec009bb9abcae940" data-og-width="702" width="702" data-og-height="583" height="583" data-path="images/usercases/feishu/feishu-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1431fec95fcfa17b49ff146b4894ce17 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=975fcd7f78f75ea043017dd243bc1959 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c3667fea2b18cdf9c70b7cf19332b0f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7388f36c0a2dcdd0aeecc1a9fdb9cf90 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d5fb5130472eaf4380fcd0b7b249f775 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c19735637510217e5c011a6430fd4560 2500w" />
</Frame>

* 点击字段名右侧的“+”或搜索字段。点击悬停字段类型的 “探索字段捷径” ，搜索“硅基流动”并选择 “AI 大模型（硅基流动）”。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=98541de8706a2a6c575c6c6afc5cc805" data-og-width="1024" width="1024" data-og-height="740" height="740" data-path="images/usercases/feishu/feishu-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=97c3b47cf7478e739d6d554b34570467 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=930f2af5f8b0bff8884f18bbf6ce0c8f 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e66d79acbe4cb3837f235065b4c1959e 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8f1bdce7b6dd9d22800ea956156dc2b3 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=121cb61d4b76bf8f4716bccf761bbead 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5a7c93b2349949d2d753cc05e608c507 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02685fe5c9f1a3f35a86aba6a47d72bc" data-og-width="1024" width="1024" data-og-height="788" height="788" data-path="images/usercases/feishu/feishu-5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=31b1cd99c5aa71eaf24a1297e51b53df 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f7ad2e8ff268c1e1a9dccbf5ec4971d5 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7e42f5e6d78571b354b8df3ac2124249 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=27e6e17d976140127a9090fa3be9f285 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e29122ec27606cb51f5228510b090f00 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-5.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=af57c9346523182334c7088af939c293 2500w" />
</Frame>

* 点击“关联账号”按钮，跳转 硅基流动 SiliconFlow 平台以获取 API 密钥，复制 API 密钥，返回当前页面，将 API 密钥粘贴至指定输入框内。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=717187ba43bb8ca32d118317c3f3c738" data-og-width="1024" width="1024" data-og-height="703" height="703" data-path="images/usercases/feishu/feishu-6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=56a70062f8bff97b91083617495378a6 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=58b91949dc9642f09a41fc487fc69ae0 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9f46e38dcec69f32d4aa25b19948d179 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7f85256aa7effc48c6f627070ba72a3c 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9ac4702df4ca7514673c6e55ac209fb9 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-6.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=64b351cc864fc557267b07cebbd72b1c 2500w" />
</Frame>

硅基流动 SiliconFlow 默认提供 Qwen/QwQ-32B、Pro/deepseek-ai/DeepSeek-R1、THUDM/GLM-Z1-32B-0414 和 DeepSeek-R1-Distill-Qwen-32B 四款 AI 模型，用户可以按需选择。

* 在"输入指令"栏中直接输入文字指令，点击右上角 ”+引用字段” 添加数据表字段，系统自动将输入文字与引用字段拼接为完整指令。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c1be686bfa68ab945500667e4eac03b" data-og-width="978" width="978" data-og-height="690" height="690" data-path="images/usercases/feishu/feishu-7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a32e66b16512a44ace1b52156b913da6 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1a3e3951c806b9c4f1cad10c165da632 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3e35f95d0e9ec603dcf29a9df1bf61e7 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7d481421b4f7c424d2448ce89e8cb058 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=92172c4d2ba4d00cf8d90187b896a608 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-7.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=93b47df49059930b7319db147e5bbe3a 2500w" />
</Frame>

* 点击“确认”并生成内容，查看字段名右上角百分比可得知任务处理进度，任务完成后图标自动消失。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b4a968c5e561987a2af67157a28652ff" data-og-width="1080" width="1080" data-og-height="510" height="510" data-path="images/usercases/feishu/feishu-8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0079c54dd969a4926bcef3a3e7e257eb 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4e1e0a905ed3ae1cb834582f8c04c540 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b94d1b807e2b66f11d3839010f4c6fef 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ef08b4a3fd8f865046d9dcee2bd2adae 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ff90947b67464a54be8a75d89a487148 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-8.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fd9a82e48e0efa5deca8af9f19817edf 2500w" />
</Frame>

* 鼠标光标悬停在字段列的任意单元格，点击“查看”，上下滑动即可浏览模型生成的完整内容，包括模型执行任务时的思考过程和输出结果。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=569a2ecbe4a45f1414f4e698ba49c8da" data-og-width="1080" width="1080" data-og-height="510" height="510" data-path="images/usercases/feishu/feishu-9.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=172fb2e904934f58272add1e967ae77c 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b9cd38fb231fe1634acf4bbc8536e39a 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7636514f98f07ee0f59c451bf62c83d6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fe2236897e718dedac9578e9f0e96554 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=279725cd46d3d7630225f1f5b2aaa7df 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-9.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=972c3e5fc30e8da9d41d3ceb9f2472da 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-10.gif?s=d6bd02ed60555270f3101acbd67d5d5c" data-og-width="1079" width="1079" data-og-height="849" height="849" data-path="images/usercases/feishu/feishu-10.gif" data-optimize="true" data-opv="3" />
</Frame>

* 你也可以双击单元格查阅对应的生成内容。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dd6bf18c84b12c48ec27d8281d320b4e" data-og-width="1080" width="1080" data-og-height="590" height="590" data-path="images/usercases/feishu/feishu-11.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b45cc924614e491c572fac015c76c1f0 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=893459dd6682e505fc700d45234b7d55 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=af31d1ec4d0c3e7dccffdaca3baf91b5 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7417fd2b7c9692fde43b44d44bbcd786 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ddcd9613dc5248b378cf8098e3a3b1ae 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-11.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a78e392e8729f1e183ade02b352557e1 2500w" />
</Frame>

注：“硅基流动”字段捷径开箱即用，尝鲜用户会有部分免费配额，超过上限后，用户可自助绑定硅基流动 SiliconFlow 账号继续使用模型。

| **错误码**   | **原因**                                     | **解决方案**                                |
| --------- | ------------------------------------------ | --------------------------------------- |
| 800004780 | 密钥填写错误                                     | 确认密钥正确填写                                |
| 800004781 | 当前捷径有大量任务处理中，请稍后重                          | 可能遇到高峰期，稍后重试                            |
| 800004782 | 1. 飞书赠送额度已用完；2. 需要绑定个人硅基流动账户使用额度           | 硅基流动绑定自己的 api key，                      |
| 800004783 | 高峰期排队导致服务超时                                | 等待一段时间后刷新，不要频繁刷新                        |
| 800004788 | 高峰期排队导致服务超时                                | 等待一段时间后刷新，不要频繁刷新                        |
| 800004789 | 1. 飞书赠送额度已用完；2. 需要绑定个人硅基流动账户使用额度；3. 密钥填写错误 | 请对照以下几个方案依次排查：1. 查看硅基流动账户余额；2. 确认密钥正确填写 |

点击此处的“联系开发者”进入话题群，也可以通过直接扫描下面官方群二维码进入。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=40789132bcf91e7f51bfa832d45402ec" data-og-width="1280" width="1280" data-og-height="398" height="398" data-path="images/usercases/feishu/feishu-12.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6d69972af2f20803eaf6a1969a740a69 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dc63eb714085bea06d44d2a4635ac18e 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7dd71e6770b014571662b7d475f77acb 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3d549f18b732501b3d1554abbb578624 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d46a08ad0691d27ace74c5c301f3d1f1 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-12.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=82dc96b146fa48a2a8bba1216981ec2b 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e6c723ba434c1799e6eebca003df6b76" data-og-width="744" width="744" data-og-height="754" height="754" data-path="images/usercases/feishu/feishu-13.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1dadbe60e50bba220bda5e3585332de1 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9a613239ddb9eda21ff66b6aa5c508ce 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=258573da3f32ca3923407a9c2ce742a6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b3ac27524c2251f357feb8450296e6c9 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ca95617f8f2362e677505e7626c3daa1 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/feishu/feishu-13.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=36a0ee6f7219c52bf2d115a6f714c3ec 2500w" />
</Frame>

---

## 沉浸式翻译

**URL:** llms-txt#沉浸式翻译

**Contents:**
- 1. 获取 API Key
- 2. 在沉浸式翻译中使用 SiliconFlow
  - 2.1 默认配置
  - 2.2 使用 SiliconFlow 的其他免费模型：
  - 2.3 使用 SiliconFlow 的其他文本生成模型：

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-immersive-translate

在沉浸式翻译中，调用 SiliconFlow 的 API，实现快速跨语言翻译的目标

作为全网口碑炸裂的双语对照网页翻译插件，[沉浸式翻译](https://immersivetranslate.com/)使用大语言模型，具备跨语种理解能力，能够实时翻译外语内容，可应用于网页阅读、 PDF 翻译、 EPUB 电子书翻译、视频双语字幕翻译等场景，并支持各种浏览器插件和应用使用。自 2023 年上线以来，这款备受赞誉的 AI 双语对照网页翻译插件，已帮助超过 100 万用户跨越语言障碍，汲取全球智慧。

硅基流动的 SiliconFlow 第一时间提供 GLM4 、 Qwen2 、 DeepSeek V2 、零一万物等大模型，将三方大模型和沉浸式翻译插件相结合，极大改善翻译时的速度和准确度。

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在沉浸式翻译中使用 SiliconFlow

1. 在“沉浸式翻译”[官网](https://immersivetranslate.com/zh-Hans/)选择“安装浏览器插件”，选择合适的浏览器版本，根据提示进行安装。如您已安装对应插件，请跳过本步骤。
2. 点击沉浸式翻译拓展，点击设置，出现弹窗，将弹窗中的“翻译服务”设置为“ SiliconFlow 翻译”
3. 设置成功后即可开始使用 SiliconFlow 翻译服务。

### 2.2 使用 SiliconFlow 的其他免费模型：

1. 设置的默认模型是 SiliconFlow 的“ Qwen/Qwen2-7B-Instruct ”，如果需要切换成 SiliconFlow 的其他模型，请点击图标中的“设置”，打开设置界面。
2. 在“基本设置”中选择其他模型，即可使用 SiliconFlow 的其他免费模型。

### 2.3 使用 SiliconFlow 的其他文本生成模型：

1. 如需使用 SiliconFlow 其他模型，点击沉浸式翻译的扩展图标，找到“设置”按钮并点击，选择“更多翻译服务”。
2. 代开设置页后点击“翻译服务”，划到底部，点击`添加兼容 Open AI 接口的自定义 AI 翻译服务？`。
   3.根据要求添加 SiliconFlow 模型的相关信息

* **自定义翻译服务名称：** 按照自己的实际情况填写即可。
* **自定义 API 接口地址：** [https://api.siliconflow.cn/v1/chat/completions](https://api.siliconflow.cn/v1/chat/completions)
* **API Key：** 将 SiliconFlow 平台的密钥粘贴到此处。
* **模型名称：** 模型在 SiliconFlow 中的名称

3. 完成配置后，点击右上角的测试，进行验证。

4. 配置成功后即可开始使用其他文本生成大模型。

---

## LangBot

**URL:** llms-txt#langbot

**Contents:**
- 关于 LangBot
- 配置教程
  - 第一步：获取硅基流动 API Key
  - 第二步：部署并配置 LangBot
  - 第三步：接入平台（以钉钉为例）
  - 第四步：使用机器人

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-langbot

[**LangBot**](https://langbot.app) 是一个开源的即时通信机器人平台，支持接入 **飞书、钉钉、QQ、微信、Discord、Telegram 等多种消息平台**，帮助用户直接在这些平台内进行任务处理或作为业务组成部分。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=00a694ed6ec0124acd6643a90dbd8b16" data-og-width="2724" width="2724" data-og-height="1706" height="1706" data-path="images/usercases/langbot/hero.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=596bf53d931fa7c8cc17bddac889bb6b 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f1ef347ceeec81b95e9ff7cd2c664cfb 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e133ea8dcee99e3e1852ed5fa1665555 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=71e5ec5e0fe5a86f40d0c3cd099daa6d 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=163d978dddb5f80e64e0b3ea0aef3e35 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/hero.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=28e3e9041f8e50766fa9276353399b58 2500w" />
</Frame>

结合 [**SiliconFlow**](https://siliconflow.cn/zh-cn/siliconcloud) 提供的大模型 API 服务，LangBot 可以接入多种主流开源大模型，用户可根据不同场景需求选择合适的模型。以下为完整的配置教程，简单几步即可拥有专属智能助手。

### 第一步：获取硅基流动 API Key

1、注册并登录 [硅基流动](https://cloud.siliconflow.cn/)。

2、进入`API 密钥` 页面，生成 API 密钥。

访问 `模型广场` 查看可用模型及详细参数。

### 第二步：部署并配置 LangBot

#### 使用 Docker 部署 LangBot

> 更多部署方式可查看[文档](https://docs.langbot.app/zh/insight/guide.html)

> 如果在中国大陆使用，可将 `docker-compose.yaml` 中的镜像替换为：

首次运行会提示创建配置文件，请根据提示完成初始化。

1. 登录 WebUI，进入 **模型配置** 页面。
2. 添加新模型，填写如下信息：

| 字段      | 内容                           |
| ------- | ---------------------------- |
| 模型名称    | 根据需要选择的模型名称，可以在硅基流动的模型广场页面获取 |
| 模型提供商   | 选择`硅基流动`                     |
| API Key | 从`硅基流动`-`API 密钥`页面获取的密钥      |
| 模型能力    | 根据硅基流动页面描述勾选                 |

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3788bf4d75c8ccd90ce5a70bf560c2d7" data-og-width="1446" width="1446" data-og-height="474" height="474" data-path="images/usercases/langbot/find_model_name.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=28eaed3615bbeacb43970d4c9aa46a44 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=38629a22fc5764b25810bbfae0ba131d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eb6176e8982f854b25f426b6e4c608c7 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0bf5b0958e06258e41b6bfb19c67e829 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=411d3690b994d4adb196a690c06bc303 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/find_model_name.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1c50988a8bd5adbe9bea268df74acc2c 2500w" />
</Frame>

模型名称可在 SiliconFlow 模型详情页标题找到。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e0a007a33a43b8d79ddd089ff6d5b2a2" data-og-width="2426" width="2426" data-og-height="1584" height="1584" data-path="images/usercases/langbot/create_model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=df9476f262b3a638dd213c7233b40318 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d184833aa5a86080c8f03511cdbc1cc2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=aa73bd3c9a4fb0fa257cb83a4e097d49 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=5e287375f29a099b4c0850919b2efe87 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e538662bf3e9430e01647b6bca105dea 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_model.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=22cf8a5905d36ca1bc0623972f55a14f 2500w" />
</Frame>

> 企业微信、飞书、Discord、Telegram、QQ、微信 等更多平台，请参考 [LangBot 文档](https://docs.langbot.app/zh/insight/guide.html)

1、登录 [钉钉开发者后台](https://open-dev.dingtalk.com/)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6308b4c3a10ef3be46f576ea7a6890d5" data-og-width="2814" width="2814" data-og-height="1425" height="1425" data-path="images/usercases/langbot/dingtalk_1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=50ffcc392f7ba69de2b13a753fb0fb6d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=acc53f8a45173c250fa816414080d74e 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=da50a6a380c2d69e37172ec0ef9b51b5 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1f0905b06d75c33902b931ab51584483 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8876c266705c3193f57e203a0978e6dd 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=075bb0daa788496ba9471d26d4aadc72 2500w" />
</Frame>

2、进入组织，点击「应用开发」→「创建应用」，填写基本信息。

3、添加「机器人」能力，完成基础配置并发布。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=032269050da1291a4d9800e5f1e2fb91" data-og-width="2858" width="2858" data-og-height="1301" height="1301" data-path="images/usercases/langbot/dingtalk_2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c49f22954a522a9fbc010054e0f348be 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e3446fea0a915c059de90aa9bfe7f670 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0f521ad82aad99636882effe91889c2c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4ea3bad7f97491dd1f9c0b1461e17ce5 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8cbc1400a0e0c42a92ffcaa160370ed7 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3656b41f1b4ad2fe1ef916e0f88d957b 2500w" />
</Frame>

* 在「机器人」选项卡中填写相关信息并发布。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0b5ecdbbe56332bf2c0eb45ea0026eed" data-og-width="2857" width="2857" data-og-height="1435" height="1435" data-path="images/usercases/langbot/dingtalk_3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3691d089d18ff7163f9df69305df1401 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=53a45ad6bbec245438e83cd76b77128f 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c3a930aef432be435b1c4fdf94a5bf39 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b49ca7499292deedc11c50128f51f2cc 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ba369aafaefb7bf3ce7341d78d7d6a4e 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ced9c9b98e0449bc7c038340a22962ff 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c0a4e49c870aa41493d3105ac3ea7826" data-og-width="2857" width="2857" data-og-height="1385" height="1385" data-path="images/usercases/langbot/dingtalk_4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6f4a6acf80db91f640d0ef4fd313b80f 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=674c19995dbf9cd68bc458517416fafa 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2763ce71f45667a3a4a5de60a1938883 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4481eb8e36c117fb880aac8b71e4f86e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c82ed5efc16b2b11f9170d577c5829d8 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/dingtalk_4.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e6f0046549e758c4dbea67cbdbbb63f2 2500w" />
</Frame>

* 在「事件订阅」中选择 **Stream 模式**，无需公网回调地址。
* 在「凭证与基础信息」中记录：
  * Client ID
  * Client Secret
  * RobotCode
  * 机器人名称

1、打开 LangBot WebUI，编辑机器人。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=afbc3c91969dc888e19e77f58d67a9ed" data-og-width="1024" width="1024" data-og-height="1644" height="1644" data-path="images/usercases/langbot/create_bot.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b3f7c113f56986f3b8bc3585e5545d01 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=876db36147ba10c03c6e56ceda561173 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a8b2458104111de67af8d456c2b74636 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a6461349b9f306c0344c356a82f26e85 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=78f926209f6eb5d5dc8dee6b524783b0 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/create_bot.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6c3d26cfd5d828324133a45296363071 2500w" />
</Frame>

2、绑定流水线（默认已有 `ChatPipeline`），平台选择 **钉钉**。

3、编辑流水线，在 AI 能力中选择 **内置 Agent**，并选择此前配置好的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6fd094208feb27654bdd29464d74a602" data-og-width="1614" width="1614" data-og-height="1402" height="1402" data-path="images/usercases/langbot/config_pipeline.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=988565cdbef754123cd70ff9c88ba49b 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=626853bc803accb7eaf75702291068da 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6220d5e2c451d2fb4b62727794f5a28b 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0e20b32df6e35c918c7d8f08ec8a0a37 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2d52b7aa3d417d3b208e66b90e16d262 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/langbot/config_pipeline.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=584388fe2cf26208ca6da1b2f9172b84 2500w" />
</Frame>

1、在钉钉搜索机器人名称，点击即可开始聊天。

2、如需在群聊中使用，可在群设置中点击「添加机器人」，搜索名称添加。

**Examples:**

Example 1 (unknown):
```unknown
> 如果在中国大陆使用，可将 `docker-compose.yaml` 中的镜像替换为：
```

Example 2 (unknown):
```unknown
#### 访问 WebUI

启动后访问：
```

---

## minbricks 智能小说编辑器

**URL:** llms-txt#minbricks-智能小说编辑器

**Contents:**
- 1. 关于 mindbricks
- 2. 安装 mindbricks
- 3. 在 mindbricks 中使用 SiliconFlow
  - 3.1 默认配置
- 3.2 使用 SiliconFlow 的其他文本生成模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-minbricks

mindbricks 是一款 macOS 平台与 Windows 平台皆可使用的智能小说编辑器，您可以将它下载到您的电脑上进行使用，感受 mindbrikcs 带来的写作新体验！

本文将介绍如何借助 SiliconFlow 提供的 API 服务在 mindbricks 中进行小说创作。

前往 [mindbricks 官网](https://mindbricks.cn) 安装, 选择合适的系统版本下载.

## 3. 在 mindbricks 中使用 SiliconFlow

安装完 mindbricks 之后，鼠标左键点击右下角的 \[齿轮] 图标，选择 \[模型设置] 。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=70b3dbc1d7c6039cb4878cf802545de8" data-og-width="830" width="830" data-og-height="474" height="474" data-path="images/usercases/mindbricks/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c633a21a517fe866b28bdd90584ce996 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2572c3425c273f91ca828f5206fc5ba0 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3a0fd23ddd4c285c30fb4a33fe61f3de 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=40d1405be675f0f69724bd542392080e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=fe3baa31d41358f9e99a309f3c630048 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4fbe7690e10bf3afa27b454908b4cb0b 2500w" />
</Frame>

在 \[模型] 中选择 「硅基流动（免费）」，鼠标左键点击保存。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=62ba60b3279092ed2a0420335f6ea331" data-og-width="830" width="830" data-og-height="878" height="878" data-path="images/usercases/mindbricks/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a9134baedfc14c317e2df952cc0ed2ef 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=493c13e8f128d0eeb3e9818cae9cefcb 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c268fe53de07a05fa8709c21d00ce166 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=96b0854743575771f27b5bf9c165d93b 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=978de3ddb09ee9695dbbb9143d284b70 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=311f2bff3ad2d77ab32aab347692add8 2500w" />
</Frame>

在主界面左键点击\[开始创作]，输入作品名称及作品位置即可创建新作品。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=166aff1534fa59f2df35a16134908b04" data-og-width="830" width="830" data-og-height="448" height="448" data-path="images/usercases/mindbricks/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f090f1fbc68fae116001e46026fa0aba 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=85515603098069176bec3ba4681806da 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=37fcd340bfdc346f0b6b1ee78e622b26 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=567927cdcaa994107754a068100da079 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=39c0e7fbf2834605e87d4cbba7970c88 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/4.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ace82e6017b6d894fefc8c7b4d7dd562 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=05428a369587db21459b753641a72756" data-og-width="830" width="830" data-og-height="320" height="320" data-path="images/usercases/mindbricks/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=569c1d1e8520e779d54458ad7f28fa2e 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e301f1fd4ee8e73936b67293a6933759 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=931ad0bf5a52d7d508a07d046c3aa85a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8a2e7762ee0221e0c59672dcefd6c9c1 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b056eed93e51fdda4e766795b3dc4f04 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/5.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8d22d434a230a195b1a8a4307c5706da 2500w" />
</Frame>

**注: 免费模型使用的模型是 Qwen3-8B，如需使用 SiliconFlow 的其他模型，需要自行获取 SiliconFlow API Key**

## 3.2 使用 SiliconFlow 的其他文本生成模型

打开 [SiliconFlow 官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。

完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

进入之前提到的 mindbricks \[模型设置] 页面，点击 \[模型]，选择 \[硅基流动] 将API Key 填入硅基流动服务的 API Key 设置项中，点击保存即可使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1b1e242c35054d0159183730079e4d84" data-og-width="830" width="830" data-og-height="474" height="474" data-path="images/usercases/mindbricks/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=673f14eac96fac93678475344796d03d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3b72459f6fef8c3dfd45320fdb7f56ae 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6d2f97fd162a765be194ad34c406d849 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3cddab1cdf499b6c05882c88eba8c64a 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eecae03f4ec4c1fe45bd8959aec3eb1d 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/6.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=fe14cc2125825ab6ea927c39754a779f 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e31ef8f7c1866fb5cd45cb9c4a1eb8da" data-og-width="830" width="830" data-og-height="456" height="456" data-path="images/usercases/mindbricks/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7254a7e3f2c6a27878dfb3faac967fb6 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1d7932b3222e1ccea5b89b85104bbdc8 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=5830c33166f2590d1bbce001581d2caf 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a9f99e0e1aaf347e5c6eae7c418f62d4 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3d49486f1ba4d01a19acfb7f41997297 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/mindbricks/7.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d46fca00857e8404d2265a098fada835 2500w" />
</Frame>

**注：MindBricks 已针对不同应用场景内置了不同模型，主要分为以下几类:**

* 对话模型: 在硅基流动服务商下默认为 Qwen/Qwen3-235B-A22B

* 角色模型: 在硅基流动服务商下默认为 Qwen/Qwen3-235B-A22B

* 推理模型: 在硅基流动服务商下默认为 deepseek-ai/DeepSeek-R1

若需要自定义完全自定义模型, 可使用自定义配置。

---

## 启动

**URL:** llms-txt#启动

**Contents:**
- 3. 上传到 HuggingFace Space

python -m mindsearch.app --lang en --model_format internlm_silicon --search_engine DuckDuckGoSearch
```

5. 启动前端。这里以gradio前端为例，其他前端启动可以参考MindSearch的README：
   `python frontend/mindsearch_gradio.py`

## 3. 上传到 HuggingFace Space

我们也可以选择部署到 HuggingFace 的 Space 当中。

1. 在 [https://huggingface.co/new-space](https://huggingface.co/new-space) 创建一个新的Space，
   配置为：
   Gradio
   Template:Blank
   Hardware:CPU basic·2 vCPU·16GB·FREE

2. 创建成功后，进入" Settings "设置 API Key。

3. 把第二步中的 MindSearch 目录、requirements.txt 和一个 app.py 一并上传。

app.py 详细内容请参考：[https://huggingface.co/spaces/SmartFlowAI/MindSearch\_X\_SiliconFlow/blob/main/app.py](https://huggingface.co/spaces/SmartFlowAI/MindSearch_X_SiliconFlow/blob/main/app.py)

---

## Obsidian Copilot

**URL:** llms-txt#obsidian-copilot

**Contents:**
- 1. 获取 API Key
- 2. 在 Obsidian Copilot 中使用 SiliconFlow 语言模型系列
  - 2.1 安装 Obsidian Copilot
  - 2.2 在 Obsidian Copilot中配置 SiliconFlow 模型
  - 2.3 在 Obsidian Copilot中使用 SiliconFlow 模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-obsidian

Obsidian Copilot 是一款开源的 AI 助手插件，设计简洁，使用方便。用户可通过自带的 API 密钥或本地模型与多种模型交互。支持自定义提示，快速与整个笔记库对话，获取答案和见解。旨在成为注重隐私的终极 AI 助手，深入理解您的个人知识库。
<br />如何在 Obsidian 中使用 SiliconFlow 模型呢？

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Obsidian Copilot 中使用 SiliconFlow 语言模型系列

### 2.1 安装 Obsidian Copilot

1. 安装 Obsidian 应用，详见[Obsidian 官网](https://obsidian.md/)
2. 在 Obsidian 中安装 Copilot 插件：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0ac70aac25ca77090e0fdfe614f47109" data-og-width="1856" width="1856" data-og-height="1364" height="1364" data-path="images/usercases/obsidian/Obsidian-1-安装.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a472017a32c6f20e254e348aed1c87fd 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=53d0d96ff10dd3aa7944d7b15f6b05c7 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8b36d4e82980df2ce73185ad84d3e73c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d798570da0bd3e216b55d922936309fa 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=573d6d5679e6871cdf5eeea94fa0b761 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-1-%E5%AE%89%E8%A3%85.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6083cba8d1f90806293408e6eef9261b 2500w" />
</Frame>

### 2.2 在 Obsidian Copilot中配置 SiliconFlow 模型

* 模型: [SiliconFlow 平台 LLM 列表](https://cloud.siliconflow.cn/models?types=chat)
* Provider: 3rd party (openai-format)
* Base URL: [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
* API Key: [获取 API Key](use-siliconcloud-in-obsidian#1-api-key)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b970b1282064c4a612e46052942e083b" data-og-width="1856" width="1856" data-og-height="1362" height="1362" data-path="images/usercases/obsidian/Obsidian-2-1-设置.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c074c2aa72b9ed1333fbafec0016675d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=78c5a92c28f5b8f3f2ae95096107bf5d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=546ba19aa64f4668a57dc5781cf19ffc 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b421ce89dd51ef98211cc9a9e7fbb1eb 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=81ce9fd3671bcc50fb06db679ccd7667 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-1-%E8%AE%BE%E7%BD%AE.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=11a3ac9d364d8e389d0b319e40128255 2500w" />
</Frame>

#### 2.2.2 设置 Embedding 模型

* 模型: 详见 [SiliconFlow 平台 Embedding 列表](https://cloud.siliconflow.cn/models?types=embedding)
* Provider: 3rd party (openai-format)
* Base URL: [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)
* API Key: [获取 API Key](use-siliconcloud-in-obsidian#1-api-key)

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8d95ab9e269b7b7b9d73acc07cfb2a77" data-og-width="1836" width="1836" data-og-height="1366" height="1366" data-path="images/usercases/obsidian/Obsidian-2-3-embedding.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ee71e3f115d2b69fc178391704881a9b 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=fe37e38df8344c0752e6b40ffbefde6d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e9551cd9b0fb084436463186db358c41 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3485e08c764faa5a498d48cd547a9bc0 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9c3ab0cf4370f3070b8351d85c850387 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-3-embedding.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c12cc0fd61aedfec10ecbea4ee255df2 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4973e8ecea66fd4969eb4c353f2d7ff0" data-og-width="1392" width="1392" data-og-height="918" height="918" data-path="images/usercases/obsidian/Obsidian-2-2-加载配置.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6b5bb51dd6369a69b85f5a3c55ad8bad 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=69f248e4c784322752596fe143513d9e 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ec44bec1d28c7d0438f07078a705ca66 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=eb67429c16bb5c2a64e1a2c71999a00c 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ed193acb316bc045b0e0debf385b838f 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-2-2-%E5%8A%A0%E8%BD%BD%E9%85%8D%E7%BD%AE.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9e2c9f042d0bf3f8bb63ffe8b25a0915 2500w" />
</Frame>

### 2.3 在 Obsidian Copilot中使用 SiliconFlow 模型

接下来就可以基于 SiliconFlow 模型和本地知识库进行检索和问答了。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=897fa6f1f60d3be88024c31c1bd8ba7a" data-og-width="2048" width="2048" data-og-height="1600" height="1600" data-path="images/usercases/obsidian/Obsidian-3-使用.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f309d11873e866e6963f6d729c8880f7 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ea7dc8f25853f7ece4e01dac25a6869a 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=761d022b12d0c9a1ba0fa28dc6b7aacd 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=edf13ab8be6b7ed613ce0879f4a69bbb 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=873bac23a2f70559d8164861960f6d4e 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/obsidian/Obsidian-3-%E4%BD%BF%E7%94%A8.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c1101fd62be7ba9cae6968d829558441 2500w" />
</Frame>

<Frame>
  <img src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/obsidian/Obsidian-3-2-QA-with-embedding.jpeg" />
</Frame>

---

## PDFMathTranslate Next

**URL:** llms-txt#pdfmathtranslate-next

**Contents:**
- 1. 关于 PDFMathTranslate Next
- 2. 安装
- 3. 使用
  - 免费翻译服务
  - 使用硅基流动提供的其他模型
- 4. 高级选项

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-pdfmathtranslate-next

## 1. 关于 PDFMathTranslate Next

[PDFMathTranslate Next](https://pdf2zh-next.com/zh/index.html) 是一款开源、保留排版的 PDF 翻译器。其翻译功能基于 funstory.ai 开源的 [BabelDOC](https://github.com/funstory-ai/BabelDOC) 项目，并在此基础上封装了易用的 CLI 和 GUI 界面。同时，它也是 BabelDOC 官方推荐的本地自部署方式。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/babeldoc-preview.gif?s=48116dc9d6710722f8bebadd8feaabd6" data-og-width="3840" width="3840" data-og-height="2424" height="2424" data-path="images/usercases/pdf2zh/babeldoc-preview.gif" data-optimize="true" data-opv="3" />
</Frame>

1. [**Windows EXE**](https://pdf2zh-next.com/zh/getting-started/INSTALLATION_winexe.html) <small>推荐用于 Windows</small>
2. [**Docker**](https://pdf2zh-next.com/zh/getting-started/INSTALLATION_docker.html) <small>推荐用于 Linux</small>
3. [**uv** (一个 Python 项目管理工具)](https://pdf2zh-next.com/zh/getting-started/INSTALLATION_uv.html) <small>推荐用于 macOS</small>

最新使用教程请参考 [PDFMathTranslate Next 硅基流动使用指南](https://pdf2zh-next.com/zh/advanced/TranslationServices/SiliconFlow.html)。

1. 在 "Translation Options" - "Service" 下拉列表中选择 "SiliconFlowFree"。
2. 点击页面下方的 Translate 按钮开始翻译
3. 翻译完成后，即可在页面下方的 "Translated" 一栏找到翻译后的 PDF 文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1efb52a94225abdc7cf8c0e4b8ad5ddb" data-og-width="3196" width="3196" data-og-height="2562" height="2562" data-path="images/usercases/pdf2zh/webui_free.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c4fee9a503415ea737c6dce4766f70c1 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=385cee7a463652108c9a81356d5922c2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=559266e2b25bbc1732d0247faad10620 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=94d268773da8959da2a2210d13c76ce0 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bd5bbfbda6fb13d46faa01a2e5f718d4 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0d3df98241f0fcbefac2fe003474e2e1 2500w" />
</Frame>

整体参照 [zotero-pdf2zh](https://github.com/guaguastandup/zotero-pdf2zh/blob/main/README_babeldoc.md) 的说明，将翻译服务配置为 "SiliconFlowFree" 即可。

文件内容将被发送到 PDFMathTranslate Next 项目维护者 [@awwaawwa](https://github.com/awwaawwa) 的服务器，然后转发给硅基流动进行翻译。

PDFMathTranslate Next 项目维护者仅收集硅基流动返回的错误信息以调试相关服务。您的文件内容不会被收集。

[硅基流动隐私政策](https://docs.siliconflow.cn/cn/legals/privacy-policy)

1. 注册一个硅基流动账号：[SiliconFlow](https://siliconflow.cn)
2. 创建一个 API 密钥：[SiliconFlow API Key](https://cloud.siliconflow.cn/me/account/ak)。然后，点击密钥以复制它。

1. "Translation Options" - **"Service"** dropdown list: 选中 "SiliconFlow"
2. "Translation Options" - **"Base URL for SiliconFlow API"**: 保持默认
3. "Translation Options" - **"SiliconFlow model to use"**: 填入 "Pro/deepseek-ai/DeepSeek-V3" 或其他模型
4. "Translation Options" - **"API key for SiliconFlow service"**: 粘贴你的 API 密钥
5. 点击页面下方的 Translate 按钮开始翻译
6. 翻译完成后，即可在页面下方的 "Translated" 一栏找到翻译后的 PDF 文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=21597781fff231729c619caf8c1afc22" data-og-width="4142" width="4142" data-og-height="2562" height="2562" data-path="images/usercases/pdf2zh/webui_set_sf.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=646c71c5e815480bc7479946da560334 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c45d4c9603f71604c57085141f1f0868 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=83925ac9b57c700641ba7e4fcc259c1a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=657a3635ae2fcd55e1f0efcfd044b65b 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=b99827214a74f00b9e913b7888da3498 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_set_sf.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=87eac020e9df8eb90eee8159e71b4887 2500w" />
</Frame>

整体参照 [zotero-pdf2zh](https://github.com/guaguastandup/zotero-pdf2zh/blob/main/README_babeldoc.md) 的说明，将翻译服务配置为 "SiliconFlow" 并填写对应参数即可。

请参考 [PDFMathTranslate Next 高级选项](https://pdf2zh-next.com/zh/advanced/advanced.html)。

**Examples:**

Example 1 (unknown):
```unknown
#### webui

1. 在 "Translation Options" - "Service" 下拉列表中选择 "SiliconFlowFree"。
2. 点击页面下方的 Translate 按钮开始翻译
3. 翻译完成后，即可在页面下方的 "Translated" 一栏找到翻译后的 PDF 文件。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1efb52a94225abdc7cf8c0e4b8ad5ddb" data-og-width="3196" width="3196" data-og-height="2562" height="2562" data-path="images/usercases/pdf2zh/webui_free.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c4fee9a503415ea737c6dce4766f70c1 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=385cee7a463652108c9a81356d5922c2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=559266e2b25bbc1732d0247faad10620 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=94d268773da8959da2a2210d13c76ce0 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bd5bbfbda6fb13d46faa01a2e5f718d4 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/pdf2zh/webui_free.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0d3df98241f0fcbefac2fe003474e2e1 2500w" />
</Frame>

#### Zotero

整体参照 [zotero-pdf2zh](https://github.com/guaguastandup/zotero-pdf2zh/blob/main/README_babeldoc.md) 的说明，将翻译服务配置为 "SiliconFlowFree" 即可。

#### 免费服务隐私说明

文件内容将被发送到 PDFMathTranslate Next 项目维护者 [@awwaawwa](https://github.com/awwaawwa) 的服务器，然后转发给硅基流动进行翻译。

PDFMathTranslate Next 项目维护者仅收集硅基流动返回的错误信息以调试相关服务。您的文件内容不会被收集。

[硅基流动隐私政策](https://docs.siliconflow.cn/cn/legals/privacy-policy)

### 使用硅基流动提供的其他模型

1. 注册一个硅基流动账号：[SiliconFlow](https://siliconflow.cn)
2. 创建一个 API 密钥：[SiliconFlow API Key](https://cloud.siliconflow.cn/me/account/ak)。然后，点击密钥以复制它。

#### cli
```

---

## ComfyUI 提示词小助手

**URL:** llms-txt#comfyui-提示词小助手

**Contents:**
- 1、关于 ComfyUI 提示词小助手
  - 核心功能
- 2、在 ComfyUI 中安装提示词小助手
- 3、在提示词小助手中使用 SiliconFlow
  - 3.1 **进入 API 配置界面**
  - 3.2 **选择硅基流动服务**
  - 3.3 **填写模型**
  - 3.4 **填入 API key**
- 4、使用教程

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-prompt-assistant

## 1、关于 ComfyUI 提示词小助手

提示词小助手，是一款 ComfyUI 中非常受欢迎的提示词扩展，它可以借助硅基流动等云服务平台提供的大模型 API，无感地在 ComfyUI 中实现提示词翻译、扩写润色、图像反推提示词等功能。是学习和使用 comfyUI 的必备的好帮手。

**提示词翻译**：无需手动设置源语言和目标语言，一键实现中英互译；

**提示词扩写**：可以根据不同生图模型、视频模型的特点，设置不同的规则，一键实现提示词扩写并润色；

**图像反推提示词**：借助视觉模型 API， 一键实现图像内容转换成提示词；

**标签预设**：可以将常用的提示词标签、触发词标签作为预设，实现快速插入。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=e6ecdaffe66b67c54908f3bea7d19679" data-og-width="1640" width="1640" data-og-height="1017" height="1017" data-path="images/usercases/prompt-assistant/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=280&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=8103d300b1c9b228714bf8a9362938bd 280w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=560&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=3609136847486f8c6c86b281aac371fe 560w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=840&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=dc1e88661596fe6d208ddd4d8af7ae0d 840w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=1100&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=7a329ae000fb9a0351bf6fb1fdca316d 1100w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=1650&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=3261aad5fb3fdf4f826bd04a35f33a55 1650w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/1.png?w=2500&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=d87542340e3ad3955460253825b00e8f 2500w" />
</Frame>

## 2、在 ComfyUI 中安装提示词小助手

**ComfyUI 桌面应用版或便携版**

可以在 Manager 中搜索“提示词小助手”或“Prompt-Assistant”（需要将 manager 中的 DB：local 改成 DB：Channel(remote) 才能搜索到），选择最新的版本号安装。

在启动器界面中的“版本管理”→“安装新扩展”中，在“扩展 URL”中输入 [https://github.com/yawiii/comfyui\_prompt\_assistant.git](https://github.com/yawiii/comfyui_prompt_assistant.git) 点击安装。

来到提示词小助手的 [GitHub 仓库](https://github.com/yawiii/comfyui_prompt_assistant)，下载源代码，放置到 custom\_nodes 目录下。

## 3、在提示词小助手中使用 SiliconFlow

### 3.1 **进入 API 配置界面**

安装完提示词小助手后，在 ComfyUI 设置中，找到“✨提示词小助手”选项。在右侧面板中点击“API 管理器”按钮，进入 API 配置界面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=d62efd2d0b98db5d3b5500b2d7a675ff" data-og-width="1760" width="1760" data-og-height="1286" height="1286" data-path="images/usercases/prompt-assistant/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=280&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=b292c5fb42c51dff771eb034d976a32e 280w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=560&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=6f7d14b2ad2ee626570171070d991b8d 560w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=840&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=f2d165fb3cdbcd362b4ee977b39b7041 840w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=1100&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=20f8674f914c2d570e2f3a86a858f922 1100w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=1650&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=bd708265a62f423ebd0d8fefc4c08ba1 1650w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/2.png?w=2500&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=9889d97a4b54708b7a1ed0dcf1f5df27 2500w" />
</Frame>

将大语言模型配置和视觉模型配置中的模型提供商下拉选项，修改为“硅基流动”。

模型输入框中默认填写的是免费的“Qwen/Qwen2.5-7B-Instruct”模型，如果想要效果更好、响应更快，可以点击界面中的“硅基流动 API 申请”链接，快速进入硅基流动主页，在“模型广场”页面中挑选适合的模型，复制模型名称填入即可。

### 3.4 **填入 API key**

在硅基流动“API 密钥”页面，新建一个密钥。复制密钥，填入到“API Key” 输入框中，点击“保存”按钮，就可以使用了。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=03d042ad9f6641a6c7b8860ee3078044" data-og-width="1280" width="1280" data-og-height="1134" height="1134" data-path="images/usercases/prompt-assistant/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=280&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=0ac799bbc2b1cf7059dd1437c7fda4ab 280w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=560&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=c3e9102a6eee4b99bd490ae5b22f5d9a 560w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=840&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=9676539b3105622f8caf14450c46bf70 840w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=1100&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=31f2ec4405442e50e8e35b4276ab1054 1100w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=1650&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=7c9823e82f0231b1f1929a88eea5cce1 1650w, https://mintcdn.com/siliconflow-37161621/QLxSnT0JY-XxfvuK/images/usercases/prompt-assistant/3.png?w=2500&fit=max&auto=format&n=QLxSnT0JY-XxfvuK&q=85&s=bb00aad4b22648a8ca57f228f3bd2f16 2500w" />
</Frame>

提示词小助手的使用非常简单，不需要添加额外的节点或额外的启动操作，只要创建的节点上包含提示词输入框或者图像内容，小助手就会自动创建。当需要对提示词进行翻译、扩写、反推时，只需要点击小助手 UI 上对应功能的按钮，即可轻松实现需求啦。

详细的提示词小助手使用技巧，请查看作者主页：[诶-阿伟哥](https://space.bilibili.com/520680644)。

---

## 却惑几菩提

**URL:** llms-txt#却惑几菩提

**Contents:**
- 一、关于却惑几菩提
- 二、如何使用
  - 1. API 配置
  - 2. 填入 API Key

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-qhgpt

[却惑几菩提](https://qhgpt.aihub.ren) 是一个将人工智能技术与佛教文化深度融合的对话平台。在这里，以禅宗思想、佛教经典为根基，借助 AI 的强大语言处理能力，为用户打造一场充满智慧与禅意的对话之旅。无论您是想探寻佛法的真谛、求解生活困惑，还是单纯想感受禅意的宁静，都能在与平台的对话中有所收获。

平台秉持 “自性求佛” 的理念，希望通过一问一答的形式，引导您向内思考，体悟内心的智慧。同时，平台承诺不存储任何对话信息，在页面刷新后，所有内容都会重置，充分保障用户的隐私安全。但也请您注意，平台内容仅作为文化交流与探讨，若存在佛教知识方面的不准确之处，还望宽容理解。

本平台基于**硅基流动 API** 驱动，平台内置 API，可直接开启对话。

> 建议设置你自己的硅基流动 API 密钥，将会优先调用。可避免公用 API 因使用人数过多导致的回复速率问题。

1、打开 **硅基流动 [官网](https://cloud.siliconflow.cn/)** 并注册账号（如果注册过，直接登录即可）。

2、完成注册后，进入 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，点击 **新建 API 密钥**，点击密钥进行复制保存，以备后续使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6cc99bb2c389ff68b8a5b13a6d5f016c" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/qhgpt/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=521c74861e0ec31a655731b2c2d4f0b4 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=585ffa04b8bf4b5265358863c419ab5a 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9b71f7b622fb01a2d975a30eab3816ae 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=25ea71033e9276d96912b6729874c611 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e23c9ad1026e8188efcf3cb3133f4dcc 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3a230933ce58ca13951459489cd9e83b 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=349568f33c4ccabfb192cf4fc3dfcafb" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/qhgpt/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=06bfc529903fa98cf77f7f066f7c77fa 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=8d01d2c42d9e79f438bbebcbf4ea7ccc 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0976261a709f26108f72cf5209c24de8 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=18649796cb38f983deff85cb26cdb484 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d454c1eef4ec2fb50396e2495174696b 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3c65db9a72c61a610631b0b6e3851491 2500w" />
</Frame>

2、在页面对话输入框，右下角位置找到 **【拈花】**，点击会展开 **【API Key** 以及 **自定义角色】**输入框。请在**【API Key】**右侧的输入框中**粘贴您刚刚在硅基流动页面复制保存的 API 密钥**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=22364745ad2a1f6e13b772d08683f6eb" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/qhgpt/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=689c4192b9c1e497f4b85575f0438bde 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7f5af133dde4dcdf087d4e80bc8202b2 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c6119565e3f9f1bd96bc8169648a0113 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ca941a12c5107456c87ba7364e309ea1 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=92142c68e24287534488cc3a42db85f1 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3a6a31cbdb09fd51a914d3a2749d53ae 2500w" />
</Frame>

3、点击人物头像，在头像下方的输入框中，输入您想要询问的问题、探讨的话题或内心的困惑。例如，您可以问 “如何理解‘诸行无常’？” 或 “生活中遇到烦恼该如何化解？”回车或点击右侧【 **卍** 】按钮开启对话。输入框左侧为\*\*【清空对话】**，右侧为 **【发送对话】** 、**【导出对话记录】**，点击**【录经】**复制当前回复，点击 **【轮转】** 将重新生成回复。等待回复过程中点击**【唵】\*\* 将终止回复。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=945bff2b6e84182321d4da4eaff6ea17" data-og-width="2879" width="2879" data-og-height="1799" height="1799" data-path="images/usercases/qhgpt/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4eee53b24b78e5cb8640b3c942d92daf 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=96f974d50f1524854defa0ba6e0ed51d 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=93433a027af983c6134096c2c17dfd14 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=77ad43fd0c21f0bad42b75fac54524a4 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=44237f71b999a3ce829737eae0aae3f4 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qhgpt/4.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bfee6d87240b1c4a2d04536c341b6cb5 2500w" />
</Frame>

4、当前版本仍处于持续迭代升级阶段，平台将陆续融入更多禅意新功能与趣味小彩蛋，静待您前来探索发现。

<Note> 注：本指南由合作伙伴提供，内容涉及宗教或哲学元素，旨在展示其技术应用场景，SiliconFlow 平台不持任何宗教立场。 </Note>

---

## 轻流无代码开发平台

**URL:** llms-txt#轻流无代码开发平台

**Contents:**
- 1. 关于轻流
- 2. 使用轻流
- 3. 在轻流中使用 SiliconFlow 连接器
  - 3.1 订阅连接器
  - 3.2 在业务系统中使用硅基流动连接器

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-qingflow

[轻流](https://qingflow.com)是一款领先的无代码开发平台，致力于为企业提供便捷、高效、智能的业务系统搭建工具。通过轻流平台，企业用户无需编写复杂代码即可快速构建个性化业务应用，轻松实现业务流程的自动化与智能化！

本文将介绍如何借助 SiliconFlow 提供的 API 服务在轻流中快捷使用，赋能企业业务系统。

无需下载安装，前往轻流官网，注册即可使用。[注册入口](https://qingflow.com/passport/register)

## 3. 在轻流中使用 SiliconFlow 连接器

注册轻流之后，进入工作区点击“更多”-“轻商城”进入轻流连接中心，点击“硅基流动”，点击“订阅”，如下图所示。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=959f3a6d874d44cdef1a145353c1b4c1" data-og-width="1000" width="1000" data-og-height="446" height="446" data-path="images/usercases/qinglow/qingflow-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6ef6f6175252b518b4a7fbc6a7ae72a1 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=abf0c4d9998ad6c6f49c385521b38746 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0380f5e4bec334385662f012e18a3c3c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=33a1dabd1ac4c68952e8180e7b35e3b4 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=f9dfd6cad8410dc7b779251453db4910 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=51f57ca8e7b911227110be2625602c1e 2500w" />
</Frame>

### 3.2 在业务系统中使用硅基流动连接器

在应用中插入“Q-Linker”字段，配置模式选择“使用连接中心模板”“硅基流动”后，即可选择你所需要的AI大模型；发布后即可投入使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=dd4b6449394cad28308109d7c546a274" data-og-width="1000" width="1000" data-og-height="484" height="484" data-path="images/usercases/qinglow/qingflow-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=cc8f425c583f316380da9103d13555a8 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=36c415e8f7a2ab56949ae3fbcfea6cbc 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=7d450ed587053534919413e02a16c19c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c081eeca58a0ac236136223f7b850728 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ed98176b8d9db6bf5f8bd1537f570299 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qinglow/qingflow-2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=dc417a32dee780b9be9f6645b3973916 2500w" />
</Frame>

值得注意的是，在轻流平台使用硅基流动提供的大模型服务时，无需额外填写自己的 API key，轻流平台已自动配置与硅基流动账户的对接，大家可以轻松享受便捷的服务接入体验。

---

## 清雅

**URL:** llms-txt#清雅

**Contents:**
- 1、关于清雅
- 2、安装使用清雅
- 3、在清雅中使用硅基流动模型
  - 3.1 配置硅基流动的 API 服务
  - 3.2 配置语言模型
  - 3.3 配置文本转语音模型
- 4、功能简介
  - 4.1 选择 Live 2D 模型
  - 4.2 选择背景
  - 4.3 选择人设

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-qingya

**清雅** 的寓意为“清新脱俗，知性优雅”。是一款融合了 Live 2D 模型的 AI 聊天互动应用，为用户带来沉浸式的温暖陪伴。目前支持 iOS 平台，具备**智能聊天**、**情绪识别**、**丰富背景**、**高度定制**，多项功能。

目前， 清雅合作硅基流动，用户输入硅基流动 API 密钥后，可选择硅基流动提供的各种**语言模型**进行聊天互动。同时，也可选择硅基流动提供的**文本转语音模型**，享受云端高品质语音，媲美真人发音。

在 App Store 内搜索“清雅”，下拉找到清雅 APP，点击下载即可。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=e827394de908ba1661347a04340e0c7b" data-og-width="1231" width="1231" data-og-height="486" height="486" data-path="images/usercases/qingya/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=d348c7f169af4bc6aeed76282b2b3c0d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2c3dc7e02419352870206a4a7bc159ea 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=3e79953506dbef4bfc71b974ca67a5c7 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=59a3ef2f97cafc168937defe3d72bff1 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=9d22914dc562e99ff34250a5b678bcd3 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/1.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ac78157a0101d20bff66d7000d899f55 2500w" />
</Frame>

### 3.1 配置硅基流动的 API 服务

1、打开清雅 APP，进入设置页面，找到 API 设置模块，在模型服务中选择硅基流动。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1202df099ac8a8b8d2e1d76de62e145c" data-og-width="1242" width="1242" data-og-height="2208" height="2208" data-path="images/usercases/qingya/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=34028286f2b130468e1baf0bd9a1503d 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=692df45ce22b763d253a983f691287e3 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=702483d6822769de4b8479ff863c0fb5 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a26b56a9cae70159f26875bf97a0a070 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=1ee40fecf4afbc24f87913e61da6ad74 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/2.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=bff8a133c17167a9fa6236f45f910100 2500w" />
</Frame>

2、点击“硅基流动平台”字样，进入硅基流动 注册/登录页面。注册/登录完成后，点击左侧导航栏的“API 密钥”，进入“API 密钥”页面。点击“新建 API 密钥”按钮，输入密钥名称后，再点击“新建密钥”按钮，即可创建硅基流动 API 密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=59107ace8e1fbf3791a5948ec510fdd6" data-og-width="1610" width="1610" data-og-height="919" height="919" data-path="images/usercases/qingya/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2dfb13047e5717b9a4bc924c1e624d09 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c54f39c9d89ba5261bf9e323b4b184ce 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=18e32256aabfb16f1ceba899e687659c 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=0d9831bcc278caed9e3f905bbad29762 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=4f5a50b44c568aac547db98a1df08772 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/qingya/3.png?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=6b7526fe31718dab3c9d0c6487d295f6 2500w" />
</Frame>

3、在“API 密钥”页面复制硅基流动 API 密钥，回到清雅 APP 中，在“硅基流动 API key”一栏粘贴，然后点击“测试连接”按钮，如果显示“连接成功”的弹窗，表示硅基流动的 API 服务配置完成。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ea07e63a00929f9f491570433c8b2759" data-og-width="1182" width="1182" data-og-height="822" height="822" data-path="images/usercases/qingya/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=06bea36be2e17181750180438573e43a 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bf06d365f93c0c0c8b75580c417cbe0e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fdbf38bd7195a00bcfef77e1fcd85088 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6650892b3fe6c1dc8b79a666589d159a 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e4db07c0e59af18403649d547b8fb10f 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/4.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=33b0d8a26d0c4c298836a957c49e5a37 2500w" />
</Frame>

1、在“设置”页面的“API设置”模块下方，可找到“选择模型”一栏。点击“选择模型”旁的“刷新”按钮，能够获取硅基流动最新上线的模型列表，在右侧可进行大语言模型的选择。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9fe23fe58c858d485dccb0ee7819fa3f" data-og-width="1580" width="1580" data-og-height="1232" height="1232" data-path="images/usercases/qingya/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1a43ca12bf22b8b9dfcc7bb619d9004e 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=78a21f4ca373fefe508035abd8da8a79 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9002eac03b30aebb1058208f7f28a30c 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a899585fe03a8729f3a60d12964dacef 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c944621071ed135ea5b3b4e97fcfe700 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/5.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b8da7adffe6f18f601c340078ef2602f 2500w" />
</Frame>

2、同理，在“相知”页面的输入框上方，点击“选择模型”按钮，也能够随时切换与您对话的大语言模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=678520a485e4498ee1da082cfb00c511" data-og-width="1578" width="1578" data-og-height="1234" height="1234" data-path="images/usercases/qingya/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fd7201aeb74546e6f5887993ab575b20 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dd06f9b8e56c119a86a058f47b7bc233 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b22d37b044e68f2290228b014f06aefd 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c360d3bc80676dccf8b62f409798ebf4 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0b267199bd92fd0d06d7f089a08fe404 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/6.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9036fe6d1c05d2edd7d86b025fa1d1f2 2500w" />
</Frame>

3、选择大语言模型后，即可在应用内进行语音通话或者文字交流。

在“设置”页面下方的“人物设置”模块，找到“选择语音”按钮，点击按钮进入“语音设置”页面。清雅提供“系统内置”语音服务或者“硅基流动”语音服务。在“硅基流动”语音服务中，可以选择硅基流动上线的文本转语音模型。选好模型和音色后，点击页面底部的“测试当前语音”按钮试听当前语音，满意的话，再点击“保存设置”按钮，即可使用当前语音与您进行对话。

和系统内置的音色相比，使用硅基流动的高品质语音能够显著降低机械感，媲美真人发音，效果非常惊艳。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d0a36a68769aa60db6a4a444ffba62cd" data-og-width="1712" width="1712" data-og-height="1374" height="1374" data-path="images/usercases/qingya/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=06af04a1dd242613e84de0369ac9d566 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=15b4155111898910edaee553821a6c7c 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8fc1d5d6c773bd908cb338007c61f1f8 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c40892000e0cfa99a6f47279e6cf8fac 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=67ede09c01bb39d5bb11d5d0475935f0 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/7.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6b9ad366cb7a2c127aa7f41bf0813b8a 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1b60771f10ec9ad1142d951858fcb39c" data-og-width="1800" width="1800" data-og-height="1462" height="1462" data-path="images/usercases/qingya/8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c0d3b6393badd4c49e89ff654b09f2f3 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=135100f3009dc7952b96cff99a814378 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=451da8d19ae97701d0ad5c8ea7482c04 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=242fd4e4a7530fe647e04d148d607f0a 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=43031ff3e304d5dceb95ff9acd7a01bc 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/qingya/8.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=78bd516aaf3f59f3d8dea226524f42c0 2500w" />
</Frame>

除了上述提及的 AI 聊天功能外，应用还提供以下功能：

**情绪识别**：深度分析对话情感，可根据情感使 Live 2D 模型表现相应的动作或表情。

**丰富背景**：应用内置多款静态图片背景和动态视频背景，营造良好聊天氛围。

**高度定制**：用户能够选择使用自定义的 Live 2D 模型、聊天背景、主题颜色、应用启动页、人物设定等等，个性化定制自己专属的应用风格。

### 4.1 选择 Live 2D 模型

在“设置”页面的“人物设置”模块，用户可以使用应用内置的Live 2D 模型或者导入自定义的Live 2D 模型，还可以配置每种情绪相对应的表情或动作

在“设置”页面的“主题设置”模块，用户可以使用应用内置的丰富聊天背景或者导入系统相册内的图片或视频作为自定义的聊天背景。

在“设置”页面的“人物设置”模块，用户可以选择让 AI 扮演的人设，应用内置多种预设的人设模板，用户也可保存自定义的人设模板。

如果想了解本应用的更多内容，可以看看清雅的用户手册。

[用户手册](https://www.yuque.com/qingya-ojuuj/czi4uf)

联系我们：[wangjingqian1770@163.com](mailto:wangjingqian1770@163.com)

---

## Refly

**URL:** llms-txt#refly

**Contents:**
- 访问 Refly
  - 点击开始使用
- 配置 SiliconFlow
  - 第一步：进入设置页面
  - 第二步：访问供应商商店
  - 第三步：安装 SiliconFlow
  - 第四步：配置 API Key
  - 第五步：验证安装成功
  - 第六步：配置模型
  - 第七步：了解模型能力

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-refly

[Refly](https://github.com/refly-ai/refly) 是一个支持 MCP、工作流和 Agent 的 **开源 AI 工作台**，旨在将创意转化为可重用/分享的工作流，并通过工作流产出高质量的文档、PPT、知识网页等结果。

> 本文将介绍如何在 refly 中使用 SiliconFlow 提供的模型能力。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0648fed3b733170b22377aa7f2d3017c" data-og-width="1900" width="1900" data-og-height="872" height="872" data-path="images/usercases/refly/refly主界面.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=45ecace90661bc7ae466b9dbb71fff14 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=07c43c15fc3392cdf4bcc92c530843cb 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f3ad342928abb8efd9385eb414354b4 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=486a994cd96335b09b64785aacf299e2 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dc298db8908c7a6a8fcf505ae3d6aec0 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E4%B8%BB%E7%95%8C%E9%9D%A2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b21be9f730e7dff1fbd7c23132844f87 2500w" />
</Frame>

您可以通过访问 [refly.ai 官网](https://refly.ai)，注册并登录您的账号，开始体验 Refly 强大的 AI 工作空间。平台支持网页端直接操作，无需本地安装，支持多种 AI 模型和工作流的创建与管理。建议使用最新版的 Chrome 或 Edge 浏览器以获得最佳体验。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7f0047ef4b707414b68e6a0c3d4d3040" data-og-width="1919" width="1919" data-og-height="861" height="861" data-path="images/usercases/refly/refly开始使用.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=448ee4061c6bfc3e461a85597c367a8d 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=217410f593b0a7f2c72f61a7cb8134e4 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c8c073c05154df1f3a226a0b13e92427 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d7be7f8594e36c298384f6e7127b9fcf 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c23146f61960abfd484bc55d6b6b56fd 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%BC%80%E5%A7%8B%E4%BD%BF%E7%94%A8.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=561bc24e1b601640ad0d89f681548cd2 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2130f54c17d6678945fd77526bed059c" data-og-width="1922" width="1922" data-og-height="873" height="873" data-path="images/usercases/refly/refly点击头像.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7ba6a24a5ceb5374ab5ce2f064b1053a 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6f5d96f42b9bc8be6675e676e29c3c78 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=cb6966ba742b4d142a072367571c2145 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ac22d1486c9995460ef271fe91ebf9d6 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=51a3c807661a7a11ba4db33c594cf02d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E5%A4%B4%E5%83%8F.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2b66ae6be59a356f97dab02b8a34f262 2500w" />
</Frame>

登录 Refly 后，在左侧导航栏底部找到您的头像，点击头像进入个人设置页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d7e8bb2cf125dfd37f06f33214a28f61" data-og-width="1901" width="1901" data-og-height="875" height="875" data-path="images/usercases/refly/refly点击设置.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e529fb79ffab201981eff477c7883927 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=763118d342c7a100734aa59aec4e2eed 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=71f439926b7b5eef709ac70271c57409 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=53e56a945d7f86cabde794f85e7e1820 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=10fea33b85738b9f745a8080960ec30d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%82%B9%E5%87%BB%E8%AE%BE%E7%BD%AE.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b666d908d750d6d27a03272222420c84 2500w" />
</Frame>

在个人设置页面中，点击"设置"选项，进入系统配置页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eb34f51904d023c7d12ba0fd60c6b50a" data-og-width="1915" width="1915" data-og-height="866" height="866" data-path="images/usercases/refly/refly模型供应商商店.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a72b9ca5c2108766867e4e9df9715287 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dab47c504381edc237368a1dc7f871db 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bad0a63b1fd9bc2b994e552c45af0884 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1e5e0054c20434284a382857a1bfd918 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1ff9348a13d410f96620b4e89d703067 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E4%BE%9B%E5%BA%94%E5%95%86%E5%95%86%E5%BA%97.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4b30196add3909c97441df9cb97be3a6 2500w" />
</Frame>

在设置页面中，左侧导航栏选择"供应商"选项，然后在主内容区域点击"供应商商店"标签页。这里列出了所有可用的 AI 模型供应商。

### 第三步：安装 SiliconFlow

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f5fea33df1f19c6834e107b2fa6d5d4" data-og-width="1918" width="1918" data-og-height="872" height="872" data-path="images/usercases/refly/refly安装siliconflow.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=200e02dceeb99086ffe1da44fb95e7e6 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c06c7a55739e3b2bab75e6623b18bccf 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8c0787dd830de00a1fe9ac23d96c8ccd 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8006f87ab145dbcb249d1940f5026b21 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b6f53ab928963ba88f190af76fedcb87 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E5%AE%89%E8%A3%85siliconflow.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=679559d051e9ee259d8b86c36472f509 2500w" />
</Frame>

在供应商商店中找到 "SiliconFlow" 卡片，点击其右侧的"安装"按钮。SiliconFlow 提供一站式云服务平台，为顶级大语言模型和嵌入模型提供高性能推理服务。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6476e4d6773502c00eee7b56931f3524" data-og-width="1892" width="1892" data-og-height="871" height="871" data-path="images/usercases/refly/reflyapi配置.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1649f117ff4603c4476f49817a28b160 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8873536e75e0b2dbbcbc50764a027ab2 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a1bd7da9cc22e8f60f6a3ad765ab1601 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1effdc83fe16ac6f4f7b23a8ea91e049 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=26dd485d746c9ba7fcc08d534dcab4da 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/reflyapi%E9%85%8D%E7%BD%AE.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f75c37dbd809e9ab08cff57632f1fff3 2500w" />
</Frame>

<Frame>
  <img src="https://raw.githubusercontent.com/siliconflow/doc-images/refs/heads/main/2-siliconcloud-apikey.png" />
</Frame>

安装 SiliconFlow 后，系统会弹出"配置 API Key"对话框：

1. **获取 API Key**：您需要从 SiliconFlow 官网获取 API Key
2. **填写 API Key**：在"API Key"输入框中填入您的密钥
3. **Base URL（可选）**：默认值为`https://api.siliconflow.cn/v1`，如需使用自定义服务地址可修改
4. **点击安装**：确认信息无误后点击"安装"按钮

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4aac22a940ee91f0a8ace685396b32fc" data-og-width="1918" width="1918" data-og-height="877" height="877" data-path="images/usercases/refly/refly显示安装成功.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ec41e7fee593275c538852cc05249a75 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6abf7212049017ac4a452c64a5a8217b 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3b81c81581882764787b844bb2e3937b 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=de9a3406a89ade991beefcc626367c26 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f5edeb35d8b7b63b66ab271a5085d6c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%98%BE%E7%A4%BA%E5%AE%89%E8%A3%85%E6%88%90%E5%8A%9F.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=95a76974515f4b3e6c9292ab6a346850 2500w" />
</Frame>

安装成功后，您可以在"我的供应商"标签页中看到 "SiliconFlow OPENAI" 已添加到供应商列表中，并且开关处于启用状态。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8578cb721c909381fa416ce109b1c470" data-og-width="1916" width="1916" data-og-height="867" height="867" data-path="images/usercases/refly/refly模型配置.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=88c04ca8e245cbc4496a269bf8a6c34f 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7f2cb18dff541123f26ee9d85b9a1cea 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=98037795f516072fe8310acc8fd09c48 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7185a424b546e05ef6270e90025fd566 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d1fd4d0475a8193f948327c3d92f255c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E6%A8%A1%E5%9E%8B%E9%85%8D%E7%BD%AE.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4b2d7a94167418f998a492c44e07c710 2500w" />
</Frame>

在左侧导航栏中选择"模型配置"，进入模型管理页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=58782bf7463084b05f57cd8f1e169d22" data-og-width="1918" width="1918" data-og-height="875" height="875" data-path="images/usercases/refly/refly确认添加模型.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0ec97c776e7c20c5f32e55d6dbc7127f 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=9097d3278b65bb11570346186bd47f7c 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=82371473a7ae2fd7bb347210c6c13449 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=167282e36efa51e3dc1a7ed62e83ab30 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b3fa678167bb4fd573a44de2a0cbe197 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/refly%E7%A1%AE%E8%AE%A4%E6%B7%BB%E5%8A%A0%E6%A8%A1%E5%9E%8B.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=579bbe8a9ec63027287874e8c3e736dc 2500w" />
</Frame>

点击"+ 添加模型"按钮，在弹出的对话框中配置模型参数：

* **供应商**：选择 "SiliconFlow"
* **模型ID**：输入`deepseek-ai/DeepSeek-V3`
* **模型名称**：输入`deepseek-ai/DeepSeek-V3`
* **分组名称**：输入`siliconflow`
* **上下文数量限制**：设置为`128000`
* **最大输出token**：设置为`128000`
* **能力**：勾选"函数调用"等所需功能
* **是否启用**：保持开启状态

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=89c5c9187073d9cb376ec6bcd8990701" data-og-width="916" width="916" data-og-height="870" height="870" data-path="images/usercases/refly/模型能力.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=56d9be4a1a88dc36456c8fa0653e7d4e 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e5d44404b6a4d32a6598306c7584c475 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=59bb2357e6ea8b0997d278fbdb254ff8 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a24fc212a23b5225731315370004e730 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=30867234dc2f09dc17593e22b4622bec 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/refly/%E6%A8%A1%E5%9E%8B%E8%83%BD%E5%8A%9B.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b46958f352faa6dc7c3033467f79539a 2500w" />
</Frame>

DeepSeek-V3-0324 模型具有以下特点：

* **价格**：输入 ¥2/M Tokens，输出 ¥8/M Tokens
* **上下文窗口**：128K tokens
* **支持能力**：
  * 工具调用 (Tool use / Function calling)
  * FIM 补全 (FIM completion)
* **速率限制**：RPM 1,000，TPM 10,000

1. **API Key 安全**：请妥善保管您的 API Key，不要泄露给他人
2. **费用控制**：注意监控 API 使用量，避免产生意外费用
3. **模型选择**：根据具体需求选择合适的模型和配置参数
4. **功能测试**：配置完成后建议进行简单的功能测试，确保一切正常

**Q: 如何修改模型配置？**
A: 在模型配置页面中，点击对应模型右侧的"..."按钮，选择编辑选项。

**Q: 如何禁用某个供应商？**
A: 在供应商列表中，将对应供应商的开关关闭即可。

配置完成后，您就可以在 Refly 中使用 SiliconFlow 提供的强大 AI 模型能力了！

---

## ToMemo

**URL:** llms-txt#tomemo

**Contents:**
- 添加 SiliconFlow 供应商
- 从 SiliconFlow 获取 API Key
  - 拉取模型
- 添加单词助理 🤓
- 键盘中的单词助理 🤓

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-tomemo

ToMemo 是一款多功能快捷键盘 + 剪切内容记录 + 懒人短语的便签应用。可以帮助你快速获取和输入常用的内容，比如邮箱地址、快递地址、身份证号、发票抬头等。

## 添加 SiliconFlow 供应商

进入添加页面后，直接点击「供应商」选项，在里面选择 SiliconFlow （硅基流动），此时，会自动填入名称、Base URL 和接口类型。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fa2c36a241eb32ae2b845de176459e0b" data-og-width="1170" data-og-height="2532" data-path="images/usercases/tomemo/tomemo-1.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c936c6a0ff254d6e1040d9350add8ddf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b99845542de28aa977633a13bfcafba8 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=010ca4ccbe9c95b697cec67c5dbebd9f 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2fac203a6dfec8046b76554f21dde2a5 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=81c1a5710a749a7a24beda9335909487 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-1.jpg?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=721ccc8d0456cd23c936031b9d35fd33 2500w" />
</Frame>

## 从 SiliconFlow 获取 API Key

SiliconFlow 的 API Key 获取地址：[点击打开 ](https://cloud.siliconflow.cn/account/ak)

点击后，完成登录，进入到下面所展示的页面。

点击「创建API密钥」按钮，逐步完成创建。

需要**拷贝 API 密钥**， 并妥善保管。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5cb71d2204ce1b055c6f312276a74c29" data-og-width="5088" data-og-height="3896" data-path="images/usercases/tomemo/tomemo-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5f3a36fa907ee946ed14b6ca3e3f9f5e 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=813b7df970dc588a50c07dfa719398d9 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=66376cbd751731b7ec5e79ab7f2f89e6 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0aea0ad46fa866fc4b1f8e714fc84e58 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=22cfcae143bd14290731d77e8db7925d 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=93c73ca87c7efebd6309c9488db92c1a 2500w" />
</Frame>

将上面获取的 API Key，填入到当前页面的 API Key 输入框中。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4ee0c41b86023897f3fd5e4185fe8035" data-og-width="1170" data-og-height="2532" data-path="images/usercases/tomemo/tomemo-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6f0459a0bb7c6fd400f38299ca6137b4 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2f48a063f27b45b4121e60ab3f13b113 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a84d7d4b6cbc9a043d4bcc5fff3e972c 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d2cb231edc7ff2905d94ba71d5cb752b 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bb5c7cfb6c0db19b43b8a48721b653ed 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-3.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e426aec1c10efa4c97a2056c70233dfa 2500w" />
</Frame>

然后选择需要加载的模型，最后点击「保存」按钮，完成 SiliconFlow 的集成。

需要选择文字生成模型，应用暂时不支持图片输入和输出。

进入「AI助手」页面，开始添加 AI 助手。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-4.gif?s=594e6735958d397e3226fdcb994770fe" data-og-width="480" data-og-height="1038" data-path="images/usercases/tomemo/tomemo-4.gif" data-optimize="true" data-opv="3" />
</Frame>

在键盘中使用「单词助理」，需要先在「AI助手」中添加「单词助理」的助手。

<Frame>
  <img width="250" src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tomemo/tomemo-5.gif?s=04af5b31ccb22dd52c1c883c653a5629" data-og-width="480" data-og-height="1038" data-path="images/usercases/tomemo/tomemo-5.gif" data-optimize="true" data-opv="3" />
</Frame>

---

## translate.js

**URL:** llms-txt#translate.js

**Contents:**
- 简介
- 模型优化
- 快速使用
  - 代码
  - 说明
  - 微调指令
- 使用 SiliconFlow 实现私有部署
  - 优势
  - 部署

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-translate-js

[translate.js](https://gitee.com/mail_osc/translate) 是面向前端开发者的 AI i18n
专注于多语言切换能力，两行 js 实现 html 全自动翻译，百多语种一键切换，无需改动页面、无语言配置文件、支持[几十个微调扩展指令](https://gitee.com/mail_osc/translate)，满足你的一切个性化需求、对 SEO 友好。
采用 MIT 协议进行开源: [GitHub](https://github.com/xnx3/translate) | [Gitee](https://gitee.com/mail_osc/translate) ，完全免费开放并允许商业使用。

本文将详细介绍依靠 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 提供的 API 服务，让你的网站支持上百语种切换。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/html_demo.gif?s=5c1ada668555a20ca5cd4a44e80ffacf" data-og-width="1650" width="1650" data-og-height="718" height="718" data-path="images/usercases/translate-js/html_demo.gif" data-optimize="true" data-opv="3" />
</Frame>

提到翻译，可能你第一时间想到的这种情景：输入框输入一段文字，后面跟上一句 ： 帮我翻译为 xxx 语言 ，它并不是这样的。

大模型有比传统机器翻译更好的译文质量，但稳定可靠的结果输出是线上场景是必须要具备的，它对大(小)模型在文本翻译领域的实际应用场景应用使用进行了深度调优及多重自检修复，以达到稳定可用的能力。展开聊聊见 [这里](https://e.gitee.com/leimingyun/doc/share/6d69716d52be98f0/?sub_id=14253611#%E6%A8%A1%E5%9E%8B%E4%BC%98%E5%8C%96)。

简单来说，就是可以通过 [SiliconFlow](https://cloud.siliconflow.cn/i/64MyJQtM) ，来对各种不规则的句子、多语种混合的句子、前后各种不通顺的句子进行翻译，进行翻译，质量比传统文本翻译的阅读通顺度跟高，同时还能达到传统文本翻译的极速响应。

您无需做任何前提准备，各种注册等，只需加入几行 js 就能完成

只需在你原本的 html**底部**增加以下代码，即可完成接入

只需要 js 加入 `translate.service.use('siliconflow');` 即可使用 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 免费的 qwen3-8b 模型来进行翻译，我们已对硅基流动进行了深度集成，所以你无需其他任何设置。

translate.js由 [指点云](https://www.zhidianyun.cn/?i125cc1) 提供服务器赞助支持，将大模型转化为文本翻译 API 并开放给 translate.js 进行使用，亚、欧、美洲等都有网络节点以支持全球范围的网络使用畅通。
如果您接入时遇到困难，可[点此反馈求助](https://gitee.com/mail_osc/translate/issues)，或加 QQ 群（1034085260）向作者求助。

translate.js 有极其丰富的扩展指令，让你可以对它进行各种精准控制，满足各种难缠客户的各种脑洞要求。（如果满足不了，可通过上方 QQ 群提出来我们加） 比如：
[切换语言select选择框的位置、CSS美化、是否出现、显示的语种等](https://translate.zvo.cn/41541.html)、[设置默认翻译为什么语种进行显示](http://translate.zvo.cn/4071.html)、[自定义翻译术语](http://translate.zvo.cn/41555.html)、[翻译完后自动触发执行](http://translate.zvo.cn/4069.html)、[指定私有部署的翻译服务接口](http://translate.zvo.cn/4068.html)、[监控页面动态渲染的文本进行自动翻译](http://translate.zvo.cn/4067.html)、[自动切换为用户所使用的语种](http://translate.zvo.cn/4065.html)、[用js控制主动进行语言切换](http://translate.zvo.cn/4064.html)、[只翻译指定的元素](http://translate.zvo.cn/4063.html)、[翻译时忽略指定的元素](http://translate.zvo.cn/4061.html)、[翻译时忽略指定的文字不翻译](http://translate.zvo.cn/283381.html)、[对网页中图片进行翻译](http://translate.zvo.cn/4055.html)、[鼠标划词翻译](http://translate.zvo.cn/4072.html)、[网页ajax请求触发自动翻译](http://translate.zvo.cn/4086.html)、[设置只对指定语种进行翻译](http://translate.zvo.cn/4085.html)、[对指定标签的属性进行翻译](http://translate.zvo.cn/231504.html) ……

更多指令及其说明可 [点此查看](https://gitee.com/mail_osc/translate).

## 使用 SiliconFlow 实现私有部署

您可以注册 [SiliconFlow](https://cloud.siliconflow.cn/i/64MyJQtM)  自己的账号，然后私有部署此服务，来进行更多设定，极大提升使用体验。

* **翻译质量**：你可以对接 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 更大尺寸的模型，比如 qwen3-32B，让翻译语句更通顺，拥有极高的阅读体验。
* **极速响应**：可开启 [内存缓存](https://translate.zvo.cn/391130.html) 来极大提高文本翻译 API 的响应速度
* **用量限制**：可针对某个域名（或者开通 API 接口的 key）来设定它的 [用量限制](https://translate.zvo.cn/391130.html) ，如果你是网络公司，你可以以套餐的形式卖给使用用户。
* **管理接口**：可以通过开放的 [管理 API 接口](https://doc.zvo.cn/translate.service/20250312/admin.getCache.json.html) ，来实时获取当前有哪些域名(或 key)在使用、翻译的字符数有多少、等等。
* **数据隐私**：接口请求、缓存数据等完全都在自己的服务器上，数据隐私无需担忧。
* **并发控制**：可自由定义每秒的[并发请求上限](https://translate.zvo.cn/413975.html)，以及调用大模型进行翻译时[请求线程池](https://translate.zvo.cn/391753.html)的线程上限，以极大缩减接口等待的耗时。另还可以通过管理接口实时获取当前请求线程池的并发数等

* **CPU** ：1 核
* **架构** ：x86\_64 （也就是 Intel 的 CPU ）
* **内存** ：1G
* **操作系统** ：
  1. CentOS 7.4 (这个版本没有可选 7.6 、7.2 等，7.x 系列的都可以)
  2. openEulor 20 (如果没有 20 版本那就选 22 版本)
* **系统盘** ：默认的系统盘即可，无需数据盘
* **弹性公网 IP** ：按流量计费（带宽大小 10MB。如果是个人使用，翻译的量不大，完全可以选 1MB 带宽）
* **所在区域** : 选国内，这样请求硅基流动接口就会更快。

1. 进入 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM) 注册账号
2. 在控制台的左侧，找到 **账户管理** 下的 **API 密钥** ，点开，去新建一个即可。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=962312a9df51eb6935be27d5a6642af3" data-og-width="1195" width="1195" data-og-height="746" height="746" data-path="images/usercases/translate-js/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=04e36d5600a1c96b76a1de41a2bc2578 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=87ecea2022e62d6647f23af643313a1e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ca65c4f98db44eadc8072a9cc1960e71 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5001e7897f7dd7973356dd718e346515 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6fb25ece2319c653610d9af978cdcb9e 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/1.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=53f7e22c9661ca82e21d84a48675882c 2500w" />
</Frame>

首先，找到配置文件 /mnt/service/config.properties 编辑它，找到

这个，将它注释掉（这个是默认体验的），然后增加以下配置：

**Examples:**

Example 1 (unknown):
```unknown
<script src="https://cdn.staticfile.net/translate.js/3.15.6/translate.min.js"></script>
<script>
translate.service.use('siliconflow'); //设置采用硅基流动的翻译通道
translate.execute(); //触发翻译
</script>
```

Example 2 (unknown):
```unknown
yum -y install wget && wget https://raw.githubusercontent.com/xnx3/translate/refs/heads/master/deploy/service.sh -O ~/install.sh && chmod -R 777 ~/install.sh && sh ~/install.sh
```

Example 3 (unknown):
```unknown
translate.service.leimingyun.domain=http://api.translate.zvo.cn
```

---

## Tyrion

**URL:** llms-txt#tyrion

**Contents:**
- 配置 SiliconFlow 模型
- 在流程中使用 SiliconFlow 模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-tyrion

[Tyrion.ai​](https://www.tyrion.ai) 一站式企业复合 AI 系统平台，融合生成式 AI、大语言模型智能体（Agent）与知识本体语义层打造统一的 AI 中枢，帮助大型企业实现跨业务的智能自动化与决策支持。平台低代码开发界面、基于大语言模型（LLM），支持快速构建 AI Agent，可视化工作流编排和智能知识库，打造高效协同的一体化产品矩阵。

本文将介绍如何在 Tyrion 中使用 SiliconFlow 提供的模型能力。

进入设置中的模型管理页面，点击 SiliconFlow 设置按钮，在编辑模型组窗口中点击**从 SiliconFlow 获取 API Key** 按钮，Tyrion 会打开相应配置页面，点击密钥复制并在 **API Key** 中粘贴，点击确认即可完成配置。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ffb4b113532a2ed887b75b713f654b65" data-og-width="1280" width="1280" data-og-height="716" height="716" data-path="images/usercases/tyrion/tyrion-1.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4ad8d61419422b1804e5bd54d438f776 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f8cc06c8c6c6ed3b6d328c41d263f0c3 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=70877f102f891e2a407229b914a606de 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6aa08dcfccc6ca4c76803869fbd1b1d5 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c2d6a938dbac85d80de931348407ac81 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-1.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c73d5a507047db2ba9325f3fca9317c9 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f788a73d18bac63c65a539e5180c67c1" data-og-width="1280" width="1280" data-og-height="400" height="400" data-path="images/usercases/tyrion/tyrion-2.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ba9f15e2a5c1899461416e6bb0a2e6af 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c6c6feeff50289045575ac6c3ab884e3 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=47274a4924d288af4a18054193b95967 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c0b6438983d92640e208d392e508b2f5 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8e4b88343b9e760f0c61647b06741ab7 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-2.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7c83bdfe83793d35c7324fa5a6a67352 2500w" />
</Frame>

## 在流程中使用 SiliconFlow 模型

在模型分组下拉框中选择 **SiliconFlow**，完成提示词的编写等配置后，便可以体验 SiliconFlow 提供的强大的模型能力。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=49ebff5189ad85d61b3fbe9c642f27e1" data-og-width="1280" width="1280" data-og-height="1038" height="1038" data-path="images/usercases/tyrion/tyrion-3.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f97e5abeaf7f872b4e9de509c25c8990 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5c4722b8d0253f3e38684ff1f1631695 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=25cdfd1bef82a67ba2d75ba50143bb7d 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c8e61bff29598a73131f516bdb7c3633 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b7967a2524cffd0abd10680adb80be7a 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-3.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f742ba679fc4865e5aed30abf609c78b 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c627342c94f0ce4c6b7ba2387588bdfa" data-og-width="943" width="943" data-og-height="1396" height="1396" data-path="images/usercases/tyrion/tyrion-4.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=aa5f38b6334934e56052b0eddcdc53d8 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d8b0e8463d7162708c2e4f400fadd7e9 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fc55577a4a73405d26fcd0b0c6449ed6 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dcc51e0624504b4e478876673551f8e7 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=683784c4ef68dfeee0c751093e2ca9c6 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/tyrion/tyrion-4.jpeg?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=63d7c6a9aafa05687703fa99dae81b32 2500w" />
</Frame>

---

## 问道

**URL:** llms-txt#问道

**Contents:**
- 1、关于问道
- 2、获取 API 密钥
- 3、在平台使用

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-wendao

[问道](https://wendao.aihub.ren)是一个 AI 聊天平台，以“问道”为主题，预设道家人物角色（如老子、庄子等）作为交互对象。用户可通过对话形式与“道家先贤”互动，探索道家思想，兼具文化传播与智能交流功能。

平台对话服务基于 [硅基流动](https://cloud.siliconflow.cn/) API ，本文将介绍如何在网站中使用 **硅基流动** 提供的 API 服务。

> 建议设置你自己的硅基流动API 密钥，将会优先调用。若不设置，将使用内置硅基流动密钥（使用人数多时，可能会有速率限制）。

1. 打开硅基流动 [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。

2. 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，点击 **新建 API 密钥**，点击密钥进行复制，以备后续使用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=b88fdf88029711f916e86d28b4a92e8e" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e695a8a4ea3742970e0e74b739b7dcdf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=97cc395b409103fdb5147421cb2dc918 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fc6111929459b0a38295cd2ec04ac7e9 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=92e04b3dc62c709e50893f24a05aaf6b 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=18408c7d958cdf46e942c7168afd1ed8 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/1.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bd579e14109ee4c95384579922e384be 2500w" />
</Frame>

1、[问道](https://wendao.aihub.ren) 首页选择任一人物卡片，进入对话框后点击右上角 **太极八卦图标**，打开 **设置框**，API Key 处填入刚刚复制的 API 密钥。API 地址和模型名称、温度也可根据需求自定义。设置完成后，点击 **保存设置** 生效。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3e586c89dd0f575ac734e01ba07ea3dd" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=26c62d549a4742bb96326f99a3d328bf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=700176f091d018eb9750a995fbf19567 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4371f7b662d68039eb40bcf346b37ef6 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a37252b5283a046d4bf8f5df1e4b4990 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c7b4589a152a1220dd878a3656f53604 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=84bac4bbefa3428a7c9975062770c6a5 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4c5e79f9269c153a693dae6ed7fea031" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1688e762e69e5d6cc674ee7280bd2058 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c111fcfa11b61e89be4303b35b698c17 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=d5b022ad7caf89b1cd1f357bc5dde66d 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8de3954fcade1c9ac3418853d2676ca9 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c81f527f88ea1205b51a3b83c2e10af7 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/3.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=97f643cdb3e19e58c37395c5050ba788 2500w" />
</Frame>

2、在老子、庄子独立页面使用：点击首页“太上”、“逍遥”进入对应页面，点击对话框右上角 “**枢**” 字按钮弹出设置，在设置框中填入 API 密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=35f3a290c06156c856f245fc6d1d7ad9" data-og-width="2863" width="2863" data-og-height="1519" height="1519" data-path="images/usercases/wendao/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=20adb8d833c7b0356aa6f356c273eae4 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eaaa6756da7ff57ecc90360156d12dd4 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=968410d22bf1530556321837df58f40b 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=051ea845f27ebd065a22dcdaf1c58ed4 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=48d7e6863524d2d7f86436cb30459d74 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/wendao/4.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=50e1ef10a466c7c65a333aefe8944b4c 2500w" />
</Frame>

3、完成配置后，直接在对话框进行对话使用即可。更多页面功能可自行探索。

---

## wiseflow AI 首席情报官

**URL:** llms-txt#wiseflow-ai-首席情报官

**Contents:**
- 关于 wiseflow
- 使用方法
  - 下载项目源代码并安装 uv 和 pocketbase
  - 参考 env\_sample 配置 .env 文件
  - 起飞！

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-wiseflow

[wiseflow](https://github.com/TeamWiseFlow/wiseflow/)（中文名：AI 首席情报官）是一款利用大模型帮用户每日从海量信息、各类信源中挖掘真正感兴趣信息的开源应用。

与 ChatGPT、Manus 等 **'deep search'** 类应用不同，wiseflow 定位于 **'wide search'**，特别适合行业情报、客户信息、招投标信息、竞对动态、舆情监控以及知识情报等需要信息“广度”收集的场景。而相对于传统的 RPA 类爬虫，项目又支持免手工提取 xpath 的“开箱即用"模式，并使用大模型对每条信息严格根据用户设定的关注点进行分析、过滤和总结。

wiseflow 刚刚发布了全新的 4.0 版本，在已有的普通网页、rss 和搜索引擎信源基础上，增加提供了对微博和快手平台的支持，4.x 后续版本还将陆续提供对微信公众号平台、抖音、小红书、b 站以及知乎平台的支持。4.0 版本还对程序架构进行了比较大的重构，运行起来更加稳定、更加快速，同时对内存更加友好。

**wiseflow 自 3.1 版本开始一直推荐使用 SiliconFlow 提供的 llm 服务，4.0 版本对比 3.x 进一步简化了操作步骤，只需三步即可开始使用！**

<Note> 温馨提示：windows 用户请提前下载 git bash 工具，并在 bash 中执行如下命令 [bash下载链接](https://git-scm.com/downloads/win) </Note>

### 下载项目源代码并安装 uv 和 pocketbase

接下来去 [pocketbase docs](https://pocketbase.io/docs/) 下载对应自己系统的 pocketbase 程序并放置于 wiseflow/pb 文件夹下。

注意，使用 MacOS 的小伙伴需要在这一步完成后，去到 wiseflow/pb 文件夹执行一次：

### 参考 env\_sample 配置 .env 文件

先在 wiseflow 文件夹（项目根目录）参考 env\_sample 创建 .env 文件，并填入相关设定信息。

**接下来就要轮到 SiliconFlow 登场了！**

* 进入 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）；
* 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key；
* 点击密钥进行复制，然后填入上一步创建的 .env 文件的 LLM\_API\_KEY 中，同时将 LLM\_API\_BASE 设置为 [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)

对于 wiseflow 这种“广度信息搜集”任务，Qwen3-14B 模型已经可以实现不错的效果，VL\_MODEL 只是辅助作用。Qwen2.5-VL-7B-Instruct 也可以满足要求，wiseflow 也特别针对小尺寸模型做了优化，当然如果你的关注点涉及大量约束限制条件以及专有名词，也可以选择尺寸更大的 Qwen3-32B 模型。

有关 .env 其他项目的说明可以参考 wiseflow 的 [docs/manual/manual.md](https://github.com/TeamWiseFlow/wiseflow/blob/master/docs/manual/manual.md)

```Bash  theme={null}
cd wiseflow
uv venv # 仅第一次执行需要
source .venv/bin/activate  # Linux/macOS# 
#或者在 Windows 上：

**Examples:**

Example 1 (unknown):
```unknown
上述操作会完成 uv 的安装。

接下来去 [pocketbase docs](https://pocketbase.io/docs/) 下载对应自己系统的 pocketbase 程序并放置于 wiseflow/pb 文件夹下。

注意，使用 MacOS 的小伙伴需要在这一步完成后，去到 wiseflow/pb 文件夹执行一次：
```

Example 2 (unknown):
```unknown
### 参考 env\_sample 配置 .env 文件

先在 wiseflow 文件夹（项目根目录）参考 env\_sample 创建 .env 文件，并填入相关设定信息。

**接下来就要轮到 SiliconFlow 登场了！**

* 进入 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）；
* 完成注册后，打开 [API 密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key；
* 点击密钥进行复制，然后填入上一步创建的 .env 文件的 LLM\_API\_KEY 中，同时将 LLM\_API\_BASE 设置为 [https://api.siliconflow.cn/v1](https://api.siliconflow.cn/v1)

.env 文件最终可以参考如下：
```

Example 3 (unknown):
```unknown
对于 wiseflow 这种“广度信息搜集”任务，Qwen3-14B 模型已经可以实现不错的效果，VL\_MODEL 只是辅助作用。Qwen2.5-VL-7B-Instruct 也可以满足要求，wiseflow 也特别针对小尺寸模型做了优化，当然如果你的关注点涉及大量约束限制条件以及专有名词，也可以选择尺寸更大的 Qwen3-32B 模型。

有关 .env 其他项目的说明可以参考 wiseflow 的 [docs/manual/manual.md](https://github.com/TeamWiseFlow/wiseflow/blob/master/docs/manual/manual.md)

### 起飞！

接下来只需要依次执行如下命令即可
```

---

## .venv\Scripts\activate

**URL:** llms-txt#.venv\scripts\activate

uv sync # 仅第一次执行需要
python -m playwright install --with-deps chromium # 仅第一次执行需要
chmod +x run.sh # 仅第一次执行需要
./run.sh
```

项目会自动拉起浏览器，引导你注册并进入使用界面。

---

## 发送非流式输出的请求

**URL:** llms-txt#发送非流式输出的请求

messages = [
    {"role": "user", "content": "奥运会的传奇名将有哪些？"}
]
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=False, 
    max_tokens=4096,
    extra_body={
        "thinking_budget": 1024
    }
)
content = response.choices[0].message.content
reasoning_content = response.choices[0].message.reasoning_content

---

## 温度参数（0.0~2.0）

**URL:** llms-txt#温度参数（0.0~2.0）

temperature=0.5  # 平衡创造性与可靠性

---

## 打印响应状态码和响应内容

**URL:** llms-txt#打印响应状态码和响应内容

**Contents:**
  - 2.3 获取用户动态音色列表
  - 2.4 使用用户动态音色
  - 2.5 删除用户动态音色
- 3. 支持模型列表
  - 3.1 FunAudioLLM/CosyVoice2-0.5B 系列模型
  - 3.2 fnlp/MOSS-TTSD-v0.5
- 4. 参考音频的最佳实践
  - 4.1 音频质量指南
  - 4.2 文件格式
- 5. 使用示例

print(response.status_code)
print(response.json())  # 如果响应是 JSON 格式
json  theme={null}
{'uri': 'speech:your-voice-name:cm04pf7az00061413w7kz5qxs:mjtkgbyuunvtybnsvbxd'}
python  theme={null}
import requests

url = "https://api.siliconflow.cn/v1/uploads/audio/voice"
headers = {
    "Authorization": "Bearer your-api-key" # 从 https://cloud.siliconflow.cn/account/ak 获取
}
files = {
    "file": open("/Users/senseb/Downloads/fish_audio-Alex.mp3", "rb") # 参考音频文件
}
data = {
    "model": "FunAudioLLM/CosyVoice2-0.5B", # 模型名称
    "customName": "your-voice-name", # 参考音频名称
    "text": "在一无所知中, 梦里的一天结束了，一个新的轮回便会开始" # 参考音频的文字内容
}

response = requests.post(url, headers=headers, files=files, data=data)

print(response.status_code)
print(response.json())  # 打印响应内容（如果是JSON格式）
json  theme={null}
{'uri': 'speech:your-voice-name:cm04pf7az00061413w7kz5qxs:mjtkgbyuunvtybnsvbxd'}
python  theme={null}
import requests
url = "https://api.siliconflow.cn/v1/audio/voice/list"

headers = {
    "Authorization": "Bearer your-api-key" # 从https://cloud.siliconflow.cn/account/ak获取
}
response = requests.get(url, headers=headers)

print(response.status_code)
print(response.json()) # 打印响应内容（如果是JSON格式）
json  theme={null}
{'uri': 'speech:your-voice-name:cm04pf7az00061413w7kz5qxs:mjtkgbyuunvtybnsvbxd'}
python  theme={null}
import requests

url = "https://api.siliconflow.cn/v1/audio/voice/deletions"
headers = {
    "Authorization": "Bearer your-api-key",
    "Content-Type": "application/json"
}
payload = {
    "uri": "speech:your-voice-name:cm02pf7az00061413w7kz5qxs:mttkgbyuunvtybnsvbxd"
}

response = requests.request("POST", url, json=payload, headers=headers)

print(response.status_code)
print(response.text) #打印响应内容
python  theme={null}
from pathlib import Path
from openai import OpenAI

speech_file_path = Path(__file__).parent / "siliconcloud-generated-speech.mp3"

client = OpenAI(
    api_key="您的 APIKEY", # 从 https://cloud.siliconflow.cn/account/ak 获取
    base_url="https://api.siliconflow.cn/v1"
)

with client.audio.speech.with_streaming_response.create(
  model="FunAudioLLM/CosyVoice2-0.5B", # 支持 fishaudio / GPT-SoVITS / CosyVoice2-0.5B 系列模型
  voice="FunAudioLLM/CosyVoice2-0.5B:alex", # 系统预置音色
  # 用户输入信息
  input="你能用高兴的情感说吗？<|endofprompt|>今天真是太开心了，马上要放假了！I'm so happy, Spring Festival is coming!",
  response_format="mp3" # 支持 mp3, wav, pcm, opus 格式
) as response:
    response.stream_to_file(speech_file_path)

python  theme={null}
from pathlib import Path
from openai import OpenAI

speech_file_path = Path(__file__).parent / "siliconcloud-generated-speech.mp3"

client = OpenAI(
    api_key="您的 APIKEY", # 从 https://cloud.siliconflow.cn/account/ak 获取
    base_url="https://api.siliconflow.cn/v1"
)

with client.audio.speech.with_streaming_response.create(
  model="FunAudioLLM/CosyVoice2-0.5B", # 支持 fishaudio / GPT-SoVITS / CosyVoice2-0.5B 系列模型
  voice="speech:your-voice-name:cm02pf7az00061413w7kz5qxs:mttkgbyuunvtybnsvbxd", # 用户上传音色名称，参考
  # 用户输入信息
  input=" 请问你能模仿粤语的口音吗？< |endofprompt| >多保重，早休息。",
  response_format="mp3"
) as response:
    response.stream_to_file(speech_file_path)

python  theme={null}
from pathlib import Path
from openai import OpenAI
client = OpenAI()

speech_file_path = Path(__file__).parent / "siliconcloud-generated-speech.mp3"

client = OpenAI(
    api_key="您的 APIKEY", # 从 https://cloud.siliconflow.cn/account/ak 获取
    base_url="https://api.siliconflow.cn/v1"
)

with client.audio.speech.with_streaming_response.create(
  model="FunAudioLLM/CosyVoice2-0.5B", 
  voice="", # 此处传入空值，表示使用动态音色
  # 用户输入信息
  input="  [laughter]有时候，看着小孩子们的天真行为[laughter]，我们总会会心一笑。",
  response_format="mp3",
  extra_body={"references":[
        {
            "audio": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Alex.mp3", # 参考音频 url。也支持 base64 格式
            "text": "在一无所知中, 梦里的一天结束了，一个新的轮回便会开始", # 参考音频的文字内容
        }
    ]}
) as response:
    response.stream_to_file(speech_file_path)
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
上述接口返回的 `uri` 字段，即为自定义音色的 ID，用户可以将其作为后续的 `voice` 参数中，进行请求。
```

Example 2 (unknown):
```unknown
在请求中[使用用户预置音色](/capabilities/text-to-speech#5-2)。

#### 2.2.2 通过文件上传用户预置音色
```

Example 3 (unknown):
```unknown
上述接口返回的 `uri` 字段，即为自定义音色的 ID，用户可以将其作为后续的 `voice` 参数中，进行请求。
```

Example 4 (unknown):
```unknown
在请求中[使用用户预置音色](/capabilities/text-to-speech#5-2)。

### 2.3 获取用户动态音色列表
```

---

## -*- coding: utf-8 -*-

**URL:** llms-txt#-*--coding:-utf-8--*-

import requests
import json

url = "https://api.siliconflow.cn/v1/audio/speech"
token = "Your-api-key"

request_data = {
                "model": "fnlp/MOSS-TTSD-v0.5",
                "stream": True,
                "input": "[S1]Hello, how are you today?[S2]I'm doing great, thanks for asking![S1]That's wonderful to hear.",
                "references": [
                    {
                        "audio": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Charles.mp3",
                        "text": "他又躺在那里，眼睛闭着，仍然沉浸在梦境的气氛里。那是个庞杂而亮堂的梦",
                    },
                    {
                        "audio": "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Claire.mp3",
                        "text": "他又躺在那里，眼睛闭着，仍然沉浸在梦境的气氛里。那是个庞杂而亮堂的梦"
                    }
                    ],
                "max_tokens": 1600,
                "response_format": "mp3",
                "speed": 1,
                "gain": 0
                }
headers = {'Content-Type': 'application/json', 'Authorization': "Bearer " + token}
try:
    res = requests.post(url=url, data=json.dumps(request_data), headers=headers)
    if res.status_code != 200:
        print(res.text)
    with open('./test.mp3', 'wb') as file:
        file.write(res.content)
except Exception as e:
    print(request_data)
    print(e)
```

---

## 测试 quick_sort 函数

**URL:** llms-txt#测试-quick_sort-函数

arr = [3, 6, 8, 10, 1, 2, 1]
sorted_arr = quick_sort(arr)
print("Sorted array:", sorted_arr)
""",
    stream=True,
    max_tokens=4096
)

for chunk in response:
    print(chunk.choices[0].text, end='')
```

---

## 示例使用

**URL:** llms-txt#示例使用

prompt = "how is the weather today in beijing?"
print(function_call_playground(prompt))
shell  theme={null}
The weather in Beijing today is sunny with a temperature of 21.4°C.
```

**Examples:**

Example 1 (unknown):
```unknown
模型将输出：
```

---

## 主体变更协议

**URL:** llms-txt#主体变更协议

**Contents:**
- 一、定义和解释
- 二. 协议主体、内容与生效
- 三. 变更的条件及程序
- 四. 账号主体变更的影响
- 五. 双方权利与义务
- 六. 附则

Source: https://docs.siliconflow.cn/cn/legals/agreement-for-account-ownership-transfer

在您正式提交账号主体变更申请前，请您务必认真阅读本协议。**<u>本协议将通过加粗或加下划线的形式提示您特别关注对您的权利及义务将产生重要影响的相应条款。</u>** 如果您对本协议的条款有疑问的，请向[contact@siliconflow.cn](mailto:contact@siliconflow.cn)咨询，如果您不同意本协议的内容，或者无法准确理解 SiliconFlow 平台（本平台）对条款的解释，请不要进行后续操作。

当您通过网络页面直接确认、接受引用本页面链接及提示遵守内容、签署书面协议、以及本平台认可的其他方式，或以其他法律法规或惯例认可的方式选择接受本协议，即表示您与本平台已达成协议，并同意接受本协议的全部约定内容。自本协议约定的生效之日起，本协议对您具有法律约束力。

**<u>请您务必在接受本协议，且确信通过账号主体变更的操作，能够实现您所希望的目的，且您能够接受因本次变更行为的相关后果与责任后，再进行后续操作。</u>**

1.1 “本平台官网”：是指包含域名为[https://siliconflow.cn的网站。](https://siliconflow.cn的网站。)

1.2 “本平台账号”：是指本平台分配给注册用户的数字ID，以下简称为“本平台账号”、“账号”。

1.3 “本平台账号持有人”，是指注册、持有并使用本平台账号的用户。

已完成实名认证的账号，除有相反证据外，本平台将根据用户的实名认证信息来确定账号持有人，如用户填写信息与实名认证主体信息不同的，以实名认证信息为准；未完成实名认证的账号，本平台将根据用户的填写信息，结合其他相关因素合理判断账号持有人。

1.4 “账号实名认证主体变更”：是指某一本平台账号的实名认证主体（原主体），变更为另一实名认证主体（新主体），本协议中简称为“账号主体变更”。

1.5 本协议下的“账号主体变更”程序、后果，仅适用于依据账号原主体申请发起、且被账号新主体接受的本平台账号实名认证主体变更情形。

**2.1** 本协议是特定本平台账号的账号持有人（“您”、“原主体”）与本平台之间，就您申请将双方之前就本次申请主体变更的本平台账号所达成的《SiliconFlow平台产品用户协议》的权利义务转让给第三方，及相关事宜所达成的一致条款。

**<u>2.2 本协议为附生效条件的协议，仅在以下四个条件同时满足的情况下，</u>** 才对您及本平台产生法律效力：

2.2.1 您所申请变更的本平台账号已完成了实名认证，且您为该实名认证主体；

2.2.2 本平台审核且同意您的账号主体变更申请；

2.2.3 您申请将账号下权利义务转让给第三方（“新主体”），且其同意按照《SiliconFlow平台产品用户协议》的约定继续履行相应的权利及义务；

2.2.4 新主体仅为企业主体，不能为自然人主体。

**<u>2.3 您与新主体就账号下所有的产品、服务、资金、债权、债务等（统称为“账号下资源”）转让等相关事项，由您与新主体之间另外自行约定。但如果您与新主体之间的约定如与本协议约定冲突的，应优先适用本协议的约定。</u>**

**3.1** 本平台仅接受符合以下条件下的账号主体变更申请；

3.1.1 由于原账号主体发生合并、分立、重组、解散、死亡等原因，需要进行账号主体变更的；

3.1.2 根据生效判决、裁定、裁决、决定等生效法律文书，需要账号主体变更的；

3.1.3 账号实际持有人与账号实名认证主体不一致，且提供了明确证明的；

3.1.4 根据法律法规规定，应当进行账号主体变更的；

3.1.5 本平台经过审慎判断，认为可以进行账号主体变更的其他情形。

**3.2** 您发起账号主体变更，应遵循如下程序要求：

3.2.1 您应在申请变更的本平台账号下发起账号主体变更申请；

3.2.2 本平台有权通过手机号、人脸识别等进行二次验证、要求您出具授权证明（当您通过账号管理人发起变更申请时）、以及其他本平台认为有必要的材料，确认本次申请账号主体变更的行为确系您本人意愿；

3.2.3 您应同意本协议的约定，接受本协议对您具有法律约束力；

3.2.4 您应遵守与账号主体变更相关的其他本平台规则、制度等的要求。

**<u>3.3 您理解并同意，</u>**

**<u>3.3.1 在新主体确认接受且完成实名认证前，您可以撤回、取消本账号主体变更流程；</u>**

**<u>3.3.2 当新主体确认接受且完成实名认证后，您的撤销或取消请求本平台将不予支持；</u>**

**<u>3.3.3 且您有义务配合新主体完成账号管理权的转交。</u>**

**<u>3.3.4 在您进行实名认证主体变更期间，本账号下的登录和操作行为均视为您的行为，您应注意和承担账号的操作风险。</u>**

**<u>3.4 您理解并同意，如果发现以下任一情形的，本平台有权随时终止账号主体变更程序或采取相应处理措施：</u>**

**<u>3.4.1 第三方对该账号发起投诉，且尚未处理完毕的；</u>**

**<u>3.4.2 该账号正处于国家主管部门的调查中；</u>**

**<u>3.4.3 该账号正处于诉讼、仲裁或其他法律程序中；</u>**

**<u>3.4.4 该账号下存在与本平台的信控关系、伙伴关系等与原主体身份关联的合作关系的；</u>**

**<u>3.4.5 存在其他可能损害国家、社会利益，或者损害本平台或其他第三方权利的情形的；</u>**

**<u>3.4.6 该账号因存在频繁变更引起的账号纠纷或账号归属不明确的情形。</u>**

**4.1** 当您的账号主体变更申请经本平台同意，且新主体确认并完成实名认证后，该账号主体将完成变更，变更成功以本平台系统记录为准，变更成功后会对您产生如下后果：

**<u>4.1.1您本账号下的权益转让给变更后的实名主体，权益包括不限于账号控制权、账号下已开通的服务、账号下未消耗的充值金额等；</u>**

4.1.2 该账号及该账号下的全部资源的归属权全部转由新主体拥有。**<u>但本平台有权终止，原主体通过该账号与本平台另行达成的关于优惠政策、信控、伙伴合作等相关事项的合作协议，或与其他本平台账号之间存在的关联关系等；</u>**

**<u>4.1.3 本平台不接受您以和新主体之间的协议为由或以其他理由，要求将该账号下一项或多项业务、权益转移给您指定的其他账号的要求；</u>**

**<u>4.1.4 本平台有权拒绝您以和新主体之间存在纠纷为由或以其他理由，要求撤销该账号主体变更的请求；</u>**

**<u>4.1.5 本平台有权在您与新主体之间就账号管理权发生争议或纠纷时，采取相应措施使得新主体获得该账号的实际管理权。</u>**

**<u>4.2 您理解并确认，账号主体变更并不代表您自变更之时起已对该账号下的所有行为和责任得到豁免或减轻：</u>**

**<u>4.2.1 您仍应对账号主体变更前，该账号下发生的所有行为承担责任；</u>**

**<u>4.2.2 您还需要对于变更之前已经产生，变更之后继续履行的合同及其他事项，对新主体在变更之后的履行行为及后果承担连带责任。</u>**

5.1.1 您在账号主体变更流程中所填写的内容及提交的资料均真实、准确、有效，且不存在任何误导或可能误导本平台同意接受该项账号主体变更申请的行为；

5.1.2 您不存在利用本平台的账号主体变更服务进行任何违反法律、法规、部门规章和国家政策等，或侵害任何第三方权利的行为；

**<u>5.1.3 您进行账号主体变更的操作不会置本平台于违约或者违法的境地。因该账号主体变更行为而产生的任何纠纷、争议、损失、侵权、违约责任等，本平台不承担法律明确规定外的责任。</u>**

**<u>您进一步承诺，如上述原因给本平台造成损失的，您应向本平台承担相应赔偿责任。</u>**

5.2.1 本平台有权在您发起申请后的任一时刻，要求您提供书面材料或其他证明，证明您有权进行变更账号主体的操作；

5.2.2 本平台有权依据自己谨慎的判断来确定您的申请是否符合法律法规或政策的规定及账号协议的约定，如存在违法违规或其他不适宜变更的情形的，本平台有权拒绝；

5.2.3 本平台有权记录账号实名认证主体变更前后的账号主体、交易流水、合同等相关信息，以遵守法律法规的规定，以及维护自身的合法权益；

5.2.4 如果您存在违反本协议第5.1条的行为的，本平台一经发现，有权直接终止账号主体变更流程，或者撤销已完成的账号主体变更操作，将账号主体恢复为没有进行变更前的状态。

**6.1** 您理解并接受，本协议的订立、执行和解释及争议的解决均应适用中华人民共和国法律，与法律规定不一致或存在冲突的，该不一致或冲突条款不具有法律约束力。

**6.2** 就本协议内容或其执行发生任何争议，双方应进行友好协商；协商不成时，任一方均可向被告方所在地有管辖权的人民法院提起诉讼。

**6.3** 本协议如果与双方以前签署的有关条款或者本平台的有关陈述不一致或者相抵触的，以本协议约定为准。

**<u>您在此再次保证已经完全阅读并理解了上述《申请账号主体变更协议》，并自愿正式进入账号主体变更的后续流程，接受上述条款的约束。</u>**

---

## 隐私政策

**URL:** llms-txt#隐私政策

Source: https://docs.siliconflow.cn/cn/legals/privacy-policy

欢迎您使用SiliconFlow高性价比的GenAI开放平台。北京硅基流动科技有限公司及其关联方（**“硅基流动”或“我们”**）非常重视用户（**“您”**）信息的保护。您在注册、登录、使用[https://siliconflow.cn（“本平台”）时，我们依据本隐私政策使用您的相关数据信息。](https://siliconflow.cn（“本平台”）时，我们依据本隐私政策使用您的相关数据信息。)

如我们的服务可能包含指向第三方网站、应用程序或服务的链接，本政策不适用于第三方提供的任何产品、服务、网站或内容。如您（或您的公司等经营实体）借助我们的产品或服务为您（或您的公司等经营实体）的客户提供服务，您（或您的公司等经营实体）需要自行制定符合交易场景及相关法律的隐私政策。如您（或您的公司等经营实体）同意借用我们的产品或服务访问第三方网站、应用程序或服务的链接，您（或您的公司等经营实体）需要自行遵守第三方网站、应用程序或服务的相关政策。

我们希望通过本隐私政策向您介绍我们对您的用户信息和交互数据的处理方式。在您开始使用我们的服务前，请您务必先仔细阅读和理解本政策，特别应重点阅读我们以粗体标识的条款，确保您充分理解和同意后再开始使用。如果您不同意本隐私政策，您应当立即停止使用服务。当您选择使用服务时，将视为您接受和认可我们按照本隐私政策对您的相关信息进行处理。

---

## 概述

**URL:** llms-txt#概述

**Contents:**
- 1. 我们如何收集和使用您的用户信息
  - 1.1 我们主动收集您的用户信息
  - 1.2 我们可能从第三方获得的用户信息
  - 1.3 收集、使用用户信息目的变更的处理
  - 1.4 业务和客户数据
- 2. 对Cookie和同类技术的使用
- 3. 我们如何存储您的用户信息
  - 3.1 信息存储的地点
  - 3.2 信息存储的期限
- 4.我们如何共享、转让、公开披露您的信息

1. 我们如何收集和使用您的用户信息
2. 对Cookie和同类技术的使用
3. 我们如何存储您的用户信息
4. 我们如何共享、转让、公开披露您的信息
5. 我们如何保护您的信息安全
6. 我们如何管理您的用户信息
7. 未成年人使用条款
8. 隐私政策的修订和通知
9. 适用范围

## 1. 我们如何收集和使用您的用户信息

为了保证您正常使用我们的平台，且在法律允许的情况下，我们会在如下场景和业务活动中收集您在使用服务时主动提供的信息，以及我们通过自动化手段收集您在使用服务过程中产生的信息（**“用户信息”**）<sup><a href="#fn1" id="ref1">1</a></sup>，包括但不限于您主动提供的个人信息。特别提示您注意，如信息无法单独或结合其他信息识别到您的个人身份且与您无关，其不属于法律意义上您的个人信息；当您的信息可以单独或结合其他信息识别到您的个人身份或与您有关时，或我们将无法与任何特定用户建立联系的数据与其他您的用户信息结合使用时，则在结合使用期间，这些信息将作为您的用户信息按照本隐私政策处理与保护。需要澄清的是，个人信息不包括经匿名化处理后的信息。

**1.1.1 您注册、认证、登录本平台账号时**<br />
当您在本平台注册账号时，您可以通过手机号创建账号。我们将通过发送短信验证码来验证您的身份是否有效，收集这些信息是为了帮助您完成注册和登录。 如果您使用其他平台的账号登录本平台，您授权我们获得您其他平台账号的相关信息，例如微信等第三方平台的账户/账号信息（包括但不限于名称、头像以及您授权的其他信息）。

**1.1.2 您订购及开通使用服务时**<br />
在您订购或开通使用我们提供的任一项服务前，根据中华人民共和国大陆地区（不含中国香港、澳门、台湾地区）相关法律法规的规定，我们需要对您进行实名认证。

(1) 如果您是个人用户，您可能需要提供您的真实身份信息，包括真实姓名、身份证件号码、身份证件正反面照片、中国银联成员机构I类银行账户卡号或 信用卡 号、银行预留手机号码等信息以完成实名认证。

(2) 如果您是单位用户，您可能需要提供您的相关信息，包括您的主体名称、统一社会信用代码、就注册账号所出具的授权委托书（加盖单位公章）、法人或组织的登记/资格证明（证件类型包括：企业营业执照、组织机构代码证、事业单位法人证书、社会团体法人登记证书、行政执法主体资格证等）、开户行、开户行账号（中国银联成员机构I类银行账户或信用卡号）、法定代表人或被授权人姓名、身份证件号码、身份证件正反面照片、法定代表人证件照片等信息以完成实名认证。另外，您可能需要提供企业联系人的个人信息，包括姓名、手机号码、电子邮箱。我们可能通过这些信息验证您的用户身份，并向您推广、介绍服务，发送业务通知、开具发票或与您进行业务沟通等。如您提供的上述信息包含第三方的个人信息或用户信息，您承诺并保证您向我们提供这些信息前已经获得了相关权利人的授权许可。

(3) 上述实名认证过程中，如果您通过人脸识别来进行实名认证的，您还需要提供面部特征的生物识别信息，并授权我们通过国家权威可信身份认证机构进行信息核验。

**1.1.3 您使用服务时**<br />

(1) 我们致力于为您提供安全、可信的产品与使用环境，提供优质而可靠的服务与信息是我们的核心目标。为了维护我们服务的正常运行，保护您或其他用户或公众的合法利益免受损失，我们会收集用于维护产品或服务安全稳定运行的必要信息。

(2) 当您浏览或使用本平台时，为了保障网站和服务的正常运行及运营安全，预防网络攻击、侵入风险，更准确地识别违反法律法规或本平台的相关协议、服务规则的情况，我们会收集您的分辨率、时区和语言等设备信息、网络接入方式及类型信息、网页浏览记录。这些信息是我们提供服务和保障服务正常运行和网络安全所必须收集的基本信息。

(3) 为让您体验到更好的服务，并保障您的使用安全，我们可能记录网络日志信息，以及使用本平台及相关服务的频率、崩溃数据、使用情况及相关性能数据信息。

(4) 当您参与本平台调研、抽奖活动时，本平台可能会留存您的账号ID、姓名、地址、手机号、职务身份、产品和服务使用情况等信息，以后续与您取得联系，核实身份信息，并按照有关活动规则为您提供奖励（如有），具体调研、抽奖活动规则与本协议不一致的，以活动规则为准。

(5) 我们可能收集您使用本平台及相关服务而产生的用户咨询记录、报障记录和针对用户故障的排障过程（如通信或通话记录），我们将通过记录、分析这些信息以便更及时响应您的帮助请求，以及用于改进服务。

(6) 合同信息，如果您需要申请线下交付或进行产品测试等，请联系[contact@siliconflow.cn](mailto:contact@siliconflow.cn)。

(7) 为了向您提供域名服务，依据工信部相关要求，我们会收集域名持有者名称、联系人姓名、通讯地址、地区、邮编、电子邮箱、固定电话/手机号码、证件号码、证件照片。您理解并授权我们和第三方域名服务机构使用这些信息资料为您提供域名服务。

(8) 为了向您提供证书中心服务，依据数字证书认证机构相关要求，我们会收集联系人姓名、联系人邮箱、联系人手机号码、企业名称、企业所在城市、企业地址。您理解并授权我们和第三方证书服务机构使用这些信息资料为您提供证书中心服务。

(9) 您知悉并同意，对于您在使用产品及/或服务的过程中提供的您的联系方式（即联系电话及电子邮箱），我们在运营中可能会向其中的一种或多种发送通知，用于用户消息告知、身份验证、安全验证、用户使用体验调研等用途；此外，我们也可能会向在前述过程中收集的手机号码通过短信、电话的方式，为您提供您可能感兴趣的服务、功能或活动等商业性信息的用途，但请您放心，如您不愿接受这些信息，您可以通过手机短信或回复邮件退订方式进行退订，也可以直接与我们联系进行退订。

### 1.2 我们可能从第三方获得的用户信息

为了给您提供更好、更优、更加个性化的服务，或共同为您提供服务，或为了预防互联网欺诈的目的，我们的关联公司、合作伙伴可能会依据法律规定或与您的约定或征得您同意前提下，向我们分享您的信息。我们会根据相关法律法规规定和/或该身份认证功能所必需，采用行业内通行的方式及尽最大的商业努力来保护您用户信息的安全。

### 1.3 收集、使用用户信息目的变更的处理

请您了解，随着我们业务的发展，我们提供的功能或服务可能有所调整变化。原则上，当新功能或服务与我们当前提供的功能或服务相关时，收集与使用的用户信息将与原处理目的具有直接或合理关联。仅在与原处理目的无直接或合理关联的场景下，我们收集、使用您的用户信息，会再次按照法律法规及国家标准的要求以页面提示、交互流程、协议确认方式另行向您进行告知说明。

**请您理解，不同于您的用户信息<sup><a href="#fn2" id="ref2">2</a></sup>，本平台将按如下方式使用您的交互数据（定义见下）：**

**1.4.1** 您通过本平台提供的服务与开源模型、第三方网站、软件、应用程序或服务之间进行输入、反馈、修正、加工、存储、上传、下载、分发相关个人资料信息、视频、图像、音频、评论、问题和其他内容、文件、数据和信息等均为您的业务和客户数据（**“交互数据”**），您完全拥有您的交互数据。

**1.4.2** 本平台作为中立的技术服务提供者，只会严格执行您的指示处理您的交互数据，我们及本平台只是作为交互数据的被动技术支持者或渠道，除非法律法规另有规定、依据特定产品规则另行约定或基于您的要求为您提供技术协助进行故障排除或解决技术问题。我们及本平台不会对您的交互数据进行任何非授权的使用或披露，同时亦不会进行任何存储。

**1.4.3** 您应对您的交互数据来源及内容负责，我们提示您谨慎判断数据来源及内容的合法性。您应保证有权授权本平台通过提供技术服务对该等交互数据进行处理，且前述处理活动均符合相关法律法规的要求，不存在任何违法违规、侵权或违反与第三方合同约定的情形，亦不会将数据用于违法违规目的。若因您的交互数据内容或您处理以及您授权本平台处理交互数据行为违反法律法规、部门规章或国家政策而造成的全部结果及责任均由您自行承担。

**1.4.4** 受限于前款规定，若您提供的交互数据包含任何个人信息或需要获得授权后才能使用的信息时（“需授权信息”），您应当自行依法提前向相关信息主体履行告知义务，并取得相关信息主体的单独同意，并保证：

(1)在我们要求时，您能就需授权信息的来源及其合法性提供书面说明和确认；<br />
(2)在我们要求时，您能提供需授权信息的授权范围，包括使用目的，个人信息主体同意您使用本平台对其个人信息进行处理；如您超出该等需授权信息的授权范围或期限时，您应自行负责获得需授权信息授权的范围扩大或延期。<br />
您理解并同意，除非满足上述条件及法律要求的其他义务，您不得向我们提供包含需授权信息的交互数据。<br />
如您违反上述义务，或未按照要求向我们提供合理满意的证明，或我们收到个人信息主体举报或投诉，我们有权单方决定拒绝继续提供技术服务（根据实际情形，包括通过限制相关服务功能，冻结、注销或收回账号等方式），或拒绝按照您的指令处理相关个人信息及其相关的数据，由此产生的全部责任均由您自行承担。

## 2. 对Cookie和同类技术的使用

Cookie和同类技术是互联网中的通用常用技术。当您使用本平台时，我们可能会使用相关技术向您的设备发送一个或多个Cookie或匿名标识符，以收集和存储您的账号信息、搜索记录信息以及登录状态信息。通过Cookie和同类技术可以帮助您省去重复填写账号信息、输入搜索内容的步骤和流程，还可以帮助我们改进服务效率、提升登录和响应速度。

您可以通过浏览器设置拒绝或管理Cookie。但请注意，如果停用Cookie，您有可能无法享受最佳的服务体验，某些功能的可用性可能会受到影响。我们承诺，我们不会将通过Cookie或同类技术收集到的您的用户信息用于本隐私政策所述目的之外的任何其他用途。

出于服务专业性考虑，我们可能委托关联公司或其他法律主体向您提供本平台上一项或多项具体服务。我们依照法律法规的规定，将在境内运营本网站和相关服务过程中收集和产生的用户信息存储于中华人民共和国境内。

**3.2.1** 我们将仅在为提供本平台及相关服务之目的所必需的期间内保留您的用户信息，但您理解并认可基于不同的服务及其功能需求，必要存储期限可能会有所不同。我们用于确定存储期限的标准包括：

(1) 完成该业务目的需要留存用户信息的时间，包括提供服务，依据法律要求维护相应的交易及业务记录，保证系统和服务的安全，应对可能的用户查询或投诉、问题定位等；

(3) 法律、合同等对保留用户信息的特殊要求等。

**3.2.2** 在您未撤回授权同意、删除或注销账号期间，我们会保留相关信息。超出必要期限后，我们将对您的信息进行删除或匿名化处理，前述情况若法律法规有强制留存要求的情况下，即使您注销您的账户或要求删除您的用户信息，我们亦无法删除或匿名化处理您的用户信息。

## 4.我们如何共享、转让、公开披露您的信息

### 4.1 数据使用过程中涉及的合作方

(1) 合法原则：与合作方合作过程中涉及数据使用活动的，必须具有合法目的、符合法定的合法性基础。如果合作方使用信息不再符合合法原则，则其不应再使用您的用户信息，或在获得相应合作性基础后再行使用。

(2) 正当与最小必要原则：数据使用必须具有正当目的，且应以达成目的必要为限。

(3) 安全审慎原则：我们将审慎评估合作方使用数据的目的，对这些合作方的安全保障能力进行综合评估，并要求其遵循合作法律协议。我们会对合作方获取信息的软件工具开发包（SDK）、应用程序接口（API）进行严格的安全监测，以保护数据安全。

**4.1.2** 委托处理
对于委托处理用户信息的场景，我们会与受托合作方根据法律规定签署相关处理协议，并对其用户信息使用活动进行监督。

**4.1.3** 共同处理
对于共同处理用户信息的场景，我们会与合作方根据法律规定签署相关协议并约定各自的权利和义务，确保在使用相关用户信息的过程中遵守法律的相关规定、保护数据安全。

**4.1.4** 合作方的范围
若具体功能和场景中涉及由我们的关联方、第三方提供服务，则合作方范围包括我们的关联方与第三方。

### 4.2 用户信息共同数据处理或数据委托处理的情形

**4.2.1** 本平台及相关服务功能中的某些具体模块或功能由合作方提供，对此您理解并同意，在我们与任何合作方合作中，我们仅会基于合法、正当、必要及安全审慎原则，在为提供服务所最小的范围内向其提供您的用户信息，并且我们将努力确保合作方在使用您的信息时遵守本隐私政策及我们要求其遵守的其他适当的保密和安全措施，承诺不得将您的信息用于其他任何用途。

**4.2.2** 为提供更好的服务，我们可能委托合作方向您提供服务，包括但不限于客户服务、支付功能、实名认证、技术服务等，因此，为向您提供服务所必需，我们会向合作方提供您的某些信息。例如：

(1) 为进行用户实名认证在您使用身份认证的功能或相关服务所需时，根据相关法律法规的规定及相关安全保障要求可能需要完成实名认证以验证您的身份。在实名认证过程中，与我们合作的认证服务机构可能需要使用您的真实姓名、身份证号码、手机号码等。<br />
(2) 支付功能由与我们合作的第三方支付机构向您提供服务。第三方支付机构为提供功能可能使用您的姓名、银行卡类型及卡号、有效期、身份证号码及手机号码等。<br />
(3) 为及时处理您的投诉、建议以及其他诉求，我们的客户服务提供商（若有）可能需要使用您的账号及所涉及的事件的相关信息，以及时了解、处理和相应相关问题。

**4.2.3** 为保障服务安全与分析统计的数据使用

(1) 保障使用安全：我们非常重视账号与服务安全，为保障您和其他用户的账号与财产安全，使您和我们的正当合法权益免受不法侵害，我们和我们的合作方可能需要使用必要的设备、账号及日志信息。<br />
(2) 分析服务使用情况：为分析我们服务的使用情况，提升用户使用的体验，我们和我们的合作方可能需要使用您的服务使用情况（崩溃、闪退）的统计性数据，这些数据难以与其他信息结合识别您的身份或与您的身份相关联。

我们不会转移您的用户信息给任何其他第三方，但以下情形除外：

**4.3.1** 基于您的书面请求，并符合国家网信部门规定条件的，我们会向您提供转移的途径。

**4.3.2** 获得您的明确同意后，我们会向其他第三方转移您的用户信息。

**4.3.3** 在涉及本平台运营主体变更、合并、收购或破产清算时，如涉及到用户信息转移，我们会依法向您告知有关情况，并要求新的持有您的信息的公司、组织继续接受本隐私政策的约束或按照不低于本隐私政策所要求的安全标准继续保护您的信息，否则我们将要求该公司、组织重新向您征求授权同意。如发生破产且无数据承接方的，我们将对您的信息做删除处理。

**4.4.1** 原则上我们不会公开披露您的用户信息，除非获得您明确同意或遵循国家法律法规规定的披露。

(1) 获得您明确同意或基于您的主动选择，我们可能会公开披露您的用户信息；<br />
(2) 为保护您或公众的人身财产安全免遭侵害，我们可能根据适用的法律或本平台相关协议、规则披露关于您的用户信息。

请您理解，在下列情形中，根据法律法规及相关国家标准，我们收集和使用您的用户信息不必事先征得您的授权同意：<br />
(1) 与我们履行法律法规规定的义务相关的；<br />
(2) 与国家安全、国防安全直接相关的；<br />
(3) 与公共安全、公共卫生、重大公共利益直接相关的；<br />
(4) 与刑事侦查、起诉、审判和判决执行等直接相关的；<br />
(5) 出于维护您或他人的生命、财产等重大合法权益但又很难得到本人授权同意的；<br />
(6) 您自行向社会公众公开的信息；<br />
(7) 根据用户信息主体要求签订和履行合同所必需的；<br />
(8) 从合法公开披露的信息中收集的您的信息的，如合法的新闻报道、政府信息公开等渠道；<br />
(9) 用于维护软件及相关服务的安全稳定运行所必需的，例如发现、处置软件及相关服务的故障；<br />
(10) 为开展合法的新闻报道所必需的；<br />
(11) 为学术研究机构，基于公共利益开展统计或学术研究所必要，且对外提供学术研究或描述的结果时，对结果中所包含的个人信息进行去标识化处理的；<br />
(12) 法律法规规定的其他情形。

特别提示您注意，如信息无法单独或结合其他信息识别到您的个人身份，其不属于法律意义上您的个人信息；当您的信息可以单独或结合其他信息识别到您的个人身份时，这些信息在结合使用期间，将作为您的用户信息按照本隐私政策处理与保护。

我们非常重视用户信息的安全，将努力采取合理的安全措施（包括技术方面和管理方面）来保护您的信息，防止您提供的信息被不当使用或未经授权的情况下被访问、公开披露、使用、修改、损坏、丢失或泄漏。 我们会使用不低于行业通行的加密技术、匿名化处理等合理可行的手段保护您的信息，并使用安全保护机制尽可能地降低您的信息遭到恶意攻击的可能性。

我们会有专门的人员和制度保障您的信息安全。我们采取严格的数据使用和访问制度。尽管已经采取了上述合理有效措施，并已经遵守了相关法律规定要求的标准，但请您理解，由于技术的限制以及可能存在的各种恶意手段，在互联网行业，即便竭尽所能加强安全措施，也不可能始终保证信息百分之百的安全，我们将尽力确保您提供给我们的信息的安全性。您知悉并理解，您接入我们的服务所用的系统和通讯网络，有可能因我们可控范围外的因素而出现问题。因此，我们强烈建议您采取积极措施保护用户信息的安全，包括但不限于使用复杂密码、定期修改密码、不将自己的账号密码等信息透露给他人。

我们会制定应急处理预案，并在发生用户信息安全事件时立即启动应急预案，努力阻止该等安全事件的影响和后果扩大。一旦发生用户信息安全事件（泄露、丢失等）后，我们将按照法律法规的要求，及时向您告知：安全事件的基本情况和可能的影响、我们已经采取或将要采取的处置措施、您可自主防范和降低风险的建议、对您的补救措施等。我们将及时将事件相关情况以推送通知、邮件、信函或短信等形式告知您，难以逐一告知时，我们会采取合理、有效的方式发布公告。同时，我们还将按照相关监管部门要求，上报用户信息安全事件的处置情况。

我们谨此特别提醒您，本隐私政策提供的用户信息保护措施仅适用于本平台及相关服务。一旦您离开本平台及相关服务，浏览或使用其他网站、产品、服务及内容资源，我们即没有能力及义务保护您在本平台及相关服务之外的软件、网站提交的任何信息，无论您登录、浏览或使用上述软件、网站是否基于本平台的链接或引导。

我们非常重视对用户信息的管理，并依法保护您对于您信息的查阅、复制、更正、补充、删除以及撤回授权同意、注销账号、投诉举报等权利，以使您有能力保障您的隐私和信息安全。

### 6.1 您在用户信息处理活动中的权利

**6.1.1** 一般情况下，您可以查阅、复制、更正、补充、访问、修改、删除您主动提供的用户信息。

**6.1.2** 在以下情形中，您可以向我们提出删除用户信息的请求：<br />
(1) 如果处理目的已实现、无法实现或者为实现处理目的不再必要；<br />
(2) 如果我们处理用户信息的行为违反法律法规；<br />
(3) 如果我们收集、使用您的用户信息，却未征得您的同意；<br />
(4) 如果我们处理用户信息的行为违反了与您的约定；<br />
(5) 如果我们停止提供产品或者服务，或用户信息的保存期限已届满；<br />
(6) 如果您撤回同意授权；<br />
(7) 如果我们不再为您提供服务；<br />
(8) 法律、行政法规规定的其他情形。

### 6.2 撤回或改变您授权同意的范围

**6.2.1** 您理解并同意，每项服务均需要一些基本用户信息方得以完成。除为实现业务功能收集的基本用户信息外，对于额外收集的用户信息的收集和使用，您可以选择撤回您的授权，或改变您的授权范围。您也可以通过注销账号的方式，撤回我们继续收集您用户信息的全部授权。

**6.2.2** 您理解并同意，当您撤回同意或授权后，将无法继续使用与撤回的同意或授权所对应的服务，且本平台也不再处理您相应的用户信息。但您撤回同意或授权的决定，不会影响此前基于您的授权而开展的用户信息处理。

我们将根据您的书面请求，为您提供以下类型的用户信息副本：您的基本资料、用户身份信息。但请注意，我们为您提供的信息副本仅以我们直接收集的信息为限。

您享有注销账号、举报或投诉的权利。为保障安全，您可能需要提供书面请求，并以其它方式证明您的身份。 对于您合理的请求，我们原则上不收取费用。但对多次重复、超出合理限度的请求，我们将视具体情形收取一定成本费用。对于那些无端重复、需要过多技术手段（例如，需要开发新系统或从根本上改变现行惯例）、给他人合法权益带来风险或者不切实际（例如，涉及备份磁带上存放的信息）的请求，我们可能会予以拒绝。<br />
您理解并认可，在以下情形中，我们将无法响应您的请求：<br />
(1) 与我们履行法律法规规定的义务相关的；<br />
(2) 与国家安全、国防安全直接相关的；<br />
(3) 与公共安全、公共卫生、重大公共利益直接相关的；<br />
(4) 与刑事侦查、起诉、审判和执行判决等直接相关的；<br />
(5) 我们有充分证据表明用户信息主体存在主观恶意或滥用权利的；<br />
(6) 出于维护用户信息主体或其他个人的生命、财产等重大合法权益但又很难得到本人同意的；<br />
(7) 响应用户信息主体的请求将导致用户信息主体或其他个人、组织的合法权益受到严重损害的；<br />
(8) 涉及商业秘密的。

如我们停止运营，我们将停止收集您的用户信息，并将停止运营的通知以逐一送达或公告等商业上可行的形式通知您，并对我们所持有的您的用户信息进行删除或匿名化处理。

我们的服务主要面向企业或相关组织。未成年人使用本平台应已经获得监护人同意。如果我们发现在未事先获得可证实的监护人同意的情况下提供了用户信息，经未成年人的监护人书面告知后我们会设法尽快删除相关信息。

为了给您提供更好的服务，本平台及相关服务将不时更新与变化，我们会适时对本隐私政策进行修订，该等修订构成本隐私政策的一部分并具有等同于本隐私政策的效力。但未经您明确同意，我们不会严重减少您依据当前生效的隐私政策所应享受的权利。<br />
本隐私政策更新后，我们会在本平台公布更新版本，并在更新后的条款生效前通过官方网站公告或其他适当的方式提醒您更新的内容，以便您及时了解本隐私政策的最新版本。如您继续使用本平台及相关服务，视为您同意接受修订后的本隐私政策的全部内容。<br />
对于重大变更，我们还会提供更为显著的通知（包括但不限于电子邮件、短信、系统消息或在浏览页面做特别提示等方式），向您说明本隐私政策的具体变更。<br />
本隐私政策所指的重大变更包括但不限于：<br />
(1) 我们的服务模式发生重大变化。如处理用户信息的目的、处理用户信息的类型、用户信息的使用方式等；<br />
(2) 我们在所有权结构、组织架构等方面发生重大变化。如业务调整、破产并购等引起的所有变更等；<br />
(3) 用户信息传输、转移或公开披露的主要对象发生变化；<br />
(4) 您参与用户信息处理方面的权利及其行使方式发生重大变化；<br />
(5) 我们的联络方式及投诉渠道发生变化时。

本隐私政策适用于本平台提供产品、服务、解决方案以及公司后续可能不时推出的纳入服务范畴内的其他产品、服务或解决方案。

本隐私政策不适用于有单独的隐私政策且未纳入本隐私政策的第三方通过本平台向您提供的产品或服务（“第三方服务”）。您使用这些第三方服务（包括您向这些第三方提供的任何含用户信息在内的信息），将受这些第三方的服务条款及隐私政策约束（而非本隐私政策），并通过其建立的用户信息主体请求和投诉等机制，提出相关请求、投诉举报，具体规定请您仔细阅读第三方的条款。请您妥善保护自己的用户信息，仅在必要的情况下向第三方提供。

需要特别说明的是，作为本平台的用户，若您利用本平台的技术服务，为您的用户再行提供服务，因您与客户的业务合作所产生的数据属于您所有，您应当与您的用户自行约定相关隐私政策，本隐私政策不作为您与您的用户之间的隐私政策的替代。

<sup id="fn1">
  1 <a href="#ref1">↩</a>
  用户信息不同于交互数据。
</sup>

<sup id="fn2">
  2 <a href="#ref2">↩</a>

| 简要说明 | 用户信息                             | 交互数据                               |
  | ---- | -------------------------------- | ---------------------------------- |
  | 来源   | 基于使用平台功能的目的，于平台注<br />册时由用户提供给平台 | 基于使用模型或软件的目的，由用户通过平台<br />输入给模型或软件 |
  | 存储   | 平台按相关法律法规要求存储                    | 平台不存储                              |
</sup>

---

## 用户充值协议

**URL:** llms-txt#用户充值协议

**Contents:**
- 1. 接受条款
- 2. 定义
- 3. 充值条件
- 4. 账户安全
- 5. 充值方式
- 6. 充值余额和赠送余额
- 7. 充值余额使用
- 8. 发票
- 9. 关于退款
- 10. 争议解决

Source: https://docs.siliconflow.cn/cn/legals/recharge-policy

尊敬的用户，为保障您的合法权益，请您在点击“确认支付”按钮前，完整、仔细地阅读本充值协议，当您点击“确认支付”按钮，即表示您已阅读、理解本协议内容，并同意按照本协议约定的规则进行充值和使用余额行为。如您不接受本协议的部分或全部内容，请您不要点击“确认支付”按钮。

欢迎您使用SiliconFlow平台。以下所述条款和条件为平台充值的用户（以下简称“用户“或“您“）和北京硅基流动科技有限公司（以下简称“硅基流动”）就充值以及余额使用所达成的协议。
当您以在线点击“确认支付”等方式确认本协议或实际进行充值时，即表示您已理解本协议内容并同意受本协议约束，包括但不限于本协议正文及所有硅基流动已经发布的或将来可能发布的关于服务的各类规则、规范、公告、说明和（或）通知等，以及其他各项网站规则、制度等。所有前述规则为本协议不可分割的组成部分，与协议正文具有同等法律效力。
硅基流动有权根据国家法律法规的变化以及实际业务运营的需要不时修改本协议相关内容，并提前公示于软件系统、网站等以通知用户。修改后的条款应于公示通知指定的日期生效。如果您选择继续充值即表示您同意并接受修改后的协议且受其约束；如果您不同意我们对本协议的修改，请立即放弃充值或者停止使用本服务。
请注意，本协议限制了硅基流动的责任，还限制了您的责任，具体条款将以加粗并加下划线的形式提示您注意，硅基流动督促您仔细阅读。如果您对本协议的条款有疑问的，请通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）进行询问，硅基流动将向您解释条款内容。如果您不同意本协议的任意内容，或者无法准确理解硅基流动对条款的解释，请不要同意本协议或使用本协议项下的服务。

**2.1** SiliconFlow平台个人充值余额账户：简称“充值余额账户”，指由硅基流动根据用户的SiliconFlow平台账户为用户自动配置的资金账户。用户向该账户充值的行为视为用户向硅基流动预付服务费，预付服务费可用于购买SiliconFlow平台提供的产品或服务。

当您充值时，您应该具有经实名认证成功后的SiliconFlow平台账户。

**4.1** 当用户进行充值时，用户应仔细确认自己的账号及信息，若因为用户自身操作不当、不了解或未充分了解充值计费方式等因素造成充错账号、错选充值种类等情形而损害自身权益，应由用户自行承担责任。

**4.2** 用户在充值时使用第三方支付企业提供的服务的，应当遵守与该第三方的各项协议及其服务规则；在使用第三方支付服务过程中用户应当妥善保管个人信息，包括但不限于银行账号、密码、验证码等；用户同意并确认，硅基流动对因第三方支付服务产生的纠纷不承担任何责任。

**5.1** 用户充值可以选择硅基流动认可的第三方支付企业（目前支持微信支付）支付充值金额。

**5.2** 用户如委托第三方对其消耗账户充值，则用户承诺并保证其了解和信任第三方，且第三方亦了解和同意接受用户委托，为用户充值；否则，如硅基流动被第三方告知该等充值非经第三方同意，则硅基流动有权立即封禁用户的 SiliconFlow 账户（账户封禁期间，硅基流动将暂停用户使用本平台服务，包括不限于用户的 API 请求或任何线上功能，下同）。自用户的消耗账户被封禁之日起30日内，用户应提供充足证据证实第三方事先同意为其充值，否则用户同意并授权硅基流动配合第三方的要求，自用户被锁定的消耗账户中将相应款项退还第三方。如届时用户的消耗账户余额不足以退还，则短缺部分，用户同意最晚在30日内充值相应金额，委托硅基流动退还，或自其微信账户或支付宝账户自行退还，除非第三方同意用户可不退还这部分款项。

**5.3** 用户承诺并保证用于其充值余额账户充值的资金来源的合法性，否则硅基流动有权配合司法机关或其他政府主管机关的要求，对用户的 SiliconFlow 账户进行相应处理，包括但不限于封禁用户的 SiliconFlow 账户等。

**6.1** 充值余额，是指您进行在线充值并实际支付的金额（人民币），不包括任何形式的赠送金额，可在SiliconFlow 平台消耗使用。

**6.2** 赠送余额，是指根据 SiliconFlow 平台不时推出的充值优惠运营活动，在充值余额以外、额外赠予的金额（包括但不限于邀请奖励等）。赠送余额不可提现、不可转让，不可开具发票。赠送余额将依据对应的活动规则发放并依据平台服务规则使用，硅基流动对赠送金额的可用范围享有最终解释权。

**7.1** 您充值后，充值余额的使用不设有效期，不能转移、转赠。因此，请您根据自己的消耗情况选择充值金额，硅基流动对充值次数不做限制。

**7.2** 充值成功后，通常您可以立即开始使用相应产品（或服务），部分情况下可能存在延迟到账的情况，若较长时间仍未到账您可通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）联系硅基流动的服务支持人员为您处理。

硅基流动将在您的充值金额消耗后，按照实际消耗金额，根据您订购的产品（或服务）协议开具相应发票。

**9.1** 您应充分预估实际需求并确定充值金额。

**9.2** 若您使用在线支付方式（目前为微信支付），通过第三方支付企业进行充值，充值完成后 360 日内，对于尚未消费的余额您可自行操作退款。硅基流动及其合作第三方支付企业将对用户的退款操作进行审核，若审核通过将会按照原支付路径退回，并可能产生相应手续费。

**9.3** 原则上，您的每一笔在线支付充值仅支持一次退款。如遇特殊情况，您可通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）联系硅基流动的服务支持人员为您处理。

**9.4** 您通过对公转账或其他方式充值的金额，不支持自助退款，您可通过客服渠道（电子邮箱：[contact@siliconflow.cn](mailto:contact@siliconflow.cn)）联系硅基流动的服务支持人员，配合提供相关证明材料，硅基流动将在审核完成后将应退金额返回给用户，并可能产生相应手续费。

**9.5** 赠送余额（包括但不限于邀请奖励及同类非现金折扣等）不支持申请退款。

**9.6** 您完成充值并已经消耗的或根据相关产品（或服务）协议应予扣除的，将不予退还。

本协议适用中华人民共和国大陆地区法律。用户如因本协议与硅基流动发生争议的，双方应首先友好协商解决，如协商不成的，该等争议将由北京市海淀区人民法院管辖。

---
