# Discharge Summary Template

## Patient Information

**Patient Name:** [Last, First]  
**Medical Record Number:** [MRN]  
**Date of Birth:** [MM/DD/YYYY]  
**Age:** [years]  
**Sex:** [M/F]

**Admission Date:** [MM/DD/YYYY]  
**Discharge Date:** [MM/DD/YYYY]  
**Length of Stay:** [X days]

**Admitting Service:** [Medicine/Surgery/Cardiology/etc.]  
**Attending Physician:** [Name]  
**Primary Care Physician:** [Name and contact]  
**Consulting Services:** [List specialties that saw patient]

---

## Admission Diagnosis

[Primary reason for hospitalization]

Example: "Acute decompensated heart failure"

---

## Discharge Diagnoses

[Numbered list, prioritized by clinical significance]

**Primary Diagnosis:**
1. [Primary diagnosis with ICD-10 code]

**Secondary Diagnoses:**
2. [Secondary diagnosis with ICD-10 code]
3. [Additional diagnosis with ICD-10 code]
4. [Comorbidity with ICD-10 code]

Example:
```
1. Acute decompensated heart failure (I50.23)
2. Acute kidney injury on chronic kidney disease stage 3 (N17.9, N18.3)
3. Hypokalemia (E87.6)
4. Type 2 diabetes mellitus (E11.9)
5. Coronary artery disease (I25.10)
```

---

## Hospital Course

[Comprehensive yet concise narrative of hospital stay - can be organized chronologically or by problem]

### Chronological Format:

**[Date Range or Hospital Day 1-X]:**

[Patient Name] was admitted to the [service] service with [chief complaint/presenting problem]. On presentation, patient was [clinical status]. Initial workup revealed [key findings].

[Description of key events, interventions, and response to treatment organized by day or by problem]

**Hospital Day 1:** [Events and interventions]

**Hospital Day 2-3:** [Progression, response to treatment]

**Hospital Day 4-7:** [Continued treatment, consultations, procedures]

**Final Hospital Days:** [Stabilization, preparation for discharge]

### Problem-Based Format (Alternative):

**1. [Primary Problem]**
- Presentation and initial management
- Diagnostic workup
- Treatment course
- Response and outcome
- Status at discharge

**2. [Secondary Problem]**
- [Similar structure]

**3. [Additional Problems]**

### Key Events and Interventions

**Consultations Obtained:**
- [Specialty] consulted on [date] for [reason]: [Recommendations]

**Procedures Performed:**
- [Procedure name] on [date]: [Indication, findings, complications if any]

**Significant Diagnostic Studies:**
- [Test/imaging] on [date]: [Key findings relevant to discharge care]

**Complications:**
- [Any complications that occurred]: [How managed]

---

## Procedures Performed During Hospitalization

1. [Procedure name] ([Date])
   - Indication: [Why performed]
   - Findings: [Key findings]
   - Complications: [None / specific complications]

2. [Additional procedures]

---

## Hospital Course Summary (Brief Version)

[One paragraph summary suitable for quick reference]

Example:
```
Mr. [Name] was admitted with acute decompensated heart failure in the setting of 
medication non-adherence. He was diuresed with IV furosemide with net negative 
5 liters over 3 days, with significant improvement in dyspnea and resolution of 
lower extremity edema. Echocardiogram showed EF 30%, similar to prior. Kidney 
function improved to baseline with diuresis. He was transitioned to oral diuretics 
on hospital day 3 and remained stable. Patient was ambulating without dyspnea on 
room air by discharge. Comprehensive heart failure education was provided.
```

---

## Discharge Physical Examination

**Vital Signs:**
- Temperature: \_\_\_\_\_ °F
- Blood Pressure: \_\_\_\_\_/\_\_\_\_\_ mmHg
- Heart Rate: \_\_\_\_\_ bpm
- Respiratory Rate: \_\_\_\_\_ breaths/min
- Oxygen Saturation: \_\_\_\_\_% on [room air / O2]
- Weight: \_\_\_\_\_ kg (Admission weight: \_\_\_\_\_ kg)

**General:** [Appearance, distress level]

**Cardiovascular:** [Heart sounds, edema]

**Pulmonary:** [Breath sounds, work of breathing]

**Abdomen:** [Tenderness, bowel sounds, distention]

**Extremities:** [Edema, pulses]

**Neurological:** [Mental status, focal deficits]

**Wounds/Incisions (if applicable):** [Healing status]

---

## Pertinent Laboratory and Imaging Results

### Discharge Labs ([Date])

| Test | Result | Reference Range |
|------|--------|----------------|
| WBC | [Value] | [Range] |
| Hemoglobin | [Value] | [Range] |
| Platelets | [Value] | [Range] |
| Sodium | [Value] | [Range] |
| Potassium | [Value] | [Range] |
| Creatinine | [Value] | [Range] |
| [Other relevant labs] | [Value] | [Range] |

### Imaging/Diagnostic Studies

**[Study name] ([Date]):** [Key findings relevant to outpatient management]

---

## Discharge Medications

[Complete list with clear indication of changes from admission]

### New Medications (Started During Hospitalization)

1. **[Medication name]** [dose] [route] [frequency]
   - Indication: [Why prescribed]
   - Duration: [If limited duration]
   - Special instructions: [With food, time of day, etc.]

### Changed Medications (Dose or Frequency Modified)

2. **[Medication name]** [NEW dose] [route] [frequency]
   - **CHANGED FROM:** [Previous dose and frequency]
   - Reason for change: [Why modified]

### Continued Medications (No change from home medications)

3. **[Medication name]** [dose] [route] [frequency]
   - **CONTINUED** from home regimen

### Discontinued Medications (Stopped During Hospitalization)

4. **[Medication name]** - **DISCONTINUED**
   - Reason: [Why stopped]

### Complete Medication List for Patient

[Consolidated list in simple format for patient]

```
1. Furosemide 40 mg by mouth once daily [NEW - for fluid management]
2. Carvedilol 12.5 mg by mouth twice daily [CONTINUED]
3. Lisinopril 20 mg by mouth once daily [CONTINUED]
4. Metformin 1000 mg by mouth twice daily [CONTINUED]
5. Aspirin 81 mg by mouth once daily [CONTINUED]
```

---

## Discharge Condition

**Overall Status:** [Stable / Improved / Baseline / Requires continued care]

**Specific Assessments:**
- Hemodynamic status: [Stable]
- Respiratory status: [Room air / Oxygen requirement]
- Mental status: [Alert and oriented x3 / Other]
- Functional status: [Ambulatory / Requires assistance / Bedbound]
- Pain control: [Adequate / Inadequate]
- Wound healing (if applicable): [Appropriate / Delayed]

Example:
```
Patient is hemodynamically stable, ambulatory without assistance, no supplemental 
oxygen requirement, euvolemic on physical exam, pain well-controlled, and has 
returned to baseline functional status.
```

---

## Discharge Disposition

[Where patient is going after hospital discharge]

Options:
- Home with self-care
- Home with home health services
- Skilled nursing facility
- Acute rehabilitation facility
- Long-term acute care hospital
- Hospice (home or facility)
- Left against medical advice (AMA)
- Transferred to another acute care facility

**Discharge Disposition:** [Selection from above]

**Services Arranged:**
- [ ] Home health nursing
- [ ] Physical therapy
- [ ] Occupational therapy
- [ ] Durable medical equipment: [List items]
- [ ] Home oxygen: [Flow rate and delivery method]
- [ ] Other: [Specify]

---

## Follow-Up Appointments

1. **[Specialty/PCP]** with Dr. [Name]
   - Date/Time: [Scheduled date and time] OR [Within X days/weeks]
   - Location: [Clinic name and address]
   - Phone: [Contact number]
   - Purpose: [What needs to be addressed]

2. **[Additional appointments]**

### Pending Studies/Labs at Discharge

- [Test name]: [When due, where to go, reason]
- Results will be sent to: [Provider name]

### Referrals Placed

- [Specialty]: [Reason for referral, contact information]

---

## Patient Instructions

### Activity

- [Specific activity restrictions or recommendations]
- Example: "Resume normal activities as tolerated. Avoid heavy lifting >10 lbs for 2 weeks."

### Diet

- [Dietary restrictions or recommendations]
- Example: "Low sodium diet (less than 2 grams per day). Fluid restriction to 2 liters per day."

### Wound Care (if applicable)

- [Incision care instructions]
- [Dressing change frequency]
- [When stitches/staples should be removed]

### Self-Monitoring

- [What patient should monitor at home]
- Example: "Weigh yourself every morning. Call doctor if weight gain >2 lbs in 1 day or >5 lbs in 1 week."

### Equipment/Supplies

- [Equipment provided or prescribed]
- [How to use]

### Medications

- [General medication instructions]
- [Importance of compliance]
- [What to do if dose missed]

---

## Return Precautions / Warning Signs

**Call your doctor or return to emergency department if you experience:**

- [Specific warning signs relevant to condition]
- [When to seek immediate care vs. call doctor]

Example for heart failure:
```
- Worsening shortness of breath or difficulty breathing
- Chest pain or pressure
- Severe swelling in legs or abdomen
- Weight gain more than 2 lbs in one day or 5 lbs in one week
- Dizziness, lightheadedness, or fainting
- Fever >101°F
- Any other concerning symptoms
```

**Emergency Contact Numbers:**
- Primary care physician: [Phone]
- Specialty clinic: [Phone]
- After-hours nurse line: [Phone]
- 911 for emergencies

---

## Patient Education Provided

Topics discussed with patient and/or family:
- [ ] Disease process and prognosis
- [ ] Medication purpose, dosing, and side effects
- [ ] Warning signs and when to seek care
- [ ] Activity and dietary restrictions
- [ ] Follow-up appointments
- [ ] Use of medical equipment
- [ ] [Other specific topics]

**Patient/Family Understanding:**
[Patient and family verbalize understanding of discharge instructions / Teach-back method used and patient able to repeat key points / Interpreter used]

**Written Materials Provided:**
- [ ] Discharge instructions
- [ ] Medication list
- [ ] Disease-specific education materials
- [ ] Emergency contact information
- [ ] Appointment information

---

## Code Status at Discharge

**Code Status:** [Full code / DNR / DNI / Other limitations]

[If changed during hospitalization, note when and why]

---

## Additional Information

### Advance Directives

- [ ] Advance directive on file
- [ ] Healthcare proxy designated: [Name and contact]
- [ ] Living will present

### Social Situation

[Relevant social factors affecting discharge plan]
- Living situation: [Lives alone / with family / assisted living]
- Caregiver support: [Available / Limited / None]
- Transportation: [Adequate / Needs assistance]
- Barriers to compliance: [Financial / Cognitive / Language / Other]

### Pending Issues at Discharge

[Tests or consultations still pending that require outpatient follow-up]

---

## Signature

**Prepared by:**  
[Physician name, credentials]  
[Pager/Contact number]

**Cosigned by (if resident/fellow):**  
[Attending physician name]

**Date and Time:** [MM/DD/YYYY at HH:MM]

**Electronically signed:** [Yes/No]

---

## Template Completion Checklist

- [ ] All discharge diagnoses listed with ICD-10 codes
- [ ] Hospital course summarized clearly
- [ ] All procedures documented
- [ ] Discharge medications reconciled and clearly marked (new/changed/continued/stopped)
- [ ] Follow-up appointments scheduled or timeframe provided
- [ ] Patient education documented
- [ ] Return precautions specific to patient's conditions
- [ ] Pending tests/results documented with follow-up plan
- [ ] Code status documented
- [ ] Completed within 24-48 hours of discharge (institutional requirement)
- [ ] Sent to primary care physician and relevant specialists
- [ ] Copy provided to patient

---

## Notes

**Timing Requirements:**
- CMS requires completion within 30 days
- Many hospitals require 24-48 hours
- Should be available for follow-up appointments

**Distribution:**
- Send to primary care physician
- Send to referring physician
- Send to consulting specialists involved in care
- Provide copy to patient
- Upload to shared HIE (Health Information Exchange)

**Quality Measures:**
- Medication reconciliation required
- Clear communication of changes
- Specific follow-up plans
- Patient education documented


