# Document Control Procedure Template

**Document Number:** SOP-4.2.4-001
**Title:** Control of Documents
**Revision:** 00
**Effective Date:** [DATE]
**Page:** 1 of [X]

---

## DOCUMENT CONTROL

### Approval Signatures

| Role | Name | Signature | Date |
|------|------|-----------|------|
| Author | [NAME] | | [DATE] |
| Reviewer | [NAME] | | [DATE] |
| Approver (Quality Manager) | [NAME] | | [DATE] |

### Revision History

| Revision | Date | Description of Changes | Approved By |
|----------|------|------------------------|-------------|
| 00 | [DATE] | Initial release | [NAME] |
|  |  |  |  |

---

## TABLE OF CONTENTS

1. [Purpose](#1-purpose)
2. [Scope](#2-scope)
3. [Definitions](#3-definitions)
4. [Responsibilities](#4-responsibilities)
5. [Procedure](#5-procedure)
   - 5.1 [Document Types and Hierarchy](#51-document-types-and-hierarchy)
   - 5.2 [Document Numbering System](#52-document-numbering-system)
   - 5.3 [Document Creation](#53-document-creation)
   - 5.4 [Document Review and Approval](#54-document-review-and-approval)
   - 5.5 [Document Distribution and Access](#55-document-distribution-and-access)
   - 5.6 [Document Changes](#56-document-changes)
   - 5.7 [Control of Obsolete Documents](#57-control-of-obsolete-documents)
   - 5.8 [Control of External Documents](#58-control-of-external-documents)
6. [Records](#6-records)
7. [References](#7-references)
8. [Attachments](#8-attachments)

---

## 1. PURPOSE

This procedure establishes requirements for the control of documents within the Quality Management System to ensure:

- Documents are approved before use
- Documents are reviewed, updated, and re-approved as necessary
- Changes and current revision status are identified
- Relevant versions of documents are available at points of use
- Documents remain legible and readily identifiable
- External documents are identified and controlled
- Obsolete documents are prevented from unintended use
- Obsolete documents are appropriately identified if retained

This procedure ensures compliance with ISO 13485:2016 Clause 4.2.4.

---

## 2. SCOPE

This procedure applies to all controlled documents within the Quality Management System, including but not limited to:

- Quality Manual
- Standard Operating Procedures (SOPs)
- Work Instructions (WIs)
- Forms and templates
- Medical Device Files
- Design and Development documents
- Risk management documents
- Validation and verification protocols and reports
- Specifications (product, process, test methods, materials)
- Drawings and schematics
- Labels and instructions for use
- External documents (standards, regulations, customer specifications)

This procedure does NOT apply to:
- Records (controlled per SOP-[NUMBER] Control of Records)
- Transient documents (emails, meeting notes not part of QMS)
- Marketing and sales materials (unless affecting product quality or regulatory compliance)

---

## 3. DEFINITIONS

| Term | Definition |
|------|------------|
| **Controlled Document** | A document that is subject to review, approval, distribution control, and change management per this procedure |
| **Master Document** | The official controlled copy maintained by Document Control, from which all distributed copies originate |
| **Document Owner** | The person or department responsible for the content, accuracy, and maintenance of a document |
| **Document Control Coordinator** | Person responsible for managing the document control system |
| **Revision** | A change to a controlled document that has been approved and issued |
| **Obsolete Document** | A document that has been superseded by a newer revision or is no longer applicable |
| **External Document** | A document originating from outside the organization (standards, regulations, customer specifications, etc.) |
| **SUPERSEDED** | Watermark applied to obsolete documents retained for reference |

---

## 4. RESPONSIBILITIES

### 4.1 Document Control Coordinator
- Manages document control system
- Assigns document numbers
- Maintains master document repository
- Ensures proper document approval before release
- Distributes controlled documents
- Maintains distribution lists
- Retrieves and destroys/archives obsolete documents
- Maintains document control records
- Trains personnel on document control procedures

### 4.2 Document Owners
- Create and maintain documents within their area
- Ensure document accuracy and completeness
- Initiate document changes when needed
- Participate in document review and approval
- Identify when documents become obsolete
- Ensure personnel in their area use current documents

### 4.3 Quality Manager
- Approves all QMS documents (SOPs, Quality Manual)
- Reviews document changes for QMS impact
- Ensures document control system effectiveness
- Audits document control compliance

### 4.4 Department Managers
- Approve department-specific work instructions
- Ensure current documents available in their areas
- Ensure personnel trained on document changes
- Remove obsolete documents from use areas

### 4.5 All Personnel
- Use only current, approved documents
- Report document issues (errors, illegibility, missing documents)
- Do not use obsolete or unapproved documents
- Maintain documents in good condition

---

## 5. PROCEDURE

### 5.1 Document Types and Hierarchy

QMS documents are organized in a four-tier hierarchy:

**Tier 1: Quality Manual (QM)**
- Policy-level document
- Describes overall QMS
- References all Tier 2 procedures
- Approved by CEO and Quality Manager

**Tier 2: Standard Operating Procedures (SOPs)**
- Define WHAT must be done, WHO does it, WHEN
- Cross-functional processes
- Include all 31 required documented procedures per ISO 13485
- Approved by Quality Manager

**Tier 3: Work Instructions (WIs)**
- Define HOW to perform specific tasks
- Step-by-step instructions
- Department or process-specific
- Approved by Department Manager and Quality Manager

**Tier 4: Forms and Templates**
- Standardized formats for data collection
- Support SOPs and WIs
- Approved by Document Owner and Quality Manager

**Other Controlled Documents:**
- Medical Device Files (MDFs)
- Design History Files (DHFs)
- Validation documents
- Specifications
- Drawings
- Labels and instructions for use

### 5.2 Document Numbering System

All controlled documents are assigned unique identification numbers:

**Quality Manual:**
- Format: QM-[###]
- Example: QM-001

**Standard Operating Procedures:**
- Format: SOP-[ISO Clause]-[###]
- Example: SOP-4.2.4-001 (for Clause 4.2.4 Control of Documents)
- Example: SOP-8.5-001 (for CAPA procedure)

**Work Instructions:**
- Format: WI-[Department Code]-[###]
- Example: WI-MFG-001 (Manufacturing department work instruction)
- Department codes: MFG (Manufacturing), QC (Quality Control), ENG (Engineering), etc.

**Forms:**
- Format: FORM-[SOP/WI Number]-[Letter]
- Example: FORM-SOP-8.5-001-A (CAPA Request Form)

**Medical Device Files:**
- Format: MDF-[Product Code]-[###]
- Example: MDF-ABC-001

**Other Documents:**
- Format varies by document type
- Assigned by Document Control Coordinator

**Revision Designation:**
- Initial release: Revision 00
- First revision: Revision 01
- Subsequent revisions: 02, 03, 04, etc.
- Format: [Document Number] Rev [##]

### 5.3 Document Creation

**5.3.1 Initiating Document Creation**

1. Document Owner identifies need for new document
2. Document Owner notifies Document Control Coordinator
3. Document Control Coordinator:
   - Assigns document number
   - Provides document template (if applicable)
   - Logs document in master list as "In Development"

**5.3.2 Document Format Requirements**

All controlled documents must include:

**Header (on each page):**
- Document number
- Document title
- Revision number
- Effective date
- Page number (Page X of Y)

**Document Control Section:**
- Approval signature table
- Revision history table

**Content Requirements:**
- Clear, concise language
- Present tense, active voice
- Consistent terminology
- Numbered sections and subsections
- References to related documents
- Records generated (if applicable)

**5.3.3 Document Drafting**

1. Document Owner drafts document content
2. Document Owner marks document as "DRAFT" on each page
3. Draft may be circulated for informal review and input
4. When ready for formal review, Document Owner submits to Document Control Coordinator

### 5.4 Document Review and Approval

**5.4.1 Review Process**

1. Document Control Coordinator:
   - Verifies document number correct
   - Verifies format compliance
   - Checks for required sections
   - Routes for review

2. Reviews conducted by:
   - Technical reviewer (subject matter expert)
   - Quality reviewer (for QMS compliance)
   - Other stakeholders as appropriate

3. Reviewers:
   - Review for technical accuracy
   - Review for clarity and completeness
   - Review for compliance with requirements
   - Provide comments to Document Owner

4. Document Owner:
   - Addresses all comments
   - Revises document as needed
   - Resubmits for approval

**5.4.2 Approval Process**

Approval authority based on document type:

| Document Type | Approval Authority |
|---------------|-------------------|
| Quality Manual | CEO and Quality Manager |
| Standard Operating Procedures | Quality Manager |
| Work Instructions | Department Manager and Quality Manager |
| Forms | Document Owner and Quality Manager |
| Specifications | Engineering Manager and Quality Manager |
| Medical Device Files | [Per regulatory requirements] |

**Approval Steps:**

1. Document Control Coordinator routes document to approvers
2. Approvers review and sign/date approval section
3. All required approvals must be obtained before document becomes effective
4. Document Control Coordinator:
   - Removes "DRAFT" watermark
   - Adds effective date (typically [X] days after approval)
   - Assigns final format
   - Adds to controlled document system
   - Updates master document list

**5.4.3 Training Requirements**

Before document becomes effective:
- Affected personnel identified
- Training conducted as needed
- Training records maintained per SOP-[NUMBER]

### 5.5 Document Distribution and Access

**5.5.1 Master Document**

- Document Control Coordinator maintains master copy
- Master stored in: [ELECTRONIC SYSTEM or PHYSICAL LOCATION]
- Master clearly identified as "MASTER COPY"
- Master is reference for all distributed copies

**5.5.2 Controlled Copies**

**Electronic Distribution (Primary Method):**
- Documents stored in [DOCUMENT MANAGEMENT SYSTEM]
- Access controlled by user permissions
- Read-only access for most users
- Always displays current revision
- Obsolete revisions automatically removed from access
- Users may print for immediate use (uncontrolled copies)

**Physical Distribution (When Necessary):**
- Controlled copies issued for specific locations/uses
- Each copy stamped "CONTROLLED COPY - [Copy Number]"
- Distribution list maintained showing:
  - Copy number
  - Document number and revision
  - Holder name and location
  - Date issued
- Holders responsible for maintaining copy in good condition
- When document revised, Document Control retrieves old copy and issues new copy

**5.5.3 Uncontrolled Copies**

- Printed for temporary, immediate use
- Stamped or marked "UNCONTROLLED COPY"
- User responsible for verifying current revision before each use
- Should be destroyed after use or within [X] days

**5.5.4 Availability at Point of Use**

- Current documents available where work is performed
- Electronic access at workstations
- Controlled physical copies in areas without electronic access
- Documents protected from damage, loss, deterioration

### 5.6 Document Changes

**5.6.1 Initiating Changes**

Changes may be initiated by:
- Document Owner identifying need
- CAPA requiring procedure change
- Internal audit finding
- Management review action
- Regulatory or standard update
- Process improvement

**5.6.2 Change Request Process**

1. Requestor:
   - Completes Document Change Request Form (Attachment A)
   - Describes change needed and justification
   - Submits to Document Owner

2. Document Owner:
   - Reviews change request
   - Determines if change appropriate
   - Approves or denies request
   - If approved, initiates document revision

**5.6.3 Making Changes**

1. Document Owner:
   - Requests current master from Document Control
   - Creates revised version with changes
   - Increments revision number
   - Updates revision history table
   - Identifies changes in document (change bars, highlights, or summary)
   - Marks as "DRAFT REVISION"

2. Changes reviewed and approved by:
   - Same approval authority as original document
   - UNLESS different approval authority designated by original approver
   - Reviewers have access to previous revision for comparison

3. Approval:
   - New revision approved per Section 5.4.2
   - Previous revision becomes obsolete on effective date of new revision

**5.6.4 Indication of Changes**

Changes are indicated by:
- Revision history table (describes nature of changes)
- Change bars or highlights in document (optional but recommended)
- Change summary page for significant revisions (optional)

**5.6.5 Urgent Changes**

For urgent changes affecting safety or regulatory compliance:
- Expedited review and approval process
- May use interim method (e.g., hand-written changes with approval)
- Formal document revision completed as soon as practical
- Document per CAPA process if change due to nonconformity

### 5.7 Control of Obsolete Documents

**5.7.1 When Document Becomes Obsolete**

Document becomes obsolete when:
- New revision approved and becomes effective
- Document no longer applicable to operations
- Product discontinued
- Process changed

**5.7.2 Removal from Use**

1. Document Control Coordinator:
   - On effective date of new revision, marks superseded revision as obsolete
   - Removes from electronic document system OR limits access with "OBSOLETE" notation
   - Retrieves physical controlled copies from distribution locations
   - Updates distribution lists

2. Department Managers:
   - Remove obsolete copies from work areas
   - Return to Document Control or destroy
   - Ensure personnel aware of new revision

**5.7.3 Retention of Obsolete Documents**

Obsolete documents may be retained for:
- Reference purposes
- Product investigations
- Regulatory or legal requirements
- Historical record

**If retained:**
- Clearly marked "OBSOLETE - FOR REFERENCE ONLY" or "SUPERSEDED"
- Stored separately from current documents
- Access restricted and controlled
- Retained per applicable retention requirements

**Retention Locations:**
- Electronic archive with "OBSOLETE" watermark
- Separate physical archive area

**5.7.4 Prevention of Unintended Use**

To prevent unintended use:
- Physical copies stamped "OBSOLETE" in red
- Electronic copies watermarked "OBSOLETE"
- Removed from active work areas
- Stored in separate archive
- Training on document control system and how to verify current revision

### 5.8 Control of External Documents

**5.8.1 Types of External Documents**

External documents include:
- ISO standards
- IEC standards
- FDA regulations and guidance documents
- EU regulations (MDR, IVDR)
- Other regulatory requirements
- Customer specifications
- Supplier certifications
- Calibration certificates
- Reference materials

**5.8.2 Identification and Control**

1. Document Owner or requestor:
   - Identifies external document needed
   - Provides copy to Document Control Coordinator

2. Document Control Coordinator:
   - Assigns external document number: EXT-[Category]-[###]
   - Logs in external document register including:
     - Document title and number
     - Source/publisher
     - Date/version
     - Location in organization
     - Responsible person for monitoring updates
   - Files in external document repository

**5.8.3 Reviewing for Currency**

- Document Owner responsible for monitoring updates to external documents
- Frequency: [Annually or as notified of updates]
- Check publisher website for updates
- Subscribe to update notifications when available
- When update identified:
  - Obtain new version
  - Provide to Document Control
  - Review for impact on QMS documents
  - Update QMS documents as needed (per CAPA if necessary)
  - Obsolete previous version per Section 5.7

**5.8.4 Customer-Supplied Documents**

- Customer specifications and drawings controlled as external documents
- Review for clarity and completeness upon receipt
- Discrepancies communicated to customer for resolution
- Controlled per this procedure to ensure current version used

---

## 6. RECORDS

Records generated and maintained per this procedure:

| Record | Retention Period | Location | Responsible Party |
|--------|------------------|----------|-------------------|
| Master Document List | Current + [X] years | [LOCATION/SYSTEM] | Document Control Coordinator |
| Document Approval Records | [X years or device lifetime] | Document Control System | Document Control Coordinator |
| Document Revision History | [X years or device lifetime] | Document Control System | Document Control Coordinator |
| Document Change Requests | [X years] | [LOCATION] | Document Control Coordinator |
| Distribution Lists | Current + [X] years | [LOCATION] | Document Control Coordinator |
| Obsolete Document Archive | [Per retention schedule] | [LOCATION] | Document Control Coordinator |
| External Document Register | Current + [X] years | [LOCATION] | Document Control Coordinator |

---

## 7. REFERENCES

- ISO 13485:2016, Clause 4.2.4 - Control of Documents
- Quality Manual, Section 4.2.4
- SOP-4.2.5 - Control of Records
- SOP-6.2 - Training and Competence

---

## 8. ATTACHMENTS

**Attachment A:** Document Change Request Form
**Attachment B:** Document Templates (QM, SOP, WI, Form)
**Attachment C:** Document Control Flowchart
**Attachment D:** Master Document List Template
**Attachment E:** Distribution List Template

---

**END OF PROCEDURE**

---

**Document Number:** SOP-4.2.4-001
**Revision:** 00
**Page:** [X] of [X]
