# Broader Impacts: Strategies and Best Practices

## Overview

**Broader Impacts** are one of two review criteria for NSF proposals, carrying equal weight with Intellectual Merit. Despite this, broader impacts are often treated as an afterthought—a critical mistake that costs otherwise strong proposals their funding.

**NSF Definition**: "The potential to benefit society and contribute to the achievement of specific, desired societal outcomes"

**Key Principle**: Broader impacts must be **specific, measurable, and integrated** with your research plan—not vague aspirations tacked onto the end.

## The Five Pillars of Broader Impacts

NSF evaluates broader impacts across five main areas. **You don't need to address all five**, but you should address at least one substantively with concrete activities, timelines, and assessment plans.

### 1. Advance Discovery While Promoting Teaching, Training, and Learning

**What This Means**: Integrate research and education to inspire the next generation of scientists and enhance scientific literacy.

**Effective Strategies**:

**Curriculum Development**:
- Create new courses incorporating research findings
- Develop course modules or laboratory exercises
- Design online learning materials (MOOCs, videos, interactive tools)
- Contribute to textbooks or educational resources

*Example*: "We will develop a 10-week computational biology module for undergraduate education, incorporating real datasets from this project. The module will include Jupyter notebooks with guided analysis, video tutorials, and assessment tools. Materials will be piloted at our institution (reaching 50 students annually) and made freely available through CourseSource for national adoption."

**Student Training**:
- Undergraduate research experiences
- Graduate student mentoring
- Postdoctoral training
- High school intern programs
- Research experiences for teachers (RET)

*Example*: "The project will support 3 PhD students and 6 undergraduate researchers over 5 years. Undergraduates will participate through our existing summer research program (10 weeks, $5,000 stipends) and will present findings at the annual undergraduate research symposium and regional conferences."

**Pedagogical Innovation**:
- Problem-based learning modules
- Active learning strategies
- Research-intensive courses
- Service learning projects
- Maker spaces or hands-on workshops

*Example*: "We will transform our introductory physics course (250 students/year) by implementing studio-style physics instruction based on results from this research. The new curriculum will include 3D visualization tools for electromagnetic fields, inquiry-based problem sets, and peer instruction protocols."

**Professional Development**:
- Workshops for faculty or teachers
- Training programs for early-career researchers
- Mentoring programs
- Career development resources

*Example*: "We will host annual 3-day workshops for 25 community college faculty, providing training in genome editing techniques. Participants will receive hands-on experience with CRISPR methods developed in this project, complete teaching modules for their courses, and ongoing support through a virtual learning community."

### 2. Broaden Participation of Underrepresented Groups

**What This Means**: Increase participation of groups underrepresented in STEM, including women, racial/ethnic minorities, persons with disabilities, and those from economically disadvantaged backgrounds.

**Effective Strategies**:

**Partnerships with Minority-Serving Institutions**:
- Collaborate with HBCUs (Historically Black Colleges and Universities)
- Partner with HSIs (Hispanic-Serving Institutions)
- Work with TCUs (Tribal Colleges and Universities)
- Engage with community colleges

*Example*: "We will establish formal research partnerships with 4 regional HBCUs (North Carolina A&T, Howard University, Morehouse College, and Spelman College). Each summer, 2 students from partner institutions will participate in 10-week research internships, including stipends ($6,000), housing, travel to field sites, and participation in our weekly research seminar series. A faculty liaison from each partner institution will co-mentor students and facilitate year-round engagement."

**Recruitment and Retention**:
- Targeted recruitment at conferences (SACNAS, ABRCMS, NSBE, SWE)
- Scholarship programs for underrepresented students
- Bridge programs for community college transfers
- Retention support (mentoring, peer networks, professional development)

*Example*: "We will recruit 50% of summer undergraduate researchers from groups underrepresented in computer science through partnerships with SACNAS and the National Society of Black Engineers. Participants will receive mentoring from graduate students with similar backgrounds, attend professional development workshops, and join our diversity-in-computing learning community that provides year-round support and networking."

**Culturally Relevant Engagement**:
- Research addressing community-identified needs
- Community-based participatory research
- Engagement with indigenous communities
- Bilingual materials and outreach

*Example*: "In partnership with the Navajo Nation, we will conduct participatory research on water quality in reservation communities. Community members will co-design the research questions, participate in data collection, and contribute indigenous knowledge about local hydrology. Results will be shared through community presentations in both English and Navajo, and will inform tribal water management policies."

**Addressing Systemic Barriers**:
- Flexible schedules for non-traditional students
- Childcare support for participants
- Accessible facilities and materials
- Financial support (stipends, travel, equipment)
- Mentoring networks and affinity groups

*Example*: "To support participation of students from low-income backgrounds, we will provide laptop computers, software licenses, and internet hotspots to all research participants. We will also offer flexible work schedules, remote participation options, and supplemental funding for students with childcare or eldercare responsibilities."

### 3. Enhance Infrastructure for Research and Education

**What This Means**: Build facilities, tools, databases, or networks that enable future research and education across the broader community.

**Effective Strategies**:

**Shared Research Infrastructure**:
- Multi-user instrumentation
- Core facilities
- Field stations or observatories
- Computational resources
- Cyberinfrastructure

*Example*: "We will establish a regional Cryo-Electron Microscopy facility serving 15 institutions in the Southwest. The facility will provide training and access to state-of-the-art imaging capabilities currently unavailable in the region. We will operate a user program with subsidized rates for academic users and offer annual training workshops for 50 researchers."

**Data and Software Resources**:
- Open-access databases
- Software tools and platforms
- Analysis pipelines
- Standardized protocols
- Data repositories

*Example*: "We will develop and maintain EcoDataHub, an open-source platform for ecological time-series analysis. The platform will include automated data cleaning, standardized analysis workflows, interactive visualization tools, and cloud computing integration. Software will be documented, version-controlled on GitHub, and supported through user forums and quarterly webinars. We expect 1,000+ users within 3 years based on community surveys."

**Biological or Physical Resources**:
- Living stock centers (model organisms, cell lines)
- Specimen collections
- Reagent repositories
- Seed banks or tissue collections

*Example*: "We will establish a publicly accessible repository of 500 sequenced bacterial strains isolated from extreme environments. Each strain will include full genome sequence, phenotypic characterization, and growth protocols. Materials will be available through the ATCC with metadata deposited in NCBI BioProject."

**Standards and Protocols**:
- Community standards
- Best practices guides
- Benchmarking datasets
- Quality control metrics
- Interoperability frameworks

*Example*: "Working with 20 international laboratories, we will develop and validate standardized protocols for single-cell RNA sequencing analysis. The resulting guidelines will address batch effects, quality control, normalization methods, and statistical best practices. Protocols will be published in peer-reviewed literature and deposited in protocols.io."

### 4. Broadly Disseminate to Enhance Scientific and Technological Understanding

**What This Means**: Communicate research to broader audiences including the public, K-12 students, policymakers, and stakeholders to enhance scientific literacy and informed decision-making.

**Effective Strategies**:

**K-12 Education Outreach**:
- School visits and science demonstrations
- After-school programs
- Science fairs and competitions
- Teacher professional development
- Classroom resources and lesson plans

*Example*: "We will partner with 10 local middle schools (serving 75% students from low-income families) to deliver hands-on robotics workshops. Each school will receive robot kits, and we will train teachers to lead a 12-week after-school robotics club. Students will apply concepts from this research (sensor fusion, autonomous navigation) to design robots for real-world challenges. The program will reach 200 students annually."

**Public Engagement**:
- Museum partnerships and exhibits
- Science cafés and public lectures
- Science festivals
- Citizen science projects
- Community workshops

*Example*: "We will collaborate with the Museum of Science and Industry to create a permanent interactive exhibit on climate modeling. The exhibit will allow visitors to manipulate climate variables and observe predicted outcomes using simplified versions of our models. We anticipate 500,000 annual visitors. We will also host quarterly 'Climate Science Saturday' public lectures reaching 2,000 community members annually."

**Media and Communications**:
- Blog posts and articles
- Podcasts or videos
- Social media engagement
- Press releases for major findings
- Popular science writing

*Example*: "We will produce a 6-episode podcast series exploring the intersection of artificial intelligence and creativity, featuring interviews with artists, musicians, and computer scientists. Episodes will be freely available on major platforms, with transcripts and educational materials on our website. Based on our existing podcast (15,000 downloads/episode), we expect to reach 100,000+ listeners."

**Policy Engagement**:
- Science policy fellowships
- Congressional briefings
- White papers for decision-makers
- Stakeholder workshops
- Regulatory science contributions

*Example*: "We will organize annual workshops bringing together researchers, water utilities, environmental regulators, and community advocates to discuss implications of our research for drinking water policy. Findings will be synthesized into policy briefs distributed to state and federal agencies. PI will participate in the AAAS Science and Technology Policy Fellowship to engage directly with EPA rulemaking."

**Citizen Science**:
- Community-based data collection
- Participatory research design
- Volunteer monitoring programs
- Crowdsourcing platforms

*Example*: "We will launch a citizen science program enlisting 500 volunteers across the Midwest to monitor pollinator populations using our smartphone app. Participants will receive training materials, identification guides, and regular feedback on their observations. Data will contribute directly to our research while building public understanding of pollinator ecology. Results will be visualized on an interactive public dashboard."

### 5. Benefit Society

**What This Means**: Apply research to address societal needs, improve quality of life, strengthen national security, or enhance economic competitiveness.

**Effective Strategies**:

**Health and Well-Being**:
- Clinical applications
- Public health improvements
- Healthcare accessibility
- Mental health resources
- Environmental health

*Example*: "Our diagnostic tool will reduce costs of malaria diagnosis from $10 to $0.50 per test, enabling deployment in resource-limited settings. We will partner with PATH and Médecins Sans Frontières to conduct field trials in 3 African countries and develop manufacturing partnerships for at-scale production. We project this technology could reach 10 million patients annually within 5 years."

**Economic Development**:
- Technology commercialization
- Job creation
- Industry partnerships
- Workforce development
- Startup formation

*Example*: "We will establish an industry partnership program with 5 regional manufacturing companies to transfer our advanced materials synthesis methods. Through quarterly technical workshops and on-site consultations, we will help companies integrate these processes into production lines, potentially creating 50-100 high-skill jobs over 5 years. Two graduate students will complete internships at partner companies."

**Environmental Sustainability**:
- Climate change mitigation or adaptation
- Conservation and biodiversity
- Pollution reduction
- Sustainable agriculture
- Renewable energy

*Example*: "Our soil carbon sequestration practices will be implemented on 1,000 acres of working farmland in partnership with 15 Iowa farmers. We will provide training, monitoring support, and carbon credit market access. If successful, practices could sequester 100,000 tons of CO2 equivalent annually if adopted across 10% of Midwest cropland, while increasing farmer income by $50-100/acre through carbon credits."

**National and Homeland Security**:
- Defense applications
- Cybersecurity
- Critical infrastructure protection
- Emergency response
- Intelligence capabilities

*Example*: "We will work with the Department of Homeland Security to adapt our threat detection algorithms for transportation security screening. Technology will be piloted at 3 major airports, with the goal of reducing false-positive rates by 40% while maintaining security effectiveness, decreasing passenger wait times and improving screening efficiency."

**Social and Cultural Benefits**:
- Preservation of cultural heritage
- Accessibility and inclusion
- Social justice
- Arts and humanities
- Quality of life improvements

*Example*: "Our 3D scanning and virtual reality platform will be used to digitally preserve 20 culturally significant sites threatened by climate change and development. Virtual reconstructions will be made freely available to descendant communities, schools, and the public through a web-based interface and VR experiences. We will partner with indigenous groups to ensure culturally appropriate representation."

## Best Practices for Broader Impacts

### Be Specific and Concrete

**Vague** ❌:
"This research will train the next generation of scientists."

**Specific** ✅:
"This project will support 3 PhD students, 2 postdocs, and 12 undergraduate researchers over 5 years. Undergraduates will be recruited through our partnership with the Louis Stokes Alliance for Minority Participation, with a goal of 50% participation from underrepresented groups. Students will receive training in advanced microscopy, data analysis, and scientific communication, and will present their research at the annual Emerging Researchers National Conference."

### Include Timelines and Milestones

**Vague** ❌:
"We will develop educational materials."

**Specific** ✅:
"Year 1: Develop draft curriculum modules and pilot with 50 students
Year 2: Revise based on assessment data and expand to 150 students across 3 institutions
Years 3-5: National dissemination through CourseSource, workshops at 2 professional conferences, and online repository. Target: Adoption by 20 institutions reaching 1,000 students annually by Year 5."

### Measure and Assess Impact

**Include**:
- Quantitative metrics (number of participants, downloads, users)
- Qualitative assessment (surveys, interviews, focus groups)
- Learning outcomes or behavioral changes
- Longitudinal tracking
- Comparison to baseline or control groups

**Example**:
"We will assess program effectiveness through: (1) Pre/post surveys measuring science self-efficacy using validated instruments, (2) Tracking participant persistence in STEM majors through institutional records, (3) Focus groups with participants and teachers, (4) Analysis of student work products. We expect to see a 30% increase in science self-efficacy scores and 90% retention in STEM majors among participants compared to 65% institutional baseline."

### Leverage Existing Infrastructure

**Don't reinvent the wheel**—build on existing programs and partnerships:
- Institutional programs (REU sites, AGEP, LSAMP, etc.)
- Community partnerships already established
- Shared facilities or resources
- Professional societies and organizations

**Example**:
"We will integrate with our institution's existing NSF REU site in Materials Science, adding 2 additional positions focused on our research area. This leverages established recruitment pipelines with 15 partner institutions, professional development programming, and assessment infrastructure while expanding opportunities for undergraduate researchers."

### Demonstrate Institutional Commitment

**Show that broader impacts will continue beyond grant period**:
- Institutional cost-sharing or support
- Integration into ongoing programs
- Sustainability plan
- Letters of commitment from partners

**Example**:
"The university has committed $50,000 annually in cost-share to sustain the high school outreach program beyond the grant period. The program will be integrated into our Center for STEM Education, ensuring administrative support, space, and continuity. Our partner school districts have committed teacher time and classroom access (see letters of commitment in supplementary documents)."

### Align with Research Plan

**Integration examples**:
- Students work on research questions from the proposal
- Educational materials use data generated by the research
- Outreach communicates research findings
- Community needs inform research questions

**Poor Integration** ❌:
Research on quantum computing + Unrelated marine biology outreach for middle schoolers

**Good Integration** ✅:
Research on quantum computing + Develop quantum computing curriculum modules + Summer program where students program quantum simulators + Public lectures on quantum technologies

## Common Broader Impacts Mistakes

### Mistake 1: Generic and Vague Statements

❌ "This project will train graduate students and postdocs."
❌ "Results will be broadly disseminated through publications and conferences."
❌ "We will engage in outreach activities."

These are baseline expectations, not broader impacts.

### Mistake 2: No Plan or Timeline

❌ "We hope to develop educational materials that could be used nationally."

✅ "Year 1: Develop and pilot 5 teaching modules. Year 2: Assess effectiveness and refine. Year 3: Publish in Journal of Chemical Education. Years 4-5: Disseminate through workshops at 3 national conferences and online repository. Target: Adoption by 30 institutions by Year 5."

### Mistake 3: No Assessment

❌ "We will run a summer camp for underrepresented students."

✅ "We will run a 4-week summer camp for 30 students (60% from underrepresented groups). We will assess impact through pre/post content knowledge tests, science identity surveys, and tracking of STEM course enrollment. We expect 80% of participants to enroll in advanced science courses the following year."

### Mistake 4: Unrealistic Scope

❌ "We will establish a national network of 100 schools, develop a comprehensive K-12 curriculum, create a museum exhibit, launch a nationwide citizen science program, and commercialize our technology" (with no budget or personnel allocated).

Be realistic about what you can accomplish with the resources and time available.

### Mistake 5: Poor Integration

❌ Research on plant genomics + Unrelated robotics outreach

✅ Research on plant genomics + Develop plant biology curriculum + Engage community gardens in phenotyping citizen science

### Mistake 6: Treating as Afterthought

❌ Half-page generic statement at end of proposal with no budget allocation

✅ Integrated throughout proposal, dedicated personnel (0.5 month PI time, 10% grad student, summer coordinator), allocated budget ($15K/year), detailed plan, and assessment strategy

### Mistake 7: No Track Record

If proposing extensive broader impacts activities but have no history of such work, reviewers will be skeptical.

✅ Show preliminary efforts, leverage existing programs, include collaborators with relevant expertise, cite successful prior broader impacts work

## Budgeting for Broader Impacts

**NSF expects resources allocated to broader impacts activities.**

**Typical Budget Items**:
- **Personnel**: Program coordinator, graduate students, undergraduate assistants
- **Participant support**: Stipends, travel, housing for students/teachers
- **Materials and supplies**: Educational materials, outreach equipment, workshop supplies
- **Travel**: Conference presentations of broader impacts work, site visits to partners
- **Subawards**: Payments to partnering institutions or organizations
- **Evaluation**: External evaluator for assessment

**Example Budget**:
- Summer program coordinator (2 months/year): $15,000/year
- Undergraduate stipends (10 students × $5,000): $50,000/year
- Materials and supplies for workshops: $5,000/year
- Travel for recruitment and partner meetings: $3,000/year
- External evaluator: $8,000/year
- **Total: $81,000/year (16% of $500K budget)**

## Resources for Broader Impacts

### NSF Resources
- **NSF Broader Impacts Website**: https://www.nsf.gov/od/oia/special/broaderimpacts/
- **BI Examples Repository**: https://www.cmu.edu/uro/resources for undergraduate research/best practices/broader-impacts.html
- **Broader Impacts Toolkit**: Many universities provide institutional resources

### Assessment Tools
- **STEM-OP (STEM Outreach Program)**: Survey instruments for outreach assessment
- **STELAR Network**: Resources for informal STEM education
- **Evaluation frameworks**: Logic models, theory of change

### Partner Organizations
- **SACNAS**: Society for Advancement of Chicanos/Hispanics and Native Americans in Science
- **ABRCMS**: Annual Biomedical Research Conference for Minority Students
- **NSBE, SWE, AISES**: Professional societies for underrepresented groups
- **Science museums and centers**: Partner for public engagement
- **School districts and community organizations**: For K-12 outreach

---

**Key Takeaway**: Effective broader impacts are specific, measurable, assessed, integrated with the research plan, and demonstrate institutional commitment. They should be planned with the same rigor as the research itself, with dedicated resources, timelines, milestones, and evaluation strategies. Generic statements about "training students" or "disseminating results" are insufficient—NSF expects concrete plans that demonstrably benefit society.

