# Specialty-Specific Treatment Plan Guidelines

## Overview

This reference provides detailed guidelines for developing treatment plans specific to each of the six template types: general medical, rehabilitation, mental health, chronic disease management, perioperative, and pain management. Each section includes specialty-specific considerations, clinical pearls, and best practices.

## Concise Documentation Examples by Specialty

### Foundation Medicine Model: Concise vs. Verbose

**PRINCIPLE**: Focus on actionable information; eliminate redundancy; use bullet points and short paragraphs.

### General Medical - Diabetes Example

**VERBOSE (Avoid)**:
> "Patient education was provided on the pathophysiology of Type 2 Diabetes Mellitus, including detailed explanation of insulin resistance, pancreatic beta-cell dysfunction, and the progressive nature of the disease. The patient was educated about the various potential complications of diabetes including microvascular complications such as diabetic retinopathy which can lead to blindness, diabetic nephropathy which can progress to end-stage renal disease requiring dialysis, and diabetic neuropathy which can cause pain and sensory loss. Additionally, macrovascular complications were discussed including increased risk of myocardial infarction, stroke, and peripheral arterial disease."

**CONCISE (Preferred - 75% shorter)**:
> "Key Education: Disease understanding, micro/macrovascular complication risks, self-monitoring techniques (glucose, BP), medication timing, diet basics, exercise safety, sick day management. Critical warnings: Hypoglycemia (shakiness, confusion - treat with 15g carbs), severe hyperglycemia >300 (call office), chest pain/stroke symptoms (911)."

### Mental Health - Depression Example

**VERBOSE (Avoid)**:
> "The patient will participate in individual psychotherapy sessions utilizing Cognitive Behavioral Therapy techniques. Sessions will be scheduled on a weekly basis for a duration of 50 minutes each. The therapist will work with the patient to identify negative thought patterns, challenge cognitive distortions, develop behavioral activation strategies, and build coping skills for managing depressive symptoms."

**CONCISE (Preferred - 60% shorter)**:
> "CBT weekly × 16 sessions (50 min) focusing on: identifying/challenging negative thoughts, behavioral activation, coping skills development. Goals: PHQ-9 <10, return to work, 3 effective stress management strategies."

### Rehabilitation - Post-Stroke Example

**VERBOSE (Avoid)**:
> "Expected outcomes include improvement in upper extremity function with anticipated achievement of the ability to perform self-care activities including bathing, dressing, and grooming with minimal assistance or independently. The patient is expected to demonstrate improved ambulation capabilities with progression from wheelchair mobility to ambulation with a rolling walker under supervision, with eventual goal of independent ambulation with a straight cane for distances up to 300 feet."

**CONCISE (Preferred - 70% shorter)**:
> "Expected outcomes (8 weeks): Independent ADLs with adaptive equipment, ambulation 300+ feet with walker/supervision, stair negotiation with handrail, safe home discharge. Timeline: Week 2 - transfers with supervision; Week 4 - ambulate 150 feet; Week 8 - community ambulation, discharge ready."

### Perioperative - Laparoscopic Surgery Example

**VERBOSE (Avoid)**:
> "Postoperative pain management will utilize a multimodal approach to analgesia in order to minimize opioid consumption and reduce the risk of opioid-related adverse effects including nausea, vomiting, constipation, and respiratory depression. The multimodal regimen will include scheduled acetaminophen administered at a dose of 1000 milligrams every 6 hours, ibuprofen 600 milligrams every 6 hours as needed, and opioid analgesics reserved for breakthrough pain only."

**CONCISE (Preferred - 65% shorter)**:
> "Multimodal analgesia: Acetaminophen 1000mg Q6H scheduled, ibuprofen 600mg Q6H PRN, opioids for breakthrough only. Goal: Pain <4/10, minimize opioid use, early mobilization."

### Key Principles for Concise Documentation

1. **Use abbreviations appropriately**: Q6H, PRN, ADLs, BP (define on first use if uncommon)
2. **Bullet points over paragraphs**: Easier to scan, more actionable
3. **Combine related information**: Group similar items together
4. **Eliminate filler words**: "The patient will...", "It is anticipated that..."
5. **Focus on "what, when, why"**: Action, timing, rationale in minimal words
6. **Use tables for complex data**: Medication lists, monitoring schedules
7. **Prioritize critical information**: Safety warnings, emergency actions

## 1. General Medical Treatment Plans

### Applicable Conditions
- Chronic diseases: Diabetes, hypertension, heart failure, COPD, asthma
- Common acute conditions requiring structured follow-up
- Primary care management of stable chronic conditions

### Key Assessment Components

**Baseline Status**:
- Vital signs, BMI, functional status
- Disease-specific metrics (HbA1c, BP, lipids, PFTs)
- Comorbidity assessment
- Medication reconciliation
- Social determinants of health screening

**Disease Severity Staging**:
- Use validated staging systems when available
- Examples: CKD stages 1-5, GOLD COPD stages I-IV, NYHA heart failure classes I-IV, ADA diabetes complications
- Document severity to guide treatment intensity

### Treatment Goal Specifics

**Guideline-Based Targets**:
- HbA1c <7% for most diabetics (<8% if elderly, limited life expectancy)
- BP <130/80 for most; <140/90 if elderly or low cardiovascular risk
- LDL <70 mg/dL if ASCVD, <100 mg/dL moderate risk
- Use individualized targets based on patient factors

**Functional Goals**:
- Maintain independence in ADLs
- Return to work if applicable
- Engage in valued activities
- Quality of life improvement

### Pharmacotherapy Considerations

**Polypharmacy Management**:
- Consider deprescribing when possible (Beers Criteria for elderly)
- Medication reconciliation at each visit
- Simplify regimens (once-daily dosing, combination pills)
- Address adherence barriers (cost, side effects, complexity)

**Drug-Disease Interactions**:
- Avoid NSAIDs if CKD, heart failure
- Caution with metformin if eGFR <30
- Beta-blockers contraindicated in severe COPD/asthma (use cardioselective if needed)

### Monitoring Schedules by Condition

**Diabetes**:
- HbA1c every 3 months if not at goal, every 6 months if stable
- Annual: dilated eye exam, foot exam, urine ACR, lipids
- Each visit: BP, weight, medication adherence

**Hypertension**:
- Home BP monitoring (HBPM) - most accurate, average of multiple readings
- Office BP at each visit
- Labs (BMP for K+, creatinine) 1-2 weeks after ACE/ARB initiation, then annually

**Heart Failure**:
- Daily weights (report gain >2-3 lbs in 2 days)
- BNP/NT-proBNP when clinically changing
- Echo annually or if EF change suspected
- Medication titration every 2 weeks during optimization phase

### Primary Care Integration

**Preventive Care**:
- Include age-appropriate cancer screenings
- Vaccination schedule (flu, pneumococcal, zoster, COVID)
- Lifestyle counseling (tobacco, alcohol, diet, exercise)

**Chronic Disease Management Models**:
- Chronic Care Model components: Self-management support, delivery system redesign, clinical information systems, decision support
- Team-based care: Involvement of nurses, pharmacists, dietitians, care coordinators

---

## 2. Rehabilitation Treatment Plans

### Applicable Settings
- Post-acute inpatient rehabilitation
- Outpatient PT/OT/SLP
- Home health therapy
- Skilled nursing facility rehabilitation

### Key Assessment Components

**Functional Assessments (use validated tools)**:
- **FIM** (Functional Independence Measure): 18 items, 7-point scale, 126 total - most widely used
- **Barthel Index**: 10 ADLs, 100-point scale - simpler than FIM
- **Berg Balance Scale**: 14 tasks, 56 points - fall risk (score <45 = high risk)
- **6-Minute Walk Test**: Distance walked in 6 minutes - cardiopulmonary endurance
- **Timed Up and Go (TUG)**: Time to stand, walk 3 meters, turn, return, sit - fall risk (>12 sec = high risk)
- **9-Hole Peg Test**: Upper extremity fine motor speed
- **ROM**: Goniometric measurement for each joint
- **Manual Muscle Testing**: 0-5 scale (0=no contraction, 5=normal strength)

**ICF Framework Goals**:
- **Body Functions/Structures**: Impairments (ROM, strength, balance)
- **Activity**: Task performance (walk 150 feet, dress independently)
- **Participation**: Life roles (return to work, community engagement)

### Rehabilitation Goals Specifics

**Goal Levels**:
1. **Impairment Goals**: Increase knee ROM 90→110°, improve MMT 3/5→4/5
2. **Activity Goals**: Ambulate 300 feet with walker, transfer bed-chair independently
3. **Participation Goals**: Return to work, resume hobbies, live independently

**Assistance Levels** (document current and goal):
- I = Independent
- SV = Supervision (cues, no physical assist)
- CG = Contact Guard (hands close, no assist)
- Min A = Minimal Assist (patient does 75%+)
- Mod A = Moderate Assist (patient does 50-74%)
- Max A = Maximal Assist (patient does 25-49%)
- Total A = Total Assist (patient does <25%)

### Therapy Interventions

**Physical Therapy**:
- Therapeutic exercise dose: Specify sets, reps, resistance, frequency
- Gait training: Distance, assistive device, supervision level
- Balance training: Static, dynamic, perturbation-based
- Modalities: Heat, ice, TENS, E-stim - adjuncts only, not primary intervention

**Occupational Therapy**:
- ADL training: Use of adaptive equipment (reacher, sock aid, built-up utensils)
- Upper extremity strengthening: Functional tasks, fine motor activities
- Cognitive retraining: Memory strategies, attention training, executive function

**Speech-Language Pathology**:
- Dysphagia: Diet texture modifications (IDDSI levels), swallow strategies (chin tuck, multiple swallows)
- Aphasia therapy: Constraint-induced language therapy, semantic feature analysis
- Dysarthria: Articulation drills, rate control, augmentative communication

### Home Exercise Program (HEP)

**Essentials**:
- Illustrated handout with pictures/descriptions
- Specific dosage (e.g., "2 sets x 10 reps, daily")
- Progression criteria
- Safety precautions
- Patient/caregiver demonstrates understanding

### DME and Environmental Modifications

**Common DME**:
- Ambulation: Walker, cane, crutches (specify type, e.g., front-wheeled walker)
- Bathroom: Raised toilet seat, shower chair, grab bars
- Dressing: Reacher, sock aid, long shoe horn, button hook, elastic laces
- Mobility: Hospital bed, wheelchair (if needed)

**Home Modifications**:
- Ramp for stairs
- Stair lift if multiple levels
- Remove scatter rugs (fall hazard)
- Improve lighting
- Rearrange for accessibility

### Discharge Planning

**Discharge Criteria**:
- Functional plateau reached or goals met
- Safe for discharge setting
- Patient/caregiver educated
- DME obtained and home modifications complete
- Follow-up arranged

**Discharge Destination**:
- Home with outpatient therapy
- Home with home health
- Skilled nursing facility
- Long-term acute care hospital (if medically complex)

---

## 3. Mental Health Treatment Plans

### Applicable Conditions
- Major depressive disorder, dysthymia
- Anxiety disorders (GAD, panic, social anxiety, specific phobias)
- Bipolar disorder
- Schizophrenia and psychotic disorders
- PTSD and trauma-related disorders
- Eating disorders
- Substance use disorders
- Personality disorders

### Key Assessment Components

**Diagnostic Assessment**:
- Meet DSM-5 criteria for diagnosis
- Symptom severity assessment (use validated scales)
- Functional impairment (work, relationships, self-care)
- Psychiatric history (prior episodes, treatments, hospitalizations)
- Substance use assessment (AUDIT, DAST)
- Trauma history
- Family psychiatric history

**Validated Assessment Tools**:
- **PHQ-9**: Depression severity (0-27, scores ≥10 indicate moderate-severe depression)
- **GAD-7**: Anxiety severity (0-21, scores ≥10 indicate moderate-severe anxiety)
- **MDQ** (Mood Disorder Questionnaire): Bipolar screening
- **PC-PTSD-5**: PTSD screening, then full PCL-5 if positive
- **AUDIT**: Alcohol use (0-40, ≥8 indicates hazardous drinking)
- **PHQ-15**: Somatic symptoms
- **WHODAS 2.0**: Functional disability

**Risk Assessment**:
- **Suicide Risk**: Use Columbia Suicide Severity Rating Scale (C-SSRS)
  - Ideation (passive, active, plan, intent)
  - Protective factors (reasons for living, social support)
  - Risk factors (prior attempts, impulsivity, access to means)
- **Violence/Homicide Risk**: History of violence, current ideation, access to weapons

### Treatment Goals Specifics

**Symptom Goals**:
- Reduction in standardized scale scores (e.g., PHQ-9 from 18→<10→<5 for remission)
- Specific symptom targets (sleep 7 hours, reduce panic attacks from 3/week→0)

**Functional Goals**:
- Return to work/school
- Resume social activities
- Improve relationships
- Self-care independence

**Recovery-Oriented Goals**:
- Personal meaning and purpose
- Hope and empowerment
- Social connections and community integration
- Independent living

### Evidence-Based Psychotherapies

**Depression**:
- **CBT**: 12-16 sessions, homework between sessions
- **Behavioral Activation**: Focus on increasing rewarding activities
- **Interpersonal Therapy (IPT)**: 12-16 sessions, focus on relationships
- **Problem-Solving Therapy**: Brief (6-8 sessions), structured approach

**Anxiety**:
- **CBT with exposure**: Gold standard for anxiety disorders
- **Panic Control Therapy**: Interoceptive exposure, cognitive restructuring
- **Social skills training**: For social anxiety

**PTSD**:
- **Prolonged Exposure (PE)**: 8-15 sessions, imaginal and in vivo exposure
- **Cognitive Processing Therapy (CPT)**: 12 sessions, challenge trauma-related cognitions
- **EMDR** (Eye Movement Desensitization and Reprocessing): Alternative, less evidence than PE/CPT

**Bipolar**:
- **Family-Focused Therapy**: Psychoeducation, communication, problem-solving
- **Interpersonal and Social Rhythm Therapy**: Stabilize daily routines, sleep

**Borderline Personality Disorder**:
- **DBT** (Dialectical Behavior Therapy): 1 year program, individual + group + phone coaching
- Skills: Mindfulness, distress tolerance, emotion regulation, interpersonal effectiveness

### Psychopharmacology Specifics

**Antidepressants**:
- First-line: SSRIs (sertraline, escitalopram, fluoxetine)
- 2-4 weeks for initial response, 6-8 weeks for full effect
- Titrate after 2-4 weeks if partial response
- Switch if no response after full trial
- Augmentation strategies if partial response (second antidepressant, atypical antipsychotic, lithium)
- Continue 6-12 months after remission (longer if recurrent)

**Antipsychotics**:
- First-generation (typical): Haloperidol - high EPS risk, use second-generation preferred
- Second-generation (atypical): Risperidone, olanzapine, quetiapine, aripiprazole, lurasidone
- Monitoring: Metabolic syndrome (weight, glucose, lipids), EPS, prolactin, QTc

**Mood Stabilizers**:
- Lithium: Narrow therapeutic window, monitor levels (0.6-1.2 mEq/L), TSH, renal function
- Valproic acid: Monitor levels, LFTs, CBC (thrombocytopenia)
- Lamotrigine: Titrate slowly (risk of Stevens-Johnson syndrome if too fast)

### Safety Planning

**Essential for All Mental Health Plans**:
- Warning signs (thoughts, feelings, behaviors)
- Internal coping strategies
- Social support contacts
- Professional contacts (therapist, psychiatrist, crisis line)
- Means restriction (firearms removed, medications limited)
- Reason for living

**Crisis Resources**:
- 988 Suicide & Crisis Lifeline
- Crisis Text Line (text HOME to 741741)
- Local mobile crisis team
- Emergency department

---

## 4. Chronic Disease Management Plans

### Multiple Comorbidities Management

**Common Clusters**:
- Cardiometabolic: Diabetes + hypertension + hyperlipidemia + obesity
- Cardiopulmonary: Heart failure + COPD
- Renal-cardiovascular: CKD + hypertension + diabetes
- Mental-physical: Depression + chronic pain + chronic disease

### Prioritization Strategies

**When Multiple Goals Compete**:
1. **Life-threatening issues first**: Unstable angina, uncontrolled heart failure
2. **High-impact, modifiable conditions**: Diabetes with HbA1c 10% (significant reduction possible)
3. **Synergistic treatments**: Medications that help multiple conditions (SGLT2i for diabetes + heart failure + CKD)
4. **Patient priorities**: What matters most to patient

### Medication Optimization for Multimorbidity

**Synergistic Medications** (dual/triple benefit):
- **SGLT2 inhibitors**: Diabetes + heart failure + CKD
- **ACE inhibitors/ARBs**: Hypertension + diabetes (renal protection) + heart failure
- **Beta-blockers**: Hypertension + heart failure + CAD
- **Statins**: Hyperlipidemia + ASCVD prevention + diabetes
- **GLP-1 agonists**: Diabetes + weight loss + cardiovascular benefit

**Deprescribing**:
- Identify medications with limited benefit (e.g., strict glycemic control in limited life expectancy)
- Discontinue medications with more harm than benefit
- Simplify regimens (reduce pill burden)

### Care Coordination

**Team-Based Care**:
- Primary care coordinates
- Specialists co-manage (cardiologist for HF, endocrinologist for diabetes)
- Care coordinator facilitates (schedules, education, barrier identification)
- Pharmacist reviews medications, optimizes therapy
- Dietitian provides medical nutrition therapy
- Social worker addresses social needs

**Communication**:
- Shared EHR when possible
- Care plan accessible to all team members
- Medication reconciliation after specialist visits
- Regular team meetings or e-consultations

### Population Health Integration

**Registry Management**:
- Identify patients due for care (HbA1c testing, diabetic eye exam)
- Outreach for overdue preventive care
- Risk stratification (high-utilizers, complex patients)

**Transition Management**:
- Hospital discharge follow-up within 7 days
- Medication reconciliation post-discharge
- Red flags review
- Escalation plan if decompensating

---

## 5. Perioperative Care Plans

### Preoperative Risk Assessment

**Cardiac Risk** (Revised Cardiac Risk Index - RCRI):
- High-risk surgery, ischemic heart disease, heart failure, CVD, diabetes on insulin, creatinine >2
- 0 points = <1% risk, 1 point = 1%, 2 points = 2.4%, ≥3 points = 5.4% risk of cardiac event

**If High Risk**: Consider further testing (stress test, echo), cardiology consultation, perioperative beta-blockade.

**Pulmonary Risk** (ARISCAT score):
- Age, SpO2, respiratory infection recent, preop anemia, surgical incision, duration, emergency
- Higher risk: Smoking cessation, incentive spirometry, early mobilization

**VTE Risk** (Caprini Score):
- Age, surgery type, mobility, prior VTE, obesity, cancer
- Stratify to guide prophylaxis (none, mechanical, pharmacologic, or both)

### Preoperative Optimization

**Diabetes**:
- Target HbA1c <8% for elective surgery (delay if >9%)
- Hold metformin 24-48 hours before (risk of lactic acidosis)
- Hold SGLT2i 3-4 days before (DKA risk)
- Insulin: Reduce long-acting by 20-25% day of surgery, hold short-acting

**Hypertension**:
- Continue most medications through surgery
- Hold ACE/ARB morning of surgery (avoid intraop hypotension)
- Continue beta-blocker (avoid withdrawal)

**Anticoagulation**:
- Warfarin: Hold 5 days before, bridge with LMWH if high VTE risk
- DOACs: Hold 24-48 hours (based on renal function and bleeding risk)
- Antiplatelet: Continue aspirin for most surgeries, hold P2Y12 inhibitors (clopidogrel) 5-7 days if high bleeding risk

**Anemia**:
- Optimize iron stores preop (IV iron if time limited)
- Avoid transfusion triggers if possible (restrictive strategy)

### Enhanced Recovery After Surgery (ERAS)

**Preoperative**:
- Patient education, expectation setting
- No prolonged fasting (clear liquids 2 hours before)
- Carbohydrate loading (reduces insulin resistance)
- No routine premedication

**Intraoperative**:
- Multimodal analgesia (minimize opioids)
- Goal-directed fluid therapy (avoid overhydration)
- Normothermia (prevent hypothermia)
- Antiemetic prophylaxis

**Postoperative**:
- Early mobilization (out of bed day of surgery)
- Early oral nutrition (resume diet POD 0-1)
- Multimodal analgesia (acetaminophen, NSAIDs, regional blocks)
- Remove tubes/drains early (Foley, NG tube, surgical drains)
- DVT prophylaxis

### Postoperative Milestones

**Day of Surgery (POD 0)**:
- Out of bed to chair 4-6 hours post-op
- Sips of clear liquids if appropriate
- Pain controlled on multimodal regimen

**POD 1**:
- Ambulate in hallway
- Regular diet
- Foley catheter removed
- Transition to oral pain medications

**POD 2-3** (typical discharge for many surgeries):
- Ambulate 150+ feet
- Adequate oral intake
- Pain controlled on oral meds
- No complications requiring hospitalization

### Discharge Readiness

**Criteria**:
- Adequate pain control on oral medications
- Tolerating regular diet
- Mobile (ambulate, transfers)
- Voiding spontaneously
- Stable vital signs
- No active complications
- Safe discharge plan (home support, DME arranged)

---

## 6. Pain Management Plans

### Pain Assessment

**Comprehensive Pain Evaluation**:
- Location, radiation
- Quality (sharp, dull, burning, aching, shooting)
- Intensity (0-10 NRS)
- Temporal pattern (constant, intermittent, episodic)
- Aggravating/alleviating factors
- Functional impact (Brief Pain Inventory - BPI interference items)
- Prior treatments and responses

**Pain Classification**:
- **Nociceptive**: Somatic (MSK) or visceral (organ)
- **Neuropathic**: Nerve injury/dysfunction (burning, shooting, electric, numbness/tingling)
- **Nociplastic**: Central sensitization, fibromyalgia
- **Mixed**: Combination

### Multimodal Analgesia Principles

**Goal**: Additive/synergistic pain relief from multiple mechanisms, opioid-sparing.

**Components**:
1. Non-opioid analgesics (acetaminophen, NSAIDs)
2. Adjuvant analgesics (gabapentinoids, SNRIs, TCAs for neuropathic)
3. Topical agents (lidocaine patches, diclofenac gel, capsaicin)
4. Interventional procedures (injections, nerve blocks, RFA, SCS)
5. Physical therapies (PT, exercise, TENS)
6. Psychological therapies (CBT-CP, mindfulness, biofeedback)
7. Complementary therapies (acupuncture, massage, yoga)
8. Opioids (if other modalities insufficient) - lowest dose, reassess frequently

### Neuropathic Pain Specific Treatments

**First-Line**:
- Gabapentin 300mg titrate to 1800-3600mg/day divided TID
- Pregabalin 75mg BID titrate to 150-300mg BID
- Duloxetine 60mg daily (also for fibromyalgia, chronic MSK pain)
- TCAs (amitriptyline, nortriptyline) 10-75mg QHS - second-line due to side effects

**Topical**:
- Lidocaine patches 5% (localized neuropathic pain)
- Capsaicin 8% patch (high-concentration, applied by provider)

**Refractory**:
- Tramadol (dual mechanism - opioid + SNRI)
- Opioids (if severe and function-limiting despite above)

### Opioid Prescribing (CDC Guidelines)

**Before Initiating**:
- Non-opioid multimodal therapies tried and inadequate
- Functional goals established (not just pain scores)
- Risks vs. benefits discussed and documented
- Opioid risk assessment (ORT, SOAPP)
- Informed consent discussion
- Treatment agreement signed
- PDMP checked
- Baseline UDS

**During Opioid Therapy**:
- Start low dose (<50 MME/day), short-acting
- Reassess frequently (every 1-3 months)
- Functional improvement expected (not just pain scores)
- UDS every 3-6 months (check for adherence and illicit substances)
- PDMP check each prescription or at least every 3 months
- Naloxone co-prescribed
- Avoid concurrent benzodiazepines
- If dose approaching 50 MME, reassess; avoid >90 MME if possible

**Tapering**:
- If not meeting functional goals
- Serious adverse effects
- Aberrant behaviors
- Patient request
- Slow taper: 10-25% dose reduction per week to month (faster if safety concern)

### Interventional Pain Procedures

**Indications and Evidence**:
- **Epidural Steroid Injection**: Radicular pain from disc herniation/stenosis - short-term benefit
- **Facet Joint Injections**: Diagnostic (if >50% relief, proceed to RFA)
- **Radiofrequency Ablation**: 6-12 months relief for facet-mediated pain
- **Spinal Cord Stimulation**: Refractory neuropathic pain (FBSS, CRPS) - 50-60% success
- **Intrathecal Pump**: Severe refractory pain, cancer pain - delivers medication to CSF

**Documentation for Procedures**:
- Indication, prior conservative treatments tried
- Expected benefit and duration
- Risks discussed
- Number of injections/procedures allowed per year

### Functional Goals Emphasis

**Shift from Pain Scores to Function**:
- "Reduce pain to 3/10" is less meaningful than "Walk 1 mile, return to work, play with grandchildren"
- BPI interference scores track functional impact
- SMART functional goals (see Goal Setting reference)

### Psychological Integration

**CBT for Chronic Pain (CBT-CP)**:
- Pain education and reconceptualization (pain ≠ harm)
- Cognitive restructuring (challenge catastrophizing, all-or-nothing thinking)
- Activity pacing and graded exposure (increase activity without flares)
- Relaxation techniques
- Acceptance and mindfulness

**Essential for Chronic Pain**: Psychological factors (depression, anxiety, catastrophizing) perpetuate pain; must be addressed.

---

## Cross-Cutting Considerations for All Treatment Plans

### Cultural Competence
- Ask about cultural health beliefs, practices
- Use interpreter services when language barriers exist
- Respect religious/spiritual practices in treatment
- Adapt interventions to cultural context when possible

### Health Literacy
- Assess understanding (teach-back method)
- Use plain language, avoid jargon
- Visual aids, written materials at 5th-6th grade reading level
- Confirm patient can execute plan (demonstrate inhaler use, insulin injection, etc.)

### Social Determinants of Health (SDOH)
- Screen for food insecurity, housing instability, transportation barriers
- Connect to community resources (SNAP, Medicaid, patient assistance programs)
- Address barriers in treatment plan (e.g., medication cost → generic alternatives, patient assistance)

### Advance Care Planning
- Appropriate for serious illness, elderly, declining function
- Goals of care discussion
- Healthcare proxy designation
- Advance directive completion
- Preferences for resuscitation, intubation, dialysis, etc.

---

**Document Version**: 1.0  
**Last Updated**: January 2025  
**Next Review**: January 2026

