---
name: yeet
description: Use only when the user explicitly asks to stage, commit, push, and open a GitHub pull request in one flow using the GitHub CLI (`gh`).
metadata:
  short-description: Stage, commit, and open PR
---

## Prerequisites

- Require GitHub CLI `gh`. Check `gh --version`. If missing, ask the user to install `gh` and stop.
- Require authenticated `gh` session. Run `gh auth status`. If not authenticated, ask the user to run `gh auth login` (and re-run `gh auth status`) before continuing.

## Naming conventions

- Branch: `codex/{description}` when starting from main/master/default.
- Commit: `{description}` (terse).
- PR title: `[codex] {description}` summarizing the full diff.

## Workflow

If on main/master/default, git checkout -b "codex/{description}"; otherwise stay on the current branch.
Confirm status git status -sb, then stage everything git add -A.
Commit tersely with the description, e.g. git commit -m "{description}".
Run checks if not already. If checks fail due to missing deps/tools, install dependencies and rerun once.
Push with tracking: git push -u origin $(git branch --show-current).
If git push fails due to workflow auth errors, pull from master and retry the push.
Open a PR: GH_PROMPT_DISABLED=1 GIT_TERMINAL_PROMPT=0 gh pr create --draft --fill --head $(git branch --show-current) and edit title/body to reflect the description and the deltas.
Write the PR description to a temp file with real newlines (e.g. pr-body.md ... EOF) and run pr-body.md to avoid \\n-escaped markdown.
PR description (markdown) must be detailed prose covering the issue, the cause and effect on users, the root cause, the fix, and any tests or checks used to validate.
