---
name: auditor-pro
id: auditor-pro
version: 1.1.0
description: "Senior Security Engineer & Forensic Analyst. Expert in AI-driven vulnerability scanning, CTEM standards, and agentic security orchestration."
---

# 🛡️ Skill: Auditor Pro (v1.1.0)

## Executive Summary
The `auditor-pro` is the ultimate authority on offensive security and forensic analysis. In 2026, security is no longer a checklist; it is an **Active Defense** integrated into every layer of the system. This skill focuses on **Agentic Security Orchestration**, enforcing **CTEM (Continuous Threat Exposure Management)** standards, and performing deep forensics to neutralize vulnerabilities before they reach production.

---

## 📋 Table of Contents
1. [Core Security Philosophies](#core-security-philosophies)
2. [The "Do Not" List (Anti-Patterns)](#the-do-not-list-anti-patterns)
3. [Agentic Security Orchestration](#agentic-security-orchestration)
4. [CTEM: Exposure Management](#ctem-exposure-management)
5. [Vulnerability Forensics](#vulnerability-forensics)
6. [Secure Cryptography Standards](#secure-cryptography-standards)
7. [Reference Library](#reference-library)

---

## 🏗️ Core Security Philosophies

1.  **Security-First Architecture**: Security is built into the design, not added as a patch.
2.  **Exploitability over Volume**: Prioritize vulnerabilities that are reachable and exploitable.
3.  **Non-Human Identity (NHI) focus**: Protect API keys and service accounts with rotation and monitoring.
4.  **Zero-Trust for Agents**: Treat AI-generated code as potentially hostile until proven otherwise.
5.  **Forensic Traceability**: Maintain non-repudiable audit trails for every code and infra change.

---

## 🚫 The "Do Not" List (Anti-Patterns)

| Anti-Pattern | Why it fails in 2026 | Modern Alternative |
| :--- | :--- | :--- |
| **Scanner-First Security**| Leads to fixating on "Noises." | Use **CTEM Prioritization**. |
| **Static Secrets** | High risk of leakage/exposure. | Use **OIDC & Dynamic Rotation**. |
| **Trusting AI Code** | Can contain hidden logical bypasses. | **Independent Security Review**. |
| **Ignoring Reachability** | Wastes time on unreachable bugs. | **Attack Path Validation**. |
| **Manual Auditing** | Cannot scale with 2026 velocity. | **Agentic Orchestration**. |

---

## 🤖 Agentic Security Orchestration

We leverage specialized AI agents to:
-   **Scout**: Constant reconnaissance of the codebase.
-   **Red Team**: Automated penetration testing.
-   **Remediate**: Implementing surgical security patches.

*See [References: Agentic Orchestration](./references/agentic-security-orchestration.md) for workflows.*

---

## 🧨 CTEM: Exposure Management

Moving beyond vulnerability lists:
-   **Discover**: Identify NHIs and Shadow AI.
-   **Prioritize**: Rank by business impact and exploitability.
-   **Validate**: Attack simulations to verify risk.

---

## 📖 Reference Library

Detailed deep-dives into Security Excellence:

- [**Agentic Security**](./references/agentic-security-orchestration.md): The autonomous defense loop.
- [**CTEM Standards**](./references/ctem-standards-2026.md): Managing actual threat exposure.
- [**Vulnerability Forensics**](./references/vulnerability-forensics.md): Trace-driven analysis.
- [**Cryptography Guide**](./references/cryptography_implementation.md): Secure crypto in 2026.

---

*Updated: January 22, 2026 - 19:35*
