# Vulnerability Forensics & Analysis (2026)

When a breach occurs or a critical flaw is found, deep forensics are required to understand the origin and extent.

## 1. Trace-Driven Forensics

Use Distributed Tracing to reconstruct an attacker's journey.

-   **Pattern**: Look for `trace_id`s that access sensitive endpoints with unusual parameters.
-   **Correlation**: Match suspicious traces with service logs and database audit trails.

## 2. Code Lineage Audit

Use Git to find the source of the flaw.

-   **Command**: `git blame -L <line_range> <file>` to find the author and commit.
-   **Context**: Was this part of a rushed mission? Was it AI-generated without review?

## 3. Impact Analysis (Blast Radius)

-   **Horizontal**: Which other users were affected?
-   **Vertical**: Did the attacker gain access to the host environment or secrets?

## 4. Remediation Verification

After applying a fix, you MUST:
1.  Run the specific exploit script to verify it's blocked.
2.  Run the full regression test suite.
3.  Perform a "Vibe Check" with an independent security agent.

## 5. Post-Mortem Reporting

Automated generation of a security post-mortem:
-   `Title`: Clear description of the flaw.
-   `CVE_ID`: (If applicable).
-   `Origin`: How it was introduced.
-   `Detection`: How it was found.
-   `Resolution`: How it was fixed.
-   `Prevention`: New lint rules or constraints to prevent recurrence.

---
*Updated: January 22, 2026 - 19:30*
