---
name: context-distiller
id: context-distiller
version: 1.1.0
description: "Senior Context Architect & Memory Engineer. Expert in Automated Context Packing, Symbol Indexing, and Agent Rehydration for 2026."
---

# 🗺️ Skill: Context Distiller (v1.1.0)

## Executive Summary
The `context-distiller` is the master of high-fidelity information management for AI swarms. In 2026, the success of a mission depends on the quality and density of the context provided to the agent. This skill focuses on **Automated Context Packing**, building **Symbolic Project Maps**, and managing **Agent Memory Rehydration** to ensure that every session starts with maximum intelligence and minimum token noise.

---

## 📋 Table of Contents
1. [The Distillation Protocol](#the-distillation-protocol)
2. [The "Do Not" List (Anti-Patterns)](#the-do-not-list-anti-patterns)
3. [Automated Context Packing (Repomix)](#automated-context-packing-repomix)
4. [Symbolic Project Mapping](#symbolic-project-mapping)
5. [Agent Memory & Rehydration](#agent-memory--rehydration)
6. [Hierarchical Inheritance](#hierarchical-inheritance)
7. [Reference Library](#reference-library)

---

## 🛠️ The Distillation Protocol

Before initiating a new mission or subproject, the Distiller MUST:

1.  **Codebase Scan**: Use `rg` and `list_directory` to map the active module's boundaries.
2.  **Symbol Indexing**: Generate a list of critical types and interfaces.
3.  **Inheritance Audit**: load master rules from `docs/AGENTS.md`.
4.  **Local Rehydration**: Create or read `.gemini/GEMINI.md` for mission-specific context.
5.  **Context Packing**: Bundle all findings into a structured Markdown artifact.

---

## 🚫 The "Do Not" List (Anti-Patterns)

| Anti-Pattern | Why it fails in 2026 | Modern Alternative |
| :--- | :--- | :--- |
| **Thin Context** | Leads to hallucinations and generic code. | Use **High-Fidelity Packing**. |
| **Token Bloat** | High latency and poor reasoning. | Use **Semantic Filtering**. |
| **Flat History** | Agent loses track of past decisions. | Use **Memory Rehydration**. |
| **Manual Symbol Hunt**| Slow and prone to missing definitions. | Use **Symbolic Project Maps**. |
| **Ignoring Rules** | Inconsistent architecture. | Use **Hierarchical Inheritance**. |

---

## 📦 Automated Context Packing

We use **Repomix** and **gitingest** to feed the models:
-   **Structure**: Group files by domain (Logic, Types, Tests).
-   **Optimization**: Exclude noise (node_modules, dist, git).
-   **Security**: Mandatory secret scrubbing before ingestion.

*See [References: Context Packing](./references/automated-context-packing.md) for workflows.*

---

## 🐘 Symbolic Project Mapping

When projects are large, don't read everything—use a map.
-   **JSON Maps**: Indexing every export and its file path.
-   **Symbolic RAG**: fetching only relevant files based on symbol dependency.

---

## 📖 Reference Library

Detailed deep-dives into Information Engineering:

- [**Context Packing**](./references/automated-context-packing.md): Bundling artifacts for LLMs.
- [**Symbolic Mapping**](./references/symbol-indexing-symbolic-ai.md): Navigating large codebases.
- [**Memory Rehydration**](./references/agent-memory-rehydration.md): Persistent mission context.
- [**Inheritance Models**](./references/context-inheritance.md): Global vs Local rules.

---

*Updated: January 22, 2026 - 21:40*
