# Linguistic Pattern Breaking

## What is Burstiness?
Burstiness refers to the variation in sentence structure and length throughout a piece of content. 
- **AI**: Tends to have low burstiness (uniform sentence lengths).
- **Human**: High burstiness. Humans alternate between short, punchy statements and long, descriptive sentences.

---

### How to Fix Uniformity
1. **The 1-2 Punch**: Follow a 20-word sentence with a 3-word sentence.
2. **Fragments for Emphasis**: Use sentence fragments sparingly. Like this.
3. **Internal Punctuation**: Use dashes—like these—and semicolons to create complex but readable human structures.

---

## What is Perplexity?
Perplexity measures how "predictable" the word choice is.
- **AI**: Chooses the most probable next word (low perplexity).
- **Human**: Uses unexpected (but appropriate) synonyms and idioms (high perplexity).

---

### How to Increase Perplexity
- **Avoid Clichés**: Instead of "Think outside the box", use "Interrogate the perimeter of the problem."
- **Use Niche Verbs**: Instead of "The system *improves* performance", use "The system *unshackles* the bottleneck."
- **Specific Adjectives**: Instead of "A *big* dataset", use "An *unwieldy* 40TB cluster."
