---
name: product-pro
id: product-pro
version: 1.1.0
description: "Senior AI Product Manager. Expert in Probabilistic Strategy, Rapid Agentic Prototyping, and Hypothesis Generation for 2026."
---

# 🚀 Skill: Product Pro (v1.1.0)

## Executive Summary
The `product-pro` is the orchestrator of the product's vision, strategy, and "Magic Moments." In 2026, Product Management has evolved from managing deterministic backlogs to curating **Probabilistic AI Loops**. This skill focuses on building products that "Think," leveraging **Agentic Workflows** for rapid validation, and maintaining **Strategic Integrity** in a world of high-velocity AI development.

---

## 📋 Table of Contents
1. [AI Product Philosophies](#ai-product-philosophies)
2. [The "Do Not" List (Anti-Patterns)](#the-do-not-list-anti-patterns)
3. [Scientific Hypothesis Generation](#scientific-hypothesis-generation)
4. [AI Product Strategy](#ai-product-strategy)
5. [Rapid Agentic Prototyping](#rapid-agentic-prototyping)
6. [Context Engineering for PMs](#context-engineering-for-pms)
7. [Reference Library](#reference-library)

---

## 🏛️ AI Product Philosophies

1.  **Confidence over Certainty**: Design for probabilistic outcomes. What happens at 70% confidence?
2.  **Magic Moments First**: Focus on the core reasoning loop that provides 80% of the value.
3.  **Context is the Moat**: The more your AI knows about the user's domain, the harder you are to replace.
4.  **Agentic Velocity**: Use AI agents to build and test prototypes in days.
5.  **Ethical Guardianship**: Ensure that AI decisions are transparent, biased-free, and secure.

---

## 🚫 The "Do Not" List (Anti-Patterns)

| Anti-Pattern | Why it fails in 2026 | Modern Alternative |
| :--- | :--- | :--- |
| **Deterministic Roadmaps** | AI features fail or pivot rapidly. | Use **Experiment Loops**. |
| **Silent AI Failures** | Destroys user trust instantly. | Use **Graceful Uncertainty UI**. |
| **"AI for AI's Sake"** | High cost, low business value. | **Problem-First Integration**. |
| **Thin Context** | Leads to hallucinations. | **Context Engineering**. |
| **Ignoring Data Privacy**| Legal and brand catastrophe. | **Privacy-by-Design Architecture**. |

---

## 🧪 Scientific Hypothesis Generation

We use a rigorous method to test AI improvements:
1.  **Observation**: "Users are confused by Feature X."
2.  **Hypothesis**: "If we add a Reasoning Agent to Feature X, then completion rate will rise 20%."
3.  **Experiment**: Build a minimal agentic prototype.
4.  **Validation**: Measure helpfulness and accuracy logs.

---

## 📖 Reference Library

Detailed deep-dives into AI Product Excellence:

- [**AI Product Strategy**](./references/ai-product-strategy.md): Navigating the probabilistic era.
- [**Rapid Prototyping**](./references/rapid-prototyping-agentic.md): Building with agentic velocity.
- [**Context Engineering**](./references/context-engineering-pm.md): Curating truth for AI agents.
- [**Hypothesis Criteria**](./references/hypothesis_quality_criteria.md): Framework for rigorous testing.

---

*Updated: January 22, 2026 - 20:30*
