---
name: prompt-pro
id: prompt-pro
version: 1.1.0
description: "Senior Prompt Engineer & Agentic Orchestrator. Expert in Reasoning Models (o3), Tree-of-Thoughts, and Structured Thinking Protocols for 2026."
---

# 🪄 Skill: Prompt Pro (v1.1.0)

## Executive Summary
The `prompt-pro` is the master of the "Linguistic Core." In 2026, prompting has evolved from simple text instructions to **Architectural Orchestration**. This skill focuses on optimizing for **Reasoning Models (o3, Gemini 3 Pro)**, implementing advanced logic frameworks like **Tree-of-Thoughts**, and building autonomous **ReAct loops** that allow agents to act and reason in unison. We don't just "talk" to AI; we design its cognitive behavior.

---

## 📋 Table of Contents
1. [Core Prompting Philosophies](#core-prompting-philosophies)
2. [The "Do Not" List (Anti-Patterns)](#the-do-not-list-anti-patterns)
3. [Optimizing for Reasoning Models (o3)](#optimizing-for-reasoning-models-o3)
4. [Tree-of-Thoughts (ToT) Framework](#tree-of-thoughts-tot-framework)
5. [ReAct: Autonomous Loops](#react-autonomous-loops)
6. [Structured Thinking Protocols](#structured-thinking-protocols)
7. [Reference Library](#reference-library)

---

## 🏛️ Core Prompting Philosophies

1.  **Intent is Deterministic**: If the prompt is ambiguous, the result is hallucinated. Use rigid structures.
2.  **Objective over Instruction**: Tell the model "What" to achieve, not just "How" to do it.
3.  **Few-Shot is the King**: One perfect example is worth a hundred rules.
4.  **Feedback Loops are Built-in**: Design prompts that ask the model to critique its own output.
5.  **Token Economy**: Be concise. Every extra token is latency and cost.

---

## 🚫 The "Do Not" List (Anti-Patterns)

| Anti-Pattern | Why it fails in 2026 | Modern Alternative |
| :--- | :--- | :--- |
| **Instruction Overload** | Model loses track of priorities. | Use **Hierarchical Rules**. |
| **Fixed Step-by-Step** | Limits the model's reasoning power. | Use **Objective-Based Prompts**. |
| **Ignoring Reasoning Tokens**| Results in shallow, rushed answers. | Increase **maxOutputTokens**. |
| **Implicit Assumptions** | Leads to "Vibe Hallucinations." | State **Assumptions Explicitly**. |
| **Manual Parsing** | Inefficient and fragile. | Use **ResponseSchema (JSON)**. |

---

## 🧠 Optimizing for Reasoning Models (o3/Pro)

We leverage the model's internal "Thought Layer":
-   **Deep Research Triggers**: Commanding exhaustive source searches.
-   **Verification Loops**: Asking the model to find flaws in its own strategy.
-   **Self-Correction**: Enabling autonomous backtracking if a plan fails.

*See [References: Reasoning Optimization](./references/reasoning-model-optimization-o3.md) for details.*

---

## 🌳 Tree-of-Thoughts (ToT) Framework

-   **Parallel Generation**: Proposing 3+ independent strategies.
-   **Elimination Strategy**: Removing the weakest branch via logic.
-   **Final Synthesis**: Merging the best elements of all branches.

---

## 📖 Reference Library

Detailed deep-dives into Prompt Engineering Excellence:

- [**Reasoning Models (o3)**](./references/reasoning-model-optimization-o3.md): Objective-based prompting.
- [**Tree-of-Thoughts**](./references/tree-of-thoughts-tot.md): Exploring multiple logic branches.
- [**ReAct Patterns**](./references/react-reasoning-acting.md): Reasoning and acting in unison.
- [**Thinking Protocols**](./references/structured-thinking-protocols.md): Designing cognitive behavior.

---

*Updated: January 22, 2026 - 21:00*
