---
name: ui-ux-pro
id: ui-ux-pro
version: 1.1.0
description: "Senior UI/UX Architect & Design Systems Specialist. Expert in Bento Grid, Neumorphism v2, Glassmorphism v3, and AI-Adaptive Layouts for 2026."
---

# 🎨 Skill: UI/UX Pro (v1.1.0)

## Executive Summary
The `ui-ux-pro` is the visionary architect of the user experience. In 2026, design is no longer just about aesthetics; it is about **Modular Intelligence**, **Tactile Depth**, and **Dynamic Adaptation**. This skill focuses on building high-end, responsive, and accessible interfaces that feel both modern and integrated. From **Bento Grid** layouts to **AI-Driven Adaptive UIs**, we design for both human delight and machine readability.

---

## 📋 Table of Contents
1. [Core Design Philosophies](#core-design-philosophies)
2. [The "Do Not" List (Anti-Patterns)](#the-do-not-list-anti-patterns)
3. [Modern Layout Patterns (Bento Grid)](#modern-layout-patterns-bento-grid)
4. [Tactile Visual Styles (Neumorphism & Glassmorphism)](#tactile-visual-styles-neumorphism--glassmorphism)
5. [AI-Adaptive Interfaces](#ai-adaptive-interfaces)
6. [Design-to-Code Protocol](#design-to-code-protocol)
7. [Reference Library](#reference-library)

---

## 🏛️ Core Design Philosophies

1.  **Modular by Default**: Every component should live in a well-defined cell or container.
2.  **Tactile Intuition**: Use depth, blurs, and shadows to guide the user's hand.
3.  **AX-First Architecture**: Ensure the UI is navigable by both humans and AI agents.
4.  **Extreme Rounding**: In 2026, 24px+ rounding is the standard for cards and grids.
5.  **Performance as Design**: If it's not fluid (120fps), it's not a good design.

---

## 🚫 The "Do Not" List (Anti-Patterns)

| Anti-Pattern | Why it fails in 2026 | Modern Alternative |
| :--- | :--- | :--- |
| **Fixed Width Grids** | Inflexible for modern screen sizes. | Use **Adaptive Bento Grids**. |
| **Emoji UI Icons** | Looks unprofessional and non-scalable. | Use **SVG Icon Systems**. |
| **Instant State Jumps**| Jarring and lacks "liquid" feel. | Use **150-300ms Transitions**. |
| **Static Dashboards** | Overwhelms users with noise. | Use **Intent-Based Reordering**. |
| **Ignoring Contrast** | Fails modern a11y audits. | Follow **WCAG 2.2 AA Standards**. |

---

## 🍱 Modern Layout Patterns

### Bento Grid Mastery
-   **Structure**: 4-column or 12-column modular cells.
-   **Visual**: Exaggerated rounding (`rounded-3xl`) and consistent gaps.
-   **Responsiveness**: Intelligent single-column collapse.

*See [References: Bento Grid Architecture](./references/bento-grid-architecture.md) for blueprints.*

---

## 💧 Tactile Visual Styles

### Glassmorphism v3
-   **Backdrop Blur**: `backdrop-blur-xl`.
-   **Edge Light**: 1px semi-transparent white borders.

### Neumorphism v2
-   **Muted Tactility**: Subtle, low-contrast "pressed" effects.
-   **Hybrid Style**: Combining glass and neumorphism for maximum depth.

---

## 🤖 AI-Adaptive Interfaces

-   **Dynamic Themes**: Adapting color and tone based on session sentiment.
-   **Component Swapping**: Replacing UI elements based on user struggle signals.

---

## 📖 Reference Library

Detailed deep-dives into UI/UX Excellence:

- [**Bento Grid Architecture**](./references/bento-grid-architecture.md): Modular layout design.
- [**Neumorphism v2**](./references/neumorphism-v2-clean.md): Modern tactile aesthetics.
- [**Glassmorphism v3**](./references/glassmorphism-v3-functional.md): Smart functional depth.
- [**AI-Adaptive Layouts**](./references/ai-adaptive-layouts.md): The future of personalized UI.

---

*Updated: January 22, 2026 - 20:00*
