---
name: article-review
description: 根据原文内容撰写深度文章评价/解读。当用户提供一篇文章、博客、公众号文章或任何长文内容，并要求生成评价、解读、读后感或二次创作内容时使用此技能。适用于：(1) 对技术文章、行业分析、年终总结等进行深度解读，(2) 提炼文章核心观点并用通俗语言重新表达，(3) 为社交媒体传播生成二次内容。
---

# 文章评价写作指南

根据原文内容生成高质量的深度评价/解读文章。

## 写作流程

### 第一步：提炼传播点

阅读原文后，首先识别：

1. **传播热点**：文章在圈子里传播的原因是什么？大众关注的焦点是什么？
2. **表层关注 vs 深层价值**：读者表面关注的点（如"作者被裁"）与文章真正的价值所在（如"费米能级"概念）

开篇示例：
```
田渊栋的年终总结，这两天在圈子里传得挺广。
很多人转发的时候，关注点都放在了他被裁这件事上。
但最近，我把他的这份年终总结反复读了几遍，看到他在总结里提出了一个大多数人会很陌生，但非常关键的概念——费米能级。
```

### 第二步：作者背景介绍

简洁介绍作者的背景信息，增强文章的权威性：

- 学历背景（本科、硕士、博士学校）
- 职业经历（知名公司、重要职位）
- 专业领域和成就
- 与文章主题相关的经历

示例：
```
本科交大，博士CMU，毕业后先加入了Google无人驾驶团队。
后转入了Facebook的AI研究院，一待就是十多年。
他主要做的是强化学习方向，发过很多篇重要的论文。
```

### 第三步：核心概念提炼与通俗化

将原文中的核心概念用更通俗易懂的语言重新解释：

1. **识别核心概念**：找出文章中最关键、最有价值的概念
2. **通俗化表达**：用更简单、更有画面感的语言重新解释
3. **逻辑链条梳理**：把作者的推理过程清晰地呈现出来

示例（原文复杂概念 → 通俗解读）：
```
原文："人的价值从按照'本人产出的劳动数量及质量'来评估，变成了是否能提高AI的能力"

解读：现在评估一个人的价值，不再是看你本人能产出多少，而是看你能不能提高AI的能力。
「你加上AI的产出，要大于AI单独的产出，这样你才有存在的价值。」
```

### 第四步：金句引用

直接引用原文中最有力的观点和金句，用引号或特殊格式标注：

- 选择最能代表作者观点的句子
- 选择最有冲击力、最易传播的表达
- 用「」或引号突出显示

示例：
```
「在这种环境下，真正稀缺的不再是实现愿望的能力，而是愿望本身。」
```

### 第五步：画面感表达

用更生动、更有画面感的比喻和表达方式重新包装核心论点：

- 使用具体的场景描写
- 用比喻让抽象概念具象化
- 加入作者个人视角的解读

示例：
```
他说，未来的世界不再是传统故事里描绘的那样，人们为了争夺稀缺的武功秘籍或者寻找唯一的阿拉丁神灯而展开冒险。
相反，这将是一个遍地神灯的时代。
每一个AI都像是一个神灯，能力超群，渴望实现别人的愿望。
```

### 第六步：升华总结

在结尾提炼文章的核心启示，给读者留下思考：

1. **提炼核心信息**：用一句话概括文章最想传达的内容
2. **给出行动指引**：读者应该如何应对或思考
3. **收尾有力**：用简洁有力的句子结束

示例：
```
田渊栋这篇年终总结想说的或许是：只要你还在主动思考，你就没有真正被淘汰。

用思考对抗同化，用目标对抗迷茫。
这或许才是AI时代，一个人最深的护城河。
```

## 写作风格要求

### 语言风格
- 简洁直接，避免冗长
- 短句为主，节奏明快
- 口语化但不失专业性
- 适当留白，给读者思考空间

### 结构特点
- 段落简短，每段2-4句
- 单句成段增强冲击力
- 使用换行分隔逻辑单元
- 引用与解读交替出现

### 避免的问题
- 不要简单复述原文
- 不要过度使用术语
- 不要添加未经证实的信息
- 不要主观臆断作者意图

## 输出格式

生成的评价文章应包含：

1. **开篇引入**（1-2段）：点明传播情况，引出核心价值
2. **背景介绍**（1段）：简述作者背景
3. **核心解读**（3-5段）：提炼并通俗化核心概念
4. **金句引用**（穿插其中）：突出原文亮点
5. **升华总结**（1-2段）：提炼启示，收尾有力

总字数通常为原文的 30%-50%，以便于二次传播。
