# 参考示例

## 完整示例（开场 + 核心观点 + 精华片段 + 结束语）

今天看到 Boris Cherny 分享了他的 Claude Code 使用方法。花了一早上时间研究完了这些内容。干货太多了。

Boris 是我2025见过的把"如何高效使用AI编程工具"这个问题讲得最透彻的人。他是 Claude Code 的创建者，带领团队开发了这个改变编程方式的工具。他的使用方法有两个核心思维：复利思维（CLAUDE.md持续积累）和验证思维（给AI一个反馈循环）。

这期分享的信息密度极高。我把全文精编出来，按主题重新组织，供大家学习。

# 几个核心观点

1. **多开并行**：终端里开5个标签页编号1-5，浏览器里同时开5-10个claude.ai/code页面，用iTerm2系统通知知道哪个需要输入
2. **只用Opus 4.5**：虽然更大更慢，但因为理解能力强、工具使用准确，最后反而比小模型更快，不需要反复纠正
3. **共享CLAUDE.md**：团队每周往里面加内容，逻辑很简单——看到Claude做错了什么就写进去，下次就不会再错
4. **Plan模式优先**：大部分会话按两次shift+tab进入Plan模式，来回讨论直到计划满意，然后Claude通常能一次性完成
5. **Slash Commands复用**：把每天重复的工作流做成命令保存在.claude/commands/，提交到git，Claude自己也能调用
6. **Hook自动格式化**：用PostToolUse hook处理Claude生成代码的最后10%格式问题，避免CI报错
7. **验证是核心**：给Claude一个验证工作的方法（跑测试、测浏览器、检查UI），最终结果质量能提升2-3倍
8. **工具全打通**：Claude通过MCP使用Slack搜索消息、BigQuery跑查询、从Sentry抓错误日志，配置保存在.mcp.json共享

---

# 精华片段

## 复利思维：CLAUDE.md 不是文档，是知识库

Boris 团队有一个共享的 CLAUDE.md 文件，提交到 git 里，整个团队每周都往里面加内容。

逻辑很简单：只要看到 Claude 做错了什么，就写进去，下次就知道不要这么做。这不是一次性写完的文档，而是在日常工作中持续积累的知识库。每次代码审查、每次发现问题，都在让这个文件变得更好。

## 验证思维：AI 很会写代码，但不知道代码能不能用

Boris 强调验证能让质量提升 2-3 倍。这其实暴露了当前 AI 编程的一个核心问题：AI 很会写代码，但不一定知道代码是否真的能用、用户体验是否好。

Claude Code 团队用 Claude Chrome 扩展测试每个改动。Claude 会打开浏览器，测试 UI，然后迭代直到代码能跑、用户体验也好。验证方法因领域而异——可能就是跑一个 bash 命令，或者跑测试套件，或者在浏览器或手机模拟器里测试应用。

## 为什么只用 Opus 4.5？

Boris 只用 Opus 4.5，而且开着 thinking 模式。理由很直接：虽然更大更慢，但因为理解能力强、工具使用准确，最后反而比小模型更快。不需要反复纠正和引导。

---

Boris 凭一己之力，定义了 AI 编程工具的使用范式。每天我都能看到许多开发者用和 Boris 一样的方式，把 Claude 当成真正的编程伙伴。也让我投身其中，以提升效率、学习成长为目的来探索这些工具。

借用 Boris 的核心理念来收个尾：给 AI 一个验证工作的方法，有了这个反馈循环，最终结果的质量能提升 2-3 倍。希望大家能像这期分享反复强调的——不是替代你思考，而是放大你的能力。复利思维 + 验证思维，这才是 AI 时代的正确打开方式。

---

## 长文示例（精华片段风格）

Manus被收购前最后一次访谈：季逸超还不知道Meta即将来敲门

早上写了Manus CEO肖弘的故事。

Meta数十亿美元收购Manus背后：从江西小镇到硅谷风暴眼，肖弘的十年狂飙

但Manus不是一个人造就的，现在正好借机聊聊另一位关键人物——联合创始人兼首席科学家季逸超（Peak）。

相比Peak这个名字，我估计很多人对他的脸更为熟悉，他算是Manus的「门面」——大多数Manus的产品发布视频都是他来主录制的。

2025年12月1日，Peak坐在张小郡的播客镜头前，聊了3个半小时。

他聊了高中做猛犸浏览器的日子，聊了被GPT-3颠覆的那几年，聊了Manus从0到1亿美金ARR的疯狂增长。

访谈快结束时，张小郡问他：你对Manus最悲观的预期是什么？

他说："悲观预期就是下个月死掉。"

然后补了一句："我们没有权利活着，我们是在努力获得一个活着的权利。"

他不知道的是，就在采访结束后不到一个月，Meta宣布全资收购Manus。

这期访谈，成了Manus被收购前的最后一次公开访谈。

### "这个问题要非常郑重的回答一下"

访谈中，Peak澄清了一个重要的争议：

"如果我们在3月份发布的时候，如果我们有任何付费的宣传——我死全家。"

这是他对"Manus炒作营销"质疑的回应。语气认真到让人有点想笑。

他接着评价了联合创始人肖弘：

"你会发现小红有个非常稀缺的特质，什么？他很正常。他身心健全，没有任何不良嗜好，没有任何极端极端的思想。"

主持人问：这不是一个正常的指标吗？

Peak说："这已经很难得了。你知道吗，就是我觉得现在整个这个行业，有很多人比较偏执或者怎么样。但是讲真，其实就是你没有乔布斯的命——"

主持人打断：你在说你自己吗？

Peak笑了："对，我觉得别的创始人都太艺术家了。"

### 从猛犸浏览器到被GPT-3"杀死"

Peak的故事，要从家庭说起。

父亲是北大物理系教授，传统意义上的科学家；母亲是老一辈中关村连续创业者。他在两种风格中长大，取了个中间点——科技创业者。

"我从小不是那种聪明孩子，学习一般，偏科，但比较喜欢自己瞎琢磨。"

高中在北大附中读书，遇到了一群超级开明的老师——开明到什么程度？有的课不想上,老师说那就不上了。学校还给了他一个办公室，有空调有电脑，让他捣鼓喜欢的东西。

2009年，App Store出现。这对Peak来说是个转折点：

"在App Store之前，你瞎捣鼓的东西没法证明有价值。但App Store让我可以向父母、老师证明——我瞎搞的东西能产生经济价值。"

于是他做了猛犸浏览器（Mammoth Web Browser），定价1.99美元，最后赚了30多万美金。

有意思的是，当时国内没法付费，他就破解自己的软件，在国内论坛免费发。"国内赚不到钱，那就赚吆喝。"

高二高三的时候，他在中关村的一个创业活动上认识了真格基金。徐小平问他："小伙不错，你想创业吗？"

他说不想。"我边上学边躺着赚钱，为什么要创业？"

但回家跟父母一聊，又觉得这是个机会。最后他想通了：大学什么时候都能读，但机会成本不等人。于是拿了真格的投资，大学不上了，直接创业。

真格给了他一个承诺："不管你干什么。"这个承诺兑现至今。

2011年，他因为想解决"预测用户下一次点击"的问题，进入了自然语言处理（NLP）领域。从此一发不可收拾。

2014年，他开始做Magi——一个用AI自动构建知识图谱的搜索引擎。他想做下一代Google。

"我们选择了最苦的一条路：从零开始训模型，从爬虫到索引引擎全是自己写的。"

这个项目做了四年。期间经历了Word2Vec、LSTM、Transformer每一次技术迭代，每次都意味着之前的积累作废。"非常幸福，又非常不幸。"

但他们还是做出来了。和Google做过head to head对比，准确度89%+，比Google还高。

"那是我智力和我的编程能力的巅峰。我把我这辈子想试的技术，都以合理的方式花投资人的钱给搞定了。"

然后，2020年，GPT-3出现了。

"我拿到了GPT-3的early access，我觉得天要塌了。"

他随便写了个prompt，测了一下，发现效果跟自己团队做了好几年的模型五五开。

在GPT-3之前，NLP领域的人"泾渭分明"——做信息抽取的、做机器翻译的、做客服系统的，大家互相握手，"互相学习互相学习"。

GPT-3出来之后，"把那条心给摁死了"。因为它是一个通解。

Peak的第一反应是：赶紧卖掉公司。

他卖了。

"在那个项目做完的那一刻，我的人生已经圆满了。你知道吗？所以再后来像包括现在做Manus这些事，我心里已经没有什么就是那种——我要证明自己，或者我要做什么这个才能死而无憾。我早就无憾了。"

### "每天醒了，都感觉海水在上涨"

卖掉Magi之后，Peak去了一家独角兽公司打工。

那是一家to B的AI公司，内部有个打榜系统：研究员打榜赢显卡，赢得越多，显卡资源越多，然后你又能做更多实验。强者恒强。

"我一个人霸榜第一名，一年半。"

但他也想清楚了一件事："我根本不是做CEO的那块料。我既不喜欢商业化，我也很讨厌管人。"

所以当肖弘找到他的时候，他知道自己要的是什么——不是主导一家公司，而是找一块空的画布，做自己擅长的事。

2024年，在真格基金的撮合下，他加入蝴蝶效应，和肖弘、张涛组成核心团队。当时公司已经有了Monica——一个浏览器AI插件，是中国AI行业少有的盈利产品。

但Peak说，做AI创业的那种痛苦感又回来了：

"每天醒了之后，你都感觉海水在上涨，但是你不知道会涨到什么程度。也许你第二天醒的时候就已经到到鼻子这了。"

这是做AI创业最难受的状态：你在追一个永远在跑的目标。

所以这次他换了个思路：不做模型，做应用。

"我们其实是把模型训练这件事外包了出去。用户给我们的钱，同时服务了用户，且让我们有影响力，让别人帮我们训模型。"

听起来有点反直觉。大家都说做AI应用是"逆向工程"，没有护城河。但Peak不这么看：

"对我们来说不仅不是逆向工程，反而是在给别人带节奏。"

他举例：Gemini新出的"可控并行Function calling"，那个定义和schema是他写的。

"因为我们对于不同的场景使用不同的模型，所以没有关系，我们永远能够为用户提供所有人中最好的一个体验。"

### "悲观预期就是下个月死掉"

访谈最后，主持人问了两个问题。

第一个：你对Manus最乐观的预期是什么？

Peak说："我们希望让所有的有高价值工作的白领，都能获得一个7×24小时不断推理的AI伙伴。"

第二个：最悲观的预期呢？

"悲观预期就是下个月死掉。这个是所有创业公司一样的悲观预期。就是我刚才说的，我们没有权利活着，我们是在努力获得一个活着的权利。"

主持人问他：如果Manus下个月死了，你会去干嘛？

他说："我会歇一会，太累了。"

### 当Meta来敲门

访谈录制于12月1日。

12月30日，Meta宣布全资收购Manus。

这是Meta历史上第三大收购，仅次于WhatsApp和Scale.ai。整个谈判不到10天，快到"怀疑是不是假的offer"。

真格基金的刘元说："属于中国这一代年轻创业者的时代，已经到来。"

戴雨森说："他们不靠关系，不比资历，在全球舞台上光明正大同台竞技，做到了我们上一代创业者做不了甚至不敢想的事情。"

### 回看这期访谈

现在再看Peak在访谈中说的那些话，感觉完全不一样了。

"我们没有权利活着。"——他们获得了最强的活着的方式。

"悲观预期就是下个月死掉。"——结果下个月他们成了Meta的一部分。

"如果Manus下个月死了，我会歇一会。"——他没能歇，但应该是个好的"不能歇"。

"我早就无憾了。"——这句话在被收购的语境下，听起来像是一种松弛。

还有他评价肖弘的那句："他很正常，身心健全。"——在一个疯狂的行业里，"正常"反而成了稀缺品质。

### 尾声

Peak在访谈里说，他的事业"只能有三个月的视野"。

主持人问：10年后的AI世界你怎么想象？

他说："我不敢想象。"

2025年的AI创业者大概都是这样：看不清远方，但每天都在狂奔。

只是有的人跑着跑着，被Meta接住了。

本文基于张小郡播客《Manus决定出售前最后的访谈》整理

视频链接：https://www.bilibili.com/video/BV1knvYBDEjs
