# 写作风格指南

## 整体格式规范

### 行距规则
- **段落内**：不留空行，紧凑排列
- **段落之间**：留一个空行
- **章节之间**：用 `---` 分隔

### 文章结构
```
[开场介绍]

# 几个核心观点
[短文内容]

---

# 精华片段
[长文内容]

---

[结束语]
```

---

## 开场介绍（必须包含）

### 模板
```
今天看到[嘉宾]去了[播客/节目名称]的播客。花了[时间]听完了这期播客。干货太多了。

[嘉宾]是我[时间]见过的把"[核心主题]"这个问题讲得最透彻的人。[2-3句话介绍嘉宾的核心成就和背景，用具体数据]。[嘉宾的反差点或独特之处]。

这期播客的信息密度极高。我把全文精编出来，按主题重新组织，供大家学习。
```

### 示例
```
今天看到 Zara 去了十字路口的播客。花了一早上时间听完了这期播客。干货太多了。

Zara 是我2025见过的把"非技术背景如何在AI时代崛起"这个问题讲得最透彻的人。她的小红书一年从2万涨到18万粉丝，发了将近500篇内容，平均1.5天一篇。她今年转岗做产品经理，业余用Vibe Coding发布了自己第一个产品。她曾经在The Information做记者，在真格、GGV做过VC，现在在硅谷某互联网公司——但她本科是哈佛心理学专业，完全没有技术背景。

这期播客的信息密度极高。我把全文精编出来，按主题重新组织，供大家学习。
```

### 关键要素
- **具体数据**：粉丝数、内容数量、时间周期
- **反差点**：非技术背景但做技术产品、文科生但做AI
- **个人视角**："我见过的最..."、"花了一早上..."

---

## 结束语（必须包含）

### 模板
```
---

[嘉宾名字]凭[具体贡献]，[产生的影响]。[我个人的行动或感受]。

[引用一句有力的话或个人签名]来收个尾。希望大家能像这期播客反复讲的——[核心理念]。[最后一句升华]。
```

### 示例
```
---

Zara 凭一己之力，促进了小红书 AI 视频赛道的发展。每天我都能刷到许多人用和 Zara 一样的方式。也让我投身其中，以热爱、好奇、成长为目的而创作内容。

借用我自己在各个社交媒体的签名"Simple living，Lazy creating"来收个尾。希望大家能像这期播客反复讲的——积极行动但不用太卷、太焦虑。松弛感的关键是找到那个属于你自己的成长方式，在成长的过程中找到自己。
```

### 关键要素
- **嘉宾影响力**：具体说明ta改变了什么
- **个人连接**：我因此做了什么、学到了什么
- **金句收尾**：个人签名或播客核心理念
- **读者祝福**：希望大家...

---

## 短文风格（# 几个核心观点）

### 结构模式

```
[开场钩子：谁说了什么/发生了什么]

[核心洞察 1-2 个，简要解释]

[过渡语句：如"总结一下做个笔记👇"]

1. **关键词**：一句话洞察
2. **关键词**：一句话洞察
3. **关键词**：一句话洞察
...
[8-12 条]

---
```

### 关键特征

- **长度**：600-1000 字（列表部分）
- **开场**：直接点出主题人物/事件，吸引注意
- **核心洞察**：1-2 个关键思考，解释为什么重要
- **要点列表**：使用 `1.` `2.` `3.` 数字格式（不用emoji）
- **每条格式**：`**加粗关键词**：一句话洞察`
- **结尾**：用分隔线 `---` 收尾

### 列表格式规则（重要）

**为什么不用 emoji 数字（1️⃣2️⃣...）：**
- 超过10条后视觉不统一（如 1️⃣0️⃣ 或 1️⃣1️⃣ 看起来乱）
- 占用更多字符
- 在某些平台渲染不一致

**正确格式示例：**
```
1. **咖啡因机制**：它不是给你能量，而是"抢椅子"——占据腺苷受体但不激活，让大脑不知道你已经累了
2. **睡前酒精**：不是"助眠"而是"镇静"，酒精敲晕大脑皮层的脑电波和自然入睡完全不同
3. **REM与寿命**：每减少5%的REM睡眠，死亡风险增加约13%，是线性关系
```

**错误格式示例：**
```
1️⃣ 咖啡因不是给你能量，而是"抢椅子"——它占据腺苷受体但不激活，让大脑不知道你已经醒了16小时。咖啡因退去后，所有累积的腺苷一起涌来，这就是"咖啡因崩溃"。
```
（问题：没有加粗关键词、内容太长、emoji数字）

### 写作原则

1. **可扫读**：加粗关键词让读者一眼抓住主题
2. **可分享**：每条独立成句，适合截图转发
3. **精炼**：每条1-2句话，不超过50字
4. **有料**：具体数据、人名、百分比，不说空话
5. **质量优先**：8-12条精选，不要15+条稀释

### 避免

- ❌ 每条太长（超过50字）
- ❌ 使用 emoji 数字（1️⃣2️⃣...）
- ❌ 缺少加粗关键词开头
- ❌ 堆砌太多条目（超过12条）
- ❌ 空泛表述（"很重要"、"非常有用"）
- ❌ 遗漏具体数据

---

## 长文风格（对话式访谈整理）

### 两种长文风格

**风格A：叙事性文章**（原有风格，适合单人演讲、独白内容）
**风格B：对话式访谈**（新增风格，适合播客、访谈、对话内容）

---

### 风格A：叙事性文章

#### 结构模式

```
[引人入胜的标题]

[开场：设置场景/背景]

### [章节标题 1：背景故事]
"[关键引语]"
[背景分析和上下文]

### [章节标题 2：主要内容]
[故事发展，穿插引语和洞察]

### [章节标题 3：关键时刻]
[戏剧性高潮]

### [章节标题 4：转折点]
"[关键引语]"
[分析意义]

### [尾声：反思或反转]
[事后发生了什么/这意味着什么]

[可选：来源说明]
```

#### 关键特征

- **长度**：1500-3000+ 字
- **标题**：抓眼球，概括核心戏剧性
- **章节标题**：引导阅读，提供导航
- **引语**：直接引用原文，让人物"说话"
- **叙事弧线**：设置 → 发展 → 高潮 → 解决
- **戏剧性反转**：如"他不知道的是..." / "He didn't know that..."
- **具体细节**：名字、数字、时间、地点

#### 写作原则

1. **讲故事，不只是总结**：找到内容中的故事线
2. **保留原声**：用引语让读者听到当事人的声音
3. **提供背景**：解释为什么这些事重要
4. **制造悬念**：适当使用时间倒叙或对比
5. **人性化细节**：脆弱、幽默、真实的时刻
6. **戏剧性对比**：当时的想法 vs. 后来的结果

#### 避免

- 不要线性流水账式总结
- 不要丢失人物的个性和语气
- 不要添加源材料中没有的信息
- 不要使用 AI 式的套话

---

### 风格B：对话式访谈整理

**适用场景**：播客访谈、对话类内容、多人讨论

#### 结构模式

```
[前言/导语 - 编辑者视角的开场白]
断断续续，终于看完了...[简短个人感受]
干货很多。[核心人物]可能是...[定位和评价]
[为什么值得关注，为什么整理这篇内容]
我今天不忙，把这次访谈全文精编出来，供大家学习。赠人玫瑰，手有余香。
[可选：提前祝大家XX快乐]
下面是 YouTube 链接：https://...

#01 [第一个主题 - 简短有力的标题]
主持人：[对话形式的开场提问]
嘉宾：[直接引用回答，保留对话感]

[编辑者的补充说明、数据解读、背景信息]
[可以插入"我觉得这个点真的太重要了"等个人观点]

主持人：[继续追问]
嘉宾：[继续回答]

[继续分析和延伸]

#02 [第二个主题]
主持人：[继续对话]
嘉宾：[回答]

[分析和延伸]
[可以加入"这太有意思了""太离谱了"等口语化反应]

#03 [第三个主题]
...
```

#### 关键特征

- **长度**：3000-8000+ 字（取决于访谈长度）
- **开场**：编辑者第一人称，表达"断断续续看完"的真实感，像朋友推荐
- **语气**：口语化、对话感强，像在和朋友转述精彩内容
- **结构**：用 #01 #02 #03 等编号 + 主题标题做章节分隔
- **对话体**："主持人：" "嘉宾：" 的格式保留访谈原味
- **编辑介入**：在对话之间插入编辑者的观察、补充、个人反应
- **链接引用**：适当插入"文章链接：https://..." 作为延伸阅读
- **口语化**："太离谱了" "我觉得" "真的" "完全" "非常" 等日常用语
- **具体细节**：大量保留数字、人名、公司名、具体案例

#### 写作原则

1. **保持对话原貌**：用"主持人：" "嘉宾："格式，让读者听到真实交流
2. **编辑者在场感**：适时以第一人称（"我觉得""让我惊讶的是"）点评
3. **主题化分段**：不按时间线，而是按话题重组，每个话题独立成章
4. **口语化表达**：
   - "太有意思了" "这真的很重要" "我必须问一句"
   - "天哪" "哇塞" "完全是这样"
   - "说实话" "坦白说" "老实说"
5. **数据具体化**：不说"增长很快"，说"7个月做到1亿，4个月做到2亿"
6. **补充背景**：在对话后加编辑说明，帮读者理解上下文
7. **真实感**："断断续续看完" "今天不忙，精编出来" 体现真人在整理
8. **结尾人情味**："赠人玫瑰，手有余香" "提前祝大家新年快乐"

#### 标题风格

- 章节标题要简洁有力，直接点出主题
- 例如："#01 Lovable 的规模与增长情况"
- 例如："#02 Lovable 的商业模式"
- 例如："#05 怎么招聘到优秀人才？"
- 不用华丽修辞，用最直白的方式概括

#### 对话 + 解读的平衡

好的对话式长文应该是：
- 60-70% 是保留原味的对话
- 20-30% 是编辑者的分析、补充、链接
- 10% 是过渡和结构化组织

这样既保留了访谈的真实性，又提供了编辑的增值

#### 避免

- 不要纯粹做访谈实录，要有编辑视角的重组和提炼
- 不要丢失对话的口语化和随意感
- 不要过度修饰，保持"整理笔记"的质朴感
- 不要省略具体数据和案例
- 不要使用过于正式的书面语
- 不要像写新闻稿，要像朋友在分享干货

---

## 通用原则

### 提取什么

1. **深层洞察**（最重要 - 避免浅层观察）：
   - **反直觉的观点**：挑战常识的观点
   - **思维模型**：决策背后的框架和原则
   - **二阶思考**：不只是"发生了什么"，而是"这揭示了什么深层规律"
   - **悖论和张力**：矛盾之处往往揭示深层哲学
   - **战略智慧**：具体战术如何体现更大的战略原则
2. **实用智慧带WHY**：不只是"做X"，而是"X体现了原则Y"
3. **金句**：能概括大想法或哲学立场的句子
4. **转折点**：认知或范式的根本转变
5. **人性时刻**：脆弱、幽默、真实（揭示性格和价值观）
6. **语境反转**：当时不知道 vs. 现在知道

### 语气与风格

- **对话式但有洞察**：像在跟聪明朋友解释
- **展示，不说教**：用引语证明观点
- **尊重源材料**：不歪曲或过度解读
- **找到故事**：每段内容都有叙事弧线

### 实操建议

1. **完整消化内容**：不要浅尝辄止
2. **识别核心叙事**：主要故事是什么？
3. **提取引语和事实**：有力的引语、具体数字、细节
4. **构建两个版本**：
   - 短版：什么能让人点击/分享？
   - 长版：完整故事值得怎么讲？
5. **打磨清晰度**：
   - 去掉行话（除非必要）
   - 确保逻辑流畅
   - 核实引语准确
   - 验证叙事独立完整
