---
name: content-topic-generator
description: 从文章、推文、社交媒体内容生成多角度选题，包括推文选题（140字完整内容）和公众号选题（含详细大纲）。支持延伸、反驳、扩充、热点结合四种策略。当用户需要基于现有内容创作新选题、分析文章生成衍生内容、或进行内容再创作时使用。适用场景：(1) 分析推文/文章并生成选题，(2) 创建公众号/社交媒体内容策划，(3) 将长文拆解为多个传播点，(4) 内容营销和话题策划。
---

# Content Topic Generator

从文章和推文生成高质量选题，包括即发推文内容和深度文章大纲。

## 核心能力

1. **推文选题生成** - 生成140字以内的完整推文内容
2. **公众号选题生成** - 生成详细的文章标题和大纲
3. **多角度策略** - 延伸、反驳、扩充、热点结合四种创作方向
4. **读者视角** - 从吸引力和传播力角度设计选题

## 工作流程

### 第一步：分析原始内容

读取用户提供的文章或推文，提取：
- **核心观点**：主要论点是什么
- **关键信息**：数据、案例、金句
- **讨论空间**：可延伸/反驳/扩充的点
- **热点关联**：是否可结合时事/节日/行业事件

### 第二步：选择创作策略

根据内容特点选择1-4种策略（详见 `references/topic-strategies.md`）：

**延伸策略** - 原观点基础上深化或拓展
- 适合：信息密度高但未充分展开的内容
- 例：原文讲AI工具 → 延伸为AI工具使用的心理学原理

**反驳策略** - 提出相反或不同角度的观点
- 适合：有争议性、存在片面性的观点
- 例：原文说AI降低门槛 → 反驳为AI实际上提高了竞争门槛

**扩充策略** - 对某个点进行深度展开
- 适合：提到了点但未详细说明的内容
- 例：原文提到Gemini提示词 → 扩充为10个提示词完整教程

**热点结合策略** - 与时事热点/节日结合
- 适合：可与当前热点关联的主题
- 例：原文讲副业 → 结合元旦做新年规划话题

### 第三步：生成推文选题

为每个策略生成推文内容（使用 `assets/template-tweet.txt` 模板）：

**要求：**
- 严格控制在140字以内（中文字符）
- 开头3秒内抓住注意力
- 包含明确的观点或价值
- 设计互动点（让人想点赞/评论/转发）

**质量标准：**
- 信息密度高，无废话
- 有具体性（数据/案例优于泛泛而谈）
- 制造悬念或行动召唤
- 符合社交媒体语言风格

**参考写作准则：** `references/writing-guidelines.md` 的推文部分

### 第四步：生成公众号选题

为每个策略生成文章大纲（使用 `assets/template-article.txt` 模板）：

**标题要求：**
- 吸引力强，让人想点开
- 优先使用数字型/反差型/疑问型标题
- 清晰传达文章价值

**大纲要求：**
- 结构清晰，5-7个章节
- 每个章节标注字数和核心论点
- 包含支撑材料（数据/案例/引用）
- 总字数1500-3000字（可根据内容调整）

**必须包含：**
- 开篇：说明为什么要读
- 主体：分点论述/教程步骤/案例分析
- 结尾：总结 + 行动号召

**参考写作准则：** `references/writing-guidelines.md` 的公众号部分

### 第五步：输出结果

按以下格式输出完整选题：

```markdown
# {原文标题/主题} - 选题分析

## 原文核心信息

**核心观点：** {一句话总结}
**关键信息：** {数据/案例/金句}
**内容类型：** {观点/教程/案例/分析}

---

## 推文选题（{N}条）

### 推文 #1 - {策略名称}

**策略：** 延伸/反驳/扩充/热点结合
**核心角度：** {这条推文的独特视角}
**目标读者：** {面向谁}

**推文内容（{X}/140字）：**

{完整的推文正文}

**预期效果：**
- 互动点：{为什么读者会互动}
- 情绪共鸣：{触发什么情绪}
- 行动引导：{希望读者做什么}

---

## 公众号选题（{N}篇）

### 选题 #1 - {策略名称}

**策略：** 延伸/反驳/扩充/热点结合
**标题：** 《{标题}》
**目标读者：** {面向谁}
**核心价值：** {读完能获得什么}
**预估字数：** {字数}
**内容定位：** {深度分析/实操教程/观点评论}

#### 文章大纲

**一、{章节标题}（{字数}字）**
- 核心论点：{关键信息}
- 要点：{列出2-3个要点}
- 支撑材料：{数据/案例}

**二、{章节标题}（{字数}字）**
...

**{结尾章节}**
- 总结要点
- 行动号召

---

**内容增强建议：**
- 需要补充的素材：{数据/采访/测试}
- SEO关键词：{关键词列表}
- 适合平台：{公众号/知乎/小红书}
- 传播力预估：{高/中/低}
```

## 使用示例

### 示例 1：基于推文生成选题

**用户输入：**
```
分析这条推文并生成选题：
"看到一个人在用ChatGPT写代码，我从他身后走过，他连忙把浏览器关闭了……唉，马上都2026年了，就不能大大方方地用AI吗？"
```

**输出：**
- 3条推文选题（延伸、反驳、热点结合）
- 2个公众号选题（深度分析、观点评论）

### 示例 2：基于文章生成选题

**用户输入：**
```
我有一篇关于"未来五年小个体赚钱十大红利"的文章，帮我生成：
- 5条推文，每条聚焦一个红利点
- 2个公众号深度选题
```

**输出：**
- 5条推文，每条深挖一个红利（扩充策略）
- 1个反驳类文章：为什么这些红利可能是陷阱
- 1个扩充类文章：第一个红利的完整实操指南

### 示例 3：定制化选题生成

**用户输入：**
```
基于这3条推文，只生成"反驳"策略的选题，要能引发讨论
```

**输出：**
- 针对性地使用反驳策略
- 强调争议点和讨论空间
- 设计互动性强的推文和话题

## 质量控制清单

生成每个选题后，自检：

**推文检查：**
- [ ] 字数≤140字
- [ ] 开头是否吸引人
- [ ] 是否有明确观点/价值
- [ ] 是否设计了互动点

**公众号大纲检查：**
- [ ] 标题是否吸引人
- [ ] 大纲结构是否清晰
- [ ] 是否有具体支撑材料
- [ ] 总字数估算是否合理
- [ ] 是否有行动号召

**读者视角检查：**
- [ ] 为什么读者要看这个内容
- [ ] 读完能获得什么
- [ ] 是否有分享/转发的动机

## 进阶技巧

### 策略组合

针对同一内容，可以组合使用策略：
- **高传播组合**：反驳 + 热点结合
- **深度价值组合**：延伸 + 扩充
- **快速产出组合**：延伸 + 热点结合

### 多平台适配

不同平台调整风格：
- **Twitter/X**：观点犀利，数据具体
- **微博**：情绪化，易传播
- **小红书**：生活化，视觉化
- **知乎**：专业性，逻辑性

### 系列选题规划

将一个大主题拆解为系列内容：
1. 第一篇：总览/现象观察
2. 第二篇：深度分析/方法论
3. 第三篇：案例详解/实操指南
4. 第四篇：进阶/未来趋势

## 常见问题

**Q：如何判断用哪种策略？**
A：优先级：扩充（有具体需求点）> 反驳（有争议性）> 延伸（需要深化）> 热点结合（有时效性）

**Q：推文超过140字怎么办？**
A：删除虚词、合并同义表达、用标点替代连词、保留最核心观点

**Q：大纲需要多详细？**
A：每个章节要有核心论点和要点列表，支撑材料可以是建议（待补充）

**Q：如何提高选题吸引力？**
A：使用具体数字、制造反差、提出反常识观点、结合热点、设计悬念

## 参考资源

- **策略详解**：`references/topic-strategies.md` - 四大策略的完整说明和案例
- **写作准则**：`references/writing-guidelines.md` - 推文和公众号的写作标准
- **推文模板**：`assets/template-tweet.txt` - 推文输出格式模板
- **文章模板**：`assets/template-article.txt` - 公众号大纲格式模板
