# 内容创作准则

## 推文创作准则（140字限制）

### 结构模板

**1. 钩子式（Hook）**
```
第一句：反常识观点/惊人数据/提问
第二句：解释或论证
第三句：行动号召/悬念
```

**2. 对比式（Contrast）**
```
前半部分：传统观点/问题现状
转折词：但是/真相是/其实
后半部分：新观点/解决方案
```

**3. 清单式（List）**
```
引言：主题陈述
核心：3-5个要点（用emoji或数字）
结尾：总结或悬念
```

### 写作技巧

**强吸引力开头：**
- ❌ "今天分享一个AI工具使用技巧"
- ✅ "测试100次后发现，90%的人都用错了ChatGPT"

**制造悬念：**
- ❌ "这是我的三个方法"
- ✅ "第三个方法让我收入翻倍（明天公开）"

**数据具体化：**
- ❌ "很多人"
- ✅ "73%的职场人"

**行动号召：**
- ❌ "希望对你有帮助"
- ✅ "收藏这条，明天用得上"

### 字数控制

- **Twitter/X**: 280字符（约140汉字）
- **微博**: 140字
- **小红书**: 建议80-120字（首屏显示）

**精简技巧：**
1. 删除"的/地/得"等虚词
2. 合并同义表达
3. 用标点替代连词
4. 数字和emoji节省字数

---

## 公众号大纲准则

### 标题公式

**1. 数字型**
```
N个{方法/技巧/真相}，{解决问题/实现目标}
例：5个AI工具，让你的工作效率提升300%
```

**2. 反差型**
```
{常见认知} ，但{真相/反转}
例：人人都在用AI，为什么你越用越焦虑？
```

**3. 场景型**
```
{时间/身份/场景}，{问题/解决方案}
例：2026年第一个工作日，给你的副业算笔账
```

**4. 疑问型**
```
为什么{现象}？/{问题}怎么办？
例：为什么AI内容泛滥，好内容反而更稀缺？
```

### 大纲结构

**标准五段式：**
```
1. 开篇（10%）：问题/现象/故事切入
2. 分析（30%）：拆解问题，提供洞察
3. 方法（40%）：具体解决方案/案例
4. 案例/数据（15%）：佐证和深化
5. 结尾（5%）：总结/行动号召
```

**深度分析型：**
```
1. 现象观察（15%）
2. 问题本质（25%）
3. 多角度分析（30%）
4. 趋势预判（20%）
5. 个人思考（10%）
```

**实操教程型：**
```
1. 为什么要学（10%）
2. 核心原理（20%）
3. 分步教程（50%）
4. 常见问题（15%）
5. 进阶资源（5%）
```

### 大纲要素

每个章节应包含：
- **章节主题**：清晰的小标题
- **核心论点**：这一节要传达的关键信息
- **支撑材料**：数据/案例/引用/截图
- **字数估算**：控制节奏和篇幅

**示例：**
```
## 2. AI工具的三个认知误区（800字）

核心论点：大多数人对AI工具的理解停留在表面

2.1 误区一：AI能替代思考（300字）
- 案例：某公司全员用AI写方案的失败案例
- 数据：AI生成内容的同质化率达85%

2.2 误区二：会用工具就够了（250字）
- 对比：工具熟练度 vs 问题定义能力
- 引用：OpenAI CEO关于prompt工程的观点

2.3 误区三：AI会让人变懒（250字）
- 反驳：AI实际上提高了工作标准
- 案例：顶尖程序员如何用AI提升代码质量
```

### 内容密度控制

**高密度内容（适合专业读者）：**
- 信息量：每100字≥3个知识点
- 案例：具体、有数据
- 结构：清晰、可跳读

**中密度内容（适合大众读者）：**
- 信息量：每100字1-2个知识点
- 案例：故事化、有共鸣
- 结构：叙事性强

**低密度内容（适合轻松阅读）：**
- 信息量：每100字≤1个知识点
- 案例：趣味化、接地气
- 结构：对话式、场景化

---

## 读者视角检查清单

创作完成后，用以下问题检验：

### 推文检查
- [ ] 前3秒能否吸引注意力？
- [ ] 是否有明确的takeaway？
- [ ] 是否有互动点（点赞/评论/转发的理由）？
- [ ] 字数是否在限制内？
- [ ] 是否有错别字？

### 公众号大纲检查
- [ ] 标题是否足够吸引人？
- [ ] 开篇能否在30秒内说明"为什么要读"？
- [ ] 每个章节的价值是否清晰？
- [ ] 是否有具体案例或数据支撑？
- [ ] 结构是否便于跳读？
- [ ] 是否有明确的行动号召？
- [ ] 总字数是否符合定位（深度3000+/中度1500-2500/轻度800-1500）？
