---
name: doc-coauthoring
description: Guide users through a structured workflow for co-authoring documentation, articles, or long-form content. Use when user wants to write documentation, proposals, articles, or similar structured content. This workflow helps users efficiently transfer context, refine content through iteration, and verify the doc works for readers. Trigger when user mentions writing docs, creating proposals, drafting articles, or using "co-authoring" workflow.
---

# Doc Co-Authoring Workflow

协作式文档创作工作流。三个阶段：Context Gathering → Refinement & Structure → Reader Testing。

## When to Offer This Workflow

**触发条件：**

- 用户提到写文章、写文档、co-authoring
- 用户提供素材并要求创作内容

**简短说明流程后直接开始，不要过度解释。**

## Stage 1: Context Gathering

**目标：** 快速获取足够上下文，包括内容方向和写作风格。

### 元信息（必问）

1. 文档类型？（公众号/小红书/技术文档/提案）
2. 目标读者？
3. 读完后的预期效果？
4. 你的个人观点/角度？
5. 篇幅和风格？

### 写作风格偏好（必问）

**关键：提前确认风格，避免后续反复修改。**

询问用户：

- 有参考资料吗？（如有，先分析其风格并遵循）
- 偏简洁还是详细？
- 有什么写作习惯需要遵守？

### 参考资料风格分析

**如果用户提供了参考资料：**

先读取并分析其写作风格：

- 句式特点（短句为主？长句为主？）
- 结构方式（有无小标题？段落长度？）
- 语气（口语化？正式？）
- 避免的模式

分析完成后告知用户："参考资料风格已学习，后续写作会遵循。"

### 常见写作反模式（默认避免）

除非用户明确要求，否则避免：

1. **自问自答句式**：❌ "这意味着什么？它意味着..." → ✅ 直接陈述
2. **过度对比**：❌ "不是...而是..." 连用多次 → ✅ 直接说是什么
3. **小标题分割案例**：❌ 每个案例都加粗标题 → ✅ 合并流畅叙述
4. **设问开头**：❌ "为什么会这样？" → ✅ 直接说原因
5. **重复总结**：❌ "总之、综上所述、这意味着" → ✅ 省略或精简
6. **过度解释**：❌ 每个概念都展开说明 → ✅ 假设读者有基础

**用户说"太啰嗦"时，立刻精简，不要解释。**

### 素材处理

**如果用户提供了素材文件：**

- 直接读取
- 提取关键信息
- 不要过度询问，直接进入下一阶段

**如果需要补充信息：**

- 可以搜索互联网获取热门观点、案例、数据
- 主动搜索，不要每次都问"要不要搜索"

### 退出条件

用户回答完元信息问题后，直接进入 Stage 2，不要反复确认。

## Stage 2: Refinement & Structure

**目标：** 逐章节头脑风暴、筛选、撰写、迭代。

### 确定结构

根据文档类型建议 3-6 个章节，创建文件框架（Markdown 文件），用 `[待撰写]` 占位。

### 每章节流程

**Step 1: 头脑风暴**

列出 8-15 个可能包含的点，编号呈现。

```
**N 个可能包含的点：**
1. xxx
2. xxx
...

**保留哪些？** 比如：`1、3、5、7`
```

**Step 2: 筛选**

用户回复选择后：

- 如果用户说"全部"或"1-N"：直接全部采用，不再确认
- 如果用户选择部分：只用选中的
- 不要追问"确定吗"，直接进入撰写

**Step 3: 撰写**

根据筛选结果撰写该章节，直接更新文件。

撰写完成后：

- 展示该章节内容（引用块格式）
- 简短询问："有想改的吗？没问题就「继续」"

**Step 4: 迭代**

用户反馈处理规则：

| 用户说        | 行动                 |
| ------------- | -------------------- |
| "继续"        | 进入下一章节         |
| "太啰嗦"      | 立刻精简，不解释     |
| "不要xxx句式" | 记住，后续章节也遵守 |
| 具体修改意见  | 执行修改，展示结果   |

**迭代要快。** 用户给反馈后立刻改，改完立刻展示，不要长篇解释。

### 风格学习

在迭代过程中记住用户的风格偏好：

- 用户删掉了什么 → 后续避免
- 用户说"太啰嗦" → 后续更精简
- 用户说"不要自问自答" → 所有章节都避免

### 完成所有章节后

输出全文供用户通读，询问是否需要调整。

## Stage 3: Reader Testing（可选）

**目标：** 用新鲜视角检查文档是否清晰。

仅当用户要求时执行，或文档较长/较复杂时建议。

### 执行方式

1. 预测读者可能的问题（5-10 个）
2. 用 sub-agent 或建议用户开新对话测试
3. 发现问题则回到 Stage 2 修复

---

## 核心原则

### 效率优先

- 不要反复确认，用户说了就执行
- 头脑风暴后用户选"全部"就直接用
- 迭代要快，改完就展示

### 风格一致

- 第一章确定的风格，后续章节都遵守
- 用户的修改反馈要记住，举一反三

### 精简表达

- 展示内容用引用块，简洁
- 过渡语一句话："继续？" "有想改的吗？"
- 不要长篇解释流程

### 常见反馈的快速响应

| 用户说         | 立刻做               |
| -------------- | -------------------- |
| "太啰嗦"       | 精简 50%，不解释     |
| "不要自问自答" | 重写，去掉所有设问句 |
| "合并起来写"   | 去掉小标题，流畅叙述 |
| "继续"         | 下一章节             |
| "输出全文"     | 读取文件，完整展示   |
