---
name: mem-file-scan
description: AI个人记忆系统的文件扫描回顾功能。扫描Obsidian仓库中本周修改的文件（排除AI_MEMORY目录），识别潜在的重要事件和决策。使用场景：(1) 用户说"文件扫描"、"查看本周文件"、"扫描文件变化"时；(2) 周复盘时补充L1记录前；(3) 用户想回顾本周在Obsidian中的活动时。该skill会列出修改的文件，询问用户哪些需要记录到L1，并辅助记录。
---

# Mem File Scan

## Overview

扫描Obsidian仓库中本周修改的文件，帮助用户补充记录到L1情境层。解决AI记忆系统只能记录Claude对话内容，无法捕获用户在Obsidian中其他活动的问题。

## 触发时机

- 用户主动请求："文件扫描"、"查看本周文件"、"扫描文件变化"
- 周复盘流程开始时（可在周复盘前自动调用）
- 用户想回顾本周在Obsidian中的活动

## 工作流程

### 第一步：确定本周时间范围

计算本周的日期范围：
- 如果是周日或周日之后：本周一（00:00）至现在
- 如果是周日之前：上周一（00:00）至上周日（23:59）

示例：
```bash
# 获取本周日期范围
今天是：2025-12-27（周五）
本周范围：2025-12-22（周一）至 2025-12-27（今天）
```

### 第二步：扫描修改的文件

使用Bash工具查找本周修改的文件：

```bash
# 查找本周修改的.md文件
# 排除AI_MEMORY目录（因为那是记忆系统本身）
# 排除.obsidian、.trash等系统目录

find . -name "*.md" -type f -newermt "2025-12-22" ! -newermt "2025-12-28" \
  ! -path "./AI_MEMORY/*" \
  ! -path "./.obsidian/*" \
  ! -path "./.trash/*" \
  ! -path "./.claude/*"
```

**注意**：
- `! -path "./AI_MEMORY/*"` 排除记忆系统本身
- 根据实际日期调整 `-newermt` 参数
- 使用`find`命令的`-newermt`选项查找修改时间

### 第三步：展示文件列表并询问

将找到的文件分类展示给用户：

```
📂 本周文件扫描结果（12-22 至 12-27）

━━━━━━━━━━━━━━━━━━━━━━━━
发现 {N} 个修改的文件：

📅 Daily日记类（X个）：
- Daily/2025-12-22.md
- Daily/2025-12-25.md

📝 项目文档类（X个）：
- Projects/项目A/进展.md
- Projects/项目B/会议记录.md

📚 学习笔记类（X个）：
- Learning/Python/装饰器.md

🎯 其他（X个）：
- ...

━━━━━━━━━━━━━━━━━━━━━━━━

接下来，我会帮你从这些文件中提取可能需要记录到L1的内容。

请告诉我：
1. 你希望我从哪些文件开始？（可以说"全部"、"从Daily开始"或指定具体文件）
2. 或者你可以直接告诉我哪些文件里包含重要事件/决策/偏好
```

### 第四步：读取并分析文件

根据用户选择，逐个读取文件并分析：

使用Read工具读取文件，寻找以下关键信息：

**🎯 识别重点**：
1. **重要决策**：技术选型、工具选择、方向调整
2. **情绪记录**：明显的情绪表达（兴奋、焦虑、成就感等）
3. **新项目/新习惯**：开始新项目、建立新习惯
4. **重复行为**：3次以上的相似活动
5. **偏好表达**：明确的喜欢/不喜欢表述
6. **待办事项**：重要但未完成的事项
7. **有意义的资料收集**：
   - 与当前项目/系统强相关的学习资料
   - 反映新兴趣方向的资料收集
   - 可能暗示潜在改进意图的资料（如刚创建系统后就收集相关综述）

**⚠️ 忽略内容**：
- 偶然保存的无关文章（与当前兴趣/项目无关）
- 纯粹的临时笔记（无后续行动）
- 代码片段（除非是重要学习成果）
- 已记录到L1的内容

### 第五步：生成候选记录列表

对每个文件，生成候选记录：

```
📄 文件：Daily/2025-12-25.md

━━━━━━━━━━━━━━━━━━━━━━━━
发现以下可能需要记录的内容：

1️⃣ 【重要决策】选择Python作为后端语言
   - 内容：讨论了技术栈，最终决定用Python
   - 你的考虑：团队熟悉、生态丰富
   - 情绪：安心
   - 是否记录到L1？ [ ] 是  [ ] 否  [ ] 修改后记录

2️⃣ 【日常事件】完成了用户认证模块
   - 内容：实现了登录、注册功能
   - 是否记录到L1？ [ ] 是  [ ] 否

━━━━━━━━━━━━━━━━━━━━━━━━
```

### 第六步：等待用户确认并记录到L1

根据用户确认，使用mem-record skill记录到L1：

**如果用户选择"是"**：
```
调用 mem-record skill，传入提取的内容
```

**如果用户选择"修改后记录"**：
```
询问用户如何修改
根据用户反馈调整内容
调用 mem-record skill
```

**如果用户选择"否"**：
```
跳过，继续下一个
```

### 第七步：汇总记录结果

所有文件处理完成后，输出汇总：

```
✅ 文件扫描回顾完成！

━━━━━━━━━━━━━━━━━━━━━━━━
📊 本次扫描统计：
- 扫描文件数：{X}个
- 识别候选：{Y}条
- 成功记录到L1：{Z}条

📝 记录详情：
1. ✅ 技术选型决策 → L1_情境层/2025-12.md
2. ✅ 完成用户认证 → L1_情境层/2025-12.md
3. ⏭️ 跳过：日常琐事

━━━━━━━━━━━━━━━━━━━━━━━━
💡 建议：
- 这些新记录将在下次周复盘时参与行为模式分析
- 继续保持记录习惯，让记忆系统更全面地了解你
```

## 注意事项

### 文件排除规则

始终排除以下目录和文件：
- `AI_MEMORY/` - 记忆系统本身
- `.obsidian/` - Obsidian配置
- `.trash/` - 已删除文件
- `.claude/` - Claude Code配置
- 任何隐藏文件/目录（以`.`开头）

### 智能识别优先级

按以下优先级识别：
1. **决策** > 日常事件
2. **情绪** > 纯事实
3. **新项目/新习惯** > 常规活动
4. **重复行为** > 偶发事件

### 记录密度控制

- 不要过度记录：琐碎的日常琐事无需记录
- 聚焦重要事件：决策、情绪、偏好、模式
- 尊重用户选择：由用户决定哪些值得记录

## 与其他skills的协作

### 与mem-record协作

本skill识别出需要记录的内容后，调用mem-record skill进行实际记录：

```
[mem-file-scan] 识别候选 → [用户确认] → [mem-record] 执行记录
```

### 与mem-weekly协作

在周复盘流程中，可以在分析L1记录之前调用本skill：

```
[周复盘开始]
  ↓
[mem-file-scan] 扫描本周文件，补充L1
  ↓
[mem-weekly] 分析L1，识别行为模式
```

## 错误处理

### 没有找到修改的文件

```
本周未发现修改的文件（排除AI_MEMORY目录）。

可能原因：
1. 本周主要在Claude中对话，较少直接编辑Obsidian
2. 文件修改时间未在本周范围内

建议：
- 继续使用mem-record记录日常对话
- 下周再尝试文件扫描
```

### 文件过大或格式异常

```
⚠️ 文件 {filename} 过大或格式异常，跳过分析

你可以：
1. 手动告诉我这个文件里的重要内容
2. 继续处理其他文件
```

## 示例对话

### 用户主动触发

```
用户：文件扫描

Claude：[调用mem-file-scan]
  📂 本周文件扫描结果（12-22 至 12-27）
  发现 5 个修改的文件...
  [后续流程]
```

### 周复盘时自动调用

```
用户：周复盘

Claude：[先调用mem-file-scan]
  在开始周复盘前，让我先扫描一下本周修改的文件...
  [扫描流程]
  ✅ 补充记录完成

  [然后调用mem-weekly]
  现在开始周复盘分析...
```
