---
name: mem-monthly
description: AI个人记忆系统的月度复盘功能。分析本月L2行为层更新，提炼思维模式到L3认知层，检查L4核心层是否需要校准。使用场景：(1) 用户说"月复盘"时；(2) 每月末定期回顾时；(3) 需要从行为模式提炼认知框架时。该skill会分析多个行为是否指向同一思维原则，尝试提炼到L3，并引导用户反思L4核心层。
---

# 月复盘

## 快速开始

当用户说"月复盘"时，执行以下流程：

1. **读取本月L2更新** - 获取行为层的所有更新
2. **分析思维模式** - 识别行为背后的共同原则
3. **提炼到L3** - 尝试创建认知框架
4. **检查L4校准** - 评估核心层是否需要更新
5. **生成月报** - 输出月度复盘报告

## 工作流程

### 第一步：读取本月L2更新

读取 `AI_MEMORY/L2_行为层/` 下所有文件，提取本月更新的内容。

### 第二步：分析思维模式

**寻找共同原则**：
- 多个行为是否指向同一决策框架？
- 多个偏好是否体现同一思维模型？
- 多个习惯是否基于同一认知原则？

**示例**：
```
行为1：处理复杂任务前先用思维导图
行为2：做决策时会列出所有选项
行为3：解决问题时用MECE原则

→ 共同原则：系统性思考
→ 记录到 L3_认知层/决策框架.md
```

### 第三步：提炼到L3

如果发现共同的思维原则，创建或更新L3文件：

```markdown
## {认知框架名称}

### 描述
{这个思维模式的描述}

### 来源行为
- {行为1}
- {行为2}
- {行为3}

### 提炼日期
{日期}

### 应用场景
{何时使用这个框架}
```

### 第四步：检查L4校准

评估L4核心层：
- 最近3个月有更新吗？
- 本月的行为是否与价值观一致？
- 是否有价值观冲突的迹象？

如果需要更新：
```
⚠️ L4核心层建议回顾

原因：
- [原因1]
- [原因2]

建议：
手动回顾 L4_核心层/核心价值观.md
```

### 第五步：生成月报

```
📊 {月份}记忆系统月报

━━━━━━━━━━━━━━━━━━━━━━━━
📈 系统健康度：{评分}分

✅ 本月新增：
- L1情境记录：{X}条
- L2行为模式：{X}个
- L3认知框架：{X}个

⚠️ 需要关注：
- L4_核心层已{X}个月未更新
- 建议：{建议}

━━━━━━━━━━━━━━━━━━━━━━━━
🧠 提炼出的认知模式：

"{模式名称}"
- 来源行为：{行为列表}
- 首次出现：{日期}
- 稳定性：{高/中/低}
- 建议：记录到 L3_认知层/{文件}.md

你的选择：[ ] 确认记录  [ ] 需要修改

━━━━━━━━━━━━━━━━━━━━━━━━
🎯 下月建议：
1.
2.
3.
```

## 完成后操作

更新 `AI_MEMORY/Meta/复盘记录.md` 的月复盘部分。

## L4更新流程

**⚠️ L4只能手动修改**

如果检测到L4需要更新：

1. **引导反思**
   ```
   本月你做了这些重要决策：
   - [决策1]
   - [决策2]
   - [决策3]

   这些决策体现了什么价值观？
   ```

2. **等待手动更新**
   - 用户手动编辑 L4 文件
   - 用户告诉"已更新"

3. **重新校准**
   - 读取新的L4内容
   - 确认系统已校准
