---
name: mem-query
description: AI个人记忆系统的记忆查询功能。检索各层级记忆文件，综合多层级信息回答用户问题。使用场景：(1) 用户问"我的记忆中关于XXX"时；(2) 用户询问自己的习惯/偏好/价值观时；(3) 需要基于用户历史提供建议时。该skill会自动检索L1-L4各层级，引用来源，给出基于记忆的个性化回答。
---

# 记忆查询

## 快速开始

当用户询问关于自己的历史时：

1. **读取INDEX.md** - 获取记忆地图
2. **确定检索层级** - 根据问题确定相关层级
3. **Grep搜索** - 使用关键词搜索
4. **读取文件** - 读取匹配的文件
5. **综合回答** - 结合多层级信息回答

## 检索协议

### 标准流程

```
用户提问
  ↓
读取 AI_MEMORY/INDEX.md
  ↓
识别问题类型 → 确定相关层级
  ↓
Grep关键词搜索 → AI_MEMORY/
  ↓
读取匹配文件
  ↓
综合多层级信息
  ↓
用L4价值观校准回答
  ↓
生成回复（引用来源）
```

### 检索优先级

1. **L4核心层** - 价值观校准（必须读取）
2. **L3认知层** - 思维框架（如涉及决策）
3. **L2行为层** - 行为模式（如涉及具体做法）
4. **L1情境层** - 近期上下文（如涉及当前项目）

### Grep搜索策略

```bash
# 示例1：用户问工作习惯
Grep "工作习惯|工作流|处理.*任务" AI_MEMORY/L2_行为层/

# 示例2：用户问如何决策
Grep "决策|选择|判断" AI_MEMORY/L3_认知层/

# 示例3：用户问价值观相关
Grep "价值观|重要|原则" AI_MEMORY/L4_核心层/
```

## 回答格式

**标准回答模板**：

```
根据你的{层级}记录（{文件名}）：

{具体内容}

{来源引用}
```

**示例**：

```
根据你的工作习惯记录（L2_行为层/工作习惯.md）：

你处理复杂任务时通常会：
1. 先用思维导图拆解（出现频率：5次）
2. 按优先级排序（决策框架：MECE原则）
3. 分步执行，每步验证

你希望我按这个方式来处理吗？
```

## 常见查询类型

### 查询工作习惯

```
Q: "我通常如何处理复杂任务？"

检索：
- Grep "复杂任务" L2_行为层/
- 读取 L2_行为层/工作习惯.md
- 读取 L3_认知层/决策框架.md
```

### 查询价值观

```
Q: "我最看重什么？"

检索：
- 读取 L4_核心层/核心价值观.md（必须）
- 不需要搜索，直接读取
```

### 查询近期事件

```
Q: "我上周做了什么？"

检索：
- 读取 L1_情境层/{年}-{月}.md
- 提取相关日期范围的记录
```

### 查询偏好

```
Q: "我喜欢用什么工具？"

检索：
- Grep "工具|偏好" L2_行为层/
- 读取 L2_行为层/工具偏好.md
```

## 错误处理

### 找不到相关记忆

```
我在你的记忆中没找到相关记录。

这可能意味着：
1. 这是新情况，还没形成模式
2. 之前没记录

要记录这次对话到L1情境层吗？
```

### 记忆冲突

```
⚠️ 发现记忆冲突：
- L2_行为层/工作习惯.md 记录：你喜欢用思维导图
- L1_情境层/2025-12-15.md 记录：你今天说"不想用思维导图"

可能原因：
1. 偏好发生了变化
2. 情境不同

请帮我确认：哪个记录更准确？
```

## 重要原则

1. **总是引用来源** - 告诉用户信息来自哪个文件
2. **用L4校准** - 所有建议都要符合用户的价值观
3. **诚实无记忆** - 找不到就直说，不要编造
4. **区分层级** - 明确说明这是行为模式还是价值观
