---
name: mem-record
description: AI个人记忆系统的记忆记录功能。自动从对话中提炼关键信息并记录到相应层级。使用场景：(1) 用户说"记录到记忆系统"、"记住这个"、"把这次对话记下来"时；(2) 检测到重要事件、决策、偏好表达时；(3) 用户完成重要任务或做出决策时。该skill会自动判断应该记录到L1情境层、L2行为层、L3认知层，还是建议更新L4核心层。
---

# AI记忆记录

## 快速开始

当用户说"记录到记忆系统"或类似表达时，执行以下流程：

1. **提炼关键信息** - 从当前会话中提取事件、决策、偏好、情绪
2. **确定记录层级** - 根据内容类型判断应该记录到哪一层
3. **检测重复模式** - 检查是否为重复出现的模式（3次+）
4. **更新文件** - 更新相应的记忆文件
5. **建议提炼** - 如果检测到重复模式，建议提炼到更高层级

## 工作流程

### 第一步：提炼关键信息

从当前会话中提取：

- **事件**：发生了什么？何时发生的？
- **决策**：做了什么决定？考虑因素是什么？
- **偏好**：表达了什么喜好或厌恶？
- **情绪**：有什么情绪反应？
- **后续行动**：提到了什么接下来的行动？

### 第二步：确定记录层级

根据内容类型判断层级：

**L1_情境层**（日常记录）：
- 日常事件、对话
- 重要决策、任务完成
- 情绪表达

**L2_行为层**（习惯与偏好）：
- 出现3次+的偏好表达
- 习惯性行为模式
- 工具使用偏好

**L3_认知层**（思维模式）：
- 多个行为指向同一原则
- 决策框架
- 思考模型

**L4_核心层**（⚠️ 只能手动修改）：
- 价值观表达
- 人生信念
- 身份认同

详细的判断规则见 [protocol.md](references/protocol.md)

### 第三步：检测重复模式

使用Grep搜索关键词：

```bash
Grep "关键词" AI_MEMORY/L1_情境层/
```

统计出现次数，如果 >= 3次，建议提炼到L2行为层。

示例：
```
用户说："我喜欢用图表而不是大段文字"

执行：Grep "图表" AI_MEMORY/L1_情境层/
结果：发现这是第3次出现
操作：建议记录到 L2_行为层/工作习惯.md
```

### 第四步：更新文件

#### 更新L1_情境层

1. 读取当前月份文件（如 `AI_MEMORY/L1_情境层/2025-12.md`）
2. 在"按日期记录"部分添加新条目

格式：
```markdown
### {日期}（周X）

#### {事件类型}
- **内容**：{提取的内容}
- **情绪**：{情绪（如有）}
- **后续行动**：{行动（如有）}
- **标签**：`#{标签1} #{标签2}`
```

#### 更新L2行为层

如果检测到重复模式（3次+），更新相应的L2文件：

1. 检查是否存在相关文件（如 `L2_行为层/工作习惯.md`）
2. 如果不存在，创建新文件
3. 添加或更新该行为模式

### 第五步：建议提炼

向用户展示：

```
✅ 已记录到 L1_情境层/2025-12.md

💡 检测到这是第{N}次出现"{偏好/行为}"，
   是否记录到 L2_行为层/{相关文件}.md？
```

如果涉及L4核心层（价值观）：

```
⚠️ 这次对话涉及核心价值观，
   建议手动更新 L4_核心层/核心价值观.md

   要不要我生成建议内容供你审核？
```

## L4核心层保护原则

**L4_核心层只能由用户手动修改**

Claude可以：
- ✅ 建议更新
- ✅ 生成建议内容
- ✅ 展示当前内容

Claude绝对不能：
- ❌ 直接写入L4文件
- ❌ 自动推断价值观

## 文件结构

完整的文件结构见 [structure.md](references/structure.md)

重要路径：
- L1情境层：`AI_MEMORY/L1_情境层/{年}-{月}.md`
- L2行为层：`AI_MEMORY/L2_行为层/`
- L3认知层：`AI_MEMORY/L3_认知层/`
- L4核心层：`AI_MEMORY/L4_核心层/`（⚠️ 只读）

## 辅助脚本

使用 `scripts/update_memory.py` 可以：
- 获取当前月份文件路径
- 格式化L1条目
- 生成模式检查提示

## 示例

### 示例1：记录决策

```
用户："今天我决定采用Claude Code方案来搭建AI记忆系统，
     因为它不需要向量数据库，基于现有工具"

执行：
1. 提炼：决策（采用Claude Code）、考虑因素（无需向量DB）、情绪（未表达）
2. 判断：这是重要决策，记录到L1
3. 检查：首次提到此决策
4. 更新：L1_情境层/2025-12.md
5. 输出：✅ 已记录到L1情境层
```

### 示例2：记录偏好（检测到重复模式）

```
用户："我更喜欢用图表而不是大段文字来解释概念"

执行：
1. 提炼：偏好（图表 > 文字）
2. 判断：偏好表达
3. 检查：Grep "图表" L1_情境层/
4. 结果：发现这是第3次出现
5. 输出：✅ 已记录到L1
         💡 这是第3次提到"图表偏好"，是否记录到L2？
```

### 示例3：涉及价值观

```
用户："对我来说，成长比赚钱更重要"

执行：
1. 提炼：价值观（成长优先）
2. 判断：涉及L4核心层
3. 输出：⚠️ 这涉及核心价值观
         建议手动更新 L4_核心层/核心价值观.md
         要不要我生成建议内容？
```

## 常见问题

**Q：如何判断应该记录到哪一层？**

A：参考 [protocol.md](references/protocol.md) 的判断规则。

**Q：如何检测重复模式？**

A：使用Grep搜索关键词，统计出现次数。

**Q：L4核心层可以自动更新吗？**

A：不可以。L4核心层只能由用户手动修改，Claude只能建议。
