# 记忆记录协议

## 记录判断规则

### 需要记录到L1（情境层）的情况
- ✅ 用户完成重要任务
- ✅ 用户做出决策
- ✅ 用户表达情绪/感受
- ✅ 用户提及今日/近期事件

### 需要检查L2（行为层）的情况
- ✅ 用户表达偏好（第3次出现）
- ✅ 用户描述习惯性行为
- ✅ 用户选择某种工具/方法

### 需要建议L3（认知层）的情况
- ✅ 多个L2习惯指向同一思维模式
- ✅ 用户解释"为什么"这样做
- ✅ 用户总结方法论

### 需要建议L4（核心层）的情况 ⚠️
- ✅ 用户表达深层价值观
- ✅ 用户讨论人生意义/目标
- ✅ 用户反思"我是谁"

## 文件格式

### L1_情境层格式

```markdown
### {日期}（周X）

#### {事件类型}
- **内容**：{提取的内容}
- **情绪**：{识别的情绪（如有）}
- **后续行动**：{如有}
- **标签**：`#{标签1} #{标签2}`
```

### L2_行为层格式

```markdown
## 📋 {行为名称}

### 习惯描述
{具体描述}

### 统计信息
- 首次记录：{日期}
- 出现次数：{次数}
- 稳定性：{高/中/低}
- 最后确认：{日期}
```

## 检测重复模式

使用Grep搜索关键词：
```bash
Grep "{关键词}" AI_MEMORY/L1_情境层/
```

统计出现次数，如果 >= 3次，建议记录到L2。
