# AI记忆系统文件结构

## 目录结构

```
AI_MEMORY/
├── INDEX.md                    # 主索引
├── PROMPTS.md                  # Claude使用协议
├── L0_状态层/                  # 当前会话临时数据
├── L1_情境层/                  # 日常事件记录
│   └── 2025-12.md             # 本月情境记录
├── L2_行为层/                  # 习惯与偏好
│   ├── 工作习惯.md
│   ├── 沟通风格.md
│   └── 工具偏好.md
├── L3_认知层/                  # 思维模式
│   ├── 决策框架.md
│   └── 思考模型.md
├── L4_核心层/                  # ⭐ 价值观（只能手动修改）
│   ├── 核心价值观.md
│   ├── 人生信念.md
│   └── 身份定义.md
├── Intent/                     # 主动输入
│   ├── 目标与规划.md
│   ├── 偏好与要求.md
│   └── 约束与边界.md
└── Meta/                       # 系统元数据
    ├── 洞察队列.md
    ├── 框架演变.md
    └── 复盘记录.md
```

## 各层级说明

### L0_状态层
- **用途**：当前会话临时数据
- **生命周期**：会话结束即清理
- **更新方式**：自动

### L1_情境层
- **用途**：日常事件、对话记录
- **生命周期**：永久保存
- **更新方式**：用户触发或自动检测
- **文件命名**：{年}-{月}.md

### L2_行为层
- **用途**：习惯、偏好、工作流
- **生命周期**：永久保存
- **更新方式**：从L1提炼（出现3次+）
- **文件命名**：按行为类别

### L3_认知层
- **用途**：思维模式、决策框架
- **生命周期**：永久保存
- **更新方式**：从L2提炼（月度复盘）
- **文件命名**：按认知类别

### L4_核心层
- **用途**：价值观、人生信念、身份
- **生命周期**：永久保存
- **更新方式**：只能手动修改 ⚠️
- **文件命名**：固定3个文件

## 重要规则

1. **L4核心层保护**：只能由用户手动修改
2. **来源追溯**：每个记忆必须标注来源
3. **定期回顾**：
   - L1→L2：每周
   - L2→L3：每月
   - L3→L4：每季度
