---
name: mem-weekly
description: AI个人记忆系统的周复盘功能。分析本周L1情境层记录，识别重复模式，提炼到L2行为层。使用场景：(1) 用户说"周复盘"时；(2) 每周定期回顾时；(3) 需要从日常记录中提炼行为模式时。该skill会自动统计重复出现的行为（3次+），生成候选列表，等待用户确认后更新L2行为层。
---

# 周复盘

## 快速开始

当用户说"周复盘"时，执行以下流程：

**重要：在执行周复盘前，必须先调用 `mem-file-scan` skill 来扫描本周修改的文件，补充L1记录。**

1. **文件扫描（前置步骤）** - 调用mem-file-scan扫描本周修改的文件，补充L1记录
2. **读取本周L1记录** - 获取本周所有情境记录
3. **识别重复模式** - 统计出现3次以上的行为/偏好
4. **生成候选列表** - 创建待提炼的候选清单
5. **等待用户确认** - 展示给用户选择
6. **更新L2文件** - 根据确认更新行为层

## 工作流程

### 前置步骤：文件扫描补充L1

**在开始周复盘分析之前，必须先调用 `mem-file-scan` skill**：

```bash
调用 mem-file-scan skill
```

**为什么需要这一步**：
- AI记忆系统只能记录Claude对话内容
- 用户在Obsidian中直接编辑的文件不会被自动记录
- 文件扫描可以识别本周修改的文件，提取重要事件和决策
- 补充L1记录后，周复盘才能分析出更全面的行为模式

**执行方式**：
1. 先调用 `mem-file-scan`
2. 等待文件扫描完成并补充L1记录
3. 再继续执行后续的周复盘分析流程

### 第一步：读取本周L1记录

读取当前月份的L1文件：`AI_MEMORY/L1_情境层/{年}-{月}.md`

提取本周的记录：
- 确定本周的日期范围（如：12-22 至 12-28）
- 提取本周的所有条目

### 第二步：识别重复模式

使用Grep搜索关键词，统计出现次数：

```bash
Grep "关键词" AI_MEMORY/L1_情境层/
```

**重复模式判断标准**：
- 相同偏好/行为出现 **3次以上**
- 相同工具选择出现 **3次以上**
- 相同表达方式出现 **3次以上**

### 第三步：生成候选列表

创建待提炼的候选清单（最多5个）：

格式：
```
📊 本周记忆复盘（{月份}第{X}周）

━━━━━━━━━━━━━━━━━━━━━━━━
🔍 发现 {N} 个重复模式：

1️⃣ "{模式名称}"
   - 出现次数：{X}次
   - 来源：[日期1] [日期2] [日期3]
   - 建议：记录到 L2_行为层/{文件}.md
   - 你的选择：[ ] 记录  [ ] 忽略  [ ] 修改后记录

2️⃣ "{模式名称}"
   ...
```

### 第四步：等待用户确认

展示候选列表，等待用户选择。

用户可以：
- **记录** - 直接记录到L2
- **忽略** - 跳过此模式
- **修改后记录** - 修改内容后再记录

### 第五步：更新L2文件

根据用户确认，更新相应的L2文件：

1. **检查文件是否存在**
   - 存在：追加或更新
   - 不存在：创建新文件

2. **更新格式**

```markdown
## 📋 {行为/偏好名称}

### 习惯描述
{具体描述}

### 统计信息
- 首次记录：{日期}
- 出现次数：{次数}
- 稳定性：{高/中/低}
- 最后确认：{日期}

### 来源
- {来源1}
- {来源2}
- {来源3}
```

3. **更新统计**
   - 更新 INDEX.md 统计信息
   - 更新本周复盘记录

## 输出示例

```
📊 本周记忆复盘（12月第4周）

━━━━━━━━━━━━━━━━━━━━━━━━
🔍 发现 3 个重复模式：

1️⃣ "处理复杂任务前先用思维导图"
   - 出现次数：4次
   - 来源：[12-22] [12-24] [12-26] [12-27]
   - 建议：记录到 L2_行为层/工作习惯.md
   - 你的选择：[ ] 记录  [ ] 忽略  [ ] 修改后记录

2️⃣ "早上9-12点深度工作，不回消息"
   - 出现次数：5次
   - 来源：[Daily] 5次记录
   - 建议：记录到 L2_行为层/工作习惯.md
   - 你的选择：[ ] 记录  [ ] 忽略  [ ] 修改后记录

3️⃣ "重要决策会睡眠一晚后再决定"
   - 出现次数：3次
   - 建议：记录到 L2_行为层/决策习惯.md
   - 你的选择：[ ] 记录  [ ] 忽略  [ ] 修改后记录

━━━━━━━━━━━━━━━━━━━━━━━━
等待你的确认...
```

## 完成后操作

复盘完成后，更新 `AI_MEMORY/Meta/复盘记录.md`：

```markdown
### {年} {月}第{X}周

**复盘日期**：{日期}

**本周关键事件**：
1. {事件1}
2. {事件2}
3. {事件3}

**识别出的行为模式**：
- [模式1] - 出现次数：X次
- [模式2] - 出现次数：X次

**更新到L2**：
- ✅ [文件1]
- ✅ [文件2]

**下周关注**：
1.
2.
3.
```

## 常见问题

**Q：如果本周没有重复模式怎么办？**

A：输出"本周未发现明显的重复模式，继续观察即可"。

**Q：如何确定本周的日期范围？**

A：使用当前日期，往前推7天。如今天是12-27（周五），本周是12-21至12-27。

**Q：用户选择的"修改后记录"怎么处理？**

A：询问用户如何修改，然后按用户要求更新后再记录到L2。
