---
name: start-work
description: 每日工作启动助手。读取Obsidian收件箱、计划文件，提醒今日待办，询问内容创作计划，展示周计划进度，调用热点采集。触发词："开始工作"、"开启新一天"、"今天做什么"。帮助用户快速进入高效工作状态。
---

# Start Work - 开始工作

## 触发方式

| 用户说 | 执行动作 |
|--------|----------|
| "开始工作" / "开启新一天" | 完整工作启动流程 |
| "今天做什么" | 快速版：只显示待办和计划 |
| "看看我的进度" | 仅显示周计划进度 |

---

## 完整工作启动流程

### 第一步：开场问候

输出今日信息：

```
☀️ 开始工作！今天是 YYYY年M月D日，星期X

---
```

---

### 第二步：读取上下文

并行读取以下文件（使用 Read 工具）：

| 文件 | 路径 | 目的 |
|------|------|------|
| 收件箱 | `/Users/ugreen/Documents/obsidian/00 收件箱/` | 检查待处理项 |
| 年度计划 | `/Users/ugreen/Documents/obsidian/06 计划/2026年计划.md` | 获取周计划 |
| 周写作计划 | `/Users/ugreen/Documents/obsidian/06 计划/2026年第4周写作计划.md` | 获取本周文章列表 |
| 选题库 | `/Users/ugreen/Documents/obsidian/选题库/待写选题.md` | 获取待写选题 |
| L1情境层 | `/Users/ugreen/Documents/obsidian/AI_MEMORY/L1_情境层/` | 查看近期记录 |
| 核心价值观 | `/Users/ugreen/Documents/obsidian/AI_MEMORY/L4_核心层/核心价值观.md` | 激励语素材 |

---

### 第三步：今日待办提醒

分析读取的内容，提取并输出：

```markdown
## 📋 今日待办

### 🔴 紧急/截止日期临近
- [从计划文件中提取]

### 🟡 本周进行中
- [从周计划中提取状态为"写作中"的任务]

### 🟢 待启动
- [从待写选题/计划中提取]

---

**从哪里开始？**
> 建议：[基于优先级给出一句话建议，说明从哪个任务开始、怎么做]
```

---

### 第四步：内容创作确认

使用 AskQuestion 工具询问：

```
今日内容计划确认
---

1. 即刻动态：今天打算发什么？
   - [ ] 产品体验分享
   - [ ] 技术观点
   - [ ] 生活碎片
   - [ ] 转发+评论
   - [ ] 暂不发布

2. 公众号文章：今天写哪篇？
   - [ ] 继续写作中的文章
   - [ ] 开始新选题
   - [ ] 暂不写文章

3. 小红书笔记：今天发什么？
   - [ ] 图文笔记
   - [ ] 视频笔记
   - [ ] 暂不发布
```

根据用户选择，提供具体建议：
- 如果选择"继续写作中"，提示当前进度
- 如果选择"开始新选题"，列出待写选题供选择
- 如果选择"暂不发布"，不做追问

---

### 第五步：周计划进度激励

输出格式：

```markdown
## 📊 本周进度

### 文章计划（目标：5篇/周）
| 状态 | 数量 | 标题 |
|------|------|------|
| ✅ 已完成 | N | ... |
| ✍️ 写作中 | N | ... |
| ⏳ 待写 | N | ... |

**进度**：[===========------] N/5

### 更新频率追踪
| 类型 | 本周目标 | 已完成 | 进度 |
|------|----------|--------|------|
| 文章 | 5 | N | N/5 |
| 视频 | 4 | N | N/4 |
| 动态 | 7 | N | N/7 |

---

💪 **激励语**
> [基于核心价值观生成一句激励语]
> 
> 距离年度目标还有 XX 天，保持节奏！
```

---

### 第六步：今日热点（可选）

询问用户：

```
是否需要查看今日AI热点？
- [ ] 是，帮我采集
- [ ] 不用了，直接开始工作
```

如果用户选择"是"：
- 调用 topic-agent Skill（触发词："今日AI热点"）
- 或直接执行 topic-collector 的采集流程

---

## 快速版流程

当用户说"今天做什么"时，只执行：
1. 开场问候（简短版）
2. 今日待办提醒
3. 内容创作确认

跳过周计划进度和热点采集。

---

## 输出示例

```markdown
☀️ 开始工作！今天是 2026年1月28日，星期三

---

## 📋 今日待办

### 🔴 紧急
- 「企业如何使用 Skill」待审阅发布

### 🟡 本周进行中
- minimax 商单文章（待发布）

### 🟢 待启动
- 在哪里寻找你的上下文
- 创业的 20 个洞察

**从哪里开始？**
> 建议：先完成「企业如何使用 Skill」的审阅，预计30分钟可发布。然后开始写「在哪里寻找你的上下文」，参考已有草稿。

---

## 📊 本周进度

**文章**：[=====-----------] 1/5 完成
**视频**：[----------------] 0/4 完成

💪 距离公众号5万粉丝目标还有 337 天，每一篇文章都是积累！

---

🔥 需要查看今日AI热点吗？
```

---

## 注意事项

- **周计划路径动态化**：根据当前日期自动定位到正确的周计划文件
- **不要过度提问**：如果收件箱为空，跳过相关提醒
- **保持简洁**：整个流程输出控制在一屏内，避免信息过载
- **激励语个性化**：基于 L4 核心价值观生成，不要用通用鸡汤

---

## 依赖的 Skill

| Skill | 触发时机 |
|-------|----------|
| topic-agent | 用户选择查看热点时调用 |
| mem-query | 查询记忆系统（可选） |

---

## 路径配置

```
基础路径: /Users/ugreen/Documents/obsidian/
├── 00 收件箱/           # 待处理项
├── 06 计划/             # 年度/周计划
│   ├── 2026年计划.md
│   └── 2026年第N周写作计划.md
├── 选题库/
│   ├── 待写选题.md
│   └── 每日选题/
└── AI_MEMORY/
    ├── L1_情境层/       # 近期记录
    └── L4_核心层/       # 核心价值观
```
