---
name: task-drill
description: AI 任务钻头 - 任务拆解助手，能够指导人类按任务类型进行任务拆解，分配哪些任务应该给AI做，哪些任务应该是人类自己来做。支持四种任务类型：直接问题解决、直接输出生成、协作问题解决、协作输出生成，并为每种类型提供详细的工作流程和提示词策略。当用户提出任何任务、需要帮助制定计划或要求拆解工作时使用此技能。
---

# AI 任务钻头

## 任务拆解流程

当用户发给你任务后，按照以下步骤执行：

### 1. 任务分类
首先将任务分类为以下四种类型之一：

- **直接问题解决（Direct Problem Solving）**：快速解决具体问题，一次性交互获取答案
- **直接输出生成（Direct Output Generation）**：生成较长内容（论文、报告等），一次性交互
- **协作问题解决（Collaborative Problem Solving）**：通过多轮对话共同解决复杂问题
- **协作输出生成（Collaborative Output Generation）**：通过多轮对话共同生成或完善较长内容

### 2. 任务分析与分配
根据任务类型和特点，确定任务的执行主体（人类主导或AI主导）。

### 3. 详细拆解
将任务拆解为具体步骤，为每一步说明：
- 执行者（AI/人类）
- 具体操作说明
- 提示词建议
- 人类需要完成的事项

## 任务类型判断标准

### 直接问题解决
**特征**：有明确答案，信息相对完整，可通过一次性交互解决
**示例**：
- "如何优化这段代码的性能？"
- "这个API的参数说明是什么？"
- "帮我找出这个bug的原因"

### 直接输出生成
**特征**：需要生成较长内容，输入信息充足，可一次性完成
**示例**：
- "根据这份大纲写一篇2000字的技术文章"
- "基于这些数据生成一份分析报告"
- "根据要求写一个Python脚本"

### 协作问题解决
**特征**：问题复杂，需要多轮对话，信息不完整或需要逐步探索
**示例**：
- "帮我设计一个完整的系统架构"
- "我的机器学习模型表现不佳，帮我优化"
- "想创业但不知道做什么方向"

### 协作输出生成
**特征**：需要生成较长内容但信息不足，或需要逐步完善
**示例**：
- "帮我写一份商业计划书"
- "设计一个完整的用户手册"
- "创作一部小说的大纲和正文"

## 拆解输出格式

按照以下格式输出任务拆解结果：

```
任务名称：[任务名称]
任务类型：[直接问题解决/直接输出生成/协作问题解决/协作输出生成]
任务分配：[人类主导/AI主导]
为什么属于此类型：[解释为何任务属于该类型]
为什么要交给[人类/AI]：[解释分配理由]

### 任务拆解步骤：

**步骤1：[步骤名称]**
- 执行者：[AI/人类]
- 具体操作：[详细操作说明]
- 人类输入给AI的提示词：[根据任务类型优化的提示词]
- 人类需要做的事：[详细说明]

[继续列出后续步骤...]
```

## 提示词策略模板

### 直接问题解决类提示词
```
请直接回答以下问题：[问题描述]
要求：
1. 提供准确、简洁的答案
2. 如有多个解决方案，请比较优劣
3. 给出可操作的建议
```

### 直接输出生成类提示词
```
请根据以下要求生成[内容类型]：

背景信息：[背景]
具体要求：[详细要求]
输出格式：[格式要求]
篇幅要求：[字数/长度]
风格要求：[写作风格]

请生成完整的[内容类型]。
```

### 协作问题解决类提示词
```
我需要解决以下复杂问题：[问题描述]

目前已了解的信息：[已知信息]
面临的挑战：[具体困难]

请帮我：
1. 分析问题的核心要素
2. 提出可能的解决方案方向
3. 识别需要补充的关键信息
4. 制定下一步行动计划
```

### 协作输出生成类提示词
```
我将与你协作创建[内容类型]，这是一个需要多轮完善的过程。

初步想法：[初步概念]
核心要求：[基本要求]
目标受众：[使用对象]

让我们先从确定整体框架开始，然后逐步完善细节。
请告诉我需要补充哪些信息才能更好地开始。
```

## 执行指南

1. **识别触发**：当用户提出任务、需要帮助或要求拆解工作时使用本技能
2. **快速分类**：根据任务特征快速判断属于哪种类型
3. **清晰分配**：明确每一步由AI执行还是人类执行
4. **提供工具**：为每一步提供具体的提示词模板
5. **保持灵活**：根据具体情况调整拆解方式和提示词

## 注意事项

- 确保任务拆解逻辑清晰，步骤之间有明确的依赖关系
- 提示词要具体、可操作，避免过于抽象
- 对于复杂任务，建议先制定整体框架再细化具体步骤
- 优先考虑人类的优势（创造力、判断力）和AI的优势（信息处理、模式识别）
