---
name: topic-agent
description: 选题系统主控Agent。协调热点采集、选题生成、选题审核三个环节，支持迭代直到产出合格选题。触发方式：(1)"开始今日选题"启动完整流程 (2)"今日AI热点"只采集热点不生成选题 (3)"我有一个选题"进入单个选题分析 (4)"推荐一些好的选题"直接输出推荐。输出保存到Obsidian选题库。
---

# Topic Agent - 选题系统主控

## 触发方式

| 用户说 | 执行动作 |
|--------|----------|
| "开始今日选题" | 完整流程：采集→生成→审核→保存 |
| "今日AI热点" / "看看今天有什么热点" | 仅采集：列出今日热点，不生成选题 |
| "我有一个选题" | 单个分析：用户输入→生成→审核 |
| "推荐一些好的选题" | 快速推荐：基于近期热点推荐3-5个 |

---

## 模式一：今日AI热点（仅采集）

当用户说"今日AI热点"时，执行以下流程：

### 采集步骤

使用WebSearch并行搜索以下内容：

```
# 1. AI博主实践分享
"Claude Code" OR "Cursor" tips tricks workflow 2026

# 2. 创业公司/新产品
Product Hunt AI tools launch 2026

# 3. 模型厂商动态
Anthropic Claude OR OpenAI ChatGPT update January 2026

# 4. AI Agent工作流
AI agent automation n8n workflow 2026

# 5. 社区讨论
Reddit ClaudeAI OR LocalLLaMA hot January 2026

# 6. 研究动态
AI research DeepMind OR Meta AI January 2026
```

### 输出格式

```markdown
## 今日AI热点 - MMDD

---

### 🧑‍💻 AI博主实践分享

1. **[内容摘要]**
   - 作者：@用户名 / 博主名
   - 原文：[文章标题](https://具体URL)
   - 要点：一句话总结

---

### 🚀 创业公司/新产品

1. **[产品名]** - 一句话描述
   - 原文：[Product Hunt](https://producthunt.com/posts/xxx)
   - 热度：⬆️ N upvotes

---

### 🏢 模型厂商动态

1. **[更新内容]**
   - 厂商：Anthropic / OpenAI / Google
   - 原文：[官方博客](https://具体URL)
   - 要点：关键变化

---

### 🔬 AI研究/学术

1. **[论文/博客标题]**
   - 来源：DeepMind / Meta AI / arXiv
   - 原文：[链接](https://具体URL)
   - 要点：核心发现

---

### 💬 社区热议

1. **[讨论标题]**
   - 来源：r/ClaudeAI / Hacker News
   - 原文：[帖子链接](https://具体URL)
   - 热度：⬆️ upvotes | 💬 comments
```

### 关键要求

- **每条热点必须有原文链接**：不是主域名，而是具体文章/帖子URL
- 按5个分类整理：博主分享、新产品、厂商动态、研究、社区
- 优先有实操价值的内容

---

## 模式二：完整选题流程

当用户说"开始今日选题"时：

```
┌─────────────────────────────────────────────┐
│  1. 采集热点（同模式一）                      │
│     输出今日AI热点列表                        │
└─────────────────┬───────────────────────────┘
                  ▼
┌─────────────────────────────────────────────┐
│  2. 筛选TOP10生成选题方案                     │
│     事件描述 + 核心角度 + 标题 + 写作方式      │
└─────────────────┬───────────────────────────┘
                  ▼
┌─────────────────────────────────────────────┐
│  3. 审核评分                                  │
│     热度 + 独特角度 + 国内关注度 → 总分        │
└─────────────────┬───────────────────────────┘
                  ▼
┌─────────────────────────────────────────────┐
│  4. 输出结果                                  │
│     ✅通过：保存到选题库                      │
│     ⚠️待优化：给出修改建议                   │
│     ❌不通过：说明原因                        │
└─────────────────────────────────────────────┘
```

---

## 模式三：单个选题分析

当用户说"我有一个选题"时：

1. 询问选题内容
2. 搜索相关热点验证热度
3. 生成完整选题方案
4. 审核评分
5. 给出优化建议

---

## 输出位置

```
/Users/ugreen/Documents/obsidian/选题库/每日选题/MMDD-选题名称.md
```

文件命名示例：`0114-Claude-Code进阶技巧.md`

---

## 选题输出模板

```markdown
# [选题标题]

**日期**：YYYY-MM-DD
**状态**：待写 / 写作中 / 已发布
**审核分数**：XX/100

## 事件描述
[一段话说清楚发生了什么]

## 核心角度
[为什么值得写，差异化在哪]

## 标题备选
1.
2.
3.

## 写作方式
[干货教程 / 产品体验 / 观点分享 / 新技术突破]

## 大纲
1.
2.
3.

## 素材链接
- [来源1标题](https://具体URL)
- [来源2标题](https://具体URL)
- [来源3标题](https://具体URL)

## 备注
[其他想法]
```

---

## 快捷指令

| 指令 | 说明 |
|------|------|
| "继续" | 继续上次中断的流程 |
| "跳过" | 跳过当前选题，看下一个 |
| "保存" | 直接保存当前选题到库 |
| "放弃" | 放弃当前选题 |
| "改角度" | 保持热点，换个角度重新生成 |
| "展开写" | 基于选题开始写作 |

---

## 审核标准

| 维度 | 权重 | 评分标准 |
|------|------|----------|
| 热度 | 30% | 社交媒体讨论量、搜索趋势 |
| 独特角度 | 40% | 是否有差异化视角，不是简单搬运 |
| 国内关注 | 30% | 国内用户是否关心这个话题 |

**通过标准**：
- ✅ 80分以上：通过，保存到选题库
- ⚠️ 60-79分：待优化，给出修改建议
- ❌ 60分以下：不通过，说明原因

---

## 每日目标

- 采集：50+条热点（5个分类）
- 生成：10个选题方案
- 通过：3-5个合格选题
- 保存：全部通过的选题存入选题库
