---
name: topic-generator
description: AI选题生成工具。从采集的热点中筛选TOP10，生成完整选题方案。当用户说"生成选题"、"筛选热点"、"哪些值得写"时触发。输出包含：事件描述、核心角度、标题、写作方式。
---

# Topic Generator - 选题生成

## 生成流程

1. **接收热点列表**（来自topic-collector）
2. **评估筛选**：按选题价值打分
3. **输出TOP10**：完整选题方案

## 筛选标准

### 必须满足
- AI相关（Vibe Coding / Claude / AI工具 / AI模型）
- 有明确的用户价值（能学到/能用到/能思考）
- 国内用户能理解和关注

### 加分项
| 维度 | 高分 | 低分 |
|------|------|------|
| 热度 | 讨论量大、增长快 | 冷门、无人问津 |
| 时效 | 24小时内 | 超过3天 |
| 独特性 | 有新角度可挖 | 已被写烂 |
| 可操作 | 能给出具体方法 | 纯概念讨论 |

## 写作方式分类

根据内容特点选择：

1. **干货教程** - 有具体步骤可复现
2. **产品体验** - 新产品/新功能测评
3. **观点分享** - 趋势分析/行业洞察
4. **新技术突破** - 重大更新/技术解读

## 输出格式

每个选题输出：

```markdown
### 选题 N：[标题]

**事件描述**
一句话说清楚发生了什么

**核心角度**
为什么值得写？独特切入点是什么？

**推荐标题**（3个备选）
1. 标题A
2. 标题B
3. 标题C

**写作方式**：干货教程 / 产品体验 / 观点分享 / 新技术突破

**预估热度**：⭐⭐⭐⭐⭐（1-5星）

**不写的风险**：错过什么？（可选）
```

## 选题公式参考

### 工具测评型
- 用了X天[工具]，我发现[意外收获]
- [工具]的隐藏功能，90%的人不知道

### 方法论型
- 我用[方法]搞定了[问题]的完整流程
- [数字]个让[场景]效率翻倍的技巧

### 热点结合型
- [热点]爆火，但大家忽略了这一点
- 从[热点]看AI编程的未来

### 反共识型
- 别再[常见做法]了
- 为什么我不推荐[热门事物]

### 经验复盘型
- 做了[数字]个[事情]后，我总结的[数字]条教训
- 如果重来一次，我会[改变]

## 质量检查

生成后自检：
- [ ] 标题有冲突感？（数字、对比、反差、疑问）
- [ ] 读者有痛点？
- [ ] 我有独特视角？
- [ ] 有具体案例？
- [ ] 能引发讨论？

5条全中 = 必写 | 3-4条 = 可写 | <3条 = 再想想
