---
name: topic-reviewer
description: 选题审核工具。检查选题是否符合发布标准，给出通过/不通过判断及修改建议。当用户说"审核选题"、"这个选题行不行"、"帮我看看这个能不能写"时触发。
---

# Topic Reviewer - 选题审核

## 审核流程

1. **接收选题**（来自topic-generator或用户输入）
2. **逐项检查**：按审核清单打分
3. **输出结论**：通过/不通过 + 理由

## 审核清单

### 必过项（一票否决）

| 检查项 | 不通过标准 |
|--------|------------|
| 热度 | 讨论量<100或无增长趋势 |
| 相关性 | 与AI/编程/效率无关 |
| 时效性 | 超过72小时的旧闻 |
| 可写性 | 没有可操作的内容输出 |

### 评分项（满分100）

| 维度 | 权重 | 评分标准 |
|------|------|----------|
| 独特角度 | 30% | 有无别人没写过的切入点 |
| 用户价值 | 25% | 读者能获得什么 |
| 国内适配 | 20% | 国内用户是否关注 |
| 标题吸引力 | 15% | 是否想点进去看 |
| 写作难度 | 10% | 能否快速高质量完成 |

**通过线：70分**

## 不通过的常见原因

1. **热度不够高**
   - 表现：源头讨论量低，无传播趋势
   - 建议：等热度起来再写，或换热点

2. **没有独特角度**
   - 表现：已有大量类似文章
   - 建议：找差异化切入点，或放弃

3. **不符合国内用户关注**
   - 表现：纯海外事件，无本土关联
   - 建议：找国内用户共鸣点，或翻译+本土化

4. **纯蹭热点无干货**
   - 表现：只是转述新闻，无增量信息
   - 建议：加入实操/测评/深度分析

5. **写作成本过高**
   - 表现：需要大量调研或技术门槛高
   - 建议：简化范围或分拆系列

## 输出格式

```markdown
## 选题审核结果

**选题**：[标题]

**结论**：✅ 通过 / ❌ 不通过

**评分**：XX/100

| 维度 | 得分 | 说明 |
|------|------|------|
| 独特角度 | /30 | |
| 用户价值 | /25 | |
| 国内适配 | /20 | |
| 标题吸引力 | /15 | |
| 写作难度 | /10 | |

**审核意见**
- 优点：...
- 问题：...
- 建议：...

**修改方向**（如不通过）
1. ...
2. ...
```

## 快速判断

没时间细评时，问自己：
1. 今天不写会后悔吗？
2. 写完能获得什么反馈？
3. 一句话能说清为什么值得写吗？

3个都是"是" = 直接写
